/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.xs2a.adapter.adapter;

import de.adorsys.xs2a.adapter.http.UriBuilder;
import de.adorsys.xs2a.adapter.service.Oauth2Service;
import de.adorsys.xs2a.adapter.service.PkceOauth2Extension;
import de.adorsys.xs2a.adapter.service.model.TokenResponse;
import java.io.IOException;
import java.net.URI;
import java.util.Map;

public class PkceOauth2Service
implements Oauth2Service,
PkceOauth2Extension {
    private final Oauth2Service oauth2Service;

    public PkceOauth2Service(Oauth2Service oauth2Service) {
        this.oauth2Service = oauth2Service;
    }

    public URI getAuthorizationRequestUri(Map<String, String> headers, Oauth2Service.Parameters parameters) throws IOException {
        return UriBuilder.fromUri(this.oauth2Service.getAuthorizationRequestUri(headers, parameters)).queryParam("code_challenge_method", "S256").queryParam("code_challenge", this.codeChallenge()).build();
    }

    public TokenResponse getToken(Map<String, String> headers, Oauth2Service.Parameters parameters) throws IOException {
        if (Oauth2Service.GrantType.AUTHORIZATION_CODE.toString().equals(parameters.getGrantType())) {
            parameters.setCodeVerifier(this.codeVerifier());
        }
        return this.oauth2Service.getToken(headers, parameters);
    }
}

