/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.xs2a.adapter.adapter.link.bg;

import de.adorsys.xs2a.adapter.adapter.link.bg.template.LinksTemplate;
import de.adorsys.xs2a.adapter.http.StringUri;
import de.adorsys.xs2a.adapter.service.link.LinksRewriter;
import de.adorsys.xs2a.adapter.service.model.Link;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BerlinGroupLinksRewriter
implements LinksRewriter {
    private static final Logger logger = LoggerFactory.getLogger(BerlinGroupLinksRewriter.class);
    private static final Set<String> UNCHANGEABLE_LINKS = new HashSet<String>(Arrays.asList("scaRedirect", "scaOAuth"));
    private static final String START_OF_PLACEHOLDER = "{";
    private static final String END_OF_PLACEHOLDER = "}";
    private static final Pattern CONSENT_ID_PATTERN = Pattern.compile("/consents/([^/]+)");
    private static final Pattern AUTHORISATION_ID_PATTERN = Pattern.compile("/authorisations/([^/]+)");
    private static final Pattern ACCOUNT_ID_PATTERN = Pattern.compile("/accounts/([^/]+)");
    private static final Pattern TRANSACTION_ID_PATTERN = Pattern.compile("/transactions/([^/]+)");
    private final LinksTemplate linksTemplate;
    private final String host;
    private final String version;
    private final Map<String, Function<String, Optional<String>>> placeholdersToParamRetrievers;

    public BerlinGroupLinksRewriter(LinksTemplate linksTemplate, String host, String version) {
        this.linksTemplate = linksTemplate;
        this.host = host;
        this.version = version;
        this.placeholdersToParamRetrievers = new HashMap<String, Function<String, Optional<String>>>();
        this.registerPlaceholder("{host}", this::retrieveHost);
        this.registerPlaceholder("{version}", this::retrieveVersion);
        this.registerPlaceholder("{consentId}", this::retrieveConsentId);
        this.registerPlaceholder("{authorisationId}", this::retrieveAuthorisationId);
        this.registerPlaceholder("{accountId}", this::retrieveAccountId);
        this.registerPlaceholder("{transactionId}", this::retrieveTransactionId);
        this.registerPlaceholder("{paymentService}", this::retrievePaymentService);
        this.registerPlaceholder("{paymentProduct}", this::retrievePaymentProduct);
        this.registerPlaceholder("{paymentId}", this::retrievePaymentId);
    }

    public void registerPlaceholder(String placeholder, Function<String, Optional<String>> paramRetriever) {
        this.placeholdersToParamRetrievers.put(placeholder, paramRetriever);
    }

    public Map<String, Link> rewrite(Map<String, Link> links) {
        if (links == null || links.isEmpty()) {
            return links;
        }
        HashMap<String, Link> rewrittenLinks = new HashMap<String, Link>();
        for (Map.Entry<String, Link> linkEntry : links.entrySet()) {
            String linkName = linkEntry.getKey();
            Link linkFromAspsp = linkEntry.getValue();
            if (this.linkUnchangeable(linkName)) {
                rewrittenLinks.put(linkName, linkFromAspsp);
                continue;
            }
            Optional<String> linkTemplateOptional = this.linksTemplate.get(linkName);
            if (!linkTemplateOptional.isPresent()) {
                logger.warn("Links rewriting: unknown link [{}] - will be leaved unmapped", (Object)linkName);
                rewrittenLinks.put(linkName, linkFromAspsp);
                continue;
            }
            Optional<String> rewrittenLinksOptional = this.replacePlaceholdersWithValues(linkTemplateOptional.get(), linkFromAspsp.getHref());
            if (rewrittenLinksOptional.isPresent()) {
                String rewrittenLink = rewrittenLinksOptional.get();
                rewrittenLink = StringUri.copyQueryParams(linkFromAspsp.getHref(), rewrittenLink);
                rewrittenLinks.put(linkName, new Link(rewrittenLink));
                continue;
            }
            logger.warn("Links rewriting: unknown format of the link [{}] - will be leaved unmapped. Custom rewriting should be provided to handle it", (Object)linkName);
            rewrittenLinks.put(linkName, linkFromAspsp);
        }
        return rewrittenLinks;
    }

    protected boolean linkUnchangeable(String linkName) {
        return UNCHANGEABLE_LINKS.contains(linkName);
    }

    private Optional<String> replacePlaceholdersWithValues(String linkTemplate, String linkFromAspsp) {
        Set<String> placeholders = this.getTemplatePlaceholders(linkTemplate);
        String rewrittenLink = linkTemplate;
        for (String placeholder : placeholders) {
            Function<String, Optional<String>> paramRetriever = this.placeholdersToParamRetrievers.get(placeholder);
            if (paramRetriever == null) {
                return Optional.empty();
            }
            Optional<String> paramOptional = paramRetriever.apply(linkFromAspsp);
            if (!paramOptional.isPresent()) {
                return Optional.empty();
            }
            String param = paramOptional.get();
            rewrittenLink = rewrittenLink.replace(placeholder, param);
        }
        return Optional.of(rewrittenLink);
    }

    private Set<String> getTemplatePlaceholders(String linkTemplate) {
        LinkedHashSet<String> placeholders = new LinkedHashSet<String>();
        int from = 0;
        while (true) {
            int start = linkTemplate.indexOf(START_OF_PLACEHOLDER, from);
            int end = linkTemplate.indexOf(END_OF_PLACEHOLDER, from);
            if (start == -1 || end == -1) break;
            String placeholder = linkTemplate.substring(start, end + 1);
            placeholders.add(placeholder);
            from = end + 1;
        }
        return placeholders;
    }

    protected Optional<String> retrieveHost(String link) {
        return Optional.ofNullable(this.host);
    }

    protected Optional<String> retrieveVersion(String link) {
        return Optional.ofNullable(this.version);
    }

    protected Optional<String> retrieveConsentId(String link) {
        return this.findUsingPattern(link, CONSENT_ID_PATTERN);
    }

    private Optional<String> findUsingPattern(String link, Pattern pattern) {
        Matcher matcher = pattern.matcher(link);
        if (matcher.find()) {
            return Optional.of(matcher.group(1));
        }
        return Optional.empty();
    }

    protected Optional<String> retrieveAuthorisationId(String link) {
        return this.findUsingPattern(link, AUTHORISATION_ID_PATTERN);
    }

    protected Optional<String> retrieveAccountId(String link) {
        return this.findUsingPattern(link, ACCOUNT_ID_PATTERN);
    }

    protected Optional<String> retrieveTransactionId(String link) {
        return this.findUsingPattern(link, TRANSACTION_ID_PATTERN);
    }

    protected Optional<String> retrievePaymentService(String link) {
        String[] linkPaths = this.getLinkPathsAsArray(link);
        if (linkPaths.length < 1) {
            return Optional.empty();
        }
        return Optional.of(linkPaths[0]);
    }

    private String[] getLinkPathsAsArray(String link) {
        Optional<String> aspspApiVersionOptional = StringUri.getVersion(link);
        if (!aspspApiVersionOptional.isPresent()) {
            return new String[0];
        }
        String aspspApiVersion = aspspApiVersionOptional.get();
        String linkWithoutHostAndVersion = link.substring(link.indexOf(aspspApiVersion) + aspspApiVersion.length() + 1);
        if (linkWithoutHostAndVersion.isEmpty()) {
            return new String[0];
        }
        return linkWithoutHostAndVersion.split("/");
    }

    protected Optional<String> retrievePaymentProduct(String link) {
        String[] linkPaths = this.getLinkPathsAsArray(link);
        if (linkPaths.length < 2) {
            return Optional.empty();
        }
        return Optional.of(linkPaths[1]);
    }

    protected Optional<String> retrievePaymentId(String link) {
        String[] linkPaths = this.getLinkPathsAsArray(link);
        if (linkPaths.length < 3) {
            return Optional.empty();
        }
        return Optional.of(linkPaths[2]);
    }
}

