/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.xs2a.adapter.http;

import de.adorsys.xs2a.adapter.http.HttpClient;
import de.adorsys.xs2a.adapter.http.Request;
import de.adorsys.xs2a.adapter.http.RequestBuilderImpl;
import de.adorsys.xs2a.adapter.http.Xs2aHttpLogSanitizer;
import de.adorsys.xs2a.adapter.service.Response;
import de.adorsys.xs2a.adapter.service.ResponseHeaders;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.io.EmptyInputStream;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApacheHttpClient
implements HttpClient {
    private static final Logger logger = LoggerFactory.getLogger(ApacheHttpClient.class);
    private final Xs2aHttpLogSanitizer logSanitizer = new Xs2aHttpLogSanitizer();
    private static final String GET = "GET";
    private static final String POST = "POST";
    private static final String PUT = "PUT";
    private static final String DELETE = "DELETE";
    private final CloseableHttpClient httpClient;

    public ApacheHttpClient(CloseableHttpClient httpClient) {
        this.httpClient = httpClient;
    }

    public Request.Builder get(String uri) {
        return new RequestBuilderImpl(this, GET, uri);
    }

    public Request.Builder post(String uri) {
        return new RequestBuilderImpl(this, POST, uri);
    }

    public Request.Builder put(String uri) {
        return new RequestBuilderImpl(this, PUT, uri);
    }

    public Request.Builder delete(String uri) {
        return new RequestBuilderImpl(this, DELETE, uri);
    }

    public <T> Response<T> send(Request.Builder requestBuilder, HttpClient.ResponseHandler<T> responseHandler) {
        return this.execute(this.createRequest(requestBuilder), requestBuilder.headers(), responseHandler);
    }

    private HttpUriRequest createRequest(Request.Builder requestBuilder) {
        switch (requestBuilder.method()) {
            case "GET": {
                return new HttpGet(requestBuilder.uri());
            }
            case "POST": {
                HttpPost post = new HttpPost(requestBuilder.uri());
                if (requestBuilder.jsonBody() != null) {
                    post.setEntity((HttpEntity)new StringEntity(requestBuilder.jsonBody(), ContentType.APPLICATION_JSON));
                } else if (requestBuilder.emptyBody()) {
                    post.setEntity((HttpEntity)new StringEntity("{}", ContentType.APPLICATION_JSON));
                } else if (requestBuilder.urlEncodedBody() != null) {
                    List list = requestBuilder.urlEncodedBody().entrySet().stream().map(entry -> new BasicNameValuePair((String)entry.getKey(), (String)entry.getValue())).collect(Collectors.toList());
                    try {
                        post.setEntity((HttpEntity)new UrlEncodedFormEntity(list));
                    }
                    catch (UnsupportedEncodingException e) {
                        throw new UncheckedIOException(e);
                    }
                }
                return post;
            }
            case "PUT": {
                HttpPut put = new HttpPut(requestBuilder.uri());
                put.setEntity((HttpEntity)new StringEntity(requestBuilder.jsonBody(), ContentType.APPLICATION_JSON));
                return put;
            }
            case "DELETE": {
                return new HttpDelete(requestBuilder.uri());
            }
        }
        throw new UnsupportedOperationException(requestBuilder.method());
    }

    public String content(Request.Builder requestBuilder) {
        return this.getContent(this.createRequest(requestBuilder));
    }

    private String getContent(HttpUriRequest request) {
        Optional<HttpEntity> requestEntity = this.getRequestEntity(request);
        try {
            return requestEntity.isPresent() ? EntityUtils.toString((HttpEntity)requestEntity.get()) : "";
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private Optional<HttpEntity> getRequestEntity(HttpUriRequest request) {
        HttpEntity entity = null;
        if (request instanceof HttpEntityEnclosingRequest) {
            entity = ((HttpEntityEnclosingRequest)request).getEntity();
        }
        return Optional.ofNullable(entity);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private <T> Response<T> execute(HttpUriRequest request, Map<String, String> headers, HttpClient.ResponseHandler<T> responseHandler) {
        headers.forEach((arg_0, arg_1) -> ((HttpUriRequest)request).addHeader(arg_0, arg_1));
        this.logRequest(request, headers);
        try (CloseableHttpResponse response = this.httpClient.execute(request);){
            int statusCode = response.getStatusLine().getStatusCode();
            HttpEntity entity = response.getEntity();
            Map<String, String> responseHeadersMap = this.toHeadersMap(response.getAllHeaders());
            ResponseHeaders responseHeaders = ResponseHeaders.fromMap(responseHeadersMap);
            Object content = entity != null ? entity.getContent() : EmptyInputStream.INSTANCE;
            Object responseBody = responseHandler.apply(statusCode, (InputStream)content, responseHeaders);
            this.logResponse(responseBody, response, responseHeadersMap);
            Response response2 = new Response(statusCode, responseBody, responseHeaders);
            return response2;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private <T> void logResponse(T responseBody, CloseableHttpResponse response, Map<String, String> headers) {
        String direction = "<--";
        this.logHttpEvent(headers, response.getStatusLine().toString(), direction);
        HttpEntity entity = response.getEntity();
        String contentType = entity != null && entity.getContentType() != null ? entity.getContentType().getValue() : "";
        String sanitizedResponseBody = this.logSanitizer.sanitizeResponseBody(responseBody, contentType);
        logger.debug("{} Response body [{}]: {}", new Object[]{direction, contentType, sanitizedResponseBody});
        logger.debug(direction);
    }

    private void logRequest(HttpUriRequest request, Map<String, String> headers) {
        String direction = "-->";
        this.logHttpEvent(headers, request.getRequestLine().toString(), direction);
        Optional<HttpEntity> requestEntityOptional = this.getRequestEntity(request);
        if (requestEntityOptional.isPresent()) {
            HttpEntity entity = requestEntityOptional.get();
            String contentType = entity.getContentType() != null ? entity.getContentType().getValue() : "";
            String sanitizedResponseBody = this.logSanitizer.sanitizeRequestBody(entity, contentType);
            logger.debug("{} Request body [{}]: {}", new Object[]{direction, contentType, sanitizedResponseBody});
            logger.debug(direction);
        }
    }

    private void logHttpEvent(Map<String, String> headers, String httpLine, String direction) {
        logger.debug("{} {}", (Object)direction, (Object)this.logSanitizer.sanitize(httpLine));
        headers.forEach((key, value) -> logger.debug("{} {}: {}", new Object[]{direction, key, this.logSanitizer.sanitizeHeader((String)key, (String)value)}));
        logger.debug(direction);
    }

    private Map<String, String> toHeadersMap(Header[] headers) {
        if (Objects.isNull(headers)) {
            return new HashMap<String, String>();
        }
        HashMap<String, String> headersMap = new HashMap<String, String>();
        for (Header header : headers) {
            headersMap.put(header.getName(), header.getValue());
        }
        return headersMap;
    }
}

