/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.xs2a.adapter.http;

import de.adorsys.xs2a.adapter.http.UriBuilder;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.apache.http.NameValuePair;
import org.apache.http.client.utils.URIBuilder;

class ApacheUriBuilder
extends UriBuilder {
    private final URIBuilder uriBuilder;

    ApacheUriBuilder(URI baseUri) {
        this.uriBuilder = new URIBuilder(baseUri);
    }

    @Override
    public UriBuilder queryParam(String name, String value) {
        if (name != null && value != null) {
            this.uriBuilder.setParameter(name, value);
        }
        return this;
    }

    @Override
    public UriBuilder renameQueryParam(String currentName, String newName) {
        List queryParams = this.uriBuilder.getQueryParams();
        this.uriBuilder.removeQuery();
        for (NameValuePair queryParam : queryParams) {
            if (queryParam.getName().equals(currentName)) {
                this.uriBuilder.addParameter(newName, queryParam.getValue());
                continue;
            }
            this.uriBuilder.addParameter(queryParam.getName(), queryParam.getValue());
        }
        return this;
    }

    @Override
    public URI build() {
        try {
            return ApacheUriBuilder.rfc2396Encoded(this.uriBuilder.build());
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    private static URI rfc2396Encoded(URI uri) {
        try {
            String query = uri.getRawQuery() != null ? URLDecoder.decode(uri.getRawQuery(), StandardCharsets.UTF_8.name()) : null;
            return new URI(uri.getScheme(), uri.getUserInfo(), uri.getHost(), uri.getPort(), uri.getPath(), query, uri.getFragment());
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }
}

