/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.xs2a.adapter.http;

import de.adorsys.xs2a.adapter.http.HttpClient;
import de.adorsys.xs2a.adapter.http.Request;
import de.adorsys.xs2a.adapter.service.Response;
import java.util.LinkedHashMap;
import java.util.Map;

public class RequestBuilderImpl
implements Request.Builder {
    private final HttpClient httpClient;
    private String method;
    private String uri;
    private Map<String, String> headers = new LinkedHashMap<String, String>();
    private String body;
    private boolean emptyBody;
    private Map<String, String> formData;

    public RequestBuilderImpl(HttpClient httpClient, String method, String uri) {
        this.httpClient = httpClient;
        this.method = method;
        this.uri = uri;
    }

    public String method() {
        return this.method;
    }

    public String uri() {
        return this.uri;
    }

    public Request.Builder uri(String uri) {
        this.uri = uri;
        return this;
    }

    public Request.Builder headers(Map<String, String> headers) {
        this.headers = headers;
        return this;
    }

    public Map<String, String> headers() {
        return this.headers;
    }

    public Request.Builder header(String name, String value) {
        this.headers.put(name, value);
        return this;
    }

    public Request.Builder jsonBody(String body) {
        this.body = body;
        return this;
    }

    public String jsonBody() {
        return this.body;
    }

    public Request.Builder emptyBody(boolean emptyBody) {
        this.emptyBody = emptyBody;
        return this;
    }

    public boolean emptyBody() {
        return this.emptyBody;
    }

    public Request.Builder urlEncodedBody(Map<String, String> formData) {
        this.formData = formData;
        return this;
    }

    public Map<String, String> urlEncodedBody() {
        return this.formData;
    }

    public <T> Response<T> send(Request.Builder.Interceptor interceptor, HttpClient.ResponseHandler<T> responseHandler) {
        return this.httpClient.send((Request.Builder)(interceptor != null ? (Request.Builder)interceptor.apply((Object)this) : this), responseHandler);
    }

    public String content() {
        return this.httpClient.content((Request.Builder)this);
    }
}

