/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.xs2a.adapter.http;

import de.adorsys.xs2a.adapter.http.JsonMapper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.http.HttpEntity;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class Xs2aHttpLogSanitizer {
    private static final Logger logger = LoggerFactory.getLogger(Xs2aHttpLogSanitizer.class);
    private static final String APPLICATION_JSON = "application/json";
    static final String REPLACEMENT = "******";
    private final Set<String> sanitizedHeaders = new HashSet<String>();
    private final Set<String> nonSanitizedBodyProperties = new HashSet<String>();
    private final List<Pattern> patterns = new ArrayList<Pattern>();
    private JsonMapper objectMapper = new JsonMapper();

    Xs2aHttpLogSanitizer() {
        this.patterns.add(Pattern.compile("(consents|accounts|authorisations)/[^/?\\s\\[\"]+(.*?)"));
        this.sanitizedHeaders.addAll(Arrays.asList("Authorization", "PSU-ID", "PSU-Corporate-ID", "Consent-ID", "X-GTW-IBAN", "Location", "Signature", "TPP-Signature-Certificate", "Digest"));
        this.nonSanitizedBodyProperties.addAll(Arrays.asList("recurringIndicator", "validUntil", "frequencyPerDay", "combinedServiceIndicator"));
    }

    public String sanitizeHeader(String name, String value) {
        if (this.sanitizedHeaders.contains(name)) {
            return REPLACEMENT;
        }
        return this.sanitize(value);
    }

    public String sanitize(String data) {
        String replacedData = data;
        for (Pattern pattern : this.patterns) {
            Matcher matcher = pattern.matcher(replacedData);
            if (!matcher.find()) continue;
            replacedData = matcher.replaceAll("$1/******$2");
        }
        return replacedData;
    }

    public String sanitizeRequestBody(HttpEntity entity, String contentType) {
        if (contentType.startsWith(APPLICATION_JSON)) {
            try {
                return this.sanitizeStringifiedJsonBody(EntityUtils.toString((HttpEntity)entity));
            }
            catch (Exception e) {
                logger.error("Can't parse request as json. It will be replaced with {}", (Object)REPLACEMENT);
            }
        }
        return REPLACEMENT;
    }

    public String sanitizeResponseBody(Object responseBody, String contentType) {
        if (contentType.startsWith(APPLICATION_JSON)) {
            try {
                String json = responseBody instanceof String ? (String)responseBody : this.objectMapper.writeValueAsString(responseBody);
                return this.sanitizeStringifiedJsonBody(json);
            }
            catch (Exception e) {
                logger.error("Can't parse response as json. It will be replaced with {}", (Object)REPLACEMENT);
            }
        }
        return REPLACEMENT;
    }

    private String sanitizeStringifiedJsonBody(String body) {
        Object responseMap = this.objectMapper.readValue(body, Object.class);
        this.sanitizeObject(responseMap);
        return this.objectMapper.writeValueAsString(responseMap);
    }

    private Map<String, Object> sanitizeMap(Map<String, Object> responseMap) {
        for (Map.Entry<String, Object> entry : responseMap.entrySet()) {
            if (this.nonSanitizedBodyProperties.contains(entry.getKey())) continue;
            responseMap.replace(entry.getKey(), this.sanitizeObject(entry.getValue()));
        }
        return responseMap;
    }

    private List sanitizeList(List list) {
        for (int i = 0; i < list.size(); ++i) {
            list.set(i, this.sanitizeObject(list.get(i)));
        }
        return list;
    }

    private Object sanitizeObject(Object item) {
        if (item instanceof Map) {
            return this.sanitizeMap((Map)item);
        }
        if (item instanceof List) {
            return this.sanitizeList((List)item);
        }
        return REPLACEMENT;
    }
}

