/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.xs2a.adapter.signing.header;

import de.adorsys.xs2a.adapter.signing.service.algorithm.EncodingAlgorithm;
import de.adorsys.xs2a.adapter.signing.service.algorithm.HashingAlgorithm;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;

public class Digest {
    private String headerValue;

    private Digest(String headerValue) {
        this.headerValue = headerValue;
    }

    public static DigestBuilder builder() {
        return new DigestBuilder();
    }

    public String getHeaderName() {
        return "Digest";
    }

    public String getHeaderValue() {
        return this.headerValue;
    }

    public static final class DigestBuilder {
        private String requestBody;
        private HashingAlgorithm hashingAlgorithm = HashingAlgorithm.SHA256;
        private EncodingAlgorithm encodingAlgorithm = EncodingAlgorithm.BASE64;
        private Charset charset = StandardCharsets.UTF_8;

        private DigestBuilder() {
        }

        public DigestBuilder requestBody(String requestBody) {
            this.requestBody = requestBody;
            return this;
        }

        public DigestBuilder hashingAlgorithm(HashingAlgorithm hashingAlgorithm) {
            this.hashingAlgorithm = hashingAlgorithm;
            return this;
        }

        public DigestBuilder encodingAlgorithm(EncodingAlgorithm encodingAlgorithm) {
            this.encodingAlgorithm = encodingAlgorithm;
            return this;
        }

        public DigestBuilder charset(Charset charset) {
            this.charset = charset;
            return this;
        }

        public Digest build() {
            byte[] digestBytes = this.hashingAlgorithm.getHashingService().hash(this.requestBody, this.charset);
            String digestEncoded = this.encodingAlgorithm.getEncodingService().encode(digestBytes);
            return new Digest(this.buildDigestHeader(this.hashingAlgorithm.getAlgorithmName(), digestEncoded));
        }

        private String buildDigestHeader(String algorithmName, String digestEncoded) {
            return algorithmName + "=" + digestEncoded;
        }
    }
}

