/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.xs2a.adapter.signing.service.signing;

import de.adorsys.xs2a.adapter.service.exception.HttpRequestSigningException;
import de.adorsys.xs2a.adapter.signing.service.algorithm.SigningAlgorithm;
import de.adorsys.xs2a.adapter.signing.service.signing.SigningService;
import java.nio.charset.Charset;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.SignatureException;

public class Sha256WithRsaSigningService
implements SigningService {
    @Override
    public byte[] sign(PrivateKey privateKey, String data, Charset charset) {
        try {
            Signature rsaSha256Signature = Signature.getInstance(this.getAlgorithm().getAlgorithmName());
            rsaSha256Signature.initSign(privateKey);
            rsaSha256Signature.update(data.getBytes(charset));
            return rsaSha256Signature.sign();
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | SignatureException e) {
            throw new HttpRequestSigningException("Exception during the signing algorithm" + this.getAlgorithm().getAlgorithmName() + " usage: " + e);
        }
    }

    private SigningAlgorithm getAlgorithm() {
        return SigningAlgorithm.SHA256_WITH_RSA;
    }
}

