/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.xs2a.adapter.service.config;

import de.adorsys.xs2a.adapter.service.PropertyUtil;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AdapterConfig {
    private static final Logger logger = LoggerFactory.getLogger(AdapterConfig.class);
    private static final String ADAPTER_CONFIG_FILE_PATH_PROPERTY = "adapter.config.file.path";
    private static final String DEFAULT_ADAPTER_CONFIG_FILE = "adapter.config.properties";
    private static final Properties properties = new Properties();

    public static void reload() {
        try {
            properties.clear();
            InputStream configFileAsStream = AdapterConfig.getConfigFileAsStream();
            properties.load(configFileAsStream);
            logger.debug("Adapter configuration file is loaded");
        }
        catch (IOException e) {
            throw new IllegalStateException("Can't load adapter config file");
        }
    }

    private AdapterConfig() {
    }

    public static String readProperty(String property) {
        return properties.getProperty(property);
    }

    public static String readProperty(String property, String defaultValue) {
        return properties.getProperty(property, defaultValue);
    }

    private static InputStream getConfigFileAsStream() throws FileNotFoundException {
        InputStream inputStream;
        String filePath = PropertyUtil.readProperty(ADAPTER_CONFIG_FILE_PATH_PROPERTY);
        if (filePath == null || filePath.isEmpty()) {
            inputStream = AdapterConfig.getResourceAsStream(DEFAULT_ADAPTER_CONFIG_FILE);
            logger.debug("Default configuration file [{}] will be used", (Object)DEFAULT_ADAPTER_CONFIG_FILE);
        } else {
            inputStream = AdapterConfig.getFileAsStream(filePath);
            logger.debug("[{}] configuration file will be used", (Object)filePath);
        }
        return inputStream;
    }

    private static InputStream getResourceAsStream(String fileName) {
        return Thread.currentThread().getContextClassLoader().getResourceAsStream(fileName);
    }

    private static InputStream getFileAsStream(String filePath) throws FileNotFoundException {
        return new FileInputStream(filePath);
    }

    static {
        AdapterConfig.reload();
    }
}

