/*
 * Decompiled with CFR 0.152.
 */
package de.agilecoders.wicket.jquery;

import de.agilecoders.wicket.jquery.CombinableConfig;
import de.agilecoders.wicket.jquery.ConfigModel;
import de.agilecoders.wicket.jquery.IKey;
import de.agilecoders.wicket.jquery.Key;
import de.agilecoders.wicket.jquery.util.Json;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.wicket.model.IModel;

public abstract class AbstractConfig
extends CombinableConfig {
    private final Map<String, Object> config = new HashMap<String, Object>();

    protected AbstractConfig() {
    }

    @Override
    public final String toJsonString() {
        return Json.stringify(this.config);
    }

    @Override
    public final Map<String, Object> all() {
        return Collections.unmodifiableMap(this.config);
    }

    @Override
    public final boolean isEmpty() {
        return this.config.isEmpty();
    }

    @Override
    public final <T> AbstractConfig put(IKey<T> key, T value) {
        if (!key.isDefaultValue(value)) {
            this.config.put(key.key(), value);
        } else {
            this.remove(key);
        }
        return this;
    }

    @Override
    public <T> boolean contains(IKey<T> key) {
        return this.config.containsKey(key.key());
    }

    @Override
    public final <T> T remove(IKey<T> key) {
        return (T)this.config.remove(key.key());
    }

    protected final <T> String getString(IKey<T> key) {
        Object value = this.config.get(key.key());
        return String.valueOf(value != null ? value : key.getDefaultValue());
    }

    @Override
    public final <T> T get(IKey<T> key) {
        Object value = this.config.get(key.key());
        return (T)(value != null ? value : key.getDefaultValue());
    }

    protected ConfigModel wrap(IModel<String> model) {
        return new ConfigModel(model);
    }

    protected static <T> IKey<T> newKey(String key, T defaultValue) {
        return new Key<T>(key, defaultValue);
    }
}

