/*
 * Decompiled with CFR 0.152.
 */
package de.agilecoders.wicket.jquery.settings;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.ser.std.RawSerializer;
import de.agilecoders.wicket.jquery.Config;
import de.agilecoders.wicket.jquery.ConfigModel;
import de.agilecoders.wicket.jquery.settings.ObjectMapperFactory;
import de.agilecoders.wicket.jquery.util.Json;
import java.io.IOException;

public class DefaultObjectMapperFactory
implements ObjectMapperFactory {
    @Override
    public ObjectMapper newObjectMapper() {
        return this.configure(new ObjectMapper()).registerModule(this.newModule());
    }

    protected Module newModule() {
        return this.addSerializer(new SimpleModule("wicket-jquery-selectors", new Version(1, 0, 0, null, "de.agilecoders.wicket", "wicket-jquery-selectors")));
    }

    protected Module addSerializer(SimpleModule module) {
        module.addSerializer(ConfigModel.class, Holder.configModelSerializer);
        module.addSerializer(Config.class, Holder.configSerializer);
        module.addSerializer(Json.RawValue.class, (JsonSerializer)Holder.rawSerializer);
        return module;
    }

    protected ObjectMapper configure(ObjectMapper mapper) {
        mapper.configure(JsonParser.Feature.ALLOW_SINGLE_QUOTES, true);
        mapper.configure(JsonParser.Feature.ALLOW_UNQUOTED_FIELD_NAMES, true);
        return mapper;
    }

    protected static final class Holder {
        private static final RawSerializer<Json.RawValue> rawSerializer = new RawSerializer<Json.RawValue>(Json.RawValue.class){

            public void serialize(Json.RawValue value, JsonGenerator jsonGenerator, SerializerProvider provider) throws IOException {
                jsonGenerator.writeObject((Object)value.value());
            }
        };
        public static JsonSerializer<Config> configSerializer = new JsonSerializer<Config>(){

            public void serialize(Config value, JsonGenerator jsonGenerator, SerializerProvider provider) throws IOException {
                jsonGenerator.writeObject((Object)value.toJsonString());
            }
        };
        public static JsonSerializer<ConfigModel> configModelSerializer = new JsonSerializer<ConfigModel>(){

            public void serialize(ConfigModel value, JsonGenerator jsonGenerator, SerializerProvider provider) throws IOException {
                jsonGenerator.writeString(value.getObject());
            }
        };

        protected Holder() {
        }
    }
}

