/*
 * Decompiled with CFR 0.152.
 */
package de.agilecoders.wicket.jquery.function;

import de.agilecoders.wicket.jquery.function.AbstractFunction;
import de.agilecoders.wicket.jquery.util.Strings2;
import java.util.Collections;
import java.util.List;
import org.apache.wicket.util.lang.Objects;

public class JavaScriptInlineFunction
extends AbstractFunction {
    private final String functionBody;

    public JavaScriptInlineFunction(String functionBody) {
        this(functionBody, Collections.emptyList());
    }

    public JavaScriptInlineFunction(String functionBody, List<CharSequence> parameters) {
        super("function", parameters);
        this.functionBody = Strings2.nullToEmpty(functionBody);
    }

    @Override
    public String build() {
        return super.build() + "{" + this.functionBody + "}";
    }

    public boolean equals(Object o) {
        if (o instanceof JavaScriptInlineFunction) {
            JavaScriptInlineFunction other = (JavaScriptInlineFunction)o;
            boolean parametersEqual = Objects.equal(this.getParameters(), other.getParameters());
            boolean functionBodyEqual = Objects.equal((Object)this.functionBody, (Object)other.functionBody);
            return parametersEqual && functionBodyEqual;
        }
        if (o instanceof String) {
            return this.functionBody.equals(o);
        }
        return false;
    }

    public int hashCode() {
        return this.functionBody.hashCode();
    }

    public String toString() {
        return this.functionBody;
    }

    public static String toString(JavaScriptInlineFunction value) {
        return value != null ? value.toString() : "null";
    }
}

