/*
 * Decompiled with CFR 0.152.
 */
package de.agilecoders.wicket.webjars;

import de.agilecoders.wicket.webjars.settings.IWebjarsSettings;
import de.agilecoders.wicket.webjars.settings.WebjarsSettings;
import de.agilecoders.wicket.webjars.util.file.WebjarsResourceFinder;
import java.util.List;
import org.apache.wicket.Application;
import org.apache.wicket.MetaDataKey;

public final class WicketWebjars {
    private static final MetaDataKey<IWebjarsSettings> WEBJARS_SETTINGS_METADATA_KEY = new MetaDataKey<IWebjarsSettings>(){};

    public static void install(Application app) {
        WicketWebjars.install(app, null);
    }

    public static void install(Application app, IWebjarsSettings settings) {
        IWebjarsSettings existingSettings = WicketWebjars.settings(app);
        if (existingSettings == null) {
            if (settings == null) {
                settings = new WebjarsSettings();
            }
            app.setMetaData(WEBJARS_SETTINGS_METADATA_KEY, (Object)settings);
            List finders = app.getResourceSettings().getResourceFinders();
            WebjarsResourceFinder finder = new WebjarsResourceFinder(settings);
            if (!finders.contains(finder)) {
                finders.add(finder);
            }
        }
    }

    public static IWebjarsSettings settings(Application app) {
        return (IWebjarsSettings)app.getMetaData(WEBJARS_SETTINGS_METADATA_KEY);
    }

    public static IWebjarsSettings settings() {
        if (Application.exists()) {
            IWebjarsSettings settings = (IWebjarsSettings)Application.get().getMetaData(WEBJARS_SETTINGS_METADATA_KEY);
            if (settings != null) {
                return settings;
            }
            throw new IllegalStateException("you have to call WicketWebjars.install() before you can use an IWebjarsResourceReference or any other component.");
        }
        throw new IllegalStateException("there is no active application assigned to this thread.");
    }

    private WicketWebjars() {
        throw new UnsupportedOperationException();
    }
}

