/*
 * Decompiled with CFR 0.152.
 */
package de.agilecoders.wicket.webjars.collectors;

import de.agilecoders.wicket.webjars.collectors.ProtocolAwareAssetPathCollector;
import java.io.File;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;

public class FileAssetPathCollector
extends ProtocolAwareAssetPathCollector {
    private static final int MAX_DIRECTORY_DEPTH = 5;
    private final String pathPrefix;

    public FileAssetPathCollector(String pathPrefix) {
        super("file");
        this.pathPrefix = pathPrefix;
    }

    @Override
    public Collection<String> collect(URL url, Pattern filterExpr) {
        File file;
        try {
            file = new File(url.toURI());
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
        return this.listFiles(file, filterExpr);
    }

    private Set<String> listFiles(File file, Pattern filterExpr) {
        HashSet<String> aggregatedChildren = new HashSet<String>();
        this.aggregateChildren(file, file, aggregatedChildren, filterExpr, 0);
        return aggregatedChildren;
    }

    private void aggregateChildren(File rootDirectory, File file, Set<String> aggregatedChildren, Pattern filterExpr, int level) {
        if (file != null && file.isDirectory()) {
            if (level > 5) {
                throw new IllegalStateException("Got deeper than 5 levels while searching " + rootDirectory);
            }
            File[] files = file.listFiles();
            if (files != null) {
                for (File child : files) {
                    this.aggregateChildren(rootDirectory, child, aggregatedChildren, filterExpr, level + 1);
                }
            }
        } else if (file != null) {
            this.aggregateFile(file, aggregatedChildren, filterExpr);
        }
    }

    private void aggregateFile(File file, Set<String> aggregatedChildren, Pattern filterExpr) {
        String path = file.getPath().replace('\\', '/');
        String relativePath = path.substring(path.indexOf(this.pathPrefix));
        if (filterExpr.matcher(relativePath).matches()) {
            aggregatedChildren.add(relativePath);
        }
    }
}

