/*
 * Decompiled with CFR 0.152.
 */
package de.agilecoders.wicket.webjars.util;

import de.agilecoders.wicket.webjars.collectors.AssetsMap;
import de.agilecoders.wicket.webjars.collectors.IAssetProvider;
import de.agilecoders.wicket.webjars.settings.IWebjarsSettings;
import de.agilecoders.wicket.webjars.util.Helper;
import de.agilecoders.wicket.webjars.util.IFullPathProvider;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import org.apache.wicket.util.lang.Args;

public class WebJarAssetLocator
implements IAssetProvider,
IFullPathProvider {
    private final AssetsMap assetMap;
    private final String recentVersionPlaceHolder;

    public WebJarAssetLocator(IWebjarsSettings settings) {
        this.assetMap = new AssetsMap(settings);
        this.recentVersionPlaceHolder = "/" + settings.recentVersionPlaceHolder() + "/";
    }

    private String throwNotFoundException(String partialPath) {
        throw new IllegalArgumentException(partialPath + " could not be found. Make sure you've added the corresponding WebJar and please check for typos.");
    }

    private String throwMultipleMatchesException(String partialPath) {
        throw new IllegalArgumentException("Multiple matches found for " + partialPath + ". Please provide a more specific path, for example by including a version number.");
    }

    @Override
    public String getFullPath(String partialPath) {
        Iterator<Map.Entry<String, String>> fullPathTailIter;
        Map.Entry<String, String> fullPathEntry;
        partialPath = ((String)Args.notEmpty((CharSequence)partialPath, (String)"partialPath")).contains(this.recentVersionPlaceHolder) ? this.assetMap.findRecentVersionFor(partialPath) : partialPath;
        String reversePartialPath = Helper.reversePath(partialPath);
        SortedMap<String, String> fullPathTail = this.assetMap.getFullPathIndex().tailMap(reversePartialPath);
        if (fullPathTail.size() == 0) {
            this.throwNotFoundException(partialPath);
        }
        if (!(fullPathEntry = (fullPathTailIter = fullPathTail.entrySet().iterator()).next()).getKey().startsWith(reversePartialPath)) {
            this.throwNotFoundException(partialPath);
        }
        String fullPath = fullPathEntry.getValue();
        if (fullPathTailIter.hasNext() && fullPathTailIter.next().getKey().startsWith(reversePartialPath)) {
            this.throwMultipleMatchesException(reversePartialPath);
        }
        return fullPath;
    }

    @Override
    public SortedMap<String, String> getFullPathIndex() {
        return this.assetMap.getFullPathIndex();
    }

    @Override
    public Set<String> listAssets(String folderPath) {
        return this.assetMap.listAssets(folderPath);
    }
}

