/*
 * Decompiled with CFR 0.152.
 */
package de.agilecoders.wicket.webjars.util.file;

import de.agilecoders.wicket.webjars.request.resource.IWebjarsResourceReference;
import de.agilecoders.wicket.webjars.settings.IWebjarsSettings;
import de.agilecoders.wicket.webjars.util.IFullPathProvider;
import de.agilecoders.wicket.webjars.util.IResourceStreamProvider;
import de.agilecoders.wicket.webjars.util.WebJarAssetLocator;
import org.apache.wicket.util.file.IResourceFinder;
import org.apache.wicket.util.resource.IResourceStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebjarsResourceFinder
implements IResourceFinder {
    private static final Logger LOG = LoggerFactory.getLogger((String)"wicket-webjars");
    private final IFullPathProvider locator;
    private final IResourceStreamProvider resourceStreamProvider;
    private final IWebjarsSettings settings;
    private final int hashCode;

    public WebjarsResourceFinder(IWebjarsSettings settings) {
        this.settings = settings;
        this.locator = this.newFullPathProvider();
        this.resourceStreamProvider = settings.resourceStreamProvider().newInstance(settings.classLoaders());
        int result = this.locator != null ? this.locator.hashCode() : 0;
        this.hashCode = result = 31 * result + (settings != null ? settings.hashCode() : 0);
    }

    protected IFullPathProvider newFullPathProvider() {
        return new WebJarAssetLocator(this.settings);
    }

    public IResourceStream find(Class<?> clazz, String pathName) {
        IResourceStream stream = null;
        if (IWebjarsResourceReference.class.isAssignableFrom(clazz)) {
            int pos;
            int n = pos = pathName != null ? pathName.lastIndexOf("/webjars/") : -1;
            if (pos > -1) {
                try {
                    String webjarsPath = this.locator.getFullPath(pathName.substring(pos));
                    LOG.debug("webjars path: {}", (Object)webjarsPath);
                    stream = this.newResourceStream(webjarsPath);
                }
                catch (Exception e) {
                    LOG.debug("can't locate resource for: {}; {}", new Object[]{pathName, e.getMessage(), e});
                }
                if (stream == null) {
                    LOG.debug("there is no webjars resource for: {}", (Object)pathName);
                }
            }
        }
        return stream;
    }

    protected IResourceStream newResourceStream(String webjarsPath) {
        return this.resourceStreamProvider.newResourceStream(webjarsPath);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WebjarsResourceFinder that = (WebjarsResourceFinder)o;
        if (this.locator != null ? !this.locator.equals(that.locator) : that.locator != null) {
            return false;
        }
        return !(this.settings != null ? !this.settings.equals(that.settings) : that.settings != null);
    }

    public int hashCode() {
        return this.hashCode;
    }
}

