/*
 * Decompiled with CFR 0.152.
 */
package de.agilecoders.wicket.webjars.vfs;

import de.agilecoders.wicket.webjars.vfs.VfsDir;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import org.jboss.vfs.VirtualFile;
import org.reflections.vfs.UrlTypeVFS;
import org.reflections.vfs.Vfs;

public class ExtendedUrlTypeVFS
extends UrlTypeVFS {
    static final boolean jbossAS;
    final String VFS = "vfs";

    public boolean matches(URL url) {
        return super.matches(url) || "vfs".equals(url.getProtocol());
    }

    public Vfs.Dir createDir(URL url) {
        if (jbossAS && "vfs".equals(url.getProtocol())) {
            try {
                if (url.getContent() instanceof VirtualFile) {
                    return new VfsDir(url);
                }
            }
            catch (IOException e) {
                throw new RuntimeException("error reading from VFS", e);
            }
        }
        return super.createDir(url);
    }

    public URL adaptURL(URL url) throws MalformedURLException {
        if ("vfs".equals(url.getProtocol())) {
            return new URL(url.toString().replace("vfs", "file"));
        }
        return super.adaptURL(url);
    }

    static {
        boolean jbossFound;
        try {
            Class.forName("org.jboss.vfs.VirtualFile");
            jbossFound = true;
        }
        catch (ClassNotFoundException e) {
            jbossFound = false;
        }
        jbossAS = jbossFound;
    }
}

