/*
 * Decompiled with CFR 0.152.
 */
package de.agilecoders.wicket.webjars.vfs;

import com.google.common.collect.AbstractIterator;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import org.jboss.vfs.VirtualFile;
import org.reflections.vfs.Vfs;

public class VfsDir
implements Vfs.Dir {
    private VirtualFile virtualFile;

    public VfsDir(URL url) {
        try {
            Object content = url.getContent();
            if (!(content instanceof VirtualFile)) {
                throw new IllegalArgumentException("URL content is not a JBoss VFS VirtualFile. Type is: " + (content == null ? "null" : content.getClass().getName()));
            }
            this.virtualFile = (VirtualFile)content;
        }
        catch (IOException e) {
            throw new RuntimeException("could not instantiate VFS directory", e);
        }
    }

    public String getPath() {
        return this.virtualFile.getPathName();
    }

    public Iterable<Vfs.File> getFiles() {
        return new Iterable<Vfs.File>(){

            @Override
            public Iterator<Vfs.File> iterator() {
                final ArrayList toVisit = new ArrayList(VfsDir.this.virtualFile.getChildren());
                return new AbstractIterator<Vfs.File>(){

                    protected Vfs.File computeNext() {
                        while (!toVisit.isEmpty()) {
                            final VirtualFile nextFile = (VirtualFile)toVisit.remove(toVisit.size() - 1);
                            if (nextFile.isDirectory()) {
                                toVisit.addAll(nextFile.getChildren());
                                continue;
                            }
                            return new Vfs.File(){

                                public String getName() {
                                    return nextFile.getName();
                                }

                                public String getRelativePath() {
                                    return nextFile.getPathNameRelativeTo(VfsDir.this.virtualFile);
                                }

                                public InputStream openInputStream() throws IOException {
                                    return nextFile.openStream();
                                }
                            };
                        }
                        return (Vfs.File)this.endOfData();
                    }
                };
            }
        };
    }

    public void close() {
    }

    public String toString() {
        return this.virtualFile.getName();
    }
}

