/*
 * Decompiled with CFR 0.152.
 */
package de.agilecoders.wicket.webjars.collectors;

import de.agilecoders.wicket.webjars.WicketWebjars;
import de.agilecoders.wicket.webjars.collectors.AssetPathCollector;
import de.agilecoders.wicket.webjars.collectors.IAssetProvider;
import de.agilecoders.wicket.webjars.collectors.IRecentVersionProvider;
import de.agilecoders.wicket.webjars.settings.IWebjarsSettings;
import de.agilecoders.wicket.webjars.util.Helper;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AssetsMap
implements IAssetProvider,
IRecentVersionProvider {
    private static final Logger LOG = LoggerFactory.getLogger(WicketWebjars.class);
    private final IWebjarsSettings settings;
    private final SortedMap<String, String> fullPathIndex;
    private final AssetPathCollector[] collectors;
    private final String recentVersionPlaceHolder;

    public AssetsMap(IWebjarsSettings settings) {
        this.settings = settings;
        this.collectors = settings.assetPathCollectors();
        this.recentVersionPlaceHolder = settings.recentVersionPlaceHolder();
        this.fullPathIndex = this.createFullPathIndex(settings.resourcePattern(), settings.classLoaders());
    }

    @Override
    public String findRecentVersionFor(String path) {
        String partialPath = Helper.prependWebjarsPathIfMissing(path);
        Matcher partialPathMatcher = this.settings.webjarsPathPattern().matcher(partialPath);
        if (partialPathMatcher.find() && this.recentVersionPlaceHolder.equalsIgnoreCase(partialPathMatcher.group(2))) {
            Set<String> assets = this.listAssets(partialPathMatcher.group(1));
            String fileName = "/" + partialPathMatcher.group(3);
            ArrayList<String> versions = new ArrayList<String>();
            for (String asset : assets) {
                Matcher matcher;
                if (!asset.endsWith(fileName) || !(matcher = this.settings.webjarsPathPattern().matcher(asset)).find()) continue;
                versions.add(matcher.group(2));
            }
            if (versions.size() == 1) {
                return (String)versions.get(0);
            }
            if (versions.size() > 1) {
                LOG.warn("more than one version of a dependency is not supported till now. webjars resource: {}; available versions: {}; using: {}", new Object[]{fileName, versions, versions.get(0)});
                return (String)versions.get(0);
            }
            LOG.debug("no version found for webjars resource: {}", (Object)partialPath);
        } else {
            LOG.trace("given webjars resource isn't a dynamic versioned one: {}", (Object)partialPath);
        }
        return null;
    }

    @Override
    public SortedMap<String, String> getFullPathIndex() {
        return this.fullPathIndex;
    }

    @Override
    public Set<String> listAssets(String folderPath) {
        Collection<String> allAssets = this.getFullPathIndex().values();
        HashSet<String> assets = new HashSet<String>();
        String webjarsPath = this.settings.webjarsPath();
        String prefix = webjarsPath.endsWith("/") ? webjarsPath + Helper.removeLeadingSlash(folderPath) : webjarsPath + Helper.appendLeadingSlash(folderPath);
        for (String asset : allAssets) {
            if (!asset.startsWith(prefix)) continue;
            assets.add(asset);
        }
        return assets;
    }

    private Set<URL> listWebjarsParentURLs(ClassLoader[] classLoaders) {
        HashSet<URL> urls = new HashSet<URL>();
        String webjarsPath = this.settings.webjarsPath();
        for (ClassLoader classLoader : classLoaders) {
            try {
                Enumeration<URL> enumeration = classLoader.getResources(webjarsPath);
                while (enumeration.hasMoreElements()) {
                    urls.add(enumeration.nextElement());
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return urls;
    }

    private Set<String> getAssetPaths(Pattern filterExpr, ClassLoader ... classLoaders) {
        HashSet<String> assetPaths = new HashSet<String>();
        Set<URL> urls = this.listWebjarsParentURLs(classLoaders);
        for (URL url : urls) {
            for (AssetPathCollector collector : this.collectors) {
                if (!collector.accept(url)) continue;
                Collection<String> collection = collector.collect(url, filterExpr);
                assetPaths.addAll(collection);
            }
        }
        return assetPaths;
    }

    private SortedMap<String, String> createFullPathIndex(Pattern filterExpr, ClassLoader ... classLoaders) {
        Set<String> assetPaths = this.getAssetPaths(filterExpr, classLoaders);
        TreeMap<String, String> assetPathIndex = new TreeMap<String, String>();
        for (String assetPath : assetPaths) {
            assetPathIndex.put(Helper.reversePath(assetPath), assetPath);
        }
        return assetPathIndex;
    }
}

