/*
 * Decompiled with CFR 0.152.
 */
package de.agilecoders.wicket.webjars;

import de.agilecoders.wicket.webjars.request.WebjarsCDNRequestMapper;
import de.agilecoders.wicket.webjars.settings.IWebjarsSettings;
import de.agilecoders.wicket.webjars.settings.WebjarsSettings;
import de.agilecoders.wicket.webjars.util.WebjarsVersion;
import de.agilecoders.wicket.webjars.util.file.WebjarsResourceFinder;
import java.util.List;
import org.apache.wicket.Application;
import org.apache.wicket.MetaDataKey;
import org.apache.wicket.core.request.mapper.ResourceReferenceMapper;
import org.apache.wicket.protocol.http.WebApplication;
import org.apache.wicket.request.IRequestMapper;
import org.apache.wicket.request.mapper.parameter.IPageParametersEncoder;
import org.apache.wicket.request.mapper.parameter.PageParametersEncoder;
import org.apache.wicket.request.resource.caching.IResourceCachingStrategy;
import org.apache.wicket.util.IProvider;
import org.apache.wicket.util.file.IResourceFinder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class WicketWebjars {
    private static final Logger LOG = LoggerFactory.getLogger((String)"wicket-webjars");
    private static final MetaDataKey<IWebjarsSettings> WEBJARS_SETTINGS_METADATA_KEY = new MetaDataKey<IWebjarsSettings>(){};

    public static boolean isInstalled(Application application) {
        return application.getMetaData(WEBJARS_SETTINGS_METADATA_KEY) != null;
    }

    public static void install(WebApplication app) {
        WicketWebjars.install(app, null);
    }

    public static void install(WebApplication app, IWebjarsSettings settings) {
        IWebjarsSettings existingSettings = WicketWebjars.settings((Application)app);
        if (existingSettings == null) {
            WebjarsResourceFinder finder;
            List finders;
            if (settings == null) {
                settings = new WebjarsSettings();
            }
            app.setMetaData(WEBJARS_SETTINGS_METADATA_KEY, (Object)settings);
            if (settings.useCdnResources()) {
                WicketWebjars.mountCDNMapper(app, settings.cdnUrl());
            }
            if (!(finders = app.getResourceSettings().getResourceFinders()).contains(finder = new WebjarsResourceFinder(settings))) {
                finders.add(finder);
            }
            LOG.info("initialize wicket webjars with given settings: {}", (Object)settings);
        }
    }

    public static void reindex(WebApplication application) {
        List resourceFinders = application.getResourceSettings().getResourceFinders();
        for (IResourceFinder resourceFinder : resourceFinders) {
            if (!(resourceFinder instanceof WebjarsResourceFinder)) continue;
            WebjarsVersion.reset();
            WebjarsResourceFinder webjarsResourceFinder = (WebjarsResourceFinder)resourceFinder;
            webjarsResourceFinder.reindex();
            break;
        }
    }

    private static void mountCDNMapper(final WebApplication app, String cdnUrl) {
        IProvider<String> parentFolderPlaceholderProvider = new IProvider<String>(){

            public String get() {
                return app.getResourceSettings().getParentFolderPlaceholder();
            }
        };
        IProvider<IResourceCachingStrategy> cachingStrategyProvider = new IProvider<IResourceCachingStrategy>(){

            public IResourceCachingStrategy get() {
                return app.getResourceSettings().getCachingStrategy();
            }
        };
        LOG.info("use cdn resources from {}", (Object)cdnUrl);
        ResourceReferenceMapper delegate = new ResourceReferenceMapper((IPageParametersEncoder)new PageParametersEncoder(), (IProvider)parentFolderPlaceholderProvider, (IProvider)cachingStrategyProvider);
        app.mount((IRequestMapper)new WebjarsCDNRequestMapper((IRequestMapper)delegate, cdnUrl, cachingStrategyProvider));
    }

    public static IWebjarsSettings settings(Application app) {
        return (IWebjarsSettings)app.getMetaData(WEBJARS_SETTINGS_METADATA_KEY);
    }

    public static IWebjarsSettings settings() {
        if (Application.exists()) {
            IWebjarsSettings settings = (IWebjarsSettings)Application.get().getMetaData(WEBJARS_SETTINGS_METADATA_KEY);
            if (settings != null) {
                return settings;
            }
            throw new IllegalStateException("you have to call WicketWebjars.install() before you can use an IWebjarsResourceReference or any other component.");
        }
        throw new IllegalStateException("there is no active application assigned to this thread.");
    }

    private WicketWebjars() {
        throw new UnsupportedOperationException();
    }
}

