/*
 * Decompiled with CFR 0.152.
 */
package de.agilecoders.wicket.extensions.markup.html.bootstrap.form.datetime;

import de.agilecoders.wicket.extensions.javascript.jasny.InputMaskBehavior;
import de.agilecoders.wicket.extensions.markup.html.bootstrap.form.datetime.DatetimePickerIconConfig;
import de.agilecoders.wicket.jquery.AbstractConfig;
import de.agilecoders.wicket.jquery.IKey;
import de.agilecoders.wicket.jquery.util.Strings2;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.wicket.behavior.Behavior;

public class DatetimePickerConfig
extends AbstractConfig {
    private static final long serialVersionUID = 1L;
    private static final String DIGITS_PATTERN = "(?i)(y|m|d|h|s)";
    private static final IKey<String> Format = DatetimePickerConfig.newKey((String)"format", null);
    private static final IKey<Boolean> UseCurrent = DatetimePickerConfig.newKey((String)"useCurrent", (Object)true);
    private static final IKey<Boolean> CalendarWeeks = DatetimePickerConfig.newKey((String)"calendarWeeks", (Object)false);
    private static final IKey<Integer> MinuteStepping = DatetimePickerConfig.newKey((String)"stepping", (Object)1);
    private static final IKey<String> MinDate = DatetimePickerConfig.newKey((String)"minDate", null);
    private static final IKey<String> MaxDate = DatetimePickerConfig.newKey((String)"maxDate", null);
    private static final IKey<String> ViewMode = DatetimePickerConfig.newKey((String)"viewMode", null);
    private static final IKey<String> Locale = DatetimePickerConfig.newKey((String)"locale", null);
    private static final IKey<Boolean> ShowToday = DatetimePickerConfig.newKey((String)"showTodayButton", (Object)false);
    private static final IKey<Boolean> ShowClose = DatetimePickerConfig.newKey((String)"showClose", (Object)false);
    private static final IKey<Boolean> Collapse = DatetimePickerConfig.newKey((String)"collapse", (Object)true);
    private static final IKey<Boolean> SideBySide = DatetimePickerConfig.newKey((String)"sideBySide", (Object)false);
    private static final IKey<String[]> DisabledDates = DatetimePickerConfig.newKey((String)"disabledDates", null);
    private static final IKey<String[]> EnabledDates = DatetimePickerConfig.newKey((String)"enabledDates", null);
    private static final IKey<DatetimePickerIconConfig> Icons = DatetimePickerConfig.newKey((String)"icons", null);
    private Boolean maskInput = false;

    public DatetimePickerConfig() {
        this.useLocale("en-gb");
        this.withFormat("MM/dd/yyyy");
    }

    public DatetimePickerConfig useLocale(String locale) {
        this.put(Locale, locale);
        return this;
    }

    public DatetimePickerConfig useMaskInput(boolean maskInput) {
        this.maskInput = maskInput;
        return this;
    }

    public Boolean getMaskInput() {
        return this.maskInput;
    }

    public DatetimePickerConfig withFormat(String format) {
        this.put(Format, DatetimePickerConfig.toJavaScriptDateFormat(format));
        return this;
    }

    public DatetimePickerConfig with(DatetimePickerIconConfig iconConfig) {
        this.put(Icons, (Object)iconConfig);
        return this;
    }

    public DatetimePickerConfig useView(ViewModeType view) {
        this.put(ViewMode, view.getCode());
        return this;
    }

    public DatetimePickerConfig useSideBySide(Boolean sideBySide) {
        this.put(SideBySide, sideBySide);
        return this;
    }

    public DatetimePickerConfig useCurrent(Boolean useCurrent) {
        this.put(UseCurrent, useCurrent);
        return this;
    }

    public DatetimePickerConfig useCalendarWeeks(Boolean calendarWeeks) {
        this.put(CalendarWeeks, calendarWeeks);
        return this;
    }

    public DatetimePickerConfig withMinuteStepping(Integer minuteStepping) {
        this.put(MinuteStepping, minuteStepping);
        return this;
    }

    public DatetimePickerConfig withMinDate(Date minDate) {
        this.put(MinDate, this.customDateFormatter().format(minDate));
        return this;
    }

    public DatetimePickerConfig withMaxDate(Date maxDate) {
        this.put(MaxDate, this.customDateFormatter().format(maxDate));
        return this;
    }

    public DatetimePickerConfig setShowToday(Boolean showToday) {
        this.put(ShowToday, showToday);
        return this;
    }

    public DatetimePickerConfig setShowClose(Boolean showClose) {
        this.put(ShowClose, showClose);
        return this;
    }

    public DatetimePickerConfig setCollapse(Boolean collapse) {
        this.put(Collapse, collapse);
        return this;
    }

    public DatetimePickerConfig withDisabledDates(Date[] disabledDates) {
        this.put(DisabledDates, this.convertDatesToStrings(disabledDates));
        return this;
    }

    public DatetimePickerConfig withEnabledDates(Date[] enabledDates) {
        this.put(EnabledDates, this.convertDatesToStrings(enabledDates));
        return this;
    }

    public String getFormat() {
        return DatetimePickerConfig.toJavaDateFormat(this.getString(Format));
    }

    public String getMinuteStepping() {
        return this.getString(MinuteStepping);
    }

    public ViewModeType getViewMode() {
        return ViewModeType.valueOf(this.getString(ViewMode));
    }

    private String[] convertDatesToStrings(Date[] dates) {
        String[] stringDates = new String[dates.length];
        SimpleDateFormat formatter = this.customDateFormatter();
        int i = 0;
        for (Date date : dates) {
            stringDates[i++] = formatter.format(date);
        }
        return stringDates;
    }

    private SimpleDateFormat customDateFormatter() {
        return new SimpleDateFormat(this.getFormat());
    }

    public static String toJavaDateFormat(String javaScriptDateFormat) {
        return Strings2.nullToEmpty((String)javaScriptDateFormat).replaceAll("D", "d").replaceAll("Y", "y");
    }

    public static String toJavaScriptDateFormat(String javaDateFormat) {
        return Strings2.nullToEmpty((String)javaDateFormat).replaceAll("d", "D").replaceAll("y", "Y");
    }

    public Behavior newMaskBehavior() {
        return new InputMaskBehavior(){
            private static final long serialVersionUID = 5414514378068933745L;

            @Override
            protected String getMask() {
                return DatetimePickerConfig.this.getFormat().replaceAll(DatetimePickerConfig.DIGITS_PATTERN, "9");
            }
        };
    }

    public static enum ViewModeType {
        YEARS("years"),
        MONTHS("months"),
        DAYS("days");

        private final String code;

        private ViewModeType(String code) {
            this.code = code;
        }

        public String getCode() {
            return this.code;
        }
    }
}

