/*
 * Decompiled with CFR 0.152.
 */
package de.agilecoders.wicket.extensions.markup.html.bootstrap.form.fileinput;

import de.agilecoders.wicket.extensions.markup.html.bootstrap.form.fileinput.FileInputConfig;
import de.agilecoders.wicket.extensions.markup.html.bootstrap.form.fileinput.FileinputJsReference;
import de.agilecoders.wicket.jquery.AbstractConfig;
import de.agilecoders.wicket.jquery.JQuery;
import de.agilecoders.wicket.jquery.util.Strings2;
import java.util.HashMap;
import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.form.AjaxFormSubmitBehavior;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.head.HeaderItem;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.markup.head.OnDomReadyHeaderItem;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.upload.FileUpload;
import org.apache.wicket.markup.html.form.upload.FileUploadField;
import org.apache.wicket.model.IModel;
import org.apache.wicket.util.lang.Args;
import org.apache.wicket.util.template.PackageTextTemplate;

public class BootstrapFileInputField
extends FileUploadField {
    public static final String JQUERY_IDENTIFIER_UPLOAD_BUTTON_CLASS = "fileinput-upload-button";
    private static final String AJAX_EVENT_NAME_SUFFIX = "_fileinput-upload-button-clicked";
    private static final String[] LABELS = new String[]{"browseLabel", "removeLabel", "uploadLabel", "msgLoading", "msgProgress", "msgSelected"};
    private Form<?> form;
    private AjaxFormSubmitBehavior ajaxUploadBehavior;
    private final FileInputConfig config;

    public BootstrapFileInputField(String id) {
        this(id, null);
    }

    public BootstrapFileInputField(String id, IModel<List<FileUpload>> model) {
        this(id, model, new FileInputConfig());
    }

    public BootstrapFileInputField(String id, IModel<List<FileUpload>> model, FileInputConfig config) {
        super(id, model);
        this.config = (FileInputConfig)((Object)Args.notNull((Object)((Object)config), (String)"config"));
        if (!config.uploadClass().contains(JQUERY_IDENTIFIER_UPLOAD_BUTTON_CLASS)) {
            String uploadClass = config.uploadClass() + " " + JQUERY_IDENTIFIER_UPLOAD_BUTTON_CLASS;
            config.uploadClass(uploadClass);
        }
    }

    public FileInputConfig getConfig() {
        return this.config;
    }

    void setForm(Form<?> form) {
        this.form = form;
    }

    protected void onConfigure() {
        super.onConfigure();
        if (this.ajaxUploadBehavior == null && this.getConfig().showUpload()) {
            String ajaxEventName = Strings2.getMarkupId((Component)this) + AJAX_EVENT_NAME_SUFFIX;
            this.ajaxUploadBehavior = this.newAjaxFormSubmitBehavior(ajaxEventName);
            this.add(new Behavior[]{this.ajaxUploadBehavior});
        } else if (this.ajaxUploadBehavior != null && !this.getConfig().showUpload()) {
            this.remove(new Behavior[]{this.ajaxUploadBehavior});
            this.ajaxUploadBehavior = null;
        }
    }

    protected AjaxFormSubmitBehavior newAjaxFormSubmitBehavior(String event) {
        return new AjaxFormSubmitBehavior(this.form, event){

            protected void onSubmit(AjaxRequestTarget target) {
                target.add(new Component[]{this.getForm()});
                BootstrapFileInputField.this.onSubmit(target);
            }
        };
    }

    void onError(AjaxRequestTarget target) {
    }

    void onSubmit(AjaxRequestTarget target) {
    }

    public void renderHead(IHeaderResponse response) {
        FileinputJsReference.INSTANCE.renderHead(response);
        JQuery fileinputJS = JQuery.$((Component)this).chain("fileinput", (AbstractConfig)this.config);
        String ajaxUpload = "";
        if (this.ajaxUploadBehavior != null) {
            PackageTextTemplate tmpl = new PackageTextTemplate(BootstrapFileInputField.class, "res/fileinput.tmpl.js");
            HashMap<String, CharSequence> variables = new HashMap<String, CharSequence>();
            variables.put("markupId", Strings2.getMarkupId((Component)this));
            for (String label : LABELS) {
                variables.put(label, this.getString(label));
            }
            variables.put("eventName", this.ajaxUploadBehavior.getEvent());
            ajaxUpload = tmpl.asString(variables);
        }
        response.render((HeaderItem)OnDomReadyHeaderItem.forScript((CharSequence)(fileinputJS.get() + ajaxUpload)));
    }
}

