/*
 * Decompiled with CFR 0.152.
 */
package de.agilecoders.wicket.extensions.markup.html.bootstrap.form.typeahead;

import de.agilecoders.wicket.core.markup.html.bootstrap.behavior.BootstrapResourcesBehavior;
import de.agilecoders.wicket.core.markup.html.bootstrap.form.InputBehavior;
import de.agilecoders.wicket.core.markup.html.bootstrap.layout.col.SpanType;
import de.agilecoders.wicket.extensions.markup.html.bootstrap.form.typeahead.Dataset;
import de.agilecoders.wicket.extensions.markup.html.bootstrap.form.typeahead.Remote;
import de.agilecoders.wicket.extensions.markup.html.bootstrap.form.typeahead.TypeaheadBehavior;
import de.agilecoders.wicket.extensions.markup.html.bootstrap.form.typeahead.TypeaheadJsReference;
import de.agilecoders.wicket.jquery.AbstractConfig;
import de.agilecoders.wicket.jquery.JQuery;
import java.util.Collections;
import org.apache.wicket.Component;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.head.HeaderItem;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.markup.head.JavaScriptHeaderItem;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.model.IModel;
import org.apache.wicket.request.resource.ResourceReference;
import org.apache.wicket.util.lang.Args;

public class Typeahead<T>
extends TextField<T> {
    private final Dataset config;
    private final InputBehavior inputBehavior;
    private TypeaheadBehavior<T> remoteBehavior;

    public Typeahead(String markupId, Dataset config) {
        this(markupId, null, config);
    }

    public Typeahead(String markupId, IModel<T> model, Dataset config) {
        super(markupId, model);
        this.config = (Dataset)((Object)Args.notNull((Object)((Object)config), (String)"config"));
        Behavior[] behaviorArray = new Behavior[1];
        this.inputBehavior = new InputBehavior();
        behaviorArray[0] = this.inputBehavior;
        this.add(behaviorArray);
        BootstrapResourcesBehavior.addTo((Component)this);
    }

    public Typeahead<T> size(SpanType size) {
        this.inputBehavior.size(size);
        return this;
    }

    public Typeahead<T> size(InputBehavior.Size size) {
        this.inputBehavior.size(size);
        return this;
    }

    public Typeahead<T> remote(boolean remote) {
        if (remote && this.remoteBehavior == null) {
            this.remoteBehavior = this.createTypeaheadBehavior();
            this.add(new Behavior[]{this.remoteBehavior});
        } else if (!remote && this.remoteBehavior != null) {
            this.remove(new Behavior[]{this.remoteBehavior});
            this.remoteBehavior = null;
        }
        return this;
    }

    protected TypeaheadBehavior<T> createTypeaheadBehavior() {
        return new TypeaheadBehavior<T>(){

            @Override
            protected Iterable<T> getChoices(String input) {
                return Typeahead.this.getChoices(input);
            }
        };
    }

    protected Iterable<T> getChoices(String input) {
        return Collections.emptyList();
    }

    protected void onComponentTag(ComponentTag tag) {
        this.checkComponentTag(tag, "input");
        super.onComponentTag(tag);
    }

    public void renderHead(IHeaderResponse response) {
        super.renderHead(response);
        if (this.remoteBehavior != null) {
            Remote remoteConfig = this.config.getRemote();
            if (remoteConfig == null) {
                remoteConfig = new Remote();
                this.config.withRemote(remoteConfig);
            }
            remoteConfig.withUrl(this.remoteBehavior.getCallbackUrl());
        }
        response.render(this.newTypeaheadJsHeaderItem());
        response.render((HeaderItem)JQuery.$((Component)this).chain("typeahead", (AbstractConfig)this.config).asDomReadyScript());
    }

    protected HeaderItem newTypeaheadJsHeaderItem() {
        return JavaScriptHeaderItem.forReference((ResourceReference)TypeaheadJsReference.instance());
    }
}

