package de.agilecoders.wicket.extensions.markup.html.bootstrap.icon;

import static de.agilecoders.wicket.extensions.markup.html.bootstrap.icon.FontAwesome5IconTypeBuilder.on;

import org.apache.wicket.util.string.Strings;

import de.agilecoders.wicket.core.markup.html.bootstrap.image.IconType;
import de.agilecoders.wicket.extensions.markup.html.bootstrap.icon.FontAwesome5IconTypeBuilder.FontAwesome5Brand;
import de.agilecoders.wicket.extensions.markup.html.bootstrap.icon.FontAwesome5IconTypeBuilder.FontAwesome5Regular;
import de.agilecoders.wicket.extensions.markup.html.bootstrap.icon.FontAwesome5IconTypeBuilder.FontAwesome5Solid;

/**
 * <strong>Important</strong>: To use font-awesome 5.x you need to declare the Maven/Gradle dependency
 * in your application pom.xml/build.gradle, for example:
 *
 * <br/>
 *  &lt;dependency&gt;<br/>
 *      &lt;groupId&gt;org.webjars&lt;/groupId&gt;<br/>
 *      &lt;artifactId&gt;font-awesome&lt;/artifactId&gt;<br/>
 *      &lt;version&gt;5.15.4&lt;/version&gt;<br/>
 *  &lt;/dependency&gt;<br/>
 *
 * All the icon types.
 */
public class FontAwesome5IconType extends IconType {

    /**
     * serialVersionUID.
     */
    private static final long serialVersionUID = 1L;

    // icon types of style 'solid' (tag '_s') and 'regular' (tag '_r') (where free)
    public static final FontAwesome5IconType ad_s = on(FontAwesome5Solid.ad).build();
    public static final FontAwesome5IconType address_book_r = on(FontAwesome5Regular.address_book).build();
    public static final FontAwesome5IconType address_book_s = on(FontAwesome5Solid.address_book).build();
    public static final FontAwesome5IconType address_card_r = on(FontAwesome5Regular.address_card).build();
    public static final FontAwesome5IconType address_card_s = on(FontAwesome5Solid.address_card).build();
    public static final FontAwesome5IconType adjust_s = on(FontAwesome5Solid.adjust).build();
    public static final FontAwesome5IconType air_freshener_s = on(FontAwesome5Solid.air_freshener).build();
    public static final FontAwesome5IconType align_center_s = on(FontAwesome5Solid.align_center).build();
    public static final FontAwesome5IconType align_justify_s = on(FontAwesome5Solid.align_justify).build();
    public static final FontAwesome5IconType align_left_s = on(FontAwesome5Solid.align_left).build();
    public static final FontAwesome5IconType align_right_s = on(FontAwesome5Solid.align_right).build();
    public static final FontAwesome5IconType allergies_s = on(FontAwesome5Solid.allergies).build();
    public static final FontAwesome5IconType ambulance_s = on(FontAwesome5Solid.ambulance).build();
    public static final FontAwesome5IconType american_sign_language_interpreting_s = on(FontAwesome5Solid.american_sign_language_interpreting).build();
    public static final FontAwesome5IconType anchor_s = on(FontAwesome5Solid.anchor).build();
    public static final FontAwesome5IconType angle_double_down_s = on(FontAwesome5Solid.angle_double_down).build();
    public static final FontAwesome5IconType angle_double_left_s = on(FontAwesome5Solid.angle_double_left).build();
    public static final FontAwesome5IconType angle_double_right_s = on(FontAwesome5Solid.angle_double_right).build();
    public static final FontAwesome5IconType angle_double_up_s = on(FontAwesome5Solid.angle_double_up).build();
    public static final FontAwesome5IconType angle_down_s = on(FontAwesome5Solid.angle_down).build();
    public static final FontAwesome5IconType angle_left_s = on(FontAwesome5Solid.angle_left).build();
    public static final FontAwesome5IconType angle_right_s = on(FontAwesome5Solid.angle_right).build();
    public static final FontAwesome5IconType angle_up_s = on(FontAwesome5Solid.angle_up).build();
    public static final FontAwesome5IconType angry_r = on(FontAwesome5Regular.angry).build();
    public static final FontAwesome5IconType angry_s = on(FontAwesome5Solid.angry).build();
    public static final FontAwesome5IconType ankh_s = on(FontAwesome5Solid.ankh).build();
    public static final FontAwesome5IconType apple_alt_s = on(FontAwesome5Solid.apple_alt).build();
    public static final FontAwesome5IconType archive_s = on(FontAwesome5Solid.archive).build();
    public static final FontAwesome5IconType archway_s = on(FontAwesome5Solid.archway).build();
    public static final FontAwesome5IconType arrow_alt_circle_down_r = on(FontAwesome5Regular.arrow_alt_circle_down).build();
    public static final FontAwesome5IconType arrow_alt_circle_down_s = on(FontAwesome5Solid.arrow_alt_circle_down).build();
    public static final FontAwesome5IconType arrow_alt_circle_left_r = on(FontAwesome5Regular.arrow_alt_circle_left).build();
    public static final FontAwesome5IconType arrow_alt_circle_left_s = on(FontAwesome5Solid.arrow_alt_circle_left).build();
    public static final FontAwesome5IconType arrow_alt_circle_right_r = on(FontAwesome5Regular.arrow_alt_circle_right).build();
    public static final FontAwesome5IconType arrow_alt_circle_right_s = on(FontAwesome5Solid.arrow_alt_circle_right).build();
    public static final FontAwesome5IconType arrow_alt_circle_up_r = on(FontAwesome5Regular.arrow_alt_circle_up).build();
    public static final FontAwesome5IconType arrow_alt_circle_up_s = on(FontAwesome5Solid.arrow_alt_circle_up).build();
    public static final FontAwesome5IconType arrow_circle_down_s = on(FontAwesome5Solid.arrow_circle_down).build();
    public static final FontAwesome5IconType arrow_circle_left_s = on(FontAwesome5Solid.arrow_circle_left).build();
    public static final FontAwesome5IconType arrow_circle_right_s = on(FontAwesome5Solid.arrow_circle_right).build();
    public static final FontAwesome5IconType arrow_circle_up_s = on(FontAwesome5Solid.arrow_circle_up).build();
    public static final FontAwesome5IconType arrow_down_s = on(FontAwesome5Solid.arrow_down).build();
    public static final FontAwesome5IconType arrow_left_s = on(FontAwesome5Solid.arrow_left).build();
    public static final FontAwesome5IconType arrow_right_s = on(FontAwesome5Solid.arrow_right).build();
    public static final FontAwesome5IconType arrow_up_s = on(FontAwesome5Solid.arrow_up).build();
    public static final FontAwesome5IconType arrows_alt_h_s = on(FontAwesome5Solid.arrows_alt_h).build();
    public static final FontAwesome5IconType arrows_alt_s = on(FontAwesome5Solid.arrows_alt).build();
    public static final FontAwesome5IconType arrows_alt_v_s = on(FontAwesome5Solid.arrows_alt_v).build();
    public static final FontAwesome5IconType assistive_listening_systems_s = on(FontAwesome5Solid.assistive_listening_systems).build();
    public static final FontAwesome5IconType asterisk_s = on(FontAwesome5Solid.asterisk).build();
    public static final FontAwesome5IconType at_s = on(FontAwesome5Solid.at).build();
    public static final FontAwesome5IconType atlas_s = on(FontAwesome5Solid.atlas).build();
    public static final FontAwesome5IconType atom_s = on(FontAwesome5Solid.atom).build();
    public static final FontAwesome5IconType audio_description_s = on(FontAwesome5Solid.audio_description).build();
    public static final FontAwesome5IconType award_s = on(FontAwesome5Solid.award).build();
    public static final FontAwesome5IconType baby_carriage_s = on(FontAwesome5Solid.baby_carriage).build();
    public static final FontAwesome5IconType baby_s = on(FontAwesome5Solid.baby).build();
    public static final FontAwesome5IconType backspace_s = on(FontAwesome5Solid.backspace).build();
    public static final FontAwesome5IconType backward_s = on(FontAwesome5Solid.backward).build();
    public static final FontAwesome5IconType bacon_s = on(FontAwesome5Solid.bacon).build();
    public static final FontAwesome5IconType bacteria_s = on(FontAwesome5Solid.bacteria).build();
    public static final FontAwesome5IconType bacterium_s = on(FontAwesome5Solid.bacterium).build();
    public static final FontAwesome5IconType bahai_s = on(FontAwesome5Solid.bahai).build();
    public static final FontAwesome5IconType balance_scale_left_s = on(FontAwesome5Solid.balance_scale_left).build();
    public static final FontAwesome5IconType balance_scale_right_s = on(FontAwesome5Solid.balance_scale_right).build();
    public static final FontAwesome5IconType balance_scale_s = on(FontAwesome5Solid.balance_scale).build();
    public static final FontAwesome5IconType ban_s = on(FontAwesome5Solid.ban).build();
    public static final FontAwesome5IconType band_aid_s = on(FontAwesome5Solid.band_aid).build();
    public static final FontAwesome5IconType barcode_s = on(FontAwesome5Solid.barcode).build();
    public static final FontAwesome5IconType bars_s = on(FontAwesome5Solid.bars).build();
    public static final FontAwesome5IconType baseball_ball_s = on(FontAwesome5Solid.baseball_ball).build();
    public static final FontAwesome5IconType basketball_ball_s = on(FontAwesome5Solid.basketball_ball).build();
    public static final FontAwesome5IconType bath_s = on(FontAwesome5Solid.bath).build();
    public static final FontAwesome5IconType battery_empty_s = on(FontAwesome5Solid.battery_empty).build();
    public static final FontAwesome5IconType battery_full_s = on(FontAwesome5Solid.battery_full).build();
    public static final FontAwesome5IconType battery_half_s = on(FontAwesome5Solid.battery_half).build();
    public static final FontAwesome5IconType battery_quarter_s = on(FontAwesome5Solid.battery_quarter).build();
    public static final FontAwesome5IconType battery_three_quarters_s = on(FontAwesome5Solid.battery_three_quarters).build();
    public static final FontAwesome5IconType bed_s = on(FontAwesome5Solid.bed).build();
    public static final FontAwesome5IconType beer_s = on(FontAwesome5Solid.beer).build();
    public static final FontAwesome5IconType bell_r = on(FontAwesome5Regular.bell).build();
    public static final FontAwesome5IconType bell_s = on(FontAwesome5Solid.bell).build();
    public static final FontAwesome5IconType bell_slash_r = on(FontAwesome5Regular.bell_slash).build();
    public static final FontAwesome5IconType bell_slash_s = on(FontAwesome5Solid.bell_slash).build();
    public static final FontAwesome5IconType bezier_curve_s = on(FontAwesome5Solid.bezier_curve).build();
    public static final FontAwesome5IconType bible_s = on(FontAwesome5Solid.bible).build();
    public static final FontAwesome5IconType bicycle_s = on(FontAwesome5Solid.bicycle).build();
    public static final FontAwesome5IconType biking_s = on(FontAwesome5Solid.biking).build();
    public static final FontAwesome5IconType binoculars_s = on(FontAwesome5Solid.binoculars).build();
    public static final FontAwesome5IconType biohazard_s = on(FontAwesome5Solid.biohazard).build();
    public static final FontAwesome5IconType birthday_cake_s = on(FontAwesome5Solid.birthday_cake).build();
    public static final FontAwesome5IconType blender_phone_s = on(FontAwesome5Solid.blender_phone).build();
    public static final FontAwesome5IconType blender_s = on(FontAwesome5Solid.blender).build();
    public static final FontAwesome5IconType blind_s = on(FontAwesome5Solid.blind).build();
    public static final FontAwesome5IconType blog_s = on(FontAwesome5Solid.blog).build();
    public static final FontAwesome5IconType bold_s = on(FontAwesome5Solid.bold).build();
    public static final FontAwesome5IconType bolt_s = on(FontAwesome5Solid.bolt).build();
    public static final FontAwesome5IconType bomb_s = on(FontAwesome5Solid.bomb).build();
    public static final FontAwesome5IconType bone_s = on(FontAwesome5Solid.bone).build();
    public static final FontAwesome5IconType bong_s = on(FontAwesome5Solid.bong).build();
    public static final FontAwesome5IconType book_dead_s = on(FontAwesome5Solid.book_dead).build();
    public static final FontAwesome5IconType book_medical_s = on(FontAwesome5Solid.book_medical).build();
    public static final FontAwesome5IconType book_open_s = on(FontAwesome5Solid.book_open).build();
    public static final FontAwesome5IconType book_reader_s = on(FontAwesome5Solid.book_reader).build();
    public static final FontAwesome5IconType book_s = on(FontAwesome5Solid.book).build();
    public static final FontAwesome5IconType bookmark_r = on(FontAwesome5Regular.bookmark).build();
    public static final FontAwesome5IconType bookmark_s = on(FontAwesome5Solid.bookmark).build();
    public static final FontAwesome5IconType border_all_s = on(FontAwesome5Solid.border_all).build();
    public static final FontAwesome5IconType border_none_s = on(FontAwesome5Solid.border_none).build();
    public static final FontAwesome5IconType border_style_s = on(FontAwesome5Solid.border_style).build();
    public static final FontAwesome5IconType bowling_ball_s = on(FontAwesome5Solid.bowling_ball).build();
    public static final FontAwesome5IconType box_open_s = on(FontAwesome5Solid.box_open).build();
    public static final FontAwesome5IconType box_s = on(FontAwesome5Solid.box).build();
    public static final FontAwesome5IconType box_tissue_s = on(FontAwesome5Solid.box_tissue).build();
    public static final FontAwesome5IconType boxes_s = on(FontAwesome5Solid.boxes).build();
    public static final FontAwesome5IconType braille_s = on(FontAwesome5Solid.braille).build();
    public static final FontAwesome5IconType brain_s = on(FontAwesome5Solid.brain).build();
    public static final FontAwesome5IconType bread_slice_s = on(FontAwesome5Solid.bread_slice).build();
    public static final FontAwesome5IconType briefcase_medical_s = on(FontAwesome5Solid.briefcase_medical).build();
    public static final FontAwesome5IconType briefcase_s = on(FontAwesome5Solid.briefcase).build();
    public static final FontAwesome5IconType broadcast_tower_s = on(FontAwesome5Solid.broadcast_tower).build();
    public static final FontAwesome5IconType broom_s = on(FontAwesome5Solid.broom).build();
    public static final FontAwesome5IconType brush_s = on(FontAwesome5Solid.brush).build();
    public static final FontAwesome5IconType bug_s = on(FontAwesome5Solid.bug).build();
    public static final FontAwesome5IconType building_r = on(FontAwesome5Regular.building).build();
    public static final FontAwesome5IconType building_s = on(FontAwesome5Solid.building).build();
    public static final FontAwesome5IconType bullhorn_s = on(FontAwesome5Solid.bullhorn).build();
    public static final FontAwesome5IconType bullseye_s = on(FontAwesome5Solid.bullseye).build();
    public static final FontAwesome5IconType burn_s = on(FontAwesome5Solid.burn).build();
    public static final FontAwesome5IconType bus_alt_s = on(FontAwesome5Solid.bus_alt).build();
    public static final FontAwesome5IconType bus_s = on(FontAwesome5Solid.bus).build();
    public static final FontAwesome5IconType business_time_s = on(FontAwesome5Solid.business_time).build();
    public static final FontAwesome5IconType calculator_s = on(FontAwesome5Solid.calculator).build();
    public static final FontAwesome5IconType calendar_alt_r = on(FontAwesome5Regular.calendar_alt).build();
    public static final FontAwesome5IconType calendar_alt_s = on(FontAwesome5Solid.calendar_alt).build();
    public static final FontAwesome5IconType calendar_check_r = on(FontAwesome5Regular.calendar_check).build();
    public static final FontAwesome5IconType calendar_check_s = on(FontAwesome5Solid.calendar_check).build();
    public static final FontAwesome5IconType calendar_day_s = on(FontAwesome5Solid.calendar_day).build();
    public static final FontAwesome5IconType calendar_minus_r = on(FontAwesome5Regular.calendar_minus).build();
    public static final FontAwesome5IconType calendar_minus_s = on(FontAwesome5Solid.calendar_minus).build();
    public static final FontAwesome5IconType calendar_plus_r = on(FontAwesome5Regular.calendar_plus).build();
    public static final FontAwesome5IconType calendar_plus_s = on(FontAwesome5Solid.calendar_plus).build();
    public static final FontAwesome5IconType calendar_r = on(FontAwesome5Regular.calendar).build();
    public static final FontAwesome5IconType calendar_s = on(FontAwesome5Solid.calendar).build();
    public static final FontAwesome5IconType calendar_times_r = on(FontAwesome5Regular.calendar_times).build();
    public static final FontAwesome5IconType calendar_times_s = on(FontAwesome5Solid.calendar_times).build();
    public static final FontAwesome5IconType calendar_week_s = on(FontAwesome5Solid.calendar_week).build();
    public static final FontAwesome5IconType camera_retro_s = on(FontAwesome5Solid.camera_retro).build();
    public static final FontAwesome5IconType camera_s = on(FontAwesome5Solid.camera).build();
    public static final FontAwesome5IconType campground_s = on(FontAwesome5Solid.campground).build();
    public static final FontAwesome5IconType candy_cane_s = on(FontAwesome5Solid.candy_cane).build();
    public static final FontAwesome5IconType cannabis_s = on(FontAwesome5Solid.cannabis).build();
    public static final FontAwesome5IconType capsules_s = on(FontAwesome5Solid.capsules).build();
    public static final FontAwesome5IconType car_alt_s = on(FontAwesome5Solid.car_alt).build();
    public static final FontAwesome5IconType car_battery_s = on(FontAwesome5Solid.car_battery).build();
    public static final FontAwesome5IconType car_crash_s = on(FontAwesome5Solid.car_crash).build();
    public static final FontAwesome5IconType car_s = on(FontAwesome5Solid.car).build();
    public static final FontAwesome5IconType car_side_s = on(FontAwesome5Solid.car_side).build();
    public static final FontAwesome5IconType caravan_s = on(FontAwesome5Solid.caravan).build();
    public static final FontAwesome5IconType caret_down_s = on(FontAwesome5Solid.caret_down).build();
    public static final FontAwesome5IconType caret_left_s = on(FontAwesome5Solid.caret_left).build();
    public static final FontAwesome5IconType caret_right_s = on(FontAwesome5Solid.caret_right).build();
    public static final FontAwesome5IconType caret_square_down_r = on(FontAwesome5Regular.caret_square_down).build();
    public static final FontAwesome5IconType caret_square_down_s = on(FontAwesome5Solid.caret_square_down).build();
    public static final FontAwesome5IconType caret_square_left_r = on(FontAwesome5Regular.caret_square_left).build();
    public static final FontAwesome5IconType caret_square_left_s = on(FontAwesome5Solid.caret_square_left).build();
    public static final FontAwesome5IconType caret_square_right_r = on(FontAwesome5Regular.caret_square_right).build();
    public static final FontAwesome5IconType caret_square_right_s = on(FontAwesome5Solid.caret_square_right).build();
    public static final FontAwesome5IconType caret_square_up_r = on(FontAwesome5Regular.caret_square_up).build();
    public static final FontAwesome5IconType caret_square_up_s = on(FontAwesome5Solid.caret_square_up).build();
    public static final FontAwesome5IconType caret_up_s = on(FontAwesome5Solid.caret_up).build();
    public static final FontAwesome5IconType carrot_s = on(FontAwesome5Solid.carrot).build();
    public static final FontAwesome5IconType cart_arrow_down_s = on(FontAwesome5Solid.cart_arrow_down).build();
    public static final FontAwesome5IconType cart_plus_s = on(FontAwesome5Solid.cart_plus).build();
    public static final FontAwesome5IconType cash_register_s = on(FontAwesome5Solid.cash_register).build();
    public static final FontAwesome5IconType cat_s = on(FontAwesome5Solid.cat).build();
    public static final FontAwesome5IconType certificate_s = on(FontAwesome5Solid.certificate).build();
    public static final FontAwesome5IconType chair_s = on(FontAwesome5Solid.chair).build();
    public static final FontAwesome5IconType chalkboard_s = on(FontAwesome5Solid.chalkboard).build();
    public static final FontAwesome5IconType chalkboard_teacher_s = on(FontAwesome5Solid.chalkboard_teacher).build();
    public static final FontAwesome5IconType charging_station_s = on(FontAwesome5Solid.charging_station).build();
    public static final FontAwesome5IconType chart_area_s = on(FontAwesome5Solid.chart_area).build();
    public static final FontAwesome5IconType chart_bar_r = on(FontAwesome5Regular.chart_bar).build();
    public static final FontAwesome5IconType chart_bar_s = on(FontAwesome5Solid.chart_bar).build();
    public static final FontAwesome5IconType chart_line_s = on(FontAwesome5Solid.chart_line).build();
    public static final FontAwesome5IconType chart_pie_s = on(FontAwesome5Solid.chart_pie).build();
    public static final FontAwesome5IconType check_circle_r = on(FontAwesome5Regular.check_circle).build();
    public static final FontAwesome5IconType check_circle_s = on(FontAwesome5Solid.check_circle).build();
    public static final FontAwesome5IconType check_double_s = on(FontAwesome5Solid.check_double).build();
    public static final FontAwesome5IconType check_s = on(FontAwesome5Solid.check).build();
    public static final FontAwesome5IconType check_square_r = on(FontAwesome5Regular.check_square).build();
    public static final FontAwesome5IconType check_square_s = on(FontAwesome5Solid.check_square).build();
    public static final FontAwesome5IconType cheese_s = on(FontAwesome5Solid.cheese).build();
    public static final FontAwesome5IconType chess_bishop_s = on(FontAwesome5Solid.chess_bishop).build();
    public static final FontAwesome5IconType chess_board_s = on(FontAwesome5Solid.chess_board).build();
    public static final FontAwesome5IconType chess_king_s = on(FontAwesome5Solid.chess_king).build();
    public static final FontAwesome5IconType chess_knight_s = on(FontAwesome5Solid.chess_knight).build();
    public static final FontAwesome5IconType chess_pawn_s = on(FontAwesome5Solid.chess_pawn).build();
    public static final FontAwesome5IconType chess_queen_s = on(FontAwesome5Solid.chess_queen).build();
    public static final FontAwesome5IconType chess_rook_s = on(FontAwesome5Solid.chess_rook).build();
    public static final FontAwesome5IconType chess_s = on(FontAwesome5Solid.chess).build();
    public static final FontAwesome5IconType chevron_circle_down_s = on(FontAwesome5Solid.chevron_circle_down).build();
    public static final FontAwesome5IconType chevron_circle_left_s = on(FontAwesome5Solid.chevron_circle_left).build();
    public static final FontAwesome5IconType chevron_circle_right_s = on(FontAwesome5Solid.chevron_circle_right).build();
    public static final FontAwesome5IconType chevron_circle_up_s = on(FontAwesome5Solid.chevron_circle_up).build();
    public static final FontAwesome5IconType chevron_down_s = on(FontAwesome5Solid.chevron_down).build();
    public static final FontAwesome5IconType chevron_left_s = on(FontAwesome5Solid.chevron_left).build();
    public static final FontAwesome5IconType chevron_right_s = on(FontAwesome5Solid.chevron_right).build();
    public static final FontAwesome5IconType chevron_up_s = on(FontAwesome5Solid.chevron_up).build();
    public static final FontAwesome5IconType child_s = on(FontAwesome5Solid.child).build();
    public static final FontAwesome5IconType church_s = on(FontAwesome5Solid.church).build();
    public static final FontAwesome5IconType circle_notch_s = on(FontAwesome5Solid.circle_notch).build();
    public static final FontAwesome5IconType circle_r = on(FontAwesome5Regular.circle).build();
    public static final FontAwesome5IconType circle_s = on(FontAwesome5Solid.circle).build();
    public static final FontAwesome5IconType city_s = on(FontAwesome5Solid.city).build();
    public static final FontAwesome5IconType clinic_medical_s = on(FontAwesome5Solid.clinic_medical).build();
    public static final FontAwesome5IconType clipboard_check_s = on(FontAwesome5Solid.clipboard_check).build();
    public static final FontAwesome5IconType clipboard_list_s = on(FontAwesome5Solid.clipboard_list).build();
    public static final FontAwesome5IconType clipboard_r = on(FontAwesome5Regular.clipboard).build();
    public static final FontAwesome5IconType clipboard_s = on(FontAwesome5Solid.clipboard).build();
    public static final FontAwesome5IconType clock_r = on(FontAwesome5Regular.clock).build();
    public static final FontAwesome5IconType clock_s = on(FontAwesome5Solid.clock).build();
    public static final FontAwesome5IconType clone_r = on(FontAwesome5Regular.clone).build();
    public static final FontAwesome5IconType clone_s = on(FontAwesome5Solid.clone).build();
    public static final FontAwesome5IconType closed_captioning_r = on(FontAwesome5Regular.closed_captioning).build();
    public static final FontAwesome5IconType closed_captioning_s = on(FontAwesome5Solid.closed_captioning).build();
    public static final FontAwesome5IconType cloud_download_alt_s = on(FontAwesome5Solid.cloud_download_alt).build();
    public static final FontAwesome5IconType cloud_meatball_s = on(FontAwesome5Solid.cloud_meatball).build();
    public static final FontAwesome5IconType cloud_moon_rain_s = on(FontAwesome5Solid.cloud_moon_rain).build();
    public static final FontAwesome5IconType cloud_moon_s = on(FontAwesome5Solid.cloud_moon).build();
    public static final FontAwesome5IconType cloud_rain_s = on(FontAwesome5Solid.cloud_rain).build();
    public static final FontAwesome5IconType cloud_s = on(FontAwesome5Solid.cloud).build();
    public static final FontAwesome5IconType cloud_showers_heavy_s = on(FontAwesome5Solid.cloud_showers_heavy).build();
    public static final FontAwesome5IconType cloud_sun_rain_s = on(FontAwesome5Solid.cloud_sun_rain).build();
    public static final FontAwesome5IconType cloud_sun_s = on(FontAwesome5Solid.cloud_sun).build();
    public static final FontAwesome5IconType cloud_upload_alt_s = on(FontAwesome5Solid.cloud_upload_alt).build();
    public static final FontAwesome5IconType cocktail_s = on(FontAwesome5Solid.cocktail).build();
    public static final FontAwesome5IconType code_branch_s = on(FontAwesome5Solid.code_branch).build();
    public static final FontAwesome5IconType code_s = on(FontAwesome5Solid.code).build();
    public static final FontAwesome5IconType coffee_s = on(FontAwesome5Solid.coffee).build();
    public static final FontAwesome5IconType cog_s = on(FontAwesome5Solid.cog).build();
    public static final FontAwesome5IconType cogs_s = on(FontAwesome5Solid.cogs).build();
    public static final FontAwesome5IconType coins_s = on(FontAwesome5Solid.coins).build();
    public static final FontAwesome5IconType columns_s = on(FontAwesome5Solid.columns).build();
    public static final FontAwesome5IconType comment_alt_r = on(FontAwesome5Regular.comment_alt).build();
    public static final FontAwesome5IconType comment_alt_s = on(FontAwesome5Solid.comment_alt).build();
    public static final FontAwesome5IconType comment_dollar_s = on(FontAwesome5Solid.comment_dollar).build();
    public static final FontAwesome5IconType comment_dots_r = on(FontAwesome5Regular.comment_dots).build();
    public static final FontAwesome5IconType comment_dots_s = on(FontAwesome5Solid.comment_dots).build();
    public static final FontAwesome5IconType comment_medical_s = on(FontAwesome5Solid.comment_medical).build();
    public static final FontAwesome5IconType comment_r = on(FontAwesome5Regular.comment).build();
    public static final FontAwesome5IconType comment_s = on(FontAwesome5Solid.comment).build();
    public static final FontAwesome5IconType comment_slash_s = on(FontAwesome5Solid.comment_slash).build();
    public static final FontAwesome5IconType comments_dollar_s = on(FontAwesome5Solid.comments_dollar).build();
    public static final FontAwesome5IconType comments_r = on(FontAwesome5Regular.comments).build();
    public static final FontAwesome5IconType comments_s = on(FontAwesome5Solid.comments).build();
    public static final FontAwesome5IconType compact_disc_s = on(FontAwesome5Solid.compact_disc).build();
    public static final FontAwesome5IconType compass_r = on(FontAwesome5Regular.compass).build();
    public static final FontAwesome5IconType compass_s = on(FontAwesome5Solid.compass).build();
    public static final FontAwesome5IconType compress_alt_s = on(FontAwesome5Solid.compress_alt).build();
    public static final FontAwesome5IconType compress_arrows_alt_s = on(FontAwesome5Solid.compress_arrows_alt).build();
    public static final FontAwesome5IconType compress_s = on(FontAwesome5Solid.compress).build();
    public static final FontAwesome5IconType concierge_bell_s = on(FontAwesome5Solid.concierge_bell).build();
    public static final FontAwesome5IconType cookie_bite_s = on(FontAwesome5Solid.cookie_bite).build();
    public static final FontAwesome5IconType cookie_s = on(FontAwesome5Solid.cookie).build();
    public static final FontAwesome5IconType copy_r = on(FontAwesome5Regular.copy).build();
    public static final FontAwesome5IconType copy_s = on(FontAwesome5Solid.copy).build();
    public static final FontAwesome5IconType copyright_r = on(FontAwesome5Regular.copyright).build();
    public static final FontAwesome5IconType copyright_s = on(FontAwesome5Solid.copyright).build();
    public static final FontAwesome5IconType couch_s = on(FontAwesome5Solid.couch).build();
    public static final FontAwesome5IconType credit_card_r = on(FontAwesome5Regular.credit_card).build();
    public static final FontAwesome5IconType credit_card_s = on(FontAwesome5Solid.credit_card).build();
    public static final FontAwesome5IconType crop_alt_s = on(FontAwesome5Solid.crop_alt).build();
    public static final FontAwesome5IconType crop_s = on(FontAwesome5Solid.crop).build();
    public static final FontAwesome5IconType cross_s = on(FontAwesome5Solid.cross).build();
    public static final FontAwesome5IconType crosshairs_s = on(FontAwesome5Solid.crosshairs).build();
    public static final FontAwesome5IconType crow_s = on(FontAwesome5Solid.crow).build();
    public static final FontAwesome5IconType crown_s = on(FontAwesome5Solid.crown).build();
    public static final FontAwesome5IconType crutch_s = on(FontAwesome5Solid.crutch).build();
    public static final FontAwesome5IconType cube_s = on(FontAwesome5Solid.cube).build();
    public static final FontAwesome5IconType cubes_s = on(FontAwesome5Solid.cubes).build();
    public static final FontAwesome5IconType cut_s = on(FontAwesome5Solid.cut).build();
    public static final FontAwesome5IconType database_s = on(FontAwesome5Solid.database).build();
    public static final FontAwesome5IconType deaf_s = on(FontAwesome5Solid.deaf).build();
    public static final FontAwesome5IconType democrat_s = on(FontAwesome5Solid.democrat).build();
    public static final FontAwesome5IconType desktop_s = on(FontAwesome5Solid.desktop).build();
    public static final FontAwesome5IconType dharmachakra_s = on(FontAwesome5Solid.dharmachakra).build();
    public static final FontAwesome5IconType diagnoses_s = on(FontAwesome5Solid.diagnoses).build();
    public static final FontAwesome5IconType dice_d20_s = on(FontAwesome5Solid.dice_d20).build();
    public static final FontAwesome5IconType dice_d6_s = on(FontAwesome5Solid.dice_d6).build();
    public static final FontAwesome5IconType dice_five_s = on(FontAwesome5Solid.dice_five).build();
    public static final FontAwesome5IconType dice_four_s = on(FontAwesome5Solid.dice_four).build();
    public static final FontAwesome5IconType dice_one_s = on(FontAwesome5Solid.dice_one).build();
    public static final FontAwesome5IconType dice_s = on(FontAwesome5Solid.dice).build();
    public static final FontAwesome5IconType dice_six_s = on(FontAwesome5Solid.dice_six).build();
    public static final FontAwesome5IconType dice_three_s = on(FontAwesome5Solid.dice_three).build();
    public static final FontAwesome5IconType dice_two_s = on(FontAwesome5Solid.dice_two).build();
    public static final FontAwesome5IconType digital_tachograph_s = on(FontAwesome5Solid.digital_tachograph).build();
    public static final FontAwesome5IconType directions_s = on(FontAwesome5Solid.directions).build();
    public static final FontAwesome5IconType disease_s = on(FontAwesome5Solid.disease).build();
    public static final FontAwesome5IconType divide_s = on(FontAwesome5Solid.divide).build();
    public static final FontAwesome5IconType dizzy_r = on(FontAwesome5Regular.dizzy).build();
    public static final FontAwesome5IconType dizzy_s = on(FontAwesome5Solid.dizzy).build();
    public static final FontAwesome5IconType dna_s = on(FontAwesome5Solid.dna).build();
    public static final FontAwesome5IconType dog_s = on(FontAwesome5Solid.dog).build();
    public static final FontAwesome5IconType dollar_sign_s = on(FontAwesome5Solid.dollar_sign).build();
    public static final FontAwesome5IconType dolly_flatbed_s = on(FontAwesome5Solid.dolly_flatbed).build();
    public static final FontAwesome5IconType dolly_s = on(FontAwesome5Solid.dolly).build();
    public static final FontAwesome5IconType donate_s = on(FontAwesome5Solid.donate).build();
    public static final FontAwesome5IconType door_closed_s = on(FontAwesome5Solid.door_closed).build();
    public static final FontAwesome5IconType door_open_s = on(FontAwesome5Solid.door_open).build();
    public static final FontAwesome5IconType dot_circle_r = on(FontAwesome5Regular.dot_circle).build();
    public static final FontAwesome5IconType dot_circle_s = on(FontAwesome5Solid.dot_circle).build();
    public static final FontAwesome5IconType dove_s = on(FontAwesome5Solid.dove).build();
    public static final FontAwesome5IconType download_s = on(FontAwesome5Solid.download).build();
    public static final FontAwesome5IconType drafting_compass_s = on(FontAwesome5Solid.drafting_compass).build();
    public static final FontAwesome5IconType dragon_s = on(FontAwesome5Solid.dragon).build();
    public static final FontAwesome5IconType draw_polygon_s = on(FontAwesome5Solid.draw_polygon).build();
    public static final FontAwesome5IconType drum_s = on(FontAwesome5Solid.drum).build();
    public static final FontAwesome5IconType drum_steelpan_s = on(FontAwesome5Solid.drum_steelpan).build();
    public static final FontAwesome5IconType drumstick_bite_s = on(FontAwesome5Solid.drumstick_bite).build();
    public static final FontAwesome5IconType dumbbell_s = on(FontAwesome5Solid.dumbbell).build();
    public static final FontAwesome5IconType dumpster_fire_s = on(FontAwesome5Solid.dumpster_fire).build();
    public static final FontAwesome5IconType dumpster_s = on(FontAwesome5Solid.dumpster).build();
    public static final FontAwesome5IconType dungeon_s = on(FontAwesome5Solid.dungeon).build();
    public static final FontAwesome5IconType edit_r = on(FontAwesome5Regular.edit).build();
    public static final FontAwesome5IconType edit_s = on(FontAwesome5Solid.edit).build();
    public static final FontAwesome5IconType egg_s = on(FontAwesome5Solid.egg).build();
    public static final FontAwesome5IconType eject_s = on(FontAwesome5Solid.eject).build();
    public static final FontAwesome5IconType ellipsis_h_s = on(FontAwesome5Solid.ellipsis_h).build();
    public static final FontAwesome5IconType ellipsis_v_s = on(FontAwesome5Solid.ellipsis_v).build();
    public static final FontAwesome5IconType envelope_open_r = on(FontAwesome5Regular.envelope_open).build();
    public static final FontAwesome5IconType envelope_open_s = on(FontAwesome5Solid.envelope_open).build();
    public static final FontAwesome5IconType envelope_open_text_s = on(FontAwesome5Solid.envelope_open_text).build();
    public static final FontAwesome5IconType envelope_r = on(FontAwesome5Regular.envelope).build();
    public static final FontAwesome5IconType envelope_s = on(FontAwesome5Solid.envelope).build();
    public static final FontAwesome5IconType envelope_square_s = on(FontAwesome5Solid.envelope_square).build();
    public static final FontAwesome5IconType equals_s = on(FontAwesome5Solid.equals).build();
    public static final FontAwesome5IconType eraser_s = on(FontAwesome5Solid.eraser).build();
    public static final FontAwesome5IconType ethernet_s = on(FontAwesome5Solid.ethernet).build();
    public static final FontAwesome5IconType euro_sign_s = on(FontAwesome5Solid.euro_sign).build();
    public static final FontAwesome5IconType exchange_alt_s = on(FontAwesome5Solid.exchange_alt).build();
    public static final FontAwesome5IconType exclamation_circle_s = on(FontAwesome5Solid.exclamation_circle).build();
    public static final FontAwesome5IconType exclamation_s = on(FontAwesome5Solid.exclamation).build();
    public static final FontAwesome5IconType exclamation_triangle_s = on(FontAwesome5Solid.exclamation_triangle).build();
    public static final FontAwesome5IconType expand_alt_s = on(FontAwesome5Solid.expand_alt).build();
    public static final FontAwesome5IconType expand_arrows_alt_s = on(FontAwesome5Solid.expand_arrows_alt).build();
    public static final FontAwesome5IconType expand_s = on(FontAwesome5Solid.expand).build();
    public static final FontAwesome5IconType external_link_alt_s = on(FontAwesome5Solid.external_link_alt).build();
    public static final FontAwesome5IconType external_link_square_alt_s = on(FontAwesome5Solid.external_link_square_alt).build();
    public static final FontAwesome5IconType eye_dropper_s = on(FontAwesome5Solid.eye_dropper).build();
    public static final FontAwesome5IconType eye_r = on(FontAwesome5Regular.eye).build();
    public static final FontAwesome5IconType eye_s = on(FontAwesome5Solid.eye).build();
    public static final FontAwesome5IconType eye_slash_r = on(FontAwesome5Regular.eye_slash).build();
    public static final FontAwesome5IconType eye_slash_s = on(FontAwesome5Solid.eye_slash).build();
    public static final FontAwesome5IconType fan_s = on(FontAwesome5Solid.fan).build();
    public static final FontAwesome5IconType fast_backward_s = on(FontAwesome5Solid.fast_backward).build();
    public static final FontAwesome5IconType fast_forward_s = on(FontAwesome5Solid.fast_forward).build();
    public static final FontAwesome5IconType faucet_s = on(FontAwesome5Solid.faucet).build();
    public static final FontAwesome5IconType fax_s = on(FontAwesome5Solid.fax).build();
    public static final FontAwesome5IconType feather_alt_s = on(FontAwesome5Solid.feather_alt).build();
    public static final FontAwesome5IconType feather_s = on(FontAwesome5Solid.feather).build();
    public static final FontAwesome5IconType female_s = on(FontAwesome5Solid.female).build();
    public static final FontAwesome5IconType fighter_jet_s = on(FontAwesome5Solid.fighter_jet).build();
    public static final FontAwesome5IconType file_alt_r = on(FontAwesome5Regular.file_alt).build();
    public static final FontAwesome5IconType file_alt_s = on(FontAwesome5Solid.file_alt).build();
    public static final FontAwesome5IconType file_archive_r = on(FontAwesome5Regular.file_archive).build();
    public static final FontAwesome5IconType file_archive_s = on(FontAwesome5Solid.file_archive).build();
    public static final FontAwesome5IconType file_audio_r = on(FontAwesome5Regular.file_audio).build();
    public static final FontAwesome5IconType file_audio_s = on(FontAwesome5Solid.file_audio).build();
    public static final FontAwesome5IconType file_code_r = on(FontAwesome5Regular.file_code).build();
    public static final FontAwesome5IconType file_code_s = on(FontAwesome5Solid.file_code).build();
    public static final FontAwesome5IconType file_contract_s = on(FontAwesome5Solid.file_contract).build();
    public static final FontAwesome5IconType file_csv_s = on(FontAwesome5Solid.file_csv).build();
    public static final FontAwesome5IconType file_download_s = on(FontAwesome5Solid.file_download).build();
    public static final FontAwesome5IconType file_excel_r = on(FontAwesome5Regular.file_excel).build();
    public static final FontAwesome5IconType file_excel_s = on(FontAwesome5Solid.file_excel).build();
    public static final FontAwesome5IconType file_export_s = on(FontAwesome5Solid.file_export).build();
    public static final FontAwesome5IconType file_image_r = on(FontAwesome5Regular.file_image).build();
    public static final FontAwesome5IconType file_image_s = on(FontAwesome5Solid.file_image).build();
    public static final FontAwesome5IconType file_import_s = on(FontAwesome5Solid.file_import).build();
    public static final FontAwesome5IconType file_invoice_dollar_s = on(FontAwesome5Solid.file_invoice_dollar).build();
    public static final FontAwesome5IconType file_invoice_s = on(FontAwesome5Solid.file_invoice).build();
    public static final FontAwesome5IconType file_medical_alt_s = on(FontAwesome5Solid.file_medical_alt).build();
    public static final FontAwesome5IconType file_medical_s = on(FontAwesome5Solid.file_medical).build();
    public static final FontAwesome5IconType file_pdf_r = on(FontAwesome5Regular.file_pdf).build();
    public static final FontAwesome5IconType file_pdf_s = on(FontAwesome5Solid.file_pdf).build();
    public static final FontAwesome5IconType file_powerpoint_r = on(FontAwesome5Regular.file_powerpoint).build();
    public static final FontAwesome5IconType file_powerpoint_s = on(FontAwesome5Solid.file_powerpoint).build();
    public static final FontAwesome5IconType file_prescription_s = on(FontAwesome5Solid.file_prescription).build();
    public static final FontAwesome5IconType file_r = on(FontAwesome5Regular.file).build();
    public static final FontAwesome5IconType file_s = on(FontAwesome5Solid.file).build();
    public static final FontAwesome5IconType file_signature_s = on(FontAwesome5Solid.file_signature).build();
    public static final FontAwesome5IconType file_upload_s = on(FontAwesome5Solid.file_upload).build();
    public static final FontAwesome5IconType file_video_r = on(FontAwesome5Regular.file_video).build();
    public static final FontAwesome5IconType file_video_s = on(FontAwesome5Solid.file_video).build();
    public static final FontAwesome5IconType file_word_r = on(FontAwesome5Regular.file_word).build();
    public static final FontAwesome5IconType file_word_s = on(FontAwesome5Solid.file_word).build();
    public static final FontAwesome5IconType fill_drip_s = on(FontAwesome5Solid.fill_drip).build();
    public static final FontAwesome5IconType fill_s = on(FontAwesome5Solid.fill).build();
    public static final FontAwesome5IconType film_s = on(FontAwesome5Solid.film).build();
    public static final FontAwesome5IconType filter_s = on(FontAwesome5Solid.filter).build();
    public static final FontAwesome5IconType fingerprint_s = on(FontAwesome5Solid.fingerprint).build();
    public static final FontAwesome5IconType fire_alt_s = on(FontAwesome5Solid.fire_alt).build();
    public static final FontAwesome5IconType fire_extinguisher_s = on(FontAwesome5Solid.fire_extinguisher).build();
    public static final FontAwesome5IconType fire_s = on(FontAwesome5Solid.fire).build();
    public static final FontAwesome5IconType first_aid_s = on(FontAwesome5Solid.first_aid).build();
    public static final FontAwesome5IconType fish_s = on(FontAwesome5Solid.fish).build();
    public static final FontAwesome5IconType fist_raised_s = on(FontAwesome5Solid.fist_raised).build();
    public static final FontAwesome5IconType flag_checkered_s = on(FontAwesome5Solid.flag_checkered).build();
    public static final FontAwesome5IconType flag_r = on(FontAwesome5Regular.flag).build();
    public static final FontAwesome5IconType flag_s = on(FontAwesome5Solid.flag).build();
    public static final FontAwesome5IconType flag_usa_s = on(FontAwesome5Solid.flag_usa).build();
    public static final FontAwesome5IconType flask_s = on(FontAwesome5Solid.flask).build();
    public static final FontAwesome5IconType flushed_r = on(FontAwesome5Regular.flushed).build();
    public static final FontAwesome5IconType flushed_s = on(FontAwesome5Solid.flushed).build();
    public static final FontAwesome5IconType folder_minus_s = on(FontAwesome5Solid.folder_minus).build();
    public static final FontAwesome5IconType folder_open_r = on(FontAwesome5Regular.folder_open).build();
    public static final FontAwesome5IconType folder_open_s = on(FontAwesome5Solid.folder_open).build();
    public static final FontAwesome5IconType folder_plus_s = on(FontAwesome5Solid.folder_plus).build();
    public static final FontAwesome5IconType folder_r = on(FontAwesome5Regular.folder).build();
    public static final FontAwesome5IconType folder_s = on(FontAwesome5Solid.folder).build();
    public static final FontAwesome5IconType font_awesome_logo_full_r = on(FontAwesome5Regular.font_awesome_logo_full).build();
    public static final FontAwesome5IconType font_awesome_logo_full_s = on(FontAwesome5Solid.font_awesome_logo_full).build();
    public static final FontAwesome5IconType font_s = on(FontAwesome5Solid.font).build();
    public static final FontAwesome5IconType football_ball_s = on(FontAwesome5Solid.football_ball).build();
    public static final FontAwesome5IconType forward_s = on(FontAwesome5Solid.forward).build();
    public static final FontAwesome5IconType frog_s = on(FontAwesome5Solid.frog).build();
    public static final FontAwesome5IconType frown_open_r = on(FontAwesome5Regular.frown_open).build();
    public static final FontAwesome5IconType frown_open_s = on(FontAwesome5Solid.frown_open).build();
    public static final FontAwesome5IconType frown_r = on(FontAwesome5Regular.frown).build();
    public static final FontAwesome5IconType frown_s = on(FontAwesome5Solid.frown).build();
    public static final FontAwesome5IconType funnel_dollar_s = on(FontAwesome5Solid.funnel_dollar).build();
    public static final FontAwesome5IconType futbol_r = on(FontAwesome5Regular.futbol).build();
    public static final FontAwesome5IconType futbol_s = on(FontAwesome5Solid.futbol).build();
    public static final FontAwesome5IconType gamepad_s = on(FontAwesome5Solid.gamepad).build();
    public static final FontAwesome5IconType gas_pump_s = on(FontAwesome5Solid.gas_pump).build();
    public static final FontAwesome5IconType gavel_s = on(FontAwesome5Solid.gavel).build();
    public static final FontAwesome5IconType gem_r = on(FontAwesome5Regular.gem).build();
    public static final FontAwesome5IconType gem_s = on(FontAwesome5Solid.gem).build();
    public static final FontAwesome5IconType genderless_s = on(FontAwesome5Solid.genderless).build();
    public static final FontAwesome5IconType ghost_s = on(FontAwesome5Solid.ghost).build();
    public static final FontAwesome5IconType gift_s = on(FontAwesome5Solid.gift).build();
    public static final FontAwesome5IconType gifts_s = on(FontAwesome5Solid.gifts).build();
    public static final FontAwesome5IconType glass_cheers_s = on(FontAwesome5Solid.glass_cheers).build();
    public static final FontAwesome5IconType glass_martini_alt_s = on(FontAwesome5Solid.glass_martini_alt).build();
    public static final FontAwesome5IconType glass_martini_s = on(FontAwesome5Solid.glass_martini).build();
    public static final FontAwesome5IconType glass_whiskey_s = on(FontAwesome5Solid.glass_whiskey).build();
    public static final FontAwesome5IconType glasses_s = on(FontAwesome5Solid.glasses).build();
    public static final FontAwesome5IconType globe_africa_s = on(FontAwesome5Solid.globe_africa).build();
    public static final FontAwesome5IconType globe_americas_s = on(FontAwesome5Solid.globe_americas).build();
    public static final FontAwesome5IconType globe_asia_s = on(FontAwesome5Solid.globe_asia).build();
    public static final FontAwesome5IconType globe_europe_s = on(FontAwesome5Solid.globe_europe).build();
    public static final FontAwesome5IconType globe_s = on(FontAwesome5Solid.globe).build();
    public static final FontAwesome5IconType golf_ball_s = on(FontAwesome5Solid.golf_ball).build();
    public static final FontAwesome5IconType gopuram_s = on(FontAwesome5Solid.gopuram).build();
    public static final FontAwesome5IconType graduation_cap_s = on(FontAwesome5Solid.graduation_cap).build();
    public static final FontAwesome5IconType greater_than_equal_s = on(FontAwesome5Solid.greater_than_equal).build();
    public static final FontAwesome5IconType greater_than_s = on(FontAwesome5Solid.greater_than).build();
    public static final FontAwesome5IconType grimace_r = on(FontAwesome5Regular.grimace).build();
    public static final FontAwesome5IconType grimace_s = on(FontAwesome5Solid.grimace).build();
    public static final FontAwesome5IconType grin_alt_r = on(FontAwesome5Regular.grin_alt).build();
    public static final FontAwesome5IconType grin_alt_s = on(FontAwesome5Solid.grin_alt).build();
    public static final FontAwesome5IconType grin_beam_r = on(FontAwesome5Regular.grin_beam).build();
    public static final FontAwesome5IconType grin_beam_s = on(FontAwesome5Solid.grin_beam).build();
    public static final FontAwesome5IconType grin_beam_sweat_r = on(FontAwesome5Regular.grin_beam_sweat).build();
    public static final FontAwesome5IconType grin_beam_sweat_s = on(FontAwesome5Solid.grin_beam_sweat).build();
    public static final FontAwesome5IconType grin_hearts_r = on(FontAwesome5Regular.grin_hearts).build();
    public static final FontAwesome5IconType grin_hearts_s = on(FontAwesome5Solid.grin_hearts).build();
    public static final FontAwesome5IconType grin_r = on(FontAwesome5Regular.grin).build();
    public static final FontAwesome5IconType grin_s = on(FontAwesome5Solid.grin).build();
    public static final FontAwesome5IconType grin_squint_r = on(FontAwesome5Regular.grin_squint).build();
    public static final FontAwesome5IconType grin_squint_s = on(FontAwesome5Solid.grin_squint).build();
    public static final FontAwesome5IconType grin_squint_tears_r = on(FontAwesome5Regular.grin_squint_tears).build();
    public static final FontAwesome5IconType grin_squint_tears_s = on(FontAwesome5Solid.grin_squint_tears).build();
    public static final FontAwesome5IconType grin_stars_r = on(FontAwesome5Regular.grin_stars).build();
    public static final FontAwesome5IconType grin_stars_s = on(FontAwesome5Solid.grin_stars).build();
    public static final FontAwesome5IconType grin_tears_r = on(FontAwesome5Regular.grin_tears).build();
    public static final FontAwesome5IconType grin_tears_s = on(FontAwesome5Solid.grin_tears).build();
    public static final FontAwesome5IconType grin_tongue_r = on(FontAwesome5Regular.grin_tongue).build();
    public static final FontAwesome5IconType grin_tongue_s = on(FontAwesome5Solid.grin_tongue).build();
    public static final FontAwesome5IconType grin_tongue_squint_r = on(FontAwesome5Regular.grin_tongue_squint).build();
    public static final FontAwesome5IconType grin_tongue_squint_s = on(FontAwesome5Solid.grin_tongue_squint).build();
    public static final FontAwesome5IconType grin_tongue_wink_r = on(FontAwesome5Regular.grin_tongue_wink).build();
    public static final FontAwesome5IconType grin_tongue_wink_s = on(FontAwesome5Solid.grin_tongue_wink).build();
    public static final FontAwesome5IconType grin_wink_r = on(FontAwesome5Regular.grin_wink).build();
    public static final FontAwesome5IconType grin_wink_s = on(FontAwesome5Solid.grin_wink).build();
    public static final FontAwesome5IconType grip_horizontal_s = on(FontAwesome5Solid.grip_horizontal).build();
    public static final FontAwesome5IconType grip_lines_s = on(FontAwesome5Solid.grip_lines).build();
    public static final FontAwesome5IconType grip_lines_vertical_s = on(FontAwesome5Solid.grip_lines_vertical).build();
    public static final FontAwesome5IconType grip_vertical_s = on(FontAwesome5Solid.grip_vertical).build();
    public static final FontAwesome5IconType guitar_s = on(FontAwesome5Solid.guitar).build();
    public static final FontAwesome5IconType h_square_s = on(FontAwesome5Solid.h_square).build();
    public static final FontAwesome5IconType hamburger_s = on(FontAwesome5Solid.hamburger).build();
    public static final FontAwesome5IconType hammer_s = on(FontAwesome5Solid.hammer).build();
    public static final FontAwesome5IconType hamsa_s = on(FontAwesome5Solid.hamsa).build();
    public static final FontAwesome5IconType hand_holding_heart_s = on(FontAwesome5Solid.hand_holding_heart).build();
    public static final FontAwesome5IconType hand_holding_medical_s = on(FontAwesome5Solid.hand_holding_medical).build();
    public static final FontAwesome5IconType hand_holding_s = on(FontAwesome5Solid.hand_holding).build();
    public static final FontAwesome5IconType hand_holding_usd_s = on(FontAwesome5Solid.hand_holding_usd).build();
    public static final FontAwesome5IconType hand_holding_water_s = on(FontAwesome5Solid.hand_holding_water).build();
    public static final FontAwesome5IconType hand_lizard_r = on(FontAwesome5Regular.hand_lizard).build();
    public static final FontAwesome5IconType hand_lizard_s = on(FontAwesome5Solid.hand_lizard).build();
    public static final FontAwesome5IconType hand_middle_finger_s = on(FontAwesome5Solid.hand_middle_finger).build();
    public static final FontAwesome5IconType hand_paper_r = on(FontAwesome5Regular.hand_paper).build();
    public static final FontAwesome5IconType hand_paper_s = on(FontAwesome5Solid.hand_paper).build();
    public static final FontAwesome5IconType hand_peace_r = on(FontAwesome5Regular.hand_peace).build();
    public static final FontAwesome5IconType hand_peace_s = on(FontAwesome5Solid.hand_peace).build();
    public static final FontAwesome5IconType hand_point_down_r = on(FontAwesome5Regular.hand_point_down).build();
    public static final FontAwesome5IconType hand_point_down_s = on(FontAwesome5Solid.hand_point_down).build();
    public static final FontAwesome5IconType hand_point_left_r = on(FontAwesome5Regular.hand_point_left).build();
    public static final FontAwesome5IconType hand_point_left_s = on(FontAwesome5Solid.hand_point_left).build();
    public static final FontAwesome5IconType hand_point_right_r = on(FontAwesome5Regular.hand_point_right).build();
    public static final FontAwesome5IconType hand_point_right_s = on(FontAwesome5Solid.hand_point_right).build();
    public static final FontAwesome5IconType hand_point_up_r = on(FontAwesome5Regular.hand_point_up).build();
    public static final FontAwesome5IconType hand_point_up_s = on(FontAwesome5Solid.hand_point_up).build();
    public static final FontAwesome5IconType hand_pointer_r = on(FontAwesome5Regular.hand_pointer).build();
    public static final FontAwesome5IconType hand_pointer_s = on(FontAwesome5Solid.hand_pointer).build();
    public static final FontAwesome5IconType hand_rock_r = on(FontAwesome5Regular.hand_rock).build();
    public static final FontAwesome5IconType hand_rock_s = on(FontAwesome5Solid.hand_rock).build();
    public static final FontAwesome5IconType hand_scissors_r = on(FontAwesome5Regular.hand_scissors).build();
    public static final FontAwesome5IconType hand_scissors_s = on(FontAwesome5Solid.hand_scissors).build();
    public static final FontAwesome5IconType hand_sparkles_s = on(FontAwesome5Solid.hand_sparkles).build();
    public static final FontAwesome5IconType hand_spock_r = on(FontAwesome5Regular.hand_spock).build();
    public static final FontAwesome5IconType hand_spock_s = on(FontAwesome5Solid.hand_spock).build();
    public static final FontAwesome5IconType hands_helping_s = on(FontAwesome5Solid.hands_helping).build();
    public static final FontAwesome5IconType hands_s = on(FontAwesome5Solid.hands).build();
    public static final FontAwesome5IconType hands_wash_s = on(FontAwesome5Solid.hands_wash).build();
    public static final FontAwesome5IconType handshake_alt_slash_s = on(FontAwesome5Solid.handshake_alt_slash).build();
    public static final FontAwesome5IconType handshake_r = on(FontAwesome5Regular.handshake).build();
    public static final FontAwesome5IconType handshake_s = on(FontAwesome5Solid.handshake).build();
    public static final FontAwesome5IconType handshake_slash_s = on(FontAwesome5Solid.handshake_slash).build();
    public static final FontAwesome5IconType hanukiah_s = on(FontAwesome5Solid.hanukiah).build();
    public static final FontAwesome5IconType hard_hat_s = on(FontAwesome5Solid.hard_hat).build();
    public static final FontAwesome5IconType hashtag_s = on(FontAwesome5Solid.hashtag).build();
    public static final FontAwesome5IconType hat_cowboy_s = on(FontAwesome5Solid.hat_cowboy).build();
    public static final FontAwesome5IconType hat_cowboy_side_s = on(FontAwesome5Solid.hat_cowboy_side).build();
    public static final FontAwesome5IconType hat_wizard_s = on(FontAwesome5Solid.hat_wizard).build();
    public static final FontAwesome5IconType hdd_r = on(FontAwesome5Regular.hdd).build();
    public static final FontAwesome5IconType hdd_s = on(FontAwesome5Solid.hdd).build();
    public static final FontAwesome5IconType head_side_cough_s = on(FontAwesome5Solid.head_side_cough).build();
    public static final FontAwesome5IconType head_side_cough_slash_s = on(FontAwesome5Solid.head_side_cough_slash).build();
    public static final FontAwesome5IconType head_side_mask_s = on(FontAwesome5Solid.head_side_mask).build();
    public static final FontAwesome5IconType head_side_virus_s = on(FontAwesome5Solid.head_side_virus).build();
    public static final FontAwesome5IconType heading_s = on(FontAwesome5Solid.heading).build();
    public static final FontAwesome5IconType headphones_alt_s = on(FontAwesome5Solid.headphones_alt).build();
    public static final FontAwesome5IconType headphones_s = on(FontAwesome5Solid.headphones).build();
    public static final FontAwesome5IconType headset_s = on(FontAwesome5Solid.headset).build();
    public static final FontAwesome5IconType heart_broken_s = on(FontAwesome5Solid.heart_broken).build();
    public static final FontAwesome5IconType heart_r = on(FontAwesome5Regular.heart).build();
    public static final FontAwesome5IconType heart_s = on(FontAwesome5Solid.heart).build();
    public static final FontAwesome5IconType heartbeat_s = on(FontAwesome5Solid.heartbeat).build();
    public static final FontAwesome5IconType helicopter_s = on(FontAwesome5Solid.helicopter).build();
    public static final FontAwesome5IconType highlighter_s = on(FontAwesome5Solid.highlighter).build();
    public static final FontAwesome5IconType hiking_s = on(FontAwesome5Solid.hiking).build();
    public static final FontAwesome5IconType hippo_s = on(FontAwesome5Solid.hippo).build();
    public static final FontAwesome5IconType history_s = on(FontAwesome5Solid.history).build();
    public static final FontAwesome5IconType hockey_puck_s = on(FontAwesome5Solid.hockey_puck).build();
    public static final FontAwesome5IconType holly_berry_s = on(FontAwesome5Solid.holly_berry).build();
    public static final FontAwesome5IconType home_s = on(FontAwesome5Solid.home).build();
    public static final FontAwesome5IconType horse_head_s = on(FontAwesome5Solid.horse_head).build();
    public static final FontAwesome5IconType horse_s = on(FontAwesome5Solid.horse).build();
    public static final FontAwesome5IconType hospital_alt_s = on(FontAwesome5Solid.hospital_alt).build();
    public static final FontAwesome5IconType hospital_r = on(FontAwesome5Regular.hospital).build();
    public static final FontAwesome5IconType hospital_s = on(FontAwesome5Solid.hospital).build();
    public static final FontAwesome5IconType hospital_symbol_s = on(FontAwesome5Solid.hospital_symbol).build();
    public static final FontAwesome5IconType hospital_user_s = on(FontAwesome5Solid.hospital_user).build();
    public static final FontAwesome5IconType hot_tub_s = on(FontAwesome5Solid.hot_tub).build();
    public static final FontAwesome5IconType hotdog_s = on(FontAwesome5Solid.hotdog).build();
    public static final FontAwesome5IconType hotel_s = on(FontAwesome5Solid.hotel).build();
    public static final FontAwesome5IconType hourglass_end_s = on(FontAwesome5Solid.hourglass_end).build();
    public static final FontAwesome5IconType hourglass_half_s = on(FontAwesome5Solid.hourglass_half).build();
    public static final FontAwesome5IconType hourglass_r = on(FontAwesome5Regular.hourglass).build();
    public static final FontAwesome5IconType hourglass_s = on(FontAwesome5Solid.hourglass).build();
    public static final FontAwesome5IconType hourglass_start_s = on(FontAwesome5Solid.hourglass_start).build();
    public static final FontAwesome5IconType house_damage_s = on(FontAwesome5Solid.house_damage).build();
    public static final FontAwesome5IconType house_user_s = on(FontAwesome5Solid.house_user).build();
    public static final FontAwesome5IconType hryvnia_s = on(FontAwesome5Solid.hryvnia).build();
    public static final FontAwesome5IconType i_cursor_s = on(FontAwesome5Solid.i_cursor).build();
    public static final FontAwesome5IconType ice_cream_s = on(FontAwesome5Solid.ice_cream).build();
    public static final FontAwesome5IconType icicles_s = on(FontAwesome5Solid.icicles).build();
    public static final FontAwesome5IconType icons_s = on(FontAwesome5Solid.icons).build();
    public static final FontAwesome5IconType id_badge_r = on(FontAwesome5Regular.id_badge).build();
    public static final FontAwesome5IconType id_badge_s = on(FontAwesome5Solid.id_badge).build();
    public static final FontAwesome5IconType id_card_alt_s = on(FontAwesome5Solid.id_card_alt).build();
    public static final FontAwesome5IconType id_card_r = on(FontAwesome5Regular.id_card).build();
    public static final FontAwesome5IconType id_card_s = on(FontAwesome5Solid.id_card).build();
    public static final FontAwesome5IconType igloo_s = on(FontAwesome5Solid.igloo).build();
    public static final FontAwesome5IconType image_r = on(FontAwesome5Regular.image).build();
    public static final FontAwesome5IconType image_s = on(FontAwesome5Solid.image).build();
    public static final FontAwesome5IconType images_r = on(FontAwesome5Regular.images).build();
    public static final FontAwesome5IconType images_s = on(FontAwesome5Solid.images).build();
    public static final FontAwesome5IconType inbox_s = on(FontAwesome5Solid.inbox).build();
    public static final FontAwesome5IconType indent_s = on(FontAwesome5Solid.indent).build();
    public static final FontAwesome5IconType industry_s = on(FontAwesome5Solid.industry).build();
    public static final FontAwesome5IconType infinity_s = on(FontAwesome5Solid.infinity).build();
    public static final FontAwesome5IconType info_circle_s = on(FontAwesome5Solid.info_circle).build();
    public static final FontAwesome5IconType info_s = on(FontAwesome5Solid.info).build();
    public static final FontAwesome5IconType italic_s = on(FontAwesome5Solid.italic).build();
    public static final FontAwesome5IconType jedi_s = on(FontAwesome5Solid.jedi).build();
    public static final FontAwesome5IconType joint_s = on(FontAwesome5Solid.joint).build();
    public static final FontAwesome5IconType journal_whills_s = on(FontAwesome5Solid.journal_whills).build();
    public static final FontAwesome5IconType kaaba_s = on(FontAwesome5Solid.kaaba).build();
    public static final FontAwesome5IconType key_s = on(FontAwesome5Solid.key).build();
    public static final FontAwesome5IconType keyboard_r = on(FontAwesome5Regular.keyboard).build();
    public static final FontAwesome5IconType keyboard_s = on(FontAwesome5Solid.keyboard).build();
    public static final FontAwesome5IconType khanda_s = on(FontAwesome5Solid.khanda).build();
    public static final FontAwesome5IconType kiss_beam_r = on(FontAwesome5Regular.kiss_beam).build();
    public static final FontAwesome5IconType kiss_beam_s = on(FontAwesome5Solid.kiss_beam).build();
    public static final FontAwesome5IconType kiss_r = on(FontAwesome5Regular.kiss).build();
    public static final FontAwesome5IconType kiss_s = on(FontAwesome5Solid.kiss).build();
    public static final FontAwesome5IconType kiss_wink_heart_r = on(FontAwesome5Regular.kiss_wink_heart).build();
    public static final FontAwesome5IconType kiss_wink_heart_s = on(FontAwesome5Solid.kiss_wink_heart).build();
    public static final FontAwesome5IconType kiwi_bird_s = on(FontAwesome5Solid.kiwi_bird).build();
    public static final FontAwesome5IconType landmark_s = on(FontAwesome5Solid.landmark).build();
    public static final FontAwesome5IconType language_s = on(FontAwesome5Solid.language).build();
    public static final FontAwesome5IconType laptop_code_s = on(FontAwesome5Solid.laptop_code).build();
    public static final FontAwesome5IconType laptop_house_s = on(FontAwesome5Solid.laptop_house).build();
    public static final FontAwesome5IconType laptop_medical_s = on(FontAwesome5Solid.laptop_medical).build();
    public static final FontAwesome5IconType laptop_s = on(FontAwesome5Solid.laptop).build();
    public static final FontAwesome5IconType laugh_beam_r = on(FontAwesome5Regular.laugh_beam).build();
    public static final FontAwesome5IconType laugh_beam_s = on(FontAwesome5Solid.laugh_beam).build();
    public static final FontAwesome5IconType laugh_r = on(FontAwesome5Regular.laugh).build();
    public static final FontAwesome5IconType laugh_s = on(FontAwesome5Solid.laugh).build();
    public static final FontAwesome5IconType laugh_squint_r = on(FontAwesome5Regular.laugh_squint).build();
    public static final FontAwesome5IconType laugh_squint_s = on(FontAwesome5Solid.laugh_squint).build();
    public static final FontAwesome5IconType laugh_wink_r = on(FontAwesome5Regular.laugh_wink).build();
    public static final FontAwesome5IconType laugh_wink_s = on(FontAwesome5Solid.laugh_wink).build();
    public static final FontAwesome5IconType layer_group_s = on(FontAwesome5Solid.layer_group).build();
    public static final FontAwesome5IconType leaf_s = on(FontAwesome5Solid.leaf).build();
    public static final FontAwesome5IconType lemon_r = on(FontAwesome5Regular.lemon).build();
    public static final FontAwesome5IconType lemon_s = on(FontAwesome5Solid.lemon).build();
    public static final FontAwesome5IconType less_than_equal_s = on(FontAwesome5Solid.less_than_equal).build();
    public static final FontAwesome5IconType less_than_s = on(FontAwesome5Solid.less_than).build();
    public static final FontAwesome5IconType level_down_alt_s = on(FontAwesome5Solid.level_down_alt).build();
    public static final FontAwesome5IconType level_up_alt_s = on(FontAwesome5Solid.level_up_alt).build();
    public static final FontAwesome5IconType life_ring_r = on(FontAwesome5Regular.life_ring).build();
    public static final FontAwesome5IconType life_ring_s = on(FontAwesome5Solid.life_ring).build();
    public static final FontAwesome5IconType lightbulb_r = on(FontAwesome5Regular.lightbulb).build();
    public static final FontAwesome5IconType lightbulb_s = on(FontAwesome5Solid.lightbulb).build();
    public static final FontAwesome5IconType link_s = on(FontAwesome5Solid.link).build();
    public static final FontAwesome5IconType lira_sign_s = on(FontAwesome5Solid.lira_sign).build();
    public static final FontAwesome5IconType list_alt_r = on(FontAwesome5Regular.list_alt).build();
    public static final FontAwesome5IconType list_alt_s = on(FontAwesome5Solid.list_alt).build();
    public static final FontAwesome5IconType list_ol_s = on(FontAwesome5Solid.list_ol).build();
    public static final FontAwesome5IconType list_s = on(FontAwesome5Solid.list).build();
    public static final FontAwesome5IconType list_ul_s = on(FontAwesome5Solid.list_ul).build();
    public static final FontAwesome5IconType location_arrow_s = on(FontAwesome5Solid.location_arrow).build();
    public static final FontAwesome5IconType lock_open_s = on(FontAwesome5Solid.lock_open).build();
    public static final FontAwesome5IconType lock_s = on(FontAwesome5Solid.lock).build();
    public static final FontAwesome5IconType long_arrow_alt_down_s = on(FontAwesome5Solid.long_arrow_alt_down).build();
    public static final FontAwesome5IconType long_arrow_alt_left_s = on(FontAwesome5Solid.long_arrow_alt_left).build();
    public static final FontAwesome5IconType long_arrow_alt_right_s = on(FontAwesome5Solid.long_arrow_alt_right).build();
    public static final FontAwesome5IconType long_arrow_alt_up_s = on(FontAwesome5Solid.long_arrow_alt_up).build();
    public static final FontAwesome5IconType low_vision_s = on(FontAwesome5Solid.low_vision).build();
    public static final FontAwesome5IconType luggage_cart_s = on(FontAwesome5Solid.luggage_cart).build();
    public static final FontAwesome5IconType lungs_s = on(FontAwesome5Solid.lungs).build();
    public static final FontAwesome5IconType lungs_virus_s = on(FontAwesome5Solid.lungs_virus).build();
    public static final FontAwesome5IconType magic_s = on(FontAwesome5Solid.magic).build();
    public static final FontAwesome5IconType magnet_s = on(FontAwesome5Solid.magnet).build();
    public static final FontAwesome5IconType mail_bulk_s = on(FontAwesome5Solid.mail_bulk).build();
    public static final FontAwesome5IconType male_s = on(FontAwesome5Solid.male).build();
    public static final FontAwesome5IconType map_marked_alt_s = on(FontAwesome5Solid.map_marked_alt).build();
    public static final FontAwesome5IconType map_marked_s = on(FontAwesome5Solid.map_marked).build();
    public static final FontAwesome5IconType map_marker_alt_s = on(FontAwesome5Solid.map_marker_alt).build();
    public static final FontAwesome5IconType map_marker_s = on(FontAwesome5Solid.map_marker).build();
    public static final FontAwesome5IconType map_pin_s = on(FontAwesome5Solid.map_pin).build();
    public static final FontAwesome5IconType map_r = on(FontAwesome5Regular.map).build();
    public static final FontAwesome5IconType map_s = on(FontAwesome5Solid.map).build();
    public static final FontAwesome5IconType map_signs_s = on(FontAwesome5Solid.map_signs).build();
    public static final FontAwesome5IconType marker_s = on(FontAwesome5Solid.marker).build();
    public static final FontAwesome5IconType mars_double_s = on(FontAwesome5Solid.mars_double).build();
    public static final FontAwesome5IconType mars_s = on(FontAwesome5Solid.mars).build();
    public static final FontAwesome5IconType mars_stroke_h_s = on(FontAwesome5Solid.mars_stroke_h).build();
    public static final FontAwesome5IconType mars_stroke_s = on(FontAwesome5Solid.mars_stroke).build();
    public static final FontAwesome5IconType mars_stroke_v_s = on(FontAwesome5Solid.mars_stroke_v).build();
    public static final FontAwesome5IconType mask_s = on(FontAwesome5Solid.mask).build();
    public static final FontAwesome5IconType medal_s = on(FontAwesome5Solid.medal).build();
    public static final FontAwesome5IconType medkit_s = on(FontAwesome5Solid.medkit).build();
    public static final FontAwesome5IconType meh_blank_r = on(FontAwesome5Regular.meh_blank).build();
    public static final FontAwesome5IconType meh_blank_s = on(FontAwesome5Solid.meh_blank).build();
    public static final FontAwesome5IconType meh_r = on(FontAwesome5Regular.meh).build();
    public static final FontAwesome5IconType meh_rolling_eyes_r = on(FontAwesome5Regular.meh_rolling_eyes).build();
    public static final FontAwesome5IconType meh_rolling_eyes_s = on(FontAwesome5Solid.meh_rolling_eyes).build();
    public static final FontAwesome5IconType meh_s = on(FontAwesome5Solid.meh).build();
    public static final FontAwesome5IconType memory_s = on(FontAwesome5Solid.memory).build();
    public static final FontAwesome5IconType menorah_s = on(FontAwesome5Solid.menorah).build();
    public static final FontAwesome5IconType mercury_s = on(FontAwesome5Solid.mercury).build();
    public static final FontAwesome5IconType meteor_s = on(FontAwesome5Solid.meteor).build();
    public static final FontAwesome5IconType microchip_s = on(FontAwesome5Solid.microchip).build();
    public static final FontAwesome5IconType microphone_alt_s = on(FontAwesome5Solid.microphone_alt).build();
    public static final FontAwesome5IconType microphone_alt_slash_s = on(FontAwesome5Solid.microphone_alt_slash).build();
    public static final FontAwesome5IconType microphone_s = on(FontAwesome5Solid.microphone).build();
    public static final FontAwesome5IconType microphone_slash_s = on(FontAwesome5Solid.microphone_slash).build();
    public static final FontAwesome5IconType microscope_s = on(FontAwesome5Solid.microscope).build();
    public static final FontAwesome5IconType minus_circle_s = on(FontAwesome5Solid.minus_circle).build();
    public static final FontAwesome5IconType minus_s = on(FontAwesome5Solid.minus).build();
    public static final FontAwesome5IconType minus_square_r = on(FontAwesome5Regular.minus_square).build();
    public static final FontAwesome5IconType minus_square_s = on(FontAwesome5Solid.minus_square).build();
    public static final FontAwesome5IconType mitten_s = on(FontAwesome5Solid.mitten).build();
    public static final FontAwesome5IconType mobile_alt_s = on(FontAwesome5Solid.mobile_alt).build();
    public static final FontAwesome5IconType mobile_s = on(FontAwesome5Solid.mobile).build();
    public static final FontAwesome5IconType money_bill_alt_r = on(FontAwesome5Regular.money_bill_alt).build();
    public static final FontAwesome5IconType money_bill_alt_s = on(FontAwesome5Solid.money_bill_alt).build();
    public static final FontAwesome5IconType money_bill_s = on(FontAwesome5Solid.money_bill).build();
    public static final FontAwesome5IconType money_bill_wave_alt_s = on(FontAwesome5Solid.money_bill_wave_alt).build();
    public static final FontAwesome5IconType money_bill_wave_s = on(FontAwesome5Solid.money_bill_wave).build();
    public static final FontAwesome5IconType money_check_alt_s = on(FontAwesome5Solid.money_check_alt).build();
    public static final FontAwesome5IconType money_check_s = on(FontAwesome5Solid.money_check).build();
    public static final FontAwesome5IconType monument_s = on(FontAwesome5Solid.monument).build();
    public static final FontAwesome5IconType moon_r = on(FontAwesome5Regular.moon).build();
    public static final FontAwesome5IconType moon_s = on(FontAwesome5Solid.moon).build();
    public static final FontAwesome5IconType mortar_pestle_s = on(FontAwesome5Solid.mortar_pestle).build();
    public static final FontAwesome5IconType mosque_s = on(FontAwesome5Solid.mosque).build();
    public static final FontAwesome5IconType motorcycle_s = on(FontAwesome5Solid.motorcycle).build();
    public static final FontAwesome5IconType mountain_s = on(FontAwesome5Solid.mountain).build();
    public static final FontAwesome5IconType mouse_pointer_s = on(FontAwesome5Solid.mouse_pointer).build();
    public static final FontAwesome5IconType mouse_s = on(FontAwesome5Solid.mouse).build();
    public static final FontAwesome5IconType mug_hot_s = on(FontAwesome5Solid.mug_hot).build();
    public static final FontAwesome5IconType music_s = on(FontAwesome5Solid.music).build();
    public static final FontAwesome5IconType network_wired_s = on(FontAwesome5Solid.network_wired).build();
    public static final FontAwesome5IconType neuter_s = on(FontAwesome5Solid.neuter).build();
    public static final FontAwesome5IconType newspaper_r = on(FontAwesome5Regular.newspaper).build();
    public static final FontAwesome5IconType newspaper_s = on(FontAwesome5Solid.newspaper).build();
    public static final FontAwesome5IconType not_equal_s = on(FontAwesome5Solid.not_equal).build();
    public static final FontAwesome5IconType notes_medical_s = on(FontAwesome5Solid.notes_medical).build();
    public static final FontAwesome5IconType object_group_r = on(FontAwesome5Regular.object_group).build();
    public static final FontAwesome5IconType object_group_s = on(FontAwesome5Solid.object_group).build();
    public static final FontAwesome5IconType object_ungroup_r = on(FontAwesome5Regular.object_ungroup).build();
    public static final FontAwesome5IconType object_ungroup_s = on(FontAwesome5Solid.object_ungroup).build();
    public static final FontAwesome5IconType oil_can_s = on(FontAwesome5Solid.oil_can).build();
    public static final FontAwesome5IconType om_s = on(FontAwesome5Solid.om).build();
    public static final FontAwesome5IconType otter_s = on(FontAwesome5Solid.otter).build();
    public static final FontAwesome5IconType outdent_s = on(FontAwesome5Solid.outdent).build();
    public static final FontAwesome5IconType pager_s = on(FontAwesome5Solid.pager).build();
    public static final FontAwesome5IconType paint_brush_s = on(FontAwesome5Solid.paint_brush).build();
    public static final FontAwesome5IconType paint_roller_s = on(FontAwesome5Solid.paint_roller).build();
    public static final FontAwesome5IconType palette_s = on(FontAwesome5Solid.palette).build();
    public static final FontAwesome5IconType pallet_s = on(FontAwesome5Solid.pallet).build();
    public static final FontAwesome5IconType paper_plane_r = on(FontAwesome5Regular.paper_plane).build();
    public static final FontAwesome5IconType paper_plane_s = on(FontAwesome5Solid.paper_plane).build();
    public static final FontAwesome5IconType paperclip_s = on(FontAwesome5Solid.paperclip).build();
    public static final FontAwesome5IconType parachute_box_s = on(FontAwesome5Solid.parachute_box).build();
    public static final FontAwesome5IconType paragraph_s = on(FontAwesome5Solid.paragraph).build();
    public static final FontAwesome5IconType parking_s = on(FontAwesome5Solid.parking).build();
    public static final FontAwesome5IconType passport_s = on(FontAwesome5Solid.passport).build();
    public static final FontAwesome5IconType pastafarianism_s = on(FontAwesome5Solid.pastafarianism).build();
    public static final FontAwesome5IconType paste_s = on(FontAwesome5Solid.paste).build();
    public static final FontAwesome5IconType pause_circle_r = on(FontAwesome5Regular.pause_circle).build();
    public static final FontAwesome5IconType pause_circle_s = on(FontAwesome5Solid.pause_circle).build();
    public static final FontAwesome5IconType pause_s = on(FontAwesome5Solid.pause).build();
    public static final FontAwesome5IconType paw_s = on(FontAwesome5Solid.paw).build();
    public static final FontAwesome5IconType peace_s = on(FontAwesome5Solid.peace).build();
    public static final FontAwesome5IconType pen_alt_s = on(FontAwesome5Solid.pen_alt).build();
    public static final FontAwesome5IconType pen_fancy_s = on(FontAwesome5Solid.pen_fancy).build();
    public static final FontAwesome5IconType pen_nib_s = on(FontAwesome5Solid.pen_nib).build();
    public static final FontAwesome5IconType pen_s = on(FontAwesome5Solid.pen).build();
    public static final FontAwesome5IconType pen_square_s = on(FontAwesome5Solid.pen_square).build();
    public static final FontAwesome5IconType pencil_alt_s = on(FontAwesome5Solid.pencil_alt).build();
    public static final FontAwesome5IconType pencil_ruler_s = on(FontAwesome5Solid.pencil_ruler).build();
    public static final FontAwesome5IconType people_arrows_s = on(FontAwesome5Solid.people_arrows).build();
    public static final FontAwesome5IconType people_carry_s = on(FontAwesome5Solid.people_carry).build();
    public static final FontAwesome5IconType pepper_hot_s = on(FontAwesome5Solid.pepper_hot).build();
    public static final FontAwesome5IconType percent_s = on(FontAwesome5Solid.percent).build();
    public static final FontAwesome5IconType percentage_s = on(FontAwesome5Solid.percentage).build();
    public static final FontAwesome5IconType person_booth_s = on(FontAwesome5Solid.person_booth).build();
    public static final FontAwesome5IconType phone_alt_s = on(FontAwesome5Solid.phone_alt).build();
    public static final FontAwesome5IconType phone_s = on(FontAwesome5Solid.phone).build();
    public static final FontAwesome5IconType phone_slash_s = on(FontAwesome5Solid.phone_slash).build();
    public static final FontAwesome5IconType phone_square_alt_s = on(FontAwesome5Solid.phone_square_alt).build();
    public static final FontAwesome5IconType phone_square_s = on(FontAwesome5Solid.phone_square).build();
    public static final FontAwesome5IconType phone_volume_s = on(FontAwesome5Solid.phone_volume).build();
    public static final FontAwesome5IconType photo_video_s = on(FontAwesome5Solid.photo_video).build();
    public static final FontAwesome5IconType piggy_bank_s = on(FontAwesome5Solid.piggy_bank).build();
    public static final FontAwesome5IconType pills_s = on(FontAwesome5Solid.pills).build();
    public static final FontAwesome5IconType pizza_slice_s = on(FontAwesome5Solid.pizza_slice).build();
    public static final FontAwesome5IconType place_of_worship_s = on(FontAwesome5Solid.place_of_worship).build();
    public static final FontAwesome5IconType plane_arrival_s = on(FontAwesome5Solid.plane_arrival).build();
    public static final FontAwesome5IconType plane_departure_s = on(FontAwesome5Solid.plane_departure).build();
    public static final FontAwesome5IconType plane_s = on(FontAwesome5Solid.plane).build();
    public static final FontAwesome5IconType plane_slash_s = on(FontAwesome5Solid.plane_slash).build();
    public static final FontAwesome5IconType play_circle_r = on(FontAwesome5Regular.play_circle).build();
    public static final FontAwesome5IconType play_circle_s = on(FontAwesome5Solid.play_circle).build();
    public static final FontAwesome5IconType play_s = on(FontAwesome5Solid.play).build();
    public static final FontAwesome5IconType plug_s = on(FontAwesome5Solid.plug).build();
    public static final FontAwesome5IconType plus_circle_s = on(FontAwesome5Solid.plus_circle).build();
    public static final FontAwesome5IconType plus_s = on(FontAwesome5Solid.plus).build();
    public static final FontAwesome5IconType plus_square_r = on(FontAwesome5Regular.plus_square).build();
    public static final FontAwesome5IconType plus_square_s = on(FontAwesome5Solid.plus_square).build();
    public static final FontAwesome5IconType podcast_s = on(FontAwesome5Solid.podcast).build();
    public static final FontAwesome5IconType poll_h_s = on(FontAwesome5Solid.poll_h).build();
    public static final FontAwesome5IconType poll_s = on(FontAwesome5Solid.poll).build();
    public static final FontAwesome5IconType poo_s = on(FontAwesome5Solid.poo).build();
    public static final FontAwesome5IconType poo_storm_s = on(FontAwesome5Solid.poo_storm).build();
    public static final FontAwesome5IconType poop_s = on(FontAwesome5Solid.poop).build();
    public static final FontAwesome5IconType portrait_s = on(FontAwesome5Solid.portrait).build();
    public static final FontAwesome5IconType pound_sign_s = on(FontAwesome5Solid.pound_sign).build();
    public static final FontAwesome5IconType power_off_s = on(FontAwesome5Solid.power_off).build();
    public static final FontAwesome5IconType pray_s = on(FontAwesome5Solid.pray).build();
    public static final FontAwesome5IconType praying_hands_s = on(FontAwesome5Solid.praying_hands).build();
    public static final FontAwesome5IconType prescription_bottle_alt_s = on(FontAwesome5Solid.prescription_bottle_alt).build();
    public static final FontAwesome5IconType prescription_bottle_s = on(FontAwesome5Solid.prescription_bottle).build();
    public static final FontAwesome5IconType prescription_s = on(FontAwesome5Solid.prescription).build();
    public static final FontAwesome5IconType print_s = on(FontAwesome5Solid.print).build();
    public static final FontAwesome5IconType procedures_s = on(FontAwesome5Solid.procedures).build();
    public static final FontAwesome5IconType project_diagram_s = on(FontAwesome5Solid.project_diagram).build();
    public static final FontAwesome5IconType pump_medical_s = on(FontAwesome5Solid.pump_medical).build();
    public static final FontAwesome5IconType pump_soap_s = on(FontAwesome5Solid.pump_soap).build();
    public static final FontAwesome5IconType puzzle_piece_s = on(FontAwesome5Solid.puzzle_piece).build();
    public static final FontAwesome5IconType qrcode_s = on(FontAwesome5Solid.qrcode).build();
    public static final FontAwesome5IconType question_circle_r = on(FontAwesome5Regular.question_circle).build();
    public static final FontAwesome5IconType question_circle_s = on(FontAwesome5Solid.question_circle).build();
    public static final FontAwesome5IconType question_s = on(FontAwesome5Solid.question).build();
    public static final FontAwesome5IconType quidditch_s = on(FontAwesome5Solid.quidditch).build();
    public static final FontAwesome5IconType quote_left_s = on(FontAwesome5Solid.quote_left).build();
    public static final FontAwesome5IconType quote_right_s = on(FontAwesome5Solid.quote_right).build();
    public static final FontAwesome5IconType quran_s = on(FontAwesome5Solid.quran).build();
    public static final FontAwesome5IconType radiation_alt_s = on(FontAwesome5Solid.radiation_alt).build();
    public static final FontAwesome5IconType radiation_s = on(FontAwesome5Solid.radiation).build();
    public static final FontAwesome5IconType rainbow_s = on(FontAwesome5Solid.rainbow).build();
    public static final FontAwesome5IconType random_s = on(FontAwesome5Solid.random).build();
    public static final FontAwesome5IconType receipt_s = on(FontAwesome5Solid.receipt).build();
    public static final FontAwesome5IconType record_vinyl_s = on(FontAwesome5Solid.record_vinyl).build();
    public static final FontAwesome5IconType recycle_s = on(FontAwesome5Solid.recycle).build();
    public static final FontAwesome5IconType redo_alt_s = on(FontAwesome5Solid.redo_alt).build();
    public static final FontAwesome5IconType redo_s = on(FontAwesome5Solid.redo).build();
    public static final FontAwesome5IconType registered_r = on(FontAwesome5Regular.registered).build();
    public static final FontAwesome5IconType registered_s = on(FontAwesome5Solid.registered).build();
    public static final FontAwesome5IconType remove_format_s = on(FontAwesome5Solid.remove_format).build();
    public static final FontAwesome5IconType reply_all_s = on(FontAwesome5Solid.reply_all).build();
    public static final FontAwesome5IconType reply_s = on(FontAwesome5Solid.reply).build();
    public static final FontAwesome5IconType republican_s = on(FontAwesome5Solid.republican).build();
    public static final FontAwesome5IconType restroom_s = on(FontAwesome5Solid.restroom).build();
    public static final FontAwesome5IconType retweet_s = on(FontAwesome5Solid.retweet).build();
    public static final FontAwesome5IconType ribbon_s = on(FontAwesome5Solid.ribbon).build();
    public static final FontAwesome5IconType ring_s = on(FontAwesome5Solid.ring).build();
    public static final FontAwesome5IconType road_s = on(FontAwesome5Solid.road).build();
    public static final FontAwesome5IconType robot_s = on(FontAwesome5Solid.robot).build();
    public static final FontAwesome5IconType rocket_s = on(FontAwesome5Solid.rocket).build();
    public static final FontAwesome5IconType route_s = on(FontAwesome5Solid.route).build();
    public static final FontAwesome5IconType rss_s = on(FontAwesome5Solid.rss).build();
    public static final FontAwesome5IconType rss_square_s = on(FontAwesome5Solid.rss_square).build();
    public static final FontAwesome5IconType ruble_sign_s = on(FontAwesome5Solid.ruble_sign).build();
    public static final FontAwesome5IconType ruler_combined_s = on(FontAwesome5Solid.ruler_combined).build();
    public static final FontAwesome5IconType ruler_horizontal_s = on(FontAwesome5Solid.ruler_horizontal).build();
    public static final FontAwesome5IconType ruler_s = on(FontAwesome5Solid.ruler).build();
    public static final FontAwesome5IconType ruler_vertical_s = on(FontAwesome5Solid.ruler_vertical).build();
    public static final FontAwesome5IconType running_s = on(FontAwesome5Solid.running).build();
    public static final FontAwesome5IconType rupee_sign_s = on(FontAwesome5Solid.rupee_sign).build();
    public static final FontAwesome5IconType sad_cry_r = on(FontAwesome5Regular.sad_cry).build();
    public static final FontAwesome5IconType sad_cry_s = on(FontAwesome5Solid.sad_cry).build();
    public static final FontAwesome5IconType sad_tear_r = on(FontAwesome5Regular.sad_tear).build();
    public static final FontAwesome5IconType sad_tear_s = on(FontAwesome5Solid.sad_tear).build();
    public static final FontAwesome5IconType satellite_dish_s = on(FontAwesome5Solid.satellite_dish).build();
    public static final FontAwesome5IconType satellite_s = on(FontAwesome5Solid.satellite).build();
    public static final FontAwesome5IconType save_r = on(FontAwesome5Regular.save).build();
    public static final FontAwesome5IconType save_s = on(FontAwesome5Solid.save).build();
    public static final FontAwesome5IconType school_s = on(FontAwesome5Solid.school).build();
    public static final FontAwesome5IconType screwdriver_s = on(FontAwesome5Solid.screwdriver).build();
    public static final FontAwesome5IconType scroll_s = on(FontAwesome5Solid.scroll).build();
    public static final FontAwesome5IconType sd_card_s = on(FontAwesome5Solid.sd_card).build();
    public static final FontAwesome5IconType search_dollar_s = on(FontAwesome5Solid.search_dollar).build();
    public static final FontAwesome5IconType search_location_s = on(FontAwesome5Solid.search_location).build();
    public static final FontAwesome5IconType search_minus_s = on(FontAwesome5Solid.search_minus).build();
    public static final FontAwesome5IconType search_plus_s = on(FontAwesome5Solid.search_plus).build();
    public static final FontAwesome5IconType search_s = on(FontAwesome5Solid.search).build();
    public static final FontAwesome5IconType seedling_s = on(FontAwesome5Solid.seedling).build();
    public static final FontAwesome5IconType server_s = on(FontAwesome5Solid.server).build();
    public static final FontAwesome5IconType shapes_s = on(FontAwesome5Solid.shapes).build();
    public static final FontAwesome5IconType share_alt_s = on(FontAwesome5Solid.share_alt).build();
    public static final FontAwesome5IconType share_alt_square_s = on(FontAwesome5Solid.share_alt_square).build();
    public static final FontAwesome5IconType share_s = on(FontAwesome5Solid.share).build();
    public static final FontAwesome5IconType share_square_r = on(FontAwesome5Regular.share_square).build();
    public static final FontAwesome5IconType share_square_s = on(FontAwesome5Solid.share_square).build();
    public static final FontAwesome5IconType shekel_sign_s = on(FontAwesome5Solid.shekel_sign).build();
    public static final FontAwesome5IconType shield_alt_s = on(FontAwesome5Solid.shield_alt).build();
    public static final FontAwesome5IconType shield_virus_s = on(FontAwesome5Solid.shield_virus).build();
    public static final FontAwesome5IconType ship_s = on(FontAwesome5Solid.ship).build();
    public static final FontAwesome5IconType shipping_fast_s = on(FontAwesome5Solid.shipping_fast).build();
    public static final FontAwesome5IconType shoe_prints_s = on(FontAwesome5Solid.shoe_prints).build();
    public static final FontAwesome5IconType shopping_bag_s = on(FontAwesome5Solid.shopping_bag).build();
    public static final FontAwesome5IconType shopping_basket_s = on(FontAwesome5Solid.shopping_basket).build();
    public static final FontAwesome5IconType shopping_cart_s = on(FontAwesome5Solid.shopping_cart).build();
    public static final FontAwesome5IconType shower_s = on(FontAwesome5Solid.shower).build();
    public static final FontAwesome5IconType shuttle_van_s = on(FontAwesome5Solid.shuttle_van).build();
    public static final FontAwesome5IconType sign_in_alt_s = on(FontAwesome5Solid.sign_in_alt).build();
    public static final FontAwesome5IconType sign_language_s = on(FontAwesome5Solid.sign_language).build();
    public static final FontAwesome5IconType sign_out_alt_s = on(FontAwesome5Solid.sign_out_alt).build();
    public static final FontAwesome5IconType sign_s = on(FontAwesome5Solid.sign).build();
    public static final FontAwesome5IconType signal_s = on(FontAwesome5Solid.signal).build();
    public static final FontAwesome5IconType signature_s = on(FontAwesome5Solid.signature).build();
    public static final FontAwesome5IconType sim_card_s = on(FontAwesome5Solid.sim_card).build();
    public static final FontAwesome5IconType sink_s = on(FontAwesome5Solid.sink).build();
    public static final FontAwesome5IconType sitemap_s = on(FontAwesome5Solid.sitemap).build();
    public static final FontAwesome5IconType skating_s = on(FontAwesome5Solid.skating).build();
    public static final FontAwesome5IconType skiing_nordic_s = on(FontAwesome5Solid.skiing_nordic).build();
    public static final FontAwesome5IconType skiing_s = on(FontAwesome5Solid.skiing).build();
    public static final FontAwesome5IconType skull_crossbones_s = on(FontAwesome5Solid.skull_crossbones).build();
    public static final FontAwesome5IconType skull_s = on(FontAwesome5Solid.skull).build();
    public static final FontAwesome5IconType slash_s = on(FontAwesome5Solid.slash).build();
    public static final FontAwesome5IconType sleigh_s = on(FontAwesome5Solid.sleigh).build();
    public static final FontAwesome5IconType sliders_h_s = on(FontAwesome5Solid.sliders_h).build();
    public static final FontAwesome5IconType smile_beam_r = on(FontAwesome5Regular.smile_beam).build();
    public static final FontAwesome5IconType smile_beam_s = on(FontAwesome5Solid.smile_beam).build();
    public static final FontAwesome5IconType smile_r = on(FontAwesome5Regular.smile).build();
    public static final FontAwesome5IconType smile_s = on(FontAwesome5Solid.smile).build();
    public static final FontAwesome5IconType smile_wink_r = on(FontAwesome5Regular.smile_wink).build();
    public static final FontAwesome5IconType smile_wink_s = on(FontAwesome5Solid.smile_wink).build();
    public static final FontAwesome5IconType smog_s = on(FontAwesome5Solid.smog).build();
    public static final FontAwesome5IconType smoking_ban_s = on(FontAwesome5Solid.smoking_ban).build();
    public static final FontAwesome5IconType smoking_s = on(FontAwesome5Solid.smoking).build();
    public static final FontAwesome5IconType sms_s = on(FontAwesome5Solid.sms).build();
    public static final FontAwesome5IconType snowboarding_s = on(FontAwesome5Solid.snowboarding).build();
    public static final FontAwesome5IconType snowflake_r = on(FontAwesome5Regular.snowflake).build();
    public static final FontAwesome5IconType snowflake_s = on(FontAwesome5Solid.snowflake).build();
    public static final FontAwesome5IconType snowman_s = on(FontAwesome5Solid.snowman).build();
    public static final FontAwesome5IconType snowplow_s = on(FontAwesome5Solid.snowplow).build();
    public static final FontAwesome5IconType soap_s = on(FontAwesome5Solid.soap).build();
    public static final FontAwesome5IconType socks_s = on(FontAwesome5Solid.socks).build();
    public static final FontAwesome5IconType solar_panel_s = on(FontAwesome5Solid.solar_panel).build();
    public static final FontAwesome5IconType sort_alpha_down_alt_s = on(FontAwesome5Solid.sort_alpha_down_alt).build();
    public static final FontAwesome5IconType sort_alpha_down_s = on(FontAwesome5Solid.sort_alpha_down).build();
    public static final FontAwesome5IconType sort_alpha_up_alt_s = on(FontAwesome5Solid.sort_alpha_up_alt).build();
    public static final FontAwesome5IconType sort_alpha_up_s = on(FontAwesome5Solid.sort_alpha_up).build();
    public static final FontAwesome5IconType sort_amount_down_alt_s = on(FontAwesome5Solid.sort_amount_down_alt).build();
    public static final FontAwesome5IconType sort_amount_down_s = on(FontAwesome5Solid.sort_amount_down).build();
    public static final FontAwesome5IconType sort_amount_up_alt_s = on(FontAwesome5Solid.sort_amount_up_alt).build();
    public static final FontAwesome5IconType sort_amount_up_s = on(FontAwesome5Solid.sort_amount_up).build();
    public static final FontAwesome5IconType sort_down_s = on(FontAwesome5Solid.sort_down).build();
    public static final FontAwesome5IconType sort_numeric_down_alt_s = on(FontAwesome5Solid.sort_numeric_down_alt).build();
    public static final FontAwesome5IconType sort_numeric_down_s = on(FontAwesome5Solid.sort_numeric_down).build();
    public static final FontAwesome5IconType sort_numeric_up_alt_s = on(FontAwesome5Solid.sort_numeric_up_alt).build();
    public static final FontAwesome5IconType sort_numeric_up_s = on(FontAwesome5Solid.sort_numeric_up).build();
    public static final FontAwesome5IconType sort_s = on(FontAwesome5Solid.sort).build();
    public static final FontAwesome5IconType sort_up_s = on(FontAwesome5Solid.sort_up).build();
    public static final FontAwesome5IconType spa_s = on(FontAwesome5Solid.spa).build();
    public static final FontAwesome5IconType space_shuttle_s = on(FontAwesome5Solid.space_shuttle).build();
    public static final FontAwesome5IconType spell_check_s = on(FontAwesome5Solid.spell_check).build();
    public static final FontAwesome5IconType spider_s = on(FontAwesome5Solid.spider).build();
    public static final FontAwesome5IconType spinner_s = on(FontAwesome5Solid.spinner).build();
    public static final FontAwesome5IconType splotch_s = on(FontAwesome5Solid.splotch).build();
    public static final FontAwesome5IconType spray_can_s = on(FontAwesome5Solid.spray_can).build();
    public static final FontAwesome5IconType square_full_s = on(FontAwesome5Solid.square_full).build();
    public static final FontAwesome5IconType square_r = on(FontAwesome5Regular.square).build();
    public static final FontAwesome5IconType square_root_alt_s = on(FontAwesome5Solid.square_root_alt).build();
    public static final FontAwesome5IconType square_s = on(FontAwesome5Solid.square).build();
    public static final FontAwesome5IconType stamp_s = on(FontAwesome5Solid.stamp).build();
    public static final FontAwesome5IconType star_and_crescent_s = on(FontAwesome5Solid.star_and_crescent).build();
    public static final FontAwesome5IconType star_half_alt_s = on(FontAwesome5Solid.star_half_alt).build();
    public static final FontAwesome5IconType star_half_r = on(FontAwesome5Regular.star_half).build();
    public static final FontAwesome5IconType star_half_s = on(FontAwesome5Solid.star_half).build();
    public static final FontAwesome5IconType star_of_david_s = on(FontAwesome5Solid.star_of_david).build();
    public static final FontAwesome5IconType star_of_life_s = on(FontAwesome5Solid.star_of_life).build();
    public static final FontAwesome5IconType star_r = on(FontAwesome5Regular.star).build();
    public static final FontAwesome5IconType star_s = on(FontAwesome5Solid.star).build();
    public static final FontAwesome5IconType step_backward_s = on(FontAwesome5Solid.step_backward).build();
    public static final FontAwesome5IconType step_forward_s = on(FontAwesome5Solid.step_forward).build();
    public static final FontAwesome5IconType stethoscope_s = on(FontAwesome5Solid.stethoscope).build();
    public static final FontAwesome5IconType sticky_note_r = on(FontAwesome5Regular.sticky_note).build();
    public static final FontAwesome5IconType sticky_note_s = on(FontAwesome5Solid.sticky_note).build();
    public static final FontAwesome5IconType stop_circle_r = on(FontAwesome5Regular.stop_circle).build();
    public static final FontAwesome5IconType stop_circle_s = on(FontAwesome5Solid.stop_circle).build();
    public static final FontAwesome5IconType stop_s = on(FontAwesome5Solid.stop).build();
    public static final FontAwesome5IconType stopwatch_20_s = on(FontAwesome5Solid.stopwatch_20).build();
    public static final FontAwesome5IconType stopwatch_s = on(FontAwesome5Solid.stopwatch).build();
    public static final FontAwesome5IconType store_alt_s = on(FontAwesome5Solid.store_alt).build();
    public static final FontAwesome5IconType store_alt_slash_s = on(FontAwesome5Solid.store_alt_slash).build();
    public static final FontAwesome5IconType store_s = on(FontAwesome5Solid.store).build();
    public static final FontAwesome5IconType store_slash_s = on(FontAwesome5Solid.store_slash).build();
    public static final FontAwesome5IconType stream_s = on(FontAwesome5Solid.stream).build();
    public static final FontAwesome5IconType street_view_s = on(FontAwesome5Solid.street_view).build();
    public static final FontAwesome5IconType strikethrough_s = on(FontAwesome5Solid.strikethrough).build();
    public static final FontAwesome5IconType stroopwafel_s = on(FontAwesome5Solid.stroopwafel).build();
    public static final FontAwesome5IconType subscript_s = on(FontAwesome5Solid.subscript).build();
    public static final FontAwesome5IconType subway_s = on(FontAwesome5Solid.subway).build();
    public static final FontAwesome5IconType suitcase_rolling_s = on(FontAwesome5Solid.suitcase_rolling).build();
    public static final FontAwesome5IconType suitcase_s = on(FontAwesome5Solid.suitcase).build();
    public static final FontAwesome5IconType sun_r = on(FontAwesome5Regular.sun).build();
    public static final FontAwesome5IconType sun_s = on(FontAwesome5Solid.sun).build();
    public static final FontAwesome5IconType superscript_s = on(FontAwesome5Solid.superscript).build();
    public static final FontAwesome5IconType surprise_r = on(FontAwesome5Regular.surprise).build();
    public static final FontAwesome5IconType surprise_s = on(FontAwesome5Solid.surprise).build();
    public static final FontAwesome5IconType swatchbook_s = on(FontAwesome5Solid.swatchbook).build();
    public static final FontAwesome5IconType swimmer_s = on(FontAwesome5Solid.swimmer).build();
    public static final FontAwesome5IconType swimming_pool_s = on(FontAwesome5Solid.swimming_pool).build();
    public static final FontAwesome5IconType synagogue_s = on(FontAwesome5Solid.synagogue).build();
    public static final FontAwesome5IconType sync_alt_s = on(FontAwesome5Solid.sync_alt).build();
    public static final FontAwesome5IconType sync_s = on(FontAwesome5Solid.sync).build();
    public static final FontAwesome5IconType syringe_s = on(FontAwesome5Solid.syringe).build();
    public static final FontAwesome5IconType table_s = on(FontAwesome5Solid.table).build();
    public static final FontAwesome5IconType table_tennis_s = on(FontAwesome5Solid.table_tennis).build();
    public static final FontAwesome5IconType tablet_alt_s = on(FontAwesome5Solid.tablet_alt).build();
    public static final FontAwesome5IconType tablet_s = on(FontAwesome5Solid.tablet).build();
    public static final FontAwesome5IconType tablets_s = on(FontAwesome5Solid.tablets).build();
    public static final FontAwesome5IconType tachometer_alt_s = on(FontAwesome5Solid.tachometer_alt).build();
    public static final FontAwesome5IconType tag_s = on(FontAwesome5Solid.tag).build();
    public static final FontAwesome5IconType tags_s = on(FontAwesome5Solid.tags).build();
    public static final FontAwesome5IconType tape_s = on(FontAwesome5Solid.tape).build();
    public static final FontAwesome5IconType tasks_s = on(FontAwesome5Solid.tasks).build();
    public static final FontAwesome5IconType taxi_s = on(FontAwesome5Solid.taxi).build();
    public static final FontAwesome5IconType teeth_open_s = on(FontAwesome5Solid.teeth_open).build();
    public static final FontAwesome5IconType teeth_s = on(FontAwesome5Solid.teeth).build();
    public static final FontAwesome5IconType temperature_high_s = on(FontAwesome5Solid.temperature_high).build();
    public static final FontAwesome5IconType temperature_low_s = on(FontAwesome5Solid.temperature_low).build();
    public static final FontAwesome5IconType tenge_s = on(FontAwesome5Solid.tenge).build();
    public static final FontAwesome5IconType terminal_s = on(FontAwesome5Solid.terminal).build();
    public static final FontAwesome5IconType text_height_s = on(FontAwesome5Solid.text_height).build();
    public static final FontAwesome5IconType text_width_s = on(FontAwesome5Solid.text_width).build();
    public static final FontAwesome5IconType th_large_s = on(FontAwesome5Solid.th_large).build();
    public static final FontAwesome5IconType th_list_s = on(FontAwesome5Solid.th_list).build();
    public static final FontAwesome5IconType th_s = on(FontAwesome5Solid.th).build();
    public static final FontAwesome5IconType theater_masks_s = on(FontAwesome5Solid.theater_masks).build();
    public static final FontAwesome5IconType thermometer_empty_s = on(FontAwesome5Solid.thermometer_empty).build();
    public static final FontAwesome5IconType thermometer_full_s = on(FontAwesome5Solid.thermometer_full).build();
    public static final FontAwesome5IconType thermometer_half_s = on(FontAwesome5Solid.thermometer_half).build();
    public static final FontAwesome5IconType thermometer_quarter_s = on(FontAwesome5Solid.thermometer_quarter).build();
    public static final FontAwesome5IconType thermometer_s = on(FontAwesome5Solid.thermometer).build();
    public static final FontAwesome5IconType thermometer_three_quarters_s = on(FontAwesome5Solid.thermometer_three_quarters).build();
    public static final FontAwesome5IconType thumbs_down_r = on(FontAwesome5Regular.thumbs_down).build();
    public static final FontAwesome5IconType thumbs_down_s = on(FontAwesome5Solid.thumbs_down).build();
    public static final FontAwesome5IconType thumbs_up_r = on(FontAwesome5Regular.thumbs_up).build();
    public static final FontAwesome5IconType thumbs_up_s = on(FontAwesome5Solid.thumbs_up).build();
    public static final FontAwesome5IconType thumbtack_s = on(FontAwesome5Solid.thumbtack).build();
    public static final FontAwesome5IconType ticket_alt_s = on(FontAwesome5Solid.ticket_alt).build();
    public static final FontAwesome5IconType times_circle_r = on(FontAwesome5Regular.times_circle).build();
    public static final FontAwesome5IconType times_circle_s = on(FontAwesome5Solid.times_circle).build();
    public static final FontAwesome5IconType times_s = on(FontAwesome5Solid.times).build();
    public static final FontAwesome5IconType tint_s = on(FontAwesome5Solid.tint).build();
    public static final FontAwesome5IconType tint_slash_s = on(FontAwesome5Solid.tint_slash).build();
    public static final FontAwesome5IconType tired_r = on(FontAwesome5Regular.tired).build();
    public static final FontAwesome5IconType tired_s = on(FontAwesome5Solid.tired).build();
    public static final FontAwesome5IconType toggle_off_s = on(FontAwesome5Solid.toggle_off).build();
    public static final FontAwesome5IconType toggle_on_s = on(FontAwesome5Solid.toggle_on).build();
    public static final FontAwesome5IconType toilet_paper_s = on(FontAwesome5Solid.toilet_paper).build();
    public static final FontAwesome5IconType toilet_paper_slash_s = on(FontAwesome5Solid.toilet_paper_slash).build();
    public static final FontAwesome5IconType toilet_s = on(FontAwesome5Solid.toilet).build();
    public static final FontAwesome5IconType toolbox_s = on(FontAwesome5Solid.toolbox).build();
    public static final FontAwesome5IconType tools_s = on(FontAwesome5Solid.tools).build();
    public static final FontAwesome5IconType tooth_s = on(FontAwesome5Solid.tooth).build();
    public static final FontAwesome5IconType torah_s = on(FontAwesome5Solid.torah).build();
    public static final FontAwesome5IconType torii_gate_s = on(FontAwesome5Solid.torii_gate).build();
    public static final FontAwesome5IconType tractor_s = on(FontAwesome5Solid.tractor).build();
    public static final FontAwesome5IconType trademark_s = on(FontAwesome5Solid.trademark).build();
    public static final FontAwesome5IconType traffic_light_s = on(FontAwesome5Solid.traffic_light).build();
    public static final FontAwesome5IconType trailer_s = on(FontAwesome5Solid.trailer).build();
    public static final FontAwesome5IconType train_s = on(FontAwesome5Solid.train).build();
    public static final FontAwesome5IconType tram_s = on(FontAwesome5Solid.tram).build();
    public static final FontAwesome5IconType transgender_alt_s = on(FontAwesome5Solid.transgender_alt).build();
    public static final FontAwesome5IconType transgender_s = on(FontAwesome5Solid.transgender).build();
    public static final FontAwesome5IconType trash_alt_r = on(FontAwesome5Regular.trash_alt).build();
    public static final FontAwesome5IconType trash_alt_s = on(FontAwesome5Solid.trash_alt).build();
    public static final FontAwesome5IconType trash_restore_alt_s = on(FontAwesome5Solid.trash_restore_alt).build();
    public static final FontAwesome5IconType trash_restore_s = on(FontAwesome5Solid.trash_restore).build();
    public static final FontAwesome5IconType trash_s = on(FontAwesome5Solid.trash).build();
    public static final FontAwesome5IconType tree_s = on(FontAwesome5Solid.tree).build();
    public static final FontAwesome5IconType trophy_s = on(FontAwesome5Solid.trophy).build();
    public static final FontAwesome5IconType truck_loading_s = on(FontAwesome5Solid.truck_loading).build();
    public static final FontAwesome5IconType truck_monster_s = on(FontAwesome5Solid.truck_monster).build();
    public static final FontAwesome5IconType truck_moving_s = on(FontAwesome5Solid.truck_moving).build();
    public static final FontAwesome5IconType truck_pickup_s = on(FontAwesome5Solid.truck_pickup).build();
    public static final FontAwesome5IconType truck_s = on(FontAwesome5Solid.truck).build();
    public static final FontAwesome5IconType tshirt_s = on(FontAwesome5Solid.tshirt).build();
    public static final FontAwesome5IconType tty_s = on(FontAwesome5Solid.tty).build();
    public static final FontAwesome5IconType tv_s = on(FontAwesome5Solid.tv).build();
    public static final FontAwesome5IconType umbrella_beach_s = on(FontAwesome5Solid.umbrella_beach).build();
    public static final FontAwesome5IconType umbrella_s = on(FontAwesome5Solid.umbrella).build();
    public static final FontAwesome5IconType underline_s = on(FontAwesome5Solid.underline).build();
    public static final FontAwesome5IconType undo_alt_s = on(FontAwesome5Solid.undo_alt).build();
    public static final FontAwesome5IconType undo_s = on(FontAwesome5Solid.undo).build();
    public static final FontAwesome5IconType universal_access_s = on(FontAwesome5Solid.universal_access).build();
    public static final FontAwesome5IconType university_s = on(FontAwesome5Solid.university).build();
    public static final FontAwesome5IconType unlink_s = on(FontAwesome5Solid.unlink).build();
    public static final FontAwesome5IconType unlock_alt_s = on(FontAwesome5Solid.unlock_alt).build();
    public static final FontAwesome5IconType unlock_s = on(FontAwesome5Solid.unlock).build();
    public static final FontAwesome5IconType upload_s = on(FontAwesome5Solid.upload).build();
    public static final FontAwesome5IconType user_alt_s = on(FontAwesome5Solid.user_alt).build();
    public static final FontAwesome5IconType user_alt_slash_s = on(FontAwesome5Solid.user_alt_slash).build();
    public static final FontAwesome5IconType user_astronaut_s = on(FontAwesome5Solid.user_astronaut).build();
    public static final FontAwesome5IconType user_check_s = on(FontAwesome5Solid.user_check).build();
    public static final FontAwesome5IconType user_circle_r = on(FontAwesome5Regular.user_circle).build();
    public static final FontAwesome5IconType user_circle_s = on(FontAwesome5Solid.user_circle).build();
    public static final FontAwesome5IconType user_clock_s = on(FontAwesome5Solid.user_clock).build();
    public static final FontAwesome5IconType user_cog_s = on(FontAwesome5Solid.user_cog).build();
    public static final FontAwesome5IconType user_edit_s = on(FontAwesome5Solid.user_edit).build();
    public static final FontAwesome5IconType user_friends_s = on(FontAwesome5Solid.user_friends).build();
    public static final FontAwesome5IconType user_graduate_s = on(FontAwesome5Solid.user_graduate).build();
    public static final FontAwesome5IconType user_injured_s = on(FontAwesome5Solid.user_injured).build();
    public static final FontAwesome5IconType user_lock_s = on(FontAwesome5Solid.user_lock).build();
    public static final FontAwesome5IconType user_md_s = on(FontAwesome5Solid.user_md).build();
    public static final FontAwesome5IconType user_minus_s = on(FontAwesome5Solid.user_minus).build();
    public static final FontAwesome5IconType user_ninja_s = on(FontAwesome5Solid.user_ninja).build();
    public static final FontAwesome5IconType user_nurse_s = on(FontAwesome5Solid.user_nurse).build();
    public static final FontAwesome5IconType user_plus_s = on(FontAwesome5Solid.user_plus).build();
    public static final FontAwesome5IconType user_r = on(FontAwesome5Regular.user).build();
    public static final FontAwesome5IconType user_s = on(FontAwesome5Solid.user).build();
    public static final FontAwesome5IconType user_secret_s = on(FontAwesome5Solid.user_secret).build();
    public static final FontAwesome5IconType user_shield_s = on(FontAwesome5Solid.user_shield).build();
    public static final FontAwesome5IconType user_slash_s = on(FontAwesome5Solid.user_slash).build();
    public static final FontAwesome5IconType user_tag_s = on(FontAwesome5Solid.user_tag).build();
    public static final FontAwesome5IconType user_tie_s = on(FontAwesome5Solid.user_tie).build();
    public static final FontAwesome5IconType user_times_s = on(FontAwesome5Solid.user_times).build();
    public static final FontAwesome5IconType users_cog_s = on(FontAwesome5Solid.users_cog).build();
    public static final FontAwesome5IconType users_s = on(FontAwesome5Solid.users).build();
    public static final FontAwesome5IconType users_slash_s = on(FontAwesome5Solid.users_slash).build();
    public static final FontAwesome5IconType utensil_spoon_s = on(FontAwesome5Solid.utensil_spoon).build();
    public static final FontAwesome5IconType utensils_s = on(FontAwesome5Solid.utensils).build();
    public static final FontAwesome5IconType vector_square_s = on(FontAwesome5Solid.vector_square).build();
    public static final FontAwesome5IconType venus_double_s = on(FontAwesome5Solid.venus_double).build();
    public static final FontAwesome5IconType venus_mars_s = on(FontAwesome5Solid.venus_mars).build();
    public static final FontAwesome5IconType venus_s = on(FontAwesome5Solid.venus).build();
    public static final FontAwesome5IconType vest_patches_s = on(FontAwesome5Solid.vest_patches).build();
    public static final FontAwesome5IconType vest_s = on(FontAwesome5Solid.vest).build();
    public static final FontAwesome5IconType vial_s = on(FontAwesome5Solid.vial).build();
    public static final FontAwesome5IconType vials_s = on(FontAwesome5Solid.vials).build();
    public static final FontAwesome5IconType video_s = on(FontAwesome5Solid.video).build();
    public static final FontAwesome5IconType video_slash_s = on(FontAwesome5Solid.video_slash).build();
    public static final FontAwesome5IconType vihara_s = on(FontAwesome5Solid.vihara).build();
    public static final FontAwesome5IconType virus_s = on(FontAwesome5Solid.virus).build();
    public static final FontAwesome5IconType virus_slash_s = on(FontAwesome5Solid.virus_slash).build();
    public static final FontAwesome5IconType viruses_s = on(FontAwesome5Solid.viruses).build();
    public static final FontAwesome5IconType voicemail_s = on(FontAwesome5Solid.voicemail).build();
    public static final FontAwesome5IconType volleyball_ball_s = on(FontAwesome5Solid.volleyball_ball).build();
    public static final FontAwesome5IconType volume_down_s = on(FontAwesome5Solid.volume_down).build();
    public static final FontAwesome5IconType volume_mute_s = on(FontAwesome5Solid.volume_mute).build();
    public static final FontAwesome5IconType volume_off_s = on(FontAwesome5Solid.volume_off).build();
    public static final FontAwesome5IconType volume_up_s = on(FontAwesome5Solid.volume_up).build();
    public static final FontAwesome5IconType vote_yea_s = on(FontAwesome5Solid.vote_yea).build();
    public static final FontAwesome5IconType vr_cardboard_s = on(FontAwesome5Solid.vr_cardboard).build();
    public static final FontAwesome5IconType walking_s = on(FontAwesome5Solid.walking).build();
    public static final FontAwesome5IconType wallet_s = on(FontAwesome5Solid.wallet).build();
    public static final FontAwesome5IconType warehouse_s = on(FontAwesome5Solid.warehouse).build();
    public static final FontAwesome5IconType water_s = on(FontAwesome5Solid.water).build();
    public static final FontAwesome5IconType wave_square_s = on(FontAwesome5Solid.wave_square).build();
    public static final FontAwesome5IconType weight_hanging_s = on(FontAwesome5Solid.weight_hanging).build();
    public static final FontAwesome5IconType weight_s = on(FontAwesome5Solid.weight).build();
    public static final FontAwesome5IconType wheelchair_s = on(FontAwesome5Solid.wheelchair).build();
    public static final FontAwesome5IconType wifi_s = on(FontAwesome5Solid.wifi).build();
    public static final FontAwesome5IconType wind_s = on(FontAwesome5Solid.wind).build();
    public static final FontAwesome5IconType window_close_r = on(FontAwesome5Regular.window_close).build();
    public static final FontAwesome5IconType window_close_s = on(FontAwesome5Solid.window_close).build();
    public static final FontAwesome5IconType window_maximize_r = on(FontAwesome5Regular.window_maximize).build();
    public static final FontAwesome5IconType window_maximize_s = on(FontAwesome5Solid.window_maximize).build();
    public static final FontAwesome5IconType window_minimize_r = on(FontAwesome5Regular.window_minimize).build();
    public static final FontAwesome5IconType window_minimize_s = on(FontAwesome5Solid.window_minimize).build();
    public static final FontAwesome5IconType window_restore_r = on(FontAwesome5Regular.window_restore).build();
    public static final FontAwesome5IconType window_restore_s = on(FontAwesome5Solid.window_restore).build();
    public static final FontAwesome5IconType wine_bottle_s = on(FontAwesome5Solid.wine_bottle).build();
    public static final FontAwesome5IconType wine_glass_alt_s = on(FontAwesome5Solid.wine_glass_alt).build();
    public static final FontAwesome5IconType wine_glass_s = on(FontAwesome5Solid.wine_glass).build();
    public static final FontAwesome5IconType won_sign_s = on(FontAwesome5Solid.won_sign).build();
    public static final FontAwesome5IconType wrench_s = on(FontAwesome5Solid.wrench).build();
    public static final FontAwesome5IconType x_ray_s = on(FontAwesome5Solid.x_ray).build();
    public static final FontAwesome5IconType yen_sign_s = on(FontAwesome5Solid.yen_sign).build();
    public static final FontAwesome5IconType yin_yang_s = on(FontAwesome5Solid.yin_yang).build();

    // icon types of style 'brand'
    public static final FontAwesome5IconType _500px = on(FontAwesome5Brand._500px).build();
    public static final FontAwesome5IconType accessible_icon = on(FontAwesome5Brand.accessible_icon).build();
    public static final FontAwesome5IconType accusoft = on(FontAwesome5Brand.accusoft).build();
    public static final FontAwesome5IconType acquisitions_incorporated = on(FontAwesome5Brand.acquisitions_incorporated).build();
    public static final FontAwesome5IconType adn = on(FontAwesome5Brand.adn).build();
    public static final FontAwesome5IconType adversal = on(FontAwesome5Brand.adversal).build();
    public static final FontAwesome5IconType affiliatetheme = on(FontAwesome5Brand.affiliatetheme).build();
    public static final FontAwesome5IconType airbnb = on(FontAwesome5Brand.airbnb).build();
    public static final FontAwesome5IconType algolia = on(FontAwesome5Brand.algolia).build();
    public static final FontAwesome5IconType alipay = on(FontAwesome5Brand.alipay).build();
    public static final FontAwesome5IconType amazon = on(FontAwesome5Brand.amazon).build();
    public static final FontAwesome5IconType amazon_pay = on(FontAwesome5Brand.amazon_pay).build();
    public static final FontAwesome5IconType amilia = on(FontAwesome5Brand.amilia).build();
    public static final FontAwesome5IconType android = on(FontAwesome5Brand.android).build();
    public static final FontAwesome5IconType angellist = on(FontAwesome5Brand.angellist).build();
    public static final FontAwesome5IconType angrycreative = on(FontAwesome5Brand.angrycreative).build();
    public static final FontAwesome5IconType angular = on(FontAwesome5Brand.angular).build();
    public static final FontAwesome5IconType app_store = on(FontAwesome5Brand.app_store).build();
    public static final FontAwesome5IconType app_store_ios = on(FontAwesome5Brand.app_store_ios).build();
    public static final FontAwesome5IconType apper = on(FontAwesome5Brand.apper).build();
    public static final FontAwesome5IconType apple = on(FontAwesome5Brand.apple).build();
    public static final FontAwesome5IconType apple_pay = on(FontAwesome5Brand.apple_pay).build();
    public static final FontAwesome5IconType artstation = on(FontAwesome5Brand.artstation).build();
    public static final FontAwesome5IconType asymmetrik = on(FontAwesome5Brand.asymmetrik).build();
    public static final FontAwesome5IconType atlassian = on(FontAwesome5Brand.atlassian).build();
    public static final FontAwesome5IconType audible = on(FontAwesome5Brand.audible).build();
    public static final FontAwesome5IconType autoprefixer = on(FontAwesome5Brand.autoprefixer).build();
    public static final FontAwesome5IconType avianex = on(FontAwesome5Brand.avianex).build();
    public static final FontAwesome5IconType aviato = on(FontAwesome5Brand.aviato).build();
    public static final FontAwesome5IconType aws = on(FontAwesome5Brand.aws).build();
    public static final FontAwesome5IconType bandcamp = on(FontAwesome5Brand.bandcamp).build();
    public static final FontAwesome5IconType battle_net = on(FontAwesome5Brand.battle_net).build();
    public static final FontAwesome5IconType behance = on(FontAwesome5Brand.behance).build();
    public static final FontAwesome5IconType behance_square = on(FontAwesome5Brand.behance_square).build();
    public static final FontAwesome5IconType bimobject = on(FontAwesome5Brand.bimobject).build();
    public static final FontAwesome5IconType bitbucket = on(FontAwesome5Brand.bitbucket).build();
    public static final FontAwesome5IconType bitcoin = on(FontAwesome5Brand.bitcoin).build();
    public static final FontAwesome5IconType bity = on(FontAwesome5Brand.bity).build();
    public static final FontAwesome5IconType black_tie = on(FontAwesome5Brand.black_tie).build();
    public static final FontAwesome5IconType blackberry = on(FontAwesome5Brand.blackberry).build();
    public static final FontAwesome5IconType blogger = on(FontAwesome5Brand.blogger).build();
    public static final FontAwesome5IconType blogger_b = on(FontAwesome5Brand.blogger_b).build();
    public static final FontAwesome5IconType bluetooth = on(FontAwesome5Brand.bluetooth).build();
    public static final FontAwesome5IconType bluetooth_b = on(FontAwesome5Brand.bluetooth_b).build();
    public static final FontAwesome5IconType bootstrap = on(FontAwesome5Brand.bootstrap).build();
    public static final FontAwesome5IconType btc = on(FontAwesome5Brand.btc).build();
    public static final FontAwesome5IconType buffer = on(FontAwesome5Brand.buffer).build();
    public static final FontAwesome5IconType buromobelexperte = on(FontAwesome5Brand.buromobelexperte).build();
    public static final FontAwesome5IconType buy_n_large = on(FontAwesome5Brand.buy_n_large).build();
    public static final FontAwesome5IconType buysellads = on(FontAwesome5Brand.buysellads).build();
    public static final FontAwesome5IconType canadian_maple_leaf = on(FontAwesome5Brand.canadian_maple_leaf).build();
    public static final FontAwesome5IconType cc_amazon_pay = on(FontAwesome5Brand.cc_amazon_pay).build();
    public static final FontAwesome5IconType cc_amex = on(FontAwesome5Brand.cc_amex).build();
    public static final FontAwesome5IconType cc_apple_pay = on(FontAwesome5Brand.cc_apple_pay).build();
    public static final FontAwesome5IconType cc_diners_club = on(FontAwesome5Brand.cc_diners_club).build();
    public static final FontAwesome5IconType cc_discover = on(FontAwesome5Brand.cc_discover).build();
    public static final FontAwesome5IconType cc_jcb = on(FontAwesome5Brand.cc_jcb).build();
    public static final FontAwesome5IconType cc_mastercard = on(FontAwesome5Brand.cc_mastercard).build();
    public static final FontAwesome5IconType cc_paypal = on(FontAwesome5Brand.cc_paypal).build();
    public static final FontAwesome5IconType cc_stripe = on(FontAwesome5Brand.cc_stripe).build();
    public static final FontAwesome5IconType cc_visa = on(FontAwesome5Brand.cc_visa).build();
    public static final FontAwesome5IconType centercode = on(FontAwesome5Brand.centercode).build();
    public static final FontAwesome5IconType centos = on(FontAwesome5Brand.centos).build();
    public static final FontAwesome5IconType chrome = on(FontAwesome5Brand.chrome).build();
    public static final FontAwesome5IconType chromecast = on(FontAwesome5Brand.chromecast).build();
    public static final FontAwesome5IconType cloudflare = on(FontAwesome5Brand.cloudflare).build();
    public static final FontAwesome5IconType cloudscale = on(FontAwesome5Brand.cloudscale).build();
    public static final FontAwesome5IconType cloudsmith = on(FontAwesome5Brand.cloudsmith).build();
    public static final FontAwesome5IconType cloudversify = on(FontAwesome5Brand.cloudversify).build();
    public static final FontAwesome5IconType codepen = on(FontAwesome5Brand.codepen).build();
    public static final FontAwesome5IconType codiepie = on(FontAwesome5Brand.codiepie).build();
    public static final FontAwesome5IconType confluence = on(FontAwesome5Brand.confluence).build();
    public static final FontAwesome5IconType connectdevelop = on(FontAwesome5Brand.connectdevelop).build();
    public static final FontAwesome5IconType contao = on(FontAwesome5Brand.contao).build();
    public static final FontAwesome5IconType cotton_bureau = on(FontAwesome5Brand.cotton_bureau).build();
    public static final FontAwesome5IconType cpanel = on(FontAwesome5Brand.cpanel).build();
    public static final FontAwesome5IconType creative_commons = on(FontAwesome5Brand.creative_commons).build();
    public static final FontAwesome5IconType creative_commons_by = on(FontAwesome5Brand.creative_commons_by).build();
    public static final FontAwesome5IconType creative_commons_nc = on(FontAwesome5Brand.creative_commons_nc).build();
    public static final FontAwesome5IconType creative_commons_nc_eu = on(FontAwesome5Brand.creative_commons_nc_eu).build();
    public static final FontAwesome5IconType creative_commons_nc_jp = on(FontAwesome5Brand.creative_commons_nc_jp).build();
    public static final FontAwesome5IconType creative_commons_nd = on(FontAwesome5Brand.creative_commons_nd).build();
    public static final FontAwesome5IconType creative_commons_pd = on(FontAwesome5Brand.creative_commons_pd).build();
    public static final FontAwesome5IconType creative_commons_pd_alt = on(FontAwesome5Brand.creative_commons_pd_alt).build();
    public static final FontAwesome5IconType creative_commons_remix = on(FontAwesome5Brand.creative_commons_remix).build();
    public static final FontAwesome5IconType creative_commons_sa = on(FontAwesome5Brand.creative_commons_sa).build();
    public static final FontAwesome5IconType creative_commons_sampling = on(FontAwesome5Brand.creative_commons_sampling).build();
    public static final FontAwesome5IconType creative_commons_sampling_plus = on(FontAwesome5Brand.creative_commons_sampling_plus).build();
    public static final FontAwesome5IconType creative_commons_share = on(FontAwesome5Brand.creative_commons_share).build();
    public static final FontAwesome5IconType creative_commons_zero = on(FontAwesome5Brand.creative_commons_zero).build();
    public static final FontAwesome5IconType critical_role = on(FontAwesome5Brand.critical_role).build();
    public static final FontAwesome5IconType css3 = on(FontAwesome5Brand.css3).build();
    public static final FontAwesome5IconType css3_alt = on(FontAwesome5Brand.css3_alt).build();
    public static final FontAwesome5IconType cuttlefish = on(FontAwesome5Brand.cuttlefish).build();
    public static final FontAwesome5IconType d_and_d = on(FontAwesome5Brand.d_and_d).build();
    public static final FontAwesome5IconType d_and_d_beyond = on(FontAwesome5Brand.d_and_d_beyond).build();
    public static final FontAwesome5IconType dailymotion = on(FontAwesome5Brand.dailymotion).build();
    public static final FontAwesome5IconType dashcube = on(FontAwesome5Brand.dashcube).build();
    public static final FontAwesome5IconType deezer = on(FontAwesome5Brand.deezer).build();
    public static final FontAwesome5IconType delicious = on(FontAwesome5Brand.delicious).build();
    public static final FontAwesome5IconType deploydog = on(FontAwesome5Brand.deploydog).build();
    public static final FontAwesome5IconType deskpro = on(FontAwesome5Brand.deskpro).build();
    public static final FontAwesome5IconType dev = on(FontAwesome5Brand.dev).build();
    public static final FontAwesome5IconType deviantart = on(FontAwesome5Brand.deviantart).build();
    public static final FontAwesome5IconType dhl = on(FontAwesome5Brand.dhl).build();
    public static final FontAwesome5IconType diaspora = on(FontAwesome5Brand.diaspora).build();
    public static final FontAwesome5IconType digg = on(FontAwesome5Brand.digg).build();
    public static final FontAwesome5IconType digital_ocean = on(FontAwesome5Brand.digital_ocean).build();
    public static final FontAwesome5IconType discord = on(FontAwesome5Brand.discord).build();
    public static final FontAwesome5IconType discourse = on(FontAwesome5Brand.discourse).build();
    public static final FontAwesome5IconType dochub = on(FontAwesome5Brand.dochub).build();
    public static final FontAwesome5IconType docker = on(FontAwesome5Brand.docker).build();
    public static final FontAwesome5IconType draft2digital = on(FontAwesome5Brand.draft2digital).build();
    public static final FontAwesome5IconType dribbble = on(FontAwesome5Brand.dribbble).build();
    public static final FontAwesome5IconType dribbble_square = on(FontAwesome5Brand.dribbble_square).build();
    public static final FontAwesome5IconType dropbox = on(FontAwesome5Brand.dropbox).build();
    public static final FontAwesome5IconType drupal = on(FontAwesome5Brand.drupal).build();
    public static final FontAwesome5IconType dyalog = on(FontAwesome5Brand.dyalog).build();
    public static final FontAwesome5IconType earlybirds = on(FontAwesome5Brand.earlybirds).build();
    public static final FontAwesome5IconType ebay = on(FontAwesome5Brand.ebay).build();
    public static final FontAwesome5IconType edge = on(FontAwesome5Brand.edge).build();
    public static final FontAwesome5IconType edge_legacy = on(FontAwesome5Brand.edge_legacy).build();
    public static final FontAwesome5IconType elementor = on(FontAwesome5Brand.elementor).build();
    public static final FontAwesome5IconType ello = on(FontAwesome5Brand.ello).build();
    public static final FontAwesome5IconType ember = on(FontAwesome5Brand.ember).build();
    public static final FontAwesome5IconType empire = on(FontAwesome5Brand.empire).build();
    public static final FontAwesome5IconType envira = on(FontAwesome5Brand.envira).build();
    public static final FontAwesome5IconType erlang = on(FontAwesome5Brand.erlang).build();
    public static final FontAwesome5IconType ethereum = on(FontAwesome5Brand.ethereum).build();
    public static final FontAwesome5IconType etsy = on(FontAwesome5Brand.etsy).build();
    public static final FontAwesome5IconType evernote = on(FontAwesome5Brand.evernote).build();
    public static final FontAwesome5IconType expeditedssl = on(FontAwesome5Brand.expeditedssl).build();
    public static final FontAwesome5IconType facebook = on(FontAwesome5Brand.facebook).build();
    public static final FontAwesome5IconType facebook_f = on(FontAwesome5Brand.facebook_f).build();
    public static final FontAwesome5IconType facebook_messenger = on(FontAwesome5Brand.facebook_messenger).build();
    public static final FontAwesome5IconType facebook_square = on(FontAwesome5Brand.facebook_square).build();
    public static final FontAwesome5IconType fantasy_flight_games = on(FontAwesome5Brand.fantasy_flight_games).build();
    public static final FontAwesome5IconType fedex = on(FontAwesome5Brand.fedex).build();
    public static final FontAwesome5IconType fedora = on(FontAwesome5Brand.fedora).build();
    public static final FontAwesome5IconType figma = on(FontAwesome5Brand.figma).build();
    public static final FontAwesome5IconType firefox = on(FontAwesome5Brand.firefox).build();
    public static final FontAwesome5IconType firefox_browser = on(FontAwesome5Brand.firefox_browser).build();
    public static final FontAwesome5IconType first_order = on(FontAwesome5Brand.first_order).build();
    public static final FontAwesome5IconType first_order_alt = on(FontAwesome5Brand.first_order_alt).build();
    public static final FontAwesome5IconType firstdraft = on(FontAwesome5Brand.firstdraft).build();
    public static final FontAwesome5IconType flickr = on(FontAwesome5Brand.flickr).build();
    public static final FontAwesome5IconType flipboard = on(FontAwesome5Brand.flipboard).build();
    public static final FontAwesome5IconType fly = on(FontAwesome5Brand.fly).build();
    public static final FontAwesome5IconType font_awesome = on(FontAwesome5Brand.font_awesome).build();
    public static final FontAwesome5IconType font_awesome_alt = on(FontAwesome5Brand.font_awesome_alt).build();
    public static final FontAwesome5IconType font_awesome_flag = on(FontAwesome5Brand.font_awesome_flag).build();
    public static final FontAwesome5IconType font_awesome_logo_full = on(FontAwesome5Brand.font_awesome_logo_full).build();
    public static final FontAwesome5IconType fonticons = on(FontAwesome5Brand.fonticons).build();
    public static final FontAwesome5IconType fonticons_fi = on(FontAwesome5Brand.fonticons_fi).build();
    public static final FontAwesome5IconType fort_awesome = on(FontAwesome5Brand.fort_awesome).build();
    public static final FontAwesome5IconType fort_awesome_alt = on(FontAwesome5Brand.fort_awesome_alt).build();
    public static final FontAwesome5IconType forumbee = on(FontAwesome5Brand.forumbee).build();
    public static final FontAwesome5IconType foursquare = on(FontAwesome5Brand.foursquare).build();
    public static final FontAwesome5IconType free_code_camp = on(FontAwesome5Brand.free_code_camp).build();
    public static final FontAwesome5IconType freebsd = on(FontAwesome5Brand.freebsd).build();
    public static final FontAwesome5IconType fulcrum = on(FontAwesome5Brand.fulcrum).build();
    public static final FontAwesome5IconType galactic_republic = on(FontAwesome5Brand.galactic_republic).build();
    public static final FontAwesome5IconType galactic_senate = on(FontAwesome5Brand.galactic_senate).build();
    public static final FontAwesome5IconType get_pocket = on(FontAwesome5Brand.get_pocket).build();
    public static final FontAwesome5IconType gg = on(FontAwesome5Brand.gg).build();
    public static final FontAwesome5IconType gg_circle = on(FontAwesome5Brand.gg_circle).build();
    public static final FontAwesome5IconType git = on(FontAwesome5Brand.git).build();
    public static final FontAwesome5IconType git_alt = on(FontAwesome5Brand.git_alt).build();
    public static final FontAwesome5IconType git_square = on(FontAwesome5Brand.git_square).build();
    public static final FontAwesome5IconType github = on(FontAwesome5Brand.github).build();
    public static final FontAwesome5IconType github_alt = on(FontAwesome5Brand.github_alt).build();
    public static final FontAwesome5IconType github_square = on(FontAwesome5Brand.github_square).build();
    public static final FontAwesome5IconType gitkraken = on(FontAwesome5Brand.gitkraken).build();
    public static final FontAwesome5IconType gitlab = on(FontAwesome5Brand.gitlab).build();
    public static final FontAwesome5IconType gitter = on(FontAwesome5Brand.gitter).build();
    public static final FontAwesome5IconType glide = on(FontAwesome5Brand.glide).build();
    public static final FontAwesome5IconType glide_g = on(FontAwesome5Brand.glide_g).build();
    public static final FontAwesome5IconType gofore = on(FontAwesome5Brand.gofore).build();
    public static final FontAwesome5IconType goodreads = on(FontAwesome5Brand.goodreads).build();
    public static final FontAwesome5IconType goodreads_g = on(FontAwesome5Brand.goodreads_g).build();
    public static final FontAwesome5IconType google = on(FontAwesome5Brand.google).build();
    public static final FontAwesome5IconType google_drive = on(FontAwesome5Brand.google_drive).build();
    public static final FontAwesome5IconType google_pay = on(FontAwesome5Brand.google_pay).build();
    public static final FontAwesome5IconType google_play = on(FontAwesome5Brand.google_play).build();
    public static final FontAwesome5IconType google_plus = on(FontAwesome5Brand.google_plus).build();
    public static final FontAwesome5IconType google_plus_g = on(FontAwesome5Brand.google_plus_g).build();
    public static final FontAwesome5IconType google_plus_square = on(FontAwesome5Brand.google_plus_square).build();
    public static final FontAwesome5IconType google_wallet = on(FontAwesome5Brand.google_wallet).build();
    public static final FontAwesome5IconType gratipay = on(FontAwesome5Brand.gratipay).build();
    public static final FontAwesome5IconType grav = on(FontAwesome5Brand.grav).build();
    public static final FontAwesome5IconType gripfire = on(FontAwesome5Brand.gripfire).build();
    public static final FontAwesome5IconType grunt = on(FontAwesome5Brand.grunt).build();
    public static final FontAwesome5IconType guilded = on(FontAwesome5Brand.guilded).build();
    public static final FontAwesome5IconType gulp = on(FontAwesome5Brand.gulp).build();
    public static final FontAwesome5IconType hacker_news = on(FontAwesome5Brand.hacker_news).build();
    public static final FontAwesome5IconType hacker_news_square = on(FontAwesome5Brand.hacker_news_square).build();
    public static final FontAwesome5IconType hackerrank = on(FontAwesome5Brand.hackerrank).build();
    public static final FontAwesome5IconType hips = on(FontAwesome5Brand.hips).build();
    public static final FontAwesome5IconType hire_a_helper = on(FontAwesome5Brand.hire_a_helper).build();
    public static final FontAwesome5IconType hive = on(FontAwesome5Brand.hive).build();
    public static final FontAwesome5IconType hooli = on(FontAwesome5Brand.hooli).build();
    public static final FontAwesome5IconType hornbill = on(FontAwesome5Brand.hornbill).build();
    public static final FontAwesome5IconType hotjar = on(FontAwesome5Brand.hotjar).build();
    public static final FontAwesome5IconType houzz = on(FontAwesome5Brand.houzz).build();
    public static final FontAwesome5IconType html5 = on(FontAwesome5Brand.html5).build();
    public static final FontAwesome5IconType hubspot = on(FontAwesome5Brand.hubspot).build();
    public static final FontAwesome5IconType ideal = on(FontAwesome5Brand.ideal).build();
    public static final FontAwesome5IconType imdb = on(FontAwesome5Brand.imdb).build();
    public static final FontAwesome5IconType innosoft = on(FontAwesome5Brand.innosoft).build();
    public static final FontAwesome5IconType instagram = on(FontAwesome5Brand.instagram).build();
    public static final FontAwesome5IconType instagram_square = on(FontAwesome5Brand.instagram_square).build();
    public static final FontAwesome5IconType instalod = on(FontAwesome5Brand.instalod).build();
    public static final FontAwesome5IconType intercom = on(FontAwesome5Brand.intercom).build();
    public static final FontAwesome5IconType internet_explorer = on(FontAwesome5Brand.internet_explorer).build();
    public static final FontAwesome5IconType invision = on(FontAwesome5Brand.invision).build();
    public static final FontAwesome5IconType ioxhost = on(FontAwesome5Brand.ioxhost).build();
    public static final FontAwesome5IconType itch_io = on(FontAwesome5Brand.itch_io).build();
    public static final FontAwesome5IconType itunes = on(FontAwesome5Brand.itunes).build();
    public static final FontAwesome5IconType itunes_note = on(FontAwesome5Brand.itunes_note).build();
    public static final FontAwesome5IconType java = on(FontAwesome5Brand.java).build();
    public static final FontAwesome5IconType jedi_order = on(FontAwesome5Brand.jedi_order).build();
    public static final FontAwesome5IconType jenkins = on(FontAwesome5Brand.jenkins).build();
    public static final FontAwesome5IconType jira = on(FontAwesome5Brand.jira).build();
    public static final FontAwesome5IconType joget = on(FontAwesome5Brand.joget).build();
    public static final FontAwesome5IconType joomla = on(FontAwesome5Brand.joomla).build();
    public static final FontAwesome5IconType js = on(FontAwesome5Brand.js).build();
    public static final FontAwesome5IconType js_square = on(FontAwesome5Brand.js_square).build();
    public static final FontAwesome5IconType jsfiddle = on(FontAwesome5Brand.jsfiddle).build();
    public static final FontAwesome5IconType kaggle = on(FontAwesome5Brand.kaggle).build();
    public static final FontAwesome5IconType keybase = on(FontAwesome5Brand.keybase).build();
    public static final FontAwesome5IconType keycdn = on(FontAwesome5Brand.keycdn).build();
    public static final FontAwesome5IconType kickstarter = on(FontAwesome5Brand.kickstarter).build();
    public static final FontAwesome5IconType kickstarter_k = on(FontAwesome5Brand.kickstarter_k).build();
    public static final FontAwesome5IconType korvue = on(FontAwesome5Brand.korvue).build();
    public static final FontAwesome5IconType laravel = on(FontAwesome5Brand.laravel).build();
    public static final FontAwesome5IconType lastfm = on(FontAwesome5Brand.lastfm).build();
    public static final FontAwesome5IconType lastfm_square = on(FontAwesome5Brand.lastfm_square).build();
    public static final FontAwesome5IconType leanpub = on(FontAwesome5Brand.leanpub).build();
    public static final FontAwesome5IconType less = on(FontAwesome5Brand.less).build();
    public static final FontAwesome5IconType line = on(FontAwesome5Brand.line).build();
    public static final FontAwesome5IconType linkedin = on(FontAwesome5Brand.linkedin).build();
    public static final FontAwesome5IconType linkedin_in = on(FontAwesome5Brand.linkedin_in).build();
    public static final FontAwesome5IconType linode = on(FontAwesome5Brand.linode).build();
    public static final FontAwesome5IconType linux = on(FontAwesome5Brand.linux).build();
    public static final FontAwesome5IconType lyft = on(FontAwesome5Brand.lyft).build();
    public static final FontAwesome5IconType magento = on(FontAwesome5Brand.magento).build();
    public static final FontAwesome5IconType mailchimp = on(FontAwesome5Brand.mailchimp).build();
    public static final FontAwesome5IconType mandalorian = on(FontAwesome5Brand.mandalorian).build();
    public static final FontAwesome5IconType markdown = on(FontAwesome5Brand.markdown).build();
    public static final FontAwesome5IconType mastodon = on(FontAwesome5Brand.mastodon).build();
    public static final FontAwesome5IconType maxcdn = on(FontAwesome5Brand.maxcdn).build();
    public static final FontAwesome5IconType mdb = on(FontAwesome5Brand.mdb).build();
    public static final FontAwesome5IconType medapps = on(FontAwesome5Brand.medapps).build();
    public static final FontAwesome5IconType medium = on(FontAwesome5Brand.medium).build();
    public static final FontAwesome5IconType medium_m = on(FontAwesome5Brand.medium_m).build();
    public static final FontAwesome5IconType medrt = on(FontAwesome5Brand.medrt).build();
    public static final FontAwesome5IconType meetup = on(FontAwesome5Brand.meetup).build();
    public static final FontAwesome5IconType megaport = on(FontAwesome5Brand.megaport).build();
    public static final FontAwesome5IconType mendeley = on(FontAwesome5Brand.mendeley).build();
    public static final FontAwesome5IconType microblog = on(FontAwesome5Brand.microblog).build();
    public static final FontAwesome5IconType microsoft = on(FontAwesome5Brand.microsoft).build();
    public static final FontAwesome5IconType mix = on(FontAwesome5Brand.mix).build();
    public static final FontAwesome5IconType mixcloud = on(FontAwesome5Brand.mixcloud).build();
    public static final FontAwesome5IconType mixer = on(FontAwesome5Brand.mixer).build();
    public static final FontAwesome5IconType mizuni = on(FontAwesome5Brand.mizuni).build();
    public static final FontAwesome5IconType modx = on(FontAwesome5Brand.modx).build();
    public static final FontAwesome5IconType monero = on(FontAwesome5Brand.monero).build();
    public static final FontAwesome5IconType napster = on(FontAwesome5Brand.napster).build();
    public static final FontAwesome5IconType neos = on(FontAwesome5Brand.neos).build();
    public static final FontAwesome5IconType nimblr = on(FontAwesome5Brand.nimblr).build();
    public static final FontAwesome5IconType node = on(FontAwesome5Brand.node).build();
    public static final FontAwesome5IconType node_js = on(FontAwesome5Brand.node_js).build();
    public static final FontAwesome5IconType npm = on(FontAwesome5Brand.npm).build();
    public static final FontAwesome5IconType ns8 = on(FontAwesome5Brand.ns8).build();
    public static final FontAwesome5IconType nutritionix = on(FontAwesome5Brand.nutritionix).build();
    public static final FontAwesome5IconType octopus_deploy = on(FontAwesome5Brand.octopus_deploy).build();
    public static final FontAwesome5IconType odnoklassniki = on(FontAwesome5Brand.odnoklassniki).build();
    public static final FontAwesome5IconType odnoklassniki_square = on(FontAwesome5Brand.odnoklassniki_square).build();
    public static final FontAwesome5IconType old_republic = on(FontAwesome5Brand.old_republic).build();
    public static final FontAwesome5IconType opencart = on(FontAwesome5Brand.opencart).build();
    public static final FontAwesome5IconType openid = on(FontAwesome5Brand.openid).build();
    public static final FontAwesome5IconType opera = on(FontAwesome5Brand.opera).build();
    public static final FontAwesome5IconType optin_monster = on(FontAwesome5Brand.optin_monster).build();
    public static final FontAwesome5IconType orcid = on(FontAwesome5Brand.orcid).build();
    public static final FontAwesome5IconType osi = on(FontAwesome5Brand.osi).build();
    public static final FontAwesome5IconType page4 = on(FontAwesome5Brand.page4).build();
    public static final FontAwesome5IconType pagelines = on(FontAwesome5Brand.pagelines).build();
    public static final FontAwesome5IconType palfed = on(FontAwesome5Brand.palfed).build();
    public static final FontAwesome5IconType patreon = on(FontAwesome5Brand.patreon).build();
    public static final FontAwesome5IconType paypal = on(FontAwesome5Brand.paypal).build();
    public static final FontAwesome5IconType penny_arcade = on(FontAwesome5Brand.penny_arcade).build();
    public static final FontAwesome5IconType perbyte = on(FontAwesome5Brand.perbyte).build();
    public static final FontAwesome5IconType periscope = on(FontAwesome5Brand.periscope).build();
    public static final FontAwesome5IconType phabricator = on(FontAwesome5Brand.phabricator).build();
    public static final FontAwesome5IconType phoenix_framework = on(FontAwesome5Brand.phoenix_framework).build();
    public static final FontAwesome5IconType phoenix_squadron = on(FontAwesome5Brand.phoenix_squadron).build();
    public static final FontAwesome5IconType php = on(FontAwesome5Brand.php).build();
    public static final FontAwesome5IconType pied_piper = on(FontAwesome5Brand.pied_piper).build();
    public static final FontAwesome5IconType pied_piper_alt = on(FontAwesome5Brand.pied_piper_alt).build();
    public static final FontAwesome5IconType pied_piper_hat = on(FontAwesome5Brand.pied_piper_hat).build();
    public static final FontAwesome5IconType pied_piper_pp = on(FontAwesome5Brand.pied_piper_pp).build();
    public static final FontAwesome5IconType pied_piper_square = on(FontAwesome5Brand.pied_piper_square).build();
    public static final FontAwesome5IconType pinterest = on(FontAwesome5Brand.pinterest).build();
    public static final FontAwesome5IconType pinterest_p = on(FontAwesome5Brand.pinterest_p).build();
    public static final FontAwesome5IconType pinterest_square = on(FontAwesome5Brand.pinterest_square).build();
    public static final FontAwesome5IconType playstation = on(FontAwesome5Brand.playstation).build();
    public static final FontAwesome5IconType product_hunt = on(FontAwesome5Brand.product_hunt).build();
    public static final FontAwesome5IconType pushed = on(FontAwesome5Brand.pushed).build();
    public static final FontAwesome5IconType python = on(FontAwesome5Brand.python).build();
    public static final FontAwesome5IconType qq = on(FontAwesome5Brand.qq).build();
    public static final FontAwesome5IconType quinscape = on(FontAwesome5Brand.quinscape).build();
    public static final FontAwesome5IconType quora = on(FontAwesome5Brand.quora).build();
    public static final FontAwesome5IconType r_project = on(FontAwesome5Brand.r_project).build();
    public static final FontAwesome5IconType raspberry_pi = on(FontAwesome5Brand.raspberry_pi).build();
    public static final FontAwesome5IconType ravelry = on(FontAwesome5Brand.ravelry).build();
    public static final FontAwesome5IconType react = on(FontAwesome5Brand.react).build();
    public static final FontAwesome5IconType reacteurope = on(FontAwesome5Brand.reacteurope).build();
    public static final FontAwesome5IconType readme = on(FontAwesome5Brand.readme).build();
    public static final FontAwesome5IconType rebel = on(FontAwesome5Brand.rebel).build();
    public static final FontAwesome5IconType red_river = on(FontAwesome5Brand.red_river).build();
    public static final FontAwesome5IconType reddit = on(FontAwesome5Brand.reddit).build();
    public static final FontAwesome5IconType reddit_alien = on(FontAwesome5Brand.reddit_alien).build();
    public static final FontAwesome5IconType reddit_square = on(FontAwesome5Brand.reddit_square).build();
    public static final FontAwesome5IconType redhat = on(FontAwesome5Brand.redhat).build();
    public static final FontAwesome5IconType renren = on(FontAwesome5Brand.renren).build();
    public static final FontAwesome5IconType replyd = on(FontAwesome5Brand.replyd).build();
    public static final FontAwesome5IconType researchgate = on(FontAwesome5Brand.researchgate).build();
    public static final FontAwesome5IconType resolving = on(FontAwesome5Brand.resolving).build();
    public static final FontAwesome5IconType rev = on(FontAwesome5Brand.rev).build();
    public static final FontAwesome5IconType rocketchat = on(FontAwesome5Brand.rocketchat).build();
    public static final FontAwesome5IconType rockrms = on(FontAwesome5Brand.rockrms).build();
    public static final FontAwesome5IconType rust = on(FontAwesome5Brand.rust).build();
    public static final FontAwesome5IconType safari = on(FontAwesome5Brand.safari).build();
    public static final FontAwesome5IconType salesforce = on(FontAwesome5Brand.salesforce).build();
    public static final FontAwesome5IconType sass = on(FontAwesome5Brand.sass).build();
    public static final FontAwesome5IconType schlix = on(FontAwesome5Brand.schlix).build();
    public static final FontAwesome5IconType scribd = on(FontAwesome5Brand.scribd).build();
    public static final FontAwesome5IconType searchengin = on(FontAwesome5Brand.searchengin).build();
    public static final FontAwesome5IconType sellcast = on(FontAwesome5Brand.sellcast).build();
    public static final FontAwesome5IconType sellsy = on(FontAwesome5Brand.sellsy).build();
    public static final FontAwesome5IconType servicestack = on(FontAwesome5Brand.servicestack).build();
    public static final FontAwesome5IconType shirtsinbulk = on(FontAwesome5Brand.shirtsinbulk).build();
    public static final FontAwesome5IconType shopify = on(FontAwesome5Brand.shopify).build();
    public static final FontAwesome5IconType shopware = on(FontAwesome5Brand.shopware).build();
    public static final FontAwesome5IconType simplybuilt = on(FontAwesome5Brand.simplybuilt).build();
    public static final FontAwesome5IconType sistrix = on(FontAwesome5Brand.sistrix).build();
    public static final FontAwesome5IconType sith = on(FontAwesome5Brand.sith).build();
    public static final FontAwesome5IconType sketch = on(FontAwesome5Brand.sketch).build();
    public static final FontAwesome5IconType skyatlas = on(FontAwesome5Brand.skyatlas).build();
    public static final FontAwesome5IconType skype = on(FontAwesome5Brand.skype).build();
    public static final FontAwesome5IconType slack = on(FontAwesome5Brand.slack).build();
    public static final FontAwesome5IconType slack_hash = on(FontAwesome5Brand.slack_hash).build();
    public static final FontAwesome5IconType slideshare = on(FontAwesome5Brand.slideshare).build();
    public static final FontAwesome5IconType snapchat = on(FontAwesome5Brand.snapchat).build();
    public static final FontAwesome5IconType snapchat_ghost = on(FontAwesome5Brand.snapchat_ghost).build();
    public static final FontAwesome5IconType snapchat_square = on(FontAwesome5Brand.snapchat_square).build();
    public static final FontAwesome5IconType soundcloud = on(FontAwesome5Brand.soundcloud).build();
    public static final FontAwesome5IconType sourcetree = on(FontAwesome5Brand.sourcetree).build();
    public static final FontAwesome5IconType speakap = on(FontAwesome5Brand.speakap).build();
    public static final FontAwesome5IconType speaker_deck = on(FontAwesome5Brand.speaker_deck).build();
    public static final FontAwesome5IconType spotify = on(FontAwesome5Brand.spotify).build();
    public static final FontAwesome5IconType squarespace = on(FontAwesome5Brand.squarespace).build();
    public static final FontAwesome5IconType stack_exchange = on(FontAwesome5Brand.stack_exchange).build();
    public static final FontAwesome5IconType stack_overflow = on(FontAwesome5Brand.stack_overflow).build();
    public static final FontAwesome5IconType stackpath = on(FontAwesome5Brand.stackpath).build();
    public static final FontAwesome5IconType staylinked = on(FontAwesome5Brand.staylinked).build();
    public static final FontAwesome5IconType steam = on(FontAwesome5Brand.steam).build();
    public static final FontAwesome5IconType steam_square = on(FontAwesome5Brand.steam_square).build();
    public static final FontAwesome5IconType steam_symbol = on(FontAwesome5Brand.steam_symbol).build();
    public static final FontAwesome5IconType sticker_mule = on(FontAwesome5Brand.sticker_mule).build();
    public static final FontAwesome5IconType strava = on(FontAwesome5Brand.strava).build();
    public static final FontAwesome5IconType stripe = on(FontAwesome5Brand.stripe).build();
    public static final FontAwesome5IconType stripe_s = on(FontAwesome5Brand.stripe_s).build();
    public static final FontAwesome5IconType studiovinari = on(FontAwesome5Brand.studiovinari).build();
    public static final FontAwesome5IconType stumbleupon = on(FontAwesome5Brand.stumbleupon).build();
    public static final FontAwesome5IconType stumbleupon_circle = on(FontAwesome5Brand.stumbleupon_circle).build();
    public static final FontAwesome5IconType superpowers = on(FontAwesome5Brand.superpowers).build();
    public static final FontAwesome5IconType supple = on(FontAwesome5Brand.supple).build();
    public static final FontAwesome5IconType suse = on(FontAwesome5Brand.suse).build();
    public static final FontAwesome5IconType swift = on(FontAwesome5Brand.swift).build();
    public static final FontAwesome5IconType symfony = on(FontAwesome5Brand.symfony).build();
    public static final FontAwesome5IconType teamspeak = on(FontAwesome5Brand.teamspeak).build();
    public static final FontAwesome5IconType telegram = on(FontAwesome5Brand.telegram).build();
    public static final FontAwesome5IconType telegram_plane = on(FontAwesome5Brand.telegram_plane).build();
    public static final FontAwesome5IconType tencent_weibo = on(FontAwesome5Brand.tencent_weibo).build();
    public static final FontAwesome5IconType the_red_yeti = on(FontAwesome5Brand.the_red_yeti).build();
    public static final FontAwesome5IconType themeco = on(FontAwesome5Brand.themeco).build();
    public static final FontAwesome5IconType themeisle = on(FontAwesome5Brand.themeisle).build();
    public static final FontAwesome5IconType think_peaks = on(FontAwesome5Brand.think_peaks).build();
    public static final FontAwesome5IconType tiktok = on(FontAwesome5Brand.tiktok).build();
    public static final FontAwesome5IconType trade_federation = on(FontAwesome5Brand.trade_federation).build();
    public static final FontAwesome5IconType trello = on(FontAwesome5Brand.trello).build();
    public static final FontAwesome5IconType tripadvisor = on(FontAwesome5Brand.tripadvisor).build();
    public static final FontAwesome5IconType tumblr = on(FontAwesome5Brand.tumblr).build();
    public static final FontAwesome5IconType tumblr_square = on(FontAwesome5Brand.tumblr_square).build();
    public static final FontAwesome5IconType twitch = on(FontAwesome5Brand.twitch).build();
    public static final FontAwesome5IconType twitter = on(FontAwesome5Brand.twitter).build();
    public static final FontAwesome5IconType twitter_square = on(FontAwesome5Brand.twitter_square).build();
    public static final FontAwesome5IconType typo3 = on(FontAwesome5Brand.typo3).build();
    public static final FontAwesome5IconType uber = on(FontAwesome5Brand.uber).build();
    public static final FontAwesome5IconType ubuntu = on(FontAwesome5Brand.ubuntu).build();
    public static final FontAwesome5IconType uikit = on(FontAwesome5Brand.uikit).build();
    public static final FontAwesome5IconType umbraco = on(FontAwesome5Brand.umbraco).build();
    public static final FontAwesome5IconType uncharted = on(FontAwesome5Brand.uncharted).build();
    public static final FontAwesome5IconType uniregistry = on(FontAwesome5Brand.uniregistry).build();
    public static final FontAwesome5IconType unity = on(FontAwesome5Brand.unity).build();
    public static final FontAwesome5IconType unsplash = on(FontAwesome5Brand.unsplash).build();
    public static final FontAwesome5IconType untappd = on(FontAwesome5Brand.untappd).build();
    public static final FontAwesome5IconType ups = on(FontAwesome5Brand.ups).build();
    public static final FontAwesome5IconType usb = on(FontAwesome5Brand.usb).build();
    public static final FontAwesome5IconType usps = on(FontAwesome5Brand.usps).build();
    public static final FontAwesome5IconType ussunnah = on(FontAwesome5Brand.ussunnah).build();
    public static final FontAwesome5IconType vaadin = on(FontAwesome5Brand.vaadin).build();
    public static final FontAwesome5IconType viacoin = on(FontAwesome5Brand.viacoin).build();
    public static final FontAwesome5IconType viadeo = on(FontAwesome5Brand.viadeo).build();
    public static final FontAwesome5IconType viadeo_square = on(FontAwesome5Brand.viadeo_square).build();
    public static final FontAwesome5IconType viber = on(FontAwesome5Brand.viber).build();
    public static final FontAwesome5IconType vimeo = on(FontAwesome5Brand.vimeo).build();
    public static final FontAwesome5IconType vimeo_square = on(FontAwesome5Brand.vimeo_square).build();
    public static final FontAwesome5IconType vimeo_v = on(FontAwesome5Brand.vimeo_v).build();
    public static final FontAwesome5IconType vine = on(FontAwesome5Brand.vine).build();
    public static final FontAwesome5IconType vk = on(FontAwesome5Brand.vk).build();
    public static final FontAwesome5IconType vnv = on(FontAwesome5Brand.vnv).build();
    public static final FontAwesome5IconType vuejs = on(FontAwesome5Brand.vuejs).build();
    public static final FontAwesome5IconType watchman_monitoring = on(FontAwesome5Brand.watchman_monitoring).build();
    public static final FontAwesome5IconType waze = on(FontAwesome5Brand.waze).build();
    public static final FontAwesome5IconType weebly = on(FontAwesome5Brand.weebly).build();
    public static final FontAwesome5IconType weibo = on(FontAwesome5Brand.weibo).build();
    public static final FontAwesome5IconType weixin = on(FontAwesome5Brand.weixin).build();
    public static final FontAwesome5IconType whatsapp = on(FontAwesome5Brand.whatsapp).build();
    public static final FontAwesome5IconType whatsapp_square = on(FontAwesome5Brand.whatsapp_square).build();
    public static final FontAwesome5IconType whmcs = on(FontAwesome5Brand.whmcs).build();
    public static final FontAwesome5IconType wikipedia_w = on(FontAwesome5Brand.wikipedia_w).build();
    public static final FontAwesome5IconType windows = on(FontAwesome5Brand.windows).build();
    public static final FontAwesome5IconType wix = on(FontAwesome5Brand.wix).build();
    public static final FontAwesome5IconType wizards_of_the_coast = on(FontAwesome5Brand.wizards_of_the_coast).build();
    public static final FontAwesome5IconType wodu = on(FontAwesome5Brand.wodu).build();
    public static final FontAwesome5IconType wolf_pack_battalion = on(FontAwesome5Brand.wolf_pack_battalion).build();
    public static final FontAwesome5IconType wordpress = on(FontAwesome5Brand.wordpress).build();
    public static final FontAwesome5IconType wordpress_simple = on(FontAwesome5Brand.wordpress_simple).build();
    public static final FontAwesome5IconType wpbeginner = on(FontAwesome5Brand.wpbeginner).build();
    public static final FontAwesome5IconType wpexplorer = on(FontAwesome5Brand.wpexplorer).build();
    public static final FontAwesome5IconType wpforms = on(FontAwesome5Brand.wpforms).build();
    public static final FontAwesome5IconType wpressr = on(FontAwesome5Brand.wpressr).build();
    public static final FontAwesome5IconType xbox = on(FontAwesome5Brand.xbox).build();
    public static final FontAwesome5IconType xing = on(FontAwesome5Brand.xing).build();
    public static final FontAwesome5IconType xing_square = on(FontAwesome5Brand.xing_square).build();
    public static final FontAwesome5IconType y_combinator = on(FontAwesome5Brand.y_combinator).build();
    public static final FontAwesome5IconType yahoo = on(FontAwesome5Brand.yahoo).build();
    public static final FontAwesome5IconType yammer = on(FontAwesome5Brand.yammer).build();
    public static final FontAwesome5IconType yandex = on(FontAwesome5Brand.yandex).build();
    public static final FontAwesome5IconType yandex_international = on(FontAwesome5Brand.yandex_international).build();
    public static final FontAwesome5IconType yarn = on(FontAwesome5Brand.yarn).build();
    public static final FontAwesome5IconType yelp = on(FontAwesome5Brand.yelp).build();
    public static final FontAwesome5IconType yoast = on(FontAwesome5Brand.yoast).build();
    public static final FontAwesome5IconType youtube = on(FontAwesome5Brand.youtube).build();
    public static final FontAwesome5IconType youtube_square = on(FontAwesome5Brand.youtube_square).build();
    public static final FontAwesome5IconType zhihu = on(FontAwesome5Brand.zhihu).build();

    /**
     * Constructor.
     *
     * @param cssClassName The css class name of the icon reference
     */
    FontAwesome5IconType(final String... cssClassName) {
        super(Strings.join(" ", cssClassName));
    }

    @Override
    public String cssClassName() {
        return getCssClassName();
    }
}
