package de.agilecoders.wicket.extensions.markup.html.bootstrap.icon;

import static de.agilecoders.wicket.extensions.markup.html.bootstrap.icon.FontAwesome6IconTypeBuilder.on;

import org.apache.wicket.util.string.Strings;

import de.agilecoders.wicket.core.markup.html.bootstrap.image.IconType;
import de.agilecoders.wicket.extensions.markup.html.bootstrap.icon.FontAwesome6IconTypeBuilder.FontAwesome6Brand;
import de.agilecoders.wicket.extensions.markup.html.bootstrap.icon.FontAwesome6IconTypeBuilder.FontAwesome6Regular;
import de.agilecoders.wicket.extensions.markup.html.bootstrap.icon.FontAwesome6IconTypeBuilder.FontAwesome6Solid;

/**
 * <strong>Important</strong>: To use font-awesome 6.x you need to declare the Maven/Gradle dependency
 * in your application pom.xml/build.gradle, for example:
 *
 * <br/>
 *  &lt;dependency&gt;<br/>
 *      &lt;groupId&gt;org.webjars&lt;/groupId&gt;<br/>
 *      &lt;artifactId&gt;font-awesome&lt;/artifactId&gt;<br/>
 *      &lt;version&gt;6.2.0&lt;/version&gt;<br/>
 *  &lt;/dependency&gt;<br/>
 *
 * All the icon types.
 */
public class FontAwesome6IconType extends IconType {

    /**
     * serialVersionUID.
     */
    private static final long serialVersionUID = 1L;

    // icon types of style 'solid' (tag '_s') and 'regular' (tag '_r') (where free)

    public static final FontAwesome6IconType _0_s = on(FontAwesome6Solid._0).build();
    public static final FontAwesome6IconType _1_s = on(FontAwesome6Solid._1).build();
    public static final FontAwesome6IconType _2_s = on(FontAwesome6Solid._2).build();
    public static final FontAwesome6IconType _3_s = on(FontAwesome6Solid._3).build();
    public static final FontAwesome6IconType _4_s = on(FontAwesome6Solid._4).build();
    public static final FontAwesome6IconType _5_s = on(FontAwesome6Solid._5).build();
    public static final FontAwesome6IconType _6_s = on(FontAwesome6Solid._6).build();
    public static final FontAwesome6IconType _7_s = on(FontAwesome6Solid._7).build();
    public static final FontAwesome6IconType _8_s = on(FontAwesome6Solid._8).build();
    public static final FontAwesome6IconType _9_s = on(FontAwesome6Solid._9).build();
    public static final FontAwesome6IconType a_s = on(FontAwesome6Solid.a).build();
    public static final FontAwesome6IconType address_book_r = on(FontAwesome6Regular.address_book).build();
    public static final FontAwesome6IconType address_book_s = on(FontAwesome6Solid.address_book).build();
    public static final FontAwesome6IconType address_card_r = on(FontAwesome6Regular.address_card).build();
    public static final FontAwesome6IconType address_card_s = on(FontAwesome6Solid.address_card).build();
    public static final FontAwesome6IconType align_center_s = on(FontAwesome6Solid.align_center).build();
    public static final FontAwesome6IconType align_justify_s = on(FontAwesome6Solid.align_justify).build();
    public static final FontAwesome6IconType align_left_s = on(FontAwesome6Solid.align_left).build();
    public static final FontAwesome6IconType align_right_s = on(FontAwesome6Solid.align_right).build();
    public static final FontAwesome6IconType anchor_circle_check_s = on(FontAwesome6Solid.anchor_circle_check).build();
    public static final FontAwesome6IconType anchor_circle_exclamation_s = on(FontAwesome6Solid.anchor_circle_exclamation).build();
    public static final FontAwesome6IconType anchor_circle_xmark_s = on(FontAwesome6Solid.anchor_circle_xmark).build();
    public static final FontAwesome6IconType anchor_lock_s = on(FontAwesome6Solid.anchor_lock).build();
    public static final FontAwesome6IconType anchor_s = on(FontAwesome6Solid.anchor).build();
    public static final FontAwesome6IconType angle_down_s = on(FontAwesome6Solid.angle_down).build();
    public static final FontAwesome6IconType angle_left_s = on(FontAwesome6Solid.angle_left).build();
    public static final FontAwesome6IconType angle_right_s = on(FontAwesome6Solid.angle_right).build();
    public static final FontAwesome6IconType angle_up_s = on(FontAwesome6Solid.angle_up).build();
    public static final FontAwesome6IconType angles_down_s = on(FontAwesome6Solid.angles_down).build();
    public static final FontAwesome6IconType angles_left_s = on(FontAwesome6Solid.angles_left).build();
    public static final FontAwesome6IconType angles_right_s = on(FontAwesome6Solid.angles_right).build();
    public static final FontAwesome6IconType angles_up_s = on(FontAwesome6Solid.angles_up).build();
    public static final FontAwesome6IconType ankh_s = on(FontAwesome6Solid.ankh).build();
    public static final FontAwesome6IconType apple_whole_s = on(FontAwesome6Solid.apple_whole).build();
    public static final FontAwesome6IconType archway_s = on(FontAwesome6Solid.archway).build();
    public static final FontAwesome6IconType arrow_down_1_9_s = on(FontAwesome6Solid.arrow_down_1_9).build();
    public static final FontAwesome6IconType arrow_down_9_1_s = on(FontAwesome6Solid.arrow_down_9_1).build();
    public static final FontAwesome6IconType arrow_down_a_z_s = on(FontAwesome6Solid.arrow_down_a_z).build();
    public static final FontAwesome6IconType arrow_down_long_s = on(FontAwesome6Solid.arrow_down_long).build();
    public static final FontAwesome6IconType arrow_down_s = on(FontAwesome6Solid.arrow_down).build();
    public static final FontAwesome6IconType arrow_down_short_wide_s = on(FontAwesome6Solid.arrow_down_short_wide).build();
    public static final FontAwesome6IconType arrow_down_up_across_line_s = on(FontAwesome6Solid.arrow_down_up_across_line).build();
    public static final FontAwesome6IconType arrow_down_up_lock_s = on(FontAwesome6Solid.arrow_down_up_lock).build();
    public static final FontAwesome6IconType arrow_down_wide_short_s = on(FontAwesome6Solid.arrow_down_wide_short).build();
    public static final FontAwesome6IconType arrow_down_z_a_s = on(FontAwesome6Solid.arrow_down_z_a).build();
    public static final FontAwesome6IconType arrow_left_long_s = on(FontAwesome6Solid.arrow_left_long).build();
    public static final FontAwesome6IconType arrow_left_s = on(FontAwesome6Solid.arrow_left).build();
    public static final FontAwesome6IconType arrow_pointer_s = on(FontAwesome6Solid.arrow_pointer).build();
    public static final FontAwesome6IconType arrow_right_arrow_left_s = on(FontAwesome6Solid.arrow_right_arrow_left).build();
    public static final FontAwesome6IconType arrow_right_from_bracket_s = on(FontAwesome6Solid.arrow_right_from_bracket).build();
    public static final FontAwesome6IconType arrow_right_long_s = on(FontAwesome6Solid.arrow_right_long).build();
    public static final FontAwesome6IconType arrow_right_s = on(FontAwesome6Solid.arrow_right).build();
    public static final FontAwesome6IconType arrow_right_to_bracket_s = on(FontAwesome6Solid.arrow_right_to_bracket).build();
    public static final FontAwesome6IconType arrow_right_to_city_s = on(FontAwesome6Solid.arrow_right_to_city).build();
    public static final FontAwesome6IconType arrow_rotate_left_s = on(FontAwesome6Solid.arrow_rotate_left).build();
    public static final FontAwesome6IconType arrow_rotate_right_s = on(FontAwesome6Solid.arrow_rotate_right).build();
    public static final FontAwesome6IconType arrow_trend_down_s = on(FontAwesome6Solid.arrow_trend_down).build();
    public static final FontAwesome6IconType arrow_trend_up_s = on(FontAwesome6Solid.arrow_trend_up).build();
    public static final FontAwesome6IconType arrow_turn_down_s = on(FontAwesome6Solid.arrow_turn_down).build();
    public static final FontAwesome6IconType arrow_turn_up_s = on(FontAwesome6Solid.arrow_turn_up).build();
    public static final FontAwesome6IconType arrow_up_1_9_s = on(FontAwesome6Solid.arrow_up_1_9).build();
    public static final FontAwesome6IconType arrow_up_9_1_s = on(FontAwesome6Solid.arrow_up_9_1).build();
    public static final FontAwesome6IconType arrow_up_a_z_s = on(FontAwesome6Solid.arrow_up_a_z).build();
    public static final FontAwesome6IconType arrow_up_from_bracket_s = on(FontAwesome6Solid.arrow_up_from_bracket).build();
    public static final FontAwesome6IconType arrow_up_from_ground_water_s = on(FontAwesome6Solid.arrow_up_from_ground_water).build();
    public static final FontAwesome6IconType arrow_up_from_water_pump_s = on(FontAwesome6Solid.arrow_up_from_water_pump).build();
    public static final FontAwesome6IconType arrow_up_long_s = on(FontAwesome6Solid.arrow_up_long).build();
    public static final FontAwesome6IconType arrow_up_right_dots_s = on(FontAwesome6Solid.arrow_up_right_dots).build();
    public static final FontAwesome6IconType arrow_up_right_from_square_s = on(FontAwesome6Solid.arrow_up_right_from_square).build();
    public static final FontAwesome6IconType arrow_up_s = on(FontAwesome6Solid.arrow_up).build();
    public static final FontAwesome6IconType arrow_up_short_wide_s = on(FontAwesome6Solid.arrow_up_short_wide).build();
    public static final FontAwesome6IconType arrow_up_wide_short_s = on(FontAwesome6Solid.arrow_up_wide_short).build();
    public static final FontAwesome6IconType arrow_up_z_a_s = on(FontAwesome6Solid.arrow_up_z_a).build();
    public static final FontAwesome6IconType arrows_down_to_line_s = on(FontAwesome6Solid.arrows_down_to_line).build();
    public static final FontAwesome6IconType arrows_down_to_people_s = on(FontAwesome6Solid.arrows_down_to_people).build();
    public static final FontAwesome6IconType arrows_left_right_s = on(FontAwesome6Solid.arrows_left_right).build();
    public static final FontAwesome6IconType arrows_left_right_to_line_s = on(FontAwesome6Solid.arrows_left_right_to_line).build();
    public static final FontAwesome6IconType arrows_rotate_s = on(FontAwesome6Solid.arrows_rotate).build();
    public static final FontAwesome6IconType arrows_spin_s = on(FontAwesome6Solid.arrows_spin).build();
    public static final FontAwesome6IconType arrows_split_up_and_left_s = on(FontAwesome6Solid.arrows_split_up_and_left).build();
    public static final FontAwesome6IconType arrows_to_circle_s = on(FontAwesome6Solid.arrows_to_circle).build();
    public static final FontAwesome6IconType arrows_to_dot_s = on(FontAwesome6Solid.arrows_to_dot).build();
    public static final FontAwesome6IconType arrows_to_eye_s = on(FontAwesome6Solid.arrows_to_eye).build();
    public static final FontAwesome6IconType arrows_turn_right_s = on(FontAwesome6Solid.arrows_turn_right).build();
    public static final FontAwesome6IconType arrows_turn_to_dots_s = on(FontAwesome6Solid.arrows_turn_to_dots).build();
    public static final FontAwesome6IconType arrows_up_down_left_right_s = on(FontAwesome6Solid.arrows_up_down_left_right).build();
    public static final FontAwesome6IconType arrows_up_down_s = on(FontAwesome6Solid.arrows_up_down).build();
    public static final FontAwesome6IconType arrows_up_to_line_s = on(FontAwesome6Solid.arrows_up_to_line).build();
    public static final FontAwesome6IconType asterisk_s = on(FontAwesome6Solid.asterisk).build();
    public static final FontAwesome6IconType at_s = on(FontAwesome6Solid.at).build();
    public static final FontAwesome6IconType atom_s = on(FontAwesome6Solid.atom).build();
    public static final FontAwesome6IconType audio_description_s = on(FontAwesome6Solid.audio_description).build();
    public static final FontAwesome6IconType austral_sign_s = on(FontAwesome6Solid.austral_sign).build();
    public static final FontAwesome6IconType award_s = on(FontAwesome6Solid.award).build();
    public static final FontAwesome6IconType b_s = on(FontAwesome6Solid.b).build();
    public static final FontAwesome6IconType baby_carriage_s = on(FontAwesome6Solid.baby_carriage).build();
    public static final FontAwesome6IconType baby_s = on(FontAwesome6Solid.baby).build();
    public static final FontAwesome6IconType backward_fast_s = on(FontAwesome6Solid.backward_fast).build();
    public static final FontAwesome6IconType backward_s = on(FontAwesome6Solid.backward).build();
    public static final FontAwesome6IconType backward_step_s = on(FontAwesome6Solid.backward_step).build();
    public static final FontAwesome6IconType bacon_s = on(FontAwesome6Solid.bacon).build();
    public static final FontAwesome6IconType bacteria_s = on(FontAwesome6Solid.bacteria).build();
    public static final FontAwesome6IconType bacterium_s = on(FontAwesome6Solid.bacterium).build();
    public static final FontAwesome6IconType bag_shopping_s = on(FontAwesome6Solid.bag_shopping).build();
    public static final FontAwesome6IconType bahai_s = on(FontAwesome6Solid.bahai).build();
    public static final FontAwesome6IconType baht_sign_s = on(FontAwesome6Solid.baht_sign).build();
    public static final FontAwesome6IconType ban_s = on(FontAwesome6Solid.ban).build();
    public static final FontAwesome6IconType ban_smoking_s = on(FontAwesome6Solid.ban_smoking).build();
    public static final FontAwesome6IconType bandage_s = on(FontAwesome6Solid.bandage).build();
    public static final FontAwesome6IconType bangladeshi_taka_sign_s = on(FontAwesome6Solid.bangladeshi_taka_sign).build();
    public static final FontAwesome6IconType barcode_s = on(FontAwesome6Solid.barcode).build();
    public static final FontAwesome6IconType bars_progress_s = on(FontAwesome6Solid.bars_progress).build();
    public static final FontAwesome6IconType bars_s = on(FontAwesome6Solid.bars).build();
    public static final FontAwesome6IconType bars_staggered_s = on(FontAwesome6Solid.bars_staggered).build();
    public static final FontAwesome6IconType baseball_bat_ball_s = on(FontAwesome6Solid.baseball_bat_ball).build();
    public static final FontAwesome6IconType baseball_s = on(FontAwesome6Solid.baseball).build();
    public static final FontAwesome6IconType basket_shopping_s = on(FontAwesome6Solid.basket_shopping).build();
    public static final FontAwesome6IconType basketball_s = on(FontAwesome6Solid.basketball).build();
    public static final FontAwesome6IconType bath_s = on(FontAwesome6Solid.bath).build();
    public static final FontAwesome6IconType battery_empty_s = on(FontAwesome6Solid.battery_empty).build();
    public static final FontAwesome6IconType battery_full_s = on(FontAwesome6Solid.battery_full).build();
    public static final FontAwesome6IconType battery_half_s = on(FontAwesome6Solid.battery_half).build();
    public static final FontAwesome6IconType battery_quarter_s = on(FontAwesome6Solid.battery_quarter).build();
    public static final FontAwesome6IconType battery_three_quarters_s = on(FontAwesome6Solid.battery_three_quarters).build();
    public static final FontAwesome6IconType bed_pulse_s = on(FontAwesome6Solid.bed_pulse).build();
    public static final FontAwesome6IconType bed_s = on(FontAwesome6Solid.bed).build();
    public static final FontAwesome6IconType beer_mug_empty_s = on(FontAwesome6Solid.beer_mug_empty).build();
    public static final FontAwesome6IconType bell_concierge_s = on(FontAwesome6Solid.bell_concierge).build();
    public static final FontAwesome6IconType bell_r = on(FontAwesome6Regular.bell).build();
    public static final FontAwesome6IconType bell_s = on(FontAwesome6Solid.bell).build();
    public static final FontAwesome6IconType bell_slash_r = on(FontAwesome6Regular.bell_slash).build();
    public static final FontAwesome6IconType bell_slash_s = on(FontAwesome6Solid.bell_slash).build();
    public static final FontAwesome6IconType bezier_curve_s = on(FontAwesome6Solid.bezier_curve).build();
    public static final FontAwesome6IconType bicycle_s = on(FontAwesome6Solid.bicycle).build();
    public static final FontAwesome6IconType binoculars_s = on(FontAwesome6Solid.binoculars).build();
    public static final FontAwesome6IconType biohazard_s = on(FontAwesome6Solid.biohazard).build();
    public static final FontAwesome6IconType bitcoin_sign_s = on(FontAwesome6Solid.bitcoin_sign).build();
    public static final FontAwesome6IconType blender_phone_s = on(FontAwesome6Solid.blender_phone).build();
    public static final FontAwesome6IconType blender_s = on(FontAwesome6Solid.blender).build();
    public static final FontAwesome6IconType blog_s = on(FontAwesome6Solid.blog).build();
    public static final FontAwesome6IconType bold_s = on(FontAwesome6Solid.bold).build();
    public static final FontAwesome6IconType bolt_lightning_s = on(FontAwesome6Solid.bolt_lightning).build();
    public static final FontAwesome6IconType bolt_s = on(FontAwesome6Solid.bolt).build();
    public static final FontAwesome6IconType bomb_s = on(FontAwesome6Solid.bomb).build();
    public static final FontAwesome6IconType bone_s = on(FontAwesome6Solid.bone).build();
    public static final FontAwesome6IconType bong_s = on(FontAwesome6Solid.bong).build();
    public static final FontAwesome6IconType book_atlas_s = on(FontAwesome6Solid.book_atlas).build();
    public static final FontAwesome6IconType book_bible_s = on(FontAwesome6Solid.book_bible).build();
    public static final FontAwesome6IconType book_bookmark_s = on(FontAwesome6Solid.book_bookmark).build();
    public static final FontAwesome6IconType book_journal_whills_s = on(FontAwesome6Solid.book_journal_whills).build();
    public static final FontAwesome6IconType book_medical_s = on(FontAwesome6Solid.book_medical).build();
    public static final FontAwesome6IconType book_open_reader_s = on(FontAwesome6Solid.book_open_reader).build();
    public static final FontAwesome6IconType book_open_s = on(FontAwesome6Solid.book_open).build();
    public static final FontAwesome6IconType book_quran_s = on(FontAwesome6Solid.book_quran).build();
    public static final FontAwesome6IconType book_s = on(FontAwesome6Solid.book).build();
    public static final FontAwesome6IconType book_skull_s = on(FontAwesome6Solid.book_skull).build();
    public static final FontAwesome6IconType book_tanakh_s = on(FontAwesome6Solid.book_tanakh).build();
    public static final FontAwesome6IconType bookmark_r = on(FontAwesome6Regular.bookmark).build();
    public static final FontAwesome6IconType bookmark_s = on(FontAwesome6Solid.bookmark).build();
    public static final FontAwesome6IconType border_all_s = on(FontAwesome6Solid.border_all).build();
    public static final FontAwesome6IconType border_none_s = on(FontAwesome6Solid.border_none).build();
    public static final FontAwesome6IconType border_top_left_s = on(FontAwesome6Solid.border_top_left).build();
    public static final FontAwesome6IconType bore_hole_s = on(FontAwesome6Solid.bore_hole).build();
    public static final FontAwesome6IconType bottle_droplet_s = on(FontAwesome6Solid.bottle_droplet).build();
    public static final FontAwesome6IconType bottle_water_s = on(FontAwesome6Solid.bottle_water).build();
    public static final FontAwesome6IconType bowl_food_s = on(FontAwesome6Solid.bowl_food).build();
    public static final FontAwesome6IconType bowl_rice_s = on(FontAwesome6Solid.bowl_rice).build();
    public static final FontAwesome6IconType bowling_ball_s = on(FontAwesome6Solid.bowling_ball).build();
    public static final FontAwesome6IconType box_archive_s = on(FontAwesome6Solid.box_archive).build();
    public static final FontAwesome6IconType box_open_s = on(FontAwesome6Solid.box_open).build();
    public static final FontAwesome6IconType box_s = on(FontAwesome6Solid.box).build();
    public static final FontAwesome6IconType box_tissue_s = on(FontAwesome6Solid.box_tissue).build();
    public static final FontAwesome6IconType boxes_packing_s = on(FontAwesome6Solid.boxes_packing).build();
    public static final FontAwesome6IconType boxes_stacked_s = on(FontAwesome6Solid.boxes_stacked).build();
    public static final FontAwesome6IconType braille_s = on(FontAwesome6Solid.braille).build();
    public static final FontAwesome6IconType brain_s = on(FontAwesome6Solid.brain).build();
    public static final FontAwesome6IconType brazilian_real_sign_s = on(FontAwesome6Solid.brazilian_real_sign).build();
    public static final FontAwesome6IconType bread_slice_s = on(FontAwesome6Solid.bread_slice).build();
    public static final FontAwesome6IconType bridge_circle_check_s = on(FontAwesome6Solid.bridge_circle_check).build();
    public static final FontAwesome6IconType bridge_circle_exclamation_s = on(FontAwesome6Solid.bridge_circle_exclamation).build();
    public static final FontAwesome6IconType bridge_circle_xmark_s = on(FontAwesome6Solid.bridge_circle_xmark).build();
    public static final FontAwesome6IconType bridge_lock_s = on(FontAwesome6Solid.bridge_lock).build();
    public static final FontAwesome6IconType bridge_s = on(FontAwesome6Solid.bridge).build();
    public static final FontAwesome6IconType bridge_water_s = on(FontAwesome6Solid.bridge_water).build();
    public static final FontAwesome6IconType briefcase_medical_s = on(FontAwesome6Solid.briefcase_medical).build();
    public static final FontAwesome6IconType briefcase_s = on(FontAwesome6Solid.briefcase).build();
    public static final FontAwesome6IconType broom_ball_s = on(FontAwesome6Solid.broom_ball).build();
    public static final FontAwesome6IconType broom_s = on(FontAwesome6Solid.broom).build();
    public static final FontAwesome6IconType brush_s = on(FontAwesome6Solid.brush).build();
    public static final FontAwesome6IconType bucket_s = on(FontAwesome6Solid.bucket).build();
    public static final FontAwesome6IconType bug_s = on(FontAwesome6Solid.bug).build();
    public static final FontAwesome6IconType bug_slash_s = on(FontAwesome6Solid.bug_slash).build();
    public static final FontAwesome6IconType bugs_s = on(FontAwesome6Solid.bugs).build();
    public static final FontAwesome6IconType building_circle_arrow_right_s = on(FontAwesome6Solid.building_circle_arrow_right).build();
    public static final FontAwesome6IconType building_circle_check_s = on(FontAwesome6Solid.building_circle_check).build();
    public static final FontAwesome6IconType building_circle_exclamation_s = on(FontAwesome6Solid.building_circle_exclamation).build();
    public static final FontAwesome6IconType building_circle_xmark_s = on(FontAwesome6Solid.building_circle_xmark).build();
    public static final FontAwesome6IconType building_columns_s = on(FontAwesome6Solid.building_columns).build();
    public static final FontAwesome6IconType building_flag_s = on(FontAwesome6Solid.building_flag).build();
    public static final FontAwesome6IconType building_lock_s = on(FontAwesome6Solid.building_lock).build();
    public static final FontAwesome6IconType building_ngo_s = on(FontAwesome6Solid.building_ngo).build();
    public static final FontAwesome6IconType building_r = on(FontAwesome6Regular.building).build();
    public static final FontAwesome6IconType building_s = on(FontAwesome6Solid.building).build();
    public static final FontAwesome6IconType building_shield_s = on(FontAwesome6Solid.building_shield).build();
    public static final FontAwesome6IconType building_un_s = on(FontAwesome6Solid.building_un).build();
    public static final FontAwesome6IconType building_user_s = on(FontAwesome6Solid.building_user).build();
    public static final FontAwesome6IconType building_wheat_s = on(FontAwesome6Solid.building_wheat).build();
    public static final FontAwesome6IconType bullhorn_s = on(FontAwesome6Solid.bullhorn).build();
    public static final FontAwesome6IconType bullseye_s = on(FontAwesome6Solid.bullseye).build();
    public static final FontAwesome6IconType burger_s = on(FontAwesome6Solid.burger).build();
    public static final FontAwesome6IconType burst_s = on(FontAwesome6Solid.burst).build();
    public static final FontAwesome6IconType bus_s = on(FontAwesome6Solid.bus).build();
    public static final FontAwesome6IconType bus_simple_s = on(FontAwesome6Solid.bus_simple).build();
    public static final FontAwesome6IconType business_time_s = on(FontAwesome6Solid.business_time).build();
    public static final FontAwesome6IconType c_s = on(FontAwesome6Solid.c).build();
    public static final FontAwesome6IconType cable_car_s = on(FontAwesome6Solid.cable_car).build();
    public static final FontAwesome6IconType cake_candles_s = on(FontAwesome6Solid.cake_candles).build();
    public static final FontAwesome6IconType calculator_s = on(FontAwesome6Solid.calculator).build();
    public static final FontAwesome6IconType calendar_check_r = on(FontAwesome6Regular.calendar_check).build();
    public static final FontAwesome6IconType calendar_check_s = on(FontAwesome6Solid.calendar_check).build();
    public static final FontAwesome6IconType calendar_day_s = on(FontAwesome6Solid.calendar_day).build();
    public static final FontAwesome6IconType calendar_days_r = on(FontAwesome6Regular.calendar_days).build();
    public static final FontAwesome6IconType calendar_days_s = on(FontAwesome6Solid.calendar_days).build();
    public static final FontAwesome6IconType calendar_minus_r = on(FontAwesome6Regular.calendar_minus).build();
    public static final FontAwesome6IconType calendar_minus_s = on(FontAwesome6Solid.calendar_minus).build();
    public static final FontAwesome6IconType calendar_plus_r = on(FontAwesome6Regular.calendar_plus).build();
    public static final FontAwesome6IconType calendar_plus_s = on(FontAwesome6Solid.calendar_plus).build();
    public static final FontAwesome6IconType calendar_r = on(FontAwesome6Regular.calendar).build();
    public static final FontAwesome6IconType calendar_s = on(FontAwesome6Solid.calendar).build();
    public static final FontAwesome6IconType calendar_week_s = on(FontAwesome6Solid.calendar_week).build();
    public static final FontAwesome6IconType calendar_xmark_r = on(FontAwesome6Regular.calendar_xmark).build();
    public static final FontAwesome6IconType calendar_xmark_s = on(FontAwesome6Solid.calendar_xmark).build();
    public static final FontAwesome6IconType camera_retro_s = on(FontAwesome6Solid.camera_retro).build();
    public static final FontAwesome6IconType camera_rotate_s = on(FontAwesome6Solid.camera_rotate).build();
    public static final FontAwesome6IconType camera_s = on(FontAwesome6Solid.camera).build();
    public static final FontAwesome6IconType campground_s = on(FontAwesome6Solid.campground).build();
    public static final FontAwesome6IconType candy_cane_s = on(FontAwesome6Solid.candy_cane).build();
    public static final FontAwesome6IconType cannabis_s = on(FontAwesome6Solid.cannabis).build();
    public static final FontAwesome6IconType capsules_s = on(FontAwesome6Solid.capsules).build();
    public static final FontAwesome6IconType car_battery_s = on(FontAwesome6Solid.car_battery).build();
    public static final FontAwesome6IconType car_burst_s = on(FontAwesome6Solid.car_burst).build();
    public static final FontAwesome6IconType car_on_s = on(FontAwesome6Solid.car_on).build();
    public static final FontAwesome6IconType car_rear_s = on(FontAwesome6Solid.car_rear).build();
    public static final FontAwesome6IconType car_s = on(FontAwesome6Solid.car).build();
    public static final FontAwesome6IconType car_side_s = on(FontAwesome6Solid.car_side).build();
    public static final FontAwesome6IconType car_tunnel_s = on(FontAwesome6Solid.car_tunnel).build();
    public static final FontAwesome6IconType caravan_s = on(FontAwesome6Solid.caravan).build();
    public static final FontAwesome6IconType caret_down_s = on(FontAwesome6Solid.caret_down).build();
    public static final FontAwesome6IconType caret_left_s = on(FontAwesome6Solid.caret_left).build();
    public static final FontAwesome6IconType caret_right_s = on(FontAwesome6Solid.caret_right).build();
    public static final FontAwesome6IconType caret_up_s = on(FontAwesome6Solid.caret_up).build();
    public static final FontAwesome6IconType carrot_s = on(FontAwesome6Solid.carrot).build();
    public static final FontAwesome6IconType cart_arrow_down_s = on(FontAwesome6Solid.cart_arrow_down).build();
    public static final FontAwesome6IconType cart_flatbed_s = on(FontAwesome6Solid.cart_flatbed).build();
    public static final FontAwesome6IconType cart_flatbed_suitcase_s = on(FontAwesome6Solid.cart_flatbed_suitcase).build();
    public static final FontAwesome6IconType cart_plus_s = on(FontAwesome6Solid.cart_plus).build();
    public static final FontAwesome6IconType cart_shopping_s = on(FontAwesome6Solid.cart_shopping).build();
    public static final FontAwesome6IconType cash_register_s = on(FontAwesome6Solid.cash_register).build();
    public static final FontAwesome6IconType cat_s = on(FontAwesome6Solid.cat).build();
    public static final FontAwesome6IconType cedi_sign_s = on(FontAwesome6Solid.cedi_sign).build();
    public static final FontAwesome6IconType cent_sign_s = on(FontAwesome6Solid.cent_sign).build();
    public static final FontAwesome6IconType certificate_s = on(FontAwesome6Solid.certificate).build();
    public static final FontAwesome6IconType chair_s = on(FontAwesome6Solid.chair).build();
    public static final FontAwesome6IconType chalkboard_s = on(FontAwesome6Solid.chalkboard).build();
    public static final FontAwesome6IconType chalkboard_user_s = on(FontAwesome6Solid.chalkboard_user).build();
    public static final FontAwesome6IconType champagne_glasses_s = on(FontAwesome6Solid.champagne_glasses).build();
    public static final FontAwesome6IconType charging_station_s = on(FontAwesome6Solid.charging_station).build();
    public static final FontAwesome6IconType chart_area_s = on(FontAwesome6Solid.chart_area).build();
    public static final FontAwesome6IconType chart_bar_r = on(FontAwesome6Regular.chart_bar).build();
    public static final FontAwesome6IconType chart_bar_s = on(FontAwesome6Solid.chart_bar).build();
    public static final FontAwesome6IconType chart_column_s = on(FontAwesome6Solid.chart_column).build();
    public static final FontAwesome6IconType chart_diagram_s = on(FontAwesome6Solid.chart_diagram).build();
    public static final FontAwesome6IconType chart_gantt_s = on(FontAwesome6Solid.chart_gantt).build();
    public static final FontAwesome6IconType chart_line_s = on(FontAwesome6Solid.chart_line).build();
    public static final FontAwesome6IconType chart_pie_s = on(FontAwesome6Solid.chart_pie).build();
    public static final FontAwesome6IconType chart_simple_s = on(FontAwesome6Solid.chart_simple).build();
    public static final FontAwesome6IconType check_double_s = on(FontAwesome6Solid.check_double).build();
    public static final FontAwesome6IconType check_s = on(FontAwesome6Solid.check).build();
    public static final FontAwesome6IconType check_to_slot_s = on(FontAwesome6Solid.check_to_slot).build();
    public static final FontAwesome6IconType cheese_s = on(FontAwesome6Solid.cheese).build();
    public static final FontAwesome6IconType chess_bishop_r = on(FontAwesome6Regular.chess_bishop).build();
    public static final FontAwesome6IconType chess_bishop_s = on(FontAwesome6Solid.chess_bishop).build();
    public static final FontAwesome6IconType chess_board_s = on(FontAwesome6Solid.chess_board).build();
    public static final FontAwesome6IconType chess_king_r = on(FontAwesome6Regular.chess_king).build();
    public static final FontAwesome6IconType chess_king_s = on(FontAwesome6Solid.chess_king).build();
    public static final FontAwesome6IconType chess_knight_r = on(FontAwesome6Regular.chess_knight).build();
    public static final FontAwesome6IconType chess_knight_s = on(FontAwesome6Solid.chess_knight).build();
    public static final FontAwesome6IconType chess_pawn_r = on(FontAwesome6Regular.chess_pawn).build();
    public static final FontAwesome6IconType chess_pawn_s = on(FontAwesome6Solid.chess_pawn).build();
    public static final FontAwesome6IconType chess_queen_r = on(FontAwesome6Regular.chess_queen).build();
    public static final FontAwesome6IconType chess_queen_s = on(FontAwesome6Solid.chess_queen).build();
    public static final FontAwesome6IconType chess_rook_r = on(FontAwesome6Regular.chess_rook).build();
    public static final FontAwesome6IconType chess_rook_s = on(FontAwesome6Solid.chess_rook).build();
    public static final FontAwesome6IconType chess_s = on(FontAwesome6Solid.chess).build();
    public static final FontAwesome6IconType chevron_down_s = on(FontAwesome6Solid.chevron_down).build();
    public static final FontAwesome6IconType chevron_left_s = on(FontAwesome6Solid.chevron_left).build();
    public static final FontAwesome6IconType chevron_right_s = on(FontAwesome6Solid.chevron_right).build();
    public static final FontAwesome6IconType chevron_up_s = on(FontAwesome6Solid.chevron_up).build();
    public static final FontAwesome6IconType child_combatant_s = on(FontAwesome6Solid.child_combatant).build();
    public static final FontAwesome6IconType child_dress_s = on(FontAwesome6Solid.child_dress).build();
    public static final FontAwesome6IconType child_reaching_s = on(FontAwesome6Solid.child_reaching).build();
    public static final FontAwesome6IconType child_s = on(FontAwesome6Solid.child).build();
    public static final FontAwesome6IconType children_s = on(FontAwesome6Solid.children).build();
    public static final FontAwesome6IconType church_s = on(FontAwesome6Solid.church).build();
    public static final FontAwesome6IconType circle_arrow_down_s = on(FontAwesome6Solid.circle_arrow_down).build();
    public static final FontAwesome6IconType circle_arrow_left_s = on(FontAwesome6Solid.circle_arrow_left).build();
    public static final FontAwesome6IconType circle_arrow_right_s = on(FontAwesome6Solid.circle_arrow_right).build();
    public static final FontAwesome6IconType circle_arrow_up_s = on(FontAwesome6Solid.circle_arrow_up).build();
    public static final FontAwesome6IconType circle_check_r = on(FontAwesome6Regular.circle_check).build();
    public static final FontAwesome6IconType circle_check_s = on(FontAwesome6Solid.circle_check).build();
    public static final FontAwesome6IconType circle_chevron_down_s = on(FontAwesome6Solid.circle_chevron_down).build();
    public static final FontAwesome6IconType circle_chevron_left_s = on(FontAwesome6Solid.circle_chevron_left).build();
    public static final FontAwesome6IconType circle_chevron_right_s = on(FontAwesome6Solid.circle_chevron_right).build();
    public static final FontAwesome6IconType circle_chevron_up_s = on(FontAwesome6Solid.circle_chevron_up).build();
    public static final FontAwesome6IconType circle_dollar_to_slot_s = on(FontAwesome6Solid.circle_dollar_to_slot).build();
    public static final FontAwesome6IconType circle_dot_r = on(FontAwesome6Regular.circle_dot).build();
    public static final FontAwesome6IconType circle_dot_s = on(FontAwesome6Solid.circle_dot).build();
    public static final FontAwesome6IconType circle_down_r = on(FontAwesome6Regular.circle_down).build();
    public static final FontAwesome6IconType circle_down_s = on(FontAwesome6Solid.circle_down).build();
    public static final FontAwesome6IconType circle_exclamation_s = on(FontAwesome6Solid.circle_exclamation).build();
    public static final FontAwesome6IconType circle_h_s = on(FontAwesome6Solid.circle_h).build();
    public static final FontAwesome6IconType circle_half_stroke_s = on(FontAwesome6Solid.circle_half_stroke).build();
    public static final FontAwesome6IconType circle_info_s = on(FontAwesome6Solid.circle_info).build();
    public static final FontAwesome6IconType circle_left_r = on(FontAwesome6Regular.circle_left).build();
    public static final FontAwesome6IconType circle_left_s = on(FontAwesome6Solid.circle_left).build();
    public static final FontAwesome6IconType circle_minus_s = on(FontAwesome6Solid.circle_minus).build();
    public static final FontAwesome6IconType circle_nodes_s = on(FontAwesome6Solid.circle_nodes).build();
    public static final FontAwesome6IconType circle_notch_s = on(FontAwesome6Solid.circle_notch).build();
    public static final FontAwesome6IconType circle_pause_r = on(FontAwesome6Regular.circle_pause).build();
    public static final FontAwesome6IconType circle_pause_s = on(FontAwesome6Solid.circle_pause).build();
    public static final FontAwesome6IconType circle_play_r = on(FontAwesome6Regular.circle_play).build();
    public static final FontAwesome6IconType circle_play_s = on(FontAwesome6Solid.circle_play).build();
    public static final FontAwesome6IconType circle_plus_s = on(FontAwesome6Solid.circle_plus).build();
    public static final FontAwesome6IconType circle_question_r = on(FontAwesome6Regular.circle_question).build();
    public static final FontAwesome6IconType circle_question_s = on(FontAwesome6Solid.circle_question).build();
    public static final FontAwesome6IconType circle_r = on(FontAwesome6Regular.circle).build();
    public static final FontAwesome6IconType circle_radiation_s = on(FontAwesome6Solid.circle_radiation).build();
    public static final FontAwesome6IconType circle_right_r = on(FontAwesome6Regular.circle_right).build();
    public static final FontAwesome6IconType circle_right_s = on(FontAwesome6Solid.circle_right).build();
    public static final FontAwesome6IconType circle_s = on(FontAwesome6Solid.circle).build();
    public static final FontAwesome6IconType circle_stop_r = on(FontAwesome6Regular.circle_stop).build();
    public static final FontAwesome6IconType circle_stop_s = on(FontAwesome6Solid.circle_stop).build();
    public static final FontAwesome6IconType circle_up_r = on(FontAwesome6Regular.circle_up).build();
    public static final FontAwesome6IconType circle_up_s = on(FontAwesome6Solid.circle_up).build();
    public static final FontAwesome6IconType circle_user_r = on(FontAwesome6Regular.circle_user).build();
    public static final FontAwesome6IconType circle_user_s = on(FontAwesome6Solid.circle_user).build();
    public static final FontAwesome6IconType circle_xmark_r = on(FontAwesome6Regular.circle_xmark).build();
    public static final FontAwesome6IconType circle_xmark_s = on(FontAwesome6Solid.circle_xmark).build();
    public static final FontAwesome6IconType city_s = on(FontAwesome6Solid.city).build();
    public static final FontAwesome6IconType clapperboard_s = on(FontAwesome6Solid.clapperboard).build();
    public static final FontAwesome6IconType clipboard_check_s = on(FontAwesome6Solid.clipboard_check).build();
    public static final FontAwesome6IconType clipboard_list_s = on(FontAwesome6Solid.clipboard_list).build();
    public static final FontAwesome6IconType clipboard_question_s = on(FontAwesome6Solid.clipboard_question).build();
    public static final FontAwesome6IconType clipboard_r = on(FontAwesome6Regular.clipboard).build();
    public static final FontAwesome6IconType clipboard_s = on(FontAwesome6Solid.clipboard).build();
    public static final FontAwesome6IconType clipboard_user_s = on(FontAwesome6Solid.clipboard_user).build();
    public static final FontAwesome6IconType clock_r = on(FontAwesome6Regular.clock).build();
    public static final FontAwesome6IconType clock_rotate_left_s = on(FontAwesome6Solid.clock_rotate_left).build();
    public static final FontAwesome6IconType clock_s = on(FontAwesome6Solid.clock).build();
    public static final FontAwesome6IconType clone_r = on(FontAwesome6Regular.clone).build();
    public static final FontAwesome6IconType clone_s = on(FontAwesome6Solid.clone).build();
    public static final FontAwesome6IconType closed_captioning_r = on(FontAwesome6Regular.closed_captioning).build();
    public static final FontAwesome6IconType closed_captioning_s = on(FontAwesome6Solid.closed_captioning).build();
    public static final FontAwesome6IconType cloud_arrow_down_s = on(FontAwesome6Solid.cloud_arrow_down).build();
    public static final FontAwesome6IconType cloud_arrow_up_s = on(FontAwesome6Solid.cloud_arrow_up).build();
    public static final FontAwesome6IconType cloud_bolt_s = on(FontAwesome6Solid.cloud_bolt).build();
    public static final FontAwesome6IconType cloud_meatball_s = on(FontAwesome6Solid.cloud_meatball).build();
    public static final FontAwesome6IconType cloud_moon_rain_s = on(FontAwesome6Solid.cloud_moon_rain).build();
    public static final FontAwesome6IconType cloud_moon_s = on(FontAwesome6Solid.cloud_moon).build();
    public static final FontAwesome6IconType cloud_rain_s = on(FontAwesome6Solid.cloud_rain).build();
    public static final FontAwesome6IconType cloud_s = on(FontAwesome6Solid.cloud).build();
    public static final FontAwesome6IconType cloud_showers_heavy_s = on(FontAwesome6Solid.cloud_showers_heavy).build();
    public static final FontAwesome6IconType cloud_showers_water_s = on(FontAwesome6Solid.cloud_showers_water).build();
    public static final FontAwesome6IconType cloud_sun_rain_s = on(FontAwesome6Solid.cloud_sun_rain).build();
    public static final FontAwesome6IconType cloud_sun_s = on(FontAwesome6Solid.cloud_sun).build();
    public static final FontAwesome6IconType clover_s = on(FontAwesome6Solid.clover).build();
    public static final FontAwesome6IconType code_branch_s = on(FontAwesome6Solid.code_branch).build();
    public static final FontAwesome6IconType code_commit_s = on(FontAwesome6Solid.code_commit).build();
    public static final FontAwesome6IconType code_compare_s = on(FontAwesome6Solid.code_compare).build();
    public static final FontAwesome6IconType code_fork_s = on(FontAwesome6Solid.code_fork).build();
    public static final FontAwesome6IconType code_merge_s = on(FontAwesome6Solid.code_merge).build();
    public static final FontAwesome6IconType code_pull_request_s = on(FontAwesome6Solid.code_pull_request).build();
    public static final FontAwesome6IconType code_s = on(FontAwesome6Solid.code).build();
    public static final FontAwesome6IconType coins_s = on(FontAwesome6Solid.coins).build();
    public static final FontAwesome6IconType colon_sign_s = on(FontAwesome6Solid.colon_sign).build();
    public static final FontAwesome6IconType comment_dollar_s = on(FontAwesome6Solid.comment_dollar).build();
    public static final FontAwesome6IconType comment_dots_r = on(FontAwesome6Regular.comment_dots).build();
    public static final FontAwesome6IconType comment_dots_s = on(FontAwesome6Solid.comment_dots).build();
    public static final FontAwesome6IconType comment_medical_s = on(FontAwesome6Solid.comment_medical).build();
    public static final FontAwesome6IconType comment_nodes_s = on(FontAwesome6Solid.comment_nodes).build();
    public static final FontAwesome6IconType comment_r = on(FontAwesome6Regular.comment).build();
    public static final FontAwesome6IconType comment_s = on(FontAwesome6Solid.comment).build();
    public static final FontAwesome6IconType comment_slash_s = on(FontAwesome6Solid.comment_slash).build();
    public static final FontAwesome6IconType comment_sms_s = on(FontAwesome6Solid.comment_sms).build();
    public static final FontAwesome6IconType comments_dollar_s = on(FontAwesome6Solid.comments_dollar).build();
    public static final FontAwesome6IconType comments_r = on(FontAwesome6Regular.comments).build();
    public static final FontAwesome6IconType comments_s = on(FontAwesome6Solid.comments).build();
    public static final FontAwesome6IconType compact_disc_s = on(FontAwesome6Solid.compact_disc).build();
    public static final FontAwesome6IconType compass_drafting_s = on(FontAwesome6Solid.compass_drafting).build();
    public static final FontAwesome6IconType compass_r = on(FontAwesome6Regular.compass).build();
    public static final FontAwesome6IconType compass_s = on(FontAwesome6Solid.compass).build();
    public static final FontAwesome6IconType compress_s = on(FontAwesome6Solid.compress).build();
    public static final FontAwesome6IconType computer_mouse_s = on(FontAwesome6Solid.computer_mouse).build();
    public static final FontAwesome6IconType computer_s = on(FontAwesome6Solid.computer).build();
    public static final FontAwesome6IconType cookie_bite_s = on(FontAwesome6Solid.cookie_bite).build();
    public static final FontAwesome6IconType cookie_s = on(FontAwesome6Solid.cookie).build();
    public static final FontAwesome6IconType copy_r = on(FontAwesome6Regular.copy).build();
    public static final FontAwesome6IconType copy_s = on(FontAwesome6Solid.copy).build();
    public static final FontAwesome6IconType copyright_r = on(FontAwesome6Regular.copyright).build();
    public static final FontAwesome6IconType copyright_s = on(FontAwesome6Solid.copyright).build();
    public static final FontAwesome6IconType couch_s = on(FontAwesome6Solid.couch).build();
    public static final FontAwesome6IconType cow_s = on(FontAwesome6Solid.cow).build();
    public static final FontAwesome6IconType credit_card_r = on(FontAwesome6Regular.credit_card).build();
    public static final FontAwesome6IconType credit_card_s = on(FontAwesome6Solid.credit_card).build();
    public static final FontAwesome6IconType crop_s = on(FontAwesome6Solid.crop).build();
    public static final FontAwesome6IconType crop_simple_s = on(FontAwesome6Solid.crop_simple).build();
    public static final FontAwesome6IconType cross_s = on(FontAwesome6Solid.cross).build();
    public static final FontAwesome6IconType crosshairs_s = on(FontAwesome6Solid.crosshairs).build();
    public static final FontAwesome6IconType crow_s = on(FontAwesome6Solid.crow).build();
    public static final FontAwesome6IconType crown_s = on(FontAwesome6Solid.crown).build();
    public static final FontAwesome6IconType crutch_s = on(FontAwesome6Solid.crutch).build();
    public static final FontAwesome6IconType cruzeiro_sign_s = on(FontAwesome6Solid.cruzeiro_sign).build();
    public static final FontAwesome6IconType cube_s = on(FontAwesome6Solid.cube).build();
    public static final FontAwesome6IconType cubes_s = on(FontAwesome6Solid.cubes).build();
    public static final FontAwesome6IconType cubes_stacked_s = on(FontAwesome6Solid.cubes_stacked).build();
    public static final FontAwesome6IconType d_s = on(FontAwesome6Solid.d).build();
    public static final FontAwesome6IconType database_s = on(FontAwesome6Solid.database).build();
    public static final FontAwesome6IconType delete_left_s = on(FontAwesome6Solid.delete_left).build();
    public static final FontAwesome6IconType democrat_s = on(FontAwesome6Solid.democrat).build();
    public static final FontAwesome6IconType desktop_s = on(FontAwesome6Solid.desktop).build();
    public static final FontAwesome6IconType dharmachakra_s = on(FontAwesome6Solid.dharmachakra).build();
    public static final FontAwesome6IconType diagram_next_s = on(FontAwesome6Solid.diagram_next).build();
    public static final FontAwesome6IconType diagram_predecessor_s = on(FontAwesome6Solid.diagram_predecessor).build();
    public static final FontAwesome6IconType diagram_project_s = on(FontAwesome6Solid.diagram_project).build();
    public static final FontAwesome6IconType diagram_successor_s = on(FontAwesome6Solid.diagram_successor).build();
    public static final FontAwesome6IconType diamond_s = on(FontAwesome6Solid.diamond).build();
    public static final FontAwesome6IconType diamond_turn_right_s = on(FontAwesome6Solid.diamond_turn_right).build();
    public static final FontAwesome6IconType dice_d20_s = on(FontAwesome6Solid.dice_d20).build();
    public static final FontAwesome6IconType dice_d6_s = on(FontAwesome6Solid.dice_d6).build();
    public static final FontAwesome6IconType dice_five_s = on(FontAwesome6Solid.dice_five).build();
    public static final FontAwesome6IconType dice_four_s = on(FontAwesome6Solid.dice_four).build();
    public static final FontAwesome6IconType dice_one_s = on(FontAwesome6Solid.dice_one).build();
    public static final FontAwesome6IconType dice_s = on(FontAwesome6Solid.dice).build();
    public static final FontAwesome6IconType dice_six_s = on(FontAwesome6Solid.dice_six).build();
    public static final FontAwesome6IconType dice_three_s = on(FontAwesome6Solid.dice_three).build();
    public static final FontAwesome6IconType dice_two_s = on(FontAwesome6Solid.dice_two).build();
    public static final FontAwesome6IconType disease_s = on(FontAwesome6Solid.disease).build();
    public static final FontAwesome6IconType display_s = on(FontAwesome6Solid.display).build();
    public static final FontAwesome6IconType divide_s = on(FontAwesome6Solid.divide).build();
    public static final FontAwesome6IconType dna_s = on(FontAwesome6Solid.dna).build();
    public static final FontAwesome6IconType dog_s = on(FontAwesome6Solid.dog).build();
    public static final FontAwesome6IconType dollar_sign_s = on(FontAwesome6Solid.dollar_sign).build();
    public static final FontAwesome6IconType dolly_s = on(FontAwesome6Solid.dolly).build();
    public static final FontAwesome6IconType dong_sign_s = on(FontAwesome6Solid.dong_sign).build();
    public static final FontAwesome6IconType door_closed_s = on(FontAwesome6Solid.door_closed).build();
    public static final FontAwesome6IconType door_open_s = on(FontAwesome6Solid.door_open).build();
    public static final FontAwesome6IconType dove_s = on(FontAwesome6Solid.dove).build();
    public static final FontAwesome6IconType down_left_and_up_right_to_center_s = on(FontAwesome6Solid.down_left_and_up_right_to_center).build();
    public static final FontAwesome6IconType down_long_s = on(FontAwesome6Solid.down_long).build();
    public static final FontAwesome6IconType download_s = on(FontAwesome6Solid.download).build();
    public static final FontAwesome6IconType dragon_s = on(FontAwesome6Solid.dragon).build();
    public static final FontAwesome6IconType draw_polygon_s = on(FontAwesome6Solid.draw_polygon).build();
    public static final FontAwesome6IconType droplet_s = on(FontAwesome6Solid.droplet).build();
    public static final FontAwesome6IconType droplet_slash_s = on(FontAwesome6Solid.droplet_slash).build();
    public static final FontAwesome6IconType drum_s = on(FontAwesome6Solid.drum).build();
    public static final FontAwesome6IconType drum_steelpan_s = on(FontAwesome6Solid.drum_steelpan).build();
    public static final FontAwesome6IconType drumstick_bite_s = on(FontAwesome6Solid.drumstick_bite).build();
    public static final FontAwesome6IconType dumbbell_s = on(FontAwesome6Solid.dumbbell).build();
    public static final FontAwesome6IconType dumpster_fire_s = on(FontAwesome6Solid.dumpster_fire).build();
    public static final FontAwesome6IconType dumpster_s = on(FontAwesome6Solid.dumpster).build();
    public static final FontAwesome6IconType dungeon_s = on(FontAwesome6Solid.dungeon).build();
    public static final FontAwesome6IconType e_s = on(FontAwesome6Solid.e).build();
    public static final FontAwesome6IconType ear_deaf_s = on(FontAwesome6Solid.ear_deaf).build();
    public static final FontAwesome6IconType ear_listen_s = on(FontAwesome6Solid.ear_listen).build();
    public static final FontAwesome6IconType earth_africa_s = on(FontAwesome6Solid.earth_africa).build();
    public static final FontAwesome6IconType earth_americas_s = on(FontAwesome6Solid.earth_americas).build();
    public static final FontAwesome6IconType earth_asia_s = on(FontAwesome6Solid.earth_asia).build();
    public static final FontAwesome6IconType earth_europe_s = on(FontAwesome6Solid.earth_europe).build();
    public static final FontAwesome6IconType earth_oceania_s = on(FontAwesome6Solid.earth_oceania).build();
    public static final FontAwesome6IconType egg_s = on(FontAwesome6Solid.egg).build();
    public static final FontAwesome6IconType eject_s = on(FontAwesome6Solid.eject).build();
    public static final FontAwesome6IconType elevator_s = on(FontAwesome6Solid.elevator).build();
    public static final FontAwesome6IconType ellipsis_s = on(FontAwesome6Solid.ellipsis).build();
    public static final FontAwesome6IconType ellipsis_vertical_s = on(FontAwesome6Solid.ellipsis_vertical).build();
    public static final FontAwesome6IconType envelope_circle_check_s = on(FontAwesome6Solid.envelope_circle_check).build();
    public static final FontAwesome6IconType envelope_open_r = on(FontAwesome6Regular.envelope_open).build();
    public static final FontAwesome6IconType envelope_open_s = on(FontAwesome6Solid.envelope_open).build();
    public static final FontAwesome6IconType envelope_open_text_s = on(FontAwesome6Solid.envelope_open_text).build();
    public static final FontAwesome6IconType envelope_r = on(FontAwesome6Regular.envelope).build();
    public static final FontAwesome6IconType envelope_s = on(FontAwesome6Solid.envelope).build();
    public static final FontAwesome6IconType envelopes_bulk_s = on(FontAwesome6Solid.envelopes_bulk).build();
    public static final FontAwesome6IconType equals_s = on(FontAwesome6Solid.equals).build();
    public static final FontAwesome6IconType eraser_s = on(FontAwesome6Solid.eraser).build();
    public static final FontAwesome6IconType ethernet_s = on(FontAwesome6Solid.ethernet).build();
    public static final FontAwesome6IconType euro_sign_s = on(FontAwesome6Solid.euro_sign).build();
    public static final FontAwesome6IconType exclamation_s = on(FontAwesome6Solid.exclamation).build();
    public static final FontAwesome6IconType expand_s = on(FontAwesome6Solid.expand).build();
    public static final FontAwesome6IconType explosion_s = on(FontAwesome6Solid.explosion).build();
    public static final FontAwesome6IconType eye_dropper_s = on(FontAwesome6Solid.eye_dropper).build();
    public static final FontAwesome6IconType eye_low_vision_s = on(FontAwesome6Solid.eye_low_vision).build();
    public static final FontAwesome6IconType eye_r = on(FontAwesome6Regular.eye).build();
    public static final FontAwesome6IconType eye_s = on(FontAwesome6Solid.eye).build();
    public static final FontAwesome6IconType eye_slash_r = on(FontAwesome6Regular.eye_slash).build();
    public static final FontAwesome6IconType eye_slash_s = on(FontAwesome6Solid.eye_slash).build();
    public static final FontAwesome6IconType f_s = on(FontAwesome6Solid.f).build();
    public static final FontAwesome6IconType face_angry_r = on(FontAwesome6Regular.face_angry).build();
    public static final FontAwesome6IconType face_angry_s = on(FontAwesome6Solid.face_angry).build();
    public static final FontAwesome6IconType face_dizzy_r = on(FontAwesome6Regular.face_dizzy).build();
    public static final FontAwesome6IconType face_dizzy_s = on(FontAwesome6Solid.face_dizzy).build();
    public static final FontAwesome6IconType face_flushed_r = on(FontAwesome6Regular.face_flushed).build();
    public static final FontAwesome6IconType face_flushed_s = on(FontAwesome6Solid.face_flushed).build();
    public static final FontAwesome6IconType face_frown_open_r = on(FontAwesome6Regular.face_frown_open).build();
    public static final FontAwesome6IconType face_frown_open_s = on(FontAwesome6Solid.face_frown_open).build();
    public static final FontAwesome6IconType face_frown_r = on(FontAwesome6Regular.face_frown).build();
    public static final FontAwesome6IconType face_frown_s = on(FontAwesome6Solid.face_frown).build();
    public static final FontAwesome6IconType face_grimace_r = on(FontAwesome6Regular.face_grimace).build();
    public static final FontAwesome6IconType face_grimace_s = on(FontAwesome6Solid.face_grimace).build();
    public static final FontAwesome6IconType face_grin_beam_r = on(FontAwesome6Regular.face_grin_beam).build();
    public static final FontAwesome6IconType face_grin_beam_s = on(FontAwesome6Solid.face_grin_beam).build();
    public static final FontAwesome6IconType face_grin_beam_sweat_r = on(FontAwesome6Regular.face_grin_beam_sweat).build();
    public static final FontAwesome6IconType face_grin_beam_sweat_s = on(FontAwesome6Solid.face_grin_beam_sweat).build();
    public static final FontAwesome6IconType face_grin_hearts_r = on(FontAwesome6Regular.face_grin_hearts).build();
    public static final FontAwesome6IconType face_grin_hearts_s = on(FontAwesome6Solid.face_grin_hearts).build();
    public static final FontAwesome6IconType face_grin_r = on(FontAwesome6Regular.face_grin).build();
    public static final FontAwesome6IconType face_grin_s = on(FontAwesome6Solid.face_grin).build();
    public static final FontAwesome6IconType face_grin_squint_r = on(FontAwesome6Regular.face_grin_squint).build();
    public static final FontAwesome6IconType face_grin_squint_s = on(FontAwesome6Solid.face_grin_squint).build();
    public static final FontAwesome6IconType face_grin_squint_tears_r = on(FontAwesome6Regular.face_grin_squint_tears).build();
    public static final FontAwesome6IconType face_grin_squint_tears_s = on(FontAwesome6Solid.face_grin_squint_tears).build();
    public static final FontAwesome6IconType face_grin_stars_r = on(FontAwesome6Regular.face_grin_stars).build();
    public static final FontAwesome6IconType face_grin_stars_s = on(FontAwesome6Solid.face_grin_stars).build();
    public static final FontAwesome6IconType face_grin_tears_r = on(FontAwesome6Regular.face_grin_tears).build();
    public static final FontAwesome6IconType face_grin_tears_s = on(FontAwesome6Solid.face_grin_tears).build();
    public static final FontAwesome6IconType face_grin_tongue_r = on(FontAwesome6Regular.face_grin_tongue).build();
    public static final FontAwesome6IconType face_grin_tongue_s = on(FontAwesome6Solid.face_grin_tongue).build();
    public static final FontAwesome6IconType face_grin_tongue_squint_r = on(FontAwesome6Regular.face_grin_tongue_squint).build();
    public static final FontAwesome6IconType face_grin_tongue_squint_s = on(FontAwesome6Solid.face_grin_tongue_squint).build();
    public static final FontAwesome6IconType face_grin_tongue_wink_r = on(FontAwesome6Regular.face_grin_tongue_wink).build();
    public static final FontAwesome6IconType face_grin_tongue_wink_s = on(FontAwesome6Solid.face_grin_tongue_wink).build();
    public static final FontAwesome6IconType face_grin_wide_r = on(FontAwesome6Regular.face_grin_wide).build();
    public static final FontAwesome6IconType face_grin_wide_s = on(FontAwesome6Solid.face_grin_wide).build();
    public static final FontAwesome6IconType face_grin_wink_r = on(FontAwesome6Regular.face_grin_wink).build();
    public static final FontAwesome6IconType face_grin_wink_s = on(FontAwesome6Solid.face_grin_wink).build();
    public static final FontAwesome6IconType face_kiss_beam_r = on(FontAwesome6Regular.face_kiss_beam).build();
    public static final FontAwesome6IconType face_kiss_beam_s = on(FontAwesome6Solid.face_kiss_beam).build();
    public static final FontAwesome6IconType face_kiss_r = on(FontAwesome6Regular.face_kiss).build();
    public static final FontAwesome6IconType face_kiss_s = on(FontAwesome6Solid.face_kiss).build();
    public static final FontAwesome6IconType face_kiss_wink_heart_r = on(FontAwesome6Regular.face_kiss_wink_heart).build();
    public static final FontAwesome6IconType face_kiss_wink_heart_s = on(FontAwesome6Solid.face_kiss_wink_heart).build();
    public static final FontAwesome6IconType face_laugh_beam_r = on(FontAwesome6Regular.face_laugh_beam).build();
    public static final FontAwesome6IconType face_laugh_beam_s = on(FontAwesome6Solid.face_laugh_beam).build();
    public static final FontAwesome6IconType face_laugh_r = on(FontAwesome6Regular.face_laugh).build();
    public static final FontAwesome6IconType face_laugh_s = on(FontAwesome6Solid.face_laugh).build();
    public static final FontAwesome6IconType face_laugh_squint_r = on(FontAwesome6Regular.face_laugh_squint).build();
    public static final FontAwesome6IconType face_laugh_squint_s = on(FontAwesome6Solid.face_laugh_squint).build();
    public static final FontAwesome6IconType face_laugh_wink_r = on(FontAwesome6Regular.face_laugh_wink).build();
    public static final FontAwesome6IconType face_laugh_wink_s = on(FontAwesome6Solid.face_laugh_wink).build();
    public static final FontAwesome6IconType face_meh_blank_r = on(FontAwesome6Regular.face_meh_blank).build();
    public static final FontAwesome6IconType face_meh_blank_s = on(FontAwesome6Solid.face_meh_blank).build();
    public static final FontAwesome6IconType face_meh_r = on(FontAwesome6Regular.face_meh).build();
    public static final FontAwesome6IconType face_meh_s = on(FontAwesome6Solid.face_meh).build();
    public static final FontAwesome6IconType face_rolling_eyes_r = on(FontAwesome6Regular.face_rolling_eyes).build();
    public static final FontAwesome6IconType face_rolling_eyes_s = on(FontAwesome6Solid.face_rolling_eyes).build();
    public static final FontAwesome6IconType face_sad_cry_r = on(FontAwesome6Regular.face_sad_cry).build();
    public static final FontAwesome6IconType face_sad_cry_s = on(FontAwesome6Solid.face_sad_cry).build();
    public static final FontAwesome6IconType face_sad_tear_r = on(FontAwesome6Regular.face_sad_tear).build();
    public static final FontAwesome6IconType face_sad_tear_s = on(FontAwesome6Solid.face_sad_tear).build();
    public static final FontAwesome6IconType face_smile_beam_r = on(FontAwesome6Regular.face_smile_beam).build();
    public static final FontAwesome6IconType face_smile_beam_s = on(FontAwesome6Solid.face_smile_beam).build();
    public static final FontAwesome6IconType face_smile_r = on(FontAwesome6Regular.face_smile).build();
    public static final FontAwesome6IconType face_smile_s = on(FontAwesome6Solid.face_smile).build();
    public static final FontAwesome6IconType face_smile_wink_r = on(FontAwesome6Regular.face_smile_wink).build();
    public static final FontAwesome6IconType face_smile_wink_s = on(FontAwesome6Solid.face_smile_wink).build();
    public static final FontAwesome6IconType face_surprise_r = on(FontAwesome6Regular.face_surprise).build();
    public static final FontAwesome6IconType face_surprise_s = on(FontAwesome6Solid.face_surprise).build();
    public static final FontAwesome6IconType face_tired_r = on(FontAwesome6Regular.face_tired).build();
    public static final FontAwesome6IconType face_tired_s = on(FontAwesome6Solid.face_tired).build();
    public static final FontAwesome6IconType fan_s = on(FontAwesome6Solid.fan).build();
    public static final FontAwesome6IconType faucet_drip_s = on(FontAwesome6Solid.faucet_drip).build();
    public static final FontAwesome6IconType faucet_s = on(FontAwesome6Solid.faucet).build();
    public static final FontAwesome6IconType fax_s = on(FontAwesome6Solid.fax).build();
    public static final FontAwesome6IconType feather_pointed_s = on(FontAwesome6Solid.feather_pointed).build();
    public static final FontAwesome6IconType feather_s = on(FontAwesome6Solid.feather).build();
    public static final FontAwesome6IconType ferry_s = on(FontAwesome6Solid.ferry).build();
    public static final FontAwesome6IconType file_arrow_down_s = on(FontAwesome6Solid.file_arrow_down).build();
    public static final FontAwesome6IconType file_arrow_up_s = on(FontAwesome6Solid.file_arrow_up).build();
    public static final FontAwesome6IconType file_audio_r = on(FontAwesome6Regular.file_audio).build();
    public static final FontAwesome6IconType file_audio_s = on(FontAwesome6Solid.file_audio).build();
    public static final FontAwesome6IconType file_circle_check_s = on(FontAwesome6Solid.file_circle_check).build();
    public static final FontAwesome6IconType file_circle_exclamation_s = on(FontAwesome6Solid.file_circle_exclamation).build();
    public static final FontAwesome6IconType file_circle_minus_s = on(FontAwesome6Solid.file_circle_minus).build();
    public static final FontAwesome6IconType file_circle_plus_s = on(FontAwesome6Solid.file_circle_plus).build();
    public static final FontAwesome6IconType file_circle_question_s = on(FontAwesome6Solid.file_circle_question).build();
    public static final FontAwesome6IconType file_circle_xmark_s = on(FontAwesome6Solid.file_circle_xmark).build();
    public static final FontAwesome6IconType file_code_r = on(FontAwesome6Regular.file_code).build();
    public static final FontAwesome6IconType file_code_s = on(FontAwesome6Solid.file_code).build();
    public static final FontAwesome6IconType file_contract_s = on(FontAwesome6Solid.file_contract).build();
    public static final FontAwesome6IconType file_csv_s = on(FontAwesome6Solid.file_csv).build();
    public static final FontAwesome6IconType file_excel_r = on(FontAwesome6Regular.file_excel).build();
    public static final FontAwesome6IconType file_excel_s = on(FontAwesome6Solid.file_excel).build();
    public static final FontAwesome6IconType file_export_s = on(FontAwesome6Solid.file_export).build();
    public static final FontAwesome6IconType file_fragment_s = on(FontAwesome6Solid.file_fragment).build();
    public static final FontAwesome6IconType file_half_dashed_s = on(FontAwesome6Solid.file_half_dashed).build();
    public static final FontAwesome6IconType file_image_r = on(FontAwesome6Regular.file_image).build();
    public static final FontAwesome6IconType file_image_s = on(FontAwesome6Solid.file_image).build();
    public static final FontAwesome6IconType file_import_s = on(FontAwesome6Solid.file_import).build();
    public static final FontAwesome6IconType file_invoice_dollar_s = on(FontAwesome6Solid.file_invoice_dollar).build();
    public static final FontAwesome6IconType file_invoice_s = on(FontAwesome6Solid.file_invoice).build();
    public static final FontAwesome6IconType file_lines_r = on(FontAwesome6Regular.file_lines).build();
    public static final FontAwesome6IconType file_lines_s = on(FontAwesome6Solid.file_lines).build();
    public static final FontAwesome6IconType file_medical_s = on(FontAwesome6Solid.file_medical).build();
    public static final FontAwesome6IconType file_pdf_r = on(FontAwesome6Regular.file_pdf).build();
    public static final FontAwesome6IconType file_pdf_s = on(FontAwesome6Solid.file_pdf).build();
    public static final FontAwesome6IconType file_pen_s = on(FontAwesome6Solid.file_pen).build();
    public static final FontAwesome6IconType file_powerpoint_r = on(FontAwesome6Regular.file_powerpoint).build();
    public static final FontAwesome6IconType file_powerpoint_s = on(FontAwesome6Solid.file_powerpoint).build();
    public static final FontAwesome6IconType file_prescription_s = on(FontAwesome6Solid.file_prescription).build();
    public static final FontAwesome6IconType file_r = on(FontAwesome6Regular.file).build();
    public static final FontAwesome6IconType file_s = on(FontAwesome6Solid.file).build();
    public static final FontAwesome6IconType file_shield_s = on(FontAwesome6Solid.file_shield).build();
    public static final FontAwesome6IconType file_signature_s = on(FontAwesome6Solid.file_signature).build();
    public static final FontAwesome6IconType file_video_r = on(FontAwesome6Regular.file_video).build();
    public static final FontAwesome6IconType file_video_s = on(FontAwesome6Solid.file_video).build();
    public static final FontAwesome6IconType file_waveform_s = on(FontAwesome6Solid.file_waveform).build();
    public static final FontAwesome6IconType file_word_r = on(FontAwesome6Regular.file_word).build();
    public static final FontAwesome6IconType file_word_s = on(FontAwesome6Solid.file_word).build();
    public static final FontAwesome6IconType file_zipper_r = on(FontAwesome6Regular.file_zipper).build();
    public static final FontAwesome6IconType file_zipper_s = on(FontAwesome6Solid.file_zipper).build();
    public static final FontAwesome6IconType fill_drip_s = on(FontAwesome6Solid.fill_drip).build();
    public static final FontAwesome6IconType fill_s = on(FontAwesome6Solid.fill).build();
    public static final FontAwesome6IconType film_s = on(FontAwesome6Solid.film).build();
    public static final FontAwesome6IconType filter_circle_dollar_s = on(FontAwesome6Solid.filter_circle_dollar).build();
    public static final FontAwesome6IconType filter_circle_xmark_s = on(FontAwesome6Solid.filter_circle_xmark).build();
    public static final FontAwesome6IconType filter_s = on(FontAwesome6Solid.filter).build();
    public static final FontAwesome6IconType fingerprint_s = on(FontAwesome6Solid.fingerprint).build();
    public static final FontAwesome6IconType fire_burner_s = on(FontAwesome6Solid.fire_burner).build();
    public static final FontAwesome6IconType fire_extinguisher_s = on(FontAwesome6Solid.fire_extinguisher).build();
    public static final FontAwesome6IconType fire_flame_curved_s = on(FontAwesome6Solid.fire_flame_curved).build();
    public static final FontAwesome6IconType fire_flame_simple_s = on(FontAwesome6Solid.fire_flame_simple).build();
    public static final FontAwesome6IconType fire_s = on(FontAwesome6Solid.fire).build();
    public static final FontAwesome6IconType fish_fins_s = on(FontAwesome6Solid.fish_fins).build();
    public static final FontAwesome6IconType fish_s = on(FontAwesome6Solid.fish).build();
    public static final FontAwesome6IconType flag_checkered_s = on(FontAwesome6Solid.flag_checkered).build();
    public static final FontAwesome6IconType flag_r = on(FontAwesome6Regular.flag).build();
    public static final FontAwesome6IconType flag_s = on(FontAwesome6Solid.flag).build();
    public static final FontAwesome6IconType flag_usa_s = on(FontAwesome6Solid.flag_usa).build();
    public static final FontAwesome6IconType flask_s = on(FontAwesome6Solid.flask).build();
    public static final FontAwesome6IconType flask_vial_s = on(FontAwesome6Solid.flask_vial).build();
    public static final FontAwesome6IconType floppy_disk_r = on(FontAwesome6Regular.floppy_disk).build();
    public static final FontAwesome6IconType floppy_disk_s = on(FontAwesome6Solid.floppy_disk).build();
    public static final FontAwesome6IconType florin_sign_s = on(FontAwesome6Solid.florin_sign).build();
    public static final FontAwesome6IconType folder_closed_r = on(FontAwesome6Regular.folder_closed).build();
    public static final FontAwesome6IconType folder_closed_s = on(FontAwesome6Solid.folder_closed).build();
    public static final FontAwesome6IconType folder_minus_s = on(FontAwesome6Solid.folder_minus).build();
    public static final FontAwesome6IconType folder_open_r = on(FontAwesome6Regular.folder_open).build();
    public static final FontAwesome6IconType folder_open_s = on(FontAwesome6Solid.folder_open).build();
    public static final FontAwesome6IconType folder_plus_s = on(FontAwesome6Solid.folder_plus).build();
    public static final FontAwesome6IconType folder_r = on(FontAwesome6Regular.folder).build();
    public static final FontAwesome6IconType folder_s = on(FontAwesome6Solid.folder).build();
    public static final FontAwesome6IconType folder_tree_s = on(FontAwesome6Solid.folder_tree).build();
    public static final FontAwesome6IconType font_awesome_r = on(FontAwesome6Regular.font_awesome).build();
    public static final FontAwesome6IconType font_awesome_s = on(FontAwesome6Solid.font_awesome).build();
    public static final FontAwesome6IconType font_s = on(FontAwesome6Solid.font).build();
    public static final FontAwesome6IconType football_s = on(FontAwesome6Solid.football).build();
    public static final FontAwesome6IconType forward_fast_s = on(FontAwesome6Solid.forward_fast).build();
    public static final FontAwesome6IconType forward_s = on(FontAwesome6Solid.forward).build();
    public static final FontAwesome6IconType forward_step_s = on(FontAwesome6Solid.forward_step).build();
    public static final FontAwesome6IconType franc_sign_s = on(FontAwesome6Solid.franc_sign).build();
    public static final FontAwesome6IconType frog_s = on(FontAwesome6Solid.frog).build();
    public static final FontAwesome6IconType futbol_r = on(FontAwesome6Regular.futbol).build();
    public static final FontAwesome6IconType futbol_s = on(FontAwesome6Solid.futbol).build();
    public static final FontAwesome6IconType g_s = on(FontAwesome6Solid.g).build();
    public static final FontAwesome6IconType gamepad_s = on(FontAwesome6Solid.gamepad).build();
    public static final FontAwesome6IconType gas_pump_s = on(FontAwesome6Solid.gas_pump).build();
    public static final FontAwesome6IconType gauge_high_s = on(FontAwesome6Solid.gauge_high).build();
    public static final FontAwesome6IconType gauge_s = on(FontAwesome6Solid.gauge).build();
    public static final FontAwesome6IconType gauge_simple_high_s = on(FontAwesome6Solid.gauge_simple_high).build();
    public static final FontAwesome6IconType gauge_simple_s = on(FontAwesome6Solid.gauge_simple).build();
    public static final FontAwesome6IconType gavel_s = on(FontAwesome6Solid.gavel).build();
    public static final FontAwesome6IconType gear_s = on(FontAwesome6Solid.gear).build();
    public static final FontAwesome6IconType gears_s = on(FontAwesome6Solid.gears).build();
    public static final FontAwesome6IconType gem_r = on(FontAwesome6Regular.gem).build();
    public static final FontAwesome6IconType gem_s = on(FontAwesome6Solid.gem).build();
    public static final FontAwesome6IconType genderless_s = on(FontAwesome6Solid.genderless).build();
    public static final FontAwesome6IconType ghost_s = on(FontAwesome6Solid.ghost).build();
    public static final FontAwesome6IconType gift_s = on(FontAwesome6Solid.gift).build();
    public static final FontAwesome6IconType gifts_s = on(FontAwesome6Solid.gifts).build();
    public static final FontAwesome6IconType glass_water_droplet_s = on(FontAwesome6Solid.glass_water_droplet).build();
    public static final FontAwesome6IconType glass_water_s = on(FontAwesome6Solid.glass_water).build();
    public static final FontAwesome6IconType glasses_s = on(FontAwesome6Solid.glasses).build();
    public static final FontAwesome6IconType globe_s = on(FontAwesome6Solid.globe).build();
    public static final FontAwesome6IconType golf_ball_tee_s = on(FontAwesome6Solid.golf_ball_tee).build();
    public static final FontAwesome6IconType gopuram_s = on(FontAwesome6Solid.gopuram).build();
    public static final FontAwesome6IconType graduation_cap_s = on(FontAwesome6Solid.graduation_cap).build();
    public static final FontAwesome6IconType greater_than_equal_s = on(FontAwesome6Solid.greater_than_equal).build();
    public static final FontAwesome6IconType greater_than_s = on(FontAwesome6Solid.greater_than).build();
    public static final FontAwesome6IconType grip_lines_s = on(FontAwesome6Solid.grip_lines).build();
    public static final FontAwesome6IconType grip_lines_vertical_s = on(FontAwesome6Solid.grip_lines_vertical).build();
    public static final FontAwesome6IconType grip_s = on(FontAwesome6Solid.grip).build();
    public static final FontAwesome6IconType grip_vertical_s = on(FontAwesome6Solid.grip_vertical).build();
    public static final FontAwesome6IconType group_arrows_rotate_s = on(FontAwesome6Solid.group_arrows_rotate).build();
    public static final FontAwesome6IconType guarani_sign_s = on(FontAwesome6Solid.guarani_sign).build();
    public static final FontAwesome6IconType guitar_s = on(FontAwesome6Solid.guitar).build();
    public static final FontAwesome6IconType gun_s = on(FontAwesome6Solid.gun).build();
    public static final FontAwesome6IconType h_s = on(FontAwesome6Solid.h).build();
    public static final FontAwesome6IconType hammer_s = on(FontAwesome6Solid.hammer).build();
    public static final FontAwesome6IconType hamsa_s = on(FontAwesome6Solid.hamsa).build();
    public static final FontAwesome6IconType hand_back_fist_r = on(FontAwesome6Regular.hand_back_fist).build();
    public static final FontAwesome6IconType hand_back_fist_s = on(FontAwesome6Solid.hand_back_fist).build();
    public static final FontAwesome6IconType hand_dots_s = on(FontAwesome6Solid.hand_dots).build();
    public static final FontAwesome6IconType hand_fist_s = on(FontAwesome6Solid.hand_fist).build();
    public static final FontAwesome6IconType hand_holding_dollar_s = on(FontAwesome6Solid.hand_holding_dollar).build();
    public static final FontAwesome6IconType hand_holding_droplet_s = on(FontAwesome6Solid.hand_holding_droplet).build();
    public static final FontAwesome6IconType hand_holding_hand_s = on(FontAwesome6Solid.hand_holding_hand).build();
    public static final FontAwesome6IconType hand_holding_heart_s = on(FontAwesome6Solid.hand_holding_heart).build();
    public static final FontAwesome6IconType hand_holding_medical_s = on(FontAwesome6Solid.hand_holding_medical).build();
    public static final FontAwesome6IconType hand_holding_s = on(FontAwesome6Solid.hand_holding).build();
    public static final FontAwesome6IconType hand_lizard_r = on(FontAwesome6Regular.hand_lizard).build();
    public static final FontAwesome6IconType hand_lizard_s = on(FontAwesome6Solid.hand_lizard).build();
    public static final FontAwesome6IconType hand_middle_finger_s = on(FontAwesome6Solid.hand_middle_finger).build();
    public static final FontAwesome6IconType hand_peace_r = on(FontAwesome6Regular.hand_peace).build();
    public static final FontAwesome6IconType hand_peace_s = on(FontAwesome6Solid.hand_peace).build();
    public static final FontAwesome6IconType hand_point_down_r = on(FontAwesome6Regular.hand_point_down).build();
    public static final FontAwesome6IconType hand_point_down_s = on(FontAwesome6Solid.hand_point_down).build();
    public static final FontAwesome6IconType hand_point_left_r = on(FontAwesome6Regular.hand_point_left).build();
    public static final FontAwesome6IconType hand_point_left_s = on(FontAwesome6Solid.hand_point_left).build();
    public static final FontAwesome6IconType hand_point_right_r = on(FontAwesome6Regular.hand_point_right).build();
    public static final FontAwesome6IconType hand_point_right_s = on(FontAwesome6Solid.hand_point_right).build();
    public static final FontAwesome6IconType hand_point_up_r = on(FontAwesome6Regular.hand_point_up).build();
    public static final FontAwesome6IconType hand_point_up_s = on(FontAwesome6Solid.hand_point_up).build();
    public static final FontAwesome6IconType hand_pointer_r = on(FontAwesome6Regular.hand_pointer).build();
    public static final FontAwesome6IconType hand_pointer_s = on(FontAwesome6Solid.hand_pointer).build();
    public static final FontAwesome6IconType hand_r = on(FontAwesome6Regular.hand).build();
    public static final FontAwesome6IconType hand_s = on(FontAwesome6Solid.hand).build();
    public static final FontAwesome6IconType hand_scissors_r = on(FontAwesome6Regular.hand_scissors).build();
    public static final FontAwesome6IconType hand_scissors_s = on(FontAwesome6Solid.hand_scissors).build();
    public static final FontAwesome6IconType hand_sparkles_s = on(FontAwesome6Solid.hand_sparkles).build();
    public static final FontAwesome6IconType hand_spock_r = on(FontAwesome6Regular.hand_spock).build();
    public static final FontAwesome6IconType hand_spock_s = on(FontAwesome6Solid.hand_spock).build();
    public static final FontAwesome6IconType handcuffs_s = on(FontAwesome6Solid.handcuffs).build();
    public static final FontAwesome6IconType hands_asl_interpreting_s = on(FontAwesome6Solid.hands_asl_interpreting).build();
    public static final FontAwesome6IconType hands_bound_s = on(FontAwesome6Solid.hands_bound).build();
    public static final FontAwesome6IconType hands_bubbles_s = on(FontAwesome6Solid.hands_bubbles).build();
    public static final FontAwesome6IconType hands_clapping_s = on(FontAwesome6Solid.hands_clapping).build();
    public static final FontAwesome6IconType hands_holding_child_s = on(FontAwesome6Solid.hands_holding_child).build();
    public static final FontAwesome6IconType hands_holding_circle_s = on(FontAwesome6Solid.hands_holding_circle).build();
    public static final FontAwesome6IconType hands_holding_s = on(FontAwesome6Solid.hands_holding).build();
    public static final FontAwesome6IconType hands_praying_s = on(FontAwesome6Solid.hands_praying).build();
    public static final FontAwesome6IconType hands_s = on(FontAwesome6Solid.hands).build();
    public static final FontAwesome6IconType handshake_angle_s = on(FontAwesome6Solid.handshake_angle).build();
    public static final FontAwesome6IconType handshake_r = on(FontAwesome6Regular.handshake).build();
    public static final FontAwesome6IconType handshake_s = on(FontAwesome6Solid.handshake).build();
    public static final FontAwesome6IconType handshake_simple_s = on(FontAwesome6Solid.handshake_simple).build();
    public static final FontAwesome6IconType handshake_simple_slash_s = on(FontAwesome6Solid.handshake_simple_slash).build();
    public static final FontAwesome6IconType handshake_slash_s = on(FontAwesome6Solid.handshake_slash).build();
    public static final FontAwesome6IconType hanukiah_s = on(FontAwesome6Solid.hanukiah).build();
    public static final FontAwesome6IconType hard_drive_r = on(FontAwesome6Regular.hard_drive).build();
    public static final FontAwesome6IconType hard_drive_s = on(FontAwesome6Solid.hard_drive).build();
    public static final FontAwesome6IconType hashtag_s = on(FontAwesome6Solid.hashtag).build();
    public static final FontAwesome6IconType hat_cowboy_s = on(FontAwesome6Solid.hat_cowboy).build();
    public static final FontAwesome6IconType hat_cowboy_side_s = on(FontAwesome6Solid.hat_cowboy_side).build();
    public static final FontAwesome6IconType hat_wizard_s = on(FontAwesome6Solid.hat_wizard).build();
    public static final FontAwesome6IconType head_side_cough_s = on(FontAwesome6Solid.head_side_cough).build();
    public static final FontAwesome6IconType head_side_cough_slash_s = on(FontAwesome6Solid.head_side_cough_slash).build();
    public static final FontAwesome6IconType head_side_mask_s = on(FontAwesome6Solid.head_side_mask).build();
    public static final FontAwesome6IconType head_side_virus_s = on(FontAwesome6Solid.head_side_virus).build();
    public static final FontAwesome6IconType heading_s = on(FontAwesome6Solid.heading).build();
    public static final FontAwesome6IconType headphones_s = on(FontAwesome6Solid.headphones).build();
    public static final FontAwesome6IconType headphones_simple_s = on(FontAwesome6Solid.headphones_simple).build();
    public static final FontAwesome6IconType headset_s = on(FontAwesome6Solid.headset).build();
    public static final FontAwesome6IconType heart_circle_bolt_s = on(FontAwesome6Solid.heart_circle_bolt).build();
    public static final FontAwesome6IconType heart_circle_check_s = on(FontAwesome6Solid.heart_circle_check).build();
    public static final FontAwesome6IconType heart_circle_exclamation_s = on(FontAwesome6Solid.heart_circle_exclamation).build();
    public static final FontAwesome6IconType heart_circle_minus_s = on(FontAwesome6Solid.heart_circle_minus).build();
    public static final FontAwesome6IconType heart_circle_plus_s = on(FontAwesome6Solid.heart_circle_plus).build();
    public static final FontAwesome6IconType heart_circle_xmark_s = on(FontAwesome6Solid.heart_circle_xmark).build();
    public static final FontAwesome6IconType heart_crack_s = on(FontAwesome6Solid.heart_crack).build();
    public static final FontAwesome6IconType heart_pulse_s = on(FontAwesome6Solid.heart_pulse).build();
    public static final FontAwesome6IconType heart_r = on(FontAwesome6Regular.heart).build();
    public static final FontAwesome6IconType heart_s = on(FontAwesome6Solid.heart).build();
    public static final FontAwesome6IconType helicopter_s = on(FontAwesome6Solid.helicopter).build();
    public static final FontAwesome6IconType helicopter_symbol_s = on(FontAwesome6Solid.helicopter_symbol).build();
    public static final FontAwesome6IconType helmet_safety_s = on(FontAwesome6Solid.helmet_safety).build();
    public static final FontAwesome6IconType helmet_un_s = on(FontAwesome6Solid.helmet_un).build();
    public static final FontAwesome6IconType hexagon_nodes_bolt_s = on(FontAwesome6Solid.hexagon_nodes_bolt).build();
    public static final FontAwesome6IconType hexagon_nodes_s = on(FontAwesome6Solid.hexagon_nodes).build();
    public static final FontAwesome6IconType highlighter_s = on(FontAwesome6Solid.highlighter).build();
    public static final FontAwesome6IconType hill_avalanche_s = on(FontAwesome6Solid.hill_avalanche).build();
    public static final FontAwesome6IconType hill_rockslide_s = on(FontAwesome6Solid.hill_rockslide).build();
    public static final FontAwesome6IconType hippo_s = on(FontAwesome6Solid.hippo).build();
    public static final FontAwesome6IconType hockey_puck_s = on(FontAwesome6Solid.hockey_puck).build();
    public static final FontAwesome6IconType holly_berry_s = on(FontAwesome6Solid.holly_berry).build();
    public static final FontAwesome6IconType horse_head_s = on(FontAwesome6Solid.horse_head).build();
    public static final FontAwesome6IconType horse_s = on(FontAwesome6Solid.horse).build();
    public static final FontAwesome6IconType hospital_r = on(FontAwesome6Regular.hospital).build();
    public static final FontAwesome6IconType hospital_s = on(FontAwesome6Solid.hospital).build();
    public static final FontAwesome6IconType hospital_user_s = on(FontAwesome6Solid.hospital_user).build();
    public static final FontAwesome6IconType hot_tub_person_s = on(FontAwesome6Solid.hot_tub_person).build();
    public static final FontAwesome6IconType hotdog_s = on(FontAwesome6Solid.hotdog).build();
    public static final FontAwesome6IconType hotel_s = on(FontAwesome6Solid.hotel).build();
    public static final FontAwesome6IconType hourglass_end_s = on(FontAwesome6Solid.hourglass_end).build();
    public static final FontAwesome6IconType hourglass_half_r = on(FontAwesome6Regular.hourglass_half).build();
    public static final FontAwesome6IconType hourglass_half_s = on(FontAwesome6Solid.hourglass_half).build();
    public static final FontAwesome6IconType hourglass_r = on(FontAwesome6Regular.hourglass).build();
    public static final FontAwesome6IconType hourglass_s = on(FontAwesome6Solid.hourglass).build();
    public static final FontAwesome6IconType hourglass_start_s = on(FontAwesome6Solid.hourglass_start).build();
    public static final FontAwesome6IconType house_chimney_crack_s = on(FontAwesome6Solid.house_chimney_crack).build();
    public static final FontAwesome6IconType house_chimney_medical_s = on(FontAwesome6Solid.house_chimney_medical).build();
    public static final FontAwesome6IconType house_chimney_s = on(FontAwesome6Solid.house_chimney).build();
    public static final FontAwesome6IconType house_chimney_user_s = on(FontAwesome6Solid.house_chimney_user).build();
    public static final FontAwesome6IconType house_chimney_window_s = on(FontAwesome6Solid.house_chimney_window).build();
    public static final FontAwesome6IconType house_circle_check_s = on(FontAwesome6Solid.house_circle_check).build();
    public static final FontAwesome6IconType house_circle_exclamation_s = on(FontAwesome6Solid.house_circle_exclamation).build();
    public static final FontAwesome6IconType house_circle_xmark_s = on(FontAwesome6Solid.house_circle_xmark).build();
    public static final FontAwesome6IconType house_crack_s = on(FontAwesome6Solid.house_crack).build();
    public static final FontAwesome6IconType house_fire_s = on(FontAwesome6Solid.house_fire).build();
    public static final FontAwesome6IconType house_flag_s = on(FontAwesome6Solid.house_flag).build();
    public static final FontAwesome6IconType house_flood_water_circle_arrow_right_s = on(FontAwesome6Solid.house_flood_water_circle_arrow_right).build();
    public static final FontAwesome6IconType house_flood_water_s = on(FontAwesome6Solid.house_flood_water).build();
    public static final FontAwesome6IconType house_laptop_s = on(FontAwesome6Solid.house_laptop).build();
    public static final FontAwesome6IconType house_lock_s = on(FontAwesome6Solid.house_lock).build();
    public static final FontAwesome6IconType house_medical_circle_check_s = on(FontAwesome6Solid.house_medical_circle_check).build();
    public static final FontAwesome6IconType house_medical_circle_exclamation_s = on(FontAwesome6Solid.house_medical_circle_exclamation).build();
    public static final FontAwesome6IconType house_medical_circle_xmark_s = on(FontAwesome6Solid.house_medical_circle_xmark).build();
    public static final FontAwesome6IconType house_medical_flag_s = on(FontAwesome6Solid.house_medical_flag).build();
    public static final FontAwesome6IconType house_medical_s = on(FontAwesome6Solid.house_medical).build();
    public static final FontAwesome6IconType house_s = on(FontAwesome6Solid.house).build();
    public static final FontAwesome6IconType house_signal_s = on(FontAwesome6Solid.house_signal).build();
    public static final FontAwesome6IconType house_tsunami_s = on(FontAwesome6Solid.house_tsunami).build();
    public static final FontAwesome6IconType house_user_s = on(FontAwesome6Solid.house_user).build();
    public static final FontAwesome6IconType hryvnia_sign_s = on(FontAwesome6Solid.hryvnia_sign).build();
    public static final FontAwesome6IconType hurricane_s = on(FontAwesome6Solid.hurricane).build();
    public static final FontAwesome6IconType i_cursor_s = on(FontAwesome6Solid.i_cursor).build();
    public static final FontAwesome6IconType i_s = on(FontAwesome6Solid.i).build();
    public static final FontAwesome6IconType ice_cream_s = on(FontAwesome6Solid.ice_cream).build();
    public static final FontAwesome6IconType icicles_s = on(FontAwesome6Solid.icicles).build();
    public static final FontAwesome6IconType icons_s = on(FontAwesome6Solid.icons).build();
    public static final FontAwesome6IconType id_badge_r = on(FontAwesome6Regular.id_badge).build();
    public static final FontAwesome6IconType id_badge_s = on(FontAwesome6Solid.id_badge).build();
    public static final FontAwesome6IconType id_card_clip_s = on(FontAwesome6Solid.id_card_clip).build();
    public static final FontAwesome6IconType id_card_r = on(FontAwesome6Regular.id_card).build();
    public static final FontAwesome6IconType id_card_s = on(FontAwesome6Solid.id_card).build();
    public static final FontAwesome6IconType igloo_s = on(FontAwesome6Solid.igloo).build();
    public static final FontAwesome6IconType image_portrait_s = on(FontAwesome6Solid.image_portrait).build();
    public static final FontAwesome6IconType image_r = on(FontAwesome6Regular.image).build();
    public static final FontAwesome6IconType image_s = on(FontAwesome6Solid.image).build();
    public static final FontAwesome6IconType images_r = on(FontAwesome6Regular.images).build();
    public static final FontAwesome6IconType images_s = on(FontAwesome6Solid.images).build();
    public static final FontAwesome6IconType inbox_s = on(FontAwesome6Solid.inbox).build();
    public static final FontAwesome6IconType indent_s = on(FontAwesome6Solid.indent).build();
    public static final FontAwesome6IconType indian_rupee_sign_s = on(FontAwesome6Solid.indian_rupee_sign).build();
    public static final FontAwesome6IconType industry_s = on(FontAwesome6Solid.industry).build();
    public static final FontAwesome6IconType infinity_s = on(FontAwesome6Solid.infinity).build();
    public static final FontAwesome6IconType info_s = on(FontAwesome6Solid.info).build();
    public static final FontAwesome6IconType italic_s = on(FontAwesome6Solid.italic).build();
    public static final FontAwesome6IconType j_s = on(FontAwesome6Solid.j).build();
    public static final FontAwesome6IconType jar_s = on(FontAwesome6Solid.jar).build();
    public static final FontAwesome6IconType jar_wheat_s = on(FontAwesome6Solid.jar_wheat).build();
    public static final FontAwesome6IconType jedi_s = on(FontAwesome6Solid.jedi).build();
    public static final FontAwesome6IconType jet_fighter_s = on(FontAwesome6Solid.jet_fighter).build();
    public static final FontAwesome6IconType jet_fighter_up_s = on(FontAwesome6Solid.jet_fighter_up).build();
    public static final FontAwesome6IconType joint_s = on(FontAwesome6Solid.joint).build();
    public static final FontAwesome6IconType jug_detergent_s = on(FontAwesome6Solid.jug_detergent).build();
    public static final FontAwesome6IconType k_s = on(FontAwesome6Solid.k).build();
    public static final FontAwesome6IconType kaaba_s = on(FontAwesome6Solid.kaaba).build();
    public static final FontAwesome6IconType key_s = on(FontAwesome6Solid.key).build();
    public static final FontAwesome6IconType keyboard_r = on(FontAwesome6Regular.keyboard).build();
    public static final FontAwesome6IconType keyboard_s = on(FontAwesome6Solid.keyboard).build();
    public static final FontAwesome6IconType khanda_s = on(FontAwesome6Solid.khanda).build();
    public static final FontAwesome6IconType kip_sign_s = on(FontAwesome6Solid.kip_sign).build();
    public static final FontAwesome6IconType kit_medical_s = on(FontAwesome6Solid.kit_medical).build();
    public static final FontAwesome6IconType kitchen_set_s = on(FontAwesome6Solid.kitchen_set).build();
    public static final FontAwesome6IconType kiwi_bird_s = on(FontAwesome6Solid.kiwi_bird).build();
    public static final FontAwesome6IconType l_s = on(FontAwesome6Solid.l).build();
    public static final FontAwesome6IconType land_mine_on_s = on(FontAwesome6Solid.land_mine_on).build();
    public static final FontAwesome6IconType landmark_dome_s = on(FontAwesome6Solid.landmark_dome).build();
    public static final FontAwesome6IconType landmark_flag_s = on(FontAwesome6Solid.landmark_flag).build();
    public static final FontAwesome6IconType landmark_s = on(FontAwesome6Solid.landmark).build();
    public static final FontAwesome6IconType language_s = on(FontAwesome6Solid.language).build();
    public static final FontAwesome6IconType laptop_code_s = on(FontAwesome6Solid.laptop_code).build();
    public static final FontAwesome6IconType laptop_file_s = on(FontAwesome6Solid.laptop_file).build();
    public static final FontAwesome6IconType laptop_medical_s = on(FontAwesome6Solid.laptop_medical).build();
    public static final FontAwesome6IconType laptop_s = on(FontAwesome6Solid.laptop).build();
    public static final FontAwesome6IconType lari_sign_s = on(FontAwesome6Solid.lari_sign).build();
    public static final FontAwesome6IconType layer_group_s = on(FontAwesome6Solid.layer_group).build();
    public static final FontAwesome6IconType leaf_s = on(FontAwesome6Solid.leaf).build();
    public static final FontAwesome6IconType left_long_s = on(FontAwesome6Solid.left_long).build();
    public static final FontAwesome6IconType left_right_s = on(FontAwesome6Solid.left_right).build();
    public static final FontAwesome6IconType lemon_r = on(FontAwesome6Regular.lemon).build();
    public static final FontAwesome6IconType lemon_s = on(FontAwesome6Solid.lemon).build();
    public static final FontAwesome6IconType less_than_equal_s = on(FontAwesome6Solid.less_than_equal).build();
    public static final FontAwesome6IconType less_than_s = on(FontAwesome6Solid.less_than).build();
    public static final FontAwesome6IconType life_ring_r = on(FontAwesome6Regular.life_ring).build();
    public static final FontAwesome6IconType life_ring_s = on(FontAwesome6Solid.life_ring).build();
    public static final FontAwesome6IconType lightbulb_r = on(FontAwesome6Regular.lightbulb).build();
    public static final FontAwesome6IconType lightbulb_s = on(FontAwesome6Solid.lightbulb).build();
    public static final FontAwesome6IconType lines_leaning_s = on(FontAwesome6Solid.lines_leaning).build();
    public static final FontAwesome6IconType link_s = on(FontAwesome6Solid.link).build();
    public static final FontAwesome6IconType link_slash_s = on(FontAwesome6Solid.link_slash).build();
    public static final FontAwesome6IconType lira_sign_s = on(FontAwesome6Solid.lira_sign).build();
    public static final FontAwesome6IconType list_check_s = on(FontAwesome6Solid.list_check).build();
    public static final FontAwesome6IconType list_ol_s = on(FontAwesome6Solid.list_ol).build();
    public static final FontAwesome6IconType list_s = on(FontAwesome6Solid.list).build();
    public static final FontAwesome6IconType list_ul_s = on(FontAwesome6Solid.list_ul).build();
    public static final FontAwesome6IconType litecoin_sign_s = on(FontAwesome6Solid.litecoin_sign).build();
    public static final FontAwesome6IconType location_arrow_s = on(FontAwesome6Solid.location_arrow).build();
    public static final FontAwesome6IconType location_crosshairs_s = on(FontAwesome6Solid.location_crosshairs).build();
    public static final FontAwesome6IconType location_dot_s = on(FontAwesome6Solid.location_dot).build();
    public static final FontAwesome6IconType location_pin_lock_s = on(FontAwesome6Solid.location_pin_lock).build();
    public static final FontAwesome6IconType location_pin_s = on(FontAwesome6Solid.location_pin).build();
    public static final FontAwesome6IconType lock_open_s = on(FontAwesome6Solid.lock_open).build();
    public static final FontAwesome6IconType lock_s = on(FontAwesome6Solid.lock).build();
    public static final FontAwesome6IconType locust_s = on(FontAwesome6Solid.locust).build();
    public static final FontAwesome6IconType lungs_s = on(FontAwesome6Solid.lungs).build();
    public static final FontAwesome6IconType lungs_virus_s = on(FontAwesome6Solid.lungs_virus).build();
    public static final FontAwesome6IconType m_s = on(FontAwesome6Solid.m).build();
    public static final FontAwesome6IconType magnet_s = on(FontAwesome6Solid.magnet).build();
    public static final FontAwesome6IconType magnifying_glass_arrow_right_s = on(FontAwesome6Solid.magnifying_glass_arrow_right).build();
    public static final FontAwesome6IconType magnifying_glass_chart_s = on(FontAwesome6Solid.magnifying_glass_chart).build();
    public static final FontAwesome6IconType magnifying_glass_dollar_s = on(FontAwesome6Solid.magnifying_glass_dollar).build();
    public static final FontAwesome6IconType magnifying_glass_location_s = on(FontAwesome6Solid.magnifying_glass_location).build();
    public static final FontAwesome6IconType magnifying_glass_minus_s = on(FontAwesome6Solid.magnifying_glass_minus).build();
    public static final FontAwesome6IconType magnifying_glass_plus_s = on(FontAwesome6Solid.magnifying_glass_plus).build();
    public static final FontAwesome6IconType magnifying_glass_s = on(FontAwesome6Solid.magnifying_glass).build();
    public static final FontAwesome6IconType manat_sign_s = on(FontAwesome6Solid.manat_sign).build();
    public static final FontAwesome6IconType map_location_dot_s = on(FontAwesome6Solid.map_location_dot).build();
    public static final FontAwesome6IconType map_location_s = on(FontAwesome6Solid.map_location).build();
    public static final FontAwesome6IconType map_pin_s = on(FontAwesome6Solid.map_pin).build();
    public static final FontAwesome6IconType map_r = on(FontAwesome6Regular.map).build();
    public static final FontAwesome6IconType map_s = on(FontAwesome6Solid.map).build();
    public static final FontAwesome6IconType marker_s = on(FontAwesome6Solid.marker).build();
    public static final FontAwesome6IconType mars_and_venus_burst_s = on(FontAwesome6Solid.mars_and_venus_burst).build();
    public static final FontAwesome6IconType mars_and_venus_s = on(FontAwesome6Solid.mars_and_venus).build();
    public static final FontAwesome6IconType mars_double_s = on(FontAwesome6Solid.mars_double).build();
    public static final FontAwesome6IconType mars_s = on(FontAwesome6Solid.mars).build();
    public static final FontAwesome6IconType mars_stroke_right_s = on(FontAwesome6Solid.mars_stroke_right).build();
    public static final FontAwesome6IconType mars_stroke_s = on(FontAwesome6Solid.mars_stroke).build();
    public static final FontAwesome6IconType mars_stroke_up_s = on(FontAwesome6Solid.mars_stroke_up).build();
    public static final FontAwesome6IconType martini_glass_citrus_s = on(FontAwesome6Solid.martini_glass_citrus).build();
    public static final FontAwesome6IconType martini_glass_empty_s = on(FontAwesome6Solid.martini_glass_empty).build();
    public static final FontAwesome6IconType martini_glass_s = on(FontAwesome6Solid.martini_glass).build();
    public static final FontAwesome6IconType mask_face_s = on(FontAwesome6Solid.mask_face).build();
    public static final FontAwesome6IconType mask_s = on(FontAwesome6Solid.mask).build();
    public static final FontAwesome6IconType mask_ventilator_s = on(FontAwesome6Solid.mask_ventilator).build();
    public static final FontAwesome6IconType masks_theater_s = on(FontAwesome6Solid.masks_theater).build();
    public static final FontAwesome6IconType mattress_pillow_s = on(FontAwesome6Solid.mattress_pillow).build();
    public static final FontAwesome6IconType maximize_s = on(FontAwesome6Solid.maximize).build();
    public static final FontAwesome6IconType medal_s = on(FontAwesome6Solid.medal).build();
    public static final FontAwesome6IconType memory_s = on(FontAwesome6Solid.memory).build();
    public static final FontAwesome6IconType menorah_s = on(FontAwesome6Solid.menorah).build();
    public static final FontAwesome6IconType mercury_s = on(FontAwesome6Solid.mercury).build();
    public static final FontAwesome6IconType message_r = on(FontAwesome6Regular.message).build();
    public static final FontAwesome6IconType message_s = on(FontAwesome6Solid.message).build();
    public static final FontAwesome6IconType meteor_s = on(FontAwesome6Solid.meteor).build();
    public static final FontAwesome6IconType microchip_s = on(FontAwesome6Solid.microchip).build();
    public static final FontAwesome6IconType microphone_lines_s = on(FontAwesome6Solid.microphone_lines).build();
    public static final FontAwesome6IconType microphone_lines_slash_s = on(FontAwesome6Solid.microphone_lines_slash).build();
    public static final FontAwesome6IconType microphone_s = on(FontAwesome6Solid.microphone).build();
    public static final FontAwesome6IconType microphone_slash_s = on(FontAwesome6Solid.microphone_slash).build();
    public static final FontAwesome6IconType microscope_s = on(FontAwesome6Solid.microscope).build();
    public static final FontAwesome6IconType mill_sign_s = on(FontAwesome6Solid.mill_sign).build();
    public static final FontAwesome6IconType minimize_s = on(FontAwesome6Solid.minimize).build();
    public static final FontAwesome6IconType minus_s = on(FontAwesome6Solid.minus).build();
    public static final FontAwesome6IconType mitten_s = on(FontAwesome6Solid.mitten).build();
    public static final FontAwesome6IconType mobile_button_s = on(FontAwesome6Solid.mobile_button).build();
    public static final FontAwesome6IconType mobile_retro_s = on(FontAwesome6Solid.mobile_retro).build();
    public static final FontAwesome6IconType mobile_s = on(FontAwesome6Solid.mobile).build();
    public static final FontAwesome6IconType mobile_screen_button_s = on(FontAwesome6Solid.mobile_screen_button).build();
    public static final FontAwesome6IconType mobile_screen_s = on(FontAwesome6Solid.mobile_screen).build();
    public static final FontAwesome6IconType money_bill_1_r = on(FontAwesome6Regular.money_bill_1).build();
    public static final FontAwesome6IconType money_bill_1_s = on(FontAwesome6Solid.money_bill_1).build();
    public static final FontAwesome6IconType money_bill_1_wave_s = on(FontAwesome6Solid.money_bill_1_wave).build();
    public static final FontAwesome6IconType money_bill_s = on(FontAwesome6Solid.money_bill).build();
    public static final FontAwesome6IconType money_bill_transfer_s = on(FontAwesome6Solid.money_bill_transfer).build();
    public static final FontAwesome6IconType money_bill_trend_up_s = on(FontAwesome6Solid.money_bill_trend_up).build();
    public static final FontAwesome6IconType money_bill_wave_s = on(FontAwesome6Solid.money_bill_wave).build();
    public static final FontAwesome6IconType money_bill_wheat_s = on(FontAwesome6Solid.money_bill_wheat).build();
    public static final FontAwesome6IconType money_bills_s = on(FontAwesome6Solid.money_bills).build();
    public static final FontAwesome6IconType money_check_dollar_s = on(FontAwesome6Solid.money_check_dollar).build();
    public static final FontAwesome6IconType money_check_s = on(FontAwesome6Solid.money_check).build();
    public static final FontAwesome6IconType monument_s = on(FontAwesome6Solid.monument).build();
    public static final FontAwesome6IconType moon_r = on(FontAwesome6Regular.moon).build();
    public static final FontAwesome6IconType moon_s = on(FontAwesome6Solid.moon).build();
    public static final FontAwesome6IconType mortar_pestle_s = on(FontAwesome6Solid.mortar_pestle).build();
    public static final FontAwesome6IconType mosque_s = on(FontAwesome6Solid.mosque).build();
    public static final FontAwesome6IconType mosquito_net_s = on(FontAwesome6Solid.mosquito_net).build();
    public static final FontAwesome6IconType mosquito_s = on(FontAwesome6Solid.mosquito).build();
    public static final FontAwesome6IconType motorcycle_s = on(FontAwesome6Solid.motorcycle).build();
    public static final FontAwesome6IconType mound_s = on(FontAwesome6Solid.mound).build();
    public static final FontAwesome6IconType mountain_city_s = on(FontAwesome6Solid.mountain_city).build();
    public static final FontAwesome6IconType mountain_s = on(FontAwesome6Solid.mountain).build();
    public static final FontAwesome6IconType mountain_sun_s = on(FontAwesome6Solid.mountain_sun).build();
    public static final FontAwesome6IconType mug_hot_s = on(FontAwesome6Solid.mug_hot).build();
    public static final FontAwesome6IconType mug_saucer_s = on(FontAwesome6Solid.mug_saucer).build();
    public static final FontAwesome6IconType music_s = on(FontAwesome6Solid.music).build();
    public static final FontAwesome6IconType n_s = on(FontAwesome6Solid.n).build();
    public static final FontAwesome6IconType naira_sign_s = on(FontAwesome6Solid.naira_sign).build();
    public static final FontAwesome6IconType network_wired_s = on(FontAwesome6Solid.network_wired).build();
    public static final FontAwesome6IconType neuter_s = on(FontAwesome6Solid.neuter).build();
    public static final FontAwesome6IconType newspaper_r = on(FontAwesome6Regular.newspaper).build();
    public static final FontAwesome6IconType newspaper_s = on(FontAwesome6Solid.newspaper).build();
    public static final FontAwesome6IconType not_equal_s = on(FontAwesome6Solid.not_equal).build();
    public static final FontAwesome6IconType notdef_s = on(FontAwesome6Solid.notdef).build();
    public static final FontAwesome6IconType note_sticky_r = on(FontAwesome6Regular.note_sticky).build();
    public static final FontAwesome6IconType note_sticky_s = on(FontAwesome6Solid.note_sticky).build();
    public static final FontAwesome6IconType notes_medical_s = on(FontAwesome6Solid.notes_medical).build();
    public static final FontAwesome6IconType o_s = on(FontAwesome6Solid.o).build();
    public static final FontAwesome6IconType object_group_r = on(FontAwesome6Regular.object_group).build();
    public static final FontAwesome6IconType object_group_s = on(FontAwesome6Solid.object_group).build();
    public static final FontAwesome6IconType object_ungroup_r = on(FontAwesome6Regular.object_ungroup).build();
    public static final FontAwesome6IconType object_ungroup_s = on(FontAwesome6Solid.object_ungroup).build();
    public static final FontAwesome6IconType oil_can_s = on(FontAwesome6Solid.oil_can).build();
    public static final FontAwesome6IconType oil_well_s = on(FontAwesome6Solid.oil_well).build();
    public static final FontAwesome6IconType om_s = on(FontAwesome6Solid.om).build();
    public static final FontAwesome6IconType otter_s = on(FontAwesome6Solid.otter).build();
    public static final FontAwesome6IconType outdent_s = on(FontAwesome6Solid.outdent).build();
    public static final FontAwesome6IconType p_s = on(FontAwesome6Solid.p).build();
    public static final FontAwesome6IconType pager_s = on(FontAwesome6Solid.pager).build();
    public static final FontAwesome6IconType paint_roller_s = on(FontAwesome6Solid.paint_roller).build();
    public static final FontAwesome6IconType paintbrush_s = on(FontAwesome6Solid.paintbrush).build();
    public static final FontAwesome6IconType palette_s = on(FontAwesome6Solid.palette).build();
    public static final FontAwesome6IconType pallet_s = on(FontAwesome6Solid.pallet).build();
    public static final FontAwesome6IconType panorama_s = on(FontAwesome6Solid.panorama).build();
    public static final FontAwesome6IconType paper_plane_r = on(FontAwesome6Regular.paper_plane).build();
    public static final FontAwesome6IconType paper_plane_s = on(FontAwesome6Solid.paper_plane).build();
    public static final FontAwesome6IconType paperclip_s = on(FontAwesome6Solid.paperclip).build();
    public static final FontAwesome6IconType parachute_box_s = on(FontAwesome6Solid.parachute_box).build();
    public static final FontAwesome6IconType paragraph_s = on(FontAwesome6Solid.paragraph).build();
    public static final FontAwesome6IconType passport_s = on(FontAwesome6Solid.passport).build();
    public static final FontAwesome6IconType paste_r = on(FontAwesome6Regular.paste).build();
    public static final FontAwesome6IconType paste_s = on(FontAwesome6Solid.paste).build();
    public static final FontAwesome6IconType pause_s = on(FontAwesome6Solid.pause).build();
    public static final FontAwesome6IconType paw_s = on(FontAwesome6Solid.paw).build();
    public static final FontAwesome6IconType peace_s = on(FontAwesome6Solid.peace).build();
    public static final FontAwesome6IconType pen_clip_s = on(FontAwesome6Solid.pen_clip).build();
    public static final FontAwesome6IconType pen_fancy_s = on(FontAwesome6Solid.pen_fancy).build();
    public static final FontAwesome6IconType pen_nib_s = on(FontAwesome6Solid.pen_nib).build();
    public static final FontAwesome6IconType pen_ruler_s = on(FontAwesome6Solid.pen_ruler).build();
    public static final FontAwesome6IconType pen_s = on(FontAwesome6Solid.pen).build();
    public static final FontAwesome6IconType pen_to_square_r = on(FontAwesome6Regular.pen_to_square).build();
    public static final FontAwesome6IconType pen_to_square_s = on(FontAwesome6Solid.pen_to_square).build();
    public static final FontAwesome6IconType pencil_s = on(FontAwesome6Solid.pencil).build();
    public static final FontAwesome6IconType people_arrows_s = on(FontAwesome6Solid.people_arrows).build();
    public static final FontAwesome6IconType people_carry_box_s = on(FontAwesome6Solid.people_carry_box).build();
    public static final FontAwesome6IconType people_group_s = on(FontAwesome6Solid.people_group).build();
    public static final FontAwesome6IconType people_line_s = on(FontAwesome6Solid.people_line).build();
    public static final FontAwesome6IconType people_pulling_s = on(FontAwesome6Solid.people_pulling).build();
    public static final FontAwesome6IconType people_robbery_s = on(FontAwesome6Solid.people_robbery).build();
    public static final FontAwesome6IconType people_roof_s = on(FontAwesome6Solid.people_roof).build();
    public static final FontAwesome6IconType pepper_hot_s = on(FontAwesome6Solid.pepper_hot).build();
    public static final FontAwesome6IconType percent_s = on(FontAwesome6Solid.percent).build();
    public static final FontAwesome6IconType person_arrow_down_to_line_s = on(FontAwesome6Solid.person_arrow_down_to_line).build();
    public static final FontAwesome6IconType person_arrow_up_from_line_s = on(FontAwesome6Solid.person_arrow_up_from_line).build();
    public static final FontAwesome6IconType person_biking_s = on(FontAwesome6Solid.person_biking).build();
    public static final FontAwesome6IconType person_booth_s = on(FontAwesome6Solid.person_booth).build();
    public static final FontAwesome6IconType person_breastfeeding_s = on(FontAwesome6Solid.person_breastfeeding).build();
    public static final FontAwesome6IconType person_burst_s = on(FontAwesome6Solid.person_burst).build();
    public static final FontAwesome6IconType person_cane_s = on(FontAwesome6Solid.person_cane).build();
    public static final FontAwesome6IconType person_chalkboard_s = on(FontAwesome6Solid.person_chalkboard).build();
    public static final FontAwesome6IconType person_circle_check_s = on(FontAwesome6Solid.person_circle_check).build();
    public static final FontAwesome6IconType person_circle_exclamation_s = on(FontAwesome6Solid.person_circle_exclamation).build();
    public static final FontAwesome6IconType person_circle_minus_s = on(FontAwesome6Solid.person_circle_minus).build();
    public static final FontAwesome6IconType person_circle_plus_s = on(FontAwesome6Solid.person_circle_plus).build();
    public static final FontAwesome6IconType person_circle_question_s = on(FontAwesome6Solid.person_circle_question).build();
    public static final FontAwesome6IconType person_circle_xmark_s = on(FontAwesome6Solid.person_circle_xmark).build();
    public static final FontAwesome6IconType person_digging_s = on(FontAwesome6Solid.person_digging).build();
    public static final FontAwesome6IconType person_dots_from_line_s = on(FontAwesome6Solid.person_dots_from_line).build();
    public static final FontAwesome6IconType person_dress_burst_s = on(FontAwesome6Solid.person_dress_burst).build();
    public static final FontAwesome6IconType person_dress_s = on(FontAwesome6Solid.person_dress).build();
    public static final FontAwesome6IconType person_drowning_s = on(FontAwesome6Solid.person_drowning).build();
    public static final FontAwesome6IconType person_falling_burst_s = on(FontAwesome6Solid.person_falling_burst).build();
    public static final FontAwesome6IconType person_falling_s = on(FontAwesome6Solid.person_falling).build();
    public static final FontAwesome6IconType person_half_dress_s = on(FontAwesome6Solid.person_half_dress).build();
    public static final FontAwesome6IconType person_harassing_s = on(FontAwesome6Solid.person_harassing).build();
    public static final FontAwesome6IconType person_hiking_s = on(FontAwesome6Solid.person_hiking).build();
    public static final FontAwesome6IconType person_military_pointing_s = on(FontAwesome6Solid.person_military_pointing).build();
    public static final FontAwesome6IconType person_military_rifle_s = on(FontAwesome6Solid.person_military_rifle).build();
    public static final FontAwesome6IconType person_military_to_person_s = on(FontAwesome6Solid.person_military_to_person).build();
    public static final FontAwesome6IconType person_praying_s = on(FontAwesome6Solid.person_praying).build();
    public static final FontAwesome6IconType person_pregnant_s = on(FontAwesome6Solid.person_pregnant).build();
    public static final FontAwesome6IconType person_rays_s = on(FontAwesome6Solid.person_rays).build();
    public static final FontAwesome6IconType person_rifle_s = on(FontAwesome6Solid.person_rifle).build();
    public static final FontAwesome6IconType person_running_s = on(FontAwesome6Solid.person_running).build();
    public static final FontAwesome6IconType person_s = on(FontAwesome6Solid.person).build();
    public static final FontAwesome6IconType person_shelter_s = on(FontAwesome6Solid.person_shelter).build();
    public static final FontAwesome6IconType person_skating_s = on(FontAwesome6Solid.person_skating).build();
    public static final FontAwesome6IconType person_skiing_nordic_s = on(FontAwesome6Solid.person_skiing_nordic).build();
    public static final FontAwesome6IconType person_skiing_s = on(FontAwesome6Solid.person_skiing).build();
    public static final FontAwesome6IconType person_snowboarding_s = on(FontAwesome6Solid.person_snowboarding).build();
    public static final FontAwesome6IconType person_swimming_s = on(FontAwesome6Solid.person_swimming).build();
    public static final FontAwesome6IconType person_through_window_s = on(FontAwesome6Solid.person_through_window).build();
    public static final FontAwesome6IconType person_walking_arrow_loop_left_s = on(FontAwesome6Solid.person_walking_arrow_loop_left).build();
    public static final FontAwesome6IconType person_walking_arrow_right_s = on(FontAwesome6Solid.person_walking_arrow_right).build();
    public static final FontAwesome6IconType person_walking_dashed_line_arrow_right_s = on(FontAwesome6Solid.person_walking_dashed_line_arrow_right).build();
    public static final FontAwesome6IconType person_walking_luggage_s = on(FontAwesome6Solid.person_walking_luggage).build();
    public static final FontAwesome6IconType person_walking_s = on(FontAwesome6Solid.person_walking).build();
    public static final FontAwesome6IconType person_walking_with_cane_s = on(FontAwesome6Solid.person_walking_with_cane).build();
    public static final FontAwesome6IconType peseta_sign_s = on(FontAwesome6Solid.peseta_sign).build();
    public static final FontAwesome6IconType peso_sign_s = on(FontAwesome6Solid.peso_sign).build();
    public static final FontAwesome6IconType phone_flip_s = on(FontAwesome6Solid.phone_flip).build();
    public static final FontAwesome6IconType phone_s = on(FontAwesome6Solid.phone).build();
    public static final FontAwesome6IconType phone_slash_s = on(FontAwesome6Solid.phone_slash).build();
    public static final FontAwesome6IconType phone_volume_s = on(FontAwesome6Solid.phone_volume).build();
    public static final FontAwesome6IconType photo_film_s = on(FontAwesome6Solid.photo_film).build();
    public static final FontAwesome6IconType piggy_bank_s = on(FontAwesome6Solid.piggy_bank).build();
    public static final FontAwesome6IconType pills_s = on(FontAwesome6Solid.pills).build();
    public static final FontAwesome6IconType pizza_slice_s = on(FontAwesome6Solid.pizza_slice).build();
    public static final FontAwesome6IconType place_of_worship_s = on(FontAwesome6Solid.place_of_worship).build();
    public static final FontAwesome6IconType plane_arrival_s = on(FontAwesome6Solid.plane_arrival).build();
    public static final FontAwesome6IconType plane_circle_check_s = on(FontAwesome6Solid.plane_circle_check).build();
    public static final FontAwesome6IconType plane_circle_exclamation_s = on(FontAwesome6Solid.plane_circle_exclamation).build();
    public static final FontAwesome6IconType plane_circle_xmark_s = on(FontAwesome6Solid.plane_circle_xmark).build();
    public static final FontAwesome6IconType plane_departure_s = on(FontAwesome6Solid.plane_departure).build();
    public static final FontAwesome6IconType plane_lock_s = on(FontAwesome6Solid.plane_lock).build();
    public static final FontAwesome6IconType plane_s = on(FontAwesome6Solid.plane).build();
    public static final FontAwesome6IconType plane_slash_s = on(FontAwesome6Solid.plane_slash).build();
    public static final FontAwesome6IconType plane_up_s = on(FontAwesome6Solid.plane_up).build();
    public static final FontAwesome6IconType plant_wilt_s = on(FontAwesome6Solid.plant_wilt).build();
    public static final FontAwesome6IconType plate_wheat_s = on(FontAwesome6Solid.plate_wheat).build();
    public static final FontAwesome6IconType play_s = on(FontAwesome6Solid.play).build();
    public static final FontAwesome6IconType plug_circle_bolt_s = on(FontAwesome6Solid.plug_circle_bolt).build();
    public static final FontAwesome6IconType plug_circle_check_s = on(FontAwesome6Solid.plug_circle_check).build();
    public static final FontAwesome6IconType plug_circle_exclamation_s = on(FontAwesome6Solid.plug_circle_exclamation).build();
    public static final FontAwesome6IconType plug_circle_minus_s = on(FontAwesome6Solid.plug_circle_minus).build();
    public static final FontAwesome6IconType plug_circle_plus_s = on(FontAwesome6Solid.plug_circle_plus).build();
    public static final FontAwesome6IconType plug_circle_xmark_s = on(FontAwesome6Solid.plug_circle_xmark).build();
    public static final FontAwesome6IconType plug_s = on(FontAwesome6Solid.plug).build();
    public static final FontAwesome6IconType plus_minus_s = on(FontAwesome6Solid.plus_minus).build();
    public static final FontAwesome6IconType plus_s = on(FontAwesome6Solid.plus).build();
    public static final FontAwesome6IconType podcast_s = on(FontAwesome6Solid.podcast).build();
    public static final FontAwesome6IconType poo_s = on(FontAwesome6Solid.poo).build();
    public static final FontAwesome6IconType poo_storm_s = on(FontAwesome6Solid.poo_storm).build();
    public static final FontAwesome6IconType poop_s = on(FontAwesome6Solid.poop).build();
    public static final FontAwesome6IconType power_off_s = on(FontAwesome6Solid.power_off).build();
    public static final FontAwesome6IconType prescription_bottle_medical_s = on(FontAwesome6Solid.prescription_bottle_medical).build();
    public static final FontAwesome6IconType prescription_bottle_s = on(FontAwesome6Solid.prescription_bottle).build();
    public static final FontAwesome6IconType prescription_s = on(FontAwesome6Solid.prescription).build();
    public static final FontAwesome6IconType print_s = on(FontAwesome6Solid.print).build();
    public static final FontAwesome6IconType pump_medical_s = on(FontAwesome6Solid.pump_medical).build();
    public static final FontAwesome6IconType pump_soap_s = on(FontAwesome6Solid.pump_soap).build();
    public static final FontAwesome6IconType puzzle_piece_s = on(FontAwesome6Solid.puzzle_piece).build();
    public static final FontAwesome6IconType q_s = on(FontAwesome6Solid.q).build();
    public static final FontAwesome6IconType qrcode_s = on(FontAwesome6Solid.qrcode).build();
    public static final FontAwesome6IconType question_s = on(FontAwesome6Solid.question).build();
    public static final FontAwesome6IconType quote_left_s = on(FontAwesome6Solid.quote_left).build();
    public static final FontAwesome6IconType quote_right_s = on(FontAwesome6Solid.quote_right).build();
    public static final FontAwesome6IconType r_s = on(FontAwesome6Solid.r).build();
    public static final FontAwesome6IconType radiation_s = on(FontAwesome6Solid.radiation).build();
    public static final FontAwesome6IconType radio_s = on(FontAwesome6Solid.radio).build();
    public static final FontAwesome6IconType rainbow_s = on(FontAwesome6Solid.rainbow).build();
    public static final FontAwesome6IconType ranking_star_s = on(FontAwesome6Solid.ranking_star).build();
    public static final FontAwesome6IconType receipt_s = on(FontAwesome6Solid.receipt).build();
    public static final FontAwesome6IconType record_vinyl_s = on(FontAwesome6Solid.record_vinyl).build();
    public static final FontAwesome6IconType rectangle_ad_s = on(FontAwesome6Solid.rectangle_ad).build();
    public static final FontAwesome6IconType rectangle_list_r = on(FontAwesome6Regular.rectangle_list).build();
    public static final FontAwesome6IconType rectangle_list_s = on(FontAwesome6Solid.rectangle_list).build();
    public static final FontAwesome6IconType rectangle_xmark_r = on(FontAwesome6Regular.rectangle_xmark).build();
    public static final FontAwesome6IconType rectangle_xmark_s = on(FontAwesome6Solid.rectangle_xmark).build();
    public static final FontAwesome6IconType recycle_s = on(FontAwesome6Solid.recycle).build();
    public static final FontAwesome6IconType registered_r = on(FontAwesome6Regular.registered).build();
    public static final FontAwesome6IconType registered_s = on(FontAwesome6Solid.registered).build();
    public static final FontAwesome6IconType repeat_s = on(FontAwesome6Solid.repeat).build();
    public static final FontAwesome6IconType reply_all_s = on(FontAwesome6Solid.reply_all).build();
    public static final FontAwesome6IconType reply_s = on(FontAwesome6Solid.reply).build();
    public static final FontAwesome6IconType republican_s = on(FontAwesome6Solid.republican).build();
    public static final FontAwesome6IconType restroom_s = on(FontAwesome6Solid.restroom).build();
    public static final FontAwesome6IconType retweet_s = on(FontAwesome6Solid.retweet).build();
    public static final FontAwesome6IconType ribbon_s = on(FontAwesome6Solid.ribbon).build();
    public static final FontAwesome6IconType right_from_bracket_s = on(FontAwesome6Solid.right_from_bracket).build();
    public static final FontAwesome6IconType right_left_s = on(FontAwesome6Solid.right_left).build();
    public static final FontAwesome6IconType right_long_s = on(FontAwesome6Solid.right_long).build();
    public static final FontAwesome6IconType right_to_bracket_s = on(FontAwesome6Solid.right_to_bracket).build();
    public static final FontAwesome6IconType ring_s = on(FontAwesome6Solid.ring).build();
    public static final FontAwesome6IconType road_barrier_s = on(FontAwesome6Solid.road_barrier).build();
    public static final FontAwesome6IconType road_bridge_s = on(FontAwesome6Solid.road_bridge).build();
    public static final FontAwesome6IconType road_circle_check_s = on(FontAwesome6Solid.road_circle_check).build();
    public static final FontAwesome6IconType road_circle_exclamation_s = on(FontAwesome6Solid.road_circle_exclamation).build();
    public static final FontAwesome6IconType road_circle_xmark_s = on(FontAwesome6Solid.road_circle_xmark).build();
    public static final FontAwesome6IconType road_lock_s = on(FontAwesome6Solid.road_lock).build();
    public static final FontAwesome6IconType road_s = on(FontAwesome6Solid.road).build();
    public static final FontAwesome6IconType road_spikes_s = on(FontAwesome6Solid.road_spikes).build();
    public static final FontAwesome6IconType robot_s = on(FontAwesome6Solid.robot).build();
    public static final FontAwesome6IconType rocket_s = on(FontAwesome6Solid.rocket).build();
    public static final FontAwesome6IconType rotate_left_s = on(FontAwesome6Solid.rotate_left).build();
    public static final FontAwesome6IconType rotate_right_s = on(FontAwesome6Solid.rotate_right).build();
    public static final FontAwesome6IconType rotate_s = on(FontAwesome6Solid.rotate).build();
    public static final FontAwesome6IconType route_s = on(FontAwesome6Solid.route).build();
    public static final FontAwesome6IconType rss_s = on(FontAwesome6Solid.rss).build();
    public static final FontAwesome6IconType ruble_sign_s = on(FontAwesome6Solid.ruble_sign).build();
    public static final FontAwesome6IconType rug_s = on(FontAwesome6Solid.rug).build();
    public static final FontAwesome6IconType ruler_combined_s = on(FontAwesome6Solid.ruler_combined).build();
    public static final FontAwesome6IconType ruler_horizontal_s = on(FontAwesome6Solid.ruler_horizontal).build();
    public static final FontAwesome6IconType ruler_s = on(FontAwesome6Solid.ruler).build();
    public static final FontAwesome6IconType ruler_vertical_s = on(FontAwesome6Solid.ruler_vertical).build();
    public static final FontAwesome6IconType rupee_sign_s = on(FontAwesome6Solid.rupee_sign).build();
    public static final FontAwesome6IconType rupiah_sign_s = on(FontAwesome6Solid.rupiah_sign).build();
    public static final FontAwesome6IconType s_s = on(FontAwesome6Solid.s).build();
    public static final FontAwesome6IconType sack_dollar_s = on(FontAwesome6Solid.sack_dollar).build();
    public static final FontAwesome6IconType sack_xmark_s = on(FontAwesome6Solid.sack_xmark).build();
    public static final FontAwesome6IconType sailboat_s = on(FontAwesome6Solid.sailboat).build();
    public static final FontAwesome6IconType satellite_dish_s = on(FontAwesome6Solid.satellite_dish).build();
    public static final FontAwesome6IconType satellite_s = on(FontAwesome6Solid.satellite).build();
    public static final FontAwesome6IconType scale_balanced_s = on(FontAwesome6Solid.scale_balanced).build();
    public static final FontAwesome6IconType scale_unbalanced_flip_s = on(FontAwesome6Solid.scale_unbalanced_flip).build();
    public static final FontAwesome6IconType scale_unbalanced_s = on(FontAwesome6Solid.scale_unbalanced).build();
    public static final FontAwesome6IconType school_circle_check_s = on(FontAwesome6Solid.school_circle_check).build();
    public static final FontAwesome6IconType school_circle_exclamation_s = on(FontAwesome6Solid.school_circle_exclamation).build();
    public static final FontAwesome6IconType school_circle_xmark_s = on(FontAwesome6Solid.school_circle_xmark).build();
    public static final FontAwesome6IconType school_flag_s = on(FontAwesome6Solid.school_flag).build();
    public static final FontAwesome6IconType school_lock_s = on(FontAwesome6Solid.school_lock).build();
    public static final FontAwesome6IconType school_s = on(FontAwesome6Solid.school).build();
    public static final FontAwesome6IconType scissors_s = on(FontAwesome6Solid.scissors).build();
    public static final FontAwesome6IconType screwdriver_s = on(FontAwesome6Solid.screwdriver).build();
    public static final FontAwesome6IconType screwdriver_wrench_s = on(FontAwesome6Solid.screwdriver_wrench).build();
    public static final FontAwesome6IconType scroll_s = on(FontAwesome6Solid.scroll).build();
    public static final FontAwesome6IconType scroll_torah_s = on(FontAwesome6Solid.scroll_torah).build();
    public static final FontAwesome6IconType sd_card_s = on(FontAwesome6Solid.sd_card).build();
    public static final FontAwesome6IconType section_s = on(FontAwesome6Solid.section).build();
    public static final FontAwesome6IconType seedling_s = on(FontAwesome6Solid.seedling).build();
    public static final FontAwesome6IconType server_s = on(FontAwesome6Solid.server).build();
    public static final FontAwesome6IconType shapes_s = on(FontAwesome6Solid.shapes).build();
    public static final FontAwesome6IconType share_from_square_r = on(FontAwesome6Regular.share_from_square).build();
    public static final FontAwesome6IconType share_from_square_s = on(FontAwesome6Solid.share_from_square).build();
    public static final FontAwesome6IconType share_nodes_s = on(FontAwesome6Solid.share_nodes).build();
    public static final FontAwesome6IconType share_s = on(FontAwesome6Solid.share).build();
    public static final FontAwesome6IconType sheet_plastic_s = on(FontAwesome6Solid.sheet_plastic).build();
    public static final FontAwesome6IconType shekel_sign_s = on(FontAwesome6Solid.shekel_sign).build();
    public static final FontAwesome6IconType shield_cat_s = on(FontAwesome6Solid.shield_cat).build();
    public static final FontAwesome6IconType shield_dog_s = on(FontAwesome6Solid.shield_dog).build();
    public static final FontAwesome6IconType shield_halved_s = on(FontAwesome6Solid.shield_halved).build();
    public static final FontAwesome6IconType shield_heart_s = on(FontAwesome6Solid.shield_heart).build();
    public static final FontAwesome6IconType shield_s = on(FontAwesome6Solid.shield).build();
    public static final FontAwesome6IconType shield_virus_s = on(FontAwesome6Solid.shield_virus).build();
    public static final FontAwesome6IconType ship_s = on(FontAwesome6Solid.ship).build();
    public static final FontAwesome6IconType shirt_s = on(FontAwesome6Solid.shirt).build();
    public static final FontAwesome6IconType shoe_prints_s = on(FontAwesome6Solid.shoe_prints).build();
    public static final FontAwesome6IconType shop_lock_s = on(FontAwesome6Solid.shop_lock).build();
    public static final FontAwesome6IconType shop_s = on(FontAwesome6Solid.shop).build();
    public static final FontAwesome6IconType shop_slash_s = on(FontAwesome6Solid.shop_slash).build();
    public static final FontAwesome6IconType shower_s = on(FontAwesome6Solid.shower).build();
    public static final FontAwesome6IconType shrimp_s = on(FontAwesome6Solid.shrimp).build();
    public static final FontAwesome6IconType shuffle_s = on(FontAwesome6Solid.shuffle).build();
    public static final FontAwesome6IconType shuttle_space_s = on(FontAwesome6Solid.shuttle_space).build();
    public static final FontAwesome6IconType sign_hanging_s = on(FontAwesome6Solid.sign_hanging).build();
    public static final FontAwesome6IconType signal_s = on(FontAwesome6Solid.signal).build();
    public static final FontAwesome6IconType signature_s = on(FontAwesome6Solid.signature).build();
    public static final FontAwesome6IconType signs_post_s = on(FontAwesome6Solid.signs_post).build();
    public static final FontAwesome6IconType sim_card_s = on(FontAwesome6Solid.sim_card).build();
    public static final FontAwesome6IconType sink_s = on(FontAwesome6Solid.sink).build();
    public static final FontAwesome6IconType sitemap_s = on(FontAwesome6Solid.sitemap).build();
    public static final FontAwesome6IconType skull_crossbones_s = on(FontAwesome6Solid.skull_crossbones).build();
    public static final FontAwesome6IconType skull_s = on(FontAwesome6Solid.skull).build();
    public static final FontAwesome6IconType slash_s = on(FontAwesome6Solid.slash).build();
    public static final FontAwesome6IconType sleigh_s = on(FontAwesome6Solid.sleigh).build();
    public static final FontAwesome6IconType sliders_s = on(FontAwesome6Solid.sliders).build();
    public static final FontAwesome6IconType smog_s = on(FontAwesome6Solid.smog).build();
    public static final FontAwesome6IconType smoking_s = on(FontAwesome6Solid.smoking).build();
    public static final FontAwesome6IconType snowflake_r = on(FontAwesome6Regular.snowflake).build();
    public static final FontAwesome6IconType snowflake_s = on(FontAwesome6Solid.snowflake).build();
    public static final FontAwesome6IconType snowman_s = on(FontAwesome6Solid.snowman).build();
    public static final FontAwesome6IconType snowplow_s = on(FontAwesome6Solid.snowplow).build();
    public static final FontAwesome6IconType soap_s = on(FontAwesome6Solid.soap).build();
    public static final FontAwesome6IconType socks_s = on(FontAwesome6Solid.socks).build();
    public static final FontAwesome6IconType solar_panel_s = on(FontAwesome6Solid.solar_panel).build();
    public static final FontAwesome6IconType sort_down_s = on(FontAwesome6Solid.sort_down).build();
    public static final FontAwesome6IconType sort_s = on(FontAwesome6Solid.sort).build();
    public static final FontAwesome6IconType sort_up_s = on(FontAwesome6Solid.sort_up).build();
    public static final FontAwesome6IconType spa_s = on(FontAwesome6Solid.spa).build();
    public static final FontAwesome6IconType spaghetti_monster_flying_s = on(FontAwesome6Solid.spaghetti_monster_flying).build();
    public static final FontAwesome6IconType spell_check_s = on(FontAwesome6Solid.spell_check).build();
    public static final FontAwesome6IconType spider_s = on(FontAwesome6Solid.spider).build();
    public static final FontAwesome6IconType spinner_s = on(FontAwesome6Solid.spinner).build();
    public static final FontAwesome6IconType splotch_s = on(FontAwesome6Solid.splotch).build();
    public static final FontAwesome6IconType spoon_s = on(FontAwesome6Solid.spoon).build();
    public static final FontAwesome6IconType spray_can_s = on(FontAwesome6Solid.spray_can).build();
    public static final FontAwesome6IconType spray_can_sparkles_s = on(FontAwesome6Solid.spray_can_sparkles).build();
    public static final FontAwesome6IconType square_arrow_up_right_s = on(FontAwesome6Solid.square_arrow_up_right).build();
    public static final FontAwesome6IconType square_binary_s = on(FontAwesome6Solid.square_binary).build();
    public static final FontAwesome6IconType square_caret_down_r = on(FontAwesome6Regular.square_caret_down).build();
    public static final FontAwesome6IconType square_caret_down_s = on(FontAwesome6Solid.square_caret_down).build();
    public static final FontAwesome6IconType square_caret_left_r = on(FontAwesome6Regular.square_caret_left).build();
    public static final FontAwesome6IconType square_caret_left_s = on(FontAwesome6Solid.square_caret_left).build();
    public static final FontAwesome6IconType square_caret_right_r = on(FontAwesome6Regular.square_caret_right).build();
    public static final FontAwesome6IconType square_caret_right_s = on(FontAwesome6Solid.square_caret_right).build();
    public static final FontAwesome6IconType square_caret_up_r = on(FontAwesome6Regular.square_caret_up).build();
    public static final FontAwesome6IconType square_caret_up_s = on(FontAwesome6Solid.square_caret_up).build();
    public static final FontAwesome6IconType square_check_r = on(FontAwesome6Regular.square_check).build();
    public static final FontAwesome6IconType square_check_s = on(FontAwesome6Solid.square_check).build();
    public static final FontAwesome6IconType square_envelope_s = on(FontAwesome6Solid.square_envelope).build();
    public static final FontAwesome6IconType square_full_r = on(FontAwesome6Regular.square_full).build();
    public static final FontAwesome6IconType square_full_s = on(FontAwesome6Solid.square_full).build();
    public static final FontAwesome6IconType square_h_s = on(FontAwesome6Solid.square_h).build();
    public static final FontAwesome6IconType square_minus_r = on(FontAwesome6Regular.square_minus).build();
    public static final FontAwesome6IconType square_minus_s = on(FontAwesome6Solid.square_minus).build();
    public static final FontAwesome6IconType square_nfi_s = on(FontAwesome6Solid.square_nfi).build();
    public static final FontAwesome6IconType square_parking_s = on(FontAwesome6Solid.square_parking).build();
    public static final FontAwesome6IconType square_pen_s = on(FontAwesome6Solid.square_pen).build();
    public static final FontAwesome6IconType square_person_confined_s = on(FontAwesome6Solid.square_person_confined).build();
    public static final FontAwesome6IconType square_phone_flip_s = on(FontAwesome6Solid.square_phone_flip).build();
    public static final FontAwesome6IconType square_phone_s = on(FontAwesome6Solid.square_phone).build();
    public static final FontAwesome6IconType square_plus_r = on(FontAwesome6Regular.square_plus).build();
    public static final FontAwesome6IconType square_plus_s = on(FontAwesome6Solid.square_plus).build();
    public static final FontAwesome6IconType square_poll_horizontal_s = on(FontAwesome6Solid.square_poll_horizontal).build();
    public static final FontAwesome6IconType square_poll_vertical_s = on(FontAwesome6Solid.square_poll_vertical).build();
    public static final FontAwesome6IconType square_r = on(FontAwesome6Regular.square).build();
    public static final FontAwesome6IconType square_root_variable_s = on(FontAwesome6Solid.square_root_variable).build();
    public static final FontAwesome6IconType square_rss_s = on(FontAwesome6Solid.square_rss).build();
    public static final FontAwesome6IconType square_s = on(FontAwesome6Solid.square).build();
    public static final FontAwesome6IconType square_share_nodes_s = on(FontAwesome6Solid.square_share_nodes).build();
    public static final FontAwesome6IconType square_up_right_s = on(FontAwesome6Solid.square_up_right).build();
    public static final FontAwesome6IconType square_virus_s = on(FontAwesome6Solid.square_virus).build();
    public static final FontAwesome6IconType square_xmark_s = on(FontAwesome6Solid.square_xmark).build();
    public static final FontAwesome6IconType staff_snake_s = on(FontAwesome6Solid.staff_snake).build();
    public static final FontAwesome6IconType stairs_s = on(FontAwesome6Solid.stairs).build();
    public static final FontAwesome6IconType stamp_s = on(FontAwesome6Solid.stamp).build();
    public static final FontAwesome6IconType stapler_s = on(FontAwesome6Solid.stapler).build();
    public static final FontAwesome6IconType star_and_crescent_s = on(FontAwesome6Solid.star_and_crescent).build();
    public static final FontAwesome6IconType star_half_r = on(FontAwesome6Regular.star_half).build();
    public static final FontAwesome6IconType star_half_s = on(FontAwesome6Solid.star_half).build();
    public static final FontAwesome6IconType star_half_stroke_r = on(FontAwesome6Regular.star_half_stroke).build();
    public static final FontAwesome6IconType star_half_stroke_s = on(FontAwesome6Solid.star_half_stroke).build();
    public static final FontAwesome6IconType star_of_david_s = on(FontAwesome6Solid.star_of_david).build();
    public static final FontAwesome6IconType star_of_life_s = on(FontAwesome6Solid.star_of_life).build();
    public static final FontAwesome6IconType star_r = on(FontAwesome6Regular.star).build();
    public static final FontAwesome6IconType star_s = on(FontAwesome6Solid.star).build();
    public static final FontAwesome6IconType sterling_sign_s = on(FontAwesome6Solid.sterling_sign).build();
    public static final FontAwesome6IconType stethoscope_s = on(FontAwesome6Solid.stethoscope).build();
    public static final FontAwesome6IconType stop_s = on(FontAwesome6Solid.stop).build();
    public static final FontAwesome6IconType stopwatch_20_s = on(FontAwesome6Solid.stopwatch_20).build();
    public static final FontAwesome6IconType stopwatch_s = on(FontAwesome6Solid.stopwatch).build();
    public static final FontAwesome6IconType store_s = on(FontAwesome6Solid.store).build();
    public static final FontAwesome6IconType store_slash_s = on(FontAwesome6Solid.store_slash).build();
    public static final FontAwesome6IconType street_view_s = on(FontAwesome6Solid.street_view).build();
    public static final FontAwesome6IconType strikethrough_s = on(FontAwesome6Solid.strikethrough).build();
    public static final FontAwesome6IconType stroopwafel_s = on(FontAwesome6Solid.stroopwafel).build();
    public static final FontAwesome6IconType subscript_s = on(FontAwesome6Solid.subscript).build();
    public static final FontAwesome6IconType suitcase_medical_s = on(FontAwesome6Solid.suitcase_medical).build();
    public static final FontAwesome6IconType suitcase_rolling_s = on(FontAwesome6Solid.suitcase_rolling).build();
    public static final FontAwesome6IconType suitcase_s = on(FontAwesome6Solid.suitcase).build();
    public static final FontAwesome6IconType sun_plant_wilt_s = on(FontAwesome6Solid.sun_plant_wilt).build();
    public static final FontAwesome6IconType sun_r = on(FontAwesome6Regular.sun).build();
    public static final FontAwesome6IconType sun_s = on(FontAwesome6Solid.sun).build();
    public static final FontAwesome6IconType superscript_s = on(FontAwesome6Solid.superscript).build();
    public static final FontAwesome6IconType swatchbook_s = on(FontAwesome6Solid.swatchbook).build();
    public static final FontAwesome6IconType synagogue_s = on(FontAwesome6Solid.synagogue).build();
    public static final FontAwesome6IconType syringe_s = on(FontAwesome6Solid.syringe).build();
    public static final FontAwesome6IconType t_s = on(FontAwesome6Solid.t).build();
    public static final FontAwesome6IconType table_cells_column_lock_s = on(FontAwesome6Solid.table_cells_column_lock).build();
    public static final FontAwesome6IconType table_cells_large_s = on(FontAwesome6Solid.table_cells_large).build();
    public static final FontAwesome6IconType table_cells_row_lock_s = on(FontAwesome6Solid.table_cells_row_lock).build();
    public static final FontAwesome6IconType table_cells_row_unlock_s = on(FontAwesome6Solid.table_cells_row_unlock).build();
    public static final FontAwesome6IconType table_cells_s = on(FontAwesome6Solid.table_cells).build();
    public static final FontAwesome6IconType table_columns_s = on(FontAwesome6Solid.table_columns).build();
    public static final FontAwesome6IconType table_list_s = on(FontAwesome6Solid.table_list).build();
    public static final FontAwesome6IconType table_s = on(FontAwesome6Solid.table).build();
    public static final FontAwesome6IconType table_tennis_paddle_ball_s = on(FontAwesome6Solid.table_tennis_paddle_ball).build();
    public static final FontAwesome6IconType tablet_button_s = on(FontAwesome6Solid.tablet_button).build();
    public static final FontAwesome6IconType tablet_s = on(FontAwesome6Solid.tablet).build();
    public static final FontAwesome6IconType tablet_screen_button_s = on(FontAwesome6Solid.tablet_screen_button).build();
    public static final FontAwesome6IconType tablets_s = on(FontAwesome6Solid.tablets).build();
    public static final FontAwesome6IconType tachograph_digital_s = on(FontAwesome6Solid.tachograph_digital).build();
    public static final FontAwesome6IconType tag_s = on(FontAwesome6Solid.tag).build();
    public static final FontAwesome6IconType tags_s = on(FontAwesome6Solid.tags).build();
    public static final FontAwesome6IconType tape_s = on(FontAwesome6Solid.tape).build();
    public static final FontAwesome6IconType tarp_droplet_s = on(FontAwesome6Solid.tarp_droplet).build();
    public static final FontAwesome6IconType tarp_s = on(FontAwesome6Solid.tarp).build();
    public static final FontAwesome6IconType taxi_s = on(FontAwesome6Solid.taxi).build();
    public static final FontAwesome6IconType teeth_open_s = on(FontAwesome6Solid.teeth_open).build();
    public static final FontAwesome6IconType teeth_s = on(FontAwesome6Solid.teeth).build();
    public static final FontAwesome6IconType temperature_arrow_down_s = on(FontAwesome6Solid.temperature_arrow_down).build();
    public static final FontAwesome6IconType temperature_arrow_up_s = on(FontAwesome6Solid.temperature_arrow_up).build();
    public static final FontAwesome6IconType temperature_empty_s = on(FontAwesome6Solid.temperature_empty).build();
    public static final FontAwesome6IconType temperature_full_s = on(FontAwesome6Solid.temperature_full).build();
    public static final FontAwesome6IconType temperature_half_s = on(FontAwesome6Solid.temperature_half).build();
    public static final FontAwesome6IconType temperature_high_s = on(FontAwesome6Solid.temperature_high).build();
    public static final FontAwesome6IconType temperature_low_s = on(FontAwesome6Solid.temperature_low).build();
    public static final FontAwesome6IconType temperature_quarter_s = on(FontAwesome6Solid.temperature_quarter).build();
    public static final FontAwesome6IconType temperature_three_quarters_s = on(FontAwesome6Solid.temperature_three_quarters).build();
    public static final FontAwesome6IconType tenge_sign_s = on(FontAwesome6Solid.tenge_sign).build();
    public static final FontAwesome6IconType tent_arrow_down_to_line_s = on(FontAwesome6Solid.tent_arrow_down_to_line).build();
    public static final FontAwesome6IconType tent_arrow_left_right_s = on(FontAwesome6Solid.tent_arrow_left_right).build();
    public static final FontAwesome6IconType tent_arrow_turn_left_s = on(FontAwesome6Solid.tent_arrow_turn_left).build();
    public static final FontAwesome6IconType tent_arrows_down_s = on(FontAwesome6Solid.tent_arrows_down).build();
    public static final FontAwesome6IconType tent_s = on(FontAwesome6Solid.tent).build();
    public static final FontAwesome6IconType tents_s = on(FontAwesome6Solid.tents).build();
    public static final FontAwesome6IconType terminal_s = on(FontAwesome6Solid.terminal).build();
    public static final FontAwesome6IconType text_height_s = on(FontAwesome6Solid.text_height).build();
    public static final FontAwesome6IconType text_slash_s = on(FontAwesome6Solid.text_slash).build();
    public static final FontAwesome6IconType text_width_s = on(FontAwesome6Solid.text_width).build();
    public static final FontAwesome6IconType thermometer_s = on(FontAwesome6Solid.thermometer).build();
    public static final FontAwesome6IconType thumbs_down_r = on(FontAwesome6Regular.thumbs_down).build();
    public static final FontAwesome6IconType thumbs_down_s = on(FontAwesome6Solid.thumbs_down).build();
    public static final FontAwesome6IconType thumbs_up_r = on(FontAwesome6Regular.thumbs_up).build();
    public static final FontAwesome6IconType thumbs_up_s = on(FontAwesome6Solid.thumbs_up).build();
    public static final FontAwesome6IconType thumbtack_s = on(FontAwesome6Solid.thumbtack).build();
    public static final FontAwesome6IconType thumbtack_slash_s = on(FontAwesome6Solid.thumbtack_slash).build();
    public static final FontAwesome6IconType ticket_s = on(FontAwesome6Solid.ticket).build();
    public static final FontAwesome6IconType ticket_simple_s = on(FontAwesome6Solid.ticket_simple).build();
    public static final FontAwesome6IconType timeline_s = on(FontAwesome6Solid.timeline).build();
    public static final FontAwesome6IconType toggle_off_s = on(FontAwesome6Solid.toggle_off).build();
    public static final FontAwesome6IconType toggle_on_s = on(FontAwesome6Solid.toggle_on).build();
    public static final FontAwesome6IconType toilet_paper_s = on(FontAwesome6Solid.toilet_paper).build();
    public static final FontAwesome6IconType toilet_paper_slash_s = on(FontAwesome6Solid.toilet_paper_slash).build();
    public static final FontAwesome6IconType toilet_portable_s = on(FontAwesome6Solid.toilet_portable).build();
    public static final FontAwesome6IconType toilet_s = on(FontAwesome6Solid.toilet).build();
    public static final FontAwesome6IconType toilets_portable_s = on(FontAwesome6Solid.toilets_portable).build();
    public static final FontAwesome6IconType toolbox_s = on(FontAwesome6Solid.toolbox).build();
    public static final FontAwesome6IconType tooth_s = on(FontAwesome6Solid.tooth).build();
    public static final FontAwesome6IconType torii_gate_s = on(FontAwesome6Solid.torii_gate).build();
    public static final FontAwesome6IconType tornado_s = on(FontAwesome6Solid.tornado).build();
    public static final FontAwesome6IconType tower_broadcast_s = on(FontAwesome6Solid.tower_broadcast).build();
    public static final FontAwesome6IconType tower_cell_s = on(FontAwesome6Solid.tower_cell).build();
    public static final FontAwesome6IconType tower_observation_s = on(FontAwesome6Solid.tower_observation).build();
    public static final FontAwesome6IconType tractor_s = on(FontAwesome6Solid.tractor).build();
    public static final FontAwesome6IconType trademark_s = on(FontAwesome6Solid.trademark).build();
    public static final FontAwesome6IconType traffic_light_s = on(FontAwesome6Solid.traffic_light).build();
    public static final FontAwesome6IconType trailer_s = on(FontAwesome6Solid.trailer).build();
    public static final FontAwesome6IconType train_s = on(FontAwesome6Solid.train).build();
    public static final FontAwesome6IconType train_subway_s = on(FontAwesome6Solid.train_subway).build();
    public static final FontAwesome6IconType train_tram_s = on(FontAwesome6Solid.train_tram).build();
    public static final FontAwesome6IconType transgender_s = on(FontAwesome6Solid.transgender).build();
    public static final FontAwesome6IconType trash_arrow_up_s = on(FontAwesome6Solid.trash_arrow_up).build();
    public static final FontAwesome6IconType trash_can_arrow_up_s = on(FontAwesome6Solid.trash_can_arrow_up).build();
    public static final FontAwesome6IconType trash_can_r = on(FontAwesome6Regular.trash_can).build();
    public static final FontAwesome6IconType trash_can_s = on(FontAwesome6Solid.trash_can).build();
    public static final FontAwesome6IconType trash_s = on(FontAwesome6Solid.trash).build();
    public static final FontAwesome6IconType tree_city_s = on(FontAwesome6Solid.tree_city).build();
    public static final FontAwesome6IconType tree_s = on(FontAwesome6Solid.tree).build();
    public static final FontAwesome6IconType triangle_exclamation_s = on(FontAwesome6Solid.triangle_exclamation).build();
    public static final FontAwesome6IconType trophy_s = on(FontAwesome6Solid.trophy).build();
    public static final FontAwesome6IconType trowel_bricks_s = on(FontAwesome6Solid.trowel_bricks).build();
    public static final FontAwesome6IconType trowel_s = on(FontAwesome6Solid.trowel).build();
    public static final FontAwesome6IconType truck_arrow_right_s = on(FontAwesome6Solid.truck_arrow_right).build();
    public static final FontAwesome6IconType truck_droplet_s = on(FontAwesome6Solid.truck_droplet).build();
    public static final FontAwesome6IconType truck_fast_s = on(FontAwesome6Solid.truck_fast).build();
    public static final FontAwesome6IconType truck_field_s = on(FontAwesome6Solid.truck_field).build();
    public static final FontAwesome6IconType truck_field_un_s = on(FontAwesome6Solid.truck_field_un).build();
    public static final FontAwesome6IconType truck_front_s = on(FontAwesome6Solid.truck_front).build();
    public static final FontAwesome6IconType truck_medical_s = on(FontAwesome6Solid.truck_medical).build();
    public static final FontAwesome6IconType truck_monster_s = on(FontAwesome6Solid.truck_monster).build();
    public static final FontAwesome6IconType truck_moving_s = on(FontAwesome6Solid.truck_moving).build();
    public static final FontAwesome6IconType truck_pickup_s = on(FontAwesome6Solid.truck_pickup).build();
    public static final FontAwesome6IconType truck_plane_s = on(FontAwesome6Solid.truck_plane).build();
    public static final FontAwesome6IconType truck_ramp_box_s = on(FontAwesome6Solid.truck_ramp_box).build();
    public static final FontAwesome6IconType truck_s = on(FontAwesome6Solid.truck).build();
    public static final FontAwesome6IconType tty_s = on(FontAwesome6Solid.tty).build();
    public static final FontAwesome6IconType turkish_lira_sign_s = on(FontAwesome6Solid.turkish_lira_sign).build();
    public static final FontAwesome6IconType turn_down_s = on(FontAwesome6Solid.turn_down).build();
    public static final FontAwesome6IconType turn_up_s = on(FontAwesome6Solid.turn_up).build();
    public static final FontAwesome6IconType tv_s = on(FontAwesome6Solid.tv).build();
    public static final FontAwesome6IconType u_s = on(FontAwesome6Solid.u).build();
    public static final FontAwesome6IconType umbrella_beach_s = on(FontAwesome6Solid.umbrella_beach).build();
    public static final FontAwesome6IconType umbrella_s = on(FontAwesome6Solid.umbrella).build();
    public static final FontAwesome6IconType underline_s = on(FontAwesome6Solid.underline).build();
    public static final FontAwesome6IconType universal_access_s = on(FontAwesome6Solid.universal_access).build();
    public static final FontAwesome6IconType unlock_keyhole_s = on(FontAwesome6Solid.unlock_keyhole).build();
    public static final FontAwesome6IconType unlock_s = on(FontAwesome6Solid.unlock).build();
    public static final FontAwesome6IconType up_down_left_right_s = on(FontAwesome6Solid.up_down_left_right).build();
    public static final FontAwesome6IconType up_down_s = on(FontAwesome6Solid.up_down).build();
    public static final FontAwesome6IconType up_long_s = on(FontAwesome6Solid.up_long).build();
    public static final FontAwesome6IconType up_right_and_down_left_from_center_s = on(FontAwesome6Solid.up_right_and_down_left_from_center).build();
    public static final FontAwesome6IconType up_right_from_square_s = on(FontAwesome6Solid.up_right_from_square).build();
    public static final FontAwesome6IconType upload_s = on(FontAwesome6Solid.upload).build();
    public static final FontAwesome6IconType user_astronaut_s = on(FontAwesome6Solid.user_astronaut).build();
    public static final FontAwesome6IconType user_check_s = on(FontAwesome6Solid.user_check).build();
    public static final FontAwesome6IconType user_clock_s = on(FontAwesome6Solid.user_clock).build();
    public static final FontAwesome6IconType user_doctor_s = on(FontAwesome6Solid.user_doctor).build();
    public static final FontAwesome6IconType user_gear_s = on(FontAwesome6Solid.user_gear).build();
    public static final FontAwesome6IconType user_graduate_s = on(FontAwesome6Solid.user_graduate).build();
    public static final FontAwesome6IconType user_group_s = on(FontAwesome6Solid.user_group).build();
    public static final FontAwesome6IconType user_injured_s = on(FontAwesome6Solid.user_injured).build();
    public static final FontAwesome6IconType user_large_s = on(FontAwesome6Solid.user_large).build();
    public static final FontAwesome6IconType user_large_slash_s = on(FontAwesome6Solid.user_large_slash).build();
    public static final FontAwesome6IconType user_lock_s = on(FontAwesome6Solid.user_lock).build();
    public static final FontAwesome6IconType user_minus_s = on(FontAwesome6Solid.user_minus).build();
    public static final FontAwesome6IconType user_ninja_s = on(FontAwesome6Solid.user_ninja).build();
    public static final FontAwesome6IconType user_nurse_s = on(FontAwesome6Solid.user_nurse).build();
    public static final FontAwesome6IconType user_pen_s = on(FontAwesome6Solid.user_pen).build();
    public static final FontAwesome6IconType user_plus_s = on(FontAwesome6Solid.user_plus).build();
    public static final FontAwesome6IconType user_r = on(FontAwesome6Regular.user).build();
    public static final FontAwesome6IconType user_s = on(FontAwesome6Solid.user).build();
    public static final FontAwesome6IconType user_secret_s = on(FontAwesome6Solid.user_secret).build();
    public static final FontAwesome6IconType user_shield_s = on(FontAwesome6Solid.user_shield).build();
    public static final FontAwesome6IconType user_slash_s = on(FontAwesome6Solid.user_slash).build();
    public static final FontAwesome6IconType user_tag_s = on(FontAwesome6Solid.user_tag).build();
    public static final FontAwesome6IconType user_tie_s = on(FontAwesome6Solid.user_tie).build();
    public static final FontAwesome6IconType user_xmark_s = on(FontAwesome6Solid.user_xmark).build();
    public static final FontAwesome6IconType users_between_lines_s = on(FontAwesome6Solid.users_between_lines).build();
    public static final FontAwesome6IconType users_gear_s = on(FontAwesome6Solid.users_gear).build();
    public static final FontAwesome6IconType users_line_s = on(FontAwesome6Solid.users_line).build();
    public static final FontAwesome6IconType users_rays_s = on(FontAwesome6Solid.users_rays).build();
    public static final FontAwesome6IconType users_rectangle_s = on(FontAwesome6Solid.users_rectangle).build();
    public static final FontAwesome6IconType users_s = on(FontAwesome6Solid.users).build();
    public static final FontAwesome6IconType users_slash_s = on(FontAwesome6Solid.users_slash).build();
    public static final FontAwesome6IconType users_viewfinder_s = on(FontAwesome6Solid.users_viewfinder).build();
    public static final FontAwesome6IconType utensils_s = on(FontAwesome6Solid.utensils).build();
    public static final FontAwesome6IconType v_s = on(FontAwesome6Solid.v).build();
    public static final FontAwesome6IconType van_shuttle_s = on(FontAwesome6Solid.van_shuttle).build();
    public static final FontAwesome6IconType vault_s = on(FontAwesome6Solid.vault).build();
    public static final FontAwesome6IconType vector_square_s = on(FontAwesome6Solid.vector_square).build();
    public static final FontAwesome6IconType venus_double_s = on(FontAwesome6Solid.venus_double).build();
    public static final FontAwesome6IconType venus_mars_s = on(FontAwesome6Solid.venus_mars).build();
    public static final FontAwesome6IconType venus_s = on(FontAwesome6Solid.venus).build();
    public static final FontAwesome6IconType vest_patches_s = on(FontAwesome6Solid.vest_patches).build();
    public static final FontAwesome6IconType vest_s = on(FontAwesome6Solid.vest).build();
    public static final FontAwesome6IconType vial_circle_check_s = on(FontAwesome6Solid.vial_circle_check).build();
    public static final FontAwesome6IconType vial_s = on(FontAwesome6Solid.vial).build();
    public static final FontAwesome6IconType vial_virus_s = on(FontAwesome6Solid.vial_virus).build();
    public static final FontAwesome6IconType vials_s = on(FontAwesome6Solid.vials).build();
    public static final FontAwesome6IconType video_s = on(FontAwesome6Solid.video).build();
    public static final FontAwesome6IconType video_slash_s = on(FontAwesome6Solid.video_slash).build();
    public static final FontAwesome6IconType vihara_s = on(FontAwesome6Solid.vihara).build();
    public static final FontAwesome6IconType virus_covid_s = on(FontAwesome6Solid.virus_covid).build();
    public static final FontAwesome6IconType virus_covid_slash_s = on(FontAwesome6Solid.virus_covid_slash).build();
    public static final FontAwesome6IconType virus_s = on(FontAwesome6Solid.virus).build();
    public static final FontAwesome6IconType virus_slash_s = on(FontAwesome6Solid.virus_slash).build();
    public static final FontAwesome6IconType viruses_s = on(FontAwesome6Solid.viruses).build();
    public static final FontAwesome6IconType voicemail_s = on(FontAwesome6Solid.voicemail).build();
    public static final FontAwesome6IconType volcano_s = on(FontAwesome6Solid.volcano).build();
    public static final FontAwesome6IconType volleyball_s = on(FontAwesome6Solid.volleyball).build();
    public static final FontAwesome6IconType volume_high_s = on(FontAwesome6Solid.volume_high).build();
    public static final FontAwesome6IconType volume_low_s = on(FontAwesome6Solid.volume_low).build();
    public static final FontAwesome6IconType volume_off_s = on(FontAwesome6Solid.volume_off).build();
    public static final FontAwesome6IconType volume_xmark_s = on(FontAwesome6Solid.volume_xmark).build();
    public static final FontAwesome6IconType vr_cardboard_s = on(FontAwesome6Solid.vr_cardboard).build();
    public static final FontAwesome6IconType w_s = on(FontAwesome6Solid.w).build();
    public static final FontAwesome6IconType walkie_talkie_s = on(FontAwesome6Solid.walkie_talkie).build();
    public static final FontAwesome6IconType wallet_s = on(FontAwesome6Solid.wallet).build();
    public static final FontAwesome6IconType wand_magic_s = on(FontAwesome6Solid.wand_magic).build();
    public static final FontAwesome6IconType wand_magic_sparkles_s = on(FontAwesome6Solid.wand_magic_sparkles).build();
    public static final FontAwesome6IconType wand_sparkles_s = on(FontAwesome6Solid.wand_sparkles).build();
    public static final FontAwesome6IconType warehouse_s = on(FontAwesome6Solid.warehouse).build();
    public static final FontAwesome6IconType water_ladder_s = on(FontAwesome6Solid.water_ladder).build();
    public static final FontAwesome6IconType water_s = on(FontAwesome6Solid.water).build();
    public static final FontAwesome6IconType wave_square_s = on(FontAwesome6Solid.wave_square).build();
    public static final FontAwesome6IconType web_awesome_s = on(FontAwesome6Solid.web_awesome).build();
    public static final FontAwesome6IconType weight_hanging_s = on(FontAwesome6Solid.weight_hanging).build();
    public static final FontAwesome6IconType weight_scale_s = on(FontAwesome6Solid.weight_scale).build();
    public static final FontAwesome6IconType wheat_awn_circle_exclamation_s = on(FontAwesome6Solid.wheat_awn_circle_exclamation).build();
    public static final FontAwesome6IconType wheat_awn_s = on(FontAwesome6Solid.wheat_awn).build();
    public static final FontAwesome6IconType wheelchair_move_s = on(FontAwesome6Solid.wheelchair_move).build();
    public static final FontAwesome6IconType wheelchair_s = on(FontAwesome6Solid.wheelchair).build();
    public static final FontAwesome6IconType whiskey_glass_s = on(FontAwesome6Solid.whiskey_glass).build();
    public static final FontAwesome6IconType wifi_s = on(FontAwesome6Solid.wifi).build();
    public static final FontAwesome6IconType wind_s = on(FontAwesome6Solid.wind).build();
    public static final FontAwesome6IconType window_maximize_r = on(FontAwesome6Regular.window_maximize).build();
    public static final FontAwesome6IconType window_maximize_s = on(FontAwesome6Solid.window_maximize).build();
    public static final FontAwesome6IconType window_minimize_r = on(FontAwesome6Regular.window_minimize).build();
    public static final FontAwesome6IconType window_minimize_s = on(FontAwesome6Solid.window_minimize).build();
    public static final FontAwesome6IconType window_restore_r = on(FontAwesome6Regular.window_restore).build();
    public static final FontAwesome6IconType window_restore_s = on(FontAwesome6Solid.window_restore).build();
    public static final FontAwesome6IconType wine_bottle_s = on(FontAwesome6Solid.wine_bottle).build();
    public static final FontAwesome6IconType wine_glass_empty_s = on(FontAwesome6Solid.wine_glass_empty).build();
    public static final FontAwesome6IconType wine_glass_s = on(FontAwesome6Solid.wine_glass).build();
    public static final FontAwesome6IconType won_sign_s = on(FontAwesome6Solid.won_sign).build();
    public static final FontAwesome6IconType worm_s = on(FontAwesome6Solid.worm).build();
    public static final FontAwesome6IconType wrench_s = on(FontAwesome6Solid.wrench).build();
    public static final FontAwesome6IconType x_ray_s = on(FontAwesome6Solid.x_ray).build();
    public static final FontAwesome6IconType x_s = on(FontAwesome6Solid.x).build();
    public static final FontAwesome6IconType xmark_s = on(FontAwesome6Solid.xmark).build();
    public static final FontAwesome6IconType xmarks_lines_s = on(FontAwesome6Solid.xmarks_lines).build();
    public static final FontAwesome6IconType y_s = on(FontAwesome6Solid.y).build();
    public static final FontAwesome6IconType yen_sign_s = on(FontAwesome6Solid.yen_sign).build();
    public static final FontAwesome6IconType yin_yang_s = on(FontAwesome6Solid.yin_yang).build();
    public static final FontAwesome6IconType z_s = on(FontAwesome6Solid.z).build();

    // icon types of style 'brand'
    public static final FontAwesome6IconType _42_group = on(FontAwesome6Brand._42_group).build();
    public static final FontAwesome6IconType _500px = on(FontAwesome6Brand._500px).build();
    public static final FontAwesome6IconType accessible_icon = on(FontAwesome6Brand.accessible_icon).build();
    public static final FontAwesome6IconType accusoft = on(FontAwesome6Brand.accusoft).build();
    public static final FontAwesome6IconType adn = on(FontAwesome6Brand.adn).build();
    public static final FontAwesome6IconType adversal = on(FontAwesome6Brand.adversal).build();
    public static final FontAwesome6IconType affiliatetheme = on(FontAwesome6Brand.affiliatetheme).build();
    public static final FontAwesome6IconType airbnb = on(FontAwesome6Brand.airbnb).build();
    public static final FontAwesome6IconType algolia = on(FontAwesome6Brand.algolia).build();
    public static final FontAwesome6IconType alipay = on(FontAwesome6Brand.alipay).build();
    public static final FontAwesome6IconType amazon = on(FontAwesome6Brand.amazon).build();
    public static final FontAwesome6IconType amazon_pay = on(FontAwesome6Brand.amazon_pay).build();
    public static final FontAwesome6IconType amilia = on(FontAwesome6Brand.amilia).build();
    public static final FontAwesome6IconType android = on(FontAwesome6Brand.android).build();
    public static final FontAwesome6IconType angellist = on(FontAwesome6Brand.angellist).build();
    public static final FontAwesome6IconType angrycreative = on(FontAwesome6Brand.angrycreative).build();
    public static final FontAwesome6IconType angular = on(FontAwesome6Brand.angular).build();
    public static final FontAwesome6IconType app_store = on(FontAwesome6Brand.app_store).build();
    public static final FontAwesome6IconType app_store_ios = on(FontAwesome6Brand.app_store_ios).build();
    public static final FontAwesome6IconType apper = on(FontAwesome6Brand.apper).build();
    public static final FontAwesome6IconType apple = on(FontAwesome6Brand.apple).build();
    public static final FontAwesome6IconType apple_pay = on(FontAwesome6Brand.apple_pay).build();
    public static final FontAwesome6IconType artstation = on(FontAwesome6Brand.artstation).build();
    public static final FontAwesome6IconType asymmetrik = on(FontAwesome6Brand.asymmetrik).build();
    public static final FontAwesome6IconType atlassian = on(FontAwesome6Brand.atlassian).build();
    public static final FontAwesome6IconType audible = on(FontAwesome6Brand.audible).build();
    public static final FontAwesome6IconType autoprefixer = on(FontAwesome6Brand.autoprefixer).build();
    public static final FontAwesome6IconType avianex = on(FontAwesome6Brand.avianex).build();
    public static final FontAwesome6IconType aviato = on(FontAwesome6Brand.aviato).build();
    public static final FontAwesome6IconType aws = on(FontAwesome6Brand.aws).build();
    public static final FontAwesome6IconType bandcamp = on(FontAwesome6Brand.bandcamp).build();
    public static final FontAwesome6IconType battle_net = on(FontAwesome6Brand.battle_net).build();
    public static final FontAwesome6IconType behance = on(FontAwesome6Brand.behance).build();
    public static final FontAwesome6IconType bilibili = on(FontAwesome6Brand.bilibili).build();
    public static final FontAwesome6IconType bimobject = on(FontAwesome6Brand.bimobject).build();
    public static final FontAwesome6IconType bitbucket = on(FontAwesome6Brand.bitbucket).build();
    public static final FontAwesome6IconType bitcoin = on(FontAwesome6Brand.bitcoin).build();
    public static final FontAwesome6IconType bity = on(FontAwesome6Brand.bity).build();
    public static final FontAwesome6IconType black_tie = on(FontAwesome6Brand.black_tie).build();
    public static final FontAwesome6IconType blackberry = on(FontAwesome6Brand.blackberry).build();
    public static final FontAwesome6IconType blogger = on(FontAwesome6Brand.blogger).build();
    public static final FontAwesome6IconType blogger_b = on(FontAwesome6Brand.blogger_b).build();
    public static final FontAwesome6IconType bluesky = on(FontAwesome6Brand.bluesky).build();
    public static final FontAwesome6IconType bluetooth = on(FontAwesome6Brand.bluetooth).build();
    public static final FontAwesome6IconType bluetooth_b = on(FontAwesome6Brand.bluetooth_b).build();
    public static final FontAwesome6IconType bootstrap = on(FontAwesome6Brand.bootstrap).build();
    public static final FontAwesome6IconType bots = on(FontAwesome6Brand.bots).build();
    public static final FontAwesome6IconType brave = on(FontAwesome6Brand.brave).build();
    public static final FontAwesome6IconType brave_reverse = on(FontAwesome6Brand.brave_reverse).build();
    public static final FontAwesome6IconType btc = on(FontAwesome6Brand.btc).build();
    public static final FontAwesome6IconType buffer = on(FontAwesome6Brand.buffer).build();
    public static final FontAwesome6IconType buromobelexperte = on(FontAwesome6Brand.buromobelexperte).build();
    public static final FontAwesome6IconType buy_n_large = on(FontAwesome6Brand.buy_n_large).build();
    public static final FontAwesome6IconType buysellads = on(FontAwesome6Brand.buysellads).build();
    public static final FontAwesome6IconType canadian_maple_leaf = on(FontAwesome6Brand.canadian_maple_leaf).build();
    public static final FontAwesome6IconType cc_amazon_pay = on(FontAwesome6Brand.cc_amazon_pay).build();
    public static final FontAwesome6IconType cc_amex = on(FontAwesome6Brand.cc_amex).build();
    public static final FontAwesome6IconType cc_apple_pay = on(FontAwesome6Brand.cc_apple_pay).build();
    public static final FontAwesome6IconType cc_diners_club = on(FontAwesome6Brand.cc_diners_club).build();
    public static final FontAwesome6IconType cc_discover = on(FontAwesome6Brand.cc_discover).build();
    public static final FontAwesome6IconType cc_jcb = on(FontAwesome6Brand.cc_jcb).build();
    public static final FontAwesome6IconType cc_mastercard = on(FontAwesome6Brand.cc_mastercard).build();
    public static final FontAwesome6IconType cc_paypal = on(FontAwesome6Brand.cc_paypal).build();
    public static final FontAwesome6IconType cc_stripe = on(FontAwesome6Brand.cc_stripe).build();
    public static final FontAwesome6IconType cc_visa = on(FontAwesome6Brand.cc_visa).build();
    public static final FontAwesome6IconType centercode = on(FontAwesome6Brand.centercode).build();
    public static final FontAwesome6IconType centos = on(FontAwesome6Brand.centos).build();
    public static final FontAwesome6IconType chrome = on(FontAwesome6Brand.chrome).build();
    public static final FontAwesome6IconType chromecast = on(FontAwesome6Brand.chromecast).build();
    public static final FontAwesome6IconType cloudflare = on(FontAwesome6Brand.cloudflare).build();
    public static final FontAwesome6IconType cloudscale = on(FontAwesome6Brand.cloudscale).build();
    public static final FontAwesome6IconType cloudsmith = on(FontAwesome6Brand.cloudsmith).build();
    public static final FontAwesome6IconType cloudversify = on(FontAwesome6Brand.cloudversify).build();
    public static final FontAwesome6IconType cmplid = on(FontAwesome6Brand.cmplid).build();
    public static final FontAwesome6IconType codepen = on(FontAwesome6Brand.codepen).build();
    public static final FontAwesome6IconType codiepie = on(FontAwesome6Brand.codiepie).build();
    public static final FontAwesome6IconType confluence = on(FontAwesome6Brand.confluence).build();
    public static final FontAwesome6IconType connectdevelop = on(FontAwesome6Brand.connectdevelop).build();
    public static final FontAwesome6IconType contao = on(FontAwesome6Brand.contao).build();
    public static final FontAwesome6IconType cotton_bureau = on(FontAwesome6Brand.cotton_bureau).build();
    public static final FontAwesome6IconType cpanel = on(FontAwesome6Brand.cpanel).build();
    public static final FontAwesome6IconType creative_commons = on(FontAwesome6Brand.creative_commons).build();
    public static final FontAwesome6IconType creative_commons_by = on(FontAwesome6Brand.creative_commons_by).build();
    public static final FontAwesome6IconType creative_commons_nc = on(FontAwesome6Brand.creative_commons_nc).build();
    public static final FontAwesome6IconType creative_commons_nc_eu = on(FontAwesome6Brand.creative_commons_nc_eu).build();
    public static final FontAwesome6IconType creative_commons_nc_jp = on(FontAwesome6Brand.creative_commons_nc_jp).build();
    public static final FontAwesome6IconType creative_commons_nd = on(FontAwesome6Brand.creative_commons_nd).build();
    public static final FontAwesome6IconType creative_commons_pd = on(FontAwesome6Brand.creative_commons_pd).build();
    public static final FontAwesome6IconType creative_commons_pd_alt = on(FontAwesome6Brand.creative_commons_pd_alt).build();
    public static final FontAwesome6IconType creative_commons_remix = on(FontAwesome6Brand.creative_commons_remix).build();
    public static final FontAwesome6IconType creative_commons_sa = on(FontAwesome6Brand.creative_commons_sa).build();
    public static final FontAwesome6IconType creative_commons_sampling = on(FontAwesome6Brand.creative_commons_sampling).build();
    public static final FontAwesome6IconType creative_commons_sampling_plus = on(FontAwesome6Brand.creative_commons_sampling_plus).build();
    public static final FontAwesome6IconType creative_commons_share = on(FontAwesome6Brand.creative_commons_share).build();
    public static final FontAwesome6IconType creative_commons_zero = on(FontAwesome6Brand.creative_commons_zero).build();
    public static final FontAwesome6IconType critical_role = on(FontAwesome6Brand.critical_role).build();
    public static final FontAwesome6IconType css = on(FontAwesome6Brand.css).build();
    public static final FontAwesome6IconType css3 = on(FontAwesome6Brand.css3).build();
    public static final FontAwesome6IconType css3_alt = on(FontAwesome6Brand.css3_alt).build();
    public static final FontAwesome6IconType cuttlefish = on(FontAwesome6Brand.cuttlefish).build();
    public static final FontAwesome6IconType d_and_d = on(FontAwesome6Brand.d_and_d).build();
    public static final FontAwesome6IconType d_and_d_beyond = on(FontAwesome6Brand.d_and_d_beyond).build();
    public static final FontAwesome6IconType dailymotion = on(FontAwesome6Brand.dailymotion).build();
    public static final FontAwesome6IconType dart_lang = on(FontAwesome6Brand.dart_lang).build();
    public static final FontAwesome6IconType dashcube = on(FontAwesome6Brand.dashcube).build();
    public static final FontAwesome6IconType debian = on(FontAwesome6Brand.debian).build();
    public static final FontAwesome6IconType deezer = on(FontAwesome6Brand.deezer).build();
    public static final FontAwesome6IconType delicious = on(FontAwesome6Brand.delicious).build();
    public static final FontAwesome6IconType deploydog = on(FontAwesome6Brand.deploydog).build();
    public static final FontAwesome6IconType deskpro = on(FontAwesome6Brand.deskpro).build();
    public static final FontAwesome6IconType dev = on(FontAwesome6Brand.dev).build();
    public static final FontAwesome6IconType deviantart = on(FontAwesome6Brand.deviantart).build();
    public static final FontAwesome6IconType dhl = on(FontAwesome6Brand.dhl).build();
    public static final FontAwesome6IconType diaspora = on(FontAwesome6Brand.diaspora).build();
    public static final FontAwesome6IconType digg = on(FontAwesome6Brand.digg).build();
    public static final FontAwesome6IconType digital_ocean = on(FontAwesome6Brand.digital_ocean).build();
    public static final FontAwesome6IconType discord = on(FontAwesome6Brand.discord).build();
    public static final FontAwesome6IconType discourse = on(FontAwesome6Brand.discourse).build();
    public static final FontAwesome6IconType dochub = on(FontAwesome6Brand.dochub).build();
    public static final FontAwesome6IconType docker = on(FontAwesome6Brand.docker).build();
    public static final FontAwesome6IconType draft2digital = on(FontAwesome6Brand.draft2digital).build();
    public static final FontAwesome6IconType dribbble = on(FontAwesome6Brand.dribbble).build();
    public static final FontAwesome6IconType dropbox = on(FontAwesome6Brand.dropbox).build();
    public static final FontAwesome6IconType drupal = on(FontAwesome6Brand.drupal).build();
    public static final FontAwesome6IconType dyalog = on(FontAwesome6Brand.dyalog).build();
    public static final FontAwesome6IconType earlybirds = on(FontAwesome6Brand.earlybirds).build();
    public static final FontAwesome6IconType ebay = on(FontAwesome6Brand.ebay).build();
    public static final FontAwesome6IconType edge = on(FontAwesome6Brand.edge).build();
    public static final FontAwesome6IconType edge_legacy = on(FontAwesome6Brand.edge_legacy).build();
    public static final FontAwesome6IconType elementor = on(FontAwesome6Brand.elementor).build();
    public static final FontAwesome6IconType ello = on(FontAwesome6Brand.ello).build();
    public static final FontAwesome6IconType ember = on(FontAwesome6Brand.ember).build();
    public static final FontAwesome6IconType empire = on(FontAwesome6Brand.empire).build();
    public static final FontAwesome6IconType envira = on(FontAwesome6Brand.envira).build();
    public static final FontAwesome6IconType erlang = on(FontAwesome6Brand.erlang).build();
    public static final FontAwesome6IconType ethereum = on(FontAwesome6Brand.ethereum).build();
    public static final FontAwesome6IconType etsy = on(FontAwesome6Brand.etsy).build();
    public static final FontAwesome6IconType evernote = on(FontAwesome6Brand.evernote).build();
    public static final FontAwesome6IconType expeditedssl = on(FontAwesome6Brand.expeditedssl).build();
    public static final FontAwesome6IconType facebook = on(FontAwesome6Brand.facebook).build();
    public static final FontAwesome6IconType facebook_f = on(FontAwesome6Brand.facebook_f).build();
    public static final FontAwesome6IconType facebook_messenger = on(FontAwesome6Brand.facebook_messenger).build();
    public static final FontAwesome6IconType fantasy_flight_games = on(FontAwesome6Brand.fantasy_flight_games).build();
    public static final FontAwesome6IconType fedex = on(FontAwesome6Brand.fedex).build();
    public static final FontAwesome6IconType fedora = on(FontAwesome6Brand.fedora).build();
    public static final FontAwesome6IconType figma = on(FontAwesome6Brand.figma).build();
    public static final FontAwesome6IconType files_pinwheel = on(FontAwesome6Brand.files_pinwheel).build();
    public static final FontAwesome6IconType firefox = on(FontAwesome6Brand.firefox).build();
    public static final FontAwesome6IconType firefox_browser = on(FontAwesome6Brand.firefox_browser).build();
    public static final FontAwesome6IconType first_order = on(FontAwesome6Brand.first_order).build();
    public static final FontAwesome6IconType first_order_alt = on(FontAwesome6Brand.first_order_alt).build();
    public static final FontAwesome6IconType firstdraft = on(FontAwesome6Brand.firstdraft).build();
    public static final FontAwesome6IconType flickr = on(FontAwesome6Brand.flickr).build();
    public static final FontAwesome6IconType flipboard = on(FontAwesome6Brand.flipboard).build();
    public static final FontAwesome6IconType flutter = on(FontAwesome6Brand.flutter).build();
    public static final FontAwesome6IconType fly = on(FontAwesome6Brand.fly).build();
    public static final FontAwesome6IconType font_awesome = on(FontAwesome6Brand.font_awesome).build();
    public static final FontAwesome6IconType fonticons = on(FontAwesome6Brand.fonticons).build();
    public static final FontAwesome6IconType fonticons_fi = on(FontAwesome6Brand.fonticons_fi).build();
    public static final FontAwesome6IconType fort_awesome = on(FontAwesome6Brand.fort_awesome).build();
    public static final FontAwesome6IconType fort_awesome_alt = on(FontAwesome6Brand.fort_awesome_alt).build();
    public static final FontAwesome6IconType forumbee = on(FontAwesome6Brand.forumbee).build();
    public static final FontAwesome6IconType foursquare = on(FontAwesome6Brand.foursquare).build();
    public static final FontAwesome6IconType free_code_camp = on(FontAwesome6Brand.free_code_camp).build();
    public static final FontAwesome6IconType freebsd = on(FontAwesome6Brand.freebsd).build();
    public static final FontAwesome6IconType fulcrum = on(FontAwesome6Brand.fulcrum).build();
    public static final FontAwesome6IconType galactic_republic = on(FontAwesome6Brand.galactic_republic).build();
    public static final FontAwesome6IconType galactic_senate = on(FontAwesome6Brand.galactic_senate).build();
    public static final FontAwesome6IconType get_pocket = on(FontAwesome6Brand.get_pocket).build();
    public static final FontAwesome6IconType gg = on(FontAwesome6Brand.gg).build();
    public static final FontAwesome6IconType gg_circle = on(FontAwesome6Brand.gg_circle).build();
    public static final FontAwesome6IconType git = on(FontAwesome6Brand.git).build();
    public static final FontAwesome6IconType git_alt = on(FontAwesome6Brand.git_alt).build();
    public static final FontAwesome6IconType github = on(FontAwesome6Brand.github).build();
    public static final FontAwesome6IconType github_alt = on(FontAwesome6Brand.github_alt).build();
    public static final FontAwesome6IconType gitkraken = on(FontAwesome6Brand.gitkraken).build();
    public static final FontAwesome6IconType gitlab = on(FontAwesome6Brand.gitlab).build();
    public static final FontAwesome6IconType gitter = on(FontAwesome6Brand.gitter).build();
    public static final FontAwesome6IconType glide = on(FontAwesome6Brand.glide).build();
    public static final FontAwesome6IconType glide_g = on(FontAwesome6Brand.glide_g).build();
    public static final FontAwesome6IconType gofore = on(FontAwesome6Brand.gofore).build();
    public static final FontAwesome6IconType golang = on(FontAwesome6Brand.golang).build();
    public static final FontAwesome6IconType goodreads = on(FontAwesome6Brand.goodreads).build();
    public static final FontAwesome6IconType goodreads_g = on(FontAwesome6Brand.goodreads_g).build();
    public static final FontAwesome6IconType google = on(FontAwesome6Brand.google).build();
    public static final FontAwesome6IconType google_drive = on(FontAwesome6Brand.google_drive).build();
    public static final FontAwesome6IconType google_pay = on(FontAwesome6Brand.google_pay).build();
    public static final FontAwesome6IconType google_play = on(FontAwesome6Brand.google_play).build();
    public static final FontAwesome6IconType google_plus = on(FontAwesome6Brand.google_plus).build();
    public static final FontAwesome6IconType google_plus_g = on(FontAwesome6Brand.google_plus_g).build();
    public static final FontAwesome6IconType google_scholar = on(FontAwesome6Brand.google_scholar).build();
    public static final FontAwesome6IconType google_wallet = on(FontAwesome6Brand.google_wallet).build();
    public static final FontAwesome6IconType gratipay = on(FontAwesome6Brand.gratipay).build();
    public static final FontAwesome6IconType grav = on(FontAwesome6Brand.grav).build();
    public static final FontAwesome6IconType gripfire = on(FontAwesome6Brand.gripfire).build();
    public static final FontAwesome6IconType grunt = on(FontAwesome6Brand.grunt).build();
    public static final FontAwesome6IconType guilded = on(FontAwesome6Brand.guilded).build();
    public static final FontAwesome6IconType gulp = on(FontAwesome6Brand.gulp).build();
    public static final FontAwesome6IconType hacker_news = on(FontAwesome6Brand.hacker_news).build();
    public static final FontAwesome6IconType hackerrank = on(FontAwesome6Brand.hackerrank).build();
    public static final FontAwesome6IconType hashnode = on(FontAwesome6Brand.hashnode).build();
    public static final FontAwesome6IconType hips = on(FontAwesome6Brand.hips).build();
    public static final FontAwesome6IconType hire_a_helper = on(FontAwesome6Brand.hire_a_helper).build();
    public static final FontAwesome6IconType hive = on(FontAwesome6Brand.hive).build();
    public static final FontAwesome6IconType hooli = on(FontAwesome6Brand.hooli).build();
    public static final FontAwesome6IconType hornbill = on(FontAwesome6Brand.hornbill).build();
    public static final FontAwesome6IconType hotjar = on(FontAwesome6Brand.hotjar).build();
    public static final FontAwesome6IconType houzz = on(FontAwesome6Brand.houzz).build();
    public static final FontAwesome6IconType html5 = on(FontAwesome6Brand.html5).build();
    public static final FontAwesome6IconType hubspot = on(FontAwesome6Brand.hubspot).build();
    public static final FontAwesome6IconType ideal = on(FontAwesome6Brand.ideal).build();
    public static final FontAwesome6IconType imdb = on(FontAwesome6Brand.imdb).build();
    public static final FontAwesome6IconType instagram = on(FontAwesome6Brand.instagram).build();
    public static final FontAwesome6IconType instalod = on(FontAwesome6Brand.instalod).build();
    public static final FontAwesome6IconType intercom = on(FontAwesome6Brand.intercom).build();
    public static final FontAwesome6IconType internet_explorer = on(FontAwesome6Brand.internet_explorer).build();
    public static final FontAwesome6IconType invision = on(FontAwesome6Brand.invision).build();
    public static final FontAwesome6IconType ioxhost = on(FontAwesome6Brand.ioxhost).build();
    public static final FontAwesome6IconType itch_io = on(FontAwesome6Brand.itch_io).build();
    public static final FontAwesome6IconType itunes = on(FontAwesome6Brand.itunes).build();
    public static final FontAwesome6IconType itunes_note = on(FontAwesome6Brand.itunes_note).build();
    public static final FontAwesome6IconType java = on(FontAwesome6Brand.java).build();
    public static final FontAwesome6IconType jedi_order = on(FontAwesome6Brand.jedi_order).build();
    public static final FontAwesome6IconType jenkins = on(FontAwesome6Brand.jenkins).build();
    public static final FontAwesome6IconType jira = on(FontAwesome6Brand.jira).build();
    public static final FontAwesome6IconType joget = on(FontAwesome6Brand.joget).build();
    public static final FontAwesome6IconType joomla = on(FontAwesome6Brand.joomla).build();
    public static final FontAwesome6IconType js = on(FontAwesome6Brand.js).build();
    public static final FontAwesome6IconType jsfiddle = on(FontAwesome6Brand.jsfiddle).build();
    public static final FontAwesome6IconType jxl = on(FontAwesome6Brand.jxl).build();
    public static final FontAwesome6IconType kaggle = on(FontAwesome6Brand.kaggle).build();
    public static final FontAwesome6IconType keybase = on(FontAwesome6Brand.keybase).build();
    public static final FontAwesome6IconType keycdn = on(FontAwesome6Brand.keycdn).build();
    public static final FontAwesome6IconType kickstarter = on(FontAwesome6Brand.kickstarter).build();
    public static final FontAwesome6IconType kickstarter_k = on(FontAwesome6Brand.kickstarter_k).build();
    public static final FontAwesome6IconType korvue = on(FontAwesome6Brand.korvue).build();
    public static final FontAwesome6IconType laravel = on(FontAwesome6Brand.laravel).build();
    public static final FontAwesome6IconType lastfm = on(FontAwesome6Brand.lastfm).build();
    public static final FontAwesome6IconType leanpub = on(FontAwesome6Brand.leanpub).build();
    public static final FontAwesome6IconType less = on(FontAwesome6Brand.less).build();
    public static final FontAwesome6IconType letterboxd = on(FontAwesome6Brand.letterboxd).build();
    public static final FontAwesome6IconType line = on(FontAwesome6Brand.line).build();
    public static final FontAwesome6IconType linkedin = on(FontAwesome6Brand.linkedin).build();
    public static final FontAwesome6IconType linkedin_in = on(FontAwesome6Brand.linkedin_in).build();
    public static final FontAwesome6IconType linode = on(FontAwesome6Brand.linode).build();
    public static final FontAwesome6IconType linux = on(FontAwesome6Brand.linux).build();
    public static final FontAwesome6IconType lyft = on(FontAwesome6Brand.lyft).build();
    public static final FontAwesome6IconType magento = on(FontAwesome6Brand.magento).build();
    public static final FontAwesome6IconType mailchimp = on(FontAwesome6Brand.mailchimp).build();
    public static final FontAwesome6IconType mandalorian = on(FontAwesome6Brand.mandalorian).build();
    public static final FontAwesome6IconType markdown = on(FontAwesome6Brand.markdown).build();
    public static final FontAwesome6IconType mastodon = on(FontAwesome6Brand.mastodon).build();
    public static final FontAwesome6IconType maxcdn = on(FontAwesome6Brand.maxcdn).build();
    public static final FontAwesome6IconType mdb = on(FontAwesome6Brand.mdb).build();
    public static final FontAwesome6IconType medapps = on(FontAwesome6Brand.medapps).build();
    public static final FontAwesome6IconType medium = on(FontAwesome6Brand.medium).build();
    public static final FontAwesome6IconType medrt = on(FontAwesome6Brand.medrt).build();
    public static final FontAwesome6IconType meetup = on(FontAwesome6Brand.meetup).build();
    public static final FontAwesome6IconType megaport = on(FontAwesome6Brand.megaport).build();
    public static final FontAwesome6IconType mendeley = on(FontAwesome6Brand.mendeley).build();
    public static final FontAwesome6IconType meta = on(FontAwesome6Brand.meta).build();
    public static final FontAwesome6IconType microblog = on(FontAwesome6Brand.microblog).build();
    public static final FontAwesome6IconType microsoft = on(FontAwesome6Brand.microsoft).build();
    public static final FontAwesome6IconType mintbit = on(FontAwesome6Brand.mintbit).build();
    public static final FontAwesome6IconType mix = on(FontAwesome6Brand.mix).build();
    public static final FontAwesome6IconType mixcloud = on(FontAwesome6Brand.mixcloud).build();
    public static final FontAwesome6IconType mixer = on(FontAwesome6Brand.mixer).build();
    public static final FontAwesome6IconType mizuni = on(FontAwesome6Brand.mizuni).build();
    public static final FontAwesome6IconType modx = on(FontAwesome6Brand.modx).build();
    public static final FontAwesome6IconType monero = on(FontAwesome6Brand.monero).build();
    public static final FontAwesome6IconType napster = on(FontAwesome6Brand.napster).build();
    public static final FontAwesome6IconType neos = on(FontAwesome6Brand.neos).build();
    public static final FontAwesome6IconType nfc_directional = on(FontAwesome6Brand.nfc_directional).build();
    public static final FontAwesome6IconType nfc_symbol = on(FontAwesome6Brand.nfc_symbol).build();
    public static final FontAwesome6IconType nimblr = on(FontAwesome6Brand.nimblr).build();
    public static final FontAwesome6IconType node = on(FontAwesome6Brand.node).build();
    public static final FontAwesome6IconType node_js = on(FontAwesome6Brand.node_js).build();
    public static final FontAwesome6IconType npm = on(FontAwesome6Brand.npm).build();
    public static final FontAwesome6IconType ns8 = on(FontAwesome6Brand.ns8).build();
    public static final FontAwesome6IconType nutritionix = on(FontAwesome6Brand.nutritionix).build();
    public static final FontAwesome6IconType octopus_deploy = on(FontAwesome6Brand.octopus_deploy).build();
    public static final FontAwesome6IconType odnoklassniki = on(FontAwesome6Brand.odnoklassniki).build();
    public static final FontAwesome6IconType odysee = on(FontAwesome6Brand.odysee).build();
    public static final FontAwesome6IconType old_republic = on(FontAwesome6Brand.old_republic).build();
    public static final FontAwesome6IconType opencart = on(FontAwesome6Brand.opencart).build();
    public static final FontAwesome6IconType openid = on(FontAwesome6Brand.openid).build();
    public static final FontAwesome6IconType opensuse = on(FontAwesome6Brand.opensuse).build();
    public static final FontAwesome6IconType opera = on(FontAwesome6Brand.opera).build();
    public static final FontAwesome6IconType optin_monster = on(FontAwesome6Brand.optin_monster).build();
    public static final FontAwesome6IconType orcid = on(FontAwesome6Brand.orcid).build();
    public static final FontAwesome6IconType osi = on(FontAwesome6Brand.osi).build();
    public static final FontAwesome6IconType padlet = on(FontAwesome6Brand.padlet).build();
    public static final FontAwesome6IconType page4 = on(FontAwesome6Brand.page4).build();
    public static final FontAwesome6IconType pagelines = on(FontAwesome6Brand.pagelines).build();
    public static final FontAwesome6IconType palfed = on(FontAwesome6Brand.palfed).build();
    public static final FontAwesome6IconType patreon = on(FontAwesome6Brand.patreon).build();
    public static final FontAwesome6IconType paypal = on(FontAwesome6Brand.paypal).build();
    public static final FontAwesome6IconType perbyte = on(FontAwesome6Brand.perbyte).build();
    public static final FontAwesome6IconType periscope = on(FontAwesome6Brand.periscope).build();
    public static final FontAwesome6IconType phabricator = on(FontAwesome6Brand.phabricator).build();
    public static final FontAwesome6IconType phoenix_framework = on(FontAwesome6Brand.phoenix_framework).build();
    public static final FontAwesome6IconType phoenix_squadron = on(FontAwesome6Brand.phoenix_squadron).build();
    public static final FontAwesome6IconType php = on(FontAwesome6Brand.php).build();
    public static final FontAwesome6IconType pied_piper = on(FontAwesome6Brand.pied_piper).build();
    public static final FontAwesome6IconType pied_piper_alt = on(FontAwesome6Brand.pied_piper_alt).build();
    public static final FontAwesome6IconType pied_piper_hat = on(FontAwesome6Brand.pied_piper_hat).build();
    public static final FontAwesome6IconType pied_piper_pp = on(FontAwesome6Brand.pied_piper_pp).build();
    public static final FontAwesome6IconType pinterest = on(FontAwesome6Brand.pinterest).build();
    public static final FontAwesome6IconType pinterest_p = on(FontAwesome6Brand.pinterest_p).build();
    public static final FontAwesome6IconType pix = on(FontAwesome6Brand.pix).build();
    public static final FontAwesome6IconType pixiv = on(FontAwesome6Brand.pixiv).build();
    public static final FontAwesome6IconType playstation = on(FontAwesome6Brand.playstation).build();
    public static final FontAwesome6IconType product_hunt = on(FontAwesome6Brand.product_hunt).build();
    public static final FontAwesome6IconType pushed = on(FontAwesome6Brand.pushed).build();
    public static final FontAwesome6IconType python = on(FontAwesome6Brand.python).build();
    public static final FontAwesome6IconType qq = on(FontAwesome6Brand.qq).build();
    public static final FontAwesome6IconType quinscape = on(FontAwesome6Brand.quinscape).build();
    public static final FontAwesome6IconType quora = on(FontAwesome6Brand.quora).build();
    public static final FontAwesome6IconType r_project = on(FontAwesome6Brand.r_project).build();
    public static final FontAwesome6IconType raspberry_pi = on(FontAwesome6Brand.raspberry_pi).build();
    public static final FontAwesome6IconType ravelry = on(FontAwesome6Brand.ravelry).build();
    public static final FontAwesome6IconType react = on(FontAwesome6Brand.react).build();
    public static final FontAwesome6IconType reacteurope = on(FontAwesome6Brand.reacteurope).build();
    public static final FontAwesome6IconType readme = on(FontAwesome6Brand.readme).build();
    public static final FontAwesome6IconType rebel = on(FontAwesome6Brand.rebel).build();
    public static final FontAwesome6IconType red_river = on(FontAwesome6Brand.red_river).build();
    public static final FontAwesome6IconType reddit = on(FontAwesome6Brand.reddit).build();
    public static final FontAwesome6IconType reddit_alien = on(FontAwesome6Brand.reddit_alien).build();
    public static final FontAwesome6IconType redhat = on(FontAwesome6Brand.redhat).build();
    public static final FontAwesome6IconType renren = on(FontAwesome6Brand.renren).build();
    public static final FontAwesome6IconType replyd = on(FontAwesome6Brand.replyd).build();
    public static final FontAwesome6IconType researchgate = on(FontAwesome6Brand.researchgate).build();
    public static final FontAwesome6IconType resolving = on(FontAwesome6Brand.resolving).build();
    public static final FontAwesome6IconType rev = on(FontAwesome6Brand.rev).build();
    public static final FontAwesome6IconType rocketchat = on(FontAwesome6Brand.rocketchat).build();
    public static final FontAwesome6IconType rockrms = on(FontAwesome6Brand.rockrms).build();
    public static final FontAwesome6IconType rust = on(FontAwesome6Brand.rust).build();
    public static final FontAwesome6IconType safari = on(FontAwesome6Brand.safari).build();
    public static final FontAwesome6IconType salesforce = on(FontAwesome6Brand.salesforce).build();
    public static final FontAwesome6IconType sass = on(FontAwesome6Brand.sass).build();
    public static final FontAwesome6IconType schlix = on(FontAwesome6Brand.schlix).build();
    public static final FontAwesome6IconType screenpal = on(FontAwesome6Brand.screenpal).build();
    public static final FontAwesome6IconType scribd = on(FontAwesome6Brand.scribd).build();
    public static final FontAwesome6IconType searchengin = on(FontAwesome6Brand.searchengin).build();
    public static final FontAwesome6IconType sellcast = on(FontAwesome6Brand.sellcast).build();
    public static final FontAwesome6IconType sellsy = on(FontAwesome6Brand.sellsy).build();
    public static final FontAwesome6IconType servicestack = on(FontAwesome6Brand.servicestack).build();
    public static final FontAwesome6IconType shirtsinbulk = on(FontAwesome6Brand.shirtsinbulk).build();
    public static final FontAwesome6IconType shoelace = on(FontAwesome6Brand.shoelace).build();
    public static final FontAwesome6IconType shopify = on(FontAwesome6Brand.shopify).build();
    public static final FontAwesome6IconType shopware = on(FontAwesome6Brand.shopware).build();
    public static final FontAwesome6IconType signal_messenger = on(FontAwesome6Brand.signal_messenger).build();
    public static final FontAwesome6IconType simplybuilt = on(FontAwesome6Brand.simplybuilt).build();
    public static final FontAwesome6IconType sistrix = on(FontAwesome6Brand.sistrix).build();
    public static final FontAwesome6IconType sith = on(FontAwesome6Brand.sith).build();
    public static final FontAwesome6IconType sitrox = on(FontAwesome6Brand.sitrox).build();
    public static final FontAwesome6IconType sketch = on(FontAwesome6Brand.sketch).build();
    public static final FontAwesome6IconType skyatlas = on(FontAwesome6Brand.skyatlas).build();
    public static final FontAwesome6IconType skype = on(FontAwesome6Brand.skype).build();
    public static final FontAwesome6IconType slack = on(FontAwesome6Brand.slack).build();
    public static final FontAwesome6IconType slideshare = on(FontAwesome6Brand.slideshare).build();
    public static final FontAwesome6IconType snapchat = on(FontAwesome6Brand.snapchat).build();
    public static final FontAwesome6IconType soundcloud = on(FontAwesome6Brand.soundcloud).build();
    public static final FontAwesome6IconType sourcetree = on(FontAwesome6Brand.sourcetree).build();
    public static final FontAwesome6IconType space_awesome = on(FontAwesome6Brand.space_awesome).build();
    public static final FontAwesome6IconType speakap = on(FontAwesome6Brand.speakap).build();
    public static final FontAwesome6IconType speaker_deck = on(FontAwesome6Brand.speaker_deck).build();
    public static final FontAwesome6IconType spotify = on(FontAwesome6Brand.spotify).build();
    public static final FontAwesome6IconType square_behance = on(FontAwesome6Brand.square_behance).build();
    public static final FontAwesome6IconType square_bluesky = on(FontAwesome6Brand.square_bluesky).build();
    public static final FontAwesome6IconType square_dribbble = on(FontAwesome6Brand.square_dribbble).build();
    public static final FontAwesome6IconType square_facebook = on(FontAwesome6Brand.square_facebook).build();
    public static final FontAwesome6IconType square_font_awesome = on(FontAwesome6Brand.square_font_awesome).build();
    public static final FontAwesome6IconType square_font_awesome_stroke = on(FontAwesome6Brand.square_font_awesome_stroke).build();
    public static final FontAwesome6IconType square_git = on(FontAwesome6Brand.square_git).build();
    public static final FontAwesome6IconType square_github = on(FontAwesome6Brand.square_github).build();
    public static final FontAwesome6IconType square_gitlab = on(FontAwesome6Brand.square_gitlab).build();
    public static final FontAwesome6IconType square_google_plus = on(FontAwesome6Brand.square_google_plus).build();
    public static final FontAwesome6IconType square_hacker_news = on(FontAwesome6Brand.square_hacker_news).build();
    public static final FontAwesome6IconType square_instagram = on(FontAwesome6Brand.square_instagram).build();
    public static final FontAwesome6IconType square_js = on(FontAwesome6Brand.square_js).build();
    public static final FontAwesome6IconType square_lastfm = on(FontAwesome6Brand.square_lastfm).build();
    public static final FontAwesome6IconType square_letterboxd = on(FontAwesome6Brand.square_letterboxd).build();
    public static final FontAwesome6IconType square_odnoklassniki = on(FontAwesome6Brand.square_odnoklassniki).build();
    public static final FontAwesome6IconType square_pied_piper = on(FontAwesome6Brand.square_pied_piper).build();
    public static final FontAwesome6IconType square_pinterest = on(FontAwesome6Brand.square_pinterest).build();
    public static final FontAwesome6IconType square_reddit = on(FontAwesome6Brand.square_reddit).build();
    public static final FontAwesome6IconType square_snapchat = on(FontAwesome6Brand.square_snapchat).build();
    public static final FontAwesome6IconType square_steam = on(FontAwesome6Brand.square_steam).build();
    public static final FontAwesome6IconType square_threads = on(FontAwesome6Brand.square_threads).build();
    public static final FontAwesome6IconType square_tumblr = on(FontAwesome6Brand.square_tumblr).build();
    public static final FontAwesome6IconType square_twitter = on(FontAwesome6Brand.square_twitter).build();
    public static final FontAwesome6IconType square_upwork = on(FontAwesome6Brand.square_upwork).build();
    public static final FontAwesome6IconType square_viadeo = on(FontAwesome6Brand.square_viadeo).build();
    public static final FontAwesome6IconType square_vimeo = on(FontAwesome6Brand.square_vimeo).build();
    public static final FontAwesome6IconType square_web_awesome = on(FontAwesome6Brand.square_web_awesome).build();
    public static final FontAwesome6IconType square_web_awesome_stroke = on(FontAwesome6Brand.square_web_awesome_stroke).build();
    public static final FontAwesome6IconType square_whatsapp = on(FontAwesome6Brand.square_whatsapp).build();
    public static final FontAwesome6IconType square_x_twitter = on(FontAwesome6Brand.square_x_twitter).build();
    public static final FontAwesome6IconType square_xing = on(FontAwesome6Brand.square_xing).build();
    public static final FontAwesome6IconType square_youtube = on(FontAwesome6Brand.square_youtube).build();
    public static final FontAwesome6IconType squarespace = on(FontAwesome6Brand.squarespace).build();
    public static final FontAwesome6IconType stack_exchange = on(FontAwesome6Brand.stack_exchange).build();
    public static final FontAwesome6IconType stack_overflow = on(FontAwesome6Brand.stack_overflow).build();
    public static final FontAwesome6IconType stackpath = on(FontAwesome6Brand.stackpath).build();
    public static final FontAwesome6IconType staylinked = on(FontAwesome6Brand.staylinked).build();
    public static final FontAwesome6IconType steam = on(FontAwesome6Brand.steam).build();
    public static final FontAwesome6IconType steam_symbol = on(FontAwesome6Brand.steam_symbol).build();
    public static final FontAwesome6IconType sticker_mule = on(FontAwesome6Brand.sticker_mule).build();
    public static final FontAwesome6IconType strava = on(FontAwesome6Brand.strava).build();
    public static final FontAwesome6IconType stripe = on(FontAwesome6Brand.stripe).build();
    public static final FontAwesome6IconType stripe_s = on(FontAwesome6Brand.stripe_s).build();
    public static final FontAwesome6IconType stubber = on(FontAwesome6Brand.stubber).build();
    public static final FontAwesome6IconType studiovinari = on(FontAwesome6Brand.studiovinari).build();
    public static final FontAwesome6IconType stumbleupon = on(FontAwesome6Brand.stumbleupon).build();
    public static final FontAwesome6IconType stumbleupon_circle = on(FontAwesome6Brand.stumbleupon_circle).build();
    public static final FontAwesome6IconType superpowers = on(FontAwesome6Brand.superpowers).build();
    public static final FontAwesome6IconType supple = on(FontAwesome6Brand.supple).build();
    public static final FontAwesome6IconType suse = on(FontAwesome6Brand.suse).build();
    public static final FontAwesome6IconType swift = on(FontAwesome6Brand.swift).build();
    public static final FontAwesome6IconType symfony = on(FontAwesome6Brand.symfony).build();
    public static final FontAwesome6IconType teamspeak = on(FontAwesome6Brand.teamspeak).build();
    public static final FontAwesome6IconType telegram = on(FontAwesome6Brand.telegram).build();
    public static final FontAwesome6IconType tencent_weibo = on(FontAwesome6Brand.tencent_weibo).build();
    public static final FontAwesome6IconType the_red_yeti = on(FontAwesome6Brand.the_red_yeti).build();
    public static final FontAwesome6IconType themeco = on(FontAwesome6Brand.themeco).build();
    public static final FontAwesome6IconType themeisle = on(FontAwesome6Brand.themeisle).build();
    public static final FontAwesome6IconType think_peaks = on(FontAwesome6Brand.think_peaks).build();
    public static final FontAwesome6IconType threads = on(FontAwesome6Brand.threads).build();
    public static final FontAwesome6IconType tiktok = on(FontAwesome6Brand.tiktok).build();
    public static final FontAwesome6IconType trade_federation = on(FontAwesome6Brand.trade_federation).build();
    public static final FontAwesome6IconType trello = on(FontAwesome6Brand.trello).build();
    public static final FontAwesome6IconType tumblr = on(FontAwesome6Brand.tumblr).build();
    public static final FontAwesome6IconType twitch = on(FontAwesome6Brand.twitch).build();
    public static final FontAwesome6IconType twitter = on(FontAwesome6Brand.twitter).build();
    public static final FontAwesome6IconType typo3 = on(FontAwesome6Brand.typo3).build();
    public static final FontAwesome6IconType uber = on(FontAwesome6Brand.uber).build();
    public static final FontAwesome6IconType ubuntu = on(FontAwesome6Brand.ubuntu).build();
    public static final FontAwesome6IconType uikit = on(FontAwesome6Brand.uikit).build();
    public static final FontAwesome6IconType umbraco = on(FontAwesome6Brand.umbraco).build();
    public static final FontAwesome6IconType uncharted = on(FontAwesome6Brand.uncharted).build();
    public static final FontAwesome6IconType uniregistry = on(FontAwesome6Brand.uniregistry).build();
    public static final FontAwesome6IconType unity = on(FontAwesome6Brand.unity).build();
    public static final FontAwesome6IconType unsplash = on(FontAwesome6Brand.unsplash).build();
    public static final FontAwesome6IconType untappd = on(FontAwesome6Brand.untappd).build();
    public static final FontAwesome6IconType ups = on(FontAwesome6Brand.ups).build();
    public static final FontAwesome6IconType upwork = on(FontAwesome6Brand.upwork).build();
    public static final FontAwesome6IconType usb = on(FontAwesome6Brand.usb).build();
    public static final FontAwesome6IconType usps = on(FontAwesome6Brand.usps).build();
    public static final FontAwesome6IconType ussunnah = on(FontAwesome6Brand.ussunnah).build();
    public static final FontAwesome6IconType vaadin = on(FontAwesome6Brand.vaadin).build();
    public static final FontAwesome6IconType viacoin = on(FontAwesome6Brand.viacoin).build();
    public static final FontAwesome6IconType viadeo = on(FontAwesome6Brand.viadeo).build();
    public static final FontAwesome6IconType viber = on(FontAwesome6Brand.viber).build();
    public static final FontAwesome6IconType vimeo = on(FontAwesome6Brand.vimeo).build();
    public static final FontAwesome6IconType vimeo_v = on(FontAwesome6Brand.vimeo_v).build();
    public static final FontAwesome6IconType vine = on(FontAwesome6Brand.vine).build();
    public static final FontAwesome6IconType vk = on(FontAwesome6Brand.vk).build();
    public static final FontAwesome6IconType vnv = on(FontAwesome6Brand.vnv).build();
    public static final FontAwesome6IconType vuejs = on(FontAwesome6Brand.vuejs).build();
    public static final FontAwesome6IconType watchman_monitoring = on(FontAwesome6Brand.watchman_monitoring).build();
    public static final FontAwesome6IconType waze = on(FontAwesome6Brand.waze).build();
    public static final FontAwesome6IconType web_awesome = on(FontAwesome6Brand.web_awesome).build();
    public static final FontAwesome6IconType webflow = on(FontAwesome6Brand.webflow).build();
    public static final FontAwesome6IconType weebly = on(FontAwesome6Brand.weebly).build();
    public static final FontAwesome6IconType weibo = on(FontAwesome6Brand.weibo).build();
    public static final FontAwesome6IconType weixin = on(FontAwesome6Brand.weixin).build();
    public static final FontAwesome6IconType whatsapp = on(FontAwesome6Brand.whatsapp).build();
    public static final FontAwesome6IconType whmcs = on(FontAwesome6Brand.whmcs).build();
    public static final FontAwesome6IconType wikipedia_w = on(FontAwesome6Brand.wikipedia_w).build();
    public static final FontAwesome6IconType windows = on(FontAwesome6Brand.windows).build();
    public static final FontAwesome6IconType wirsindhandwerk = on(FontAwesome6Brand.wirsindhandwerk).build();
    public static final FontAwesome6IconType wix = on(FontAwesome6Brand.wix).build();
    public static final FontAwesome6IconType wizards_of_the_coast = on(FontAwesome6Brand.wizards_of_the_coast).build();
    public static final FontAwesome6IconType wodu = on(FontAwesome6Brand.wodu).build();
    public static final FontAwesome6IconType wolf_pack_battalion = on(FontAwesome6Brand.wolf_pack_battalion).build();
    public static final FontAwesome6IconType wordpress = on(FontAwesome6Brand.wordpress).build();
    public static final FontAwesome6IconType wordpress_simple = on(FontAwesome6Brand.wordpress_simple).build();
    public static final FontAwesome6IconType wpbeginner = on(FontAwesome6Brand.wpbeginner).build();
    public static final FontAwesome6IconType wpexplorer = on(FontAwesome6Brand.wpexplorer).build();
    public static final FontAwesome6IconType wpforms = on(FontAwesome6Brand.wpforms).build();
    public static final FontAwesome6IconType wpressr = on(FontAwesome6Brand.wpressr).build();
    public static final FontAwesome6IconType x_twitter = on(FontAwesome6Brand.x_twitter).build();
    public static final FontAwesome6IconType xbox = on(FontAwesome6Brand.xbox).build();
    public static final FontAwesome6IconType xing = on(FontAwesome6Brand.xing).build();
    public static final FontAwesome6IconType y_combinator = on(FontAwesome6Brand.y_combinator).build();
    public static final FontAwesome6IconType yahoo = on(FontAwesome6Brand.yahoo).build();
    public static final FontAwesome6IconType yammer = on(FontAwesome6Brand.yammer).build();
    public static final FontAwesome6IconType yandex = on(FontAwesome6Brand.yandex).build();
    public static final FontAwesome6IconType yandex_international = on(FontAwesome6Brand.yandex_international).build();
    public static final FontAwesome6IconType yarn = on(FontAwesome6Brand.yarn).build();
    public static final FontAwesome6IconType yelp = on(FontAwesome6Brand.yelp).build();
    public static final FontAwesome6IconType yoast = on(FontAwesome6Brand.yoast).build();
    public static final FontAwesome6IconType youtube = on(FontAwesome6Brand.youtube).build();
    public static final FontAwesome6IconType zhihu = on(FontAwesome6Brand.zhihu).build();

    /**
     * Constructor.
     *
     * @param cssClassName The css class name of the icon reference
     */
    FontAwesome6IconType(final String... cssClassName) {
        super(Strings.join(" ", cssClassName));
    }

    @Override
    public String cssClassName() {
        return getCssClassName();
    }
}
