package de.agilecoders.wicket.extensions.markup.html.bootstrap.icon;

import static de.agilecoders.wicket.extensions.markup.html.bootstrap.icon.FontAwesome7IconTypeBuilder.on;

import org.apache.wicket.util.string.Strings;

import de.agilecoders.wicket.core.markup.html.bootstrap.image.IconType;
import de.agilecoders.wicket.extensions.markup.html.bootstrap.icon.FontAwesome7IconTypeBuilder.FontAwesome7Brand;
import de.agilecoders.wicket.extensions.markup.html.bootstrap.icon.FontAwesome7IconTypeBuilder.FontAwesome7Regular;
import de.agilecoders.wicket.extensions.markup.html.bootstrap.icon.FontAwesome7IconTypeBuilder.FontAwesome7Solid;

/**
 * <strong>Important</strong>: To use font-awesome 6.x you need to declare the Maven/Gradle dependency
 * in your application pom.xml/build.gradle, for example:
 *
 * <br/>
 *  &lt;dependency&gt;<br/>
 *      &lt;groupId&gt;org.webjars&lt;/groupId&gt;<br/>
 *      &lt;artifactId&gt;font-awesome&lt;/artifactId&gt;<br/>
 *      &lt;version&gt;6.2.0&lt;/version&gt;<br/>
 *  &lt;/dependency&gt;<br/>
 *
 * All the icon types.
 */
public class FontAwesome7IconType extends IconType {

    /**
     * serialVersionUID.
     */
    private static final long serialVersionUID = 1L;

    // icon types of style 'solid' (tag '_s') and 'regular' (tag '_r') (where free)
    public static final FontAwesome7IconType _0_s = on(FontAwesome7Solid._0).build();
    public static final FontAwesome7IconType _1_s = on(FontAwesome7Solid._1).build();
    public static final FontAwesome7IconType _2_s = on(FontAwesome7Solid._2).build();
    public static final FontAwesome7IconType _3_s = on(FontAwesome7Solid._3).build();
    public static final FontAwesome7IconType _4_s = on(FontAwesome7Solid._4).build();
    public static final FontAwesome7IconType _5_s = on(FontAwesome7Solid._5).build();
    public static final FontAwesome7IconType _6_s = on(FontAwesome7Solid._6).build();
    public static final FontAwesome7IconType _7_s = on(FontAwesome7Solid._7).build();
    public static final FontAwesome7IconType _8_s = on(FontAwesome7Solid._8).build();
    public static final FontAwesome7IconType _9_s = on(FontAwesome7Solid._9).build();
    public static final FontAwesome7IconType a_s = on(FontAwesome7Solid.a).build();
    public static final FontAwesome7IconType ad_s = on(FontAwesome7Solid.ad).build();
    public static final FontAwesome7IconType add_s = on(FontAwesome7Solid.add).build();
    public static final FontAwesome7IconType address_book_r = on(FontAwesome7Regular.address_book).build();
    public static final FontAwesome7IconType address_book_s = on(FontAwesome7Solid.address_book).build();
    public static final FontAwesome7IconType address_card_r = on(FontAwesome7Regular.address_card).build();
    public static final FontAwesome7IconType address_card_s = on(FontAwesome7Solid.address_card).build();
    public static final FontAwesome7IconType adjust_s = on(FontAwesome7Solid.adjust).build();
    public static final FontAwesome7IconType air_freshener_s = on(FontAwesome7Solid.air_freshener).build();
    public static final FontAwesome7IconType alarm_clock_r = on(FontAwesome7Regular.alarm_clock).build();
    public static final FontAwesome7IconType alarm_clock_s = on(FontAwesome7Solid.alarm_clock).build();
    public static final FontAwesome7IconType align_center_s = on(FontAwesome7Solid.align_center).build();
    public static final FontAwesome7IconType align_justify_s = on(FontAwesome7Solid.align_justify).build();
    public static final FontAwesome7IconType align_left_s = on(FontAwesome7Solid.align_left).build();
    public static final FontAwesome7IconType align_right_s = on(FontAwesome7Solid.align_right).build();
    public static final FontAwesome7IconType allergies_s = on(FontAwesome7Solid.allergies).build();
    public static final FontAwesome7IconType ambulance_s = on(FontAwesome7Solid.ambulance).build();
    public static final FontAwesome7IconType american_sign_language_interpreting_s = on(FontAwesome7Solid.american_sign_language_interpreting).build();
    public static final FontAwesome7IconType anchor_circle_check_s = on(FontAwesome7Solid.anchor_circle_check).build();
    public static final FontAwesome7IconType anchor_circle_exclamation_s = on(FontAwesome7Solid.anchor_circle_exclamation).build();
    public static final FontAwesome7IconType anchor_circle_xmark_s = on(FontAwesome7Solid.anchor_circle_xmark).build();
    public static final FontAwesome7IconType anchor_lock_s = on(FontAwesome7Solid.anchor_lock).build();
    public static final FontAwesome7IconType anchor_s = on(FontAwesome7Solid.anchor).build();
    public static final FontAwesome7IconType angle_double_down_s = on(FontAwesome7Solid.angle_double_down).build();
    public static final FontAwesome7IconType angle_double_left_s = on(FontAwesome7Solid.angle_double_left).build();
    public static final FontAwesome7IconType angle_double_right_s = on(FontAwesome7Solid.angle_double_right).build();
    public static final FontAwesome7IconType angle_double_up_s = on(FontAwesome7Solid.angle_double_up).build();
    public static final FontAwesome7IconType angle_down_s = on(FontAwesome7Solid.angle_down).build();
    public static final FontAwesome7IconType angle_left_s = on(FontAwesome7Solid.angle_left).build();
    public static final FontAwesome7IconType angle_right_s = on(FontAwesome7Solid.angle_right).build();
    public static final FontAwesome7IconType angle_up_s = on(FontAwesome7Solid.angle_up).build();
    public static final FontAwesome7IconType angles_down_s = on(FontAwesome7Solid.angles_down).build();
    public static final FontAwesome7IconType angles_left_s = on(FontAwesome7Solid.angles_left).build();
    public static final FontAwesome7IconType angles_right_s = on(FontAwesome7Solid.angles_right).build();
    public static final FontAwesome7IconType angles_up_s = on(FontAwesome7Solid.angles_up).build();
    public static final FontAwesome7IconType angry_r = on(FontAwesome7Regular.angry).build();
    public static final FontAwesome7IconType angry_s = on(FontAwesome7Solid.angry).build();
    public static final FontAwesome7IconType ankh_s = on(FontAwesome7Solid.ankh).build();
    public static final FontAwesome7IconType apple_alt_s = on(FontAwesome7Solid.apple_alt).build();
    public static final FontAwesome7IconType apple_whole_s = on(FontAwesome7Solid.apple_whole).build();
    public static final FontAwesome7IconType archive_s = on(FontAwesome7Solid.archive).build();
    public static final FontAwesome7IconType archway_s = on(FontAwesome7Solid.archway).build();
    public static final FontAwesome7IconType area_chart_s = on(FontAwesome7Solid.area_chart).build();
    public static final FontAwesome7IconType arrow_alt_circle_down_r = on(FontAwesome7Regular.arrow_alt_circle_down).build();
    public static final FontAwesome7IconType arrow_alt_circle_down_s = on(FontAwesome7Solid.arrow_alt_circle_down).build();
    public static final FontAwesome7IconType arrow_alt_circle_left_r = on(FontAwesome7Regular.arrow_alt_circle_left).build();
    public static final FontAwesome7IconType arrow_alt_circle_left_s = on(FontAwesome7Solid.arrow_alt_circle_left).build();
    public static final FontAwesome7IconType arrow_alt_circle_right_r = on(FontAwesome7Regular.arrow_alt_circle_right).build();
    public static final FontAwesome7IconType arrow_alt_circle_right_s = on(FontAwesome7Solid.arrow_alt_circle_right).build();
    public static final FontAwesome7IconType arrow_alt_circle_up_r = on(FontAwesome7Regular.arrow_alt_circle_up).build();
    public static final FontAwesome7IconType arrow_alt_circle_up_s = on(FontAwesome7Solid.arrow_alt_circle_up).build();
    public static final FontAwesome7IconType arrow_circle_down_s = on(FontAwesome7Solid.arrow_circle_down).build();
    public static final FontAwesome7IconType arrow_circle_left_s = on(FontAwesome7Solid.arrow_circle_left).build();
    public static final FontAwesome7IconType arrow_circle_right_s = on(FontAwesome7Solid.arrow_circle_right).build();
    public static final FontAwesome7IconType arrow_circle_up_s = on(FontAwesome7Solid.arrow_circle_up).build();
    public static final FontAwesome7IconType arrow_down_1_9_s = on(FontAwesome7Solid.arrow_down_1_9).build();
    public static final FontAwesome7IconType arrow_down_9_1_s = on(FontAwesome7Solid.arrow_down_9_1).build();
    public static final FontAwesome7IconType arrow_down_a_z_s = on(FontAwesome7Solid.arrow_down_a_z).build();
    public static final FontAwesome7IconType arrow_down_long_s = on(FontAwesome7Solid.arrow_down_long).build();
    public static final FontAwesome7IconType arrow_down_s = on(FontAwesome7Solid.arrow_down).build();
    public static final FontAwesome7IconType arrow_down_short_wide_s = on(FontAwesome7Solid.arrow_down_short_wide).build();
    public static final FontAwesome7IconType arrow_down_up_across_line_s = on(FontAwesome7Solid.arrow_down_up_across_line).build();
    public static final FontAwesome7IconType arrow_down_up_lock_s = on(FontAwesome7Solid.arrow_down_up_lock).build();
    public static final FontAwesome7IconType arrow_down_wide_short_s = on(FontAwesome7Solid.arrow_down_wide_short).build();
    public static final FontAwesome7IconType arrow_down_z_a_s = on(FontAwesome7Solid.arrow_down_z_a).build();
    public static final FontAwesome7IconType arrow_left_long_s = on(FontAwesome7Solid.arrow_left_long).build();
    public static final FontAwesome7IconType arrow_left_rotate_s = on(FontAwesome7Solid.arrow_left_rotate).build();
    public static final FontAwesome7IconType arrow_left_s = on(FontAwesome7Solid.arrow_left).build();
    public static final FontAwesome7IconType arrow_pointer_s = on(FontAwesome7Solid.arrow_pointer).build();
    public static final FontAwesome7IconType arrow_right_arrow_left_s = on(FontAwesome7Solid.arrow_right_arrow_left).build();
    public static final FontAwesome7IconType arrow_right_from_bracket_s = on(FontAwesome7Solid.arrow_right_from_bracket).build();
    public static final FontAwesome7IconType arrow_right_from_file_s = on(FontAwesome7Solid.arrow_right_from_file).build();
    public static final FontAwesome7IconType arrow_right_long_s = on(FontAwesome7Solid.arrow_right_long).build();
    public static final FontAwesome7IconType arrow_right_rotate_s = on(FontAwesome7Solid.arrow_right_rotate).build();
    public static final FontAwesome7IconType arrow_right_s = on(FontAwesome7Solid.arrow_right).build();
    public static final FontAwesome7IconType arrow_right_to_bracket_s = on(FontAwesome7Solid.arrow_right_to_bracket).build();
    public static final FontAwesome7IconType arrow_right_to_city_s = on(FontAwesome7Solid.arrow_right_to_city).build();
    public static final FontAwesome7IconType arrow_right_to_file_s = on(FontAwesome7Solid.arrow_right_to_file).build();
    public static final FontAwesome7IconType arrow_rotate_back_s = on(FontAwesome7Solid.arrow_rotate_back).build();
    public static final FontAwesome7IconType arrow_rotate_backward_s = on(FontAwesome7Solid.arrow_rotate_backward).build();
    public static final FontAwesome7IconType arrow_rotate_forward_s = on(FontAwesome7Solid.arrow_rotate_forward).build();
    public static final FontAwesome7IconType arrow_rotate_left_s = on(FontAwesome7Solid.arrow_rotate_left).build();
    public static final FontAwesome7IconType arrow_rotate_right_s = on(FontAwesome7Solid.arrow_rotate_right).build();
    public static final FontAwesome7IconType arrow_trend_down_s = on(FontAwesome7Solid.arrow_trend_down).build();
    public static final FontAwesome7IconType arrow_trend_up_s = on(FontAwesome7Solid.arrow_trend_up).build();
    public static final FontAwesome7IconType arrow_turn_down_s = on(FontAwesome7Solid.arrow_turn_down).build();
    public static final FontAwesome7IconType arrow_turn_up_s = on(FontAwesome7Solid.arrow_turn_up).build();
    public static final FontAwesome7IconType arrow_up_1_9_s = on(FontAwesome7Solid.arrow_up_1_9).build();
    public static final FontAwesome7IconType arrow_up_9_1_s = on(FontAwesome7Solid.arrow_up_9_1).build();
    public static final FontAwesome7IconType arrow_up_a_z_s = on(FontAwesome7Solid.arrow_up_a_z).build();
    public static final FontAwesome7IconType arrow_up_from_bracket_s = on(FontAwesome7Solid.arrow_up_from_bracket).build();
    public static final FontAwesome7IconType arrow_up_from_ground_water_s = on(FontAwesome7Solid.arrow_up_from_ground_water).build();
    public static final FontAwesome7IconType arrow_up_from_water_pump_s = on(FontAwesome7Solid.arrow_up_from_water_pump).build();
    public static final FontAwesome7IconType arrow_up_long_s = on(FontAwesome7Solid.arrow_up_long).build();
    public static final FontAwesome7IconType arrow_up_right_dots_s = on(FontAwesome7Solid.arrow_up_right_dots).build();
    public static final FontAwesome7IconType arrow_up_right_from_square_s = on(FontAwesome7Solid.arrow_up_right_from_square).build();
    public static final FontAwesome7IconType arrow_up_s = on(FontAwesome7Solid.arrow_up).build();
    public static final FontAwesome7IconType arrow_up_short_wide_s = on(FontAwesome7Solid.arrow_up_short_wide).build();
    public static final FontAwesome7IconType arrow_up_wide_short_s = on(FontAwesome7Solid.arrow_up_wide_short).build();
    public static final FontAwesome7IconType arrow_up_z_a_s = on(FontAwesome7Solid.arrow_up_z_a).build();
    public static final FontAwesome7IconType arrows_alt_h_s = on(FontAwesome7Solid.arrows_alt_h).build();
    public static final FontAwesome7IconType arrows_alt_s = on(FontAwesome7Solid.arrows_alt).build();
    public static final FontAwesome7IconType arrows_alt_v_s = on(FontAwesome7Solid.arrows_alt_v).build();
    public static final FontAwesome7IconType arrows_down_to_line_s = on(FontAwesome7Solid.arrows_down_to_line).build();
    public static final FontAwesome7IconType arrows_down_to_people_s = on(FontAwesome7Solid.arrows_down_to_people).build();
    public static final FontAwesome7IconType arrows_h_s = on(FontAwesome7Solid.arrows_h).build();
    public static final FontAwesome7IconType arrows_left_right_s = on(FontAwesome7Solid.arrows_left_right).build();
    public static final FontAwesome7IconType arrows_left_right_to_line_s = on(FontAwesome7Solid.arrows_left_right_to_line).build();
    public static final FontAwesome7IconType arrows_rotate_s = on(FontAwesome7Solid.arrows_rotate).build();
    public static final FontAwesome7IconType arrows_s = on(FontAwesome7Solid.arrows).build();
    public static final FontAwesome7IconType arrows_spin_s = on(FontAwesome7Solid.arrows_spin).build();
    public static final FontAwesome7IconType arrows_split_up_and_left_s = on(FontAwesome7Solid.arrows_split_up_and_left).build();
    public static final FontAwesome7IconType arrows_to_circle_s = on(FontAwesome7Solid.arrows_to_circle).build();
    public static final FontAwesome7IconType arrows_to_dot_s = on(FontAwesome7Solid.arrows_to_dot).build();
    public static final FontAwesome7IconType arrows_to_eye_s = on(FontAwesome7Solid.arrows_to_eye).build();
    public static final FontAwesome7IconType arrows_turn_right_s = on(FontAwesome7Solid.arrows_turn_right).build();
    public static final FontAwesome7IconType arrows_turn_to_dots_s = on(FontAwesome7Solid.arrows_turn_to_dots).build();
    public static final FontAwesome7IconType arrows_up_down_left_right_s = on(FontAwesome7Solid.arrows_up_down_left_right).build();
    public static final FontAwesome7IconType arrows_up_down_s = on(FontAwesome7Solid.arrows_up_down).build();
    public static final FontAwesome7IconType arrows_up_to_line_s = on(FontAwesome7Solid.arrows_up_to_line).build();
    public static final FontAwesome7IconType arrows_v_s = on(FontAwesome7Solid.arrows_v).build();
    public static final FontAwesome7IconType asl_interpreting_s = on(FontAwesome7Solid.asl_interpreting).build();
    public static final FontAwesome7IconType assistive_listening_systems_s = on(FontAwesome7Solid.assistive_listening_systems).build();
    public static final FontAwesome7IconType asterisk_s = on(FontAwesome7Solid.asterisk).build();
    public static final FontAwesome7IconType at_s = on(FontAwesome7Solid.at).build();
    public static final FontAwesome7IconType atlas_s = on(FontAwesome7Solid.atlas).build();
    public static final FontAwesome7IconType atom_s = on(FontAwesome7Solid.atom).build();
    public static final FontAwesome7IconType audio_description_s = on(FontAwesome7Solid.audio_description).build();
    public static final FontAwesome7IconType austral_sign_s = on(FontAwesome7Solid.austral_sign).build();
    public static final FontAwesome7IconType automobile_s = on(FontAwesome7Solid.automobile).build();
    public static final FontAwesome7IconType award_s = on(FontAwesome7Solid.award).build();
    public static final FontAwesome7IconType b_s = on(FontAwesome7Solid.b).build();
    public static final FontAwesome7IconType baby_carriage_s = on(FontAwesome7Solid.baby_carriage).build();
    public static final FontAwesome7IconType baby_s = on(FontAwesome7Solid.baby).build();
    public static final FontAwesome7IconType backspace_s = on(FontAwesome7Solid.backspace).build();
    public static final FontAwesome7IconType backward_fast_s = on(FontAwesome7Solid.backward_fast).build();
    public static final FontAwesome7IconType backward_s = on(FontAwesome7Solid.backward).build();
    public static final FontAwesome7IconType backward_step_s = on(FontAwesome7Solid.backward_step).build();
    public static final FontAwesome7IconType bacon_s = on(FontAwesome7Solid.bacon).build();
    public static final FontAwesome7IconType bacteria_s = on(FontAwesome7Solid.bacteria).build();
    public static final FontAwesome7IconType bacterium_s = on(FontAwesome7Solid.bacterium).build();
    public static final FontAwesome7IconType bag_shopping_s = on(FontAwesome7Solid.bag_shopping).build();
    public static final FontAwesome7IconType bahai_s = on(FontAwesome7Solid.bahai).build();
    public static final FontAwesome7IconType baht_sign_s = on(FontAwesome7Solid.baht_sign).build();
    public static final FontAwesome7IconType balance_scale_left_s = on(FontAwesome7Solid.balance_scale_left).build();
    public static final FontAwesome7IconType balance_scale_right_s = on(FontAwesome7Solid.balance_scale_right).build();
    public static final FontAwesome7IconType balance_scale_s = on(FontAwesome7Solid.balance_scale).build();
    public static final FontAwesome7IconType ban_s = on(FontAwesome7Solid.ban).build();
    public static final FontAwesome7IconType ban_smoking_s = on(FontAwesome7Solid.ban_smoking).build();
    public static final FontAwesome7IconType band_aid_s = on(FontAwesome7Solid.band_aid).build();
    public static final FontAwesome7IconType bandage_s = on(FontAwesome7Solid.bandage).build();
    public static final FontAwesome7IconType bangladeshi_taka_sign_s = on(FontAwesome7Solid.bangladeshi_taka_sign).build();
    public static final FontAwesome7IconType bank_s = on(FontAwesome7Solid.bank).build();
    public static final FontAwesome7IconType bar_chart_r = on(FontAwesome7Regular.bar_chart).build();
    public static final FontAwesome7IconType bar_chart_s = on(FontAwesome7Solid.bar_chart).build();
    public static final FontAwesome7IconType barcode_s = on(FontAwesome7Solid.barcode).build();
    public static final FontAwesome7IconType bars_progress_s = on(FontAwesome7Solid.bars_progress).build();
    public static final FontAwesome7IconType bars_s = on(FontAwesome7Solid.bars).build();
    public static final FontAwesome7IconType bars_staggered_s = on(FontAwesome7Solid.bars_staggered).build();
    public static final FontAwesome7IconType baseball_ball_s = on(FontAwesome7Solid.baseball_ball).build();
    public static final FontAwesome7IconType baseball_bat_ball_s = on(FontAwesome7Solid.baseball_bat_ball).build();
    public static final FontAwesome7IconType baseball_s = on(FontAwesome7Solid.baseball).build();
    public static final FontAwesome7IconType basket_shopping_s = on(FontAwesome7Solid.basket_shopping).build();
    public static final FontAwesome7IconType basketball_ball_s = on(FontAwesome7Solid.basketball_ball).build();
    public static final FontAwesome7IconType basketball_s = on(FontAwesome7Solid.basketball).build();
    public static final FontAwesome7IconType bath_s = on(FontAwesome7Solid.bath).build();
    public static final FontAwesome7IconType bathtub_s = on(FontAwesome7Solid.bathtub).build();
    public static final FontAwesome7IconType battery_0_s = on(FontAwesome7Solid.battery_0).build();
    public static final FontAwesome7IconType battery_2_s = on(FontAwesome7Solid.battery_2).build();
    public static final FontAwesome7IconType battery_3_s = on(FontAwesome7Solid.battery_3).build();
    public static final FontAwesome7IconType battery_4_s = on(FontAwesome7Solid.battery_4).build();
    public static final FontAwesome7IconType battery_5_s = on(FontAwesome7Solid.battery_5).build();
    public static final FontAwesome7IconType battery_car_s = on(FontAwesome7Solid.battery_car).build();
    public static final FontAwesome7IconType battery_empty_s = on(FontAwesome7Solid.battery_empty).build();
    public static final FontAwesome7IconType battery_full_s = on(FontAwesome7Solid.battery_full).build();
    public static final FontAwesome7IconType battery_half_s = on(FontAwesome7Solid.battery_half).build();
    public static final FontAwesome7IconType battery_quarter_s = on(FontAwesome7Solid.battery_quarter).build();
    public static final FontAwesome7IconType battery_s = on(FontAwesome7Solid.battery).build();
    public static final FontAwesome7IconType battery_three_quarters_s = on(FontAwesome7Solid.battery_three_quarters).build();
    public static final FontAwesome7IconType bed_pulse_s = on(FontAwesome7Solid.bed_pulse).build();
    public static final FontAwesome7IconType bed_s = on(FontAwesome7Solid.bed).build();
    public static final FontAwesome7IconType beer_mug_empty_s = on(FontAwesome7Solid.beer_mug_empty).build();
    public static final FontAwesome7IconType beer_s = on(FontAwesome7Solid.beer).build();
    public static final FontAwesome7IconType bell_concierge_s = on(FontAwesome7Solid.bell_concierge).build();
    public static final FontAwesome7IconType bell_r = on(FontAwesome7Regular.bell).build();
    public static final FontAwesome7IconType bell_s = on(FontAwesome7Solid.bell).build();
    public static final FontAwesome7IconType bell_slash_r = on(FontAwesome7Regular.bell_slash).build();
    public static final FontAwesome7IconType bell_slash_s = on(FontAwesome7Solid.bell_slash).build();
    public static final FontAwesome7IconType bezier_curve_s = on(FontAwesome7Solid.bezier_curve).build();
    public static final FontAwesome7IconType bible_s = on(FontAwesome7Solid.bible).build();
    public static final FontAwesome7IconType bicycle_s = on(FontAwesome7Solid.bicycle).build();
    public static final FontAwesome7IconType biking_s = on(FontAwesome7Solid.biking).build();
    public static final FontAwesome7IconType binoculars_s = on(FontAwesome7Solid.binoculars).build();
    public static final FontAwesome7IconType biohazard_s = on(FontAwesome7Solid.biohazard).build();
    public static final FontAwesome7IconType birthday_cake_s = on(FontAwesome7Solid.birthday_cake).build();
    public static final FontAwesome7IconType bitcoin_sign_s = on(FontAwesome7Solid.bitcoin_sign).build();
    public static final FontAwesome7IconType blackboard_s = on(FontAwesome7Solid.blackboard).build();
    public static final FontAwesome7IconType blender_phone_s = on(FontAwesome7Solid.blender_phone).build();
    public static final FontAwesome7IconType blender_s = on(FontAwesome7Solid.blender).build();
    public static final FontAwesome7IconType blind_s = on(FontAwesome7Solid.blind).build();
    public static final FontAwesome7IconType blog_s = on(FontAwesome7Solid.blog).build();
    public static final FontAwesome7IconType bold_s = on(FontAwesome7Solid.bold).build();
    public static final FontAwesome7IconType bolt_lightning_s = on(FontAwesome7Solid.bolt_lightning).build();
    public static final FontAwesome7IconType bolt_s = on(FontAwesome7Solid.bolt).build();
    public static final FontAwesome7IconType bomb_s = on(FontAwesome7Solid.bomb).build();
    public static final FontAwesome7IconType bone_s = on(FontAwesome7Solid.bone).build();
    public static final FontAwesome7IconType bong_s = on(FontAwesome7Solid.bong).build();
    public static final FontAwesome7IconType book_atlas_s = on(FontAwesome7Solid.book_atlas).build();
    public static final FontAwesome7IconType book_bible_s = on(FontAwesome7Solid.book_bible).build();
    public static final FontAwesome7IconType book_bookmark_s = on(FontAwesome7Solid.book_bookmark).build();
    public static final FontAwesome7IconType book_dead_s = on(FontAwesome7Solid.book_dead).build();
    public static final FontAwesome7IconType book_journal_whills_s = on(FontAwesome7Solid.book_journal_whills).build();
    public static final FontAwesome7IconType book_medical_s = on(FontAwesome7Solid.book_medical).build();
    public static final FontAwesome7IconType book_open_reader_s = on(FontAwesome7Solid.book_open_reader).build();
    public static final FontAwesome7IconType book_open_s = on(FontAwesome7Solid.book_open).build();
    public static final FontAwesome7IconType book_quran_s = on(FontAwesome7Solid.book_quran).build();
    public static final FontAwesome7IconType book_reader_s = on(FontAwesome7Solid.book_reader).build();
    public static final FontAwesome7IconType book_s = on(FontAwesome7Solid.book).build();
    public static final FontAwesome7IconType book_skull_s = on(FontAwesome7Solid.book_skull).build();
    public static final FontAwesome7IconType book_tanakh_s = on(FontAwesome7Solid.book_tanakh).build();
    public static final FontAwesome7IconType bookmark_r = on(FontAwesome7Regular.bookmark).build();
    public static final FontAwesome7IconType bookmark_s = on(FontAwesome7Solid.bookmark).build();
    public static final FontAwesome7IconType border_all_s = on(FontAwesome7Solid.border_all).build();
    public static final FontAwesome7IconType border_none_s = on(FontAwesome7Solid.border_none).build();
    public static final FontAwesome7IconType border_style_s = on(FontAwesome7Solid.border_style).build();
    public static final FontAwesome7IconType border_top_left_s = on(FontAwesome7Solid.border_top_left).build();
    public static final FontAwesome7IconType bore_hole_s = on(FontAwesome7Solid.bore_hole).build();
    public static final FontAwesome7IconType bottle_droplet_s = on(FontAwesome7Solid.bottle_droplet).build();
    public static final FontAwesome7IconType bottle_water_s = on(FontAwesome7Solid.bottle_water).build();
    public static final FontAwesome7IconType bowl_food_s = on(FontAwesome7Solid.bowl_food).build();
    public static final FontAwesome7IconType bowl_rice_s = on(FontAwesome7Solid.bowl_rice).build();
    public static final FontAwesome7IconType bowling_ball_s = on(FontAwesome7Solid.bowling_ball).build();
    public static final FontAwesome7IconType box_archive_s = on(FontAwesome7Solid.box_archive).build();
    public static final FontAwesome7IconType box_open_s = on(FontAwesome7Solid.box_open).build();
    public static final FontAwesome7IconType box_s = on(FontAwesome7Solid.box).build();
    public static final FontAwesome7IconType box_tissue_s = on(FontAwesome7Solid.box_tissue).build();
    public static final FontAwesome7IconType boxes_alt_s = on(FontAwesome7Solid.boxes_alt).build();
    public static final FontAwesome7IconType boxes_packing_s = on(FontAwesome7Solid.boxes_packing).build();
    public static final FontAwesome7IconType boxes_s = on(FontAwesome7Solid.boxes).build();
    public static final FontAwesome7IconType boxes_stacked_s = on(FontAwesome7Solid.boxes_stacked).build();
    public static final FontAwesome7IconType braille_s = on(FontAwesome7Solid.braille).build();
    public static final FontAwesome7IconType brain_s = on(FontAwesome7Solid.brain).build();
    public static final FontAwesome7IconType brazilian_real_sign_s = on(FontAwesome7Solid.brazilian_real_sign).build();
    public static final FontAwesome7IconType bread_slice_s = on(FontAwesome7Solid.bread_slice).build();
    public static final FontAwesome7IconType bridge_circle_check_s = on(FontAwesome7Solid.bridge_circle_check).build();
    public static final FontAwesome7IconType bridge_circle_exclamation_s = on(FontAwesome7Solid.bridge_circle_exclamation).build();
    public static final FontAwesome7IconType bridge_circle_xmark_s = on(FontAwesome7Solid.bridge_circle_xmark).build();
    public static final FontAwesome7IconType bridge_lock_s = on(FontAwesome7Solid.bridge_lock).build();
    public static final FontAwesome7IconType bridge_s = on(FontAwesome7Solid.bridge).build();
    public static final FontAwesome7IconType bridge_water_s = on(FontAwesome7Solid.bridge_water).build();
    public static final FontAwesome7IconType briefcase_clock_s = on(FontAwesome7Solid.briefcase_clock).build();
    public static final FontAwesome7IconType briefcase_medical_s = on(FontAwesome7Solid.briefcase_medical).build();
    public static final FontAwesome7IconType briefcase_s = on(FontAwesome7Solid.briefcase).build();
    public static final FontAwesome7IconType broadcast_tower_s = on(FontAwesome7Solid.broadcast_tower).build();
    public static final FontAwesome7IconType broom_ball_s = on(FontAwesome7Solid.broom_ball).build();
    public static final FontAwesome7IconType broom_s = on(FontAwesome7Solid.broom).build();
    public static final FontAwesome7IconType brush_s = on(FontAwesome7Solid.brush).build();
    public static final FontAwesome7IconType bucket_s = on(FontAwesome7Solid.bucket).build();
    public static final FontAwesome7IconType bug_s = on(FontAwesome7Solid.bug).build();
    public static final FontAwesome7IconType bug_slash_s = on(FontAwesome7Solid.bug_slash).build();
    public static final FontAwesome7IconType bugs_s = on(FontAwesome7Solid.bugs).build();
    public static final FontAwesome7IconType building_circle_arrow_right_s = on(FontAwesome7Solid.building_circle_arrow_right).build();
    public static final FontAwesome7IconType building_circle_check_s = on(FontAwesome7Solid.building_circle_check).build();
    public static final FontAwesome7IconType building_circle_exclamation_s = on(FontAwesome7Solid.building_circle_exclamation).build();
    public static final FontAwesome7IconType building_circle_xmark_s = on(FontAwesome7Solid.building_circle_xmark).build();
    public static final FontAwesome7IconType building_columns_s = on(FontAwesome7Solid.building_columns).build();
    public static final FontAwesome7IconType building_flag_s = on(FontAwesome7Solid.building_flag).build();
    public static final FontAwesome7IconType building_lock_s = on(FontAwesome7Solid.building_lock).build();
    public static final FontAwesome7IconType building_ngo_s = on(FontAwesome7Solid.building_ngo).build();
    public static final FontAwesome7IconType building_r = on(FontAwesome7Regular.building).build();
    public static final FontAwesome7IconType building_s = on(FontAwesome7Solid.building).build();
    public static final FontAwesome7IconType building_shield_s = on(FontAwesome7Solid.building_shield).build();
    public static final FontAwesome7IconType building_un_s = on(FontAwesome7Solid.building_un).build();
    public static final FontAwesome7IconType building_user_s = on(FontAwesome7Solid.building_user).build();
    public static final FontAwesome7IconType building_wheat_s = on(FontAwesome7Solid.building_wheat).build();
    public static final FontAwesome7IconType bullhorn_s = on(FontAwesome7Solid.bullhorn).build();
    public static final FontAwesome7IconType bullseye_s = on(FontAwesome7Solid.bullseye).build();
    public static final FontAwesome7IconType burger_s = on(FontAwesome7Solid.burger).build();
    public static final FontAwesome7IconType burn_s = on(FontAwesome7Solid.burn).build();
    public static final FontAwesome7IconType burst_s = on(FontAwesome7Solid.burst).build();
    public static final FontAwesome7IconType bus_alt_s = on(FontAwesome7Solid.bus_alt).build();
    public static final FontAwesome7IconType bus_s = on(FontAwesome7Solid.bus).build();
    public static final FontAwesome7IconType bus_side_s = on(FontAwesome7Solid.bus_side).build();
    public static final FontAwesome7IconType bus_simple_s = on(FontAwesome7Solid.bus_simple).build();
    public static final FontAwesome7IconType business_time_s = on(FontAwesome7Solid.business_time).build();
    public static final FontAwesome7IconType c_s = on(FontAwesome7Solid.c).build();
    public static final FontAwesome7IconType cab_s = on(FontAwesome7Solid.cab).build();
    public static final FontAwesome7IconType cable_car_s = on(FontAwesome7Solid.cable_car).build();
    public static final FontAwesome7IconType cake_candles_s = on(FontAwesome7Solid.cake_candles).build();
    public static final FontAwesome7IconType cake_s = on(FontAwesome7Solid.cake).build();
    public static final FontAwesome7IconType calculator_s = on(FontAwesome7Solid.calculator).build();
    public static final FontAwesome7IconType calendar_alt_r = on(FontAwesome7Regular.calendar_alt).build();
    public static final FontAwesome7IconType calendar_alt_s = on(FontAwesome7Solid.calendar_alt).build();
    public static final FontAwesome7IconType calendar_check_r = on(FontAwesome7Regular.calendar_check).build();
    public static final FontAwesome7IconType calendar_check_s = on(FontAwesome7Solid.calendar_check).build();
    public static final FontAwesome7IconType calendar_day_s = on(FontAwesome7Solid.calendar_day).build();
    public static final FontAwesome7IconType calendar_days_r = on(FontAwesome7Regular.calendar_days).build();
    public static final FontAwesome7IconType calendar_days_s = on(FontAwesome7Solid.calendar_days).build();
    public static final FontAwesome7IconType calendar_minus_r = on(FontAwesome7Regular.calendar_minus).build();
    public static final FontAwesome7IconType calendar_minus_s = on(FontAwesome7Solid.calendar_minus).build();
    public static final FontAwesome7IconType calendar_plus_r = on(FontAwesome7Regular.calendar_plus).build();
    public static final FontAwesome7IconType calendar_plus_s = on(FontAwesome7Solid.calendar_plus).build();
    public static final FontAwesome7IconType calendar_r = on(FontAwesome7Regular.calendar).build();
    public static final FontAwesome7IconType calendar_s = on(FontAwesome7Solid.calendar).build();
    public static final FontAwesome7IconType calendar_times_r = on(FontAwesome7Regular.calendar_times).build();
    public static final FontAwesome7IconType calendar_times_s = on(FontAwesome7Solid.calendar_times).build();
    public static final FontAwesome7IconType calendar_week_s = on(FontAwesome7Solid.calendar_week).build();
    public static final FontAwesome7IconType calendar_xmark_r = on(FontAwesome7Regular.calendar_xmark).build();
    public static final FontAwesome7IconType calendar_xmark_s = on(FontAwesome7Solid.calendar_xmark).build();
    public static final FontAwesome7IconType camera_alt_r = on(FontAwesome7Regular.camera_alt).build();
    public static final FontAwesome7IconType camera_alt_s = on(FontAwesome7Solid.camera_alt).build();
    public static final FontAwesome7IconType camera_r = on(FontAwesome7Regular.camera).build();
    public static final FontAwesome7IconType camera_retro_s = on(FontAwesome7Solid.camera_retro).build();
    public static final FontAwesome7IconType camera_rotate_s = on(FontAwesome7Solid.camera_rotate).build();
    public static final FontAwesome7IconType camera_s = on(FontAwesome7Solid.camera).build();
    public static final FontAwesome7IconType campground_s = on(FontAwesome7Solid.campground).build();
    public static final FontAwesome7IconType cancel_s = on(FontAwesome7Solid.cancel).build();
    public static final FontAwesome7IconType candy_cane_s = on(FontAwesome7Solid.candy_cane).build();
    public static final FontAwesome7IconType cannabis_s = on(FontAwesome7Solid.cannabis).build();
    public static final FontAwesome7IconType capsules_s = on(FontAwesome7Solid.capsules).build();
    public static final FontAwesome7IconType car_alt_s = on(FontAwesome7Solid.car_alt).build();
    public static final FontAwesome7IconType car_battery_s = on(FontAwesome7Solid.car_battery).build();
    public static final FontAwesome7IconType car_burst_s = on(FontAwesome7Solid.car_burst).build();
    public static final FontAwesome7IconType car_crash_s = on(FontAwesome7Solid.car_crash).build();
    public static final FontAwesome7IconType car_on_s = on(FontAwesome7Solid.car_on).build();
    public static final FontAwesome7IconType car_rear_s = on(FontAwesome7Solid.car_rear).build();
    public static final FontAwesome7IconType car_s = on(FontAwesome7Solid.car).build();
    public static final FontAwesome7IconType car_side_s = on(FontAwesome7Solid.car_side).build();
    public static final FontAwesome7IconType car_tunnel_s = on(FontAwesome7Solid.car_tunnel).build();
    public static final FontAwesome7IconType caravan_s = on(FontAwesome7Solid.caravan).build();
    public static final FontAwesome7IconType caret_down_s = on(FontAwesome7Solid.caret_down).build();
    public static final FontAwesome7IconType caret_left_s = on(FontAwesome7Solid.caret_left).build();
    public static final FontAwesome7IconType caret_right_s = on(FontAwesome7Solid.caret_right).build();
    public static final FontAwesome7IconType caret_square_down_r = on(FontAwesome7Regular.caret_square_down).build();
    public static final FontAwesome7IconType caret_square_down_s = on(FontAwesome7Solid.caret_square_down).build();
    public static final FontAwesome7IconType caret_square_left_r = on(FontAwesome7Regular.caret_square_left).build();
    public static final FontAwesome7IconType caret_square_left_s = on(FontAwesome7Solid.caret_square_left).build();
    public static final FontAwesome7IconType caret_square_right_r = on(FontAwesome7Regular.caret_square_right).build();
    public static final FontAwesome7IconType caret_square_right_s = on(FontAwesome7Solid.caret_square_right).build();
    public static final FontAwesome7IconType caret_square_up_r = on(FontAwesome7Regular.caret_square_up).build();
    public static final FontAwesome7IconType caret_square_up_s = on(FontAwesome7Solid.caret_square_up).build();
    public static final FontAwesome7IconType caret_up_s = on(FontAwesome7Solid.caret_up).build();
    public static final FontAwesome7IconType carriage_baby_s = on(FontAwesome7Solid.carriage_baby).build();
    public static final FontAwesome7IconType carrot_s = on(FontAwesome7Solid.carrot).build();
    public static final FontAwesome7IconType cart_arrow_down_s = on(FontAwesome7Solid.cart_arrow_down).build();
    public static final FontAwesome7IconType cart_flatbed_s = on(FontAwesome7Solid.cart_flatbed).build();
    public static final FontAwesome7IconType cart_flatbed_suitcase_s = on(FontAwesome7Solid.cart_flatbed_suitcase).build();
    public static final FontAwesome7IconType cart_plus_s = on(FontAwesome7Solid.cart_plus).build();
    public static final FontAwesome7IconType cart_shopping_s = on(FontAwesome7Solid.cart_shopping).build();
    public static final FontAwesome7IconType cash_register_s = on(FontAwesome7Solid.cash_register).build();
    public static final FontAwesome7IconType cat_s = on(FontAwesome7Solid.cat).build();
    public static final FontAwesome7IconType cedi_sign_s = on(FontAwesome7Solid.cedi_sign).build();
    public static final FontAwesome7IconType cent_sign_s = on(FontAwesome7Solid.cent_sign).build();
    public static final FontAwesome7IconType certificate_s = on(FontAwesome7Solid.certificate).build();
    public static final FontAwesome7IconType chain_broken_s = on(FontAwesome7Solid.chain_broken).build();
    public static final FontAwesome7IconType chain_s = on(FontAwesome7Solid.chain).build();
    public static final FontAwesome7IconType chain_slash_s = on(FontAwesome7Solid.chain_slash).build();
    public static final FontAwesome7IconType chair_s = on(FontAwesome7Solid.chair).build();
    public static final FontAwesome7IconType chalkboard_s = on(FontAwesome7Solid.chalkboard).build();
    public static final FontAwesome7IconType chalkboard_teacher_s = on(FontAwesome7Solid.chalkboard_teacher).build();
    public static final FontAwesome7IconType chalkboard_user_s = on(FontAwesome7Solid.chalkboard_user).build();
    public static final FontAwesome7IconType champagne_glasses_s = on(FontAwesome7Solid.champagne_glasses).build();
    public static final FontAwesome7IconType charging_station_s = on(FontAwesome7Solid.charging_station).build();
    public static final FontAwesome7IconType chart_area_s = on(FontAwesome7Solid.chart_area).build();
    public static final FontAwesome7IconType chart_bar_r = on(FontAwesome7Regular.chart_bar).build();
    public static final FontAwesome7IconType chart_bar_s = on(FontAwesome7Solid.chart_bar).build();
    public static final FontAwesome7IconType chart_column_s = on(FontAwesome7Solid.chart_column).build();
    public static final FontAwesome7IconType chart_diagram_s = on(FontAwesome7Solid.chart_diagram).build();
    public static final FontAwesome7IconType chart_gantt_s = on(FontAwesome7Solid.chart_gantt).build();
    public static final FontAwesome7IconType chart_line_s = on(FontAwesome7Solid.chart_line).build();
    public static final FontAwesome7IconType chart_pie_s = on(FontAwesome7Solid.chart_pie).build();
    public static final FontAwesome7IconType chart_simple_s = on(FontAwesome7Solid.chart_simple).build();
    public static final FontAwesome7IconType check_circle_r = on(FontAwesome7Regular.check_circle).build();
    public static final FontAwesome7IconType check_circle_s = on(FontAwesome7Solid.check_circle).build();
    public static final FontAwesome7IconType check_double_s = on(FontAwesome7Solid.check_double).build();
    public static final FontAwesome7IconType check_s = on(FontAwesome7Solid.check).build();
    public static final FontAwesome7IconType check_square_r = on(FontAwesome7Regular.check_square).build();
    public static final FontAwesome7IconType check_square_s = on(FontAwesome7Solid.check_square).build();
    public static final FontAwesome7IconType check_to_slot_s = on(FontAwesome7Solid.check_to_slot).build();
    public static final FontAwesome7IconType cheese_s = on(FontAwesome7Solid.cheese).build();
    public static final FontAwesome7IconType chess_bishop_r = on(FontAwesome7Regular.chess_bishop).build();
    public static final FontAwesome7IconType chess_bishop_s = on(FontAwesome7Solid.chess_bishop).build();
    public static final FontAwesome7IconType chess_board_s = on(FontAwesome7Solid.chess_board).build();
    public static final FontAwesome7IconType chess_king_r = on(FontAwesome7Regular.chess_king).build();
    public static final FontAwesome7IconType chess_king_s = on(FontAwesome7Solid.chess_king).build();
    public static final FontAwesome7IconType chess_knight_r = on(FontAwesome7Regular.chess_knight).build();
    public static final FontAwesome7IconType chess_knight_s = on(FontAwesome7Solid.chess_knight).build();
    public static final FontAwesome7IconType chess_pawn_r = on(FontAwesome7Regular.chess_pawn).build();
    public static final FontAwesome7IconType chess_pawn_s = on(FontAwesome7Solid.chess_pawn).build();
    public static final FontAwesome7IconType chess_queen_r = on(FontAwesome7Regular.chess_queen).build();
    public static final FontAwesome7IconType chess_queen_s = on(FontAwesome7Solid.chess_queen).build();
    public static final FontAwesome7IconType chess_rook_r = on(FontAwesome7Regular.chess_rook).build();
    public static final FontAwesome7IconType chess_rook_s = on(FontAwesome7Solid.chess_rook).build();
    public static final FontAwesome7IconType chess_s = on(FontAwesome7Solid.chess).build();
    public static final FontAwesome7IconType chevron_circle_down_s = on(FontAwesome7Solid.chevron_circle_down).build();
    public static final FontAwesome7IconType chevron_circle_left_s = on(FontAwesome7Solid.chevron_circle_left).build();
    public static final FontAwesome7IconType chevron_circle_right_s = on(FontAwesome7Solid.chevron_circle_right).build();
    public static final FontAwesome7IconType chevron_circle_up_s = on(FontAwesome7Solid.chevron_circle_up).build();
    public static final FontAwesome7IconType chevron_down_s = on(FontAwesome7Solid.chevron_down).build();
    public static final FontAwesome7IconType chevron_left_s = on(FontAwesome7Solid.chevron_left).build();
    public static final FontAwesome7IconType chevron_right_s = on(FontAwesome7Solid.chevron_right).build();
    public static final FontAwesome7IconType chevron_up_s = on(FontAwesome7Solid.chevron_up).build();
    public static final FontAwesome7IconType child_combatant_s = on(FontAwesome7Solid.child_combatant).build();
    public static final FontAwesome7IconType child_dress_s = on(FontAwesome7Solid.child_dress).build();
    public static final FontAwesome7IconType child_reaching_s = on(FontAwesome7Solid.child_reaching).build();
    public static final FontAwesome7IconType child_rifle_s = on(FontAwesome7Solid.child_rifle).build();
    public static final FontAwesome7IconType child_s = on(FontAwesome7Solid.child).build();
    public static final FontAwesome7IconType children_s = on(FontAwesome7Solid.children).build();
    public static final FontAwesome7IconType church_s = on(FontAwesome7Solid.church).build();
    public static final FontAwesome7IconType circle_arrow_down_s = on(FontAwesome7Solid.circle_arrow_down).build();
    public static final FontAwesome7IconType circle_arrow_left_s = on(FontAwesome7Solid.circle_arrow_left).build();
    public static final FontAwesome7IconType circle_arrow_right_s = on(FontAwesome7Solid.circle_arrow_right).build();
    public static final FontAwesome7IconType circle_arrow_up_s = on(FontAwesome7Solid.circle_arrow_up).build();
    public static final FontAwesome7IconType circle_check_r = on(FontAwesome7Regular.circle_check).build();
    public static final FontAwesome7IconType circle_check_s = on(FontAwesome7Solid.circle_check).build();
    public static final FontAwesome7IconType circle_chevron_down_s = on(FontAwesome7Solid.circle_chevron_down).build();
    public static final FontAwesome7IconType circle_chevron_left_s = on(FontAwesome7Solid.circle_chevron_left).build();
    public static final FontAwesome7IconType circle_chevron_right_s = on(FontAwesome7Solid.circle_chevron_right).build();
    public static final FontAwesome7IconType circle_chevron_up_s = on(FontAwesome7Solid.circle_chevron_up).build();
    public static final FontAwesome7IconType circle_dollar_to_slot_s = on(FontAwesome7Solid.circle_dollar_to_slot).build();
    public static final FontAwesome7IconType circle_dot_r = on(FontAwesome7Regular.circle_dot).build();
    public static final FontAwesome7IconType circle_dot_s = on(FontAwesome7Solid.circle_dot).build();
    public static final FontAwesome7IconType circle_down_r = on(FontAwesome7Regular.circle_down).build();
    public static final FontAwesome7IconType circle_down_s = on(FontAwesome7Solid.circle_down).build();
    public static final FontAwesome7IconType circle_exclamation_s = on(FontAwesome7Solid.circle_exclamation).build();
    public static final FontAwesome7IconType circle_h_s = on(FontAwesome7Solid.circle_h).build();
    public static final FontAwesome7IconType circle_half_stroke_s = on(FontAwesome7Solid.circle_half_stroke).build();
    public static final FontAwesome7IconType circle_info_s = on(FontAwesome7Solid.circle_info).build();
    public static final FontAwesome7IconType circle_left_r = on(FontAwesome7Regular.circle_left).build();
    public static final FontAwesome7IconType circle_left_s = on(FontAwesome7Solid.circle_left).build();
    public static final FontAwesome7IconType circle_minus_s = on(FontAwesome7Solid.circle_minus).build();
    public static final FontAwesome7IconType circle_nodes_s = on(FontAwesome7Solid.circle_nodes).build();
    public static final FontAwesome7IconType circle_notch_s = on(FontAwesome7Solid.circle_notch).build();
    public static final FontAwesome7IconType circle_pause_r = on(FontAwesome7Regular.circle_pause).build();
    public static final FontAwesome7IconType circle_pause_s = on(FontAwesome7Solid.circle_pause).build();
    public static final FontAwesome7IconType circle_play_r = on(FontAwesome7Regular.circle_play).build();
    public static final FontAwesome7IconType circle_play_s = on(FontAwesome7Solid.circle_play).build();
    public static final FontAwesome7IconType circle_plus_s = on(FontAwesome7Solid.circle_plus).build();
    public static final FontAwesome7IconType circle_question_r = on(FontAwesome7Regular.circle_question).build();
    public static final FontAwesome7IconType circle_question_s = on(FontAwesome7Solid.circle_question).build();
    public static final FontAwesome7IconType circle_r = on(FontAwesome7Regular.circle).build();
    public static final FontAwesome7IconType circle_radiation_s = on(FontAwesome7Solid.circle_radiation).build();
    public static final FontAwesome7IconType circle_right_r = on(FontAwesome7Regular.circle_right).build();
    public static final FontAwesome7IconType circle_right_s = on(FontAwesome7Solid.circle_right).build();
    public static final FontAwesome7IconType circle_s = on(FontAwesome7Solid.circle).build();
    public static final FontAwesome7IconType circle_stop_r = on(FontAwesome7Regular.circle_stop).build();
    public static final FontAwesome7IconType circle_stop_s = on(FontAwesome7Solid.circle_stop).build();
    public static final FontAwesome7IconType circle_up_r = on(FontAwesome7Regular.circle_up).build();
    public static final FontAwesome7IconType circle_up_s = on(FontAwesome7Solid.circle_up).build();
    public static final FontAwesome7IconType circle_user_r = on(FontAwesome7Regular.circle_user).build();
    public static final FontAwesome7IconType circle_user_s = on(FontAwesome7Solid.circle_user).build();
    public static final FontAwesome7IconType circle_xmark_r = on(FontAwesome7Regular.circle_xmark).build();
    public static final FontAwesome7IconType circle_xmark_s = on(FontAwesome7Solid.circle_xmark).build();
    public static final FontAwesome7IconType city_s = on(FontAwesome7Solid.city).build();
    public static final FontAwesome7IconType clapperboard_s = on(FontAwesome7Solid.clapperboard).build();
    public static final FontAwesome7IconType clinic_medical_s = on(FontAwesome7Solid.clinic_medical).build();
    public static final FontAwesome7IconType clipboard_check_s = on(FontAwesome7Solid.clipboard_check).build();
    public static final FontAwesome7IconType clipboard_list_s = on(FontAwesome7Solid.clipboard_list).build();
    public static final FontAwesome7IconType clipboard_question_s = on(FontAwesome7Solid.clipboard_question).build();
    public static final FontAwesome7IconType clipboard_r = on(FontAwesome7Regular.clipboard).build();
    public static final FontAwesome7IconType clipboard_s = on(FontAwesome7Solid.clipboard).build();
    public static final FontAwesome7IconType clipboard_user_s = on(FontAwesome7Solid.clipboard_user).build();
    public static final FontAwesome7IconType clock_four_r = on(FontAwesome7Regular.clock_four).build();
    public static final FontAwesome7IconType clock_four_s = on(FontAwesome7Solid.clock_four).build();
    public static final FontAwesome7IconType clock_r = on(FontAwesome7Regular.clock).build();
    public static final FontAwesome7IconType clock_rotate_left_s = on(FontAwesome7Solid.clock_rotate_left).build();
    public static final FontAwesome7IconType clock_s = on(FontAwesome7Solid.clock).build();
    public static final FontAwesome7IconType clone_r = on(FontAwesome7Regular.clone).build();
    public static final FontAwesome7IconType clone_s = on(FontAwesome7Solid.clone).build();
    public static final FontAwesome7IconType close_s = on(FontAwesome7Solid.close).build();
    public static final FontAwesome7IconType closed_captioning_r = on(FontAwesome7Regular.closed_captioning).build();
    public static final FontAwesome7IconType closed_captioning_s = on(FontAwesome7Solid.closed_captioning).build();
    public static final FontAwesome7IconType cloud_arrow_down_s = on(FontAwesome7Solid.cloud_arrow_down).build();
    public static final FontAwesome7IconType cloud_arrow_up_s = on(FontAwesome7Solid.cloud_arrow_up).build();
    public static final FontAwesome7IconType cloud_bolt_s = on(FontAwesome7Solid.cloud_bolt).build();
    public static final FontAwesome7IconType cloud_download_alt_s = on(FontAwesome7Solid.cloud_download_alt).build();
    public static final FontAwesome7IconType cloud_download_s = on(FontAwesome7Solid.cloud_download).build();
    public static final FontAwesome7IconType cloud_meatball_s = on(FontAwesome7Solid.cloud_meatball).build();
    public static final FontAwesome7IconType cloud_moon_rain_s = on(FontAwesome7Solid.cloud_moon_rain).build();
    public static final FontAwesome7IconType cloud_moon_s = on(FontAwesome7Solid.cloud_moon).build();
    public static final FontAwesome7IconType cloud_r = on(FontAwesome7Regular.cloud).build();
    public static final FontAwesome7IconType cloud_rain_s = on(FontAwesome7Solid.cloud_rain).build();
    public static final FontAwesome7IconType cloud_s = on(FontAwesome7Solid.cloud).build();
    public static final FontAwesome7IconType cloud_showers_heavy_s = on(FontAwesome7Solid.cloud_showers_heavy).build();
    public static final FontAwesome7IconType cloud_showers_water_s = on(FontAwesome7Solid.cloud_showers_water).build();
    public static final FontAwesome7IconType cloud_sun_rain_s = on(FontAwesome7Solid.cloud_sun_rain).build();
    public static final FontAwesome7IconType cloud_sun_s = on(FontAwesome7Solid.cloud_sun).build();
    public static final FontAwesome7IconType cloud_upload_alt_s = on(FontAwesome7Solid.cloud_upload_alt).build();
    public static final FontAwesome7IconType cloud_upload_s = on(FontAwesome7Solid.cloud_upload).build();
    public static final FontAwesome7IconType clover_s = on(FontAwesome7Solid.clover).build();
    public static final FontAwesome7IconType cny_s = on(FontAwesome7Solid.cny).build();
    public static final FontAwesome7IconType cocktail_s = on(FontAwesome7Solid.cocktail).build();
    public static final FontAwesome7IconType code_branch_s = on(FontAwesome7Solid.code_branch).build();
    public static final FontAwesome7IconType code_commit_s = on(FontAwesome7Solid.code_commit).build();
    public static final FontAwesome7IconType code_compare_s = on(FontAwesome7Solid.code_compare).build();
    public static final FontAwesome7IconType code_fork_s = on(FontAwesome7Solid.code_fork).build();
    public static final FontAwesome7IconType code_merge_s = on(FontAwesome7Solid.code_merge).build();
    public static final FontAwesome7IconType code_pull_request_s = on(FontAwesome7Solid.code_pull_request).build();
    public static final FontAwesome7IconType code_s = on(FontAwesome7Solid.code).build();
    public static final FontAwesome7IconType coffee_s = on(FontAwesome7Solid.coffee).build();
    public static final FontAwesome7IconType cog_s = on(FontAwesome7Solid.cog).build();
    public static final FontAwesome7IconType cogs_s = on(FontAwesome7Solid.cogs).build();
    public static final FontAwesome7IconType coins_s = on(FontAwesome7Solid.coins).build();
    public static final FontAwesome7IconType colon_sign_s = on(FontAwesome7Solid.colon_sign).build();
    public static final FontAwesome7IconType columns_s = on(FontAwesome7Solid.columns).build();
    public static final FontAwesome7IconType comment_alt_r = on(FontAwesome7Regular.comment_alt).build();
    public static final FontAwesome7IconType comment_alt_s = on(FontAwesome7Solid.comment_alt).build();
    public static final FontAwesome7IconType comment_dollar_s = on(FontAwesome7Solid.comment_dollar).build();
    public static final FontAwesome7IconType comment_dots_r = on(FontAwesome7Regular.comment_dots).build();
    public static final FontAwesome7IconType comment_dots_s = on(FontAwesome7Solid.comment_dots).build();
    public static final FontAwesome7IconType comment_medical_s = on(FontAwesome7Solid.comment_medical).build();
    public static final FontAwesome7IconType comment_nodes_s = on(FontAwesome7Solid.comment_nodes).build();
    public static final FontAwesome7IconType comment_r = on(FontAwesome7Regular.comment).build();
    public static final FontAwesome7IconType comment_s = on(FontAwesome7Solid.comment).build();
    public static final FontAwesome7IconType comment_slash_s = on(FontAwesome7Solid.comment_slash).build();
    public static final FontAwesome7IconType comment_sms_s = on(FontAwesome7Solid.comment_sms).build();
    public static final FontAwesome7IconType commenting_r = on(FontAwesome7Regular.commenting).build();
    public static final FontAwesome7IconType commenting_s = on(FontAwesome7Solid.commenting).build();
    public static final FontAwesome7IconType comments_dollar_s = on(FontAwesome7Solid.comments_dollar).build();
    public static final FontAwesome7IconType comments_r = on(FontAwesome7Regular.comments).build();
    public static final FontAwesome7IconType comments_s = on(FontAwesome7Solid.comments).build();
    public static final FontAwesome7IconType compact_disc_s = on(FontAwesome7Solid.compact_disc).build();
    public static final FontAwesome7IconType compass_drafting_s = on(FontAwesome7Solid.compass_drafting).build();
    public static final FontAwesome7IconType compass_r = on(FontAwesome7Regular.compass).build();
    public static final FontAwesome7IconType compass_s = on(FontAwesome7Solid.compass).build();
    public static final FontAwesome7IconType compress_alt_s = on(FontAwesome7Solid.compress_alt).build();
    public static final FontAwesome7IconType compress_arrows_alt_s = on(FontAwesome7Solid.compress_arrows_alt).build();
    public static final FontAwesome7IconType compress_s = on(FontAwesome7Solid.compress).build();
    public static final FontAwesome7IconType computer_mouse_s = on(FontAwesome7Solid.computer_mouse).build();
    public static final FontAwesome7IconType computer_s = on(FontAwesome7Solid.computer).build();
    public static final FontAwesome7IconType concierge_bell_s = on(FontAwesome7Solid.concierge_bell).build();
    public static final FontAwesome7IconType contact_book_r = on(FontAwesome7Regular.contact_book).build();
    public static final FontAwesome7IconType contact_book_s = on(FontAwesome7Solid.contact_book).build();
    public static final FontAwesome7IconType contact_card_r = on(FontAwesome7Regular.contact_card).build();
    public static final FontAwesome7IconType contact_card_s = on(FontAwesome7Solid.contact_card).build();
    public static final FontAwesome7IconType cookie_bite_s = on(FontAwesome7Solid.cookie_bite).build();
    public static final FontAwesome7IconType cookie_s = on(FontAwesome7Solid.cookie).build();
    public static final FontAwesome7IconType copy_r = on(FontAwesome7Regular.copy).build();
    public static final FontAwesome7IconType copy_s = on(FontAwesome7Solid.copy).build();
    public static final FontAwesome7IconType copyright_r = on(FontAwesome7Regular.copyright).build();
    public static final FontAwesome7IconType copyright_s = on(FontAwesome7Solid.copyright).build();
    public static final FontAwesome7IconType couch_s = on(FontAwesome7Solid.couch).build();
    public static final FontAwesome7IconType cow_s = on(FontAwesome7Solid.cow).build();
    public static final FontAwesome7IconType credit_card_alt_r = on(FontAwesome7Regular.credit_card_alt).build();
    public static final FontAwesome7IconType credit_card_alt_s = on(FontAwesome7Solid.credit_card_alt).build();
    public static final FontAwesome7IconType credit_card_r = on(FontAwesome7Regular.credit_card).build();
    public static final FontAwesome7IconType credit_card_s = on(FontAwesome7Solid.credit_card).build();
    public static final FontAwesome7IconType crop_alt_s = on(FontAwesome7Solid.crop_alt).build();
    public static final FontAwesome7IconType crop_s = on(FontAwesome7Solid.crop).build();
    public static final FontAwesome7IconType crop_simple_s = on(FontAwesome7Solid.crop_simple).build();
    public static final FontAwesome7IconType cross_s = on(FontAwesome7Solid.cross).build();
    public static final FontAwesome7IconType crosshairs_s = on(FontAwesome7Solid.crosshairs).build();
    public static final FontAwesome7IconType crow_s = on(FontAwesome7Solid.crow).build();
    public static final FontAwesome7IconType crown_s = on(FontAwesome7Solid.crown).build();
    public static final FontAwesome7IconType crutch_s = on(FontAwesome7Solid.crutch).build();
    public static final FontAwesome7IconType cruzeiro_sign_s = on(FontAwesome7Solid.cruzeiro_sign).build();
    public static final FontAwesome7IconType cube_s = on(FontAwesome7Solid.cube).build();
    public static final FontAwesome7IconType cubes_s = on(FontAwesome7Solid.cubes).build();
    public static final FontAwesome7IconType cubes_stacked_s = on(FontAwesome7Solid.cubes_stacked).build();
    public static final FontAwesome7IconType cut_s = on(FontAwesome7Solid.cut).build();
    public static final FontAwesome7IconType cutlery_s = on(FontAwesome7Solid.cutlery).build();
    public static final FontAwesome7IconType d_s = on(FontAwesome7Solid.d).build();
    public static final FontAwesome7IconType dashboard_s = on(FontAwesome7Solid.dashboard).build();
    public static final FontAwesome7IconType database_s = on(FontAwesome7Solid.database).build();
    public static final FontAwesome7IconType deaf_s = on(FontAwesome7Solid.deaf).build();
    public static final FontAwesome7IconType deafness_s = on(FontAwesome7Solid.deafness).build();
    public static final FontAwesome7IconType dedent_s = on(FontAwesome7Solid.dedent).build();
    public static final FontAwesome7IconType delete_left_s = on(FontAwesome7Solid.delete_left).build();
    public static final FontAwesome7IconType democrat_s = on(FontAwesome7Solid.democrat).build();
    public static final FontAwesome7IconType desktop_alt_s = on(FontAwesome7Solid.desktop_alt).build();
    public static final FontAwesome7IconType desktop_s = on(FontAwesome7Solid.desktop).build();
    public static final FontAwesome7IconType dharmachakra_s = on(FontAwesome7Solid.dharmachakra).build();
    public static final FontAwesome7IconType diagnoses_s = on(FontAwesome7Solid.diagnoses).build();
    public static final FontAwesome7IconType diagram_next_s = on(FontAwesome7Solid.diagram_next).build();
    public static final FontAwesome7IconType diagram_predecessor_s = on(FontAwesome7Solid.diagram_predecessor).build();
    public static final FontAwesome7IconType diagram_project_s = on(FontAwesome7Solid.diagram_project).build();
    public static final FontAwesome7IconType diagram_successor_s = on(FontAwesome7Solid.diagram_successor).build();
    public static final FontAwesome7IconType diamond_s = on(FontAwesome7Solid.diamond).build();
    public static final FontAwesome7IconType diamond_turn_right_s = on(FontAwesome7Solid.diamond_turn_right).build();
    public static final FontAwesome7IconType dice_d20_s = on(FontAwesome7Solid.dice_d20).build();
    public static final FontAwesome7IconType dice_d6_s = on(FontAwesome7Solid.dice_d6).build();
    public static final FontAwesome7IconType dice_five_s = on(FontAwesome7Solid.dice_five).build();
    public static final FontAwesome7IconType dice_four_s = on(FontAwesome7Solid.dice_four).build();
    public static final FontAwesome7IconType dice_one_s = on(FontAwesome7Solid.dice_one).build();
    public static final FontAwesome7IconType dice_s = on(FontAwesome7Solid.dice).build();
    public static final FontAwesome7IconType dice_six_s = on(FontAwesome7Solid.dice_six).build();
    public static final FontAwesome7IconType dice_three_s = on(FontAwesome7Solid.dice_three).build();
    public static final FontAwesome7IconType dice_two_s = on(FontAwesome7Solid.dice_two).build();
    public static final FontAwesome7IconType digging_s = on(FontAwesome7Solid.digging).build();
    public static final FontAwesome7IconType digital_tachograph_s = on(FontAwesome7Solid.digital_tachograph).build();
    public static final FontAwesome7IconType directions_s = on(FontAwesome7Solid.directions).build();
    public static final FontAwesome7IconType disease_s = on(FontAwesome7Solid.disease).build();
    public static final FontAwesome7IconType display_s = on(FontAwesome7Solid.display).build();
    public static final FontAwesome7IconType divide_s = on(FontAwesome7Solid.divide).build();
    public static final FontAwesome7IconType dizzy_r = on(FontAwesome7Regular.dizzy).build();
    public static final FontAwesome7IconType dizzy_s = on(FontAwesome7Solid.dizzy).build();
    public static final FontAwesome7IconType dna_s = on(FontAwesome7Solid.dna).build();
    public static final FontAwesome7IconType dog_s = on(FontAwesome7Solid.dog).build();
    public static final FontAwesome7IconType dollar_s = on(FontAwesome7Solid.dollar).build();
    public static final FontAwesome7IconType dollar_sign_s = on(FontAwesome7Solid.dollar_sign).build();
    public static final FontAwesome7IconType dolly_box_s = on(FontAwesome7Solid.dolly_box).build();
    public static final FontAwesome7IconType dolly_flatbed_s = on(FontAwesome7Solid.dolly_flatbed).build();
    public static final FontAwesome7IconType dolly_s = on(FontAwesome7Solid.dolly).build();
    public static final FontAwesome7IconType donate_s = on(FontAwesome7Solid.donate).build();
    public static final FontAwesome7IconType dong_sign_s = on(FontAwesome7Solid.dong_sign).build();
    public static final FontAwesome7IconType door_closed_s = on(FontAwesome7Solid.door_closed).build();
    public static final FontAwesome7IconType door_open_s = on(FontAwesome7Solid.door_open).build();
    public static final FontAwesome7IconType dot_circle_r = on(FontAwesome7Regular.dot_circle).build();
    public static final FontAwesome7IconType dot_circle_s = on(FontAwesome7Solid.dot_circle).build();
    public static final FontAwesome7IconType dove_s = on(FontAwesome7Solid.dove).build();
    public static final FontAwesome7IconType down_left_and_up_right_to_center_s = on(FontAwesome7Solid.down_left_and_up_right_to_center).build();
    public static final FontAwesome7IconType down_long_s = on(FontAwesome7Solid.down_long).build();
    public static final FontAwesome7IconType download_s = on(FontAwesome7Solid.download).build();
    public static final FontAwesome7IconType drafting_compass_s = on(FontAwesome7Solid.drafting_compass).build();
    public static final FontAwesome7IconType dragon_s = on(FontAwesome7Solid.dragon).build();
    public static final FontAwesome7IconType draw_polygon_s = on(FontAwesome7Solid.draw_polygon).build();
    public static final FontAwesome7IconType drivers_license_r = on(FontAwesome7Regular.drivers_license).build();
    public static final FontAwesome7IconType drivers_license_s = on(FontAwesome7Solid.drivers_license).build();
    public static final FontAwesome7IconType droplet_s = on(FontAwesome7Solid.droplet).build();
    public static final FontAwesome7IconType droplet_slash_s = on(FontAwesome7Solid.droplet_slash).build();
    public static final FontAwesome7IconType drum_s = on(FontAwesome7Solid.drum).build();
    public static final FontAwesome7IconType drum_steelpan_s = on(FontAwesome7Solid.drum_steelpan).build();
    public static final FontAwesome7IconType drumstick_bite_s = on(FontAwesome7Solid.drumstick_bite).build();
    public static final FontAwesome7IconType dumbbell_s = on(FontAwesome7Solid.dumbbell).build();
    public static final FontAwesome7IconType dumpster_fire_s = on(FontAwesome7Solid.dumpster_fire).build();
    public static final FontAwesome7IconType dumpster_s = on(FontAwesome7Solid.dumpster).build();
    public static final FontAwesome7IconType dungeon_s = on(FontAwesome7Solid.dungeon).build();
    public static final FontAwesome7IconType e_s = on(FontAwesome7Solid.e).build();
    public static final FontAwesome7IconType ear_deaf_s = on(FontAwesome7Solid.ear_deaf).build();
    public static final FontAwesome7IconType ear_listen_s = on(FontAwesome7Solid.ear_listen).build();
    public static final FontAwesome7IconType earth_africa_s = on(FontAwesome7Solid.earth_africa).build();
    public static final FontAwesome7IconType earth_america_s = on(FontAwesome7Solid.earth_america).build();
    public static final FontAwesome7IconType earth_americas_s = on(FontAwesome7Solid.earth_americas).build();
    public static final FontAwesome7IconType earth_asia_s = on(FontAwesome7Solid.earth_asia).build();
    public static final FontAwesome7IconType earth_europe_s = on(FontAwesome7Solid.earth_europe).build();
    public static final FontAwesome7IconType earth_oceania_s = on(FontAwesome7Solid.earth_oceania).build();
    public static final FontAwesome7IconType earth_s = on(FontAwesome7Solid.earth).build();
    public static final FontAwesome7IconType edit_r = on(FontAwesome7Regular.edit).build();
    public static final FontAwesome7IconType edit_s = on(FontAwesome7Solid.edit).build();
    public static final FontAwesome7IconType egg_s = on(FontAwesome7Solid.egg).build();
    public static final FontAwesome7IconType eject_s = on(FontAwesome7Solid.eject).build();
    public static final FontAwesome7IconType elevator_s = on(FontAwesome7Solid.elevator).build();
    public static final FontAwesome7IconType ellipsis_h_s = on(FontAwesome7Solid.ellipsis_h).build();
    public static final FontAwesome7IconType ellipsis_s = on(FontAwesome7Solid.ellipsis).build();
    public static final FontAwesome7IconType ellipsis_v_s = on(FontAwesome7Solid.ellipsis_v).build();
    public static final FontAwesome7IconType ellipsis_vertical_s = on(FontAwesome7Solid.ellipsis_vertical).build();
    public static final FontAwesome7IconType envelope_circle_check_s = on(FontAwesome7Solid.envelope_circle_check).build();
    public static final FontAwesome7IconType envelope_open_r = on(FontAwesome7Regular.envelope_open).build();
    public static final FontAwesome7IconType envelope_open_s = on(FontAwesome7Solid.envelope_open).build();
    public static final FontAwesome7IconType envelope_open_text_s = on(FontAwesome7Solid.envelope_open_text).build();
    public static final FontAwesome7IconType envelope_r = on(FontAwesome7Regular.envelope).build();
    public static final FontAwesome7IconType envelope_s = on(FontAwesome7Solid.envelope).build();
    public static final FontAwesome7IconType envelope_square_s = on(FontAwesome7Solid.envelope_square).build();
    public static final FontAwesome7IconType envelopes_bulk_s = on(FontAwesome7Solid.envelopes_bulk).build();
    public static final FontAwesome7IconType equals_s = on(FontAwesome7Solid.equals).build();
    public static final FontAwesome7IconType eraser_s = on(FontAwesome7Solid.eraser).build();
    public static final FontAwesome7IconType ethernet_s = on(FontAwesome7Solid.ethernet).build();
    public static final FontAwesome7IconType eur_s = on(FontAwesome7Solid.eur).build();
    public static final FontAwesome7IconType euro_s = on(FontAwesome7Solid.euro).build();
    public static final FontAwesome7IconType euro_sign_s = on(FontAwesome7Solid.euro_sign).build();
    public static final FontAwesome7IconType exchange_alt_s = on(FontAwesome7Solid.exchange_alt).build();
    public static final FontAwesome7IconType exchange_s = on(FontAwesome7Solid.exchange).build();
    public static final FontAwesome7IconType exclamation_circle_s = on(FontAwesome7Solid.exclamation_circle).build();
    public static final FontAwesome7IconType exclamation_s = on(FontAwesome7Solid.exclamation).build();
    public static final FontAwesome7IconType exclamation_triangle_s = on(FontAwesome7Solid.exclamation_triangle).build();
    public static final FontAwesome7IconType expand_alt_s = on(FontAwesome7Solid.expand_alt).build();
    public static final FontAwesome7IconType expand_arrows_alt_s = on(FontAwesome7Solid.expand_arrows_alt).build();
    public static final FontAwesome7IconType expand_s = on(FontAwesome7Solid.expand).build();
    public static final FontAwesome7IconType explosion_s = on(FontAwesome7Solid.explosion).build();
    public static final FontAwesome7IconType external_link_alt_s = on(FontAwesome7Solid.external_link_alt).build();
    public static final FontAwesome7IconType external_link_s = on(FontAwesome7Solid.external_link).build();
    public static final FontAwesome7IconType external_link_square_alt_s = on(FontAwesome7Solid.external_link_square_alt).build();
    public static final FontAwesome7IconType external_link_square_s = on(FontAwesome7Solid.external_link_square).build();
    public static final FontAwesome7IconType eye_dropper_empty_s = on(FontAwesome7Solid.eye_dropper_empty).build();
    public static final FontAwesome7IconType eye_dropper_s = on(FontAwesome7Solid.eye_dropper).build();
    public static final FontAwesome7IconType eye_low_vision_s = on(FontAwesome7Solid.eye_low_vision).build();
    public static final FontAwesome7IconType eye_r = on(FontAwesome7Regular.eye).build();
    public static final FontAwesome7IconType eye_s = on(FontAwesome7Solid.eye).build();
    public static final FontAwesome7IconType eye_slash_r = on(FontAwesome7Regular.eye_slash).build();
    public static final FontAwesome7IconType eye_slash_s = on(FontAwesome7Solid.eye_slash).build();
    public static final FontAwesome7IconType eyedropper_s = on(FontAwesome7Solid.eyedropper).build();
    public static final FontAwesome7IconType f_s = on(FontAwesome7Solid.f).build();
    public static final FontAwesome7IconType face_angry_r = on(FontAwesome7Regular.face_angry).build();
    public static final FontAwesome7IconType face_angry_s = on(FontAwesome7Solid.face_angry).build();
    public static final FontAwesome7IconType face_dizzy_r = on(FontAwesome7Regular.face_dizzy).build();
    public static final FontAwesome7IconType face_dizzy_s = on(FontAwesome7Solid.face_dizzy).build();
    public static final FontAwesome7IconType face_flushed_r = on(FontAwesome7Regular.face_flushed).build();
    public static final FontAwesome7IconType face_flushed_s = on(FontAwesome7Solid.face_flushed).build();
    public static final FontAwesome7IconType face_frown_open_r = on(FontAwesome7Regular.face_frown_open).build();
    public static final FontAwesome7IconType face_frown_open_s = on(FontAwesome7Solid.face_frown_open).build();
    public static final FontAwesome7IconType face_frown_r = on(FontAwesome7Regular.face_frown).build();
    public static final FontAwesome7IconType face_frown_s = on(FontAwesome7Solid.face_frown).build();
    public static final FontAwesome7IconType face_grimace_r = on(FontAwesome7Regular.face_grimace).build();
    public static final FontAwesome7IconType face_grimace_s = on(FontAwesome7Solid.face_grimace).build();
    public static final FontAwesome7IconType face_grin_beam_r = on(FontAwesome7Regular.face_grin_beam).build();
    public static final FontAwesome7IconType face_grin_beam_s = on(FontAwesome7Solid.face_grin_beam).build();
    public static final FontAwesome7IconType face_grin_beam_sweat_r = on(FontAwesome7Regular.face_grin_beam_sweat).build();
    public static final FontAwesome7IconType face_grin_beam_sweat_s = on(FontAwesome7Solid.face_grin_beam_sweat).build();
    public static final FontAwesome7IconType face_grin_hearts_r = on(FontAwesome7Regular.face_grin_hearts).build();
    public static final FontAwesome7IconType face_grin_hearts_s = on(FontAwesome7Solid.face_grin_hearts).build();
    public static final FontAwesome7IconType face_grin_r = on(FontAwesome7Regular.face_grin).build();
    public static final FontAwesome7IconType face_grin_s = on(FontAwesome7Solid.face_grin).build();
    public static final FontAwesome7IconType face_grin_squint_r = on(FontAwesome7Regular.face_grin_squint).build();
    public static final FontAwesome7IconType face_grin_squint_s = on(FontAwesome7Solid.face_grin_squint).build();
    public static final FontAwesome7IconType face_grin_squint_tears_r = on(FontAwesome7Regular.face_grin_squint_tears).build();
    public static final FontAwesome7IconType face_grin_squint_tears_s = on(FontAwesome7Solid.face_grin_squint_tears).build();
    public static final FontAwesome7IconType face_grin_stars_r = on(FontAwesome7Regular.face_grin_stars).build();
    public static final FontAwesome7IconType face_grin_stars_s = on(FontAwesome7Solid.face_grin_stars).build();
    public static final FontAwesome7IconType face_grin_tears_r = on(FontAwesome7Regular.face_grin_tears).build();
    public static final FontAwesome7IconType face_grin_tears_s = on(FontAwesome7Solid.face_grin_tears).build();
    public static final FontAwesome7IconType face_grin_tongue_r = on(FontAwesome7Regular.face_grin_tongue).build();
    public static final FontAwesome7IconType face_grin_tongue_s = on(FontAwesome7Solid.face_grin_tongue).build();
    public static final FontAwesome7IconType face_grin_tongue_squint_r = on(FontAwesome7Regular.face_grin_tongue_squint).build();
    public static final FontAwesome7IconType face_grin_tongue_squint_s = on(FontAwesome7Solid.face_grin_tongue_squint).build();
    public static final FontAwesome7IconType face_grin_tongue_wink_r = on(FontAwesome7Regular.face_grin_tongue_wink).build();
    public static final FontAwesome7IconType face_grin_tongue_wink_s = on(FontAwesome7Solid.face_grin_tongue_wink).build();
    public static final FontAwesome7IconType face_grin_wide_r = on(FontAwesome7Regular.face_grin_wide).build();
    public static final FontAwesome7IconType face_grin_wide_s = on(FontAwesome7Solid.face_grin_wide).build();
    public static final FontAwesome7IconType face_grin_wink_r = on(FontAwesome7Regular.face_grin_wink).build();
    public static final FontAwesome7IconType face_grin_wink_s = on(FontAwesome7Solid.face_grin_wink).build();
    public static final FontAwesome7IconType face_kiss_beam_r = on(FontAwesome7Regular.face_kiss_beam).build();
    public static final FontAwesome7IconType face_kiss_beam_s = on(FontAwesome7Solid.face_kiss_beam).build();
    public static final FontAwesome7IconType face_kiss_r = on(FontAwesome7Regular.face_kiss).build();
    public static final FontAwesome7IconType face_kiss_s = on(FontAwesome7Solid.face_kiss).build();
    public static final FontAwesome7IconType face_kiss_wink_heart_r = on(FontAwesome7Regular.face_kiss_wink_heart).build();
    public static final FontAwesome7IconType face_kiss_wink_heart_s = on(FontAwesome7Solid.face_kiss_wink_heart).build();
    public static final FontAwesome7IconType face_laugh_beam_r = on(FontAwesome7Regular.face_laugh_beam).build();
    public static final FontAwesome7IconType face_laugh_beam_s = on(FontAwesome7Solid.face_laugh_beam).build();
    public static final FontAwesome7IconType face_laugh_r = on(FontAwesome7Regular.face_laugh).build();
    public static final FontAwesome7IconType face_laugh_s = on(FontAwesome7Solid.face_laugh).build();
    public static final FontAwesome7IconType face_laugh_squint_r = on(FontAwesome7Regular.face_laugh_squint).build();
    public static final FontAwesome7IconType face_laugh_squint_s = on(FontAwesome7Solid.face_laugh_squint).build();
    public static final FontAwesome7IconType face_laugh_wink_r = on(FontAwesome7Regular.face_laugh_wink).build();
    public static final FontAwesome7IconType face_laugh_wink_s = on(FontAwesome7Solid.face_laugh_wink).build();
    public static final FontAwesome7IconType face_meh_blank_r = on(FontAwesome7Regular.face_meh_blank).build();
    public static final FontAwesome7IconType face_meh_blank_s = on(FontAwesome7Solid.face_meh_blank).build();
    public static final FontAwesome7IconType face_meh_r = on(FontAwesome7Regular.face_meh).build();
    public static final FontAwesome7IconType face_meh_s = on(FontAwesome7Solid.face_meh).build();
    public static final FontAwesome7IconType face_rolling_eyes_r = on(FontAwesome7Regular.face_rolling_eyes).build();
    public static final FontAwesome7IconType face_rolling_eyes_s = on(FontAwesome7Solid.face_rolling_eyes).build();
    public static final FontAwesome7IconType face_sad_cry_r = on(FontAwesome7Regular.face_sad_cry).build();
    public static final FontAwesome7IconType face_sad_cry_s = on(FontAwesome7Solid.face_sad_cry).build();
    public static final FontAwesome7IconType face_sad_tear_r = on(FontAwesome7Regular.face_sad_tear).build();
    public static final FontAwesome7IconType face_sad_tear_s = on(FontAwesome7Solid.face_sad_tear).build();
    public static final FontAwesome7IconType face_smile_beam_r = on(FontAwesome7Regular.face_smile_beam).build();
    public static final FontAwesome7IconType face_smile_beam_s = on(FontAwesome7Solid.face_smile_beam).build();
    public static final FontAwesome7IconType face_smile_r = on(FontAwesome7Regular.face_smile).build();
    public static final FontAwesome7IconType face_smile_s = on(FontAwesome7Solid.face_smile).build();
    public static final FontAwesome7IconType face_smile_wink_r = on(FontAwesome7Regular.face_smile_wink).build();
    public static final FontAwesome7IconType face_smile_wink_s = on(FontAwesome7Solid.face_smile_wink).build();
    public static final FontAwesome7IconType face_surprise_r = on(FontAwesome7Regular.face_surprise).build();
    public static final FontAwesome7IconType face_surprise_s = on(FontAwesome7Solid.face_surprise).build();
    public static final FontAwesome7IconType face_tired_r = on(FontAwesome7Regular.face_tired).build();
    public static final FontAwesome7IconType face_tired_s = on(FontAwesome7Solid.face_tired).build();
    public static final FontAwesome7IconType fan_s = on(FontAwesome7Solid.fan).build();
    public static final FontAwesome7IconType fast_backward_s = on(FontAwesome7Solid.fast_backward).build();
    public static final FontAwesome7IconType fast_forward_s = on(FontAwesome7Solid.fast_forward).build();
    public static final FontAwesome7IconType faucet_drip_s = on(FontAwesome7Solid.faucet_drip).build();
    public static final FontAwesome7IconType faucet_s = on(FontAwesome7Solid.faucet).build();
    public static final FontAwesome7IconType fax_s = on(FontAwesome7Solid.fax).build();
    public static final FontAwesome7IconType feather_alt_s = on(FontAwesome7Solid.feather_alt).build();
    public static final FontAwesome7IconType feather_pointed_s = on(FontAwesome7Solid.feather_pointed).build();
    public static final FontAwesome7IconType feather_s = on(FontAwesome7Solid.feather).build();
    public static final FontAwesome7IconType feed_s = on(FontAwesome7Solid.feed).build();
    public static final FontAwesome7IconType female_s = on(FontAwesome7Solid.female).build();
    public static final FontAwesome7IconType ferry_s = on(FontAwesome7Solid.ferry).build();
    public static final FontAwesome7IconType fighter_jet_s = on(FontAwesome7Solid.fighter_jet).build();
    public static final FontAwesome7IconType file_alt_r = on(FontAwesome7Regular.file_alt).build();
    public static final FontAwesome7IconType file_alt_s = on(FontAwesome7Solid.file_alt).build();
    public static final FontAwesome7IconType file_archive_r = on(FontAwesome7Regular.file_archive).build();
    public static final FontAwesome7IconType file_archive_s = on(FontAwesome7Solid.file_archive).build();
    public static final FontAwesome7IconType file_arrow_down_s = on(FontAwesome7Solid.file_arrow_down).build();
    public static final FontAwesome7IconType file_arrow_up_s = on(FontAwesome7Solid.file_arrow_up).build();
    public static final FontAwesome7IconType file_audio_r = on(FontAwesome7Regular.file_audio).build();
    public static final FontAwesome7IconType file_audio_s = on(FontAwesome7Solid.file_audio).build();
    public static final FontAwesome7IconType file_circle_check_s = on(FontAwesome7Solid.file_circle_check).build();
    public static final FontAwesome7IconType file_circle_exclamation_s = on(FontAwesome7Solid.file_circle_exclamation).build();
    public static final FontAwesome7IconType file_circle_minus_s = on(FontAwesome7Solid.file_circle_minus).build();
    public static final FontAwesome7IconType file_circle_plus_s = on(FontAwesome7Solid.file_circle_plus).build();
    public static final FontAwesome7IconType file_circle_question_s = on(FontAwesome7Solid.file_circle_question).build();
    public static final FontAwesome7IconType file_circle_xmark_s = on(FontAwesome7Solid.file_circle_xmark).build();
    public static final FontAwesome7IconType file_clipboard_r = on(FontAwesome7Regular.file_clipboard).build();
    public static final FontAwesome7IconType file_clipboard_s = on(FontAwesome7Solid.file_clipboard).build();
    public static final FontAwesome7IconType file_code_r = on(FontAwesome7Regular.file_code).build();
    public static final FontAwesome7IconType file_code_s = on(FontAwesome7Solid.file_code).build();
    public static final FontAwesome7IconType file_contract_s = on(FontAwesome7Solid.file_contract).build();
    public static final FontAwesome7IconType file_csv_s = on(FontAwesome7Solid.file_csv).build();
    public static final FontAwesome7IconType file_download_s = on(FontAwesome7Solid.file_download).build();
    public static final FontAwesome7IconType file_edit_s = on(FontAwesome7Solid.file_edit).build();
    public static final FontAwesome7IconType file_excel_r = on(FontAwesome7Regular.file_excel).build();
    public static final FontAwesome7IconType file_excel_s = on(FontAwesome7Solid.file_excel).build();
    public static final FontAwesome7IconType file_export_s = on(FontAwesome7Solid.file_export).build();
    public static final FontAwesome7IconType file_fragment_s = on(FontAwesome7Solid.file_fragment).build();
    public static final FontAwesome7IconType file_half_dashed_s = on(FontAwesome7Solid.file_half_dashed).build();
    public static final FontAwesome7IconType file_image_r = on(FontAwesome7Regular.file_image).build();
    public static final FontAwesome7IconType file_image_s = on(FontAwesome7Solid.file_image).build();
    public static final FontAwesome7IconType file_import_s = on(FontAwesome7Solid.file_import).build();
    public static final FontAwesome7IconType file_invoice_dollar_s = on(FontAwesome7Solid.file_invoice_dollar).build();
    public static final FontAwesome7IconType file_invoice_s = on(FontAwesome7Solid.file_invoice).build();
    public static final FontAwesome7IconType file_lines_r = on(FontAwesome7Regular.file_lines).build();
    public static final FontAwesome7IconType file_lines_s = on(FontAwesome7Solid.file_lines).build();
    public static final FontAwesome7IconType file_medical_alt_s = on(FontAwesome7Solid.file_medical_alt).build();
    public static final FontAwesome7IconType file_medical_s = on(FontAwesome7Solid.file_medical).build();
    public static final FontAwesome7IconType file_pdf_r = on(FontAwesome7Regular.file_pdf).build();
    public static final FontAwesome7IconType file_pdf_s = on(FontAwesome7Solid.file_pdf).build();
    public static final FontAwesome7IconType file_pen_s = on(FontAwesome7Solid.file_pen).build();
    public static final FontAwesome7IconType file_powerpoint_r = on(FontAwesome7Regular.file_powerpoint).build();
    public static final FontAwesome7IconType file_powerpoint_s = on(FontAwesome7Solid.file_powerpoint).build();
    public static final FontAwesome7IconType file_prescription_s = on(FontAwesome7Solid.file_prescription).build();
    public static final FontAwesome7IconType file_r = on(FontAwesome7Regular.file).build();
    public static final FontAwesome7IconType file_s = on(FontAwesome7Solid.file).build();
    public static final FontAwesome7IconType file_shield_s = on(FontAwesome7Solid.file_shield).build();
    public static final FontAwesome7IconType file_signature_s = on(FontAwesome7Solid.file_signature).build();
    public static final FontAwesome7IconType file_text_r = on(FontAwesome7Regular.file_text).build();
    public static final FontAwesome7IconType file_text_s = on(FontAwesome7Solid.file_text).build();
    public static final FontAwesome7IconType file_upload_s = on(FontAwesome7Solid.file_upload).build();
    public static final FontAwesome7IconType file_video_r = on(FontAwesome7Regular.file_video).build();
    public static final FontAwesome7IconType file_video_s = on(FontAwesome7Solid.file_video).build();
    public static final FontAwesome7IconType file_waveform_s = on(FontAwesome7Solid.file_waveform).build();
    public static final FontAwesome7IconType file_word_r = on(FontAwesome7Regular.file_word).build();
    public static final FontAwesome7IconType file_word_s = on(FontAwesome7Solid.file_word).build();
    public static final FontAwesome7IconType file_zipper_r = on(FontAwesome7Regular.file_zipper).build();
    public static final FontAwesome7IconType file_zipper_s = on(FontAwesome7Solid.file_zipper).build();
    public static final FontAwesome7IconType fill_drip_s = on(FontAwesome7Solid.fill_drip).build();
    public static final FontAwesome7IconType fill_s = on(FontAwesome7Solid.fill).build();
    public static final FontAwesome7IconType film_alt_s = on(FontAwesome7Solid.film_alt).build();
    public static final FontAwesome7IconType film_s = on(FontAwesome7Solid.film).build();
    public static final FontAwesome7IconType film_simple_s = on(FontAwesome7Solid.film_simple).build();
    public static final FontAwesome7IconType filter_circle_dollar_s = on(FontAwesome7Solid.filter_circle_dollar).build();
    public static final FontAwesome7IconType filter_circle_xmark_s = on(FontAwesome7Solid.filter_circle_xmark).build();
    public static final FontAwesome7IconType filter_s = on(FontAwesome7Solid.filter).build();
    public static final FontAwesome7IconType fingerprint_s = on(FontAwesome7Solid.fingerprint).build();
    public static final FontAwesome7IconType fire_alt_s = on(FontAwesome7Solid.fire_alt).build();
    public static final FontAwesome7IconType fire_burner_s = on(FontAwesome7Solid.fire_burner).build();
    public static final FontAwesome7IconType fire_extinguisher_s = on(FontAwesome7Solid.fire_extinguisher).build();
    public static final FontAwesome7IconType fire_flame_curved_s = on(FontAwesome7Solid.fire_flame_curved).build();
    public static final FontAwesome7IconType fire_flame_simple_s = on(FontAwesome7Solid.fire_flame_simple).build();
    public static final FontAwesome7IconType fire_s = on(FontAwesome7Solid.fire).build();
    public static final FontAwesome7IconType first_aid_s = on(FontAwesome7Solid.first_aid).build();
    public static final FontAwesome7IconType fish_fins_s = on(FontAwesome7Solid.fish_fins).build();
    public static final FontAwesome7IconType fish_s = on(FontAwesome7Solid.fish).build();
    public static final FontAwesome7IconType fist_raised_s = on(FontAwesome7Solid.fist_raised).build();
    public static final FontAwesome7IconType flag_checkered_s = on(FontAwesome7Solid.flag_checkered).build();
    public static final FontAwesome7IconType flag_r = on(FontAwesome7Regular.flag).build();
    public static final FontAwesome7IconType flag_s = on(FontAwesome7Solid.flag).build();
    public static final FontAwesome7IconType flag_usa_s = on(FontAwesome7Solid.flag_usa).build();
    public static final FontAwesome7IconType flask_s = on(FontAwesome7Solid.flask).build();
    public static final FontAwesome7IconType flask_vial_s = on(FontAwesome7Solid.flask_vial).build();
    public static final FontAwesome7IconType floppy_disk_r = on(FontAwesome7Regular.floppy_disk).build();
    public static final FontAwesome7IconType floppy_disk_s = on(FontAwesome7Solid.floppy_disk).build();
    public static final FontAwesome7IconType florin_sign_s = on(FontAwesome7Solid.florin_sign).build();
    public static final FontAwesome7IconType flushed_r = on(FontAwesome7Regular.flushed).build();
    public static final FontAwesome7IconType flushed_s = on(FontAwesome7Solid.flushed).build();
    public static final FontAwesome7IconType folder_blank_r = on(FontAwesome7Regular.folder_blank).build();
    public static final FontAwesome7IconType folder_blank_s = on(FontAwesome7Solid.folder_blank).build();
    public static final FontAwesome7IconType folder_closed_r = on(FontAwesome7Regular.folder_closed).build();
    public static final FontAwesome7IconType folder_closed_s = on(FontAwesome7Solid.folder_closed).build();
    public static final FontAwesome7IconType folder_minus_s = on(FontAwesome7Solid.folder_minus).build();
    public static final FontAwesome7IconType folder_open_r = on(FontAwesome7Regular.folder_open).build();
    public static final FontAwesome7IconType folder_open_s = on(FontAwesome7Solid.folder_open).build();
    public static final FontAwesome7IconType folder_plus_s = on(FontAwesome7Solid.folder_plus).build();
    public static final FontAwesome7IconType folder_r = on(FontAwesome7Regular.folder).build();
    public static final FontAwesome7IconType folder_s = on(FontAwesome7Solid.folder).build();
    public static final FontAwesome7IconType folder_tree_s = on(FontAwesome7Solid.folder_tree).build();
    public static final FontAwesome7IconType font_awesome_flag_r = on(FontAwesome7Regular.font_awesome_flag).build();
    public static final FontAwesome7IconType font_awesome_flag_s = on(FontAwesome7Solid.font_awesome_flag).build();
    public static final FontAwesome7IconType font_awesome_logo_full_r = on(FontAwesome7Regular.font_awesome_logo_full).build();
    public static final FontAwesome7IconType font_awesome_logo_full_s = on(FontAwesome7Solid.font_awesome_logo_full).build();
    public static final FontAwesome7IconType font_awesome_r = on(FontAwesome7Regular.font_awesome).build();
    public static final FontAwesome7IconType font_awesome_s = on(FontAwesome7Solid.font_awesome).build();
    public static final FontAwesome7IconType font_s = on(FontAwesome7Solid.font).build();
    public static final FontAwesome7IconType football_ball_s = on(FontAwesome7Solid.football_ball).build();
    public static final FontAwesome7IconType football_s = on(FontAwesome7Solid.football).build();
    public static final FontAwesome7IconType forward_fast_s = on(FontAwesome7Solid.forward_fast).build();
    public static final FontAwesome7IconType forward_s = on(FontAwesome7Solid.forward).build();
    public static final FontAwesome7IconType forward_step_s = on(FontAwesome7Solid.forward_step).build();
    public static final FontAwesome7IconType franc_sign_s = on(FontAwesome7Solid.franc_sign).build();
    public static final FontAwesome7IconType frog_s = on(FontAwesome7Solid.frog).build();
    public static final FontAwesome7IconType frown_open_r = on(FontAwesome7Regular.frown_open).build();
    public static final FontAwesome7IconType frown_open_s = on(FontAwesome7Solid.frown_open).build();
    public static final FontAwesome7IconType frown_r = on(FontAwesome7Regular.frown).build();
    public static final FontAwesome7IconType frown_s = on(FontAwesome7Solid.frown).build();
    public static final FontAwesome7IconType funnel_dollar_s = on(FontAwesome7Solid.funnel_dollar).build();
    public static final FontAwesome7IconType futbol_ball_r = on(FontAwesome7Regular.futbol_ball).build();
    public static final FontAwesome7IconType futbol_ball_s = on(FontAwesome7Solid.futbol_ball).build();
    public static final FontAwesome7IconType futbol_r = on(FontAwesome7Regular.futbol).build();
    public static final FontAwesome7IconType futbol_s = on(FontAwesome7Solid.futbol).build();
    public static final FontAwesome7IconType g_s = on(FontAwesome7Solid.g).build();
    public static final FontAwesome7IconType gamepad_s = on(FontAwesome7Solid.gamepad).build();
    public static final FontAwesome7IconType gas_pump_s = on(FontAwesome7Solid.gas_pump).build();
    public static final FontAwesome7IconType gauge_high_s = on(FontAwesome7Solid.gauge_high).build();
    public static final FontAwesome7IconType gauge_med_s = on(FontAwesome7Solid.gauge_med).build();
    public static final FontAwesome7IconType gauge_s = on(FontAwesome7Solid.gauge).build();
    public static final FontAwesome7IconType gauge_simple_high_s = on(FontAwesome7Solid.gauge_simple_high).build();
    public static final FontAwesome7IconType gauge_simple_med_s = on(FontAwesome7Solid.gauge_simple_med).build();
    public static final FontAwesome7IconType gauge_simple_s = on(FontAwesome7Solid.gauge_simple).build();
    public static final FontAwesome7IconType gavel_s = on(FontAwesome7Solid.gavel).build();
    public static final FontAwesome7IconType gbp_s = on(FontAwesome7Solid.gbp).build();
    public static final FontAwesome7IconType gear_s = on(FontAwesome7Solid.gear).build();
    public static final FontAwesome7IconType gears_s = on(FontAwesome7Solid.gears).build();
    public static final FontAwesome7IconType gem_r = on(FontAwesome7Regular.gem).build();
    public static final FontAwesome7IconType gem_s = on(FontAwesome7Solid.gem).build();
    public static final FontAwesome7IconType genderless_s = on(FontAwesome7Solid.genderless).build();
    public static final FontAwesome7IconType ghost_s = on(FontAwesome7Solid.ghost).build();
    public static final FontAwesome7IconType gift_s = on(FontAwesome7Solid.gift).build();
    public static final FontAwesome7IconType gifts_s = on(FontAwesome7Solid.gifts).build();
    public static final FontAwesome7IconType glass_cheers_s = on(FontAwesome7Solid.glass_cheers).build();
    public static final FontAwesome7IconType glass_martini_alt_s = on(FontAwesome7Solid.glass_martini_alt).build();
    public static final FontAwesome7IconType glass_martini_s = on(FontAwesome7Solid.glass_martini).build();
    public static final FontAwesome7IconType glass_water_droplet_s = on(FontAwesome7Solid.glass_water_droplet).build();
    public static final FontAwesome7IconType glass_water_s = on(FontAwesome7Solid.glass_water).build();
    public static final FontAwesome7IconType glass_whiskey_s = on(FontAwesome7Solid.glass_whiskey).build();
    public static final FontAwesome7IconType glasses_s = on(FontAwesome7Solid.glasses).build();
    public static final FontAwesome7IconType globe_africa_s = on(FontAwesome7Solid.globe_africa).build();
    public static final FontAwesome7IconType globe_americas_s = on(FontAwesome7Solid.globe_americas).build();
    public static final FontAwesome7IconType globe_asia_s = on(FontAwesome7Solid.globe_asia).build();
    public static final FontAwesome7IconType globe_europe_s = on(FontAwesome7Solid.globe_europe).build();
    public static final FontAwesome7IconType globe_oceania_s = on(FontAwesome7Solid.globe_oceania).build();
    public static final FontAwesome7IconType globe_s = on(FontAwesome7Solid.globe).build();
    public static final FontAwesome7IconType golf_ball_s = on(FontAwesome7Solid.golf_ball).build();
    public static final FontAwesome7IconType golf_ball_tee_s = on(FontAwesome7Solid.golf_ball_tee).build();
    public static final FontAwesome7IconType gopuram_s = on(FontAwesome7Solid.gopuram).build();
    public static final FontAwesome7IconType graduation_cap_s = on(FontAwesome7Solid.graduation_cap).build();
    public static final FontAwesome7IconType greater_than_equal_s = on(FontAwesome7Solid.greater_than_equal).build();
    public static final FontAwesome7IconType greater_than_s = on(FontAwesome7Solid.greater_than).build();
    public static final FontAwesome7IconType grid_horizontal_s = on(FontAwesome7Solid.grid_horizontal).build();
    public static final FontAwesome7IconType grid_vertical_s = on(FontAwesome7Solid.grid_vertical).build();
    public static final FontAwesome7IconType grimace_r = on(FontAwesome7Regular.grimace).build();
    public static final FontAwesome7IconType grimace_s = on(FontAwesome7Solid.grimace).build();
    public static final FontAwesome7IconType grin_alt_r = on(FontAwesome7Regular.grin_alt).build();
    public static final FontAwesome7IconType grin_alt_s = on(FontAwesome7Solid.grin_alt).build();
    public static final FontAwesome7IconType grin_beam_r = on(FontAwesome7Regular.grin_beam).build();
    public static final FontAwesome7IconType grin_beam_s = on(FontAwesome7Solid.grin_beam).build();
    public static final FontAwesome7IconType grin_beam_sweat_r = on(FontAwesome7Regular.grin_beam_sweat).build();
    public static final FontAwesome7IconType grin_beam_sweat_s = on(FontAwesome7Solid.grin_beam_sweat).build();
    public static final FontAwesome7IconType grin_hearts_r = on(FontAwesome7Regular.grin_hearts).build();
    public static final FontAwesome7IconType grin_hearts_s = on(FontAwesome7Solid.grin_hearts).build();
    public static final FontAwesome7IconType grin_r = on(FontAwesome7Regular.grin).build();
    public static final FontAwesome7IconType grin_s = on(FontAwesome7Solid.grin).build();
    public static final FontAwesome7IconType grin_squint_r = on(FontAwesome7Regular.grin_squint).build();
    public static final FontAwesome7IconType grin_squint_s = on(FontAwesome7Solid.grin_squint).build();
    public static final FontAwesome7IconType grin_squint_tears_r = on(FontAwesome7Regular.grin_squint_tears).build();
    public static final FontAwesome7IconType grin_squint_tears_s = on(FontAwesome7Solid.grin_squint_tears).build();
    public static final FontAwesome7IconType grin_stars_r = on(FontAwesome7Regular.grin_stars).build();
    public static final FontAwesome7IconType grin_stars_s = on(FontAwesome7Solid.grin_stars).build();
    public static final FontAwesome7IconType grin_tears_r = on(FontAwesome7Regular.grin_tears).build();
    public static final FontAwesome7IconType grin_tears_s = on(FontAwesome7Solid.grin_tears).build();
    public static final FontAwesome7IconType grin_tongue_r = on(FontAwesome7Regular.grin_tongue).build();
    public static final FontAwesome7IconType grin_tongue_s = on(FontAwesome7Solid.grin_tongue).build();
    public static final FontAwesome7IconType grin_tongue_squint_r = on(FontAwesome7Regular.grin_tongue_squint).build();
    public static final FontAwesome7IconType grin_tongue_squint_s = on(FontAwesome7Solid.grin_tongue_squint).build();
    public static final FontAwesome7IconType grin_tongue_wink_r = on(FontAwesome7Regular.grin_tongue_wink).build();
    public static final FontAwesome7IconType grin_tongue_wink_s = on(FontAwesome7Solid.grin_tongue_wink).build();
    public static final FontAwesome7IconType grin_wink_r = on(FontAwesome7Regular.grin_wink).build();
    public static final FontAwesome7IconType grin_wink_s = on(FontAwesome7Solid.grin_wink).build();
    public static final FontAwesome7IconType grip_horizontal_s = on(FontAwesome7Solid.grip_horizontal).build();
    public static final FontAwesome7IconType grip_lines_s = on(FontAwesome7Solid.grip_lines).build();
    public static final FontAwesome7IconType grip_lines_vertical_s = on(FontAwesome7Solid.grip_lines_vertical).build();
    public static final FontAwesome7IconType grip_s = on(FontAwesome7Solid.grip).build();
    public static final FontAwesome7IconType grip_vertical_s = on(FontAwesome7Solid.grip_vertical).build();
    public static final FontAwesome7IconType group_arrows_rotate_s = on(FontAwesome7Solid.group_arrows_rotate).build();
    public static final FontAwesome7IconType guarani_sign_s = on(FontAwesome7Solid.guarani_sign).build();
    public static final FontAwesome7IconType guitar_s = on(FontAwesome7Solid.guitar).build();
    public static final FontAwesome7IconType gun_s = on(FontAwesome7Solid.gun).build();
    public static final FontAwesome7IconType h_s = on(FontAwesome7Solid.h).build();
    public static final FontAwesome7IconType h_square_s = on(FontAwesome7Solid.h_square).build();
    public static final FontAwesome7IconType hamburger_s = on(FontAwesome7Solid.hamburger).build();
    public static final FontAwesome7IconType hammer_s = on(FontAwesome7Solid.hammer).build();
    public static final FontAwesome7IconType hamsa_s = on(FontAwesome7Solid.hamsa).build();
    public static final FontAwesome7IconType hand_back_fist_r = on(FontAwesome7Regular.hand_back_fist).build();
    public static final FontAwesome7IconType hand_back_fist_s = on(FontAwesome7Solid.hand_back_fist).build();
    public static final FontAwesome7IconType hand_dots_s = on(FontAwesome7Solid.hand_dots).build();
    public static final FontAwesome7IconType hand_fist_s = on(FontAwesome7Solid.hand_fist).build();
    public static final FontAwesome7IconType hand_holding_dollar_s = on(FontAwesome7Solid.hand_holding_dollar).build();
    public static final FontAwesome7IconType hand_holding_droplet_s = on(FontAwesome7Solid.hand_holding_droplet).build();
    public static final FontAwesome7IconType hand_holding_hand_s = on(FontAwesome7Solid.hand_holding_hand).build();
    public static final FontAwesome7IconType hand_holding_heart_s = on(FontAwesome7Solid.hand_holding_heart).build();
    public static final FontAwesome7IconType hand_holding_medical_s = on(FontAwesome7Solid.hand_holding_medical).build();
    public static final FontAwesome7IconType hand_holding_s = on(FontAwesome7Solid.hand_holding).build();
    public static final FontAwesome7IconType hand_holding_usd_s = on(FontAwesome7Solid.hand_holding_usd).build();
    public static final FontAwesome7IconType hand_holding_water_s = on(FontAwesome7Solid.hand_holding_water).build();
    public static final FontAwesome7IconType hand_lizard_r = on(FontAwesome7Regular.hand_lizard).build();
    public static final FontAwesome7IconType hand_lizard_s = on(FontAwesome7Solid.hand_lizard).build();
    public static final FontAwesome7IconType hand_middle_finger_s = on(FontAwesome7Solid.hand_middle_finger).build();
    public static final FontAwesome7IconType hand_paper_r = on(FontAwesome7Regular.hand_paper).build();
    public static final FontAwesome7IconType hand_paper_s = on(FontAwesome7Solid.hand_paper).build();
    public static final FontAwesome7IconType hand_peace_r = on(FontAwesome7Regular.hand_peace).build();
    public static final FontAwesome7IconType hand_peace_s = on(FontAwesome7Solid.hand_peace).build();
    public static final FontAwesome7IconType hand_point_down_r = on(FontAwesome7Regular.hand_point_down).build();
    public static final FontAwesome7IconType hand_point_down_s = on(FontAwesome7Solid.hand_point_down).build();
    public static final FontAwesome7IconType hand_point_left_r = on(FontAwesome7Regular.hand_point_left).build();
    public static final FontAwesome7IconType hand_point_left_s = on(FontAwesome7Solid.hand_point_left).build();
    public static final FontAwesome7IconType hand_point_right_r = on(FontAwesome7Regular.hand_point_right).build();
    public static final FontAwesome7IconType hand_point_right_s = on(FontAwesome7Solid.hand_point_right).build();
    public static final FontAwesome7IconType hand_point_up_r = on(FontAwesome7Regular.hand_point_up).build();
    public static final FontAwesome7IconType hand_point_up_s = on(FontAwesome7Solid.hand_point_up).build();
    public static final FontAwesome7IconType hand_pointer_r = on(FontAwesome7Regular.hand_pointer).build();
    public static final FontAwesome7IconType hand_pointer_s = on(FontAwesome7Solid.hand_pointer).build();
    public static final FontAwesome7IconType hand_r = on(FontAwesome7Regular.hand).build();
    public static final FontAwesome7IconType hand_rock_r = on(FontAwesome7Regular.hand_rock).build();
    public static final FontAwesome7IconType hand_rock_s = on(FontAwesome7Solid.hand_rock).build();
    public static final FontAwesome7IconType hand_s = on(FontAwesome7Solid.hand).build();
    public static final FontAwesome7IconType hand_scissors_r = on(FontAwesome7Regular.hand_scissors).build();
    public static final FontAwesome7IconType hand_scissors_s = on(FontAwesome7Solid.hand_scissors).build();
    public static final FontAwesome7IconType hand_sparkles_s = on(FontAwesome7Solid.hand_sparkles).build();
    public static final FontAwesome7IconType hand_spock_r = on(FontAwesome7Regular.hand_spock).build();
    public static final FontAwesome7IconType hand_spock_s = on(FontAwesome7Solid.hand_spock).build();
    public static final FontAwesome7IconType handcuffs_s = on(FontAwesome7Solid.handcuffs).build();
    public static final FontAwesome7IconType hands_american_sign_language_interpreting_s = on(FontAwesome7Solid.hands_american_sign_language_interpreting).build();
    public static final FontAwesome7IconType hands_asl_interpreting_s = on(FontAwesome7Solid.hands_asl_interpreting).build();
    public static final FontAwesome7IconType hands_bound_s = on(FontAwesome7Solid.hands_bound).build();
    public static final FontAwesome7IconType hands_bubbles_s = on(FontAwesome7Solid.hands_bubbles).build();
    public static final FontAwesome7IconType hands_clapping_s = on(FontAwesome7Solid.hands_clapping).build();
    public static final FontAwesome7IconType hands_helping_s = on(FontAwesome7Solid.hands_helping).build();
    public static final FontAwesome7IconType hands_holding_child_s = on(FontAwesome7Solid.hands_holding_child).build();
    public static final FontAwesome7IconType hands_holding_circle_s = on(FontAwesome7Solid.hands_holding_circle).build();
    public static final FontAwesome7IconType hands_holding_s = on(FontAwesome7Solid.hands_holding).build();
    public static final FontAwesome7IconType hands_praying_s = on(FontAwesome7Solid.hands_praying).build();
    public static final FontAwesome7IconType hands_s = on(FontAwesome7Solid.hands).build();
    public static final FontAwesome7IconType hands_wash_s = on(FontAwesome7Solid.hands_wash).build();
    public static final FontAwesome7IconType handshake_alt_r = on(FontAwesome7Regular.handshake_alt).build();
    public static final FontAwesome7IconType handshake_alt_s = on(FontAwesome7Solid.handshake_alt).build();
    public static final FontAwesome7IconType handshake_alt_slash_s = on(FontAwesome7Solid.handshake_alt_slash).build();
    public static final FontAwesome7IconType handshake_angle_s = on(FontAwesome7Solid.handshake_angle).build();
    public static final FontAwesome7IconType handshake_r = on(FontAwesome7Regular.handshake).build();
    public static final FontAwesome7IconType handshake_s = on(FontAwesome7Solid.handshake).build();
    public static final FontAwesome7IconType handshake_simple_r = on(FontAwesome7Regular.handshake_simple).build();
    public static final FontAwesome7IconType handshake_simple_s = on(FontAwesome7Solid.handshake_simple).build();
    public static final FontAwesome7IconType handshake_simple_slash_s = on(FontAwesome7Solid.handshake_simple_slash).build();
    public static final FontAwesome7IconType handshake_slash_s = on(FontAwesome7Solid.handshake_slash).build();
    public static final FontAwesome7IconType hanukiah_s = on(FontAwesome7Solid.hanukiah).build();
    public static final FontAwesome7IconType hard_drive_r = on(FontAwesome7Regular.hard_drive).build();
    public static final FontAwesome7IconType hard_drive_s = on(FontAwesome7Solid.hard_drive).build();
    public static final FontAwesome7IconType hard_hat_s = on(FontAwesome7Solid.hard_hat).build();
    public static final FontAwesome7IconType hard_of_hearing_s = on(FontAwesome7Solid.hard_of_hearing).build();
    public static final FontAwesome7IconType hashtag_s = on(FontAwesome7Solid.hashtag).build();
    public static final FontAwesome7IconType hat_cowboy_s = on(FontAwesome7Solid.hat_cowboy).build();
    public static final FontAwesome7IconType hat_cowboy_side_s = on(FontAwesome7Solid.hat_cowboy_side).build();
    public static final FontAwesome7IconType hat_hard_s = on(FontAwesome7Solid.hat_hard).build();
    public static final FontAwesome7IconType hat_wizard_s = on(FontAwesome7Solid.hat_wizard).build();
    public static final FontAwesome7IconType haykal_s = on(FontAwesome7Solid.haykal).build();
    public static final FontAwesome7IconType hdd_r = on(FontAwesome7Regular.hdd).build();
    public static final FontAwesome7IconType hdd_s = on(FontAwesome7Solid.hdd).build();
    public static final FontAwesome7IconType head_side_cough_s = on(FontAwesome7Solid.head_side_cough).build();
    public static final FontAwesome7IconType head_side_cough_slash_s = on(FontAwesome7Solid.head_side_cough_slash).build();
    public static final FontAwesome7IconType head_side_mask_s = on(FontAwesome7Solid.head_side_mask).build();
    public static final FontAwesome7IconType head_side_virus_s = on(FontAwesome7Solid.head_side_virus).build();
    public static final FontAwesome7IconType header_s = on(FontAwesome7Solid.header).build();
    public static final FontAwesome7IconType heading_s = on(FontAwesome7Solid.heading).build();
    public static final FontAwesome7IconType headphones_alt_r = on(FontAwesome7Regular.headphones_alt).build();
    public static final FontAwesome7IconType headphones_alt_s = on(FontAwesome7Solid.headphones_alt).build();
    public static final FontAwesome7IconType headphones_r = on(FontAwesome7Regular.headphones).build();
    public static final FontAwesome7IconType headphones_s = on(FontAwesome7Solid.headphones).build();
    public static final FontAwesome7IconType headphones_simple_r = on(FontAwesome7Regular.headphones_simple).build();
    public static final FontAwesome7IconType headphones_simple_s = on(FontAwesome7Solid.headphones_simple).build();
    public static final FontAwesome7IconType headset_s = on(FontAwesome7Solid.headset).build();
    public static final FontAwesome7IconType heart_broken_s = on(FontAwesome7Solid.heart_broken).build();
    public static final FontAwesome7IconType heart_circle_bolt_s = on(FontAwesome7Solid.heart_circle_bolt).build();
    public static final FontAwesome7IconType heart_circle_check_s = on(FontAwesome7Solid.heart_circle_check).build();
    public static final FontAwesome7IconType heart_circle_exclamation_s = on(FontAwesome7Solid.heart_circle_exclamation).build();
    public static final FontAwesome7IconType heart_circle_minus_s = on(FontAwesome7Solid.heart_circle_minus).build();
    public static final FontAwesome7IconType heart_circle_plus_s = on(FontAwesome7Solid.heart_circle_plus).build();
    public static final FontAwesome7IconType heart_circle_xmark_s = on(FontAwesome7Solid.heart_circle_xmark).build();
    public static final FontAwesome7IconType heart_crack_s = on(FontAwesome7Solid.heart_crack).build();
    public static final FontAwesome7IconType heart_music_camera_bolt_s = on(FontAwesome7Solid.heart_music_camera_bolt).build();
    public static final FontAwesome7IconType heart_pulse_s = on(FontAwesome7Solid.heart_pulse).build();
    public static final FontAwesome7IconType heart_r = on(FontAwesome7Regular.heart).build();
    public static final FontAwesome7IconType heart_s = on(FontAwesome7Solid.heart).build();
    public static final FontAwesome7IconType heartbeat_s = on(FontAwesome7Solid.heartbeat).build();
    public static final FontAwesome7IconType helicopter_s = on(FontAwesome7Solid.helicopter).build();
    public static final FontAwesome7IconType helicopter_symbol_s = on(FontAwesome7Solid.helicopter_symbol).build();
    public static final FontAwesome7IconType helmet_safety_s = on(FontAwesome7Solid.helmet_safety).build();
    public static final FontAwesome7IconType helmet_un_s = on(FontAwesome7Solid.helmet_un).build();
    public static final FontAwesome7IconType heptagon_s = on(FontAwesome7Solid.heptagon).build();
    public static final FontAwesome7IconType hexagon_nodes_bolt_s = on(FontAwesome7Solid.hexagon_nodes_bolt).build();
    public static final FontAwesome7IconType hexagon_nodes_s = on(FontAwesome7Solid.hexagon_nodes).build();
    public static final FontAwesome7IconType hexagon_s = on(FontAwesome7Solid.hexagon).build();
    public static final FontAwesome7IconType highlighter_s = on(FontAwesome7Solid.highlighter).build();
    public static final FontAwesome7IconType hiking_s = on(FontAwesome7Solid.hiking).build();
    public static final FontAwesome7IconType hill_avalanche_s = on(FontAwesome7Solid.hill_avalanche).build();
    public static final FontAwesome7IconType hill_rockslide_s = on(FontAwesome7Solid.hill_rockslide).build();
    public static final FontAwesome7IconType hippo_s = on(FontAwesome7Solid.hippo).build();
    public static final FontAwesome7IconType history_s = on(FontAwesome7Solid.history).build();
    public static final FontAwesome7IconType hockey_puck_s = on(FontAwesome7Solid.hockey_puck).build();
    public static final FontAwesome7IconType holly_berry_s = on(FontAwesome7Solid.holly_berry).build();
    public static final FontAwesome7IconType home_alt_r = on(FontAwesome7Regular.home_alt).build();
    public static final FontAwesome7IconType home_alt_s = on(FontAwesome7Solid.home_alt).build();
    public static final FontAwesome7IconType home_lg_alt_r = on(FontAwesome7Regular.home_lg_alt).build();
    public static final FontAwesome7IconType home_lg_alt_s = on(FontAwesome7Solid.home_lg_alt).build();
    public static final FontAwesome7IconType home_lg_s = on(FontAwesome7Solid.home_lg).build();
    public static final FontAwesome7IconType home_r = on(FontAwesome7Regular.home).build();
    public static final FontAwesome7IconType home_s = on(FontAwesome7Solid.home).build();
    public static final FontAwesome7IconType home_user_s = on(FontAwesome7Solid.home_user).build();
    public static final FontAwesome7IconType horse_head_s = on(FontAwesome7Solid.horse_head).build();
    public static final FontAwesome7IconType horse_s = on(FontAwesome7Solid.horse).build();
    public static final FontAwesome7IconType hospital_alt_r = on(FontAwesome7Regular.hospital_alt).build();
    public static final FontAwesome7IconType hospital_alt_s = on(FontAwesome7Solid.hospital_alt).build();
    public static final FontAwesome7IconType hospital_r = on(FontAwesome7Regular.hospital).build();
    public static final FontAwesome7IconType hospital_s = on(FontAwesome7Solid.hospital).build();
    public static final FontAwesome7IconType hospital_symbol_s = on(FontAwesome7Solid.hospital_symbol).build();
    public static final FontAwesome7IconType hospital_user_s = on(FontAwesome7Solid.hospital_user).build();
    public static final FontAwesome7IconType hospital_wide_r = on(FontAwesome7Regular.hospital_wide).build();
    public static final FontAwesome7IconType hospital_wide_s = on(FontAwesome7Solid.hospital_wide).build();
    public static final FontAwesome7IconType hot_tub_person_s = on(FontAwesome7Solid.hot_tub_person).build();
    public static final FontAwesome7IconType hot_tub_s = on(FontAwesome7Solid.hot_tub).build();
    public static final FontAwesome7IconType hotdog_s = on(FontAwesome7Solid.hotdog).build();
    public static final FontAwesome7IconType hotel_s = on(FontAwesome7Solid.hotel).build();
    public static final FontAwesome7IconType hourglass_1_s = on(FontAwesome7Solid.hourglass_1).build();
    public static final FontAwesome7IconType hourglass_2_r = on(FontAwesome7Regular.hourglass_2).build();
    public static final FontAwesome7IconType hourglass_2_s = on(FontAwesome7Solid.hourglass_2).build();
    public static final FontAwesome7IconType hourglass_3_s = on(FontAwesome7Solid.hourglass_3).build();
    public static final FontAwesome7IconType hourglass_empty_r = on(FontAwesome7Regular.hourglass_empty).build();
    public static final FontAwesome7IconType hourglass_empty_s = on(FontAwesome7Solid.hourglass_empty).build();
    public static final FontAwesome7IconType hourglass_end_s = on(FontAwesome7Solid.hourglass_end).build();
    public static final FontAwesome7IconType hourglass_half_r = on(FontAwesome7Regular.hourglass_half).build();
    public static final FontAwesome7IconType hourglass_half_s = on(FontAwesome7Solid.hourglass_half).build();
    public static final FontAwesome7IconType hourglass_r = on(FontAwesome7Regular.hourglass).build();
    public static final FontAwesome7IconType hourglass_s = on(FontAwesome7Solid.hourglass).build();
    public static final FontAwesome7IconType hourglass_start_s = on(FontAwesome7Solid.hourglass_start).build();
    public static final FontAwesome7IconType house_chimney_crack_s = on(FontAwesome7Solid.house_chimney_crack).build();
    public static final FontAwesome7IconType house_chimney_medical_s = on(FontAwesome7Solid.house_chimney_medical).build();
    public static final FontAwesome7IconType house_chimney_s = on(FontAwesome7Solid.house_chimney).build();
    public static final FontAwesome7IconType house_chimney_user_s = on(FontAwesome7Solid.house_chimney_user).build();
    public static final FontAwesome7IconType house_chimney_window_s = on(FontAwesome7Solid.house_chimney_window).build();
    public static final FontAwesome7IconType house_circle_check_s = on(FontAwesome7Solid.house_circle_check).build();
    public static final FontAwesome7IconType house_circle_exclamation_s = on(FontAwesome7Solid.house_circle_exclamation).build();
    public static final FontAwesome7IconType house_circle_xmark_s = on(FontAwesome7Solid.house_circle_xmark).build();
    public static final FontAwesome7IconType house_crack_s = on(FontAwesome7Solid.house_crack).build();
    public static final FontAwesome7IconType house_damage_s = on(FontAwesome7Solid.house_damage).build();
    public static final FontAwesome7IconType house_fire_s = on(FontAwesome7Solid.house_fire).build();
    public static final FontAwesome7IconType house_flag_s = on(FontAwesome7Solid.house_flag).build();
    public static final FontAwesome7IconType house_flood_water_circle_arrow_right_s = on(FontAwesome7Solid.house_flood_water_circle_arrow_right).build();
    public static final FontAwesome7IconType house_flood_water_s = on(FontAwesome7Solid.house_flood_water).build();
    public static final FontAwesome7IconType house_laptop_s = on(FontAwesome7Solid.house_laptop).build();
    public static final FontAwesome7IconType house_lock_s = on(FontAwesome7Solid.house_lock).build();
    public static final FontAwesome7IconType house_medical_circle_check_s = on(FontAwesome7Solid.house_medical_circle_check).build();
    public static final FontAwesome7IconType house_medical_circle_exclamation_s = on(FontAwesome7Solid.house_medical_circle_exclamation).build();
    public static final FontAwesome7IconType house_medical_circle_xmark_s = on(FontAwesome7Solid.house_medical_circle_xmark).build();
    public static final FontAwesome7IconType house_medical_flag_s = on(FontAwesome7Solid.house_medical_flag).build();
    public static final FontAwesome7IconType house_medical_s = on(FontAwesome7Solid.house_medical).build();
    public static final FontAwesome7IconType house_r = on(FontAwesome7Regular.house).build();
    public static final FontAwesome7IconType house_s = on(FontAwesome7Solid.house).build();
    public static final FontAwesome7IconType house_signal_s = on(FontAwesome7Solid.house_signal).build();
    public static final FontAwesome7IconType house_tsunami_s = on(FontAwesome7Solid.house_tsunami).build();
    public static final FontAwesome7IconType house_user_s = on(FontAwesome7Solid.house_user).build();
    public static final FontAwesome7IconType hryvnia_s = on(FontAwesome7Solid.hryvnia).build();
    public static final FontAwesome7IconType hryvnia_sign_s = on(FontAwesome7Solid.hryvnia_sign).build();
    public static final FontAwesome7IconType hurricane_s = on(FontAwesome7Solid.hurricane).build();
    public static final FontAwesome7IconType i_cursor_s = on(FontAwesome7Solid.i_cursor).build();
    public static final FontAwesome7IconType i_s = on(FontAwesome7Solid.i).build();
    public static final FontAwesome7IconType ice_cream_s = on(FontAwesome7Solid.ice_cream).build();
    public static final FontAwesome7IconType icicles_s = on(FontAwesome7Solid.icicles).build();
    public static final FontAwesome7IconType icons_s = on(FontAwesome7Solid.icons).build();
    public static final FontAwesome7IconType id_badge_r = on(FontAwesome7Regular.id_badge).build();
    public static final FontAwesome7IconType id_badge_s = on(FontAwesome7Solid.id_badge).build();
    public static final FontAwesome7IconType id_card_alt_s = on(FontAwesome7Solid.id_card_alt).build();
    public static final FontAwesome7IconType id_card_clip_s = on(FontAwesome7Solid.id_card_clip).build();
    public static final FontAwesome7IconType id_card_r = on(FontAwesome7Regular.id_card).build();
    public static final FontAwesome7IconType id_card_s = on(FontAwesome7Solid.id_card).build();
    public static final FontAwesome7IconType igloo_s = on(FontAwesome7Solid.igloo).build();
    public static final FontAwesome7IconType ils_s = on(FontAwesome7Solid.ils).build();
    public static final FontAwesome7IconType image_portrait_s = on(FontAwesome7Solid.image_portrait).build();
    public static final FontAwesome7IconType image_r = on(FontAwesome7Regular.image).build();
    public static final FontAwesome7IconType image_s = on(FontAwesome7Solid.image).build();
    public static final FontAwesome7IconType images_r = on(FontAwesome7Regular.images).build();
    public static final FontAwesome7IconType images_s = on(FontAwesome7Solid.images).build();
    public static final FontAwesome7IconType inbox_s = on(FontAwesome7Solid.inbox).build();
    public static final FontAwesome7IconType indent_s = on(FontAwesome7Solid.indent).build();
    public static final FontAwesome7IconType indian_rupee_s = on(FontAwesome7Solid.indian_rupee).build();
    public static final FontAwesome7IconType indian_rupee_sign_s = on(FontAwesome7Solid.indian_rupee_sign).build();
    public static final FontAwesome7IconType industry_s = on(FontAwesome7Solid.industry).build();
    public static final FontAwesome7IconType infinity_s = on(FontAwesome7Solid.infinity).build();
    public static final FontAwesome7IconType info_circle_s = on(FontAwesome7Solid.info_circle).build();
    public static final FontAwesome7IconType info_s = on(FontAwesome7Solid.info).build();
    public static final FontAwesome7IconType inr_s = on(FontAwesome7Solid.inr).build();
    public static final FontAwesome7IconType institution_s = on(FontAwesome7Solid.institution).build();
    public static final FontAwesome7IconType italic_s = on(FontAwesome7Solid.italic).build();
    public static final FontAwesome7IconType j_s = on(FontAwesome7Solid.j).build();
    public static final FontAwesome7IconType jar_s = on(FontAwesome7Solid.jar).build();
    public static final FontAwesome7IconType jar_wheat_s = on(FontAwesome7Solid.jar_wheat).build();
    public static final FontAwesome7IconType jedi_s = on(FontAwesome7Solid.jedi).build();
    public static final FontAwesome7IconType jet_fighter_s = on(FontAwesome7Solid.jet_fighter).build();
    public static final FontAwesome7IconType jet_fighter_up_s = on(FontAwesome7Solid.jet_fighter_up).build();
    public static final FontAwesome7IconType joint_s = on(FontAwesome7Solid.joint).build();
    public static final FontAwesome7IconType journal_whills_s = on(FontAwesome7Solid.journal_whills).build();
    public static final FontAwesome7IconType jpy_s = on(FontAwesome7Solid.jpy).build();
    public static final FontAwesome7IconType jug_detergent_s = on(FontAwesome7Solid.jug_detergent).build();
    public static final FontAwesome7IconType k_s = on(FontAwesome7Solid.k).build();
    public static final FontAwesome7IconType kaaba_s = on(FontAwesome7Solid.kaaba).build();
    public static final FontAwesome7IconType key_s = on(FontAwesome7Solid.key).build();
    public static final FontAwesome7IconType keyboard_r = on(FontAwesome7Regular.keyboard).build();
    public static final FontAwesome7IconType keyboard_s = on(FontAwesome7Solid.keyboard).build();
    public static final FontAwesome7IconType khanda_s = on(FontAwesome7Solid.khanda).build();
    public static final FontAwesome7IconType kip_sign_s = on(FontAwesome7Solid.kip_sign).build();
    public static final FontAwesome7IconType kiss_beam_r = on(FontAwesome7Regular.kiss_beam).build();
    public static final FontAwesome7IconType kiss_beam_s = on(FontAwesome7Solid.kiss_beam).build();
    public static final FontAwesome7IconType kiss_r = on(FontAwesome7Regular.kiss).build();
    public static final FontAwesome7IconType kiss_s = on(FontAwesome7Solid.kiss).build();
    public static final FontAwesome7IconType kiss_wink_heart_r = on(FontAwesome7Regular.kiss_wink_heart).build();
    public static final FontAwesome7IconType kiss_wink_heart_s = on(FontAwesome7Solid.kiss_wink_heart).build();
    public static final FontAwesome7IconType kit_medical_s = on(FontAwesome7Solid.kit_medical).build();
    public static final FontAwesome7IconType kitchen_set_s = on(FontAwesome7Solid.kitchen_set).build();
    public static final FontAwesome7IconType kiwi_bird_s = on(FontAwesome7Solid.kiwi_bird).build();
    public static final FontAwesome7IconType krw_s = on(FontAwesome7Solid.krw).build();
    public static final FontAwesome7IconType l_s = on(FontAwesome7Solid.l).build();
    public static final FontAwesome7IconType ladder_water_s = on(FontAwesome7Solid.ladder_water).build();
    public static final FontAwesome7IconType land_mine_on_s = on(FontAwesome7Solid.land_mine_on).build();
    public static final FontAwesome7IconType landmark_alt_s = on(FontAwesome7Solid.landmark_alt).build();
    public static final FontAwesome7IconType landmark_dome_s = on(FontAwesome7Solid.landmark_dome).build();
    public static final FontAwesome7IconType landmark_flag_s = on(FontAwesome7Solid.landmark_flag).build();
    public static final FontAwesome7IconType landmark_s = on(FontAwesome7Solid.landmark).build();
    public static final FontAwesome7IconType language_s = on(FontAwesome7Solid.language).build();
    public static final FontAwesome7IconType laptop_code_s = on(FontAwesome7Solid.laptop_code).build();
    public static final FontAwesome7IconType laptop_file_s = on(FontAwesome7Solid.laptop_file).build();
    public static final FontAwesome7IconType laptop_house_s = on(FontAwesome7Solid.laptop_house).build();
    public static final FontAwesome7IconType laptop_medical_s = on(FontAwesome7Solid.laptop_medical).build();
    public static final FontAwesome7IconType laptop_s = on(FontAwesome7Solid.laptop).build();
    public static final FontAwesome7IconType lari_sign_s = on(FontAwesome7Solid.lari_sign).build();
    public static final FontAwesome7IconType laugh_beam_r = on(FontAwesome7Regular.laugh_beam).build();
    public static final FontAwesome7IconType laugh_beam_s = on(FontAwesome7Solid.laugh_beam).build();
    public static final FontAwesome7IconType laugh_r = on(FontAwesome7Regular.laugh).build();
    public static final FontAwesome7IconType laugh_s = on(FontAwesome7Solid.laugh).build();
    public static final FontAwesome7IconType laugh_squint_r = on(FontAwesome7Regular.laugh_squint).build();
    public static final FontAwesome7IconType laugh_squint_s = on(FontAwesome7Solid.laugh_squint).build();
    public static final FontAwesome7IconType laugh_wink_r = on(FontAwesome7Regular.laugh_wink).build();
    public static final FontAwesome7IconType laugh_wink_s = on(FontAwesome7Solid.laugh_wink).build();
    public static final FontAwesome7IconType layer_group_s = on(FontAwesome7Solid.layer_group).build();
    public static final FontAwesome7IconType leaf_s = on(FontAwesome7Solid.leaf).build();
    public static final FontAwesome7IconType left_long_s = on(FontAwesome7Solid.left_long).build();
    public static final FontAwesome7IconType left_right_s = on(FontAwesome7Solid.left_right).build();
    public static final FontAwesome7IconType legal_s = on(FontAwesome7Solid.legal).build();
    public static final FontAwesome7IconType lemon_r = on(FontAwesome7Regular.lemon).build();
    public static final FontAwesome7IconType lemon_s = on(FontAwesome7Solid.lemon).build();
    public static final FontAwesome7IconType less_than_equal_s = on(FontAwesome7Solid.less_than_equal).build();
    public static final FontAwesome7IconType less_than_s = on(FontAwesome7Solid.less_than).build();
    public static final FontAwesome7IconType level_down_alt_s = on(FontAwesome7Solid.level_down_alt).build();
    public static final FontAwesome7IconType level_down_s = on(FontAwesome7Solid.level_down).build();
    public static final FontAwesome7IconType level_up_alt_s = on(FontAwesome7Solid.level_up_alt).build();
    public static final FontAwesome7IconType level_up_s = on(FontAwesome7Solid.level_up).build();
    public static final FontAwesome7IconType life_ring_r = on(FontAwesome7Regular.life_ring).build();
    public static final FontAwesome7IconType life_ring_s = on(FontAwesome7Solid.life_ring).build();
    public static final FontAwesome7IconType lightbulb_r = on(FontAwesome7Regular.lightbulb).build();
    public static final FontAwesome7IconType lightbulb_s = on(FontAwesome7Solid.lightbulb).build();
    public static final FontAwesome7IconType line_chart_s = on(FontAwesome7Solid.line_chart).build();
    public static final FontAwesome7IconType lines_leaning_s = on(FontAwesome7Solid.lines_leaning).build();
    public static final FontAwesome7IconType link_s = on(FontAwesome7Solid.link).build();
    public static final FontAwesome7IconType link_slash_s = on(FontAwesome7Solid.link_slash).build();
    public static final FontAwesome7IconType lira_sign_s = on(FontAwesome7Solid.lira_sign).build();
    public static final FontAwesome7IconType list_1_2_s = on(FontAwesome7Solid.list_1_2).build();
    public static final FontAwesome7IconType list_alt_r = on(FontAwesome7Regular.list_alt).build();
    public static final FontAwesome7IconType list_alt_s = on(FontAwesome7Solid.list_alt).build();
    public static final FontAwesome7IconType list_check_s = on(FontAwesome7Solid.list_check).build();
    public static final FontAwesome7IconType list_dots_s = on(FontAwesome7Solid.list_dots).build();
    public static final FontAwesome7IconType list_numeric_s = on(FontAwesome7Solid.list_numeric).build();
    public static final FontAwesome7IconType list_ol_s = on(FontAwesome7Solid.list_ol).build();
    public static final FontAwesome7IconType list_s = on(FontAwesome7Solid.list).build();
    public static final FontAwesome7IconType list_squares_s = on(FontAwesome7Solid.list_squares).build();
    public static final FontAwesome7IconType list_ul_s = on(FontAwesome7Solid.list_ul).build();
    public static final FontAwesome7IconType litecoin_sign_s = on(FontAwesome7Solid.litecoin_sign).build();
    public static final FontAwesome7IconType location_arrow_s = on(FontAwesome7Solid.location_arrow).build();
    public static final FontAwesome7IconType location_crosshairs_s = on(FontAwesome7Solid.location_crosshairs).build();
    public static final FontAwesome7IconType location_dot_s = on(FontAwesome7Solid.location_dot).build();
    public static final FontAwesome7IconType location_pin_lock_s = on(FontAwesome7Solid.location_pin_lock).build();
    public static final FontAwesome7IconType location_pin_s = on(FontAwesome7Solid.location_pin).build();
    public static final FontAwesome7IconType location_s = on(FontAwesome7Solid.location).build();
    public static final FontAwesome7IconType lock_open_s = on(FontAwesome7Solid.lock_open).build();
    public static final FontAwesome7IconType lock_s = on(FontAwesome7Solid.lock).build();
    public static final FontAwesome7IconType locust_s = on(FontAwesome7Solid.locust).build();
    public static final FontAwesome7IconType long_arrow_alt_down_s = on(FontAwesome7Solid.long_arrow_alt_down).build();
    public static final FontAwesome7IconType long_arrow_alt_left_s = on(FontAwesome7Solid.long_arrow_alt_left).build();
    public static final FontAwesome7IconType long_arrow_alt_right_s = on(FontAwesome7Solid.long_arrow_alt_right).build();
    public static final FontAwesome7IconType long_arrow_alt_up_s = on(FontAwesome7Solid.long_arrow_alt_up).build();
    public static final FontAwesome7IconType long_arrow_down_s = on(FontAwesome7Solid.long_arrow_down).build();
    public static final FontAwesome7IconType long_arrow_left_s = on(FontAwesome7Solid.long_arrow_left).build();
    public static final FontAwesome7IconType long_arrow_right_s = on(FontAwesome7Solid.long_arrow_right).build();
    public static final FontAwesome7IconType long_arrow_up_s = on(FontAwesome7Solid.long_arrow_up).build();
    public static final FontAwesome7IconType low_vision_s = on(FontAwesome7Solid.low_vision).build();
    public static final FontAwesome7IconType luggage_cart_s = on(FontAwesome7Solid.luggage_cart).build();
    public static final FontAwesome7IconType lungs_s = on(FontAwesome7Solid.lungs).build();
    public static final FontAwesome7IconType lungs_virus_s = on(FontAwesome7Solid.lungs_virus).build();
    public static final FontAwesome7IconType m_s = on(FontAwesome7Solid.m).build();
    public static final FontAwesome7IconType magic_s = on(FontAwesome7Solid.magic).build();
    public static final FontAwesome7IconType magic_wand_sparkles_s = on(FontAwesome7Solid.magic_wand_sparkles).build();
    public static final FontAwesome7IconType magnet_s = on(FontAwesome7Solid.magnet).build();
    public static final FontAwesome7IconType magnifying_glass_arrow_right_s = on(FontAwesome7Solid.magnifying_glass_arrow_right).build();
    public static final FontAwesome7IconType magnifying_glass_chart_s = on(FontAwesome7Solid.magnifying_glass_chart).build();
    public static final FontAwesome7IconType magnifying_glass_dollar_s = on(FontAwesome7Solid.magnifying_glass_dollar).build();
    public static final FontAwesome7IconType magnifying_glass_location_s = on(FontAwesome7Solid.magnifying_glass_location).build();
    public static final FontAwesome7IconType magnifying_glass_minus_s = on(FontAwesome7Solid.magnifying_glass_minus).build();
    public static final FontAwesome7IconType magnifying_glass_plus_s = on(FontAwesome7Solid.magnifying_glass_plus).build();
    public static final FontAwesome7IconType magnifying_glass_s = on(FontAwesome7Solid.magnifying_glass).build();
    public static final FontAwesome7IconType mail_bulk_s = on(FontAwesome7Solid.mail_bulk).build();
    public static final FontAwesome7IconType mail_forward_s = on(FontAwesome7Solid.mail_forward).build();
    public static final FontAwesome7IconType mail_reply_all_s = on(FontAwesome7Solid.mail_reply_all).build();
    public static final FontAwesome7IconType mail_reply_s = on(FontAwesome7Solid.mail_reply).build();
    public static final FontAwesome7IconType male_s = on(FontAwesome7Solid.male).build();
    public static final FontAwesome7IconType manat_sign_s = on(FontAwesome7Solid.manat_sign).build();
    public static final FontAwesome7IconType map_location_dot_s = on(FontAwesome7Solid.map_location_dot).build();
    public static final FontAwesome7IconType map_location_s = on(FontAwesome7Solid.map_location).build();
    public static final FontAwesome7IconType map_marked_alt_s = on(FontAwesome7Solid.map_marked_alt).build();
    public static final FontAwesome7IconType map_marked_s = on(FontAwesome7Solid.map_marked).build();
    public static final FontAwesome7IconType map_marker_alt_s = on(FontAwesome7Solid.map_marker_alt).build();
    public static final FontAwesome7IconType map_marker_s = on(FontAwesome7Solid.map_marker).build();
    public static final FontAwesome7IconType map_pin_s = on(FontAwesome7Solid.map_pin).build();
    public static final FontAwesome7IconType map_r = on(FontAwesome7Regular.map).build();
    public static final FontAwesome7IconType map_s = on(FontAwesome7Solid.map).build();
    public static final FontAwesome7IconType map_signs_s = on(FontAwesome7Solid.map_signs).build();
    public static final FontAwesome7IconType marker_s = on(FontAwesome7Solid.marker).build();
    public static final FontAwesome7IconType mars_and_venus_burst_s = on(FontAwesome7Solid.mars_and_venus_burst).build();
    public static final FontAwesome7IconType mars_and_venus_s = on(FontAwesome7Solid.mars_and_venus).build();
    public static final FontAwesome7IconType mars_double_s = on(FontAwesome7Solid.mars_double).build();
    public static final FontAwesome7IconType mars_s = on(FontAwesome7Solid.mars).build();
    public static final FontAwesome7IconType mars_stroke_h_s = on(FontAwesome7Solid.mars_stroke_h).build();
    public static final FontAwesome7IconType mars_stroke_right_s = on(FontAwesome7Solid.mars_stroke_right).build();
    public static final FontAwesome7IconType mars_stroke_s = on(FontAwesome7Solid.mars_stroke).build();
    public static final FontAwesome7IconType mars_stroke_up_s = on(FontAwesome7Solid.mars_stroke_up).build();
    public static final FontAwesome7IconType mars_stroke_v_s = on(FontAwesome7Solid.mars_stroke_v).build();
    public static final FontAwesome7IconType martini_glass_citrus_s = on(FontAwesome7Solid.martini_glass_citrus).build();
    public static final FontAwesome7IconType martini_glass_empty_s = on(FontAwesome7Solid.martini_glass_empty).build();
    public static final FontAwesome7IconType martini_glass_s = on(FontAwesome7Solid.martini_glass).build();
    public static final FontAwesome7IconType mask_face_s = on(FontAwesome7Solid.mask_face).build();
    public static final FontAwesome7IconType mask_s = on(FontAwesome7Solid.mask).build();
    public static final FontAwesome7IconType mask_ventilator_s = on(FontAwesome7Solid.mask_ventilator).build();
    public static final FontAwesome7IconType masks_theater_s = on(FontAwesome7Solid.masks_theater).build();
    public static final FontAwesome7IconType mattress_pillow_s = on(FontAwesome7Solid.mattress_pillow).build();
    public static final FontAwesome7IconType maximize_s = on(FontAwesome7Solid.maximize).build();
    public static final FontAwesome7IconType medal_s = on(FontAwesome7Solid.medal).build();
    public static final FontAwesome7IconType medkit_s = on(FontAwesome7Solid.medkit).build();
    public static final FontAwesome7IconType meh_blank_r = on(FontAwesome7Regular.meh_blank).build();
    public static final FontAwesome7IconType meh_blank_s = on(FontAwesome7Solid.meh_blank).build();
    public static final FontAwesome7IconType meh_r = on(FontAwesome7Regular.meh).build();
    public static final FontAwesome7IconType meh_rolling_eyes_r = on(FontAwesome7Regular.meh_rolling_eyes).build();
    public static final FontAwesome7IconType meh_rolling_eyes_s = on(FontAwesome7Solid.meh_rolling_eyes).build();
    public static final FontAwesome7IconType meh_s = on(FontAwesome7Solid.meh).build();
    public static final FontAwesome7IconType memory_s = on(FontAwesome7Solid.memory).build();
    public static final FontAwesome7IconType menorah_s = on(FontAwesome7Solid.menorah).build();
    public static final FontAwesome7IconType mercury_s = on(FontAwesome7Solid.mercury).build();
    public static final FontAwesome7IconType message_r = on(FontAwesome7Regular.message).build();
    public static final FontAwesome7IconType message_s = on(FontAwesome7Solid.message).build();
    public static final FontAwesome7IconType meteor_s = on(FontAwesome7Solid.meteor).build();
    public static final FontAwesome7IconType microchip_s = on(FontAwesome7Solid.microchip).build();
    public static final FontAwesome7IconType microphone_alt_s = on(FontAwesome7Solid.microphone_alt).build();
    public static final FontAwesome7IconType microphone_alt_slash_s = on(FontAwesome7Solid.microphone_alt_slash).build();
    public static final FontAwesome7IconType microphone_lines_s = on(FontAwesome7Solid.microphone_lines).build();
    public static final FontAwesome7IconType microphone_lines_slash_s = on(FontAwesome7Solid.microphone_lines_slash).build();
    public static final FontAwesome7IconType microphone_s = on(FontAwesome7Solid.microphone).build();
    public static final FontAwesome7IconType microphone_slash_s = on(FontAwesome7Solid.microphone_slash).build();
    public static final FontAwesome7IconType microscope_s = on(FontAwesome7Solid.microscope).build();
    public static final FontAwesome7IconType mill_sign_s = on(FontAwesome7Solid.mill_sign).build();
    public static final FontAwesome7IconType minimize_s = on(FontAwesome7Solid.minimize).build();
    public static final FontAwesome7IconType minus_circle_s = on(FontAwesome7Solid.minus_circle).build();
    public static final FontAwesome7IconType minus_s = on(FontAwesome7Solid.minus).build();
    public static final FontAwesome7IconType minus_square_r = on(FontAwesome7Regular.minus_square).build();
    public static final FontAwesome7IconType minus_square_s = on(FontAwesome7Solid.minus_square).build();
    public static final FontAwesome7IconType mitten_s = on(FontAwesome7Solid.mitten).build();
    public static final FontAwesome7IconType mobile_alt_s = on(FontAwesome7Solid.mobile_alt).build();
    public static final FontAwesome7IconType mobile_android_alt_s = on(FontAwesome7Solid.mobile_android_alt).build();
    public static final FontAwesome7IconType mobile_android_s = on(FontAwesome7Solid.mobile_android).build();
    public static final FontAwesome7IconType mobile_button_s = on(FontAwesome7Solid.mobile_button).build();
    public static final FontAwesome7IconType mobile_phone_s = on(FontAwesome7Solid.mobile_phone).build();
    public static final FontAwesome7IconType mobile_retro_s = on(FontAwesome7Solid.mobile_retro).build();
    public static final FontAwesome7IconType mobile_s = on(FontAwesome7Solid.mobile).build();
    public static final FontAwesome7IconType mobile_screen_button_s = on(FontAwesome7Solid.mobile_screen_button).build();
    public static final FontAwesome7IconType mobile_screen_s = on(FontAwesome7Solid.mobile_screen).build();
    public static final FontAwesome7IconType mobile_vibrate_s = on(FontAwesome7Solid.mobile_vibrate).build();
    public static final FontAwesome7IconType money_bill_1_r = on(FontAwesome7Regular.money_bill_1).build();
    public static final FontAwesome7IconType money_bill_1_s = on(FontAwesome7Solid.money_bill_1).build();
    public static final FontAwesome7IconType money_bill_1_wave_s = on(FontAwesome7Solid.money_bill_1_wave).build();
    public static final FontAwesome7IconType money_bill_alt_r = on(FontAwesome7Regular.money_bill_alt).build();
    public static final FontAwesome7IconType money_bill_alt_s = on(FontAwesome7Solid.money_bill_alt).build();
    public static final FontAwesome7IconType money_bill_s = on(FontAwesome7Solid.money_bill).build();
    public static final FontAwesome7IconType money_bill_transfer_s = on(FontAwesome7Solid.money_bill_transfer).build();
    public static final FontAwesome7IconType money_bill_trend_up_s = on(FontAwesome7Solid.money_bill_trend_up).build();
    public static final FontAwesome7IconType money_bill_wave_alt_s = on(FontAwesome7Solid.money_bill_wave_alt).build();
    public static final FontAwesome7IconType money_bill_wave_s = on(FontAwesome7Solid.money_bill_wave).build();
    public static final FontAwesome7IconType money_bill_wheat_s = on(FontAwesome7Solid.money_bill_wheat).build();
    public static final FontAwesome7IconType money_bills_s = on(FontAwesome7Solid.money_bills).build();
    public static final FontAwesome7IconType money_check_alt_s = on(FontAwesome7Solid.money_check_alt).build();
    public static final FontAwesome7IconType money_check_dollar_s = on(FontAwesome7Solid.money_check_dollar).build();
    public static final FontAwesome7IconType money_check_s = on(FontAwesome7Solid.money_check).build();
    public static final FontAwesome7IconType monument_s = on(FontAwesome7Solid.monument).build();
    public static final FontAwesome7IconType moon_r = on(FontAwesome7Regular.moon).build();
    public static final FontAwesome7IconType moon_s = on(FontAwesome7Solid.moon).build();
    public static final FontAwesome7IconType mortar_board_s = on(FontAwesome7Solid.mortar_board).build();
    public static final FontAwesome7IconType mortar_pestle_s = on(FontAwesome7Solid.mortar_pestle).build();
    public static final FontAwesome7IconType mosque_s = on(FontAwesome7Solid.mosque).build();
    public static final FontAwesome7IconType mosquito_net_s = on(FontAwesome7Solid.mosquito_net).build();
    public static final FontAwesome7IconType mosquito_s = on(FontAwesome7Solid.mosquito).build();
    public static final FontAwesome7IconType motorcycle_s = on(FontAwesome7Solid.motorcycle).build();
    public static final FontAwesome7IconType mound_s = on(FontAwesome7Solid.mound).build();
    public static final FontAwesome7IconType mountain_city_s = on(FontAwesome7Solid.mountain_city).build();
    public static final FontAwesome7IconType mountain_s = on(FontAwesome7Solid.mountain).build();
    public static final FontAwesome7IconType mountain_sun_s = on(FontAwesome7Solid.mountain_sun).build();
    public static final FontAwesome7IconType mouse_pointer_s = on(FontAwesome7Solid.mouse_pointer).build();
    public static final FontAwesome7IconType mouse_s = on(FontAwesome7Solid.mouse).build();
    public static final FontAwesome7IconType mug_hot_s = on(FontAwesome7Solid.mug_hot).build();
    public static final FontAwesome7IconType mug_saucer_s = on(FontAwesome7Solid.mug_saucer).build();
    public static final FontAwesome7IconType multiply_s = on(FontAwesome7Solid.multiply).build();
    public static final FontAwesome7IconType museum_s = on(FontAwesome7Solid.museum).build();
    public static final FontAwesome7IconType music_s = on(FontAwesome7Solid.music).build();
    public static final FontAwesome7IconType n_s = on(FontAwesome7Solid.n).build();
    public static final FontAwesome7IconType naira_sign_s = on(FontAwesome7Solid.naira_sign).build();
    public static final FontAwesome7IconType navicon_s = on(FontAwesome7Solid.navicon).build();
    public static final FontAwesome7IconType network_wired_s = on(FontAwesome7Solid.network_wired).build();
    public static final FontAwesome7IconType neuter_s = on(FontAwesome7Solid.neuter).build();
    public static final FontAwesome7IconType newspaper_r = on(FontAwesome7Regular.newspaper).build();
    public static final FontAwesome7IconType newspaper_s = on(FontAwesome7Solid.newspaper).build();
    public static final FontAwesome7IconType non_binary_s = on(FontAwesome7Solid.non_binary).build();
    public static final FontAwesome7IconType not_equal_s = on(FontAwesome7Solid.not_equal).build();
    public static final FontAwesome7IconType notdef_s = on(FontAwesome7Solid.notdef).build();
    public static final FontAwesome7IconType note_sticky_r = on(FontAwesome7Regular.note_sticky).build();
    public static final FontAwesome7IconType note_sticky_s = on(FontAwesome7Solid.note_sticky).build();
    public static final FontAwesome7IconType notes_medical_s = on(FontAwesome7Solid.notes_medical).build();
    public static final FontAwesome7IconType o_s = on(FontAwesome7Solid.o).build();
    public static final FontAwesome7IconType object_group_r = on(FontAwesome7Regular.object_group).build();
    public static final FontAwesome7IconType object_group_s = on(FontAwesome7Solid.object_group).build();
    public static final FontAwesome7IconType object_ungroup_r = on(FontAwesome7Regular.object_ungroup).build();
    public static final FontAwesome7IconType object_ungroup_s = on(FontAwesome7Solid.object_ungroup).build();
    public static final FontAwesome7IconType octagon_s = on(FontAwesome7Solid.octagon).build();
    public static final FontAwesome7IconType oil_can_s = on(FontAwesome7Solid.oil_can).build();
    public static final FontAwesome7IconType oil_well_s = on(FontAwesome7Solid.oil_well).build();
    public static final FontAwesome7IconType om_s = on(FontAwesome7Solid.om).build();
    public static final FontAwesome7IconType otter_s = on(FontAwesome7Solid.otter).build();
    public static final FontAwesome7IconType outdent_s = on(FontAwesome7Solid.outdent).build();
    public static final FontAwesome7IconType p_s = on(FontAwesome7Solid.p).build();
    public static final FontAwesome7IconType pager_s = on(FontAwesome7Solid.pager).build();
    public static final FontAwesome7IconType paint_brush_s = on(FontAwesome7Solid.paint_brush).build();
    public static final FontAwesome7IconType paint_roller_s = on(FontAwesome7Solid.paint_roller).build();
    public static final FontAwesome7IconType paintbrush_s = on(FontAwesome7Solid.paintbrush).build();
    public static final FontAwesome7IconType palette_s = on(FontAwesome7Solid.palette).build();
    public static final FontAwesome7IconType pallet_s = on(FontAwesome7Solid.pallet).build();
    public static final FontAwesome7IconType panorama_s = on(FontAwesome7Solid.panorama).build();
    public static final FontAwesome7IconType paper_plane_r = on(FontAwesome7Regular.paper_plane).build();
    public static final FontAwesome7IconType paper_plane_s = on(FontAwesome7Solid.paper_plane).build();
    public static final FontAwesome7IconType paperclip_s = on(FontAwesome7Solid.paperclip).build();
    public static final FontAwesome7IconType parachute_box_s = on(FontAwesome7Solid.parachute_box).build();
    public static final FontAwesome7IconType paragraph_s = on(FontAwesome7Solid.paragraph).build();
    public static final FontAwesome7IconType parking_s = on(FontAwesome7Solid.parking).build();
    public static final FontAwesome7IconType passport_s = on(FontAwesome7Solid.passport).build();
    public static final FontAwesome7IconType pastafarianism_s = on(FontAwesome7Solid.pastafarianism).build();
    public static final FontAwesome7IconType paste_r = on(FontAwesome7Regular.paste).build();
    public static final FontAwesome7IconType paste_s = on(FontAwesome7Solid.paste).build();
    public static final FontAwesome7IconType pause_circle_r = on(FontAwesome7Regular.pause_circle).build();
    public static final FontAwesome7IconType pause_circle_s = on(FontAwesome7Solid.pause_circle).build();
    public static final FontAwesome7IconType pause_s = on(FontAwesome7Solid.pause).build();
    public static final FontAwesome7IconType paw_s = on(FontAwesome7Solid.paw).build();
    public static final FontAwesome7IconType peace_s = on(FontAwesome7Solid.peace).build();
    public static final FontAwesome7IconType pen_alt_s = on(FontAwesome7Solid.pen_alt).build();
    public static final FontAwesome7IconType pen_clip_s = on(FontAwesome7Solid.pen_clip).build();
    public static final FontAwesome7IconType pen_fancy_s = on(FontAwesome7Solid.pen_fancy).build();
    public static final FontAwesome7IconType pen_nib_s = on(FontAwesome7Solid.pen_nib).build();
    public static final FontAwesome7IconType pen_ruler_s = on(FontAwesome7Solid.pen_ruler).build();
    public static final FontAwesome7IconType pen_s = on(FontAwesome7Solid.pen).build();
    public static final FontAwesome7IconType pen_square_s = on(FontAwesome7Solid.pen_square).build();
    public static final FontAwesome7IconType pen_to_square_r = on(FontAwesome7Regular.pen_to_square).build();
    public static final FontAwesome7IconType pen_to_square_s = on(FontAwesome7Solid.pen_to_square).build();
    public static final FontAwesome7IconType pencil_alt_s = on(FontAwesome7Solid.pencil_alt).build();
    public static final FontAwesome7IconType pencil_ruler_s = on(FontAwesome7Solid.pencil_ruler).build();
    public static final FontAwesome7IconType pencil_s = on(FontAwesome7Solid.pencil).build();
    public static final FontAwesome7IconType pencil_square_s = on(FontAwesome7Solid.pencil_square).build();
    public static final FontAwesome7IconType pentagon_s = on(FontAwesome7Solid.pentagon).build();
    public static final FontAwesome7IconType people_arrows_left_right_s = on(FontAwesome7Solid.people_arrows_left_right).build();
    public static final FontAwesome7IconType people_arrows_s = on(FontAwesome7Solid.people_arrows).build();
    public static final FontAwesome7IconType people_carry_box_s = on(FontAwesome7Solid.people_carry_box).build();
    public static final FontAwesome7IconType people_carry_s = on(FontAwesome7Solid.people_carry).build();
    public static final FontAwesome7IconType people_group_s = on(FontAwesome7Solid.people_group).build();
    public static final FontAwesome7IconType people_line_s = on(FontAwesome7Solid.people_line).build();
    public static final FontAwesome7IconType people_pulling_s = on(FontAwesome7Solid.people_pulling).build();
    public static final FontAwesome7IconType people_robbery_s = on(FontAwesome7Solid.people_robbery).build();
    public static final FontAwesome7IconType people_roof_s = on(FontAwesome7Solid.people_roof).build();
    public static final FontAwesome7IconType pepper_hot_s = on(FontAwesome7Solid.pepper_hot).build();
    public static final FontAwesome7IconType percent_s = on(FontAwesome7Solid.percent).build();
    public static final FontAwesome7IconType percentage_s = on(FontAwesome7Solid.percentage).build();
    public static final FontAwesome7IconType person_arrow_down_to_line_s = on(FontAwesome7Solid.person_arrow_down_to_line).build();
    public static final FontAwesome7IconType person_arrow_up_from_line_s = on(FontAwesome7Solid.person_arrow_up_from_line).build();
    public static final FontAwesome7IconType person_biking_s = on(FontAwesome7Solid.person_biking).build();
    public static final FontAwesome7IconType person_booth_s = on(FontAwesome7Solid.person_booth).build();
    public static final FontAwesome7IconType person_breastfeeding_s = on(FontAwesome7Solid.person_breastfeeding).build();
    public static final FontAwesome7IconType person_burst_s = on(FontAwesome7Solid.person_burst).build();
    public static final FontAwesome7IconType person_cane_s = on(FontAwesome7Solid.person_cane).build();
    public static final FontAwesome7IconType person_chalkboard_s = on(FontAwesome7Solid.person_chalkboard).build();
    public static final FontAwesome7IconType person_circle_check_s = on(FontAwesome7Solid.person_circle_check).build();
    public static final FontAwesome7IconType person_circle_exclamation_s = on(FontAwesome7Solid.person_circle_exclamation).build();
    public static final FontAwesome7IconType person_circle_minus_s = on(FontAwesome7Solid.person_circle_minus).build();
    public static final FontAwesome7IconType person_circle_plus_s = on(FontAwesome7Solid.person_circle_plus).build();
    public static final FontAwesome7IconType person_circle_question_s = on(FontAwesome7Solid.person_circle_question).build();
    public static final FontAwesome7IconType person_circle_xmark_s = on(FontAwesome7Solid.person_circle_xmark).build();
    public static final FontAwesome7IconType person_digging_s = on(FontAwesome7Solid.person_digging).build();
    public static final FontAwesome7IconType person_dots_from_line_s = on(FontAwesome7Solid.person_dots_from_line).build();
    public static final FontAwesome7IconType person_dress_burst_s = on(FontAwesome7Solid.person_dress_burst).build();
    public static final FontAwesome7IconType person_dress_s = on(FontAwesome7Solid.person_dress).build();
    public static final FontAwesome7IconType person_drowning_s = on(FontAwesome7Solid.person_drowning).build();
    public static final FontAwesome7IconType person_falling_burst_s = on(FontAwesome7Solid.person_falling_burst).build();
    public static final FontAwesome7IconType person_falling_s = on(FontAwesome7Solid.person_falling).build();
    public static final FontAwesome7IconType person_half_dress_s = on(FontAwesome7Solid.person_half_dress).build();
    public static final FontAwesome7IconType person_harassing_s = on(FontAwesome7Solid.person_harassing).build();
    public static final FontAwesome7IconType person_hiking_s = on(FontAwesome7Solid.person_hiking).build();
    public static final FontAwesome7IconType person_military_pointing_s = on(FontAwesome7Solid.person_military_pointing).build();
    public static final FontAwesome7IconType person_military_rifle_s = on(FontAwesome7Solid.person_military_rifle).build();
    public static final FontAwesome7IconType person_military_to_person_s = on(FontAwesome7Solid.person_military_to_person).build();
    public static final FontAwesome7IconType person_praying_s = on(FontAwesome7Solid.person_praying).build();
    public static final FontAwesome7IconType person_pregnant_s = on(FontAwesome7Solid.person_pregnant).build();
    public static final FontAwesome7IconType person_rays_s = on(FontAwesome7Solid.person_rays).build();
    public static final FontAwesome7IconType person_rifle_s = on(FontAwesome7Solid.person_rifle).build();
    public static final FontAwesome7IconType person_running_s = on(FontAwesome7Solid.person_running).build();
    public static final FontAwesome7IconType person_s = on(FontAwesome7Solid.person).build();
    public static final FontAwesome7IconType person_shelter_s = on(FontAwesome7Solid.person_shelter).build();
    public static final FontAwesome7IconType person_skating_s = on(FontAwesome7Solid.person_skating).build();
    public static final FontAwesome7IconType person_skiing_nordic_s = on(FontAwesome7Solid.person_skiing_nordic).build();
    public static final FontAwesome7IconType person_skiing_s = on(FontAwesome7Solid.person_skiing).build();
    public static final FontAwesome7IconType person_snowboarding_s = on(FontAwesome7Solid.person_snowboarding).build();
    public static final FontAwesome7IconType person_swimming_s = on(FontAwesome7Solid.person_swimming).build();
    public static final FontAwesome7IconType person_through_window_s = on(FontAwesome7Solid.person_through_window).build();
    public static final FontAwesome7IconType person_walking_arrow_loop_left_s = on(FontAwesome7Solid.person_walking_arrow_loop_left).build();
    public static final FontAwesome7IconType person_walking_arrow_right_s = on(FontAwesome7Solid.person_walking_arrow_right).build();
    public static final FontAwesome7IconType person_walking_dashed_line_arrow_right_s = on(FontAwesome7Solid.person_walking_dashed_line_arrow_right).build();
    public static final FontAwesome7IconType person_walking_luggage_s = on(FontAwesome7Solid.person_walking_luggage).build();
    public static final FontAwesome7IconType person_walking_s = on(FontAwesome7Solid.person_walking).build();
    public static final FontAwesome7IconType person_walking_with_cane_s = on(FontAwesome7Solid.person_walking_with_cane).build();
    public static final FontAwesome7IconType peseta_sign_s = on(FontAwesome7Solid.peseta_sign).build();
    public static final FontAwesome7IconType peso_sign_s = on(FontAwesome7Solid.peso_sign).build();
    public static final FontAwesome7IconType phone_alt_s = on(FontAwesome7Solid.phone_alt).build();
    public static final FontAwesome7IconType phone_flip_s = on(FontAwesome7Solid.phone_flip).build();
    public static final FontAwesome7IconType phone_s = on(FontAwesome7Solid.phone).build();
    public static final FontAwesome7IconType phone_slash_s = on(FontAwesome7Solid.phone_slash).build();
    public static final FontAwesome7IconType phone_square_alt_s = on(FontAwesome7Solid.phone_square_alt).build();
    public static final FontAwesome7IconType phone_square_s = on(FontAwesome7Solid.phone_square).build();
    public static final FontAwesome7IconType phone_volume_s = on(FontAwesome7Solid.phone_volume).build();
    public static final FontAwesome7IconType photo_film_s = on(FontAwesome7Solid.photo_film).build();
    public static final FontAwesome7IconType photo_video_s = on(FontAwesome7Solid.photo_video).build();
    public static final FontAwesome7IconType pie_chart_s = on(FontAwesome7Solid.pie_chart).build();
    public static final FontAwesome7IconType piggy_bank_s = on(FontAwesome7Solid.piggy_bank).build();
    public static final FontAwesome7IconType pills_s = on(FontAwesome7Solid.pills).build();
    public static final FontAwesome7IconType ping_pong_paddle_ball_s = on(FontAwesome7Solid.ping_pong_paddle_ball).build();
    public static final FontAwesome7IconType pizza_slice_s = on(FontAwesome7Solid.pizza_slice).build();
    public static final FontAwesome7IconType place_of_worship_s = on(FontAwesome7Solid.place_of_worship).build();
    public static final FontAwesome7IconType plane_arrival_s = on(FontAwesome7Solid.plane_arrival).build();
    public static final FontAwesome7IconType plane_circle_check_s = on(FontAwesome7Solid.plane_circle_check).build();
    public static final FontAwesome7IconType plane_circle_exclamation_s = on(FontAwesome7Solid.plane_circle_exclamation).build();
    public static final FontAwesome7IconType plane_circle_xmark_s = on(FontAwesome7Solid.plane_circle_xmark).build();
    public static final FontAwesome7IconType plane_departure_s = on(FontAwesome7Solid.plane_departure).build();
    public static final FontAwesome7IconType plane_lock_s = on(FontAwesome7Solid.plane_lock).build();
    public static final FontAwesome7IconType plane_s = on(FontAwesome7Solid.plane).build();
    public static final FontAwesome7IconType plane_slash_s = on(FontAwesome7Solid.plane_slash).build();
    public static final FontAwesome7IconType plane_up_s = on(FontAwesome7Solid.plane_up).build();
    public static final FontAwesome7IconType plant_wilt_s = on(FontAwesome7Solid.plant_wilt).build();
    public static final FontAwesome7IconType plate_wheat_s = on(FontAwesome7Solid.plate_wheat).build();
    public static final FontAwesome7IconType play_circle_r = on(FontAwesome7Regular.play_circle).build();
    public static final FontAwesome7IconType play_circle_s = on(FontAwesome7Solid.play_circle).build();
    public static final FontAwesome7IconType play_s = on(FontAwesome7Solid.play).build();
    public static final FontAwesome7IconType plug_circle_bolt_s = on(FontAwesome7Solid.plug_circle_bolt).build();
    public static final FontAwesome7IconType plug_circle_check_s = on(FontAwesome7Solid.plug_circle_check).build();
    public static final FontAwesome7IconType plug_circle_exclamation_s = on(FontAwesome7Solid.plug_circle_exclamation).build();
    public static final FontAwesome7IconType plug_circle_minus_s = on(FontAwesome7Solid.plug_circle_minus).build();
    public static final FontAwesome7IconType plug_circle_plus_s = on(FontAwesome7Solid.plug_circle_plus).build();
    public static final FontAwesome7IconType plug_circle_xmark_s = on(FontAwesome7Solid.plug_circle_xmark).build();
    public static final FontAwesome7IconType plug_s = on(FontAwesome7Solid.plug).build();
    public static final FontAwesome7IconType plus_circle_s = on(FontAwesome7Solid.plus_circle).build();
    public static final FontAwesome7IconType plus_minus_s = on(FontAwesome7Solid.plus_minus).build();
    public static final FontAwesome7IconType plus_s = on(FontAwesome7Solid.plus).build();
    public static final FontAwesome7IconType plus_square_r = on(FontAwesome7Regular.plus_square).build();
    public static final FontAwesome7IconType plus_square_s = on(FontAwesome7Solid.plus_square).build();
    public static final FontAwesome7IconType podcast_s = on(FontAwesome7Solid.podcast).build();
    public static final FontAwesome7IconType poll_h_s = on(FontAwesome7Solid.poll_h).build();
    public static final FontAwesome7IconType poll_s = on(FontAwesome7Solid.poll).build();
    public static final FontAwesome7IconType poo_bolt_s = on(FontAwesome7Solid.poo_bolt).build();
    public static final FontAwesome7IconType poo_s = on(FontAwesome7Solid.poo).build();
    public static final FontAwesome7IconType poo_storm_s = on(FontAwesome7Solid.poo_storm).build();
    public static final FontAwesome7IconType poop_s = on(FontAwesome7Solid.poop).build();
    public static final FontAwesome7IconType portrait_s = on(FontAwesome7Solid.portrait).build();
    public static final FontAwesome7IconType pound_sign_s = on(FontAwesome7Solid.pound_sign).build();
    public static final FontAwesome7IconType power_off_s = on(FontAwesome7Solid.power_off).build();
    public static final FontAwesome7IconType pray_s = on(FontAwesome7Solid.pray).build();
    public static final FontAwesome7IconType praying_hands_s = on(FontAwesome7Solid.praying_hands).build();
    public static final FontAwesome7IconType prescription_bottle_alt_s = on(FontAwesome7Solid.prescription_bottle_alt).build();
    public static final FontAwesome7IconType prescription_bottle_medical_s = on(FontAwesome7Solid.prescription_bottle_medical).build();
    public static final FontAwesome7IconType prescription_bottle_s = on(FontAwesome7Solid.prescription_bottle).build();
    public static final FontAwesome7IconType prescription_s = on(FontAwesome7Solid.prescription).build();
    public static final FontAwesome7IconType print_s = on(FontAwesome7Solid.print).build();
    public static final FontAwesome7IconType procedures_s = on(FontAwesome7Solid.procedures).build();
    public static final FontAwesome7IconType project_diagram_s = on(FontAwesome7Solid.project_diagram).build();
    public static final FontAwesome7IconType pump_medical_s = on(FontAwesome7Solid.pump_medical).build();
    public static final FontAwesome7IconType pump_soap_s = on(FontAwesome7Solid.pump_soap).build();
    public static final FontAwesome7IconType puzzle_piece_s = on(FontAwesome7Solid.puzzle_piece).build();
    public static final FontAwesome7IconType q_s = on(FontAwesome7Solid.q).build();
    public static final FontAwesome7IconType qrcode_s = on(FontAwesome7Solid.qrcode).build();
    public static final FontAwesome7IconType question_circle_r = on(FontAwesome7Regular.question_circle).build();
    public static final FontAwesome7IconType question_circle_s = on(FontAwesome7Solid.question_circle).build();
    public static final FontAwesome7IconType question_s = on(FontAwesome7Solid.question).build();
    public static final FontAwesome7IconType quidditch_broom_ball_s = on(FontAwesome7Solid.quidditch_broom_ball).build();
    public static final FontAwesome7IconType quidditch_s = on(FontAwesome7Solid.quidditch).build();
    public static final FontAwesome7IconType quote_left_alt_s = on(FontAwesome7Solid.quote_left_alt).build();
    public static final FontAwesome7IconType quote_left_s = on(FontAwesome7Solid.quote_left).build();
    public static final FontAwesome7IconType quote_right_alt_s = on(FontAwesome7Solid.quote_right_alt).build();
    public static final FontAwesome7IconType quote_right_s = on(FontAwesome7Solid.quote_right).build();
    public static final FontAwesome7IconType quran_s = on(FontAwesome7Solid.quran).build();
    public static final FontAwesome7IconType r_s = on(FontAwesome7Solid.r).build();
    public static final FontAwesome7IconType radiation_alt_s = on(FontAwesome7Solid.radiation_alt).build();
    public static final FontAwesome7IconType radiation_s = on(FontAwesome7Solid.radiation).build();
    public static final FontAwesome7IconType radio_s = on(FontAwesome7Solid.radio).build();
    public static final FontAwesome7IconType rainbow_s = on(FontAwesome7Solid.rainbow).build();
    public static final FontAwesome7IconType random_s = on(FontAwesome7Solid.random).build();
    public static final FontAwesome7IconType ranking_star_s = on(FontAwesome7Solid.ranking_star).build();
    public static final FontAwesome7IconType receipt_s = on(FontAwesome7Solid.receipt).build();
    public static final FontAwesome7IconType record_vinyl_s = on(FontAwesome7Solid.record_vinyl).build();
    public static final FontAwesome7IconType rectangle_ad_s = on(FontAwesome7Solid.rectangle_ad).build();
    public static final FontAwesome7IconType rectangle_list_r = on(FontAwesome7Regular.rectangle_list).build();
    public static final FontAwesome7IconType rectangle_list_s = on(FontAwesome7Solid.rectangle_list).build();
    public static final FontAwesome7IconType rectangle_times_r = on(FontAwesome7Regular.rectangle_times).build();
    public static final FontAwesome7IconType rectangle_times_s = on(FontAwesome7Solid.rectangle_times).build();
    public static final FontAwesome7IconType rectangle_xmark_r = on(FontAwesome7Regular.rectangle_xmark).build();
    public static final FontAwesome7IconType rectangle_xmark_s = on(FontAwesome7Solid.rectangle_xmark).build();
    public static final FontAwesome7IconType recycle_s = on(FontAwesome7Solid.recycle).build();
    public static final FontAwesome7IconType redo_alt_s = on(FontAwesome7Solid.redo_alt).build();
    public static final FontAwesome7IconType redo_s = on(FontAwesome7Solid.redo).build();
    public static final FontAwesome7IconType refresh_s = on(FontAwesome7Solid.refresh).build();
    public static final FontAwesome7IconType registered_r = on(FontAwesome7Regular.registered).build();
    public static final FontAwesome7IconType registered_s = on(FontAwesome7Solid.registered).build();
    public static final FontAwesome7IconType remove_format_s = on(FontAwesome7Solid.remove_format).build();
    public static final FontAwesome7IconType remove_s = on(FontAwesome7Solid.remove).build();
    public static final FontAwesome7IconType reorder_s = on(FontAwesome7Solid.reorder).build();
    public static final FontAwesome7IconType repeat_s = on(FontAwesome7Solid.repeat).build();
    public static final FontAwesome7IconType reply_all_s = on(FontAwesome7Solid.reply_all).build();
    public static final FontAwesome7IconType reply_s = on(FontAwesome7Solid.reply).build();
    public static final FontAwesome7IconType republican_s = on(FontAwesome7Solid.republican).build();
    public static final FontAwesome7IconType restroom_s = on(FontAwesome7Solid.restroom).build();
    public static final FontAwesome7IconType retweet_s = on(FontAwesome7Solid.retweet).build();
    public static final FontAwesome7IconType ribbon_s = on(FontAwesome7Solid.ribbon).build();
    public static final FontAwesome7IconType right_from_bracket_s = on(FontAwesome7Solid.right_from_bracket).build();
    public static final FontAwesome7IconType right_left_s = on(FontAwesome7Solid.right_left).build();
    public static final FontAwesome7IconType right_long_s = on(FontAwesome7Solid.right_long).build();
    public static final FontAwesome7IconType right_to_bracket_s = on(FontAwesome7Solid.right_to_bracket).build();
    public static final FontAwesome7IconType ring_s = on(FontAwesome7Solid.ring).build();
    public static final FontAwesome7IconType rmb_s = on(FontAwesome7Solid.rmb).build();
    public static final FontAwesome7IconType road_barrier_s = on(FontAwesome7Solid.road_barrier).build();
    public static final FontAwesome7IconType road_bridge_s = on(FontAwesome7Solid.road_bridge).build();
    public static final FontAwesome7IconType road_circle_check_s = on(FontAwesome7Solid.road_circle_check).build();
    public static final FontAwesome7IconType road_circle_exclamation_s = on(FontAwesome7Solid.road_circle_exclamation).build();
    public static final FontAwesome7IconType road_circle_xmark_s = on(FontAwesome7Solid.road_circle_xmark).build();
    public static final FontAwesome7IconType road_lock_s = on(FontAwesome7Solid.road_lock).build();
    public static final FontAwesome7IconType road_s = on(FontAwesome7Solid.road).build();
    public static final FontAwesome7IconType road_spikes_s = on(FontAwesome7Solid.road_spikes).build();
    public static final FontAwesome7IconType robot_s = on(FontAwesome7Solid.robot).build();
    public static final FontAwesome7IconType rocket_s = on(FontAwesome7Solid.rocket).build();
    public static final FontAwesome7IconType rod_asclepius_s = on(FontAwesome7Solid.rod_asclepius).build();
    public static final FontAwesome7IconType rod_snake_s = on(FontAwesome7Solid.rod_snake).build();
    public static final FontAwesome7IconType rotate_back_s = on(FontAwesome7Solid.rotate_back).build();
    public static final FontAwesome7IconType rotate_backward_s = on(FontAwesome7Solid.rotate_backward).build();
    public static final FontAwesome7IconType rotate_forward_s = on(FontAwesome7Solid.rotate_forward).build();
    public static final FontAwesome7IconType rotate_left_s = on(FontAwesome7Solid.rotate_left).build();
    public static final FontAwesome7IconType rotate_right_s = on(FontAwesome7Solid.rotate_right).build();
    public static final FontAwesome7IconType rotate_s = on(FontAwesome7Solid.rotate).build();
    public static final FontAwesome7IconType rouble_s = on(FontAwesome7Solid.rouble).build();
    public static final FontAwesome7IconType route_s = on(FontAwesome7Solid.route).build();
    public static final FontAwesome7IconType rss_s = on(FontAwesome7Solid.rss).build();
    public static final FontAwesome7IconType rss_square_s = on(FontAwesome7Solid.rss_square).build();
    public static final FontAwesome7IconType rub_s = on(FontAwesome7Solid.rub).build();
    public static final FontAwesome7IconType ruble_s = on(FontAwesome7Solid.ruble).build();
    public static final FontAwesome7IconType ruble_sign_s = on(FontAwesome7Solid.ruble_sign).build();
    public static final FontAwesome7IconType rug_s = on(FontAwesome7Solid.rug).build();
    public static final FontAwesome7IconType ruler_combined_s = on(FontAwesome7Solid.ruler_combined).build();
    public static final FontAwesome7IconType ruler_horizontal_s = on(FontAwesome7Solid.ruler_horizontal).build();
    public static final FontAwesome7IconType ruler_s = on(FontAwesome7Solid.ruler).build();
    public static final FontAwesome7IconType ruler_vertical_s = on(FontAwesome7Solid.ruler_vertical).build();
    public static final FontAwesome7IconType running_s = on(FontAwesome7Solid.running).build();
    public static final FontAwesome7IconType rupee_s = on(FontAwesome7Solid.rupee).build();
    public static final FontAwesome7IconType rupee_sign_s = on(FontAwesome7Solid.rupee_sign).build();
    public static final FontAwesome7IconType rupiah_sign_s = on(FontAwesome7Solid.rupiah_sign).build();
    public static final FontAwesome7IconType s_s = on(FontAwesome7Solid.s).build();
    public static final FontAwesome7IconType sack_dollar_s = on(FontAwesome7Solid.sack_dollar).build();
    public static final FontAwesome7IconType sack_xmark_s = on(FontAwesome7Solid.sack_xmark).build();
    public static final FontAwesome7IconType sad_cry_r = on(FontAwesome7Regular.sad_cry).build();
    public static final FontAwesome7IconType sad_cry_s = on(FontAwesome7Solid.sad_cry).build();
    public static final FontAwesome7IconType sad_tear_r = on(FontAwesome7Regular.sad_tear).build();
    public static final FontAwesome7IconType sad_tear_s = on(FontAwesome7Solid.sad_tear).build();
    public static final FontAwesome7IconType sailboat_s = on(FontAwesome7Solid.sailboat).build();
    public static final FontAwesome7IconType satellite_dish_s = on(FontAwesome7Solid.satellite_dish).build();
    public static final FontAwesome7IconType satellite_s = on(FontAwesome7Solid.satellite).build();
    public static final FontAwesome7IconType save_r = on(FontAwesome7Regular.save).build();
    public static final FontAwesome7IconType save_s = on(FontAwesome7Solid.save).build();
    public static final FontAwesome7IconType scale_balanced_s = on(FontAwesome7Solid.scale_balanced).build();
    public static final FontAwesome7IconType scale_unbalanced_flip_s = on(FontAwesome7Solid.scale_unbalanced_flip).build();
    public static final FontAwesome7IconType scale_unbalanced_s = on(FontAwesome7Solid.scale_unbalanced).build();
    public static final FontAwesome7IconType school_circle_check_s = on(FontAwesome7Solid.school_circle_check).build();
    public static final FontAwesome7IconType school_circle_exclamation_s = on(FontAwesome7Solid.school_circle_exclamation).build();
    public static final FontAwesome7IconType school_circle_xmark_s = on(FontAwesome7Solid.school_circle_xmark).build();
    public static final FontAwesome7IconType school_flag_s = on(FontAwesome7Solid.school_flag).build();
    public static final FontAwesome7IconType school_lock_s = on(FontAwesome7Solid.school_lock).build();
    public static final FontAwesome7IconType school_s = on(FontAwesome7Solid.school).build();
    public static final FontAwesome7IconType scissors_s = on(FontAwesome7Solid.scissors).build();
    public static final FontAwesome7IconType screwdriver_s = on(FontAwesome7Solid.screwdriver).build();
    public static final FontAwesome7IconType screwdriver_wrench_s = on(FontAwesome7Solid.screwdriver_wrench).build();
    public static final FontAwesome7IconType scroll_s = on(FontAwesome7Solid.scroll).build();
    public static final FontAwesome7IconType scroll_torah_s = on(FontAwesome7Solid.scroll_torah).build();
    public static final FontAwesome7IconType sd_card_s = on(FontAwesome7Solid.sd_card).build();
    public static final FontAwesome7IconType search_dollar_s = on(FontAwesome7Solid.search_dollar).build();
    public static final FontAwesome7IconType search_location_s = on(FontAwesome7Solid.search_location).build();
    public static final FontAwesome7IconType search_minus_s = on(FontAwesome7Solid.search_minus).build();
    public static final FontAwesome7IconType search_plus_s = on(FontAwesome7Solid.search_plus).build();
    public static final FontAwesome7IconType search_s = on(FontAwesome7Solid.search).build();
    public static final FontAwesome7IconType section_s = on(FontAwesome7Solid.section).build();
    public static final FontAwesome7IconType seedling_s = on(FontAwesome7Solid.seedling).build();
    public static final FontAwesome7IconType septagon_s = on(FontAwesome7Solid.septagon).build();
    public static final FontAwesome7IconType server_s = on(FontAwesome7Solid.server).build();
    public static final FontAwesome7IconType shapes_s = on(FontAwesome7Solid.shapes).build();
    public static final FontAwesome7IconType share_alt_s = on(FontAwesome7Solid.share_alt).build();
    public static final FontAwesome7IconType share_alt_square_s = on(FontAwesome7Solid.share_alt_square).build();
    public static final FontAwesome7IconType share_from_square_r = on(FontAwesome7Regular.share_from_square).build();
    public static final FontAwesome7IconType share_from_square_s = on(FontAwesome7Solid.share_from_square).build();
    public static final FontAwesome7IconType share_nodes_s = on(FontAwesome7Solid.share_nodes).build();
    public static final FontAwesome7IconType share_s = on(FontAwesome7Solid.share).build();
    public static final FontAwesome7IconType share_square_r = on(FontAwesome7Regular.share_square).build();
    public static final FontAwesome7IconType share_square_s = on(FontAwesome7Solid.share_square).build();
    public static final FontAwesome7IconType sheet_plastic_s = on(FontAwesome7Solid.sheet_plastic).build();
    public static final FontAwesome7IconType shekel_s = on(FontAwesome7Solid.shekel).build();
    public static final FontAwesome7IconType shekel_sign_s = on(FontAwesome7Solid.shekel_sign).build();
    public static final FontAwesome7IconType sheqel_s = on(FontAwesome7Solid.sheqel).build();
    public static final FontAwesome7IconType sheqel_sign_s = on(FontAwesome7Solid.sheqel_sign).build();
    public static final FontAwesome7IconType shield_alt_s = on(FontAwesome7Solid.shield_alt).build();
    public static final FontAwesome7IconType shield_blank_s = on(FontAwesome7Solid.shield_blank).build();
    public static final FontAwesome7IconType shield_cat_s = on(FontAwesome7Solid.shield_cat).build();
    public static final FontAwesome7IconType shield_dog_s = on(FontAwesome7Solid.shield_dog).build();
    public static final FontAwesome7IconType shield_halved_s = on(FontAwesome7Solid.shield_halved).build();
    public static final FontAwesome7IconType shield_heart_s = on(FontAwesome7Solid.shield_heart).build();
    public static final FontAwesome7IconType shield_s = on(FontAwesome7Solid.shield).build();
    public static final FontAwesome7IconType shield_virus_s = on(FontAwesome7Solid.shield_virus).build();
    public static final FontAwesome7IconType ship_s = on(FontAwesome7Solid.ship).build();
    public static final FontAwesome7IconType shipping_fast_s = on(FontAwesome7Solid.shipping_fast).build();
    public static final FontAwesome7IconType shirt_s = on(FontAwesome7Solid.shirt).build();
    public static final FontAwesome7IconType shoe_prints_s = on(FontAwesome7Solid.shoe_prints).build();
    public static final FontAwesome7IconType shop_lock_s = on(FontAwesome7Solid.shop_lock).build();
    public static final FontAwesome7IconType shop_s = on(FontAwesome7Solid.shop).build();
    public static final FontAwesome7IconType shop_slash_s = on(FontAwesome7Solid.shop_slash).build();
    public static final FontAwesome7IconType shopping_bag_s = on(FontAwesome7Solid.shopping_bag).build();
    public static final FontAwesome7IconType shopping_basket_s = on(FontAwesome7Solid.shopping_basket).build();
    public static final FontAwesome7IconType shopping_cart_s = on(FontAwesome7Solid.shopping_cart).build();
    public static final FontAwesome7IconType shower_s = on(FontAwesome7Solid.shower).build();
    public static final FontAwesome7IconType shrimp_s = on(FontAwesome7Solid.shrimp).build();
    public static final FontAwesome7IconType shuffle_s = on(FontAwesome7Solid.shuffle).build();
    public static final FontAwesome7IconType shuttle_space_s = on(FontAwesome7Solid.shuttle_space).build();
    public static final FontAwesome7IconType shuttle_van_s = on(FontAwesome7Solid.shuttle_van).build();
    public static final FontAwesome7IconType sign_hanging_s = on(FontAwesome7Solid.sign_hanging).build();
    public static final FontAwesome7IconType sign_in_alt_s = on(FontAwesome7Solid.sign_in_alt).build();
    public static final FontAwesome7IconType sign_in_s = on(FontAwesome7Solid.sign_in).build();
    public static final FontAwesome7IconType sign_language_s = on(FontAwesome7Solid.sign_language).build();
    public static final FontAwesome7IconType sign_out_alt_s = on(FontAwesome7Solid.sign_out_alt).build();
    public static final FontAwesome7IconType sign_out_s = on(FontAwesome7Solid.sign_out).build();
    public static final FontAwesome7IconType sign_s = on(FontAwesome7Solid.sign).build();
    public static final FontAwesome7IconType signal_5_s = on(FontAwesome7Solid.signal_5).build();
    public static final FontAwesome7IconType signal_perfect_s = on(FontAwesome7Solid.signal_perfect).build();
    public static final FontAwesome7IconType signal_s = on(FontAwesome7Solid.signal).build();
    public static final FontAwesome7IconType signature_s = on(FontAwesome7Solid.signature).build();
    public static final FontAwesome7IconType signing_s = on(FontAwesome7Solid.signing).build();
    public static final FontAwesome7IconType signs_post_s = on(FontAwesome7Solid.signs_post).build();
    public static final FontAwesome7IconType sim_card_s = on(FontAwesome7Solid.sim_card).build();
    public static final FontAwesome7IconType single_quote_left_s = on(FontAwesome7Solid.single_quote_left).build();
    public static final FontAwesome7IconType single_quote_right_s = on(FontAwesome7Solid.single_quote_right).build();
    public static final FontAwesome7IconType sink_s = on(FontAwesome7Solid.sink).build();
    public static final FontAwesome7IconType sitemap_s = on(FontAwesome7Solid.sitemap).build();
    public static final FontAwesome7IconType skating_s = on(FontAwesome7Solid.skating).build();
    public static final FontAwesome7IconType skiing_nordic_s = on(FontAwesome7Solid.skiing_nordic).build();
    public static final FontAwesome7IconType skiing_s = on(FontAwesome7Solid.skiing).build();
    public static final FontAwesome7IconType skull_crossbones_s = on(FontAwesome7Solid.skull_crossbones).build();
    public static final FontAwesome7IconType skull_s = on(FontAwesome7Solid.skull).build();
    public static final FontAwesome7IconType slash_s = on(FontAwesome7Solid.slash).build();
    public static final FontAwesome7IconType sleigh_s = on(FontAwesome7Solid.sleigh).build();
    public static final FontAwesome7IconType sliders_h_s = on(FontAwesome7Solid.sliders_h).build();
    public static final FontAwesome7IconType sliders_s = on(FontAwesome7Solid.sliders).build();
    public static final FontAwesome7IconType smile_beam_r = on(FontAwesome7Regular.smile_beam).build();
    public static final FontAwesome7IconType smile_beam_s = on(FontAwesome7Solid.smile_beam).build();
    public static final FontAwesome7IconType smile_r = on(FontAwesome7Regular.smile).build();
    public static final FontAwesome7IconType smile_s = on(FontAwesome7Solid.smile).build();
    public static final FontAwesome7IconType smile_wink_r = on(FontAwesome7Regular.smile_wink).build();
    public static final FontAwesome7IconType smile_wink_s = on(FontAwesome7Solid.smile_wink).build();
    public static final FontAwesome7IconType smog_s = on(FontAwesome7Solid.smog).build();
    public static final FontAwesome7IconType smoking_ban_s = on(FontAwesome7Solid.smoking_ban).build();
    public static final FontAwesome7IconType smoking_s = on(FontAwesome7Solid.smoking).build();
    public static final FontAwesome7IconType sms_s = on(FontAwesome7Solid.sms).build();
    public static final FontAwesome7IconType snowboarding_s = on(FontAwesome7Solid.snowboarding).build();
    public static final FontAwesome7IconType snowflake_r = on(FontAwesome7Regular.snowflake).build();
    public static final FontAwesome7IconType snowflake_s = on(FontAwesome7Solid.snowflake).build();
    public static final FontAwesome7IconType snowman_s = on(FontAwesome7Solid.snowman).build();
    public static final FontAwesome7IconType snowplow_s = on(FontAwesome7Solid.snowplow).build();
    public static final FontAwesome7IconType soap_s = on(FontAwesome7Solid.soap).build();
    public static final FontAwesome7IconType soccer_ball_r = on(FontAwesome7Regular.soccer_ball).build();
    public static final FontAwesome7IconType soccer_ball_s = on(FontAwesome7Solid.soccer_ball).build();
    public static final FontAwesome7IconType socks_s = on(FontAwesome7Solid.socks).build();
    public static final FontAwesome7IconType solar_panel_s = on(FontAwesome7Solid.solar_panel).build();
    public static final FontAwesome7IconType sort_alpha_asc_s = on(FontAwesome7Solid.sort_alpha_asc).build();
    public static final FontAwesome7IconType sort_alpha_desc_s = on(FontAwesome7Solid.sort_alpha_desc).build();
    public static final FontAwesome7IconType sort_alpha_down_alt_s = on(FontAwesome7Solid.sort_alpha_down_alt).build();
    public static final FontAwesome7IconType sort_alpha_down_s = on(FontAwesome7Solid.sort_alpha_down).build();
    public static final FontAwesome7IconType sort_alpha_up_alt_s = on(FontAwesome7Solid.sort_alpha_up_alt).build();
    public static final FontAwesome7IconType sort_alpha_up_s = on(FontAwesome7Solid.sort_alpha_up).build();
    public static final FontAwesome7IconType sort_amount_asc_s = on(FontAwesome7Solid.sort_amount_asc).build();
    public static final FontAwesome7IconType sort_amount_desc_s = on(FontAwesome7Solid.sort_amount_desc).build();
    public static final FontAwesome7IconType sort_amount_down_alt_s = on(FontAwesome7Solid.sort_amount_down_alt).build();
    public static final FontAwesome7IconType sort_amount_down_s = on(FontAwesome7Solid.sort_amount_down).build();
    public static final FontAwesome7IconType sort_amount_up_alt_s = on(FontAwesome7Solid.sort_amount_up_alt).build();
    public static final FontAwesome7IconType sort_amount_up_s = on(FontAwesome7Solid.sort_amount_up).build();
    public static final FontAwesome7IconType sort_asc_s = on(FontAwesome7Solid.sort_asc).build();
    public static final FontAwesome7IconType sort_desc_s = on(FontAwesome7Solid.sort_desc).build();
    public static final FontAwesome7IconType sort_down_s = on(FontAwesome7Solid.sort_down).build();
    public static final FontAwesome7IconType sort_numeric_asc_s = on(FontAwesome7Solid.sort_numeric_asc).build();
    public static final FontAwesome7IconType sort_numeric_desc_s = on(FontAwesome7Solid.sort_numeric_desc).build();
    public static final FontAwesome7IconType sort_numeric_down_alt_s = on(FontAwesome7Solid.sort_numeric_down_alt).build();
    public static final FontAwesome7IconType sort_numeric_down_s = on(FontAwesome7Solid.sort_numeric_down).build();
    public static final FontAwesome7IconType sort_numeric_up_alt_s = on(FontAwesome7Solid.sort_numeric_up_alt).build();
    public static final FontAwesome7IconType sort_numeric_up_s = on(FontAwesome7Solid.sort_numeric_up).build();
    public static final FontAwesome7IconType sort_s = on(FontAwesome7Solid.sort).build();
    public static final FontAwesome7IconType sort_up_s = on(FontAwesome7Solid.sort_up).build();
    public static final FontAwesome7IconType spa_s = on(FontAwesome7Solid.spa).build();
    public static final FontAwesome7IconType space_shuttle_s = on(FontAwesome7Solid.space_shuttle).build();
    public static final FontAwesome7IconType spaghetti_monster_flying_s = on(FontAwesome7Solid.spaghetti_monster_flying).build();
    public static final FontAwesome7IconType spell_check_s = on(FontAwesome7Solid.spell_check).build();
    public static final FontAwesome7IconType spider_s = on(FontAwesome7Solid.spider).build();
    public static final FontAwesome7IconType spinner_s = on(FontAwesome7Solid.spinner).build();
    public static final FontAwesome7IconType spiral_s = on(FontAwesome7Solid.spiral).build();
    public static final FontAwesome7IconType splotch_s = on(FontAwesome7Solid.splotch).build();
    public static final FontAwesome7IconType spoon_s = on(FontAwesome7Solid.spoon).build();
    public static final FontAwesome7IconType spray_can_s = on(FontAwesome7Solid.spray_can).build();
    public static final FontAwesome7IconType spray_can_sparkles_s = on(FontAwesome7Solid.spray_can_sparkles).build();
    public static final FontAwesome7IconType sprout_s = on(FontAwesome7Solid.sprout).build();
    public static final FontAwesome7IconType square_arrow_up_right_s = on(FontAwesome7Solid.square_arrow_up_right).build();
    public static final FontAwesome7IconType square_binary_s = on(FontAwesome7Solid.square_binary).build();
    public static final FontAwesome7IconType square_caret_down_r = on(FontAwesome7Regular.square_caret_down).build();
    public static final FontAwesome7IconType square_caret_down_s = on(FontAwesome7Solid.square_caret_down).build();
    public static final FontAwesome7IconType square_caret_left_r = on(FontAwesome7Regular.square_caret_left).build();
    public static final FontAwesome7IconType square_caret_left_s = on(FontAwesome7Solid.square_caret_left).build();
    public static final FontAwesome7IconType square_caret_right_r = on(FontAwesome7Regular.square_caret_right).build();
    public static final FontAwesome7IconType square_caret_right_s = on(FontAwesome7Solid.square_caret_right).build();
    public static final FontAwesome7IconType square_caret_up_r = on(FontAwesome7Regular.square_caret_up).build();
    public static final FontAwesome7IconType square_caret_up_s = on(FontAwesome7Solid.square_caret_up).build();
    public static final FontAwesome7IconType square_check_r = on(FontAwesome7Regular.square_check).build();
    public static final FontAwesome7IconType square_check_s = on(FontAwesome7Solid.square_check).build();
    public static final FontAwesome7IconType square_envelope_s = on(FontAwesome7Solid.square_envelope).build();
    public static final FontAwesome7IconType square_full_r = on(FontAwesome7Regular.square_full).build();
    public static final FontAwesome7IconType square_full_s = on(FontAwesome7Solid.square_full).build();
    public static final FontAwesome7IconType square_h_s = on(FontAwesome7Solid.square_h).build();
    public static final FontAwesome7IconType square_minus_r = on(FontAwesome7Regular.square_minus).build();
    public static final FontAwesome7IconType square_minus_s = on(FontAwesome7Solid.square_minus).build();
    public static final FontAwesome7IconType square_nfi_s = on(FontAwesome7Solid.square_nfi).build();
    public static final FontAwesome7IconType square_parking_s = on(FontAwesome7Solid.square_parking).build();
    public static final FontAwesome7IconType square_pen_s = on(FontAwesome7Solid.square_pen).build();
    public static final FontAwesome7IconType square_person_confined_s = on(FontAwesome7Solid.square_person_confined).build();
    public static final FontAwesome7IconType square_phone_flip_s = on(FontAwesome7Solid.square_phone_flip).build();
    public static final FontAwesome7IconType square_phone_s = on(FontAwesome7Solid.square_phone).build();
    public static final FontAwesome7IconType square_plus_r = on(FontAwesome7Regular.square_plus).build();
    public static final FontAwesome7IconType square_plus_s = on(FontAwesome7Solid.square_plus).build();
    public static final FontAwesome7IconType square_poll_horizontal_s = on(FontAwesome7Solid.square_poll_horizontal).build();
    public static final FontAwesome7IconType square_poll_vertical_s = on(FontAwesome7Solid.square_poll_vertical).build();
    public static final FontAwesome7IconType square_r = on(FontAwesome7Regular.square).build();
    public static final FontAwesome7IconType square_root_alt_s = on(FontAwesome7Solid.square_root_alt).build();
    public static final FontAwesome7IconType square_root_variable_s = on(FontAwesome7Solid.square_root_variable).build();
    public static final FontAwesome7IconType square_rss_s = on(FontAwesome7Solid.square_rss).build();
    public static final FontAwesome7IconType square_s = on(FontAwesome7Solid.square).build();
    public static final FontAwesome7IconType square_share_nodes_s = on(FontAwesome7Solid.square_share_nodes).build();
    public static final FontAwesome7IconType square_up_right_s = on(FontAwesome7Solid.square_up_right).build();
    public static final FontAwesome7IconType square_virus_s = on(FontAwesome7Solid.square_virus).build();
    public static final FontAwesome7IconType square_xmark_s = on(FontAwesome7Solid.square_xmark).build();
    public static final FontAwesome7IconType staff_aesculapius_s = on(FontAwesome7Solid.staff_aesculapius).build();
    public static final FontAwesome7IconType staff_snake_s = on(FontAwesome7Solid.staff_snake).build();
    public static final FontAwesome7IconType stairs_s = on(FontAwesome7Solid.stairs).build();
    public static final FontAwesome7IconType stamp_s = on(FontAwesome7Solid.stamp).build();
    public static final FontAwesome7IconType stapler_s = on(FontAwesome7Solid.stapler).build();
    public static final FontAwesome7IconType star_and_crescent_s = on(FontAwesome7Solid.star_and_crescent).build();
    public static final FontAwesome7IconType star_half_alt_r = on(FontAwesome7Regular.star_half_alt).build();
    public static final FontAwesome7IconType star_half_alt_s = on(FontAwesome7Solid.star_half_alt).build();
    public static final FontAwesome7IconType star_half_r = on(FontAwesome7Regular.star_half).build();
    public static final FontAwesome7IconType star_half_s = on(FontAwesome7Solid.star_half).build();
    public static final FontAwesome7IconType star_half_stroke_r = on(FontAwesome7Regular.star_half_stroke).build();
    public static final FontAwesome7IconType star_half_stroke_s = on(FontAwesome7Solid.star_half_stroke).build();
    public static final FontAwesome7IconType star_of_david_s = on(FontAwesome7Solid.star_of_david).build();
    public static final FontAwesome7IconType star_of_life_s = on(FontAwesome7Solid.star_of_life).build();
    public static final FontAwesome7IconType star_r = on(FontAwesome7Regular.star).build();
    public static final FontAwesome7IconType star_s = on(FontAwesome7Solid.star).build();
    public static final FontAwesome7IconType step_backward_s = on(FontAwesome7Solid.step_backward).build();
    public static final FontAwesome7IconType step_forward_s = on(FontAwesome7Solid.step_forward).build();
    public static final FontAwesome7IconType sterling_sign_s = on(FontAwesome7Solid.sterling_sign).build();
    public static final FontAwesome7IconType stethoscope_s = on(FontAwesome7Solid.stethoscope).build();
    public static final FontAwesome7IconType sticky_note_r = on(FontAwesome7Regular.sticky_note).build();
    public static final FontAwesome7IconType sticky_note_s = on(FontAwesome7Solid.sticky_note).build();
    public static final FontAwesome7IconType stop_circle_r = on(FontAwesome7Regular.stop_circle).build();
    public static final FontAwesome7IconType stop_circle_s = on(FontAwesome7Solid.stop_circle).build();
    public static final FontAwesome7IconType stop_s = on(FontAwesome7Solid.stop).build();
    public static final FontAwesome7IconType stopwatch_20_s = on(FontAwesome7Solid.stopwatch_20).build();
    public static final FontAwesome7IconType stopwatch_s = on(FontAwesome7Solid.stopwatch).build();
    public static final FontAwesome7IconType store_alt_s = on(FontAwesome7Solid.store_alt).build();
    public static final FontAwesome7IconType store_alt_slash_s = on(FontAwesome7Solid.store_alt_slash).build();
    public static final FontAwesome7IconType store_s = on(FontAwesome7Solid.store).build();
    public static final FontAwesome7IconType store_slash_s = on(FontAwesome7Solid.store_slash).build();
    public static final FontAwesome7IconType stream_s = on(FontAwesome7Solid.stream).build();
    public static final FontAwesome7IconType street_view_s = on(FontAwesome7Solid.street_view).build();
    public static final FontAwesome7IconType strikethrough_s = on(FontAwesome7Solid.strikethrough).build();
    public static final FontAwesome7IconType stroopwafel_s = on(FontAwesome7Solid.stroopwafel).build();
    public static final FontAwesome7IconType subscript_s = on(FontAwesome7Solid.subscript).build();
    public static final FontAwesome7IconType subtract_s = on(FontAwesome7Solid.subtract).build();
    public static final FontAwesome7IconType subway_s = on(FontAwesome7Solid.subway).build();
    public static final FontAwesome7IconType suitcase_medical_s = on(FontAwesome7Solid.suitcase_medical).build();
    public static final FontAwesome7IconType suitcase_rolling_s = on(FontAwesome7Solid.suitcase_rolling).build();
    public static final FontAwesome7IconType suitcase_s = on(FontAwesome7Solid.suitcase).build();
    public static final FontAwesome7IconType sun_plant_wilt_s = on(FontAwesome7Solid.sun_plant_wilt).build();
    public static final FontAwesome7IconType sun_r = on(FontAwesome7Regular.sun).build();
    public static final FontAwesome7IconType sun_s = on(FontAwesome7Solid.sun).build();
    public static final FontAwesome7IconType superscript_s = on(FontAwesome7Solid.superscript).build();
    public static final FontAwesome7IconType surprise_r = on(FontAwesome7Regular.surprise).build();
    public static final FontAwesome7IconType surprise_s = on(FontAwesome7Solid.surprise).build();
    public static final FontAwesome7IconType swatchbook_s = on(FontAwesome7Solid.swatchbook).build();
    public static final FontAwesome7IconType swimmer_s = on(FontAwesome7Solid.swimmer).build();
    public static final FontAwesome7IconType swimming_pool_s = on(FontAwesome7Solid.swimming_pool).build();
    public static final FontAwesome7IconType synagogue_s = on(FontAwesome7Solid.synagogue).build();
    public static final FontAwesome7IconType sync_alt_s = on(FontAwesome7Solid.sync_alt).build();
    public static final FontAwesome7IconType sync_s = on(FontAwesome7Solid.sync).build();
    public static final FontAwesome7IconType syringe_s = on(FontAwesome7Solid.syringe).build();
    public static final FontAwesome7IconType t_s = on(FontAwesome7Solid.t).build();
    public static final FontAwesome7IconType t_shirt_s = on(FontAwesome7Solid.t_shirt).build();
    public static final FontAwesome7IconType table_cells_column_lock_s = on(FontAwesome7Solid.table_cells_column_lock).build();
    public static final FontAwesome7IconType table_cells_large_s = on(FontAwesome7Solid.table_cells_large).build();
    public static final FontAwesome7IconType table_cells_row_lock_s = on(FontAwesome7Solid.table_cells_row_lock).build();
    public static final FontAwesome7IconType table_cells_row_unlock_s = on(FontAwesome7Solid.table_cells_row_unlock).build();
    public static final FontAwesome7IconType table_cells_s = on(FontAwesome7Solid.table_cells).build();
    public static final FontAwesome7IconType table_columns_s = on(FontAwesome7Solid.table_columns).build();
    public static final FontAwesome7IconType table_list_s = on(FontAwesome7Solid.table_list).build();
    public static final FontAwesome7IconType table_s = on(FontAwesome7Solid.table).build();
    public static final FontAwesome7IconType table_tennis_paddle_ball_s = on(FontAwesome7Solid.table_tennis_paddle_ball).build();
    public static final FontAwesome7IconType table_tennis_s = on(FontAwesome7Solid.table_tennis).build();
    public static final FontAwesome7IconType tablet_alt_s = on(FontAwesome7Solid.tablet_alt).build();
    public static final FontAwesome7IconType tablet_android_s = on(FontAwesome7Solid.tablet_android).build();
    public static final FontAwesome7IconType tablet_button_s = on(FontAwesome7Solid.tablet_button).build();
    public static final FontAwesome7IconType tablet_s = on(FontAwesome7Solid.tablet).build();
    public static final FontAwesome7IconType tablet_screen_button_s = on(FontAwesome7Solid.tablet_screen_button).build();
    public static final FontAwesome7IconType tablets_s = on(FontAwesome7Solid.tablets).build();
    public static final FontAwesome7IconType tachograph_digital_s = on(FontAwesome7Solid.tachograph_digital).build();
    public static final FontAwesome7IconType tachometer_alt_average_s = on(FontAwesome7Solid.tachometer_alt_average).build();
    public static final FontAwesome7IconType tachometer_alt_fast_s = on(FontAwesome7Solid.tachometer_alt_fast).build();
    public static final FontAwesome7IconType tachometer_alt_s = on(FontAwesome7Solid.tachometer_alt).build();
    public static final FontAwesome7IconType tachometer_average_s = on(FontAwesome7Solid.tachometer_average).build();
    public static final FontAwesome7IconType tachometer_fast_s = on(FontAwesome7Solid.tachometer_fast).build();
    public static final FontAwesome7IconType tachometer_s = on(FontAwesome7Solid.tachometer).build();
    public static final FontAwesome7IconType tag_s = on(FontAwesome7Solid.tag).build();
    public static final FontAwesome7IconType tags_s = on(FontAwesome7Solid.tags).build();
    public static final FontAwesome7IconType tanakh_s = on(FontAwesome7Solid.tanakh).build();
    public static final FontAwesome7IconType tape_s = on(FontAwesome7Solid.tape).build();
    public static final FontAwesome7IconType tarp_droplet_s = on(FontAwesome7Solid.tarp_droplet).build();
    public static final FontAwesome7IconType tarp_s = on(FontAwesome7Solid.tarp).build();
    public static final FontAwesome7IconType tasks_alt_s = on(FontAwesome7Solid.tasks_alt).build();
    public static final FontAwesome7IconType tasks_s = on(FontAwesome7Solid.tasks).build();
    public static final FontAwesome7IconType taxi_s = on(FontAwesome7Solid.taxi).build();
    public static final FontAwesome7IconType teeth_open_s = on(FontAwesome7Solid.teeth_open).build();
    public static final FontAwesome7IconType teeth_s = on(FontAwesome7Solid.teeth).build();
    public static final FontAwesome7IconType teletype_s = on(FontAwesome7Solid.teletype).build();
    public static final FontAwesome7IconType television_s = on(FontAwesome7Solid.television).build();
    public static final FontAwesome7IconType temperature_0_s = on(FontAwesome7Solid.temperature_0).build();
    public static final FontAwesome7IconType temperature_1_s = on(FontAwesome7Solid.temperature_1).build();
    public static final FontAwesome7IconType temperature_2_s = on(FontAwesome7Solid.temperature_2).build();
    public static final FontAwesome7IconType temperature_3_s = on(FontAwesome7Solid.temperature_3).build();
    public static final FontAwesome7IconType temperature_4_s = on(FontAwesome7Solid.temperature_4).build();
    public static final FontAwesome7IconType temperature_arrow_down_s = on(FontAwesome7Solid.temperature_arrow_down).build();
    public static final FontAwesome7IconType temperature_arrow_up_s = on(FontAwesome7Solid.temperature_arrow_up).build();
    public static final FontAwesome7IconType temperature_down_s = on(FontAwesome7Solid.temperature_down).build();
    public static final FontAwesome7IconType temperature_empty_s = on(FontAwesome7Solid.temperature_empty).build();
    public static final FontAwesome7IconType temperature_full_s = on(FontAwesome7Solid.temperature_full).build();
    public static final FontAwesome7IconType temperature_half_s = on(FontAwesome7Solid.temperature_half).build();
    public static final FontAwesome7IconType temperature_high_s = on(FontAwesome7Solid.temperature_high).build();
    public static final FontAwesome7IconType temperature_low_s = on(FontAwesome7Solid.temperature_low).build();
    public static final FontAwesome7IconType temperature_quarter_s = on(FontAwesome7Solid.temperature_quarter).build();
    public static final FontAwesome7IconType temperature_three_quarters_s = on(FontAwesome7Solid.temperature_three_quarters).build();
    public static final FontAwesome7IconType temperature_up_s = on(FontAwesome7Solid.temperature_up).build();
    public static final FontAwesome7IconType tenge_s = on(FontAwesome7Solid.tenge).build();
    public static final FontAwesome7IconType tenge_sign_s = on(FontAwesome7Solid.tenge_sign).build();
    public static final FontAwesome7IconType tent_arrow_down_to_line_s = on(FontAwesome7Solid.tent_arrow_down_to_line).build();
    public static final FontAwesome7IconType tent_arrow_left_right_s = on(FontAwesome7Solid.tent_arrow_left_right).build();
    public static final FontAwesome7IconType tent_arrow_turn_left_s = on(FontAwesome7Solid.tent_arrow_turn_left).build();
    public static final FontAwesome7IconType tent_arrows_down_s = on(FontAwesome7Solid.tent_arrows_down).build();
    public static final FontAwesome7IconType tent_s = on(FontAwesome7Solid.tent).build();
    public static final FontAwesome7IconType tents_s = on(FontAwesome7Solid.tents).build();
    public static final FontAwesome7IconType terminal_s = on(FontAwesome7Solid.terminal).build();
    public static final FontAwesome7IconType text_height_s = on(FontAwesome7Solid.text_height).build();
    public static final FontAwesome7IconType text_slash_s = on(FontAwesome7Solid.text_slash).build();
    public static final FontAwesome7IconType text_width_s = on(FontAwesome7Solid.text_width).build();
    public static final FontAwesome7IconType th_large_s = on(FontAwesome7Solid.th_large).build();
    public static final FontAwesome7IconType th_list_s = on(FontAwesome7Solid.th_list).build();
    public static final FontAwesome7IconType th_s = on(FontAwesome7Solid.th).build();
    public static final FontAwesome7IconType theater_masks_s = on(FontAwesome7Solid.theater_masks).build();
    public static final FontAwesome7IconType thermometer_0_s = on(FontAwesome7Solid.thermometer_0).build();
    public static final FontAwesome7IconType thermometer_1_s = on(FontAwesome7Solid.thermometer_1).build();
    public static final FontAwesome7IconType thermometer_2_s = on(FontAwesome7Solid.thermometer_2).build();
    public static final FontAwesome7IconType thermometer_3_s = on(FontAwesome7Solid.thermometer_3).build();
    public static final FontAwesome7IconType thermometer_4_s = on(FontAwesome7Solid.thermometer_4).build();
    public static final FontAwesome7IconType thermometer_empty_s = on(FontAwesome7Solid.thermometer_empty).build();
    public static final FontAwesome7IconType thermometer_full_s = on(FontAwesome7Solid.thermometer_full).build();
    public static final FontAwesome7IconType thermometer_half_s = on(FontAwesome7Solid.thermometer_half).build();
    public static final FontAwesome7IconType thermometer_quarter_s = on(FontAwesome7Solid.thermometer_quarter).build();
    public static final FontAwesome7IconType thermometer_s = on(FontAwesome7Solid.thermometer).build();
    public static final FontAwesome7IconType thermometer_three_quarters_s = on(FontAwesome7Solid.thermometer_three_quarters).build();
    public static final FontAwesome7IconType thumb_tack_s = on(FontAwesome7Solid.thumb_tack).build();
    public static final FontAwesome7IconType thumb_tack_slash_s = on(FontAwesome7Solid.thumb_tack_slash).build();
    public static final FontAwesome7IconType thumbs_down_r = on(FontAwesome7Regular.thumbs_down).build();
    public static final FontAwesome7IconType thumbs_down_s = on(FontAwesome7Solid.thumbs_down).build();
    public static final FontAwesome7IconType thumbs_up_r = on(FontAwesome7Regular.thumbs_up).build();
    public static final FontAwesome7IconType thumbs_up_s = on(FontAwesome7Solid.thumbs_up).build();
    public static final FontAwesome7IconType thumbtack_s = on(FontAwesome7Solid.thumbtack).build();
    public static final FontAwesome7IconType thumbtack_slash_s = on(FontAwesome7Solid.thumbtack_slash).build();
    public static final FontAwesome7IconType thunderstorm_s = on(FontAwesome7Solid.thunderstorm).build();
    public static final FontAwesome7IconType ticket_alt_s = on(FontAwesome7Solid.ticket_alt).build();
    public static final FontAwesome7IconType ticket_s = on(FontAwesome7Solid.ticket).build();
    public static final FontAwesome7IconType ticket_simple_s = on(FontAwesome7Solid.ticket_simple).build();
    public static final FontAwesome7IconType timeline_s = on(FontAwesome7Solid.timeline).build();
    public static final FontAwesome7IconType times_circle_r = on(FontAwesome7Regular.times_circle).build();
    public static final FontAwesome7IconType times_circle_s = on(FontAwesome7Solid.times_circle).build();
    public static final FontAwesome7IconType times_rectangle_r = on(FontAwesome7Regular.times_rectangle).build();
    public static final FontAwesome7IconType times_rectangle_s = on(FontAwesome7Solid.times_rectangle).build();
    public static final FontAwesome7IconType times_s = on(FontAwesome7Solid.times).build();
    public static final FontAwesome7IconType times_square_s = on(FontAwesome7Solid.times_square).build();
    public static final FontAwesome7IconType tint_s = on(FontAwesome7Solid.tint).build();
    public static final FontAwesome7IconType tint_slash_s = on(FontAwesome7Solid.tint_slash).build();
    public static final FontAwesome7IconType tired_r = on(FontAwesome7Regular.tired).build();
    public static final FontAwesome7IconType tired_s = on(FontAwesome7Solid.tired).build();
    public static final FontAwesome7IconType toggle_off_s = on(FontAwesome7Solid.toggle_off).build();
    public static final FontAwesome7IconType toggle_on_s = on(FontAwesome7Solid.toggle_on).build();
    public static final FontAwesome7IconType toilet_paper_alt_s = on(FontAwesome7Solid.toilet_paper_alt).build();
    public static final FontAwesome7IconType toilet_paper_blank_s = on(FontAwesome7Solid.toilet_paper_blank).build();
    public static final FontAwesome7IconType toilet_paper_s = on(FontAwesome7Solid.toilet_paper).build();
    public static final FontAwesome7IconType toilet_paper_slash_s = on(FontAwesome7Solid.toilet_paper_slash).build();
    public static final FontAwesome7IconType toilet_portable_s = on(FontAwesome7Solid.toilet_portable).build();
    public static final FontAwesome7IconType toilet_s = on(FontAwesome7Solid.toilet).build();
    public static final FontAwesome7IconType toilets_portable_s = on(FontAwesome7Solid.toilets_portable).build();
    public static final FontAwesome7IconType toolbox_s = on(FontAwesome7Solid.toolbox).build();
    public static final FontAwesome7IconType tools_s = on(FontAwesome7Solid.tools).build();
    public static final FontAwesome7IconType tooth_s = on(FontAwesome7Solid.tooth).build();
    public static final FontAwesome7IconType torah_s = on(FontAwesome7Solid.torah).build();
    public static final FontAwesome7IconType torii_gate_s = on(FontAwesome7Solid.torii_gate).build();
    public static final FontAwesome7IconType tornado_s = on(FontAwesome7Solid.tornado).build();
    public static final FontAwesome7IconType tower_broadcast_s = on(FontAwesome7Solid.tower_broadcast).build();
    public static final FontAwesome7IconType tower_cell_s = on(FontAwesome7Solid.tower_cell).build();
    public static final FontAwesome7IconType tower_observation_s = on(FontAwesome7Solid.tower_observation).build();
    public static final FontAwesome7IconType tractor_s = on(FontAwesome7Solid.tractor).build();
    public static final FontAwesome7IconType trademark_s = on(FontAwesome7Solid.trademark).build();
    public static final FontAwesome7IconType traffic_light_s = on(FontAwesome7Solid.traffic_light).build();
    public static final FontAwesome7IconType trailer_s = on(FontAwesome7Solid.trailer).build();
    public static final FontAwesome7IconType train_s = on(FontAwesome7Solid.train).build();
    public static final FontAwesome7IconType train_subway_s = on(FontAwesome7Solid.train_subway).build();
    public static final FontAwesome7IconType train_tram_s = on(FontAwesome7Solid.train_tram).build();
    public static final FontAwesome7IconType tram_s = on(FontAwesome7Solid.tram).build();
    public static final FontAwesome7IconType transgender_alt_s = on(FontAwesome7Solid.transgender_alt).build();
    public static final FontAwesome7IconType transgender_s = on(FontAwesome7Solid.transgender).build();
    public static final FontAwesome7IconType trash_alt_r = on(FontAwesome7Regular.trash_alt).build();
    public static final FontAwesome7IconType trash_alt_s = on(FontAwesome7Solid.trash_alt).build();
    public static final FontAwesome7IconType trash_arrow_up_s = on(FontAwesome7Solid.trash_arrow_up).build();
    public static final FontAwesome7IconType trash_can_arrow_up_s = on(FontAwesome7Solid.trash_can_arrow_up).build();
    public static final FontAwesome7IconType trash_can_r = on(FontAwesome7Regular.trash_can).build();
    public static final FontAwesome7IconType trash_can_s = on(FontAwesome7Solid.trash_can).build();
    public static final FontAwesome7IconType trash_restore_alt_s = on(FontAwesome7Solid.trash_restore_alt).build();
    public static final FontAwesome7IconType trash_restore_s = on(FontAwesome7Solid.trash_restore).build();
    public static final FontAwesome7IconType trash_s = on(FontAwesome7Solid.trash).build();
    public static final FontAwesome7IconType tree_city_s = on(FontAwesome7Solid.tree_city).build();
    public static final FontAwesome7IconType tree_s = on(FontAwesome7Solid.tree).build();
    public static final FontAwesome7IconType triangle_circle_square_s = on(FontAwesome7Solid.triangle_circle_square).build();
    public static final FontAwesome7IconType triangle_exclamation_s = on(FontAwesome7Solid.triangle_exclamation).build();
    public static final FontAwesome7IconType trophy_s = on(FontAwesome7Solid.trophy).build();
    public static final FontAwesome7IconType trowel_bricks_s = on(FontAwesome7Solid.trowel_bricks).build();
    public static final FontAwesome7IconType trowel_s = on(FontAwesome7Solid.trowel).build();
    public static final FontAwesome7IconType truck_arrow_right_s = on(FontAwesome7Solid.truck_arrow_right).build();
    public static final FontAwesome7IconType truck_droplet_s = on(FontAwesome7Solid.truck_droplet).build();
    public static final FontAwesome7IconType truck_fast_s = on(FontAwesome7Solid.truck_fast).build();
    public static final FontAwesome7IconType truck_field_s = on(FontAwesome7Solid.truck_field).build();
    public static final FontAwesome7IconType truck_field_un_s = on(FontAwesome7Solid.truck_field_un).build();
    public static final FontAwesome7IconType truck_front_s = on(FontAwesome7Solid.truck_front).build();
    public static final FontAwesome7IconType truck_loading_s = on(FontAwesome7Solid.truck_loading).build();
    public static final FontAwesome7IconType truck_medical_s = on(FontAwesome7Solid.truck_medical).build();
    public static final FontAwesome7IconType truck_monster_s = on(FontAwesome7Solid.truck_monster).build();
    public static final FontAwesome7IconType truck_moving_s = on(FontAwesome7Solid.truck_moving).build();
    public static final FontAwesome7IconType truck_pickup_s = on(FontAwesome7Solid.truck_pickup).build();
    public static final FontAwesome7IconType truck_plane_s = on(FontAwesome7Solid.truck_plane).build();
    public static final FontAwesome7IconType truck_r = on(FontAwesome7Regular.truck).build();
    public static final FontAwesome7IconType truck_ramp_box_s = on(FontAwesome7Solid.truck_ramp_box).build();
    public static final FontAwesome7IconType truck_s = on(FontAwesome7Solid.truck).build();
    public static final FontAwesome7IconType try_s = on(FontAwesome7Solid._try).build();
    public static final FontAwesome7IconType tshirt_s = on(FontAwesome7Solid.tshirt).build();
    public static final FontAwesome7IconType tty_s = on(FontAwesome7Solid.tty).build();
    public static final FontAwesome7IconType turkish_lira_s = on(FontAwesome7Solid.turkish_lira).build();
    public static final FontAwesome7IconType turkish_lira_sign_s = on(FontAwesome7Solid.turkish_lira_sign).build();
    public static final FontAwesome7IconType turn_down_s = on(FontAwesome7Solid.turn_down).build();
    public static final FontAwesome7IconType turn_up_s = on(FontAwesome7Solid.turn_up).build();
    public static final FontAwesome7IconType tv_alt_s = on(FontAwesome7Solid.tv_alt).build();
    public static final FontAwesome7IconType tv_s = on(FontAwesome7Solid.tv).build();
    public static final FontAwesome7IconType u_s = on(FontAwesome7Solid.u).build();
    public static final FontAwesome7IconType umbrella_beach_s = on(FontAwesome7Solid.umbrella_beach).build();
    public static final FontAwesome7IconType umbrella_s = on(FontAwesome7Solid.umbrella).build();
    public static final FontAwesome7IconType underline_s = on(FontAwesome7Solid.underline).build();
    public static final FontAwesome7IconType undo_alt_s = on(FontAwesome7Solid.undo_alt).build();
    public static final FontAwesome7IconType undo_s = on(FontAwesome7Solid.undo).build();
    public static final FontAwesome7IconType universal_access_s = on(FontAwesome7Solid.universal_access).build();
    public static final FontAwesome7IconType university_s = on(FontAwesome7Solid.university).build();
    public static final FontAwesome7IconType unlink_s = on(FontAwesome7Solid.unlink).build();
    public static final FontAwesome7IconType unlock_alt_s = on(FontAwesome7Solid.unlock_alt).build();
    public static final FontAwesome7IconType unlock_keyhole_s = on(FontAwesome7Solid.unlock_keyhole).build();
    public static final FontAwesome7IconType unlock_s = on(FontAwesome7Solid.unlock).build();
    public static final FontAwesome7IconType unsorted_s = on(FontAwesome7Solid.unsorted).build();
    public static final FontAwesome7IconType up_down_left_right_s = on(FontAwesome7Solid.up_down_left_right).build();
    public static final FontAwesome7IconType up_down_s = on(FontAwesome7Solid.up_down).build();
    public static final FontAwesome7IconType up_long_s = on(FontAwesome7Solid.up_long).build();
    public static final FontAwesome7IconType up_right_and_down_left_from_center_s = on(FontAwesome7Solid.up_right_and_down_left_from_center).build();
    public static final FontAwesome7IconType up_right_from_square_s = on(FontAwesome7Solid.up_right_from_square).build();
    public static final FontAwesome7IconType upload_s = on(FontAwesome7Solid.upload).build();
    public static final FontAwesome7IconType usd_s = on(FontAwesome7Solid.usd).build();
    public static final FontAwesome7IconType user_alt_r = on(FontAwesome7Regular.user_alt).build();
    public static final FontAwesome7IconType user_alt_s = on(FontAwesome7Solid.user_alt).build();
    public static final FontAwesome7IconType user_alt_slash_s = on(FontAwesome7Solid.user_alt_slash).build();
    public static final FontAwesome7IconType user_astronaut_s = on(FontAwesome7Solid.user_astronaut).build();
    public static final FontAwesome7IconType user_check_s = on(FontAwesome7Solid.user_check).build();
    public static final FontAwesome7IconType user_circle_r = on(FontAwesome7Regular.user_circle).build();
    public static final FontAwesome7IconType user_circle_s = on(FontAwesome7Solid.user_circle).build();
    public static final FontAwesome7IconType user_clock_s = on(FontAwesome7Solid.user_clock).build();
    public static final FontAwesome7IconType user_cog_s = on(FontAwesome7Solid.user_cog).build();
    public static final FontAwesome7IconType user_doctor_s = on(FontAwesome7Solid.user_doctor).build();
    public static final FontAwesome7IconType user_edit_s = on(FontAwesome7Solid.user_edit).build();
    public static final FontAwesome7IconType user_friends_s = on(FontAwesome7Solid.user_friends).build();
    public static final FontAwesome7IconType user_gear_s = on(FontAwesome7Solid.user_gear).build();
    public static final FontAwesome7IconType user_graduate_s = on(FontAwesome7Solid.user_graduate).build();
    public static final FontAwesome7IconType user_group_s = on(FontAwesome7Solid.user_group).build();
    public static final FontAwesome7IconType user_injured_s = on(FontAwesome7Solid.user_injured).build();
    public static final FontAwesome7IconType user_large_r = on(FontAwesome7Regular.user_large).build();
    public static final FontAwesome7IconType user_large_s = on(FontAwesome7Solid.user_large).build();
    public static final FontAwesome7IconType user_large_slash_s = on(FontAwesome7Solid.user_large_slash).build();
    public static final FontAwesome7IconType user_lock_s = on(FontAwesome7Solid.user_lock).build();
    public static final FontAwesome7IconType user_md_s = on(FontAwesome7Solid.user_md).build();
    public static final FontAwesome7IconType user_minus_s = on(FontAwesome7Solid.user_minus).build();
    public static final FontAwesome7IconType user_ninja_s = on(FontAwesome7Solid.user_ninja).build();
    public static final FontAwesome7IconType user_nurse_s = on(FontAwesome7Solid.user_nurse).build();
    public static final FontAwesome7IconType user_pen_s = on(FontAwesome7Solid.user_pen).build();
    public static final FontAwesome7IconType user_plus_s = on(FontAwesome7Solid.user_plus).build();
    public static final FontAwesome7IconType user_r = on(FontAwesome7Regular.user).build();
    public static final FontAwesome7IconType user_s = on(FontAwesome7Solid.user).build();
    public static final FontAwesome7IconType user_secret_s = on(FontAwesome7Solid.user_secret).build();
    public static final FontAwesome7IconType user_shield_s = on(FontAwesome7Solid.user_shield).build();
    public static final FontAwesome7IconType user_slash_s = on(FontAwesome7Solid.user_slash).build();
    public static final FontAwesome7IconType user_tag_s = on(FontAwesome7Solid.user_tag).build();
    public static final FontAwesome7IconType user_tie_s = on(FontAwesome7Solid.user_tie).build();
    public static final FontAwesome7IconType user_times_s = on(FontAwesome7Solid.user_times).build();
    public static final FontAwesome7IconType user_xmark_s = on(FontAwesome7Solid.user_xmark).build();
    public static final FontAwesome7IconType users_between_lines_s = on(FontAwesome7Solid.users_between_lines).build();
    public static final FontAwesome7IconType users_cog_s = on(FontAwesome7Solid.users_cog).build();
    public static final FontAwesome7IconType users_gear_s = on(FontAwesome7Solid.users_gear).build();
    public static final FontAwesome7IconType users_line_s = on(FontAwesome7Solid.users_line).build();
    public static final FontAwesome7IconType users_rays_s = on(FontAwesome7Solid.users_rays).build();
    public static final FontAwesome7IconType users_rectangle_s = on(FontAwesome7Solid.users_rectangle).build();
    public static final FontAwesome7IconType users_s = on(FontAwesome7Solid.users).build();
    public static final FontAwesome7IconType users_slash_s = on(FontAwesome7Solid.users_slash).build();
    public static final FontAwesome7IconType users_viewfinder_s = on(FontAwesome7Solid.users_viewfinder).build();
    public static final FontAwesome7IconType utensil_spoon_s = on(FontAwesome7Solid.utensil_spoon).build();
    public static final FontAwesome7IconType utensils_s = on(FontAwesome7Solid.utensils).build();
    public static final FontAwesome7IconType v_s = on(FontAwesome7Solid.v).build();
    public static final FontAwesome7IconType van_shuttle_s = on(FontAwesome7Solid.van_shuttle).build();
    public static final FontAwesome7IconType vault_s = on(FontAwesome7Solid.vault).build();
    public static final FontAwesome7IconType vcard_r = on(FontAwesome7Regular.vcard).build();
    public static final FontAwesome7IconType vcard_s = on(FontAwesome7Solid.vcard).build();
    public static final FontAwesome7IconType vector_polygon_s = on(FontAwesome7Solid.vector_polygon).build();
    public static final FontAwesome7IconType venus_double_s = on(FontAwesome7Solid.venus_double).build();
    public static final FontAwesome7IconType venus_mars_s = on(FontAwesome7Solid.venus_mars).build();
    public static final FontAwesome7IconType venus_s = on(FontAwesome7Solid.venus).build();
    public static final FontAwesome7IconType vest_patches_s = on(FontAwesome7Solid.vest_patches).build();
    public static final FontAwesome7IconType vest_s = on(FontAwesome7Solid.vest).build();
    public static final FontAwesome7IconType vial_circle_check_s = on(FontAwesome7Solid.vial_circle_check).build();
    public static final FontAwesome7IconType vial_s = on(FontAwesome7Solid.vial).build();
    public static final FontAwesome7IconType vial_virus_s = on(FontAwesome7Solid.vial_virus).build();
    public static final FontAwesome7IconType vials_s = on(FontAwesome7Solid.vials).build();
    public static final FontAwesome7IconType video_camera_s = on(FontAwesome7Solid.video_camera).build();
    public static final FontAwesome7IconType video_s = on(FontAwesome7Solid.video).build();
    public static final FontAwesome7IconType video_slash_s = on(FontAwesome7Solid.video_slash).build();
    public static final FontAwesome7IconType vihara_s = on(FontAwesome7Solid.vihara).build();
    public static final FontAwesome7IconType virus_covid_s = on(FontAwesome7Solid.virus_covid).build();
    public static final FontAwesome7IconType virus_covid_slash_s = on(FontAwesome7Solid.virus_covid_slash).build();
    public static final FontAwesome7IconType virus_s = on(FontAwesome7Solid.virus).build();
    public static final FontAwesome7IconType virus_slash_s = on(FontAwesome7Solid.virus_slash).build();
    public static final FontAwesome7IconType viruses_s = on(FontAwesome7Solid.viruses).build();
    public static final FontAwesome7IconType voicemail_s = on(FontAwesome7Solid.voicemail).build();
    public static final FontAwesome7IconType volcano_s = on(FontAwesome7Solid.volcano).build();
    public static final FontAwesome7IconType volleyball_ball_s = on(FontAwesome7Solid.volleyball_ball).build();
    public static final FontAwesome7IconType volleyball_s = on(FontAwesome7Solid.volleyball).build();
    public static final FontAwesome7IconType volume_control_phone_s = on(FontAwesome7Solid.volume_control_phone).build();
    public static final FontAwesome7IconType volume_down_s = on(FontAwesome7Solid.volume_down).build();
    public static final FontAwesome7IconType volume_high_s = on(FontAwesome7Solid.volume_high).build();
    public static final FontAwesome7IconType volume_low_s = on(FontAwesome7Solid.volume_low).build();
    public static final FontAwesome7IconType volume_mute_s = on(FontAwesome7Solid.volume_mute).build();
    public static final FontAwesome7IconType volume_off_s = on(FontAwesome7Solid.volume_off).build();
    public static final FontAwesome7IconType volume_times_s = on(FontAwesome7Solid.volume_times).build();
    public static final FontAwesome7IconType volume_up_s = on(FontAwesome7Solid.volume_up).build();
    public static final FontAwesome7IconType volume_xmark_s = on(FontAwesome7Solid.volume_xmark).build();
    public static final FontAwesome7IconType vote_yea_s = on(FontAwesome7Solid.vote_yea).build();
    public static final FontAwesome7IconType vr_cardboard_s = on(FontAwesome7Solid.vr_cardboard).build();
    public static final FontAwesome7IconType w_s = on(FontAwesome7Solid.w).build();
    public static final FontAwesome7IconType walkie_talkie_s = on(FontAwesome7Solid.walkie_talkie).build();
    public static final FontAwesome7IconType walking_s = on(FontAwesome7Solid.walking).build();
    public static final FontAwesome7IconType wallet_s = on(FontAwesome7Solid.wallet).build();
    public static final FontAwesome7IconType wand_magic_s = on(FontAwesome7Solid.wand_magic).build();
    public static final FontAwesome7IconType wand_magic_sparkles_s = on(FontAwesome7Solid.wand_magic_sparkles).build();
    public static final FontAwesome7IconType wand_sparkles_s = on(FontAwesome7Solid.wand_sparkles).build();
    public static final FontAwesome7IconType warehouse_s = on(FontAwesome7Solid.warehouse).build();
    public static final FontAwesome7IconType warning_s = on(FontAwesome7Solid.warning).build();
    public static final FontAwesome7IconType water_ladder_s = on(FontAwesome7Solid.water_ladder).build();
    public static final FontAwesome7IconType water_s = on(FontAwesome7Solid.water).build();
    public static final FontAwesome7IconType wave_square_s = on(FontAwesome7Solid.wave_square).build();
    public static final FontAwesome7IconType web_awesome_s = on(FontAwesome7Solid.web_awesome).build();
    public static final FontAwesome7IconType weight_hanging_s = on(FontAwesome7Solid.weight_hanging).build();
    public static final FontAwesome7IconType weight_s = on(FontAwesome7Solid.weight).build();
    public static final FontAwesome7IconType weight_scale_s = on(FontAwesome7Solid.weight_scale).build();
    public static final FontAwesome7IconType wheat_alt_s = on(FontAwesome7Solid.wheat_alt).build();
    public static final FontAwesome7IconType wheat_awn_circle_exclamation_s = on(FontAwesome7Solid.wheat_awn_circle_exclamation).build();
    public static final FontAwesome7IconType wheat_awn_s = on(FontAwesome7Solid.wheat_awn).build();
    public static final FontAwesome7IconType wheelchair_alt_s = on(FontAwesome7Solid.wheelchair_alt).build();
    public static final FontAwesome7IconType wheelchair_move_s = on(FontAwesome7Solid.wheelchair_move).build();
    public static final FontAwesome7IconType wheelchair_s = on(FontAwesome7Solid.wheelchair).build();
    public static final FontAwesome7IconType whiskey_glass_s = on(FontAwesome7Solid.whiskey_glass).build();
    public static final FontAwesome7IconType wifi_3_s = on(FontAwesome7Solid.wifi_3).build();
    public static final FontAwesome7IconType wifi_s = on(FontAwesome7Solid.wifi).build();
    public static final FontAwesome7IconType wifi_strong_s = on(FontAwesome7Solid.wifi_strong).build();
    public static final FontAwesome7IconType wind_s = on(FontAwesome7Solid.wind).build();
    public static final FontAwesome7IconType window_close_r = on(FontAwesome7Regular.window_close).build();
    public static final FontAwesome7IconType window_close_s = on(FontAwesome7Solid.window_close).build();
    public static final FontAwesome7IconType window_maximize_r = on(FontAwesome7Regular.window_maximize).build();
    public static final FontAwesome7IconType window_maximize_s = on(FontAwesome7Solid.window_maximize).build();
    public static final FontAwesome7IconType window_minimize_r = on(FontAwesome7Regular.window_minimize).build();
    public static final FontAwesome7IconType window_minimize_s = on(FontAwesome7Solid.window_minimize).build();
    public static final FontAwesome7IconType window_restore_r = on(FontAwesome7Regular.window_restore).build();
    public static final FontAwesome7IconType window_restore_s = on(FontAwesome7Solid.window_restore).build();
    public static final FontAwesome7IconType wine_bottle_s = on(FontAwesome7Solid.wine_bottle).build();
    public static final FontAwesome7IconType wine_glass_alt_s = on(FontAwesome7Solid.wine_glass_alt).build();
    public static final FontAwesome7IconType wine_glass_empty_s = on(FontAwesome7Solid.wine_glass_empty).build();
    public static final FontAwesome7IconType wine_glass_s = on(FontAwesome7Solid.wine_glass).build();
    public static final FontAwesome7IconType won_s = on(FontAwesome7Solid.won).build();
    public static final FontAwesome7IconType won_sign_s = on(FontAwesome7Solid.won_sign).build();
    public static final FontAwesome7IconType worm_s = on(FontAwesome7Solid.worm).build();
    public static final FontAwesome7IconType wrench_s = on(FontAwesome7Solid.wrench).build();
    public static final FontAwesome7IconType x_ray_s = on(FontAwesome7Solid.x_ray).build();
    public static final FontAwesome7IconType x_s = on(FontAwesome7Solid.x).build();
    public static final FontAwesome7IconType xmark_circle_r = on(FontAwesome7Regular.xmark_circle).build();
    public static final FontAwesome7IconType xmark_circle_s = on(FontAwesome7Solid.xmark_circle).build();
    public static final FontAwesome7IconType xmark_s = on(FontAwesome7Solid.xmark).build();
    public static final FontAwesome7IconType xmark_square_s = on(FontAwesome7Solid.xmark_square).build();
    public static final FontAwesome7IconType xmarks_lines_s = on(FontAwesome7Solid.xmarks_lines).build();
    public static final FontAwesome7IconType y_s = on(FontAwesome7Solid.y).build();
    public static final FontAwesome7IconType yen_s = on(FontAwesome7Solid.yen).build();
    public static final FontAwesome7IconType yen_sign_s = on(FontAwesome7Solid.yen_sign).build();
    public static final FontAwesome7IconType yin_yang_s = on(FontAwesome7Solid.yin_yang).build();
    public static final FontAwesome7IconType z_s = on(FontAwesome7Solid.z).build();
    public static final FontAwesome7IconType zap_s = on(FontAwesome7Solid.zap).build();

    // icon types of style 'brand'
    public static final FontAwesome7IconType _11ty = on(FontAwesome7Brand._11ty).build();
    public static final FontAwesome7IconType _42_group = on(FontAwesome7Brand._42_group).build();
    public static final FontAwesome7IconType _500px = on(FontAwesome7Brand._500px).build();
    public static final FontAwesome7IconType accessible_icon = on(FontAwesome7Brand.accessible_icon).build();
    public static final FontAwesome7IconType accusoft = on(FontAwesome7Brand.accusoft).build();
    public static final FontAwesome7IconType adn = on(FontAwesome7Brand.adn).build();
    public static final FontAwesome7IconType adversal = on(FontAwesome7Brand.adversal).build();
    public static final FontAwesome7IconType affiliatetheme = on(FontAwesome7Brand.affiliatetheme).build();
    public static final FontAwesome7IconType airbnb = on(FontAwesome7Brand.airbnb).build();
    public static final FontAwesome7IconType algolia = on(FontAwesome7Brand.algolia).build();
    public static final FontAwesome7IconType alipay = on(FontAwesome7Brand.alipay).build();
    public static final FontAwesome7IconType amazon = on(FontAwesome7Brand.amazon).build();
    public static final FontAwesome7IconType amazon_pay = on(FontAwesome7Brand.amazon_pay).build();
    public static final FontAwesome7IconType amilia = on(FontAwesome7Brand.amilia).build();
    public static final FontAwesome7IconType android = on(FontAwesome7Brand.android).build();
    public static final FontAwesome7IconType angellist = on(FontAwesome7Brand.angellist).build();
    public static final FontAwesome7IconType angrycreative = on(FontAwesome7Brand.angrycreative).build();
    public static final FontAwesome7IconType angular = on(FontAwesome7Brand.angular).build();
    public static final FontAwesome7IconType app_store = on(FontAwesome7Brand.app_store).build();
    public static final FontAwesome7IconType app_store_ios = on(FontAwesome7Brand.app_store_ios).build();
    public static final FontAwesome7IconType apper = on(FontAwesome7Brand.apper).build();
    public static final FontAwesome7IconType apple = on(FontAwesome7Brand.apple).build();
    public static final FontAwesome7IconType apple_pay = on(FontAwesome7Brand.apple_pay).build();
    public static final FontAwesome7IconType artstation = on(FontAwesome7Brand.artstation).build();
    public static final FontAwesome7IconType asymmetrik = on(FontAwesome7Brand.asymmetrik).build();
    public static final FontAwesome7IconType atlassian = on(FontAwesome7Brand.atlassian).build();
    public static final FontAwesome7IconType audible = on(FontAwesome7Brand.audible).build();
    public static final FontAwesome7IconType autoprefixer = on(FontAwesome7Brand.autoprefixer).build();
    public static final FontAwesome7IconType avianex = on(FontAwesome7Brand.avianex).build();
    public static final FontAwesome7IconType aviato = on(FontAwesome7Brand.aviato).build();
    public static final FontAwesome7IconType aws = on(FontAwesome7Brand.aws).build();
    public static final FontAwesome7IconType bandcamp = on(FontAwesome7Brand.bandcamp).build();
    public static final FontAwesome7IconType battle_net = on(FontAwesome7Brand.battle_net).build();
    public static final FontAwesome7IconType behance = on(FontAwesome7Brand.behance).build();
    public static final FontAwesome7IconType behance_square = on(FontAwesome7Brand.behance_square).build();
    public static final FontAwesome7IconType bilibili = on(FontAwesome7Brand.bilibili).build();
    public static final FontAwesome7IconType bimobject = on(FontAwesome7Brand.bimobject).build();
    public static final FontAwesome7IconType bitbucket = on(FontAwesome7Brand.bitbucket).build();
    public static final FontAwesome7IconType bitcoin = on(FontAwesome7Brand.bitcoin).build();
    public static final FontAwesome7IconType bity = on(FontAwesome7Brand.bity).build();
    public static final FontAwesome7IconType black_tie = on(FontAwesome7Brand.black_tie).build();
    public static final FontAwesome7IconType blackberry = on(FontAwesome7Brand.blackberry).build();
    public static final FontAwesome7IconType blogger = on(FontAwesome7Brand.blogger).build();
    public static final FontAwesome7IconType blogger_b = on(FontAwesome7Brand.blogger_b).build();
    public static final FontAwesome7IconType bluesky = on(FontAwesome7Brand.bluesky).build();
    public static final FontAwesome7IconType bluetooth = on(FontAwesome7Brand.bluetooth).build();
    public static final FontAwesome7IconType bluetooth_b = on(FontAwesome7Brand.bluetooth_b).build();
    public static final FontAwesome7IconType bootstrap = on(FontAwesome7Brand.bootstrap).build();
    public static final FontAwesome7IconType bots = on(FontAwesome7Brand.bots).build();
    public static final FontAwesome7IconType brave = on(FontAwesome7Brand.brave).build();
    public static final FontAwesome7IconType brave_reverse = on(FontAwesome7Brand.brave_reverse).build();
    public static final FontAwesome7IconType btc = on(FontAwesome7Brand.btc).build();
    public static final FontAwesome7IconType buffer = on(FontAwesome7Brand.buffer).build();
    public static final FontAwesome7IconType buromobelexperte = on(FontAwesome7Brand.buromobelexperte).build();
    public static final FontAwesome7IconType buy_n_large = on(FontAwesome7Brand.buy_n_large).build();
    public static final FontAwesome7IconType buysellads = on(FontAwesome7Brand.buysellads).build();
    public static final FontAwesome7IconType canadian_maple_leaf = on(FontAwesome7Brand.canadian_maple_leaf).build();
    public static final FontAwesome7IconType cash_app = on(FontAwesome7Brand.cash_app).build();
    public static final FontAwesome7IconType cc_amazon_pay = on(FontAwesome7Brand.cc_amazon_pay).build();
    public static final FontAwesome7IconType cc_amex = on(FontAwesome7Brand.cc_amex).build();
    public static final FontAwesome7IconType cc_apple_pay = on(FontAwesome7Brand.cc_apple_pay).build();
    public static final FontAwesome7IconType cc_diners_club = on(FontAwesome7Brand.cc_diners_club).build();
    public static final FontAwesome7IconType cc_discover = on(FontAwesome7Brand.cc_discover).build();
    public static final FontAwesome7IconType cc_jcb = on(FontAwesome7Brand.cc_jcb).build();
    public static final FontAwesome7IconType cc_mastercard = on(FontAwesome7Brand.cc_mastercard).build();
    public static final FontAwesome7IconType cc_paypal = on(FontAwesome7Brand.cc_paypal).build();
    public static final FontAwesome7IconType cc_stripe = on(FontAwesome7Brand.cc_stripe).build();
    public static final FontAwesome7IconType cc_visa = on(FontAwesome7Brand.cc_visa).build();
    public static final FontAwesome7IconType centercode = on(FontAwesome7Brand.centercode).build();
    public static final FontAwesome7IconType centos = on(FontAwesome7Brand.centos).build();
    public static final FontAwesome7IconType chrome = on(FontAwesome7Brand.chrome).build();
    public static final FontAwesome7IconType chromecast = on(FontAwesome7Brand.chromecast).build();
    public static final FontAwesome7IconType cloudflare = on(FontAwesome7Brand.cloudflare).build();
    public static final FontAwesome7IconType cloudscale = on(FontAwesome7Brand.cloudscale).build();
    public static final FontAwesome7IconType cloudsmith = on(FontAwesome7Brand.cloudsmith).build();
    public static final FontAwesome7IconType cloudversify = on(FontAwesome7Brand.cloudversify).build();
    public static final FontAwesome7IconType cmplid = on(FontAwesome7Brand.cmplid).build();
    public static final FontAwesome7IconType codepen = on(FontAwesome7Brand.codepen).build();
    public static final FontAwesome7IconType codiepie = on(FontAwesome7Brand.codiepie).build();
    public static final FontAwesome7IconType confluence = on(FontAwesome7Brand.confluence).build();
    public static final FontAwesome7IconType connectdevelop = on(FontAwesome7Brand.connectdevelop).build();
    public static final FontAwesome7IconType contao = on(FontAwesome7Brand.contao).build();
    public static final FontAwesome7IconType cotton_bureau = on(FontAwesome7Brand.cotton_bureau).build();
    public static final FontAwesome7IconType cpanel = on(FontAwesome7Brand.cpanel).build();
    public static final FontAwesome7IconType creative_commons = on(FontAwesome7Brand.creative_commons).build();
    public static final FontAwesome7IconType creative_commons_by = on(FontAwesome7Brand.creative_commons_by).build();
    public static final FontAwesome7IconType creative_commons_nc = on(FontAwesome7Brand.creative_commons_nc).build();
    public static final FontAwesome7IconType creative_commons_nc_eu = on(FontAwesome7Brand.creative_commons_nc_eu).build();
    public static final FontAwesome7IconType creative_commons_nc_jp = on(FontAwesome7Brand.creative_commons_nc_jp).build();
    public static final FontAwesome7IconType creative_commons_nd = on(FontAwesome7Brand.creative_commons_nd).build();
    public static final FontAwesome7IconType creative_commons_pd = on(FontAwesome7Brand.creative_commons_pd).build();
    public static final FontAwesome7IconType creative_commons_pd_alt = on(FontAwesome7Brand.creative_commons_pd_alt).build();
    public static final FontAwesome7IconType creative_commons_remix = on(FontAwesome7Brand.creative_commons_remix).build();
    public static final FontAwesome7IconType creative_commons_sa = on(FontAwesome7Brand.creative_commons_sa).build();
    public static final FontAwesome7IconType creative_commons_sampling = on(FontAwesome7Brand.creative_commons_sampling).build();
    public static final FontAwesome7IconType creative_commons_sampling_plus = on(FontAwesome7Brand.creative_commons_sampling_plus).build();
    public static final FontAwesome7IconType creative_commons_share = on(FontAwesome7Brand.creative_commons_share).build();
    public static final FontAwesome7IconType creative_commons_zero = on(FontAwesome7Brand.creative_commons_zero).build();
    public static final FontAwesome7IconType critical_role = on(FontAwesome7Brand.critical_role).build();
    public static final FontAwesome7IconType css = on(FontAwesome7Brand.css).build();
    public static final FontAwesome7IconType css3 = on(FontAwesome7Brand.css3).build();
    public static final FontAwesome7IconType css3_alt = on(FontAwesome7Brand.css3_alt).build();
    public static final FontAwesome7IconType cuttlefish = on(FontAwesome7Brand.cuttlefish).build();
    public static final FontAwesome7IconType d_and_d = on(FontAwesome7Brand.d_and_d).build();
    public static final FontAwesome7IconType d_and_d_beyond = on(FontAwesome7Brand.d_and_d_beyond).build();
    public static final FontAwesome7IconType dailymotion = on(FontAwesome7Brand.dailymotion).build();
    public static final FontAwesome7IconType dart_lang = on(FontAwesome7Brand.dart_lang).build();
    public static final FontAwesome7IconType dashcube = on(FontAwesome7Brand.dashcube).build();
    public static final FontAwesome7IconType debian = on(FontAwesome7Brand.debian).build();
    public static final FontAwesome7IconType deezer = on(FontAwesome7Brand.deezer).build();
    public static final FontAwesome7IconType delicious = on(FontAwesome7Brand.delicious).build();
    public static final FontAwesome7IconType deploydog = on(FontAwesome7Brand.deploydog).build();
    public static final FontAwesome7IconType deskpro = on(FontAwesome7Brand.deskpro).build();
    public static final FontAwesome7IconType dev = on(FontAwesome7Brand.dev).build();
    public static final FontAwesome7IconType deviantart = on(FontAwesome7Brand.deviantart).build();
    public static final FontAwesome7IconType dhl = on(FontAwesome7Brand.dhl).build();
    public static final FontAwesome7IconType diaspora = on(FontAwesome7Brand.diaspora).build();
    public static final FontAwesome7IconType digg = on(FontAwesome7Brand.digg).build();
    public static final FontAwesome7IconType digital_ocean = on(FontAwesome7Brand.digital_ocean).build();
    public static final FontAwesome7IconType discord = on(FontAwesome7Brand.discord).build();
    public static final FontAwesome7IconType discourse = on(FontAwesome7Brand.discourse).build();
    public static final FontAwesome7IconType disqus = on(FontAwesome7Brand.disqus).build();
    public static final FontAwesome7IconType dochub = on(FontAwesome7Brand.dochub).build();
    public static final FontAwesome7IconType docker = on(FontAwesome7Brand.docker).build();
    public static final FontAwesome7IconType draft2digital = on(FontAwesome7Brand.draft2digital).build();
    public static final FontAwesome7IconType dribbble = on(FontAwesome7Brand.dribbble).build();
    public static final FontAwesome7IconType dribbble_square = on(FontAwesome7Brand.dribbble_square).build();
    public static final FontAwesome7IconType dropbox = on(FontAwesome7Brand.dropbox).build();
    public static final FontAwesome7IconType drupal = on(FontAwesome7Brand.drupal).build();
    public static final FontAwesome7IconType duolingo = on(FontAwesome7Brand.duolingo).build();
    public static final FontAwesome7IconType dyalog = on(FontAwesome7Brand.dyalog).build();
    public static final FontAwesome7IconType earlybirds = on(FontAwesome7Brand.earlybirds).build();
    public static final FontAwesome7IconType ebay = on(FontAwesome7Brand.ebay).build();
    public static final FontAwesome7IconType edge = on(FontAwesome7Brand.edge).build();
    public static final FontAwesome7IconType edge_legacy = on(FontAwesome7Brand.edge_legacy).build();
    public static final FontAwesome7IconType elementor = on(FontAwesome7Brand.elementor).build();
    public static final FontAwesome7IconType eleventy = on(FontAwesome7Brand.eleventy).build();
    public static final FontAwesome7IconType ello = on(FontAwesome7Brand.ello).build();
    public static final FontAwesome7IconType ember = on(FontAwesome7Brand.ember).build();
    public static final FontAwesome7IconType empire = on(FontAwesome7Brand.empire).build();
    public static final FontAwesome7IconType envira = on(FontAwesome7Brand.envira).build();
    public static final FontAwesome7IconType erlang = on(FontAwesome7Brand.erlang).build();
    public static final FontAwesome7IconType ethereum = on(FontAwesome7Brand.ethereum).build();
    public static final FontAwesome7IconType etsy = on(FontAwesome7Brand.etsy).build();
    public static final FontAwesome7IconType evernote = on(FontAwesome7Brand.evernote).build();
    public static final FontAwesome7IconType expeditedssl = on(FontAwesome7Brand.expeditedssl).build();
    public static final FontAwesome7IconType facebook = on(FontAwesome7Brand.facebook).build();
    public static final FontAwesome7IconType facebook_f = on(FontAwesome7Brand.facebook_f).build();
    public static final FontAwesome7IconType facebook_messenger = on(FontAwesome7Brand.facebook_messenger).build();
    public static final FontAwesome7IconType facebook_square = on(FontAwesome7Brand.facebook_square).build();
    public static final FontAwesome7IconType fantasy_flight_games = on(FontAwesome7Brand.fantasy_flight_games).build();
    public static final FontAwesome7IconType fedex = on(FontAwesome7Brand.fedex).build();
    public static final FontAwesome7IconType fedora = on(FontAwesome7Brand.fedora).build();
    public static final FontAwesome7IconType figma = on(FontAwesome7Brand.figma).build();
    public static final FontAwesome7IconType files_pinwheel = on(FontAwesome7Brand.files_pinwheel).build();
    public static final FontAwesome7IconType firefox = on(FontAwesome7Brand.firefox).build();
    public static final FontAwesome7IconType firefox_browser = on(FontAwesome7Brand.firefox_browser).build();
    public static final FontAwesome7IconType first_order = on(FontAwesome7Brand.first_order).build();
    public static final FontAwesome7IconType first_order_alt = on(FontAwesome7Brand.first_order_alt).build();
    public static final FontAwesome7IconType firstdraft = on(FontAwesome7Brand.firstdraft).build();
    public static final FontAwesome7IconType flickr = on(FontAwesome7Brand.flickr).build();
    public static final FontAwesome7IconType flipboard = on(FontAwesome7Brand.flipboard).build();
    public static final FontAwesome7IconType flutter = on(FontAwesome7Brand.flutter).build();
    public static final FontAwesome7IconType fly = on(FontAwesome7Brand.fly).build();
    public static final FontAwesome7IconType font_awesome = on(FontAwesome7Brand.font_awesome).build();
    public static final FontAwesome7IconType font_awesome_alt = on(FontAwesome7Brand.font_awesome_alt).build();
    public static final FontAwesome7IconType font_awesome_flag = on(FontAwesome7Brand.font_awesome_flag).build();
    public static final FontAwesome7IconType font_awesome_logo_full = on(FontAwesome7Brand.font_awesome_logo_full).build();
    public static final FontAwesome7IconType fonticons = on(FontAwesome7Brand.fonticons).build();
    public static final FontAwesome7IconType fonticons_fi = on(FontAwesome7Brand.fonticons_fi).build();
    public static final FontAwesome7IconType fort_awesome = on(FontAwesome7Brand.fort_awesome).build();
    public static final FontAwesome7IconType fort_awesome_alt = on(FontAwesome7Brand.fort_awesome_alt).build();
    public static final FontAwesome7IconType forumbee = on(FontAwesome7Brand.forumbee).build();
    public static final FontAwesome7IconType foursquare = on(FontAwesome7Brand.foursquare).build();
    public static final FontAwesome7IconType free_code_camp = on(FontAwesome7Brand.free_code_camp).build();
    public static final FontAwesome7IconType freebsd = on(FontAwesome7Brand.freebsd).build();
    public static final FontAwesome7IconType fulcrum = on(FontAwesome7Brand.fulcrum).build();
    public static final FontAwesome7IconType galactic_republic = on(FontAwesome7Brand.galactic_republic).build();
    public static final FontAwesome7IconType galactic_senate = on(FontAwesome7Brand.galactic_senate).build();
    public static final FontAwesome7IconType get_pocket = on(FontAwesome7Brand.get_pocket).build();
    public static final FontAwesome7IconType gg = on(FontAwesome7Brand.gg).build();
    public static final FontAwesome7IconType gg_circle = on(FontAwesome7Brand.gg_circle).build();
    public static final FontAwesome7IconType git = on(FontAwesome7Brand.git).build();
    public static final FontAwesome7IconType git_alt = on(FontAwesome7Brand.git_alt).build();
    public static final FontAwesome7IconType git_square = on(FontAwesome7Brand.git_square).build();
    public static final FontAwesome7IconType github = on(FontAwesome7Brand.github).build();
    public static final FontAwesome7IconType github_alt = on(FontAwesome7Brand.github_alt).build();
    public static final FontAwesome7IconType github_square = on(FontAwesome7Brand.github_square).build();
    public static final FontAwesome7IconType gitkraken = on(FontAwesome7Brand.gitkraken).build();
    public static final FontAwesome7IconType gitlab = on(FontAwesome7Brand.gitlab).build();
    public static final FontAwesome7IconType gitlab_square = on(FontAwesome7Brand.gitlab_square).build();
    public static final FontAwesome7IconType gitter = on(FontAwesome7Brand.gitter).build();
    public static final FontAwesome7IconType glide = on(FontAwesome7Brand.glide).build();
    public static final FontAwesome7IconType glide_g = on(FontAwesome7Brand.glide_g).build();
    public static final FontAwesome7IconType gofore = on(FontAwesome7Brand.gofore).build();
    public static final FontAwesome7IconType golang = on(FontAwesome7Brand.golang).build();
    public static final FontAwesome7IconType goodreads = on(FontAwesome7Brand.goodreads).build();
    public static final FontAwesome7IconType goodreads_g = on(FontAwesome7Brand.goodreads_g).build();
    public static final FontAwesome7IconType google = on(FontAwesome7Brand.google).build();
    public static final FontAwesome7IconType google_drive = on(FontAwesome7Brand.google_drive).build();
    public static final FontAwesome7IconType google_pay = on(FontAwesome7Brand.google_pay).build();
    public static final FontAwesome7IconType google_play = on(FontAwesome7Brand.google_play).build();
    public static final FontAwesome7IconType google_plus = on(FontAwesome7Brand.google_plus).build();
    public static final FontAwesome7IconType google_plus_g = on(FontAwesome7Brand.google_plus_g).build();
    public static final FontAwesome7IconType google_plus_square = on(FontAwesome7Brand.google_plus_square).build();
    public static final FontAwesome7IconType google_scholar = on(FontAwesome7Brand.google_scholar).build();
    public static final FontAwesome7IconType google_wallet = on(FontAwesome7Brand.google_wallet).build();
    public static final FontAwesome7IconType gratipay = on(FontAwesome7Brand.gratipay).build();
    public static final FontAwesome7IconType grav = on(FontAwesome7Brand.grav).build();
    public static final FontAwesome7IconType gripfire = on(FontAwesome7Brand.gripfire).build();
    public static final FontAwesome7IconType grunt = on(FontAwesome7Brand.grunt).build();
    public static final FontAwesome7IconType guilded = on(FontAwesome7Brand.guilded).build();
    public static final FontAwesome7IconType gulp = on(FontAwesome7Brand.gulp).build();
    public static final FontAwesome7IconType hacker_news = on(FontAwesome7Brand.hacker_news).build();
    public static final FontAwesome7IconType hacker_news_square = on(FontAwesome7Brand.hacker_news_square).build();
    public static final FontAwesome7IconType hackerrank = on(FontAwesome7Brand.hackerrank).build();
    public static final FontAwesome7IconType hashnode = on(FontAwesome7Brand.hashnode).build();
    public static final FontAwesome7IconType hips = on(FontAwesome7Brand.hips).build();
    public static final FontAwesome7IconType hire_a_helper = on(FontAwesome7Brand.hire_a_helper).build();
    public static final FontAwesome7IconType hive = on(FontAwesome7Brand.hive).build();
    public static final FontAwesome7IconType hooli = on(FontAwesome7Brand.hooli).build();
    public static final FontAwesome7IconType hornbill = on(FontAwesome7Brand.hornbill).build();
    public static final FontAwesome7IconType hotjar = on(FontAwesome7Brand.hotjar).build();
    public static final FontAwesome7IconType houzz = on(FontAwesome7Brand.houzz).build();
    public static final FontAwesome7IconType html5 = on(FontAwesome7Brand.html5).build();
    public static final FontAwesome7IconType hubspot = on(FontAwesome7Brand.hubspot).build();
    public static final FontAwesome7IconType ideal = on(FontAwesome7Brand.ideal).build();
    public static final FontAwesome7IconType imdb = on(FontAwesome7Brand.imdb).build();
    public static final FontAwesome7IconType innosoft = on(FontAwesome7Brand.innosoft).build();
    public static final FontAwesome7IconType instagram = on(FontAwesome7Brand.instagram).build();
    public static final FontAwesome7IconType instagram_square = on(FontAwesome7Brand.instagram_square).build();
    public static final FontAwesome7IconType instalod = on(FontAwesome7Brand.instalod).build();
    public static final FontAwesome7IconType intercom = on(FontAwesome7Brand.intercom).build();
    public static final FontAwesome7IconType internet_explorer = on(FontAwesome7Brand.internet_explorer).build();
    public static final FontAwesome7IconType invision = on(FontAwesome7Brand.invision).build();
    public static final FontAwesome7IconType ioxhost = on(FontAwesome7Brand.ioxhost).build();
    public static final FontAwesome7IconType itch_io = on(FontAwesome7Brand.itch_io).build();
    public static final FontAwesome7IconType itunes = on(FontAwesome7Brand.itunes).build();
    public static final FontAwesome7IconType itunes_note = on(FontAwesome7Brand.itunes_note).build();
    public static final FontAwesome7IconType java = on(FontAwesome7Brand.java).build();
    public static final FontAwesome7IconType jedi_order = on(FontAwesome7Brand.jedi_order).build();
    public static final FontAwesome7IconType jenkins = on(FontAwesome7Brand.jenkins).build();
    public static final FontAwesome7IconType jira = on(FontAwesome7Brand.jira).build();
    public static final FontAwesome7IconType joget = on(FontAwesome7Brand.joget).build();
    public static final FontAwesome7IconType joomla = on(FontAwesome7Brand.joomla).build();
    public static final FontAwesome7IconType js = on(FontAwesome7Brand.js).build();
    public static final FontAwesome7IconType js_square = on(FontAwesome7Brand.js_square).build();
    public static final FontAwesome7IconType jsfiddle = on(FontAwesome7Brand.jsfiddle).build();
    public static final FontAwesome7IconType jxl = on(FontAwesome7Brand.jxl).build();
    public static final FontAwesome7IconType kaggle = on(FontAwesome7Brand.kaggle).build();
    public static final FontAwesome7IconType kakao_talk = on(FontAwesome7Brand.kakao_talk).build();
    public static final FontAwesome7IconType keybase = on(FontAwesome7Brand.keybase).build();
    public static final FontAwesome7IconType keycdn = on(FontAwesome7Brand.keycdn).build();
    public static final FontAwesome7IconType kickstarter = on(FontAwesome7Brand.kickstarter).build();
    public static final FontAwesome7IconType kickstarter_k = on(FontAwesome7Brand.kickstarter_k).build();
    public static final FontAwesome7IconType korvue = on(FontAwesome7Brand.korvue).build();
    public static final FontAwesome7IconType laravel = on(FontAwesome7Brand.laravel).build();
    public static final FontAwesome7IconType lastfm = on(FontAwesome7Brand.lastfm).build();
    public static final FontAwesome7IconType lastfm_square = on(FontAwesome7Brand.lastfm_square).build();
    public static final FontAwesome7IconType leanpub = on(FontAwesome7Brand.leanpub).build();
    public static final FontAwesome7IconType less = on(FontAwesome7Brand.less).build();
    public static final FontAwesome7IconType letterboxd = on(FontAwesome7Brand.letterboxd).build();
    public static final FontAwesome7IconType line = on(FontAwesome7Brand.line).build();
    public static final FontAwesome7IconType linkedin = on(FontAwesome7Brand.linkedin).build();
    public static final FontAwesome7IconType linkedin_in = on(FontAwesome7Brand.linkedin_in).build();
    public static final FontAwesome7IconType linktree = on(FontAwesome7Brand.linktree).build();
    public static final FontAwesome7IconType linode = on(FontAwesome7Brand.linode).build();
    public static final FontAwesome7IconType linux = on(FontAwesome7Brand.linux).build();
    public static final FontAwesome7IconType lumon = on(FontAwesome7Brand.lumon).build();
    public static final FontAwesome7IconType lumon_drop = on(FontAwesome7Brand.lumon_drop).build();
    public static final FontAwesome7IconType lyft = on(FontAwesome7Brand.lyft).build();
    public static final FontAwesome7IconType magento = on(FontAwesome7Brand.magento).build();
    public static final FontAwesome7IconType mailchimp = on(FontAwesome7Brand.mailchimp).build();
    public static final FontAwesome7IconType mandalorian = on(FontAwesome7Brand.mandalorian).build();
    public static final FontAwesome7IconType markdown = on(FontAwesome7Brand.markdown).build();
    public static final FontAwesome7IconType mastodon = on(FontAwesome7Brand.mastodon).build();
    public static final FontAwesome7IconType maxcdn = on(FontAwesome7Brand.maxcdn).build();
    public static final FontAwesome7IconType mdb = on(FontAwesome7Brand.mdb).build();
    public static final FontAwesome7IconType medapps = on(FontAwesome7Brand.medapps).build();
    public static final FontAwesome7IconType medium = on(FontAwesome7Brand.medium).build();
    public static final FontAwesome7IconType medium_m = on(FontAwesome7Brand.medium_m).build();
    public static final FontAwesome7IconType medrt = on(FontAwesome7Brand.medrt).build();
    public static final FontAwesome7IconType meetup = on(FontAwesome7Brand.meetup).build();
    public static final FontAwesome7IconType megaport = on(FontAwesome7Brand.megaport).build();
    public static final FontAwesome7IconType mendeley = on(FontAwesome7Brand.mendeley).build();
    public static final FontAwesome7IconType meta = on(FontAwesome7Brand.meta).build();
    public static final FontAwesome7IconType microblog = on(FontAwesome7Brand.microblog).build();
    public static final FontAwesome7IconType microsoft = on(FontAwesome7Brand.microsoft).build();
    public static final FontAwesome7IconType mintbit = on(FontAwesome7Brand.mintbit).build();
    public static final FontAwesome7IconType mix = on(FontAwesome7Brand.mix).build();
    public static final FontAwesome7IconType mixcloud = on(FontAwesome7Brand.mixcloud).build();
    public static final FontAwesome7IconType mixer = on(FontAwesome7Brand.mixer).build();
    public static final FontAwesome7IconType mizuni = on(FontAwesome7Brand.mizuni).build();
    public static final FontAwesome7IconType modx = on(FontAwesome7Brand.modx).build();
    public static final FontAwesome7IconType monero = on(FontAwesome7Brand.monero).build();
    public static final FontAwesome7IconType napster = on(FontAwesome7Brand.napster).build();
    public static final FontAwesome7IconType neos = on(FontAwesome7Brand.neos).build();
    public static final FontAwesome7IconType nfc_directional = on(FontAwesome7Brand.nfc_directional).build();
    public static final FontAwesome7IconType nfc_symbol = on(FontAwesome7Brand.nfc_symbol).build();
    public static final FontAwesome7IconType nimblr = on(FontAwesome7Brand.nimblr).build();
    public static final FontAwesome7IconType node = on(FontAwesome7Brand.node).build();
    public static final FontAwesome7IconType node_js = on(FontAwesome7Brand.node_js).build();
    public static final FontAwesome7IconType notion = on(FontAwesome7Brand.notion).build();
    public static final FontAwesome7IconType npm = on(FontAwesome7Brand.npm).build();
    public static final FontAwesome7IconType ns8 = on(FontAwesome7Brand.ns8).build();
    public static final FontAwesome7IconType nutritionix = on(FontAwesome7Brand.nutritionix).build();
    public static final FontAwesome7IconType octopus_deploy = on(FontAwesome7Brand.octopus_deploy).build();
    public static final FontAwesome7IconType odnoklassniki = on(FontAwesome7Brand.odnoklassniki).build();
    public static final FontAwesome7IconType odnoklassniki_square = on(FontAwesome7Brand.odnoklassniki_square).build();
    public static final FontAwesome7IconType odysee = on(FontAwesome7Brand.odysee).build();
    public static final FontAwesome7IconType old_republic = on(FontAwesome7Brand.old_republic).build();
    public static final FontAwesome7IconType openai = on(FontAwesome7Brand.openai).build();
    public static final FontAwesome7IconType opencart = on(FontAwesome7Brand.opencart).build();
    public static final FontAwesome7IconType openid = on(FontAwesome7Brand.openid).build();
    public static final FontAwesome7IconType opensuse = on(FontAwesome7Brand.opensuse).build();
    public static final FontAwesome7IconType opera = on(FontAwesome7Brand.opera).build();
    public static final FontAwesome7IconType optin_monster = on(FontAwesome7Brand.optin_monster).build();
    public static final FontAwesome7IconType orcid = on(FontAwesome7Brand.orcid).build();
    public static final FontAwesome7IconType osi = on(FontAwesome7Brand.osi).build();
    public static final FontAwesome7IconType padlet = on(FontAwesome7Brand.padlet).build();
    public static final FontAwesome7IconType page4 = on(FontAwesome7Brand.page4).build();
    public static final FontAwesome7IconType pagelines = on(FontAwesome7Brand.pagelines).build();
    public static final FontAwesome7IconType palfed = on(FontAwesome7Brand.palfed).build();
    public static final FontAwesome7IconType pandora = on(FontAwesome7Brand.pandora).build();
    public static final FontAwesome7IconType patreon = on(FontAwesome7Brand.patreon).build();
    public static final FontAwesome7IconType paypal = on(FontAwesome7Brand.paypal).build();
    public static final FontAwesome7IconType perbyte = on(FontAwesome7Brand.perbyte).build();
    public static final FontAwesome7IconType periscope = on(FontAwesome7Brand.periscope).build();
    public static final FontAwesome7IconType phabricator = on(FontAwesome7Brand.phabricator).build();
    public static final FontAwesome7IconType phoenix_framework = on(FontAwesome7Brand.phoenix_framework).build();
    public static final FontAwesome7IconType phoenix_squadron = on(FontAwesome7Brand.phoenix_squadron).build();
    public static final FontAwesome7IconType php = on(FontAwesome7Brand.php).build();
    public static final FontAwesome7IconType pied_piper = on(FontAwesome7Brand.pied_piper).build();
    public static final FontAwesome7IconType pied_piper_alt = on(FontAwesome7Brand.pied_piper_alt).build();
    public static final FontAwesome7IconType pied_piper_hat = on(FontAwesome7Brand.pied_piper_hat).build();
    public static final FontAwesome7IconType pied_piper_pp = on(FontAwesome7Brand.pied_piper_pp).build();
    public static final FontAwesome7IconType pied_piper_square = on(FontAwesome7Brand.pied_piper_square).build();
    public static final FontAwesome7IconType pinterest = on(FontAwesome7Brand.pinterest).build();
    public static final FontAwesome7IconType pinterest_p = on(FontAwesome7Brand.pinterest_p).build();
    public static final FontAwesome7IconType pinterest_square = on(FontAwesome7Brand.pinterest_square).build();
    public static final FontAwesome7IconType pix = on(FontAwesome7Brand.pix).build();
    public static final FontAwesome7IconType pixelfed = on(FontAwesome7Brand.pixelfed).build();
    public static final FontAwesome7IconType pixiv = on(FontAwesome7Brand.pixiv).build();
    public static final FontAwesome7IconType playstation = on(FontAwesome7Brand.playstation).build();
    public static final FontAwesome7IconType product_hunt = on(FontAwesome7Brand.product_hunt).build();
    public static final FontAwesome7IconType pushed = on(FontAwesome7Brand.pushed).build();
    public static final FontAwesome7IconType python = on(FontAwesome7Brand.python).build();
    public static final FontAwesome7IconType qq = on(FontAwesome7Brand.qq).build();
    public static final FontAwesome7IconType quinscape = on(FontAwesome7Brand.quinscape).build();
    public static final FontAwesome7IconType quora = on(FontAwesome7Brand.quora).build();
    public static final FontAwesome7IconType r_project = on(FontAwesome7Brand.r_project).build();
    public static final FontAwesome7IconType raspberry_pi = on(FontAwesome7Brand.raspberry_pi).build();
    public static final FontAwesome7IconType ravelry = on(FontAwesome7Brand.ravelry).build();
    public static final FontAwesome7IconType react = on(FontAwesome7Brand.react).build();
    public static final FontAwesome7IconType reacteurope = on(FontAwesome7Brand.reacteurope).build();
    public static final FontAwesome7IconType readme = on(FontAwesome7Brand.readme).build();
    public static final FontAwesome7IconType rebel = on(FontAwesome7Brand.rebel).build();
    public static final FontAwesome7IconType red_river = on(FontAwesome7Brand.red_river).build();
    public static final FontAwesome7IconType reddit = on(FontAwesome7Brand.reddit).build();
    public static final FontAwesome7IconType reddit_alien = on(FontAwesome7Brand.reddit_alien).build();
    public static final FontAwesome7IconType reddit_square = on(FontAwesome7Brand.reddit_square).build();
    public static final FontAwesome7IconType redhat = on(FontAwesome7Brand.redhat).build();
    public static final FontAwesome7IconType rendact = on(FontAwesome7Brand.rendact).build();
    public static final FontAwesome7IconType renren = on(FontAwesome7Brand.renren).build();
    public static final FontAwesome7IconType replyd = on(FontAwesome7Brand.replyd).build();
    public static final FontAwesome7IconType researchgate = on(FontAwesome7Brand.researchgate).build();
    public static final FontAwesome7IconType resolving = on(FontAwesome7Brand.resolving).build();
    public static final FontAwesome7IconType rev = on(FontAwesome7Brand.rev).build();
    public static final FontAwesome7IconType rocketchat = on(FontAwesome7Brand.rocketchat).build();
    public static final FontAwesome7IconType rockrms = on(FontAwesome7Brand.rockrms).build();
    public static final FontAwesome7IconType rust = on(FontAwesome7Brand.rust).build();
    public static final FontAwesome7IconType safari = on(FontAwesome7Brand.safari).build();
    public static final FontAwesome7IconType salesforce = on(FontAwesome7Brand.salesforce).build();
    public static final FontAwesome7IconType sass = on(FontAwesome7Brand.sass).build();
    public static final FontAwesome7IconType schlix = on(FontAwesome7Brand.schlix).build();
    public static final FontAwesome7IconType screenpal = on(FontAwesome7Brand.screenpal).build();
    public static final FontAwesome7IconType scribd = on(FontAwesome7Brand.scribd).build();
    public static final FontAwesome7IconType searchengin = on(FontAwesome7Brand.searchengin).build();
    public static final FontAwesome7IconType sellcast = on(FontAwesome7Brand.sellcast).build();
    public static final FontAwesome7IconType sellsy = on(FontAwesome7Brand.sellsy).build();
    public static final FontAwesome7IconType servicestack = on(FontAwesome7Brand.servicestack).build();
    public static final FontAwesome7IconType shirtsinbulk = on(FontAwesome7Brand.shirtsinbulk).build();
    public static final FontAwesome7IconType shoelace = on(FontAwesome7Brand.shoelace).build();
    public static final FontAwesome7IconType shopify = on(FontAwesome7Brand.shopify).build();
    public static final FontAwesome7IconType shopware = on(FontAwesome7Brand.shopware).build();
    public static final FontAwesome7IconType signal_messenger = on(FontAwesome7Brand.signal_messenger).build();
    public static final FontAwesome7IconType simplybuilt = on(FontAwesome7Brand.simplybuilt).build();
    public static final FontAwesome7IconType sistrix = on(FontAwesome7Brand.sistrix).build();
    public static final FontAwesome7IconType sith = on(FontAwesome7Brand.sith).build();
    public static final FontAwesome7IconType sitrox = on(FontAwesome7Brand.sitrox).build();
    public static final FontAwesome7IconType sketch = on(FontAwesome7Brand.sketch).build();
    public static final FontAwesome7IconType skyatlas = on(FontAwesome7Brand.skyatlas).build();
    public static final FontAwesome7IconType skype = on(FontAwesome7Brand.skype).build();
    public static final FontAwesome7IconType slack = on(FontAwesome7Brand.slack).build();
    public static final FontAwesome7IconType slack_hash = on(FontAwesome7Brand.slack_hash).build();
    public static final FontAwesome7IconType slideshare = on(FontAwesome7Brand.slideshare).build();
    public static final FontAwesome7IconType snapchat = on(FontAwesome7Brand.snapchat).build();
    public static final FontAwesome7IconType snapchat_ghost = on(FontAwesome7Brand.snapchat_ghost).build();
    public static final FontAwesome7IconType snapchat_square = on(FontAwesome7Brand.snapchat_square).build();
    public static final FontAwesome7IconType soundcloud = on(FontAwesome7Brand.soundcloud).build();
    public static final FontAwesome7IconType sourcetree = on(FontAwesome7Brand.sourcetree).build();
    public static final FontAwesome7IconType space_awesome = on(FontAwesome7Brand.space_awesome).build();
    public static final FontAwesome7IconType speakap = on(FontAwesome7Brand.speakap).build();
    public static final FontAwesome7IconType speaker_deck = on(FontAwesome7Brand.speaker_deck).build();
    public static final FontAwesome7IconType spotify = on(FontAwesome7Brand.spotify).build();
    public static final FontAwesome7IconType square_behance = on(FontAwesome7Brand.square_behance).build();
    public static final FontAwesome7IconType square_bluesky = on(FontAwesome7Brand.square_bluesky).build();
    public static final FontAwesome7IconType square_dribbble = on(FontAwesome7Brand.square_dribbble).build();
    public static final FontAwesome7IconType square_facebook = on(FontAwesome7Brand.square_facebook).build();
    public static final FontAwesome7IconType square_figma = on(FontAwesome7Brand.square_figma).build();
    public static final FontAwesome7IconType square_font_awesome = on(FontAwesome7Brand.square_font_awesome).build();
    public static final FontAwesome7IconType square_font_awesome_stroke = on(FontAwesome7Brand.square_font_awesome_stroke).build();
    public static final FontAwesome7IconType square_git = on(FontAwesome7Brand.square_git).build();
    public static final FontAwesome7IconType square_github = on(FontAwesome7Brand.square_github).build();
    public static final FontAwesome7IconType square_gitlab = on(FontAwesome7Brand.square_gitlab).build();
    public static final FontAwesome7IconType square_google_plus = on(FontAwesome7Brand.square_google_plus).build();
    public static final FontAwesome7IconType square_hacker_news = on(FontAwesome7Brand.square_hacker_news).build();
    public static final FontAwesome7IconType square_instagram = on(FontAwesome7Brand.square_instagram).build();
    public static final FontAwesome7IconType square_js = on(FontAwesome7Brand.square_js).build();
    public static final FontAwesome7IconType square_kickstarter = on(FontAwesome7Brand.square_kickstarter).build();
    public static final FontAwesome7IconType square_lastfm = on(FontAwesome7Brand.square_lastfm).build();
    public static final FontAwesome7IconType square_letterboxd = on(FontAwesome7Brand.square_letterboxd).build();
    public static final FontAwesome7IconType square_linkedin = on(FontAwesome7Brand.square_linkedin).build();
    public static final FontAwesome7IconType square_odnoklassniki = on(FontAwesome7Brand.square_odnoklassniki).build();
    public static final FontAwesome7IconType square_pied_piper = on(FontAwesome7Brand.square_pied_piper).build();
    public static final FontAwesome7IconType square_pinterest = on(FontAwesome7Brand.square_pinterest).build();
    public static final FontAwesome7IconType square_reddit = on(FontAwesome7Brand.square_reddit).build();
    public static final FontAwesome7IconType square_snapchat = on(FontAwesome7Brand.square_snapchat).build();
    public static final FontAwesome7IconType square_steam = on(FontAwesome7Brand.square_steam).build();
    public static final FontAwesome7IconType square_threads = on(FontAwesome7Brand.square_threads).build();
    public static final FontAwesome7IconType square_tumblr = on(FontAwesome7Brand.square_tumblr).build();
    public static final FontAwesome7IconType square_twitter = on(FontAwesome7Brand.square_twitter).build();
    public static final FontAwesome7IconType square_upwork = on(FontAwesome7Brand.square_upwork).build();
    public static final FontAwesome7IconType square_viadeo = on(FontAwesome7Brand.square_viadeo).build();
    public static final FontAwesome7IconType square_vimeo = on(FontAwesome7Brand.square_vimeo).build();
    public static final FontAwesome7IconType square_web_awesome = on(FontAwesome7Brand.square_web_awesome).build();
    public static final FontAwesome7IconType square_web_awesome_stroke = on(FontAwesome7Brand.square_web_awesome_stroke).build();
    public static final FontAwesome7IconType square_whatsapp = on(FontAwesome7Brand.square_whatsapp).build();
    public static final FontAwesome7IconType square_x_twitter = on(FontAwesome7Brand.square_x_twitter).build();
    public static final FontAwesome7IconType square_xing = on(FontAwesome7Brand.square_xing).build();
    public static final FontAwesome7IconType square_youtube = on(FontAwesome7Brand.square_youtube).build();
    public static final FontAwesome7IconType squarespace = on(FontAwesome7Brand.squarespace).build();
    public static final FontAwesome7IconType stack_exchange = on(FontAwesome7Brand.stack_exchange).build();
    public static final FontAwesome7IconType stack_overflow = on(FontAwesome7Brand.stack_overflow).build();
    public static final FontAwesome7IconType stackpath = on(FontAwesome7Brand.stackpath).build();
    public static final FontAwesome7IconType staylinked = on(FontAwesome7Brand.staylinked).build();
    public static final FontAwesome7IconType steam = on(FontAwesome7Brand.steam).build();
    public static final FontAwesome7IconType steam_square = on(FontAwesome7Brand.steam_square).build();
    public static final FontAwesome7IconType steam_symbol = on(FontAwesome7Brand.steam_symbol).build();
    public static final FontAwesome7IconType sticker_mule = on(FontAwesome7Brand.sticker_mule).build();
    public static final FontAwesome7IconType strava = on(FontAwesome7Brand.strava).build();
    public static final FontAwesome7IconType stripe = on(FontAwesome7Brand.stripe).build();
    public static final FontAwesome7IconType stripe_s = on(FontAwesome7Brand.stripe_s).build();
    public static final FontAwesome7IconType stubber = on(FontAwesome7Brand.stubber).build();
    public static final FontAwesome7IconType studiovinari = on(FontAwesome7Brand.studiovinari).build();
    public static final FontAwesome7IconType stumbleupon = on(FontAwesome7Brand.stumbleupon).build();
    public static final FontAwesome7IconType stumbleupon_circle = on(FontAwesome7Brand.stumbleupon_circle).build();
    public static final FontAwesome7IconType superpowers = on(FontAwesome7Brand.superpowers).build();
    public static final FontAwesome7IconType supple = on(FontAwesome7Brand.supple).build();
    public static final FontAwesome7IconType suse = on(FontAwesome7Brand.suse).build();
    public static final FontAwesome7IconType swift = on(FontAwesome7Brand.swift).build();
    public static final FontAwesome7IconType symfony = on(FontAwesome7Brand.symfony).build();
    public static final FontAwesome7IconType teamspeak = on(FontAwesome7Brand.teamspeak).build();
    public static final FontAwesome7IconType telegram = on(FontAwesome7Brand.telegram).build();
    public static final FontAwesome7IconType telegram_plane = on(FontAwesome7Brand.telegram_plane).build();
    public static final FontAwesome7IconType tencent_weibo = on(FontAwesome7Brand.tencent_weibo).build();
    public static final FontAwesome7IconType tex = on(FontAwesome7Brand.tex).build();
    public static final FontAwesome7IconType the_red_yeti = on(FontAwesome7Brand.the_red_yeti).build();
    public static final FontAwesome7IconType themeco = on(FontAwesome7Brand.themeco).build();
    public static final FontAwesome7IconType themeisle = on(FontAwesome7Brand.themeisle).build();
    public static final FontAwesome7IconType think_peaks = on(FontAwesome7Brand.think_peaks).build();
    public static final FontAwesome7IconType threads = on(FontAwesome7Brand.threads).build();
    public static final FontAwesome7IconType tidal = on(FontAwesome7Brand.tidal).build();
    public static final FontAwesome7IconType tiktok = on(FontAwesome7Brand.tiktok).build();
    public static final FontAwesome7IconType trade_federation = on(FontAwesome7Brand.trade_federation).build();
    public static final FontAwesome7IconType trello = on(FontAwesome7Brand.trello).build();
    public static final FontAwesome7IconType tumblr = on(FontAwesome7Brand.tumblr).build();
    public static final FontAwesome7IconType tumblr_square = on(FontAwesome7Brand.tumblr_square).build();
    public static final FontAwesome7IconType twitch = on(FontAwesome7Brand.twitch).build();
    public static final FontAwesome7IconType twitter = on(FontAwesome7Brand.twitter).build();
    public static final FontAwesome7IconType twitter_square = on(FontAwesome7Brand.twitter_square).build();
    public static final FontAwesome7IconType typo3 = on(FontAwesome7Brand.typo3).build();
    public static final FontAwesome7IconType uber = on(FontAwesome7Brand.uber).build();
    public static final FontAwesome7IconType ubuntu = on(FontAwesome7Brand.ubuntu).build();
    public static final FontAwesome7IconType uikit = on(FontAwesome7Brand.uikit).build();
    public static final FontAwesome7IconType umbraco = on(FontAwesome7Brand.umbraco).build();
    public static final FontAwesome7IconType uncharted = on(FontAwesome7Brand.uncharted).build();
    public static final FontAwesome7IconType uniregistry = on(FontAwesome7Brand.uniregistry).build();
    public static final FontAwesome7IconType unity = on(FontAwesome7Brand.unity).build();
    public static final FontAwesome7IconType unsplash = on(FontAwesome7Brand.unsplash).build();
    public static final FontAwesome7IconType untappd = on(FontAwesome7Brand.untappd).build();
    public static final FontAwesome7IconType ups = on(FontAwesome7Brand.ups).build();
    public static final FontAwesome7IconType upwork = on(FontAwesome7Brand.upwork).build();
    public static final FontAwesome7IconType usb = on(FontAwesome7Brand.usb).build();
    public static final FontAwesome7IconType usps = on(FontAwesome7Brand.usps).build();
    public static final FontAwesome7IconType ussunnah = on(FontAwesome7Brand.ussunnah).build();
    public static final FontAwesome7IconType vaadin = on(FontAwesome7Brand.vaadin).build();
    public static final FontAwesome7IconType viacoin = on(FontAwesome7Brand.viacoin).build();
    public static final FontAwesome7IconType viadeo = on(FontAwesome7Brand.viadeo).build();
    public static final FontAwesome7IconType viadeo_square = on(FontAwesome7Brand.viadeo_square).build();
    public static final FontAwesome7IconType viber = on(FontAwesome7Brand.viber).build();
    public static final FontAwesome7IconType vimeo = on(FontAwesome7Brand.vimeo).build();
    public static final FontAwesome7IconType vimeo_square = on(FontAwesome7Brand.vimeo_square).build();
    public static final FontAwesome7IconType vimeo_v = on(FontAwesome7Brand.vimeo_v).build();
    public static final FontAwesome7IconType vine = on(FontAwesome7Brand.vine).build();
    public static final FontAwesome7IconType vk = on(FontAwesome7Brand.vk).build();
    public static final FontAwesome7IconType vnv = on(FontAwesome7Brand.vnv).build();
    public static final FontAwesome7IconType vsco = on(FontAwesome7Brand.vsco).build();
    public static final FontAwesome7IconType vuejs = on(FontAwesome7Brand.vuejs).build();
    public static final FontAwesome7IconType w3c = on(FontAwesome7Brand.w3c).build();
    public static final FontAwesome7IconType watchman_monitoring = on(FontAwesome7Brand.watchman_monitoring).build();
    public static final FontAwesome7IconType waze = on(FontAwesome7Brand.waze).build();
    public static final FontAwesome7IconType web_awesome = on(FontAwesome7Brand.web_awesome).build();
    public static final FontAwesome7IconType webflow = on(FontAwesome7Brand.webflow).build();
    public static final FontAwesome7IconType weebly = on(FontAwesome7Brand.weebly).build();
    public static final FontAwesome7IconType weibo = on(FontAwesome7Brand.weibo).build();
    public static final FontAwesome7IconType weixin = on(FontAwesome7Brand.weixin).build();
    public static final FontAwesome7IconType whatsapp = on(FontAwesome7Brand.whatsapp).build();
    public static final FontAwesome7IconType whatsapp_square = on(FontAwesome7Brand.whatsapp_square).build();
    public static final FontAwesome7IconType whmcs = on(FontAwesome7Brand.whmcs).build();
    public static final FontAwesome7IconType wikipedia_w = on(FontAwesome7Brand.wikipedia_w).build();
    public static final FontAwesome7IconType windows = on(FontAwesome7Brand.windows).build();
    public static final FontAwesome7IconType wirsindhandwerk = on(FontAwesome7Brand.wirsindhandwerk).build();
    public static final FontAwesome7IconType wix = on(FontAwesome7Brand.wix).build();
    public static final FontAwesome7IconType wizards_of_the_coast = on(FontAwesome7Brand.wizards_of_the_coast).build();
    public static final FontAwesome7IconType wodu = on(FontAwesome7Brand.wodu).build();
    public static final FontAwesome7IconType wolf_pack_battalion = on(FontAwesome7Brand.wolf_pack_battalion).build();
    public static final FontAwesome7IconType wordpress = on(FontAwesome7Brand.wordpress).build();
    public static final FontAwesome7IconType wordpress_simple = on(FontAwesome7Brand.wordpress_simple).build();
    public static final FontAwesome7IconType wpbeginner = on(FontAwesome7Brand.wpbeginner).build();
    public static final FontAwesome7IconType wpexplorer = on(FontAwesome7Brand.wpexplorer).build();
    public static final FontAwesome7IconType wpforms = on(FontAwesome7Brand.wpforms).build();
    public static final FontAwesome7IconType wpressr = on(FontAwesome7Brand.wpressr).build();
    public static final FontAwesome7IconType wsh = on(FontAwesome7Brand.wsh).build();
    public static final FontAwesome7IconType x_twitter = on(FontAwesome7Brand.x_twitter).build();
    public static final FontAwesome7IconType xbox = on(FontAwesome7Brand.xbox).build();
    public static final FontAwesome7IconType xing = on(FontAwesome7Brand.xing).build();
    public static final FontAwesome7IconType xing_square = on(FontAwesome7Brand.xing_square).build();
    public static final FontAwesome7IconType y_combinator = on(FontAwesome7Brand.y_combinator).build();
    public static final FontAwesome7IconType yahoo = on(FontAwesome7Brand.yahoo).build();
    public static final FontAwesome7IconType yammer = on(FontAwesome7Brand.yammer).build();
    public static final FontAwesome7IconType yandex = on(FontAwesome7Brand.yandex).build();
    public static final FontAwesome7IconType yandex_international = on(FontAwesome7Brand.yandex_international).build();
    public static final FontAwesome7IconType yarn = on(FontAwesome7Brand.yarn).build();
    public static final FontAwesome7IconType yelp = on(FontAwesome7Brand.yelp).build();
    public static final FontAwesome7IconType yoast = on(FontAwesome7Brand.yoast).build();
    public static final FontAwesome7IconType youtube = on(FontAwesome7Brand.youtube).build();
    public static final FontAwesome7IconType youtube_square = on(FontAwesome7Brand.youtube_square).build();
    public static final FontAwesome7IconType zhihu = on(FontAwesome7Brand.zhihu).build();

    /**
     * Constructor.
     *
     * @param cssClassName The css class name of the icon reference
     */
    FontAwesome7IconType(final String... cssClassName) {
        super(Strings.join(" ", cssClassName));
    }

    @Override
    public String cssClassName() {
        return getCssClassName();
    }
}
