/*
 * Decompiled with CFR 0.152.
 */
package de.agilecoders.wicket.less;

import com.github.sommeri.less4j.LessSource;
import de.agilecoders.wicket.less.LessCacheManager;
import java.net.URL;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.core.util.resource.UrlResourceStream;
import org.apache.wicket.util.lang.Args;
import org.apache.wicket.util.resource.AbstractStringResourceStream;
import org.apache.wicket.util.resource.IResourceStream;
import org.apache.wicket.util.resource.ResourceStreamWrapper;
import org.apache.wicket.util.time.Time;

public class LessResourceStream
extends AbstractStringResourceStream {
    private final LessSource.URLSource lessSource;

    public LessResourceStream(IResourceStream lessStream, String scopeClass) {
        Args.notNull((Object)lessStream, (String)"lessStream");
        while (lessStream instanceof ResourceStreamWrapper) {
            ResourceStreamWrapper wrapper = (ResourceStreamWrapper)lessStream;
            try {
                lessStream = wrapper.getDelegate();
            }
            catch (Exception x) {
                throw new WicketRuntimeException((Throwable)x);
            }
        }
        if (!(lessStream instanceof UrlResourceStream)) {
            throw new IllegalArgumentException(String.format("%s can work only with %s", LessResourceStream.class.getSimpleName(), UrlResourceStream.class.getName()));
        }
        URL lessUrl = ((UrlResourceStream)lessStream).getURL();
        LessCacheManager cacheManager = LessCacheManager.get();
        this.lessSource = cacheManager.getLessSource(lessUrl, scopeClass);
    }

    protected String getString() {
        LessCacheManager cacheManager = LessCacheManager.get();
        return cacheManager.getCss(this.lessSource);
    }

    public Time lastModifiedTime() {
        LessCacheManager cacheManager = LessCacheManager.get();
        return cacheManager.getLastModifiedTime(this.lessSource);
    }

    public String getContentType() {
        return "text/css";
    }
}

