/*
 * Decompiled with CFR 0.152.
 */
package de.agilecoders.wicket.less;

import com.github.sommeri.less4j.LessSource;
import de.agilecoders.wicket.less.LessCacheManager;
import de.agilecoders.wicket.webjars.WicketWebjars;
import de.agilecoders.wicket.webjars.util.WebJarAssetLocator;
import java.net.MalformedURLException;
import java.net.URL;
import javax.servlet.ServletContext;
import org.apache.commons.lang3.StringUtils;
import org.apache.wicket.Application;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.core.util.lang.WicketObjects;
import org.apache.wicket.protocol.http.WebApplication;
import org.apache.wicket.util.string.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LessUrlSource
extends LessSource.URLSource {
    private static final Logger LOG = LoggerFactory.getLogger(LessUrlSource.class);
    public static final String CLASSPATH_SCHEME = "classpath!";
    public static final String PACKAGE_SCHEME = "package!";
    public static final String WEBJARS_SCHEME = "webjars!";
    public static final String WEB_CONTEXT_SCHEME = "webcontext!";
    private final String scopeClass;

    LessUrlSource(URL inputURL, String scopeClass) {
        super(inputURL);
        this.scopeClass = scopeClass;
    }

    public LessSource relativeSource(String filename) throws LessSource.FileNotFound, LessSource.CannotReadFile {
        LessUrlSource relative;
        boolean addParent = true;
        if (StringUtils.startsWith((CharSequence)filename, (CharSequence)WEBJARS_SCHEME)) {
            relative = this.resolveWebJarsDependency(filename);
        } else if (StringUtils.startsWith((CharSequence)filename, (CharSequence)CLASSPATH_SCHEME)) {
            relative = this.resolveClasspathDependency(filename);
        } else if (StringUtils.startsWith((CharSequence)filename, (CharSequence)WEB_CONTEXT_SCHEME)) {
            relative = this.resolveWebContextDependency(filename);
        } else if (this.scopeClass != null && StringUtils.startsWith((CharSequence)filename, (CharSequence)PACKAGE_SCHEME)) {
            relative = this.resolvePackageDependency(filename);
        } else {
            addParent = false;
            relative = super.relativeSource(filename);
        }
        if (addParent) {
            this.addImportedSource((LessSource)relative);
        }
        return relative;
    }

    private LessSource resolveWebContextDependency(String filename) {
        LOG.debug("Going to resolve an import from the web context: {}", (Object)filename);
        String resourceName = filename.substring(WEB_CONTEXT_SCHEME.length());
        if (resourceName.indexOf(0) == 47) {
            resourceName = resourceName.substring(1);
        }
        ServletContext context = ((WebApplication)Application.get()).getServletContext();
        try {
            URL url = context.getResource(resourceName);
            return new LessUrlSource(url, this.scopeClass);
        }
        catch (MalformedURLException mux) {
            throw new IllegalArgumentException("Cannot create a URL to a resource in the web context", mux);
        }
    }

    private LessUrlSource resolvePackageDependency(String filename) {
        Class scope;
        URL url;
        if (Strings.isEmpty((CharSequence)this.scopeClass)) {
            throw new IllegalStateException("Cannot resolve dependency '" + filename + "' without a scope class!");
        }
        LOG.debug("Going to resolve an import from the package: {}", (Object)filename);
        String resourceName = filename.substring(PACKAGE_SCHEME.length());
        if (resourceName.indexOf(0) == 47) {
            resourceName = resourceName.substring(1);
        }
        if ((url = (scope = WicketObjects.resolveClass((String)this.scopeClass)).getResource(resourceName)) != null) {
            return new LessUrlSource(url, this.scopeClass);
        }
        throw new IllegalArgumentException(String.format("Cannot resolve relative source with name '%s' in the package of '%s'", filename, this.scopeClass));
    }

    private LessUrlSource resolveClasspathDependency(String filename) {
        URL url;
        LOG.debug("Going to resolve an import from the classpath: {}", (Object)filename);
        String resourceName = filename.substring(CLASSPATH_SCHEME.length() + 1);
        if (resourceName.indexOf(0) != 47) {
            resourceName = '/' + resourceName;
        }
        if ((url = LessCacheManager.class.getResource(resourceName)) != null) {
            return new LessUrlSource(url, this.scopeClass);
        }
        throw new IllegalArgumentException(String.format("Cannot resolve relative source with name '%s' in the classpath", filename));
    }

    private LessUrlSource resolveWebJarsDependency(String filename) {
        LOG.debug("Going to resolve an import from WebJars: {}", (Object)filename);
        String file = Holder.locator.getFullPath(filename.replaceFirst(WEBJARS_SCHEME, "/webjars/"));
        try {
            URL res = Thread.currentThread().getContextClassLoader().getResource(file);
            return new LessUrlSource(res, this.scopeClass);
        }
        catch (RuntimeException e) {
            throw new WicketRuntimeException((Throwable)e);
        }
    }

    private static final class Holder {
        private static final WebJarAssetLocator locator = new WebJarAssetLocator(WicketWebjars.settings());

        private Holder() {
        }
    }
}

