/*
 * Decompiled with CFR 0.152.
 */
package de.agilecoders.wicket.samples;

import com.google.javascript.jscomp.CompilationLevel;
import de.agilecoders.wicket.core.Bootstrap;
import de.agilecoders.wicket.core.markup.html.RenderJavaScriptToFooterHeaderResponseDecorator;
import de.agilecoders.wicket.core.markup.html.references.BootstrapPrettifyCssReference;
import de.agilecoders.wicket.core.markup.html.references.BootstrapPrettifyJavaScriptReference;
import de.agilecoders.wicket.core.markup.html.references.ModernizrJavaScriptReference;
import de.agilecoders.wicket.core.request.resource.caching.version.Adler32ResourceVersion;
import de.agilecoders.wicket.core.settings.BootstrapSettings;
import de.agilecoders.wicket.core.settings.IBootstrapSettings;
import de.agilecoders.wicket.core.settings.ITheme;
import de.agilecoders.wicket.core.settings.ThemeProvider;
import de.agilecoders.wicket.extensions.javascript.GoogleClosureJavaScriptCompressor;
import de.agilecoders.wicket.extensions.javascript.YuiCssCompressor;
import de.agilecoders.wicket.extensions.markup.html.bootstrap.html5player.Html5PlayerCssReference;
import de.agilecoders.wicket.extensions.markup.html.bootstrap.html5player.Html5PlayerJavaScriptReference;
import de.agilecoders.wicket.extensions.markup.html.bootstrap.icon.OpenWebIconsCssReference;
import de.agilecoders.wicket.extensions.markup.html.bootstrap.jqueryui.JQueryUIJavaScriptReference;
import de.agilecoders.wicket.extensions.request.StaticResourceRewriteMapper;
import de.agilecoders.wicket.less.BootstrapLess;
import de.agilecoders.wicket.samples.assets.base.ApplicationJavaScript;
import de.agilecoders.wicket.samples.assets.base.FixBootstrapStylesCssResourceReference;
import de.agilecoders.wicket.samples.pages.HomePage;
import de.agilecoders.wicket.themes.markup.html.bootstrap3.Bootstrap3Theme;
import de.agilecoders.wicket.themes.markup.html.bootstrap3.Bootstrap3ThemeJsResourceReference;
import de.agilecoders.wicket.themes.markup.html.google.GoogleTheme;
import de.agilecoders.wicket.themes.markup.html.metro.MetroTheme;
import de.agilecoders.wicket.themes.markup.html.wicket.WicketTheme;
import de.agilecoders.wicket.themes.settings.BootswatchThemeProvider;
import java.io.IOException;
import java.util.Properties;
import org.apache.wicket.Application;
import org.apache.wicket.Page;
import org.apache.wicket.RuntimeConfigurationType;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.css.ICssCompressor;
import org.apache.wicket.javascript.IJavaScriptCompressor;
import org.apache.wicket.markup.html.IHeaderResponseDecorator;
import org.apache.wicket.protocol.http.WebApplication;
import org.apache.wicket.request.resource.CssResourceReference;
import org.apache.wicket.request.resource.JavaScriptResourceReference;
import org.apache.wicket.request.resource.ResourceReference;
import org.apache.wicket.request.resource.caching.FilenameWithVersionResourceCachingStrategy;
import org.apache.wicket.request.resource.caching.IResourceCachingStrategy;
import org.apache.wicket.request.resource.caching.NoOpResourceCachingStrategy;
import org.apache.wicket.request.resource.caching.version.CachingResourceVersion;
import org.apache.wicket.request.resource.caching.version.IResourceVersion;
import org.apache.wicket.serialize.ISerializer;
import org.apache.wicket.serialize.java.DeflatedJavaSerializer;
import org.apache.wicket.settings.IRequestCycleSettings;
import org.apache.wicket.util.string.Strings;
import org.wicketstuff.annotation.scan.AnnotatedMountScanner;

public class WicketApplication
extends WebApplication {
    private Properties properties = this.loadProperties();

    public static WicketApplication get() {
        return (WicketApplication)Application.get();
    }

    public WicketApplication() {
        this.setConfigurationType(RuntimeConfigurationType.valueOf((String)this.properties.getProperty("configuration.type")));
    }

    public Class<? extends Page> getHomePage() {
        return HomePage.class;
    }

    public void init() {
        super.init();
        this.getDebugSettings().setAjaxDebugModeEnabled(false);
        this.configureBootstrap();
        this.optimizeForWebPerformance();
        new AnnotatedMountScanner().scanPackage("de.agilecoders.wicket.samples.pages").mount((WebApplication)this);
        if (Strings.isTrue((String)this.properties.getProperty("cdn.useCdn"))) {
            String cdn = this.properties.getProperty("cdn.baseUrl");
            StaticResourceRewriteMapper.withBaseUrl((String)cdn).install((WebApplication)this);
        }
    }

    private void optimizeForWebPerformance() {
        if (this.usesDeploymentConfig()) {
            this.getResourceSettings().setCachingStrategy((IResourceCachingStrategy)new FilenameWithVersionResourceCachingStrategy("-", (IResourceVersion)new CachingResourceVersion((IResourceVersion)new Adler32ResourceVersion())));
            this.getResourceSettings().setJavaScriptCompressor((IJavaScriptCompressor)new GoogleClosureJavaScriptCompressor(CompilationLevel.SIMPLE_OPTIMIZATIONS));
            this.getResourceSettings().setCssCompressor((ICssCompressor)new YuiCssCompressor());
            this.getFrameworkSettings().setSerializer((ISerializer)new DeflatedJavaSerializer(this.getApplicationKey()));
        } else {
            this.getResourceSettings().setCachingStrategy((IResourceCachingStrategy)new NoOpResourceCachingStrategy());
        }
        this.setHeaderResponseDecorator((IHeaderResponseDecorator)new RenderJavaScriptToFooterHeaderResponseDecorator());
        this.getRequestCycleSettings().setRenderStrategy(IRequestCycleSettings.RenderStrategy.ONE_PASS_RENDER);
    }

    private void configureResourceBundles() {
        this.getResourceBundles().addJavaScriptBundle(WicketApplication.class, "core.js", new JavaScriptResourceReference[]{(JavaScriptResourceReference)this.getJavaScriptLibrarySettings().getJQueryReference(), (JavaScriptResourceReference)this.getJavaScriptLibrarySettings().getWicketEventReference(), (JavaScriptResourceReference)this.getJavaScriptLibrarySettings().getWicketAjaxReference(), (JavaScriptResourceReference)ModernizrJavaScriptReference.INSTANCE});
        this.getResourceBundles().addJavaScriptBundle(WicketApplication.class, "bootstrap.js", new JavaScriptResourceReference[]{(JavaScriptResourceReference)Bootstrap.getSettings().getJsResourceReference(), (JavaScriptResourceReference)BootstrapPrettifyJavaScriptReference.INSTANCE, ApplicationJavaScript.INSTANCE});
        this.getResourceBundles().addJavaScriptBundle(WicketApplication.class, "bootstrap-extensions.js", new JavaScriptResourceReference[]{JQueryUIJavaScriptReference.instance(), Html5PlayerJavaScriptReference.instance()});
        this.getResourceBundles().addCssBundle(WicketApplication.class, "bootstrap-extensions.css", new CssResourceReference[]{Html5PlayerCssReference.instance(), OpenWebIconsCssReference.instance()});
        this.getResourceBundles().addCssBundle(WicketApplication.class, "application.css", new CssResourceReference[]{(CssResourceReference)BootstrapPrettifyCssReference.INSTANCE, FixBootstrapStylesCssResourceReference.INSTANCE});
    }

    private void configureBootstrap() {
        BootswatchThemeProvider themeProvider = new BootswatchThemeProvider(){
            {
                this.add(new ITheme[]{new MetroTheme()});
                this.add(new ITheme[]{new GoogleTheme()});
                this.add(new ITheme[]{new WicketTheme()});
                this.add(new ITheme[]{new Bootstrap3Theme()});
                this.defaultTheme("wicket");
            }
        };
        BootstrapSettings settings = new BootstrapSettings();
        settings.setJsResourceFilterName("footer-container").setThemeProvider((ThemeProvider)themeProvider);
        settings.setJsResourceReference((ResourceReference)Bootstrap3ThemeJsResourceReference.INSTANCE);
        Bootstrap.install((Application)this, (IBootstrapSettings)settings);
        BootstrapLess.install((Application)this);
    }

    public Properties getProperties() {
        return this.properties;
    }

    private Properties loadProperties() {
        Properties properties = new Properties();
        try {
            properties.load(((Object)((Object)this)).getClass().getResourceAsStream("/config.properties"));
        }
        catch (IOException e) {
            throw new WicketRuntimeException((Throwable)e);
        }
        return properties;
    }
}

