/*
 * Decompiled with CFR 0.152.
 */
package de.agilecoders.wicket.samples.pages;

import com.google.common.collect.Lists;
import de.agilecoders.wicket.core.markup.html.bootstrap.navigation.BootstrapPagingNavigator;
import de.agilecoders.wicket.core.markup.html.bootstrap.navigation.Breadcrumb;
import de.agilecoders.wicket.core.markup.html.bootstrap.tabs.BootstrapTabbedPanel;
import de.agilecoders.wicket.samples.components.basecss.DatePickerModal;
import de.agilecoders.wicket.samples.pages.BasePage;
import java.io.Serializable;
import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.extensions.breadcrumb.IBreadCrumbModel;
import org.apache.wicket.extensions.breadcrumb.IBreadCrumbParticipant;
import org.apache.wicket.extensions.breadcrumb.panel.BreadCrumbPanel;
import org.apache.wicket.extensions.markup.html.tabs.AbstractTab;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.navigation.paging.IPageable;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.request.mapper.parameter.PageParameters;
import org.wicketstuff.annotation.mount.MountPath;

@MountPath(value="/basecss", alt={"/css"})
public class BaseCssPage
extends BasePage {
    public BaseCssPage(PageParameters parameters) {
        super(parameters);
    }

    private Component newTabs(String markupId) {
        return new BootstrapTabbedPanel(markupId, (List)Lists.newArrayList((Object[])new AbstractTab[]{this.createTab("Home"), this.createTab("Second")}));
    }

    private AbstractTab createTab(String title) {
        return new AbstractTab((IModel)Model.of((Serializable)((Object)title))){

            public WebMarkupContainer getPanel(String panelId) {
                return new WebMarkupContainer(panelId);
            }
        };
    }

    private Component newBreadcrumb(String markupId) {
        Breadcrumb breadcrumb = new Breadcrumb(markupId);
        breadcrumb.setActive((IBreadCrumbParticipant)new BreadCrumbPanel("breadcrumbid", (IBreadCrumbModel)breadcrumb){

            public IModel<String> getTitle() {
                return Model.of((Serializable)((Object)"Title"));
            }
        });
        return breadcrumb;
    }

    private Component newPagination(String markupId) {
        IPageable pageable = new IPageable(){

            public long getCurrentPage() {
                return 1L;
            }

            public void setCurrentPage(long page) {
            }

            public long getPageCount() {
                return 5L;
            }
        };
        return new BootstrapPagingNavigator(markupId, pageable).setPosition(BootstrapPagingNavigator.Position.Centered);
    }

    private DatePickerModal newModalDialog(String markupId) {
        return new DatePickerModal(markupId);
    }

    @Override
    protected boolean hasNavigation() {
        return true;
    }
}

