/*
 * Decompiled with CFR 0.152.
 */
package de.agilecoders.wicket.samples.pages;

import de.agilecoders.wicket.core.markup.html.bootstrap.button.BootstrapAjaxLink;
import de.agilecoders.wicket.core.markup.html.bootstrap.button.Buttons;
import de.agilecoders.wicket.core.markup.html.bootstrap.button.dropdown.DropDownButton;
import de.agilecoders.wicket.core.markup.html.bootstrap.button.dropdown.DropDownSubMenu;
import de.agilecoders.wicket.core.markup.html.bootstrap.button.dropdown.MenuBookmarkablePageLink;
import de.agilecoders.wicket.core.markup.html.bootstrap.button.dropdown.MenuDivider;
import de.agilecoders.wicket.core.markup.html.bootstrap.button.dropdown.SplitButton;
import de.agilecoders.wicket.core.markup.html.bootstrap.image.IconType;
import de.agilecoders.wicket.extensions.markup.html.bootstrap.button.DropDownAutoOpen;
import de.agilecoders.wicket.samples.components.basecss.ButtonGroups;
import de.agilecoders.wicket.samples.pages.BasePage;
import de.agilecoders.wicket.samples.pages.DatePickerPage;
import de.agilecoders.wicket.samples.pages.ExtensionsPage;
import de.agilecoders.wicket.samples.pages.IssuesPage;
import de.agilecoders.wicket.samples.pages.Javascript;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.html.link.AbstractLink;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.request.mapper.parameter.PageParameters;
import org.wicketstuff.annotation.mount.MountPath;

@MountPath(value="/components")
public class ComponentsPage
extends BasePage {
    public ComponentsPage(PageParameters parameters) {
        super(parameters);
        this.add(new Component[]{this.newSplitButton("splitbutton")});
        this.add(new Component[]{new ButtonGroups("buttonGroups")});
        this.add(new Component[]{this.newDropDownSubMenuExample()});
    }

    private Component newSplitButton(String markupId) {
        return new SplitButton(markupId, (IModel)Model.of((Serializable)((Object)"Action"))){

            protected AbstractLink newBaseButton(String markupId, IModel<String> labelModel, IModel<IconType> iconTypeModel) {
                return new BootstrapAjaxLink<String>(markupId, labelModel, Buttons.Type.Default){

                    public void onClick(AjaxRequestTarget target) {
                        target.appendJavaScript((CharSequence)"alert('clicked');");
                    }
                };
            }

            protected List<AbstractLink> newSubMenuButtons(String buttonMarkupId) {
                ArrayList<AbstractLink> subMenu = new ArrayList<AbstractLink>();
                subMenu.add((AbstractLink)new MenuBookmarkablePageLink(ComponentsPage.class, (IModel)Model.of((Serializable)((Object)"Link 1"))));
                subMenu.add((AbstractLink)new MenuBookmarkablePageLink(ComponentsPage.class, (IModel)Model.of((Serializable)((Object)"Link 2"))));
                subMenu.add((AbstractLink)new MenuBookmarkablePageLink(ComponentsPage.class, (IModel)Model.of((Serializable)((Object)"Link 3"))));
                return subMenu;
            }
        };
    }

    @Override
    protected boolean hasNavigation() {
        return true;
    }

    private Component newDropDownSubMenuExample() {
        return new DropDownButton("dropDownSubMenuExample", (IModel)Model.of((Serializable)((Object)"Addons"))){

            protected List<AbstractLink> newSubMenuButtons(String buttonMarkupId) {
                ArrayList<AbstractLink> links = new ArrayList<AbstractLink>();
                links.add((AbstractLink)new MenuBookmarkablePageLink(Javascript.class, (IModel)Model.of((Serializable)((Object)"Javascript"))).setIconType(IconType.refresh));
                links.add((AbstractLink)new MenuBookmarkablePageLink(DatePickerPage.class, (IModel)Model.of((Serializable)((Object)"DatePicker"))).setIconType(IconType.time));
                links.add((AbstractLink)new MenuBookmarkablePageLink(IssuesPage.class, (IModel)Model.of((Serializable)((Object)"Github Issues"))).setIconType(IconType.book));
                links.add((AbstractLink)new MenuBookmarkablePageLink(ExtensionsPage.class, (IModel)Model.of((Serializable)((Object)"Extensions"))).setIconType(IconType.alignjustify));
                links.add((AbstractLink)new MenuDivider());
                links.add((AbstractLink)new DropDownSubMenu((IModel)Model.of((Serializable)((Object)"Sub-Menu Level 1"))){

                    protected List<AbstractLink> newSubMenuButtons(String buttonMarkupId) {
                        ArrayList<AbstractLink> links = new ArrayList<AbstractLink>();
                        links.add((AbstractLink)new MenuBookmarkablePageLink(Javascript.class, (IModel)Model.of((Serializable)((Object)"Javascript"))).setIconType(IconType.refresh));
                        links.add((AbstractLink)new MenuBookmarkablePageLink(DatePickerPage.class, (IModel)Model.of((Serializable)((Object)"DatePicker"))).setIconType(IconType.time));
                        links.add((AbstractLink)new MenuDivider());
                        links.add((AbstractLink)new DropDownSubMenu((IModel)Model.of((Serializable)((Object)"Sub-Menu Level 2"))){

                            protected List<AbstractLink> newSubMenuButtons(String buttonMarkupId) {
                                ArrayList<AbstractLink> links = new ArrayList<AbstractLink>();
                                links.add((AbstractLink)new MenuBookmarkablePageLink(Javascript.class, (IModel)Model.of((Serializable)((Object)"Javascript"))).setIconType(IconType.refresh));
                                links.add((AbstractLink)new MenuBookmarkablePageLink(DatePickerPage.class, (IModel)Model.of((Serializable)((Object)"DatePicker"))).setIconType(IconType.time));
                                return links;
                            }
                        });
                        return links;
                    }
                }.setIconType(IconType.arrowright));
                return links;
            }
        }.setIconType(IconType.thlarge).add(new Behavior[]{new DropDownAutoOpen()});
    }
}

