/*
 * Decompiled with CFR 0.152.
 */
package de.agilecoders.wicket.samples.panels.pagination;

import de.agilecoders.wicket.core.markup.html.bootstrap.navigation.BootstrapPagingNavigator;
import de.agilecoders.wicket.core.markup.html.bootstrap.navigation.InfiniteScrollingBehavior;
import de.agilecoders.wicket.core.markup.html.bootstrap.navigation.ajax.BootstrapAjaxPagingNavigator;
import de.agilecoders.wicket.samples.panels.pagination.AbstractPaginationPanel;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.wicket.AttributeModifier;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.markup.html.navigation.paging.AjaxPagingNavigationBehavior;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.navigation.paging.IPageable;
import org.apache.wicket.model.Model;

public class InfinitePaginationPanel
extends AbstractPaginationPanel {
    private final InfiniteScrollingBehavior scrollingBehavior;
    private BootstrapPagingNavigator pager;
    private final Model<String> callbackUrl;
    private final Component nextLink;

    public InfinitePaginationPanel(String markupId) {
        super(markupId);
        this.setOutputMarkupId(true);
        this.callbackUrl = new Model();
        this.nextLink = new Label("next-page").add(new Behavior[]{new AttributeModifier("href", this.callbackUrl)});
        this.add(new Component[]{this.nextLink});
        Behavior[] behaviorArray = new Behavior[1];
        this.scrollingBehavior = this.newInfiniteScrollingBehavior((Component)this.pager, this.nextLink);
        behaviorArray[0] = this.scrollingBehavior;
        this.add(behaviorArray);
    }

    protected InfiniteScrollingBehavior newInfiniteScrollingBehavior(Component pager, Component nextLink) {
        InfiniteScrollingBehavior scrollingBehavior = new InfiniteScrollingBehavior();
        scrollingBehavior.setNavSelector(pager);
        scrollingBehavior.setItemSelector((Component)this, ".item");
        scrollingBehavior.setNextSelector(nextLink);
        scrollingBehavior.loadingMsgText("loading...");
        scrollingBehavior.loadingImg("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAEAAAABCAYAAAAfFcSJAAAABHNCSVQICAgIfAhkiAAAAA1JREFUCJlj+P///38ACfsD/QjR6B4AAAAASUVORK5CYII=");
        scrollingBehavior.loadingFinishedMsg("completed!");
        return scrollingBehavior;
    }

    protected void onConfigure() {
        super.onConfigure();
        this.pager.add(new Behavior[]{new AttributeModifier("style", (Serializable)((Object)"display:none;"))});
        for (Behavior behavior : this.pager.get("next").getBehaviors()) {
            if (!(behavior instanceof AjaxPagingNavigationBehavior)) continue;
            this.callbackUrl.setObject((Serializable)((Object)((AjaxPagingNavigationBehavior)behavior).getCallbackUrl().toString()));
            break;
        }
    }

    @Override
    protected Component createPager(String id) {
        this.pager = new BootstrapAjaxPagingNavigator(id, (IPageable)this.pageable);
        return this.pager;
    }

    @Override
    protected List<String> createData() {
        ArrayList<String> elements = new ArrayList<String>(1000);
        int l = 1000;
        for (int i = 0; i < l; ++i) {
            elements.add("element #" + i);
        }
        return elements;
    }

    @Override
    protected int pageSize() {
        return 100;
    }
}

