/*
 * Decompiled with CFR 0.152.
 */
package de.agilecoders.wicket.samples.components.basecss;

import de.agilecoders.wicket.core.markup.html.bootstrap.button.BootstrapBookmarkablePageLink;
import de.agilecoders.wicket.core.markup.html.bootstrap.button.ButtonBehavior;
import de.agilecoders.wicket.core.markup.html.bootstrap.button.ButtonGroup;
import de.agilecoders.wicket.core.markup.html.bootstrap.button.ButtonList;
import de.agilecoders.wicket.core.markup.html.bootstrap.button.Buttons;
import de.agilecoders.wicket.core.markup.html.bootstrap.button.Toolbar;
import de.agilecoders.wicket.core.markup.html.bootstrap.image.Icon;
import de.agilecoders.wicket.core.markup.html.bootstrap.image.IconType;
import de.agilecoders.wicket.core.util.Generics2;
import de.agilecoders.wicket.samples.components.base.Section;
import de.agilecoders.wicket.samples.pages.ComponentsPage;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.html.link.AbstractLink;
import org.apache.wicket.markup.html.link.BookmarkablePageLink;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;

public class ButtonGroups
extends Section {
    public ButtonGroups(String markupId) {
        super(markupId);
        ButtonGroup buttonGroup = new ButtonGroup("buttonGroup"){

            protected List<AbstractLink> newButtons(String buttonMarkupId) {
                return Generics2.newArrayList((Object[])new AbstractLink[]{ButtonGroups.this.createButton("Left"), ButtonGroups.this.createButton("Center"), ButtonGroups.this.createButton("Right")});
            }
        };
        this.add(new Component[]{buttonGroup});
        Toolbar toolbar = new Toolbar("toolbar");
        toolbar.add(new Component[]{this.newButtonGroup("buttonGroup1", 3)});
        toolbar.add(new Component[]{this.newButtonGroup("buttonGroup2", 5)});
        toolbar.add(new Component[]{this.newButtonGroup("buttonGroup3", 1)});
        this.add(new Component[]{toolbar});
        ButtonGroup verticalButtonGroup = new ButtonGroup("verticalButtonGroup", Buttons.Orientation.Vertical){

            protected List<AbstractLink> newButtons(String buttonMarkupId) {
                return Generics2.newArrayList((Object[])new AbstractLink[]{ButtonGroups.this.createIconButton(new Icon(IconType.alignleft)), ButtonGroups.this.createIconButton(new Icon(IconType.aligncenter)), ButtonGroups.this.createIconButton(new Icon(IconType.alignright)), ButtonGroups.this.createIconButton(new Icon(IconType.alignjustify))});
            }
        };
        this.add(new Component[]{verticalButtonGroup});
    }

    private AbstractLink createIconButton(Icon icon) {
        BootstrapBookmarkablePageLink button = new BootstrapBookmarkablePageLink(ButtonList.getButtonMarkupId(), ComponentsPage.class, Buttons.Type.Default);
        button.setLabel((IModel)Model.of((Serializable)((Object)"")));
        button.setIconType(icon.getType());
        return button;
    }

    private ButtonGroup newButtonGroup(String markupId, final int noOfButtons) {
        return new ButtonGroup(markupId){

            protected List<AbstractLink> newButtons(String buttonMarkupId) {
                ArrayList<AbstractLink> buttons = new ArrayList<AbstractLink>();
                for (int i = 0; i < noOfButtons; ++i) {
                    buttons.add(ButtonGroups.this.createButton(String.valueOf(i + 1)));
                }
                return buttons;
            }
        };
    }

    private AbstractLink createButton(String label) {
        AbstractLink button = new BookmarkablePageLink(ButtonList.getButtonMarkupId(), ComponentsPage.class).setBody((IModel)Model.of((Serializable)((Object)label)));
        button.add(new Behavior[]{new ButtonBehavior()});
        return button;
    }
}

