/*
 * Decompiled with CFR 0.152.
 */
package de.agilecoders.wicket.samples.pages;

import com.newrelic.api.agent.NewRelic;
import de.agilecoders.wicket.core.Bootstrap;
import de.agilecoders.wicket.core.markup.html.bootstrap.behavior.BootstrapBaseBehavior;
import de.agilecoders.wicket.core.markup.html.bootstrap.block.Code;
import de.agilecoders.wicket.core.markup.html.bootstrap.button.dropdown.DropDownButton;
import de.agilecoders.wicket.core.markup.html.bootstrap.button.dropdown.MenuBookmarkablePageLink;
import de.agilecoders.wicket.core.markup.html.bootstrap.button.dropdown.MenuDivider;
import de.agilecoders.wicket.core.markup.html.bootstrap.button.dropdown.MenuHeader;
import de.agilecoders.wicket.core.markup.html.bootstrap.html.ChromeFrameMetaTag;
import de.agilecoders.wicket.core.markup.html.bootstrap.html.HtmlTag;
import de.agilecoders.wicket.core.markup.html.bootstrap.html.MetaTag;
import de.agilecoders.wicket.core.markup.html.bootstrap.html.OptimizedMobileViewportMetaTag;
import de.agilecoders.wicket.core.markup.html.bootstrap.image.IconType;
import de.agilecoders.wicket.core.markup.html.bootstrap.navbar.AffixBehavior;
import de.agilecoders.wicket.core.markup.html.bootstrap.navbar.INavbarComponent;
import de.agilecoders.wicket.core.markup.html.bootstrap.navbar.ImmutableNavbarComponent;
import de.agilecoders.wicket.core.markup.html.bootstrap.navbar.Navbar;
import de.agilecoders.wicket.core.markup.html.bootstrap.navbar.NavbarButton;
import de.agilecoders.wicket.core.markup.html.bootstrap.navbar.NavbarComponents;
import de.agilecoders.wicket.core.markup.html.bootstrap.navbar.NavbarDropDownButton;
import de.agilecoders.wicket.core.settings.IBootstrapSettings;
import de.agilecoders.wicket.core.settings.ITheme;
import de.agilecoders.wicket.extensions.markup.html.bootstrap.button.DropDownAutoOpen;
import de.agilecoders.wicket.samples.WicketApplication;
import de.agilecoders.wicket.samples.assets.base.ApplicationJavaScript;
import de.agilecoders.wicket.samples.assets.base.DocsCssResourceReference;
import de.agilecoders.wicket.samples.assets.base.FixBootstrapStylesCssResourceReference;
import de.agilecoders.wicket.samples.components.site.Footer;
import de.agilecoders.wicket.samples.pages.BaseCssPage;
import de.agilecoders.wicket.samples.pages.ComponentsPage;
import de.agilecoders.wicket.samples.pages.DatePickerPage;
import de.agilecoders.wicket.samples.pages.ExtensionsPage;
import de.agilecoders.wicket.samples.pages.HomePage;
import de.agilecoders.wicket.samples.pages.IssuesPage;
import de.agilecoders.wicket.samples.pages.Javascript;
import de.agilecoders.wicket.samples.pages.Scaffolding;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.apache.wicket.Application;
import org.apache.wicket.AttributeModifier;
import org.apache.wicket.Component;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.head.CssHeaderItem;
import org.apache.wicket.markup.head.HeaderItem;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.markup.head.JavaScriptHeaderItem;
import org.apache.wicket.markup.head.filter.FilteredHeaderItem;
import org.apache.wicket.markup.head.filter.HeaderResponseContainer;
import org.apache.wicket.markup.html.GenericWebPage;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.link.AbstractLink;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.request.mapper.parameter.PageParameters;
import org.apache.wicket.request.resource.ResourceReference;
import org.apache.wicket.util.string.StringValue;

abstract class BasePage<T>
extends GenericWebPage<T> {
    public BasePage(PageParameters parameters) {
        super(parameters);
        this.add(new Component[]{new HtmlTag("html")});
        this.add(new Component[]{new OptimizedMobileViewportMetaTag("viewport")});
        this.add(new Component[]{new ChromeFrameMetaTag("chrome-frame")});
        this.add(new Component[]{new MetaTag("description", (IModel)Model.of((Serializable)((Object)"description")), (IModel)Model.of((Serializable)((Object)"Apache Wicket & Twitter Bootstrap Demo")))});
        this.add(new Component[]{new MetaTag("author", (IModel)Model.of((Serializable)((Object)"author")), (IModel)Model.of((Serializable)((Object)"Michael Haitz <michael.haitz@agile-coders.de>")))});
        this.add(new Component[]{this.newNavbar("navbar")});
        this.add(new Component[]{this.newNavigation("navigation")});
        this.add(new Component[]{new Footer("footer")});
        this.add(new Behavior[]{new BootstrapBaseBehavior()});
        this.add(new Component[]{new Code("code-internal")});
        this.add(new Component[]{new HeaderResponseContainer("footer-container", "footer-container")});
        this.add(new Component[]{new Label("newrelic", (IModel)Model.of((Serializable)((Object)NewRelic.getBrowserTimingHeader()))).setEscapeModelStrings(false).setRenderBodyOnly(true).add(new Behavior[]{new AttributeModifier("id", (Serializable)((Object)"newrelic-rum-header"))})});
        this.add(new Component[]{new Label("newrelic-footer", (IModel)Model.of((Serializable)((Object)NewRelic.getBrowserTimingFooter()))).setEscapeModelStrings(false).setRenderBodyOnly(true).add(new Behavior[]{new AttributeModifier("id", (Serializable)((Object)"newrelic-rum-footer"))})});
    }

    public Properties getProperties() {
        return WicketApplication.get().getProperties();
    }

    protected Navbar newNavbar(String markupId) {
        Navbar navbar = new Navbar(markupId);
        navbar.setPosition(Navbar.Position.TOP);
        navbar.brandName((IModel)Model.of((Serializable)((Object)"Wicket Bootstrap")));
        navbar.addComponents(NavbarComponents.transform((Navbar.ComponentPosition)Navbar.ComponentPosition.LEFT, (Component[])new Component[]{new NavbarButton(HomePage.class, (IModel)Model.of((Serializable)((Object)"Overview"))).setIconType(IconType.home), new NavbarButton(BaseCssPage.class, (IModel)Model.of((Serializable)((Object)"Base CSS"))), new NavbarButton(ComponentsPage.class, (IModel)Model.of((Serializable)((Object)"Components"))), new NavbarButton(Scaffolding.class, (IModel)Model.of((Serializable)((Object)"Scaffolding"))), this.newAddonsDropDownButton()}));
        DropDownButton dropdown = new NavbarDropDownButton((IModel)Model.of((Serializable)((Object)"Themes"))){

            public boolean isActive(Component item) {
                return false;
            }

            protected List<AbstractLink> newSubMenuButtons(String buttonMarkupId) {
                ArrayList<AbstractLink> subMenu = new ArrayList<AbstractLink>();
                subMenu.add((AbstractLink)new MenuHeader((IModel)Model.of((Serializable)((Object)"all available themes:"))));
                subMenu.add((AbstractLink)new MenuDivider());
                IBootstrapSettings settings = Bootstrap.getSettings((Application)this.getApplication());
                List themes = settings.getThemeProvider().available();
                for (ITheme theme : themes) {
                    PageParameters params = new PageParameters();
                    params.set("theme", (Object)theme.name());
                    subMenu.add((AbstractLink)new MenuBookmarkablePageLink(BasePage.this.getPageClass(), params, (IModel)Model.of((Serializable)((Object)theme.name()))));
                }
                return subMenu;
            }
        }.setIconType(IconType.book);
        dropdown.add(new Behavior[]{new DropDownAutoOpen()});
        navbar.addComponents(new INavbarComponent[]{new ImmutableNavbarComponent((Component)dropdown, Navbar.ComponentPosition.RIGHT)});
        return navbar;
    }

    private Component newAddonsDropDownButton() {
        return new NavbarDropDownButton((IModel)Model.of((Serializable)((Object)"Addons"))){

            protected List<AbstractLink> newSubMenuButtons(String buttonMarkupId) {
                ArrayList<AbstractLink> subMenu = new ArrayList<AbstractLink>();
                subMenu.add((AbstractLink)new MenuBookmarkablePageLink(Javascript.class, (IModel)Model.of((Serializable)((Object)"Javascript"))).setIconType(IconType.refresh));
                subMenu.add((AbstractLink)new MenuBookmarkablePageLink(DatePickerPage.class, (IModel)Model.of((Serializable)((Object)"DatePicker"))).setIconType(IconType.time));
                subMenu.add((AbstractLink)new MenuBookmarkablePageLink(IssuesPage.class, (IModel)Model.of((Serializable)((Object)"Github Issues"))).setIconType(IconType.book));
                subMenu.add((AbstractLink)new MenuBookmarkablePageLink(ExtensionsPage.class, (IModel)Model.of((Serializable)((Object)"Extensions"))).setIconType(IconType.alignjustify));
                return subMenu;
            }
        }.setIconType(IconType.thlarge).setInverted(true).add(new Behavior[]{new DropDownAutoOpen()});
    }

    private void configureTheme(PageParameters pageParameters) {
        StringValue theme = pageParameters.get("theme");
        if (!theme.isEmpty()) {
            IBootstrapSettings settings = Bootstrap.getSettings((Application)this.getApplication());
            settings.getActiveThemeProvider().setActiveTheme(theme.toString(""));
        }
    }

    protected ITheme activeTheme() {
        IBootstrapSettings settings = Bootstrap.getSettings((Application)this.getApplication());
        return settings.getActiveThemeProvider().getActiveTheme();
    }

    protected void onConfigure() {
        super.onConfigure();
        this.configureTheme(this.getPageParameters());
    }

    public void renderHead(IHeaderResponse response) {
        super.renderHead(response);
        response.render((HeaderItem)CssHeaderItem.forReference((ResourceReference)FixBootstrapStylesCssResourceReference.INSTANCE));
        response.render((HeaderItem)new FilteredHeaderItem((HeaderItem)JavaScriptHeaderItem.forReference((ResourceReference)ApplicationJavaScript.INSTANCE), "footer-container"));
        if ("google".equalsIgnoreCase(this.activeTheme().name())) {
            response.render((HeaderItem)CssHeaderItem.forReference((ResourceReference)DocsCssResourceReference.GOOGLE));
        }
    }

    protected boolean hasNavigation() {
        return false;
    }

    private Component newNavigation(String markupId) {
        WebMarkupContainer navigation = new WebMarkupContainer(markupId);
        navigation.add(new Behavior[]{new AffixBehavior("200")});
        navigation.setVisible(this.hasNavigation());
        return navigation;
    }
}

