/*
 * Decompiled with CFR 0.152.
 */
package de.agilecoders.wicket.samples.pages;

import de.agilecoders.wicket.core.markup.html.bootstrap.button.BootstrapLink;
import de.agilecoders.wicket.core.markup.html.bootstrap.button.ButtonBehavior;
import de.agilecoders.wicket.core.markup.html.bootstrap.button.Buttons;
import de.agilecoders.wicket.core.markup.html.bootstrap.common.NotificationMessage;
import de.agilecoders.wicket.core.markup.html.bootstrap.common.NotificationPanel;
import de.agilecoders.wicket.core.markup.html.bootstrap.components.PopoverBehavior;
import de.agilecoders.wicket.core.markup.html.bootstrap.components.PopoverConfig;
import de.agilecoders.wicket.core.markup.html.bootstrap.components.TooltipConfig;
import de.agilecoders.wicket.core.markup.html.bootstrap.dialog.Modal;
import de.agilecoders.wicket.core.markup.html.bootstrap.dialog.ModalCloseButton;
import de.agilecoders.wicket.core.markup.html.bootstrap.dialog.TextContentModal;
import de.agilecoders.wicket.core.markup.html.bootstrap.navbar.AbstractNavbarComponent;
import de.agilecoders.wicket.core.markup.html.bootstrap.navbar.INavbarComponent;
import de.agilecoders.wicket.core.markup.html.bootstrap.navbar.ImmutableNavbarComponent;
import de.agilecoders.wicket.core.markup.html.bootstrap.navbar.Navbar;
import de.agilecoders.wicket.core.markup.html.bootstrap.navbar.NavbarAjaxLink;
import de.agilecoders.wicket.extensions.markup.html.bootstrap.form.ColorPickerConfig;
import de.agilecoders.wicket.extensions.markup.html.bootstrap.form.ColorPickerTextField;
import de.agilecoders.wicket.extensions.markup.html.bootstrap.form.DateTextField;
import de.agilecoders.wicket.samples.components.issues.CustomNavbarForm;
import de.agilecoders.wicket.samples.pages.BasePage;
import java.io.Serializable;
import java.util.Date;
import org.apache.wicket.Component;
import org.apache.wicket.Page;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.markup.html.form.AjaxSubmitLink;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.event.Broadcast;
import org.apache.wicket.event.IEvent;
import org.apache.wicket.event.IEventSink;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.panel.FeedbackPanel;
import org.apache.wicket.model.CompoundPropertyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.request.mapper.parameter.PageParameters;
import org.apache.wicket.util.time.Duration;
import org.wicketstuff.annotation.mount.MountPath;

@MountPath(value="/issues")
public class IssuesPage
extends BasePage {
    private DateBean dateBean = new DateBean();

    public IssuesPage(PageParameters parameters) {
        super(parameters);
        this.add(new Component[]{new NotificationPanel("feedback").hideAfter(Duration.seconds((int)5))});
        this.add(new Component[]{new ParentNavbar("navbar-parent"), new SubNavbar("navbar-child")});
        this.add(new Component[]{this.createDatePickerForm("datepicker-form")});
        this.add(new Component[]{new Navbar("navbar-form").addComponents(new INavbarComponent[]{new AbstractNavbarComponent(Navbar.ComponentPosition.LEFT){

            public Component create(String markupId) {
                return new CustomNavbarForm(markupId);
            }
        }})});
        Modal modal = this.newModalDialog("endless-modal").setUseCloseHandler(true).setFadeIn(true).setUseKeyboard(true);
        Label button = new Label("open-endless-modal", "Open Modal Dialog");
        modal.addOpenerAttributesTo((Component)button);
        this.add(new Component[]{modal, button});
        this.add(new Component[]{new Label("popover", "Popover (hover, top)").add(new Behavior[]{new PopoverBehavior((IModel)Model.of((Serializable)((Object)"title")), (IModel)Model.of((Serializable)((Object)"content")), new PopoverConfig().withHoverTrigger().withPlacement((TooltipConfig.IPlacement)TooltipConfig.Placement.top))})});
        this.add(new Component[]{new Label("richpopover", "Popover (hover, top)")});
        this.add(new Component[]{new BootstrapLink<Page>("link", (IModel)Model.of((Serializable)((Object)this))){

            public void onClick() {
                this.getSession().success((Serializable)new NotificationMessage((IModel)Model.of((Serializable)((Object)"link 1 clicked")), (IModel)Model.of((Serializable)((Object)"issue #102:")), true));
                this.setResponsePage((Page)this.getModelObject());
            }
        }.setLabel((IModel)Model.of((Serializable)((Object)"Link 1")))});
        this.add(new Component[]{new BootstrapLink<Page>("link-danger", (IModel)Model.of((Serializable)((Object)this)), Buttons.Type.Danger){

            public void onClick() {
                this.getSession().success((Serializable)new NotificationMessage((IModel)Model.of((Serializable)((Object)"link 2 <u>clicked</u>")), (IModel)Model.of((Serializable)((Object)"issue #102:")), true).escapeModelStrings(false));
                this.setResponsePage((Page)this.getModelObject());
            }
        }.setLabel((IModel)Model.of((Serializable)((Object)"Link 2")))});
        this.add(new Component[]{this.createColorPickerForm("colorpicker-form")});
    }

    private Modal newModalDialog(String markupId) {
        TextContentModal modal = new TextContentModal(markupId, (IModel)Model.of((Serializable)((Object)"Issue #90")));
        modal.addButton((Component)new ModalCloseButton());
        return modal;
    }

    public Form createDatePickerForm(String markupId) {
        Form form = new Form(markupId, (IModel)new CompoundPropertyModel((IModel)new PropertyModel((Object)this, "dateBean")));
        this.add(new Component[]{form});
        DateTextField dueDate = new DateTextField("dueDate");
        form.add(new Component[]{dueDate});
        form.add(new Component[]{new AjaxSubmitLink("submit", form){
            private static final long serialVersionUID = -2647897814406807218L;

            protected void onInitialize() {
                super.onInitialize();
                this.add(new Behavior[]{new ButtonBehavior()});
            }

            protected void onSubmit(AjaxRequestTarget target, Form<?> form) {
                System.out.print(IssuesPage.this.dateBean);
                target.appendJavaScript((CharSequence)("alert('DateBean.dueDate is: " + IssuesPage.this.dateBean.getDueDate() + "');"));
            }
        }});
        return form;
    }

    public Form createColorPickerForm(String markupId) {
        final FeedbackPanel colorPickerFeedback = new FeedbackPanel("colorPickerFeedback");
        colorPickerFeedback.setOutputMarkupId(true);
        this.add(new Component[]{colorPickerFeedback});
        Form form = new Form(markupId);
        this.add(new Component[]{form});
        ColorPickerConfig config = new ColorPickerConfig();
        config.setComponent(true);
        config.setAjaxUpdate(true);
        final ColorPickerTextField colorPicker = new ColorPickerTextField("colorPicker", (IModel)Model.of((Serializable)((Object)"")), config){

            protected void onChange(AjaxRequestTarget target, String color) {
                super.onChange(target, color);
                this.success((Serializable)((Object)("Selected color is: " + color)));
                target.add(new Component[]{colorPickerFeedback});
            }
        };
        form.add(new Component[]{colorPicker});
        form.add(new Component[]{new AjaxSubmitLink("submit", form){
            private static final long serialVersionUID = -2647897814406807218L;

            protected void onInitialize() {
                super.onInitialize();
                this.add(new Behavior[]{new ButtonBehavior()});
            }

            protected void onSubmit(AjaxRequestTarget target, Form<?> form) {
                this.success((Serializable)((Object)("Selected color is: " + (String)colorPicker.getModelObject())));
                target.add(new Component[]{colorPickerFeedback});
            }
        }});
        return form;
    }

    @Override
    protected boolean hasNavigation() {
        return true;
    }

    private static final class ToggleSubNavbarState {
        private final AjaxRequestTarget target;
        private final SubNavGroup group;

        public ToggleSubNavbarState(AjaxRequestTarget target, SubNavGroup group) {
            this.target = target;
            this.group = group;
        }

        public SubNavGroup getGroup() {
            return this.group;
        }

        public AjaxRequestTarget getTarget() {
            return this.target;
        }
    }

    private static enum SubNavGroup {
        NONE,
        A,
        B;

    }

    private static final class ParentNavbar
    extends Navbar {
        public ParentNavbar(String componentId) {
            super(componentId);
            this.setInverted(false);
            this.setOutputMarkupId(true);
            this.addComponents(new INavbarComponent[]{new ImmutableNavbarComponent((Component)new NavbarAjaxLink<String>((IModel)Model.of((Serializable)((Object)"button group a"))){

                public void onClick(AjaxRequestTarget target) {
                    this.send((IEventSink)this.getPage(), Broadcast.BREADTH, new ToggleSubNavbarState(target, SubNavGroup.A));
                }
            }, Navbar.ComponentPosition.LEFT), new ImmutableNavbarComponent((Component)new NavbarAjaxLink<String>((IModel)Model.of((Serializable)((Object)"button group b"))){

                public void onClick(AjaxRequestTarget target) {
                    this.send((IEventSink)this.getPage(), Broadcast.BREADTH, new ToggleSubNavbarState(target, SubNavGroup.B));
                }
            }, Navbar.ComponentPosition.LEFT)});
        }
    }

    private static final class SubNavbar
    extends Navbar {
        private final IModel<SubNavGroup> group = Model.of((Serializable)((Object)SubNavGroup.NONE));

        public SubNavbar(String componentId) {
            super(componentId);
            this.setInverted(true);
            this.setOutputMarkupId(true);
            this.addComponents(new INavbarComponent[]{new ImmutableNavbarComponent((Component)new NavbarAjaxLink<String>((IModel)Model.of((Serializable)((Object)"button a"))){

                public void onClick(AjaxRequestTarget target) {
                    target.appendJavaScript((CharSequence)"alert('button A clicked');");
                }

                public boolean isVisible() {
                    return SubNavGroup.A.equals(SubNavbar.this.group.getObject());
                }
            }, Navbar.ComponentPosition.LEFT), new ImmutableNavbarComponent((Component)new NavbarAjaxLink<String>((IModel)Model.of((Serializable)((Object)"button b"))){

                public void onClick(AjaxRequestTarget target) {
                    target.appendJavaScript((CharSequence)"alert('button B clicked');");
                }

                public boolean isVisible() {
                    return SubNavGroup.B.equals(SubNavbar.this.group.getObject());
                }
            }, Navbar.ComponentPosition.LEFT)});
        }

        public void onEvent(IEvent<?> event) {
            super.onEvent(event);
            if (event.getPayload() instanceof ToggleSubNavbarState) {
                ToggleSubNavbarState stateEvent = (ToggleSubNavbarState)event.getPayload();
                this.group.setObject((Object)stateEvent.getGroup());
                stateEvent.getTarget().add(new Component[]{this});
            }
        }
    }

    public class DateBean
    implements Serializable {
        private static final long serialVersionUID = 7570029514918506580L;
        private Date dueDate;

        public DateBean() {
            this(new Date());
        }

        public DateBean(Date dueDate) {
            this.dueDate = dueDate;
        }

        public Date getDueDate() {
            return this.dueDate;
        }

        public void setDueDate(Date dueDate) {
            this.dueDate = dueDate;
        }

        public String toString() {
            return "DateBean [dueDate=" + this.dueDate + "]";
        }
    }
}

