/*
 * Decompiled with CFR 0.152.
 */
package de.agilecoders.wicket.themes.markup.html.vegibit;

import de.agilecoders.wicket.core.Bootstrap;
import de.agilecoders.wicket.core.settings.IBootstrapSettings;
import de.agilecoders.wicket.core.settings.ITheme;
import de.agilecoders.wicket.themes.markup.html.vegibit.VegibitCssReference;
import java.util.Collections;
import java.util.List;
import org.apache.wicket.Application;
import org.apache.wicket.markup.head.CssHeaderItem;
import org.apache.wicket.markup.head.HeaderItem;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.request.Url;
import org.apache.wicket.request.resource.ResourceReference;
import org.apache.wicket.request.resource.UrlResourceReference;

public enum VegibitTheme implements ITheme
{
    vegiflat,
    vegistone,
    vegitalian,
    vegication,
    vegisweet,
    vegiretro,
    vegimelon,
    vegipooh,
    vegisea,
    vegilibrium,
    vegibuntu,
    vegitapenade,
    vegimin,
    vegilime,
    vegitini,
    vegicalm,
    vegificial,
    vegisail,
    vegicasso,
    vegimoon;

    private static final String CDN_PATTERN = "//netdna.bootstrapcdn.com/vegibit/%s/%s/bootstrap.min.css";
    private String cdnUrl;
    private final ResourceReference reference = new VegibitCssReference(this.name().toLowerCase());

    public List<HeaderItem> getDependencies() {
        return Collections.singletonList(CssHeaderItem.forReference((ResourceReference)this.reference).setId("wb-theme"));
    }

    public Iterable<String> getCdnUrls() {
        return Collections.emptyList();
    }

    public void renderHead(IHeaderResponse response) {
        if (this.useCdnResources()) {
            if (this.cdnUrl == null) {
                this.cdnUrl = String.format(CDN_PATTERN, this.getVersion(), this.name().toLowerCase());
            }
            response.render((HeaderItem)CssHeaderItem.forReference((ResourceReference)new UrlResourceReference(Url.parse((CharSequence)this.cdnUrl))));
        } else {
            for (HeaderItem headerItem : this.getDependencies()) {
                response.render(headerItem);
            }
        }
    }

    private boolean useCdnResources() {
        IBootstrapSettings settings;
        boolean result = false;
        if (Application.exists() && (settings = Bootstrap.getSettings()) != null) {
            result = settings.useCdnResources();
        }
        return result;
    }

    private String getVersion() {
        IBootstrapSettings settings;
        String version = "3.3.5";
        if (Application.exists() && (settings = Bootstrap.getSettings()) != null) {
            version = settings.getVersion();
        }
        return version;
    }
}

