/*
 * Decompiled with CFR 0.152.
 */
package de.ahus1.keycloak.dropwizard;

import de.ahus1.keycloak.dropwizard.KeycloakConfiguration;
import io.dropwizard.auth.AuthenticationException;
import io.dropwizard.auth.Authenticator;
import java.security.Principal;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import org.keycloak.KeycloakSecurityContext;

public abstract class AbstractKeycloakAuthenticator<P extends Principal>
implements Authenticator<HttpServletRequest, P> {
    private final KeycloakConfiguration keycloakConfiguration;

    public AbstractKeycloakAuthenticator(KeycloakConfiguration keycloakConfiguration) {
        this.keycloakConfiguration = keycloakConfiguration;
    }

    public Optional<P> authenticate(HttpServletRequest request) throws AuthenticationException {
        KeycloakSecurityContext securityContext = (KeycloakSecurityContext)request.getAttribute(KeycloakSecurityContext.class.getName());
        if (securityContext != null) {
            return Optional.ofNullable(this.prepareAuthentication(securityContext, request, this.keycloakConfiguration));
        }
        return Optional.empty();
    }

    protected abstract P prepareAuthentication(KeycloakSecurityContext var1, HttpServletRequest var2, KeycloakConfiguration var3);
}

