/*
 * Decompiled with CFR 0.152.
 */
package de.ahus1.keycloak.dropwizard;

import com.google.common.base.Preconditions;
import de.ahus1.keycloak.dropwizard.JaxrsHttpFacade;
import io.dropwizard.auth.AuthFilter;
import io.dropwizard.auth.AuthenticationException;
import java.security.Principal;
import java.util.Optional;
import javax.annotation.Priority;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.InternalServerErrorException;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.core.SecurityContext;
import org.eclipse.jetty.server.Request;
import org.keycloak.adapters.AdapterDeploymentContext;
import org.keycloak.adapters.AdapterTokenStore;
import org.keycloak.adapters.KeycloakDeployment;
import org.keycloak.adapters.KeycloakDeploymentBuilder;
import org.keycloak.adapters.jetty.JettyAdapterSessionStore;
import org.keycloak.adapters.jetty.core.JettyCookieTokenStore;
import org.keycloak.adapters.jetty.core.JettyRequestAuthenticator;
import org.keycloak.adapters.jetty.core.JettySessionTokenStore;
import org.keycloak.adapters.spi.AdapterSessionStore;
import org.keycloak.adapters.spi.AuthChallenge;
import org.keycloak.adapters.spi.AuthOutcome;
import org.keycloak.adapters.spi.HttpFacade;
import org.keycloak.enums.TokenStore;
import org.keycloak.representations.adapters.config.AdapterConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Priority(value=1000)
public class KeycloakAuthFilter<P extends Principal>
extends AuthFilter<HttpServletRequest, P> {
    private static final Logger LOGGER = LoggerFactory.getLogger(KeycloakAuthFilter.class);
    public static final String TOKEN_STORE_NOTE = "TOKEN_STORE_NOTE";
    private AdapterDeploymentContext deploymentContext;
    private AdapterConfig adapterConfig;

    public void initializeKeycloak() {
        KeycloakDeployment kd = KeycloakDeploymentBuilder.build((AdapterConfig)this.adapterConfig);
        this.deploymentContext = new AdapterDeploymentContext(kd);
    }

    private KeycloakAuthFilter(AdapterConfig adapterConfig) {
        this.adapterConfig = adapterConfig;
    }

    public void filter(final ContainerRequestContext requestContext) {
        this.validateRequest(requestContext);
        HttpServletRequest request = (HttpServletRequest)requestContext.getProperty(HttpServletRequest.class.getName());
        try {
            final Optional principal = this.authenticator.authenticate((Object)request);
            if (principal.isPresent()) {
                requestContext.setSecurityContext(new SecurityContext(){

                    public Principal getUserPrincipal() {
                        return (Principal)principal.get();
                    }

                    public boolean isUserInRole(String role) {
                        return KeycloakAuthFilter.this.authorizer.authorize((Principal)principal.get(), role);
                    }

                    public boolean isSecure() {
                        return requestContext.getSecurityContext().isSecure();
                    }

                    public String getAuthenticationScheme() {
                        return "BASIC";
                    }
                });
                return;
            }
        }
        catch (AuthenticationException e) {
            LOGGER.warn("Error authenticating credentials", (Throwable)e);
            throw new InternalServerErrorException();
        }
    }

    public void validateRequest(ContainerRequestContext requestContext) {
        if (requestContext.getSecurityContext().getUserPrincipal() != null) {
            return;
        }
        Request request = Request.getBaseRequest((ServletRequest)((ServletRequest)requestContext.getProperty(HttpServletRequest.class.getName())));
        JaxrsHttpFacade facade = new JaxrsHttpFacade(requestContext, requestContext.getSecurityContext());
        request.setAttribute(AdapterDeploymentContext.class.getName(), (Object)this.deploymentContext);
        KeycloakDeployment deployment = this.deploymentContext.resolveDeployment((HttpFacade)facade);
        if (deployment == null || !deployment.isConfigured()) {
            return;
        }
        AdapterTokenStore tokenStore = KeycloakAuthFilter.getTokenStore((HttpServletRequest)request, (HttpFacade)facade, deployment);
        tokenStore.checkCurrentToken();
        JettyRequestAuthenticator authenticator = this.createRequestAuthenticator((HttpServletRequest)request, facade, deployment, tokenStore);
        AuthOutcome outcome = authenticator.authenticate();
        if (outcome == AuthOutcome.AUTHENTICATED) {
            return;
        }
        AuthChallenge challenge = authenticator.getChallenge();
        if (challenge != null) {
            challenge.challenge((HttpFacade)facade);
            if (!this.adapterConfig.isBearerOnly()) {
                facade.getResponse().setCookie("JSESSIONID", request.getSession().getId(), "/", null, -1, false, false);
            }
            facade.getResponse().end();
        }
    }

    protected JettyRequestAuthenticator createRequestAuthenticator(HttpServletRequest request, JaxrsHttpFacade facade, KeycloakDeployment deployment, AdapterTokenStore tokenStore) {
        Request r = Request.getBaseRequest((ServletRequest)request);
        return new JettyRequestAuthenticator((HttpFacade)facade, deployment, tokenStore, -1, r);
    }

    public static AdapterTokenStore getTokenStore(HttpServletRequest request, HttpFacade facade, KeycloakDeployment resolvedDeployment) {
        Object store = (AdapterTokenStore)request.getAttribute(TOKEN_STORE_NOTE);
        if (store != null) {
            return store;
        }
        Request r = Request.getBaseRequest((ServletRequest)request);
        store = resolvedDeployment.getTokenStore() == TokenStore.SESSION ? new JettySessionTokenStore(r, resolvedDeployment, (AdapterSessionStore)new JettyAdapterSessionStore(r)) : new JettyCookieTokenStore(r, facade, resolvedDeployment);
        request.setAttribute(TOKEN_STORE_NOTE, store);
        return store;
    }

    public static class Builder<P extends Principal>
    extends AuthFilter.AuthFilterBuilder<HttpServletRequest, P, KeycloakAuthFilter<P>> {
        private AdapterConfig adapterConfig;

        protected KeycloakAuthFilter<P> newInstance() {
            return new KeycloakAuthFilter(this.adapterConfig);
        }

        public Builder<P> setConfig(AdapterConfig adapterConfig) {
            this.adapterConfig = adapterConfig;
            return this;
        }

        public KeycloakAuthFilter<P> buildAuthFilter() {
            Preconditions.checkArgument((this.adapterConfig != null ? 1 : 0) != 0, (Object)"Keycloak config is not set");
            KeycloakAuthFilter filter = (KeycloakAuthFilter)super.buildAuthFilter();
            filter.initializeKeycloak();
            return filter;
        }
    }
}

