/*
 * Decompiled with CFR 0.152.
 */
package de.ahus1.keycloak.dropwizard;

import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.eclipse.jetty.security.ServerAuthException;
import org.eclipse.jetty.security.authentication.DeferredAuthentication;
import org.eclipse.jetty.server.Authentication;
import org.keycloak.KeycloakSecurityContext;
import org.keycloak.adapters.jetty.KeycloakJettyAuthenticator;

public class KeycloakDropwizardAuthenticator
extends KeycloakJettyAuthenticator {
    public Authentication validateRequest(ServletRequest req, ServletResponse res, boolean mandatory) throws ServerAuthException {
        HttpServletRequest request = (HttpServletRequest)req;
        request.setAttribute(HttpServletRequest.class.getName(), (Object)request);
        if (!this.getAdapterConfig().isBearerOnly() && request.getQueryString() != null && request.getQueryString().contains("code=")) {
            mandatory = true;
        } else if (request.getHeaders("Authorization").hasMoreElements()) {
            mandatory = true;
        }
        HttpSession session = ((HttpServletRequest)req).getSession(false);
        if (session != null && session.getAttribute("__CACHED_FORM_PARAMETERS") != null) {
            mandatory = true;
        } else if (session != null && session.getAttribute(KeycloakSecurityContext.class.getName()) != null) {
            mandatory = true;
        }
        Authentication authentication = super.validateRequest(req, res, mandatory);
        if (authentication instanceof DeferredAuthentication) {
            authentication = null;
        }
        return authentication;
    }
}

