/*
 * Decompiled with CFR 0.152.
 */
package de.ahus1.keycloak.dropwizard;

import de.ahus1.keycloak.dropwizard.KeycloakConfiguration;
import de.ahus1.keycloak.dropwizard.KeycloakResource;
import java.security.Principal;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import org.keycloak.KeycloakSecurityContext;
import org.keycloak.representations.AccessToken;

public abstract class AbstractUser
implements Principal {
    protected HttpServletRequest request;
    protected KeycloakSecurityContext securityContext;
    private final Set<String> roles;

    public AbstractUser(HttpServletRequest request, KeycloakSecurityContext securityContext, KeycloakConfiguration keycloakConfiguration) {
        this.request = request;
        this.securityContext = securityContext;
        this.roles = this.selectRolesToApply(keycloakConfiguration);
    }

    private Set<String> selectRolesToApply(KeycloakConfiguration keycloakConfiguration) {
        if (keycloakConfiguration.isUseResourceRoleMappings()) {
            return this.selectResourceRoles(new KeycloakResource(keycloakConfiguration.getResource()));
        }
        return this.selectRealmRoles();
    }

    private Set<String> selectResourceRoles(KeycloakResource keycloakResource) {
        HashSet roles = new HashSet();
        AccessToken.Access resourceAccess = this.securityContext.getToken().getResourceAccess(keycloakResource.getResource());
        if (resourceAccess != null && resourceAccess.getRoles() != null) {
            roles.addAll(resourceAccess.getRoles());
        }
        return Collections.unmodifiableSet(roles);
    }

    private Set<String> selectRealmRoles() {
        HashSet roles = new HashSet();
        AccessToken.Access realmAccess = this.securityContext.getToken().getRealmAccess();
        if (realmAccess != null && realmAccess.getRoles() != null) {
            roles.addAll(realmAccess.getRoles());
        }
        return Collections.unmodifiableSet(roles);
    }

    public Set<String> getRoles() {
        return this.roles;
    }

    public void logout() throws ServletException {
        if (this.request.getUserPrincipal() != null) {
            this.request.logout();
        }
    }
}

