/*
 * Decompiled with CFR 0.152.
 */
package de.ahus1.keycloak.dropwizard;

import java.io.BufferedInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;
import javax.security.cert.X509Certificate;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.core.Cookie;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.NewCookie;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import org.keycloak.KeycloakSecurityContext;
import org.keycloak.adapters.OIDCHttpFacade;
import org.keycloak.adapters.spi.AuthenticationError;
import org.keycloak.adapters.spi.HttpFacade;
import org.keycloak.adapters.spi.LogoutError;
import org.keycloak.common.util.HostUtils;

public class JaxrsHttpFacade
implements OIDCHttpFacade {
    private final ContainerRequestContext requestContext;
    private final SecurityContext securityContext;
    private final RequestFacade requestFacade = new RequestFacade();
    private final ResponseFacade responseFacade = new ResponseFacade();
    private boolean responseFinished;

    public JaxrsHttpFacade(ContainerRequestContext containerRequestContext, SecurityContext securityContext) {
        this.requestContext = containerRequestContext;
        this.securityContext = securityContext;
    }

    public KeycloakSecurityContext getSecurityContext() {
        HttpServletRequest httpServletRequest = (HttpServletRequest)this.requestContext.getProperty(HttpServletRequest.class.getName());
        if (httpServletRequest != null) {
            return (KeycloakSecurityContext)httpServletRequest.getAttribute(KeycloakSecurityContext.class.getName());
        }
        return null;
    }

    public HttpFacade.Request getRequest() {
        return this.requestFacade;
    }

    public HttpFacade.Response getResponse() {
        return this.responseFacade;
    }

    public X509Certificate[] getCertificateChain() {
        throw new IllegalStateException("Not supported yet");
    }

    protected class ResponseFacade
    implements HttpFacade.Response {
        private Response.ResponseBuilder responseBuilder = Response.status((Response.Status)Response.Status.NO_CONTENT);

        protected ResponseFacade() {
        }

        public void setStatus(int status) {
            this.responseBuilder.status(status);
        }

        public void addHeader(String name, String value) {
            this.responseBuilder.header(name, (Object)value);
        }

        public void setHeader(String name, String value) {
            this.responseBuilder.header(name, (Object)value);
        }

        public void resetCookie(String name, String path) {
            this.responseBuilder.cookie(new NewCookie[]{new NewCookie(name, "", path, null, null, 0, false)});
        }

        public void setCookie(String name, String value, String path, String domain, int maxAge, boolean secure, boolean httpOnly) {
            this.responseBuilder.cookie(new NewCookie[]{new NewCookie(name, value, path, domain, null, maxAge, secure, httpOnly)});
        }

        public OutputStream getOutputStream() {
            throw new IllegalStateException("Not supported yet");
        }

        public void sendError(int code) {
            Response response = this.responseBuilder.status(code).build();
            JaxrsHttpFacade.this.requestContext.abortWith(response);
            JaxrsHttpFacade.this.responseFinished = true;
        }

        public void sendError(int code, String message) {
            Response response = this.responseBuilder.status(code).entity((Object)message).build();
            JaxrsHttpFacade.this.requestContext.abortWith(response);
            JaxrsHttpFacade.this.responseFinished = true;
        }

        public void end() {
            Response response = this.responseBuilder.build();
            JaxrsHttpFacade.this.requestContext.abortWith(response);
            JaxrsHttpFacade.this.responseFinished = true;
        }
    }

    protected class RequestFacade
    implements HttpFacade.Request {
        private InputStream inputStream;

        protected RequestFacade() {
        }

        public String getMethod() {
            return JaxrsHttpFacade.this.requestContext.getMethod();
        }

        public String getURI() {
            return JaxrsHttpFacade.this.requestContext.getUriInfo().getRequestUri().toString();
        }

        public String getRelativePath() {
            return JaxrsHttpFacade.this.requestContext.getUriInfo().getPath();
        }

        public boolean isSecure() {
            return JaxrsHttpFacade.this.securityContext.isSecure();
        }

        public String getFirstParam(String param) {
            return this.getQueryParamValue(param);
        }

        public String getQueryParamValue(String param) {
            MultivaluedMap queryParams = JaxrsHttpFacade.this.requestContext.getUriInfo().getQueryParameters();
            if (queryParams == null) {
                return null;
            }
            return (String)queryParams.getFirst((Object)param);
        }

        public HttpFacade.Cookie getCookie(String cookieName) {
            Map cookies = JaxrsHttpFacade.this.requestContext.getCookies();
            if (cookies == null) {
                return null;
            }
            Cookie cookie = (Cookie)cookies.get(cookieName);
            if (cookie == null) {
                return null;
            }
            return new HttpFacade.Cookie(cookie.getName(), cookie.getValue(), cookie.getVersion(), cookie.getDomain(), cookie.getPath());
        }

        public String getHeader(String name) {
            return JaxrsHttpFacade.this.requestContext.getHeaderString(name);
        }

        public List<String> getHeaders(String name) {
            MultivaluedMap headers = JaxrsHttpFacade.this.requestContext.getHeaders();
            return headers == null ? null : (List)headers.get((Object)name);
        }

        public InputStream getInputStream() {
            return this.getInputStream(false);
        }

        public InputStream getInputStream(boolean buffered) {
            if (this.inputStream != null) {
                return this.inputStream;
            }
            if (buffered) {
                this.inputStream = new BufferedInputStream(JaxrsHttpFacade.this.requestContext.getEntityStream());
                return this.inputStream;
            }
            return JaxrsHttpFacade.this.requestContext.getEntityStream();
        }

        public String getRemoteAddr() {
            return HostUtils.getIpAddress();
        }

        public void setError(AuthenticationError error) {
            JaxrsHttpFacade.this.requestContext.setProperty(AuthenticationError.class.getName(), (Object)error);
        }

        public void setError(LogoutError error) {
            JaxrsHttpFacade.this.requestContext.setProperty(LogoutError.class.getName(), (Object)error);
        }
    }
}

