/*
 * Decompiled with CFR 0.152.
 */
package de.ahus1.keycloak.dropwizard;

import de.ahus1.keycloak.dropwizard.KeycloakAuthFilter;
import de.ahus1.keycloak.dropwizard.KeycloakAuthenticator;
import de.ahus1.keycloak.dropwizard.KeycloakConfiguration;
import de.ahus1.keycloak.dropwizard.KeycloakDropwizardAuthenticator;
import de.ahus1.keycloak.dropwizard.User;
import de.ahus1.keycloak.dropwizard.UserAuthorizer;
import io.dropwizard.ConfiguredBundle;
import io.dropwizard.auth.AuthDynamicFeature;
import io.dropwizard.auth.AuthValueFactoryProvider;
import io.dropwizard.auth.Authorizer;
import io.dropwizard.jersey.sessions.HttpSessionFactory;
import io.dropwizard.setup.Bootstrap;
import io.dropwizard.setup.Environment;
import java.security.Principal;
import java.util.Locale;
import javax.ws.rs.container.ContainerRequestFilter;
import org.eclipse.jetty.security.Authenticator;
import org.eclipse.jetty.security.ConstraintSecurityHandler;
import org.eclipse.jetty.security.SecurityHandler;
import org.eclipse.jetty.server.session.SessionHandler;
import org.glassfish.jersey.server.filter.RolesAllowedDynamicFeature;
import org.keycloak.enums.TokenStore;

public abstract class KeycloakBundle<T>
implements ConfiguredBundle<T> {
    public void run(T configuration, Environment environment) {
        KeycloakDropwizardAuthenticator keycloak = new KeycloakDropwizardAuthenticator();
        keycloak.setAdapterConfig(this.getKeycloakConfiguration(configuration));
        ConstraintSecurityHandler securityHandler = new ConstraintSecurityHandler();
        environment.getApplicationContext().setSecurityHandler((SecurityHandler)securityHandler);
        environment.getApplicationContext().getSecurityHandler().setAuthenticator((Authenticator)keycloak);
        environment.jersey().register((Object)new AuthDynamicFeature(this.createAuthFactory(configuration)));
        environment.jersey().register(RolesAllowedDynamicFeature.class);
        environment.jersey().register((Object)new AuthValueFactoryProvider.Binder(this.getUserClass()));
        if (!(this.getKeycloakConfiguration(configuration).isBearerOnly() || this.getKeycloakConfiguration(configuration).getTokenStore() != null && this.getKeycloakConfiguration(configuration).getTokenStore().toLowerCase(Locale.ENGLISH).equals(TokenStore.COOKIE.toString().toLowerCase(Locale.ENGLISH)))) {
            environment.jersey().register(HttpSessionFactory.class);
            environment.servlets().setSessionHandler(new SessionHandler());
        }
    }

    protected ContainerRequestFilter createAuthFactory(T configuration) {
        return new KeycloakAuthFilter.Builder().setConfig(this.getKeycloakConfiguration(configuration)).setAuthenticator(this.createAuthenticator(this.getKeycloakConfiguration(configuration))).setAuthorizer(this.createAuthorizer()).setRealm(this.getRealm(configuration)).buildAuthFilter();
    }

    protected Class<? extends Principal> getUserClass() {
        return User.class;
    }

    protected Authorizer createAuthorizer() {
        return new UserAuthorizer();
    }

    protected io.dropwizard.auth.Authenticator createAuthenticator(KeycloakConfiguration configuration) {
        return new KeycloakAuthenticator(configuration);
    }

    protected String getRealm(T configuration) {
        return this.getKeycloakConfiguration(configuration).getRealm();
    }

    protected abstract KeycloakConfiguration getKeycloakConfiguration(T var1);

    public void initialize(Bootstrap<?> bootstrap) {
    }
}

