/*
 * Decompiled with CFR 0.152.
 */
package de.akquinet.jbosscc.needle;

import de.akquinet.jbosscc.needle.ObjectUnderTestInstantiationException;
import de.akquinet.jbosscc.needle.annotation.ObjectUnderTest;
import de.akquinet.jbosscc.needle.injection.InjectionAnnotationProcessor;
import de.akquinet.jbosscc.needle.injection.InjectionConfiguration;
import de.akquinet.jbosscc.needle.injection.InjectionProvider;
import de.akquinet.jbosscc.needle.injection.InjectionTargetInformation;
import de.akquinet.jbosscc.needle.mock.MockProvider;
import de.akquinet.jbosscc.needle.reflection.ReflectionUtil;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class NeedleTestcase {
    private static final Logger LOG = LoggerFactory.getLogger(NeedleTestcase.class);
    private static final InjectionAnnotationProcessor INJECTION_INTO_ANNOTATION_PROCESSOR = new InjectionAnnotationProcessor();
    private final List<InjectionProvider<?>> injectionProviderList = new ArrayList();
    private final InjectionConfiguration configuration = new InjectionConfiguration();
    private final Map<String, Object> objectUnderTestMap = new HashMap<String, Object>();
    private final Map<Object, Object> injectedObjectMap = new HashMap<Object, Object>();
    private final List<Collection<InjectionProvider<?>>> injectionProviders;

    protected NeedleTestcase(InjectionProvider<?> ... injectionProvider) {
        this.addInjectionProvider(injectionProvider);
        this.injectionProviders = Arrays.asList(this.injectionProviderList, this.configuration.getGlobalCustomInjectionProvider(), this.configuration.getInjectionProvider());
    }

    protected final void addInjectionProvider(InjectionProvider<?> ... injectionProvider) {
        for (InjectionProvider<?> provider : injectionProvider) {
            this.injectionProviderList.add(0, provider);
        }
    }

    protected final void initTestcase(Object test) throws Exception {
        LOG.info("init testcase {}", test);
        this.objectUnderTestMap.clear();
        this.injectedObjectMap.clear();
        List<Field> fields = ReflectionUtil.getAllFieldsWithAnnotation(test, ObjectUnderTest.class);
        LOG.debug("found fields {}", fields);
        for (Field field : fields) {
            LOG.debug("found field {}", (Object)field.getName());
            try {
                Object instance = this.setInstanceIfNotNull(field, test);
                this.initInstance(instance);
            }
            catch (InstantiationException e) {
                LOG.error(e.getMessage(), (Throwable)e);
            }
            catch (IllegalAccessException e) {
                LOG.error(e.getMessage(), (Throwable)e);
            }
        }
        INJECTION_INTO_ANNOTATION_PROCESSOR.process(test, Collections.unmodifiableMap(this.objectUnderTestMap));
    }

    protected final void initInstance(Object instance) {
        this.initFields(instance);
        this.initMethodInjection(instance);
    }

    private void initMethodInjection(Object instance) {
        List<Method> methods = ReflectionUtil.getMethods(instance.getClass());
        for (final Method method : methods) {
            Annotation[] annotations = method.getDeclaredAnnotations();
            if (!this.checkAnnotationIsSupported(annotations)) continue;
            Class<?>[] parameterTypes = method.getParameterTypes();
            InjectionTargetInformationFactory injectionTargetInformationFactory = new InjectionTargetInformationFactory(){

                @Override
                public InjectionTargetInformation create(Class<?> parameterType, int parameterIndex) {
                    return new InjectionTargetInformation(parameterType, method, method.getParameterAnnotations()[parameterIndex]);
                }
            };
            Object[] arguments = this.createArguments(parameterTypes, injectionTargetInformationFactory);
            try {
                ReflectionUtil.invokeMethod(method, instance, arguments);
            }
            catch (Exception e) {
                LOG.warn("could not invoke method", (Throwable)e);
            }
        }
    }

    private Object[] createArguments(Class<?>[] parameterTypes, InjectionTargetInformationFactory injectionTargetInformationFactory) {
        Object[] arguments = new Object[parameterTypes.length];
        block0: for (int i = 0; i < parameterTypes.length; ++i) {
            InjectionTargetInformation injectionTargetInformation = injectionTargetInformationFactory.create(parameterTypes[i], i);
            for (Collection<InjectionProvider<?>> collection : this.injectionProviders) {
                Object injection = this.handleInjectionProvider(collection, injectionTargetInformation);
                if (injection == null) continue;
                arguments[i] = injection;
                continue block0;
            }
        }
        return arguments;
    }

    private void initFields(Object instance) {
        List<Field> fields = ReflectionUtil.getAllFields(instance.getClass());
        block2: for (Field field : fields) {
            InjectionTargetInformation injectionTargetInformation = new InjectionTargetInformation(field.getType(), field);
            for (Collection<InjectionProvider<?>> collection : this.injectionProviders) {
                Object injection = this.handleInjectionProvider(collection, injectionTargetInformation);
                if (injection == null) continue;
                try {
                    ReflectionUtil.setField(field, instance, injection);
                }
                catch (Exception e) {
                    LOG.error(e.getMessage(), (Throwable)e);
                }
                continue block2;
            }
        }
    }

    private Object handleInjectionProvider(Collection<InjectionProvider<?>> injectionProviders, InjectionTargetInformation injectionTargetInformation) {
        for (InjectionProvider<?> provider : injectionProviders) {
            if (!provider.verify(injectionTargetInformation)) continue;
            Object object = provider.getInjectedObject(injectionTargetInformation.getType());
            this.injectedObjectMap.put(provider.getKey(injectionTargetInformation), object);
            return object;
        }
        return null;
    }

    private Object setInstanceIfNotNull(Field field, Object test) throws Exception {
        ObjectUnderTest objectUnderTestAnnotation = field.getAnnotation(ObjectUnderTest.class);
        String id = objectUnderTestAnnotation.id().equals("") ? field.getName() : objectUnderTestAnnotation.id();
        Object instance = ReflectionUtil.getFieldValue(test, field);
        if (instance == null) {
            Class<?> implementation;
            Class<?> clazz = implementation = objectUnderTestAnnotation.implementation() != Void.class ? objectUnderTestAnnotation.implementation() : field.getType();
            if (implementation.isInterface()) {
                throw new ObjectUnderTestInstantiationException("could not create an instance of object under test " + implementation + ", no implementation class configured");
            }
            instance = this.getInstanceByConstructorInjection(implementation);
            if (instance == null) {
                instance = this.createInstanceByNoArgConstructor(implementation);
            }
            try {
                ReflectionUtil.setField(field, test, instance);
            }
            catch (Exception e) {
                throw new ObjectUnderTestInstantiationException(e);
            }
        }
        this.objectUnderTestMap.put(id, instance);
        return instance;
    }

    private Object createInstanceByNoArgConstructor(Class<?> implementation) throws ObjectUnderTestInstantiationException {
        try {
            implementation.getConstructor(new Class[0]);
            return implementation.newInstance();
        }
        catch (NoSuchMethodException e) {
            throw new ObjectUnderTestInstantiationException("could not create an instance of object under test " + implementation + ",implementation has no public no-arguments constructor", e);
        }
        catch (InstantiationException e) {
            throw new ObjectUnderTestInstantiationException(e);
        }
        catch (IllegalAccessException e) {
            throw new ObjectUnderTestInstantiationException(e);
        }
    }

    private Object getInstanceByConstructorInjection(Class<?> implementation) throws ObjectUnderTestInstantiationException {
        Constructor<?>[] constructors;
        for (final Constructor<?> constructor : constructors = implementation.getConstructors()) {
            Annotation[] annotations = constructor.getAnnotations();
            if (!this.checkAnnotationIsSupported(annotations)) continue;
            Class<?>[] parameterTypes = constructor.getParameterTypes();
            InjectionTargetInformationFactory injectionTargetInformationFactory = new InjectionTargetInformationFactory(){

                @Override
                public InjectionTargetInformation create(Class<?> parameterType, int parameterIndex) {
                    return new InjectionTargetInformation(parameterType, constructor, constructor.getParameterAnnotations()[parameterIndex]);
                }
            };
            Object[] arguments = this.createArguments(parameterTypes, injectionTargetInformationFactory);
            try {
                return constructor.newInstance(arguments);
            }
            catch (Exception e) {
                throw new ObjectUnderTestInstantiationException(e);
            }
        }
        return null;
    }

    private boolean checkAnnotationIsSupported(Annotation[] annotations) {
        for (Annotation annotation : annotations) {
            if (!this.configuration.isAnnotationSupported(annotation.annotationType())) continue;
            return true;
        }
        return false;
    }

    public <X> X getInjectedObject(Object key) {
        return (X)this.injectedObjectMap.get(key);
    }

    public <X extends MockProvider> X getMockProvider() {
        return (X)this.configuration.getMockProvider();
    }

    private static interface InjectionTargetInformationFactory {
        public InjectionTargetInformation create(Class<?> var1, int var2);
    }
}

