/*
 * Decompiled with CFR 0.152.
 */
package de.akquinet.jbosscc.needle.db;

import de.akquinet.jbosscc.needle.db.DatabaseTestcaseConfiguration;
import de.akquinet.jbosscc.needle.db.EntityManagerFactoryProvider;
import de.akquinet.jbosscc.needle.db.EntityManagerProvider;
import de.akquinet.jbosscc.needle.db.operation.DBOperation;
import de.akquinet.jbosscc.needle.db.transaction.TransactionHelper;
import de.akquinet.jbosscc.needle.injection.InjectionProvider;
import de.akquinet.jbosscc.needle.injection.InjectionTargetInformation;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;

public class DatabaseTestcase
implements InjectionProvider<Object> {
    private final DatabaseTestcaseConfiguration configuration;
    private TransactionHelper transactionHelper;
    private DBOperation dbOperation;
    private EntityManagerProvider entityManagerProvider = new EntityManagerProvider(this);
    private EntityManagerFactoryProvider entityManagerFactoryProvider = new EntityManagerFactoryProvider(this);

    public DatabaseTestcase() {
        this.configuration = new DatabaseTestcaseConfiguration();
    }

    public DatabaseTestcase(DBOperation dbOperation) {
        this();
        this.dbOperation = dbOperation;
    }

    public DatabaseTestcase(String persistenceUnitName) {
        this.configuration = new DatabaseTestcaseConfiguration(persistenceUnitName);
    }

    public DatabaseTestcase(String persistenceUnitName, DBOperation dbOperation) {
        this(persistenceUnitName);
        this.dbOperation = dbOperation;
    }

    public DatabaseTestcase(Class<?> ... clazzes) {
        this.configuration = new DatabaseTestcaseConfiguration(clazzes);
    }

    public DatabaseTestcase(DBOperation dbOperation, Class<?> ... clazzes) {
        this(clazzes);
        this.dbOperation = dbOperation;
    }

    protected void after() throws Exception {
        DBOperation operation = this.getDBOperation();
        if (operation != null) {
            operation.tearDownOperation();
        }
    }

    protected void before() throws Exception {
        DBOperation operation = this.getDBOperation();
        if (operation != null) {
            operation.setUpOperation();
        }
    }

    private DBOperation getDBOperation() {
        return this.dbOperation != null ? this.dbOperation : this.configuration.getDBOperation();
    }

    public EntityManager getEntityManager() {
        return this.configuration.getEntityManager();
    }

    public EntityManagerFactory getEntityManagerFactory() {
        return this.configuration.getEntityManagerFactory();
    }

    public TransactionHelper getTransactionHelper() {
        if (this.transactionHelper == null) {
            this.transactionHelper = new TransactionHelper(this.getEntityManager());
        }
        return this.transactionHelper;
    }

    @Override
    public Object getInjectedObject(Class<?> injectionPointType) {
        return this.getInjectionProvider(injectionPointType).getInjectedObject(injectionPointType);
    }

    @Override
    public boolean verify(InjectionTargetInformation injectionTargetInformation) {
        return this.getInjectionProvider(injectionTargetInformation.getType()).verify(injectionTargetInformation);
    }

    @Override
    public Object getKey(InjectionTargetInformation injectionTargetInformation) {
        return this.getInjectionProvider(injectionTargetInformation.getType()).getKey(injectionTargetInformation);
    }

    private InjectionProvider<?> getInjectionProvider(Class<?> type) {
        return type == EntityManager.class ? this.entityManagerProvider : this.entityManagerFactoryProvider;
    }
}

