/*
 * Decompiled with CFR 0.152.
 */
package de.akquinet.jbosscc.needle.db.operation;

import de.akquinet.jbosscc.needle.configuration.ConfigurationLoader;
import de.akquinet.jbosscc.needle.db.operation.DBOperation;
import de.akquinet.jbosscc.needle.db.operation.JdbcConfiguration;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractDBOperation
implements DBOperation {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractDBOperation.class);
    private final JdbcConfiguration configuration;
    private Connection connection;

    public AbstractDBOperation(JdbcConfiguration jdbcConfiguration) {
        this.configuration = jdbcConfiguration;
    }

    protected void openConnection() throws SQLException {
        if (this.connection == null) {
            try {
                Class.forName(this.configuration.getJdbcDriver());
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException("jdbc driver not found", e);
            }
            this.connection = DriverManager.getConnection(this.configuration.getJdbcUrl(), this.configuration.getJdbcUser(), this.configuration.getJdbcPassword());
            this.connection.setAutoCommit(false);
        }
    }

    protected void closeConnection() throws SQLException {
        if (this.connection != null && !this.connection.isClosed()) {
            this.connection.close();
            this.connection = null;
        }
    }

    protected void commit() throws SQLException {
        if (this.connection != null) {
            this.connection.commit();
        }
    }

    protected void rollback() throws SQLException {
        if (this.connection != null) {
            this.connection.rollback();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<String> getTableNames(Connection connection) throws SQLException {
        ResultSet resultSet = null;
        try {
            ArrayList<String> tables = new ArrayList<String>();
            resultSet = connection.getMetaData().getTables(null, null, "%", new String[]{"TABLE"});
            while (resultSet.next()) {
                tables.add(resultSet.getString("TABLE_NAME"));
            }
            ArrayList<String> arrayList = tables;
            return arrayList;
        }
        finally {
            if (resultSet != null) {
                resultSet.close();
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Lifted jumps to return sites
     */
    private void executeScript(BufferedReader script, Statement statement) throws SQLException {
        long lineNo = 0L;
        StringBuffer sql = new StringBuffer();
        try {
            String line;
            block2: while ((line = script.readLine()) != null) {
                ++lineNo;
                String trimmedLine = line.trim();
                if (trimmedLine.length() == 0 || trimmedLine.startsWith("--") || trimmedLine.startsWith("//")) continue;
                if (trimmedLine.startsWith("/*")) {
                    do {
                        if ((line = script.readLine()) == null) continue block2;
                    } while (!line.endsWith("*/"));
                    LOG.debug("ignore " + line);
                    continue;
                }
                sql.append(trimmedLine);
                if (!trimmedLine.endsWith(";")) continue;
                String sqlStatement = sql.toString();
                sqlStatement = sqlStatement.substring(0, sqlStatement.length() - 1);
                LOG.info(sqlStatement);
                statement.execute(sqlStatement);
                sql = new StringBuffer();
            }
            return;
        }
        catch (Exception e) {
            throw new SQLException("Error during import script execution at line " + lineNo, e);
        }
    }

    protected void executeScript(String filename, Statement statement) throws SQLException {
        InputStream fileInputStream;
        LOG.info("Executing sql script: " + filename);
        try {
            fileInputStream = ConfigurationLoader.loadResource(filename);
        }
        catch (FileNotFoundException e) {
            LOG.error("could not execute script", (Throwable)e);
            return;
        }
        BufferedReader reader = new BufferedReader(new InputStreamReader(fileInputStream));
        this.executeScript(reader, statement);
    }

    protected Connection getConnection() throws SQLException {
        if (this.connection == null) {
            this.openConnection();
        }
        return this.connection;
    }
}

