/*
 * Decompiled with CFR 0.152.
 */
package de.akquinet.jbosscc.needle.db.transaction;

import de.akquinet.jbosscc.needle.db.transaction.Runnable;
import java.util.List;
import javax.persistence.EntityManager;

public class TransactionHelper {
    private final EntityManager entityManager;

    public TransactionHelper(EntityManager manager) {
        this.entityManager = manager;
    }

    public final <T> T saveObject(final T obj) throws Exception {
        return this.executeInTransaction(new Runnable<T>(){

            @Override
            public T run(EntityManager entityManager) {
                return TransactionHelper.this.persist(obj, entityManager);
            }
        });
    }

    public final <T> T loadObject(final Class<T> clazz, final Object id) throws Exception {
        return this.executeInTransaction(new Runnable<T>(){

            @Override
            public T run(EntityManager entityManager) {
                return TransactionHelper.this.loadObject(entityManager, clazz, id);
            }
        });
    }

    public final <T> List<T> loadAllObjects(final Class<T> clazz) throws Exception {
        return (List)this.executeInTransaction(new Runnable<List<T>>(){

            @Override
            public List<T> run(EntityManager entityManager) {
                return entityManager.createQuery("FROM " + clazz.getSimpleName()).getResultList();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final <T> T executeInTransaction(Runnable<T> runnable, boolean clearAfterCommit) throws Exception {
        T result;
        try {
            this.entityManager.getTransaction().begin();
            result = runnable.run(this.entityManager);
            this.entityManager.flush();
            this.entityManager.getTransaction().commit();
            if (clearAfterCommit) {
                this.entityManager.clear();
            }
        }
        finally {
            if (this.entityManager.getTransaction().isActive()) {
                this.entityManager.getTransaction().rollback();
            }
        }
        return result;
    }

    public final <T> T executeInTransaction(Runnable<T> runnable) throws Exception {
        return this.executeInTransaction(runnable, true);
    }

    public final EntityManager getEntityManager() {
        return this.entityManager;
    }

    public <T> T persist(T obj, EntityManager entityManager) {
        entityManager.persist(obj);
        return obj;
    }

    public <T> T persist(T obj) {
        return this.persist(obj, this.entityManager);
    }

    public <T> T loadObject(EntityManager entityManager, Class<T> clazz, Object id) {
        return (T)entityManager.find(clazz, id);
    }
}

