/*
 * Decompiled with CFR 0.152.
 */
package de.akquinet.jbosscc.needle.injection;

import de.akquinet.jbosscc.needle.annotation.InjectInto;
import de.akquinet.jbosscc.needle.annotation.InjectIntoMany;
import de.akquinet.jbosscc.needle.reflection.ReflectionUtil;
import java.lang.reflect.Field;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InjectionAnnotationProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(InjectionAnnotationProcessor.class);

    public void process(Object testcase, Map<String, Object> objectUnderTestMap) {
        this.proccessInjectIntoMany(testcase, objectUnderTestMap);
        this.proccessInjectInto(testcase, objectUnderTestMap);
    }

    private void proccessInjectIntoMany(Object testcase, Map<String, Object> objectUnderTestMap) {
        List<Field> fieldsWithInjectIntoManyAnnotation = ReflectionUtil.getAllFieldsWithAnnotation(testcase, InjectIntoMany.class);
        for (Field field : fieldsWithInjectIntoManyAnnotation) {
            Object sourceObject = ReflectionUtil.getFieldValue(testcase, field);
            InjectIntoMany injectIntoManyAnnotation = field.getAnnotation(InjectIntoMany.class);
            InjectInto[] value = injectIntoManyAnnotation.value();
            if (value.length == 0) {
                for (Map.Entry<String, Object> entry : objectUnderTestMap.entrySet()) {
                    this.injectByType(entry.getValue(), sourceObject, field.getType());
                }
                continue;
            }
            for (InjectInto injectInto : value) {
                this.processInjectInto(objectUnderTestMap, field, sourceObject, injectInto);
            }
        }
    }

    private void proccessInjectInto(Object testcase, Map<String, Object> objectUnderTestMap) {
        List<Field> fields = ReflectionUtil.getAllFieldsWithAnnotation(testcase, InjectInto.class);
        for (Field field : fields) {
            Object sourceObject = ReflectionUtil.getFieldValue(testcase, field);
            this.processInjectInto(objectUnderTestMap, field, sourceObject, field.getAnnotation(InjectInto.class));
        }
    }

    private void processInjectInto(Map<String, Object> objectUnderTestMap, Field field, Object sourceObject, InjectInto injectInto) {
        Object object = objectUnderTestMap.get(injectInto.targetComponentId());
        if (object != null) {
            if (injectInto.fieldName().equals("")) {
                this.injectByType(object, sourceObject, field.getType());
            } else {
                this.injectByFieldName(object, sourceObject, injectInto.fieldName());
            }
        } else {
            LOG.warn("could not inject component {} -  unknown object under test with id {}", sourceObject, (Object)injectInto.targetComponentId());
        }
    }

    private void injectByType(Object objectUnderTest, Object sourceObject, Class<?> type) {
        List<Field> fields = ReflectionUtil.getAllFieldsAssinableFrom(type, objectUnderTest.getClass());
        for (Field field : fields) {
            try {
                ReflectionUtil.setField(field, objectUnderTest, sourceObject);
            }
            catch (Exception e) {
                LOG.warn("could not inject into component " + objectUnderTest, (Throwable)e);
            }
        }
    }

    private void injectByFieldName(Object objectUnderTest, Object sourceObject, String fieldName) {
        try {
            ReflectionUtil.setField(fieldName, objectUnderTest, sourceObject);
        }
        catch (Exception e) {
            LOG.warn("could not inject into component " + objectUnderTest, (Throwable)e);
        }
    }
}

