/*
 * Decompiled with CFR 0.152.
 */
package de.akquinet.jbosscc.needle.mock;

import de.akquinet.jbosscc.needle.mock.MockProvider;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;
import org.easymock.EasyMock;
import org.easymock.EasyMockSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EasyMockProvider
extends EasyMockSupport
implements MockProvider {
    private static final Logger LOG = LoggerFactory.getLogger(EasyMockProvider.class);
    private Map<Class<?>, Object> mocks = new HashMap();

    @Override
    public <T> T createMockComponent(Class<T> type) {
        if (this.mocks.containsKey(type)) {
            Object mock = this.mocks.get(type);
            this.resetToNice(mock);
            return (T)mock;
        }
        if (Modifier.isFinal(type.getModifiers()) || type.isPrimitive()) {
            LOG.warn("Skipping creation of a mock : {} as it is final or primitive type.", (Object)type.getSimpleName());
            return null;
        }
        Object mock = this.createNiceMock(type);
        this.mocks.put(type, mock);
        return (T)mock;
    }

    public void resetToNice(Object ... mocks) {
        EasyMock.resetToNice((Object[])mocks);
    }

    public <X> X resetToNice(Object mock) {
        EasyMock.resetToNice((Object[])new Object[]{mock});
        return (X)mock;
    }

    public void resetToStrict(Object ... mocks) {
        EasyMock.resetToStrict((Object[])mocks);
    }

    public <X> X resetToStrict(Object mock) {
        EasyMock.resetToStrict((Object[])new Object[]{mock});
        return (X)mock;
    }

    public void resetToDefault(Object ... mocks) {
        EasyMock.resetToDefault((Object[])mocks);
    }

    public <X> X resetToDefault(Object mock) {
        EasyMock.resetToDefault((Object[])new Object[]{mock});
        return (X)mock;
    }
}

