/*
 * Decompiled with CFR 0.152.
 */
package de.akquinet.jbosscc.needle.configuration;

import de.akquinet.jbosscc.needle.configuration.NeedleConfiguration;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ConfigurationLoader {
    private static final Logger LOG = LoggerFactory.getLogger(ConfigurationLoader.class);
    private final Map<String, String> configProperties = this.loadResourceAndDefault("needle");
    private static final String DEFAULT_CONFIGURATION_FILENAME = "needle-defaults";

    ConfigurationLoader() {
    }

    String getProperty(String key) {
        return this.configProperties.get(key);
    }

    boolean containsKey(String key) {
        return this.configProperties.containsKey(key);
    }

    Map<String, String> loadResourceAndDefault(String name) {
        URL url;
        String key;
        Enumeration<String> keys;
        HashMap<String, String> result = new HashMap<String, String>();
        try {
            ResourceBundle customBundle = this.loadResourceBundle(name);
            keys = customBundle.getKeys();
            while (keys.hasMoreElements()) {
                key = keys.nextElement();
                this.addKeyValuePair(result, key, customBundle.getString(key));
            }
            url = NeedleConfiguration.class.getResource("/" + name + ".properties");
            LOG.info("loaded Needle config named {} from {}", (Object)name, (Object)url);
        }
        catch (Exception e) {
            LOG.debug("found no custom configuration");
        }
        try {
            ResourceBundle defaultResourceBundle = this.loadResourceBundle(DEFAULT_CONFIGURATION_FILENAME);
            keys = defaultResourceBundle.getKeys();
            while (keys.hasMoreElements()) {
                key = keys.nextElement();
                if (result.containsKey(key)) continue;
                this.addKeyValuePair(result, key, defaultResourceBundle.getString(key));
            }
            url = NeedleConfiguration.class.getResource("/needle-defaults.properties");
            LOG.debug("loaded default Needle config from: {}", (Object)url);
        }
        catch (Exception e1) {
            LOG.error("should never happen", (Throwable)e1);
            throw new RuntimeException("should never happen", e1);
        }
        return result;
    }

    private void addKeyValuePair(Map<String, String> target, String key, String value) {
        String trimmedValue = value.trim();
        if (!trimmedValue.equals(value)) {
            LOG.warn("trimmed value " + value + " to " + trimmedValue + " (key was " + key + ")");
        }
        target.put(key, trimmedValue);
    }

    private ResourceBundle loadResourceBundle(String name) {
        return ResourceBundle.getBundle(name);
    }

    public static InputStream loadResource(String resource) throws FileNotFoundException {
        boolean hasLeadingSlash = resource.startsWith("/");
        String stripped = hasLeadingSlash ? resource.substring(1) : resource;
        InputStream stream = null;
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader != null && (stream = classLoader.getResourceAsStream(resource)) == null && hasLeadingSlash) {
            stream = classLoader.getResourceAsStream(stripped);
        }
        if (stream == null) {
            throw new FileNotFoundException("resource " + resource + " not found");
        }
        return stream;
    }
}

