/*
 * Decompiled with CFR 0.152.
 */
package de.akquinet.jbosscc.needle.configuration;

import de.akquinet.jbosscc.needle.configuration.ConfigurationLoader;
import de.akquinet.jbosscc.needle.injection.InjectionProvider;
import de.akquinet.jbosscc.needle.reflection.ReflectionUtil;
import java.lang.annotation.Annotation;
import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class NeedleConfiguration {
    private static final Logger LOG = LoggerFactory.getLogger(NeedleConfiguration.class);
    private static final ConfigurationLoader CONFIGURATION_LOADER = new ConfigurationLoader();
    static final String JDBC_URL_KEY = "jdbc.url";
    static final String JDBC_DRIVER_KEY = "jdbc.driver";
    static final String JDBC_USER_KEY = "jdbc.user";
    static final String JDBC_PASSWORD_KEY = "jdbc.password";
    static final String DB_OPERATION_KEY = "db.operation";
    static final String PERSISTENCEUNIT_NAME_KEY = "persistenceUnit.name";
    static final String MOCK_PROVIDER_KEY = "mock.provider";
    static final String HIBERNATE_CFG_FILENAME_KEY = "hibernate.cfg.filename";
    static final String CUSTOM_INJECTION_ANNOTATIONS_KEY = "custom.injection.annotations";
    static final Set<Class<Annotation>> CUSTOM_INJECTION_ANNOTATIONS = NeedleConfiguration.lookupClasses("custom.injection.annotations");
    static final String CUSTOM_INJECTION_PROVIDER_CLASSES_KEY = "custom.injection.provider.classes";
    static final Set<Class<InjectionProvider<?>>> CUSTOM_INJECTION_PROVIDER_CLASSES = NeedleConfiguration.lookupClasses("custom.injection.provider.classes");
    static final String JDBC_URL = CONFIGURATION_LOADER.getProperty("jdbc.url");
    static final String JDBC_DRIVER = CONFIGURATION_LOADER.getProperty("jdbc.driver");
    static final String JDBC_USER = CONFIGURATION_LOADER.getProperty("jdbc.user");
    static final String JDBC_PASSWORD = CONFIGURATION_LOADER.getProperty("jdbc.password");
    static final String DB_OPERATION_CLASS_NAME = CONFIGURATION_LOADER.getProperty("db.operation");
    static final String MOCK_PROVIDER_CLASS_NAME = CONFIGURATION_LOADER.getProperty("mock.provider");

    private NeedleConfiguration() {
    }

    public static String getPersistenceunitName() {
        return CONFIGURATION_LOADER.getProperty(PERSISTENCEUNIT_NAME_KEY);
    }

    public static String getHibernateCfgFilename() {
        return CONFIGURATION_LOADER.getProperty(HIBERNATE_CFG_FILENAME_KEY);
    }

    public static String getDBOperationClassName() {
        return DB_OPERATION_CLASS_NAME;
    }

    public static String getJdbcUrl() {
        return JDBC_URL;
    }

    public static String getJdbcDriver() {
        return JDBC_DRIVER;
    }

    public static String getJdbcUser() {
        return JDBC_USER;
    }

    public static String getJdbcPassword() {
        return JDBC_PASSWORD;
    }

    public static String getMockProviderClassName() {
        return MOCK_PROVIDER_CLASS_NAME;
    }

    public static Set<Class<Annotation>> getCustomInjectionAnnotations() {
        return CUSTOM_INJECTION_ANNOTATIONS;
    }

    public static Set<Class<InjectionProvider<?>>> getCustomInjectionProviderClasses() {
        return CUSTOM_INJECTION_PROVIDER_CLASSES;
    }

    private static <T> Set<Class<T>> lookupClasses(String key) {
        String classesList = CONFIGURATION_LOADER.containsKey(key) ? CONFIGURATION_LOADER.getProperty(key) : "";
        HashSet<Class<T>> result = new HashSet<Class<T>>();
        StringTokenizer tokenizer = new StringTokenizer(classesList, ",");
        String token = null;
        while (tokenizer.hasMoreElements()) {
            try {
                token = tokenizer.nextToken();
                Class<?> clazz = ReflectionUtil.forName(token);
                if (clazz != null) {
                    result.add(clazz);
                    continue;
                }
                LOG.warn("could not load class {}", (Object)token);
            }
            catch (Exception e) {
                LOG.warn("could not load class " + token, (Throwable)e);
            }
        }
        return result;
    }

    static {
        StringBuilder builder = new StringBuilder();
        builder.append("\nPU_NAME=").append(NeedleConfiguration.getPersistenceunitName());
        builder.append("\nCFG_FILE=").append(NeedleConfiguration.getHibernateCfgFilename());
        builder.append("\nDB_OPERATION=").append(NeedleConfiguration.getDBOperationClassName());
        builder.append("\nMOCK_PROVIDER=").append(NeedleConfiguration.getMockProviderClassName());
        LOG.info("Needle Configuration: {}", (Object)builder.toString());
    }
}

